<?php

$path_to_root_ = dirname(dirname(dirname(dirname(__FILE__))));
include_once($path_to_root_.'/modules/ExtendedHRM/includes/Payroll.inc');

define('RC_EMPLOYEES', 12);
define('RC_ALLOWANCES', 13);
global $reports;

$reports->addReportClass(_("Payroll & HRM"), RC_EMPLOYEES);
$reports->addReportClass(_("Allowances"), RC_ALLOWANCES);
$reports->register_controls('HRM_Reports');

function HRM_Reports($name, $type){
    switch($type){

        case  'DEPARTMENTS' :
            return department_list($name, null, true, false,false,false,true,false);
        case 'KV_TRANS_YEARS':
            return kv_fiscalyears_list($name, null, true);
        case 'KV_EMPLOYEES':
             return employee_list($name);
                
        case 'KV_INACTIVE_EMPLOYEES':
             return employee_list($name, null,false, false, false, false, false, false, true);
                
        case 'KV_ALL_EMPLOYEES' :
            return employee_list( $name, null,	false, true, false, false, false,true);
                
        case 'KV_PDF_STATEMENT':
            return banksmt_esic_pf_list($name);

         case 'MONTHS':
            return kv_current_fiscal_months($name, null, false, false, 1);
    }
 }
             
$reports->addReport(RC_EMPLOYEES, "801", _("Employees"),	
    [	_("Department") => 'DEPARTMENTS',			
    _("Comments") => 'TEXTBOX',
    _("Orientation") => 'ORIENTATION',
    _("Destination") => 'DESTINATION' ]);

$reports->addReport(RC_EMPLOYEES, 802, _("Payslip"),
	array(	_("Year") => 'KV_TRANS_YEARS',
			_("Months") => 'MONTHS',
			_("Employee") => 'KV_EMPLOYEES',
			_("Comments") => 'TEXTBOX',
			_("E-mail")  => 'YES_NO'));
$reports->addReport(RC_EMPLOYEES, 809, _("Bulk Payslips"),
	array(	_("Year") => 'KV_TRANS_YEARS',
			_("Months") => 'MONTHS',			
			_("Department") => 'DEPARTMENTS',
			_("Comments") => 'TEXTBOX') );
$reports->addReport(RC_EMPLOYEES, 803, _("Payroll History"),
	array(	_("Year") => 'KV_TRANS_YEARS',
			_("Months") => 'MONTHS',
			_("Department") => 'DEPARTMENTS',
			_("Comments") => 'TEXTBOX',
			_("Destination") => 'DESTINATION'));

$reports->addReport(RC_EMPLOYEES, 804, _("Attendance"),
	array(	_("Year") => 'KV_TRANS_YEARS',
			_("Months") => 'MONTHS',
			_("Department") => 'DEPARTMENTS',	
			_("Comments") => 'TEXTBOX',
			_("Destination") => 'DESTINATION'));

$reports->addReport(RC_EMPLOYEES, 805, _("Loan"),
	array(	_("Employee") => 'KV_EMPLOYEES',	
			_("Comments") => 'TEXTBOX',
			_("Destination") => 'DESTINATION'));

$reports->addReport(RC_EMPLOYEES, 806, _("Monthly Summary"),
	array(	_("Year") => 'KV_TRANS_YEARS',
			_("Months") => 'MONTHS',	
			_("Result") => 'KV_PDF_STATEMENT',
			_("Comments") => 'TEXTBOX',
			_("Destination") => 'DESTINATION'));

$reports->addReport(RC_EMPLOYEES, 808, _("Annual Summary"),
	array(	_("Year") => 'KV_TRANS_YEARS',
			_("Result") => 'KV_PDF_STATEMENT',
			_("Comments") => 'TEXTBOX',
			_("Destination") => 'DESTINATION'));
			
$reports->addReport(RC_EMPLOYEES, 811, _("Leave Encashment"),
	array(	_("Employee") => 'KV_EMPLOYEES',		
			_("Year") => 'KV_TRANS_YEARS',
			_("Comments") => 'TEXTBOX'));
$reports->addReport(RC_EMPLOYEES, 812, _("Employee Details"),
	array(	_("Year") => 'KV_TRANS_YEARS',
			_("Employee") => 'KV_ALL_EMPLOYEES'));
			
$reports->addReport(RC_EMPLOYEES, 813, _("End of Service"),
	array(	_("Employee") => 'KV_INACTIVE_EMPLOYEES',		
			/*_("Orientation") => 'ORIENTATION',*/
			_("Comments") => 'TEXTBOX',
			_("Destination") => 'DESTINATION'));

$reports->addReport(RC_EMPLOYEES, 814, _("Attendance And Payroll"),
	array(	_("Year") => 'KV_TRANS_YEARS',
			_("Months") => 'MONTHS',
			_("Department") => 'DEPARTMENTS',	
			_("Comments") => 'TEXTBOX'));
$reports->addReport(RC_EMPLOYEES, 8044 , _("Attendance Time"),
	array(	_("Year") => 'KV_TRANS_YEARS',
			_("Months") => 'MONTHS',
			_("Department") => 'DEPARTMENTS',	
			_("Comments") => 'TEXTBOX',
			_("Destination") => 'DESTINATION'));
            
/*
$reports->addReport(RC_EMPLOYEES, 815, _("HR Salary Reports"),
	array(	_("Year") => 'KV_TRANS_YEARS',
			_("Months") => 'MONTHS',
			_("Department") => 'DEPARTMENTS',	
			_("Comments") => 'TEXTBOX',
			_("Destination") => 'DESTINATION'));
*/
/*
$result = get_allowances();	

while ($myrow = db_fetch($result)) {	
	if($myrow['Tax'] != 1) {
		$reports->addReport(RC_ALLOWANCES, 807, _($myrow['description']),
		array(	_("Year") => 'KV_TRANS_YEARS',
			_("Months") => 'MONTHS',			
			_("Comments") => 'TEXTBOX'));		
	}
}		*/