# MySQL dump of database 'digihzdv_grace_hrm' on host 'localhost'
# Backup Date and Time: 2022-10-04 17:48
# Built by digitleysystem 2.4.11
# http://digitleysystem
# Company: Digitley System
# User: Administrator

# Compatibility: 2.4.1

# Comment:
# september attendane dat file import


SET NAMES latin1;


### Structure of table `0_areas` ###

DROP TABLE IF EXISTS `0_areas`;

CREATE TABLE `0_areas` (
  `area_code` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`area_code`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_areas` ###

INSERT INTO `0_areas` VALUES
('1', 'Global', '0');

### Structure of table `0_attachments` ###

DROP TABLE IF EXISTS `0_attachments`;

CREATE TABLE `0_attachments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_no` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `unique_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `filename` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_no` (`type_no`,`trans_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_attachments` ###


### Structure of table `0_audit_trail` ###

DROP TABLE IF EXISTS `0_audit_trail`;

CREATE TABLE `0_audit_trail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `user` smallint(6) unsigned NOT NULL DEFAULT 0,
  `stamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fiscal_year` int(11) NOT NULL DEFAULT 0,
  `gl_date` date NOT NULL DEFAULT '0000-00-00',
  `gl_seq` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Seq` (`fiscal_year`,`gl_date`,`gl_seq`),
  KEY `Type_and_Number` (`type`,`trans_no`)
) ENGINE=InnoDB AUTO_INCREMENT=150 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_audit_trail` ###

INSERT INTO `0_audit_trail` VALUES
('1', '30', '1', '4', '2022-05-11 05:30:55', NULL, '3', '2022-05-11', '0'),
('2', '18', '1', '3', '2022-05-11 07:04:33', NULL, '3', '2022-05-11', '0'),
('3', '1', '1', '4', '2022-05-11 08:02:35', NULL, '3', '2022-05-11', '0'),
('4', '18', '2', '4', '2022-05-11 15:54:46', NULL, '3', '2022-05-11', '0'),
('5', '25', '1', '4', '2022-05-11 15:57:15', NULL, '3', '2022-05-11', '0'),
('6', '20', '1', '4', '2022-05-11 15:58:18', NULL, '3', '2022-05-11', '0'),
('7', '22', '1', '4', '2022-05-11 16:09:25', NULL, '3', '2022-05-11', '0'),
('8', '30', '2', '4', '2022-05-11 16:15:17', NULL, '3', '2022-05-11', '0'),
('9', '13', '1', '4', '2022-05-11 16:16:38', NULL, '3', '2022-05-11', '0'),
('10', '12', '1', '4', '2022-05-11 16:19:23', NULL, '3', '2022-05-11', '0'),
('11', '30', '3', '4', '2022-05-16 07:18:59', NULL, '3', '2022-05-16', '0'),
('12', '18', '3', '4', '2022-05-17 14:45:03', NULL, '3', '2022-05-17', '0'),
('13', '25', '2', '4', '2022-05-17 14:45:03', NULL, '3', '2022-05-17', '0'),
('14', '20', '2', '4', '2022-05-17 14:45:03', NULL, '3', '2022-05-17', '0'),
('15', '18', '4', '4', '2022-05-17 14:48:07', NULL, '3', '2022-05-17', '0'),
('16', '25', '3', '4', '2022-05-17 14:48:07', NULL, '3', '2022-05-17', '0'),
('17', '20', '3', '4', '2022-05-17 14:48:07', NULL, '3', '2022-05-17', '0'),
('18', '18', '5', '4', '2022-05-17 14:48:54', NULL, '3', '2022-05-17', '0'),
('19', '25', '4', '4', '2022-05-17 14:48:54', NULL, '3', '2022-05-17', '0'),
('20', '20', '4', '4', '2022-05-17 14:48:54', NULL, '3', '2022-05-17', '0'),
('21', '18', '6', '4', '2022-05-17 14:49:35', NULL, '3', '2022-05-17', '0'),
('22', '25', '5', '4', '2022-05-17 14:49:35', NULL, '3', '2022-05-17', '0'),
('23', '20', '5', '4', '2022-05-17 14:49:35', NULL, '3', '2022-05-17', '0'),
('24', '18', '7', '4', '2022-05-17 14:50:36', NULL, '3', '2022-05-17', '0'),
('25', '25', '6', '4', '2022-05-17 14:50:36', NULL, '3', '2022-05-17', '0'),
('26', '20', '6', '4', '2022-05-17 14:50:36', NULL, '3', '2022-05-17', '0'),
('27', '26', '1', '4', '2022-05-17 14:50:43', NULL, '3', '2022-05-17', NULL),
('28', '26', '1', '4', '2022-05-17 14:50:43', 'Released.', '3', '2022-05-17', '0'),
('29', '0', '1', '4', '2022-05-17 14:50:43', NULL, '3', '2022-05-17', '0'),
('30', '0', '2', '4', '2022-05-17 14:50:43', NULL, '3', '2022-05-17', '0'),
('31', '29', '1', '4', '2022-05-17 14:50:44', 'Production.', '3', '2022-05-17', '0'),
('32', '18', '8', '4', '2022-05-18 06:18:22', NULL, '3', '2022-05-18', '0'),
('33', '18', '9', '4', '2022-05-19 07:19:22', NULL, '3', '2022-05-19', '0'),
('34', '25', '7', '4', '2022-05-19 07:19:22', NULL, '3', '2022-05-19', '0'),
('35', '26', '2', '4', '2022-05-20 03:41:52', NULL, '3', '2022-05-20', NULL),
('36', '26', '2', '4', '2022-05-20 03:41:52', 'Released.', '3', '2022-05-20', '0'),
('37', '18', '10', '4', '2022-05-20 03:47:55', NULL, '3', '2022-05-20', '0'),
('38', '25', '8', '4', '2022-05-20 03:47:55', NULL, '3', '2022-05-20', '0'),
('39', '20', '7', '4', '2022-05-20 03:47:55', NULL, '3', '2022-05-20', '0'),
('40', '22', '2', '4', '2022-05-20 03:48:18', NULL, '3', '2022-05-20', '0'),
('41', '18', '11', '4', '2022-05-20 03:49:06', NULL, '3', '2022-05-20', '0'),
('42', '25', '9', '4', '2022-05-20 03:49:06', NULL, '3', '2022-05-20', '0'),
('43', '20', '8', '4', '2022-05-20 03:49:06', NULL, '3', '2022-05-20', '0'),
('44', '28', '1', '4', '2022-05-20 03:49:19', NULL, '3', '2022-05-20', '0'),
('45', '28', '2', '4', '2022-05-20 03:50:31', NULL, '3', '2022-05-20', '0'),
('46', '29', '2', '4', '2022-05-20 03:51:16', 'Production.', '3', '2022-05-20', '0'),
('47', '26', '3', '1', '2022-05-20 04:07:28', NULL, '3', '2022-05-20', NULL),
('48', '26', '3', '1', '2022-05-20 04:07:28', 'Released.', '3', '2022-05-20', '0'),
('49', '17', '1', '1', '2022-05-20 04:12:09', NULL, '3', '2022-05-20', '0'),
('50', '28', '3', '1', '2022-05-20 04:14:14', NULL, '3', '2022-05-20', '0'),
('51', '0', '3', '1', '2022-05-20 04:14:35', NULL, '3', '2022-05-20', '0'),
('52', '28', '4', '1', '2022-05-20 04:15:15', NULL, '3', '2022-05-20', '0'),
('53', '0', '4', '1', '2022-05-20 04:15:41', NULL, '3', '2022-05-20', '0'),
('54', '29', '3', '1', '2022-05-20 04:16:21', 'Production.', '3', '2022-05-20', '0'),
('55', '18', '12', '4', '2022-05-20 06:47:21', NULL, '3', '2022-05-20', '0'),
('56', '30', '4', '4', '2022-05-28 08:14:53', NULL, '3', '2022-05-20', NULL),
('57', '18', '13', '4', '2022-05-20 07:08:37', NULL, '3', '2022-05-20', '0'),
('58', '25', '10', '4', '2022-05-20 07:11:12', NULL, '3', '2022-05-20', '0'),
('59', '20', '9', '4', '2022-05-20 07:13:54', NULL, '3', '2022-05-20', '0'),
('60', '22', '3', '4', '2022-05-20 07:20:01', NULL, '3', '2022-05-20', '0'),
('61', '30', '5', '4', '2022-05-20 07:24:54', NULL, '3', '2022-05-20', '0'),
('62', '13', '2', '4', '2022-05-20 07:28:06', NULL, '3', '2022-05-20', '0'),
('63', '26', '4', '4', '2022-05-20 07:51:28', NULL, '3', '2022-05-20', NULL),
('64', '26', '4', '4', '2022-05-20 07:51:28', 'Released.', '3', '2022-05-20', '0'),
('65', '0', '5', '4', '2022-05-20 07:51:28', NULL, '3', '2022-05-20', '0'),
('66', '0', '6', '4', '2022-05-20 07:51:28', NULL, '3', '2022-05-20', '0'),
('67', '29', '4', '4', '2022-05-20 07:51:28', 'Production.', '3', '2022-05-20', '0'),
('68', '18', '14', '4', '2022-05-20 09:23:39', NULL, '3', '2022-05-20', '0'),
('69', '25', '11', '4', '2022-05-20 09:23:39', NULL, '3', '2022-05-20', '0'),
('70', '20', '10', '4', '2022-05-20 09:23:39', NULL, '3', '2022-05-20', '0'),
('71', '22', '4', '4', '2022-05-20 09:27:11', NULL, '3', '2022-05-20', '0'),
('72', '30', '6', '4', '2022-05-20 09:29:56', NULL, '3', '2022-05-20', '0'),
('73', '13', '3', '4', '2022-05-20 09:29:56', NULL, '3', '2022-05-20', '0'),
('74', '10', '1', '4', '2022-05-20 09:29:56', NULL, '3', '2022-05-20', '0'),
('75', '12', '2', '4', '2022-05-20 09:29:56', NULL, '3', '2022-05-20', '0'),
('76', '18', '17', '4', '2022-05-22 07:16:51', NULL, '3', '2022-05-22', '0'),
('77', '18', '18', '4', '2022-05-22 07:24:01', NULL, '3', '2022-05-22', '0'),
('78', '25', '12', '4', '2022-05-22 07:30:04', NULL, '3', '2022-05-22', '0'),
('79', '20', '11', '4', '2022-05-22 07:31:11', NULL, '3', '2022-05-22', '0'),
('80', '22', '5', '4', '2022-05-22 07:33:21', NULL, '3', '2022-05-22', '0'),
('81', '25', '13', '4', '2022-05-22 07:37:10', NULL, '3', '2022-05-22', '0'),
('82', '20', '12', '4', '2022-05-22 07:39:42', NULL, '3', '2022-05-22', '0'),
('83', '30', '4', '4', '2022-05-28 08:14:53', 'Updated.', '3', '2022-05-20', '0'),
('84', '18', '21', '4', '2022-06-01 02:21:27', NULL, '3', '2022-06-01', '0'),
('85', '18', '22', '4', '2022-06-02 06:57:35', NULL, '3', '2022-06-02', '0'),
('86', '25', '14', '4', '2022-06-02 06:58:19', NULL, '3', '2022-06-02', '0'),
('87', '18', '23', '4', '2022-06-03 11:36:07', NULL, '3', '2022-06-03', '0'),
('88', '25', '15', '4', '2022-06-03 11:37:04', NULL, '3', '2022-06-03', '0'),
('89', '18', '24', '3', '2022-06-06 03:29:39', NULL, '3', '2022-06-06', '0'),
('90', '25', '16', '3', '2022-06-06 03:31:10', NULL, '3', '2022-06-06', '0'),
('91', '30', '7', '3', '2022-06-08 08:41:55', NULL, '3', '2022-06-08', '0'),
('92', '30', '8', '3', '2022-06-08 08:46:40', NULL, '3', '2022-06-08', '0'),
('93', '13', '4', '3', '2022-06-08 08:46:40', NULL, '3', '2022-06-08', '0'),
('94', '10', '2', '3', '2022-06-08 08:46:40', NULL, '3', '2022-06-08', '0'),
('95', '12', '3', '3', '2022-06-08 08:46:40', NULL, '3', '2022-06-08', '0'),
('96', '30', '9', '4', '2022-06-08 08:56:22', NULL, '3', '2022-06-08', '0'),
('97', '13', '5', '4', '2022-06-08 08:56:22', NULL, '3', '2022-06-08', '0'),
('98', '10', '3', '4', '2022-06-08 08:56:22', NULL, '3', '2022-06-08', '0'),
('99', '30', '10', '4', '2022-06-08 08:58:38', NULL, '3', '2022-06-08', '0'),
('100', '13', '6', '4', '2022-06-08 08:58:38', NULL, '3', '2022-06-08', '0'),
('101', '10', '4', '4', '2022-06-08 08:58:38', NULL, '3', '2022-06-08', '0'),
('102', '18', '25', '4', '2022-06-09 08:33:54', NULL, '3', '2022-06-09', '0'),
('103', '18', '26', '4', '2022-06-09 08:35:52', NULL, '3', '2022-06-09', '0'),
('104', '25', '17', '4', '2022-06-09 08:35:52', NULL, '3', '2022-06-09', '0'),
('105', '32', '1', '4', '2022-06-09 08:39:05', NULL, '3', '2022-06-09', '0'),
('106', '30', '11', '4', '2022-06-09 08:40:48', NULL, '3', '2022-06-09', '0'),
('107', '13', '7', '4', '2022-06-09 08:40:48', NULL, '3', '2022-06-09', '0'),
('108', '10', '5', '4', '2022-06-09 08:40:48', NULL, '3', '2022-06-09', '0'),
('109', '12', '4', '4', '2022-06-09 08:40:48', NULL, '3', '2022-06-09', '0'),
('110', '12', '5', '4', '2022-06-09 08:43:18', NULL, '3', '2022-06-09', '0'),
('111', '26', '5', '4', '2022-06-09 08:46:22', NULL, '3', '2022-06-09', NULL),
('112', '26', '5', '4', '2022-06-09 08:46:22', 'Released.', '3', '2022-06-09', '0'),
('113', '0', '7', '4', '2022-06-09 08:46:22', NULL, '3', '2022-06-09', '0'),
('114', '0', '8', '4', '2022-06-09 08:46:22', NULL, '3', '2022-06-09', '0'),
('115', '29', '5', '4', '2022-06-09 08:46:22', 'Production.', '3', '2022-06-09', '0'),
('116', '18', '27', '4', '2022-06-10 07:06:23', NULL, '3', '2022-06-10', '0'),
('117', '26', '6', '4', '2022-06-10 07:20:08', NULL, '3', '2022-06-10', NULL),
('118', '26', '6', '4', '2022-06-10 07:20:08', 'Released.', '3', '2022-06-10', '0'),
('119', '0', '9', '4', '2022-06-10 07:20:08', NULL, '3', '2022-06-10', '0'),
('120', '0', '10', '4', '2022-06-10 07:20:08', NULL, '3', '2022-06-10', '0'),
('121', '29', '6', '4', '2022-06-10 07:20:08', 'Production.', '3', '2022-06-10', '0'),
('122', '18', '28', '4', '2022-06-13 08:35:15', NULL, '3', '2022-06-13', '0'),
('123', '30', '12', '4', '2022-06-13 08:37:22', NULL, '3', '2022-06-13', '0'),
('124', '18', '29', '4', '2022-06-14 05:19:39', NULL, '3', '2022-06-14', '0'),
('125', '18', '30', '4', '2022-06-15 03:50:49', NULL, '3', '2022-06-15', '0'),
('126', '25', '18', '4', '2022-06-15 03:51:54', NULL, '3', '2022-06-15', '0'),
('127', '20', '13', '4', '2022-06-15 03:52:53', NULL, '3', '2022-06-15', '0'),
('128', '0', '11', '1', '2022-07-14 03:52:59', NULL, '3', '2022-07-14', NULL),
('129', '0', '11', '1', '2022-07-14 03:52:59', NULL, '3', '2022-07-14', '0'),
('130', '0', '12', '1', '2022-07-14 03:52:59', NULL, '3', '2022-07-14', NULL),
('131', '0', '12', '1', '2022-07-14 03:52:59', NULL, '3', '2022-07-14', '0'),
('133', '99', '8', '1', '2022-07-16 07:48:52', NULL, '3', '2022-07-16', '0'),
('134', '99', '9', '1', '2022-07-16 07:48:52', NULL, '3', '2022-07-16', '0'),
('135', '1', '4', '1', '2022-07-16 09:46:32', NULL, '3', '2022-02-01', NULL),
('136', '98', '1', '1', '2022-07-16 09:35:45', NULL, '3', '2022-02-01', NULL),
('137', '98', '1', '1', '2022-07-16 09:36:02', 'Updated.', '3', '2022-02-01', NULL),
('138', '98', '1', '1', '2022-07-16 09:43:48', 'Updated.', '3', '2022-02-01', NULL),
('139', '99', '10', '1', '2022-07-16 09:37:06', NULL, '3', '2022-07-16', '0'),
('140', '99', '11', '1', '2022-07-16 09:37:06', NULL, '3', '2022-07-16', '0'),
('141', '98', '1', '1', '2022-07-16 09:43:48', 'Updated.', '3', '2022-01-01', '0'),
('142', '1', '4', '1', '2022-07-16 09:46:32', 'Voided.\nLoan Deleted.', '3', '2022-07-16', '0'),
('143', '1', '6', '1', '2022-07-16 09:47:57', NULL, '3', '2022-01-01', '0'),
('144', '98', '2', '1', '2022-07-16 10:09:48', NULL, '3', '2022-01-01', NULL),
('145', '99', '12', '1', '2022-07-16 09:57:51', NULL, '3', '2022-07-16', '0'),
('146', '99', '13', '1', '2022-07-16 09:57:51', NULL, '3', '2022-07-16', '0'),
('147', '98', '2', '1', '2022-07-16 10:09:48', NULL, '3', '2022-07-16', '0'),
('148', '99', '14', '1', '2022-07-16 10:09:48', NULL, '3', '2022-07-16', '0'),
('149', '99', '3', '1', '2022-07-18 18:45:23', NULL, '3', '2022-07-19', '0');

### Structure of table `0_bank_accounts` ###

DROP TABLE IF EXISTS `0_bank_accounts`;

CREATE TABLE `0_bank_accounts` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` smallint(6) NOT NULL DEFAULT 0,
  `bank_account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account_number` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_address` tinytext COLLATE utf8_unicode_ci DEFAULT NULL,
  `bank_curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_curr_act` tinyint(1) NOT NULL DEFAULT 0,
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `bank_charge_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `last_reconciled_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ending_reconcile_balance` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `bank_account_name` (`bank_account_name`),
  KEY `bank_account_number` (`bank_account_number`),
  KEY `account_code` (`account_code`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_accounts` ###

INSERT INTO `0_bank_accounts` VALUES
('1060', '0', 'Current account', 'N/A', 'N/A', NULL, 'PKR', '1', '1', '5690', '0000-00-00 00:00:00', '0', '0'),
('1065', '3', 'Petty Cash account', 'N/A', 'N/A', NULL, 'PKR', '0', '2', '5690', '2022-08-29 15:00:00', '0', '0');

### Structure of table `0_bank_trans` ###

DROP TABLE IF EXISTS `0_bank_trans`;

CREATE TABLE `0_bank_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `bank_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ref` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `trans_date` date NOT NULL DEFAULT '0000-00-00',
  `amount` double DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) NOT NULL DEFAULT 0,
  `person_id` tinyblob DEFAULT NULL,
  `reconciled` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_act` (`bank_act`,`ref`),
  KEY `type` (`type`,`trans_no`),
  KEY `bank_act_2` (`bank_act`,`reconciled`),
  KEY `bank_act_3` (`bank_act`,`trans_date`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bank_trans` ###

INSERT INTO `0_bank_trans` VALUES
('1', '1', '1', '1', '001/2022', '2022-05-11', '-1000', '0', '0', '0', '9087', NULL),
('2', '22', '1', '1', '001/2022', '2022-05-11', '-5850', '0', '0', '3', '1', NULL),
('3', '12', '1', '1', '001/2022', '2022-05-11', '5850', '0', '0', '2', '2', NULL),
('4', '0', '1', '1', NULL, '2022-05-17', '-264.16', '0', '0', '1', '1', NULL),
('5', '0', '2', '1', NULL, '2022-05-17', '-316.99', '0', '0', '1', '1', NULL),
('6', '22', '2', '1', '002/2022', '2022-05-20', '-66047143.5', '0', '0', '3', '1', NULL),
('7', '0', '3', '1', NULL, '2022-05-20', '-0.63', '0', '0', '1', '3', NULL),
('8', '0', '4', '1', NULL, '2022-05-20', '-1.27', '0', '0', '1', '3', NULL),
('9', '22', '3', '1', '003/2022', '2022-05-20', '-57915', '0', '0', '3', '2', NULL),
('10', '0', '5', '1', NULL, '2022-05-20', '-26.42', '0', '0', '1', '4', NULL),
('11', '0', '6', '1', NULL, '2022-05-20', '-21.13', '0', '0', '1', '4', NULL),
('12', '22', '4', '1', '004/2022', '2022-05-20', '-3635117', '0', '0', '3', '3', NULL),
('13', '12', '2', '2', '002/2022', '2022-05-20', '47.02', '0', '0', '2', '2', NULL),
('14', '22', '5', '1', '005/2022', '2022-05-22', '-137937.2', '0', '0', '3', '1', NULL),
('15', '12', '3', '2', '003/2022', '2022-06-08', '52.83', '0', '0', '2', '2', NULL),
('16', '12', '4', '2', '004/2022', '2022-06-09', '278.16', '0', '0', '2', '1', NULL),
('17', '12', '5', '1', '005/2022', '2022-06-09', '10000', '0', '0', '2', '3', NULL),
('18', '0', '7', '1', NULL, '2022-06-09', '-5.28', '0', '0', '1', '5', NULL),
('19', '0', '8', '1', NULL, '2022-06-09', '-2.64', '0', '0', '1', '5', NULL),
('20', '0', '9', '1', NULL, '2022-06-10', '-3.17', '0', '0', '1', '6', NULL),
('21', '0', '10', '1', NULL, '2022-06-10', '-5.28', '0', '0', '1', '6', NULL),
('22', '1', '2', '1', 'Bank Payout ', '2022-07-16', '58483.87', '0', '0', '0', '0', NULL),
('24', '1', '3', '1', 'Bank Payout ', '2022-02-01', '199548.38', '0', '0', '0', '0', NULL),
('25', '1', '4', '1', NULL, '2022-02-01', '0', '0', '0', '6', '005', NULL),
('26', '1', '5', '1', 'Bank Payout ', '2022-07-16', '80000', '0', '0', '0', '0', NULL),
('27', '1', '6', '1', NULL, '2022-01-01', '0', '0', '0', '6', '005', NULL);

### Structure of table `0_bom` ###

DROP TABLE IF EXISTS `0_bom`;

CREATE TABLE `0_bom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `component` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre_added` int(11) NOT NULL DEFAULT 0,
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `quantity` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`parent`,`component`,`workcentre_added`,`loc_code`),
  KEY `component` (`component`),
  KEY `id` (`id`),
  KEY `loc_code` (`loc_code`),
  KEY `parent` (`parent`,`loc_code`),
  KEY `workcentre_added` (`workcentre_added`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_bom` ###

INSERT INTO `0_bom` VALUES
('1', '187', '101', '1', 'DEF', '1'),
('2', '187', '1202', '1', 'DEF', '1'),
('3', 'T-0001', 'T-0002', '2', 'DEF', '1'),
('4', 'T-0001', 'T-0003', '3', 'DEF', '2'),
('5', 'T-0001', 'T-0004', '4', 'DEF', '1');

### Structure of table `0_budget_trans` ###

DROP TABLE IF EXISTS `0_budget_trans`;

CREATE TABLE `0_budget_trans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) DEFAULT 0,
  `dimension2_id` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `Account` (`account`,`tran_date`,`dimension_id`,`dimension2_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_budget_trans` ###


### Structure of table `0_chart_class` ###

DROP TABLE IF EXISTS `0_chart_class`;

CREATE TABLE `0_chart_class` (
  `cid` varchar(3) COLLATE utf8_unicode_ci NOT NULL,
  `class_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `ctype` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_class` ###

INSERT INTO `0_chart_class` VALUES
('1', 'Assets', '1', '0'),
('2', 'Liabilities', '2', '0'),
('3', 'Income', '4', '0'),
('4', 'Costs', '6', '0');

### Structure of table `0_chart_master` ###

DROP TABLE IF EXISTS `0_chart_master`;

CREATE TABLE `0_chart_master` (
  `account_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_code2` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `account_type` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`account_code`),
  KEY `account_name` (`account_name`),
  KEY `accounts_by_type` (`account_type`,`account_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_master` ###

INSERT INTO `0_chart_master` VALUES
('1060', '', 'Checking Account', '1', '0'),
('1065', '', 'Petty Cash', '1', '0'),
('1200', '', 'Accounts Receivables', '1', '0'),
('1205', '', 'Allowance for doubtful accounts', '1', '0'),
('1510', '', 'Inventory', '2', '0'),
('1520', '', 'Stocks of Raw Materials', '2', '0'),
('1530', '', 'Stocks of Work In Progress', '2', '0'),
('1540', '', 'Stocks of Finished Goods', '2', '0'),
('1550', '', 'Goods Received Clearing account', '2', '0'),
('1820', '', 'Office Furniture &amp; Equipment', '3', '0'),
('1825', '', 'Accum. Amort. -Furn. &amp; Equip.', '3', '0'),
('1840', '', 'Vehicle', '3', '0'),
('1845', '', 'Accum. Amort. -Vehicle', '3', '0'),
('2100', '', 'Accounts Payable', '4', '0'),
('2105', '', 'Deferred Income', '4', '0'),
('2110', '', 'Accrued Income Tax - Federal', '4', '0'),
('2120', '', 'Accrued Income Tax - State', '4', '0'),
('2130', '', 'Accrued Franchise Tax', '4', '0'),
('2140', '', 'Accrued Real &amp; Personal Prop Tax', '4', '0'),
('2150', '', 'Sales Tax', '4', '0'),
('2160', '', 'Accrued Use Tax Payable', '4', '0'),
('2210', '', 'Accrued Wages', '4', '0'),
('2220', '', 'Accrued Comp Time', '4', '0'),
('2230', '', 'Accrued Holiday Pay', '4', '0'),
('2240', '', 'Accrued Vacation Pay', '4', '0'),
('2310', '', 'Accr. Benefits - 401K', '4', '0'),
('2320', '', 'Accr. Benefits - Stock Purchase', '4', '0'),
('2330', '', 'Accr. Benefits - Med, Den', '4', '0'),
('2340', '', 'Accr. Benefits - Payroll Taxes', '4', '0'),
('2350', '', 'Accr. Benefits - Credit Union', '4', '0'),
('2360', '', 'Accr. Benefits - Savings Bond', '4', '0'),
('2370', '', 'Accr. Benefits - Garnish', '4', '0'),
('2380', '', 'Accr. Benefits - Charity Cont.', '4', '0'),
('2620', '', 'Bank Loans', '5', '0'),
('2680', '', 'Loans from Shareholders', '5', '0'),
('3350', '', 'Common Shares', '6', '0'),
('3590', '', 'Retained Earnings - prior years', '7', '0'),
('4010', '', 'Sales', '8', '0'),
('4430', '', 'Shipping &amp; Handling', '9', '0'),
('4440', '', 'Interest', '9', '0'),
('4450', '', 'Foreign Exchange Gain', '9', '0'),
('4500', '', 'Prompt Payment Discounts', '9', '0'),
('4510', '', 'Discounts Given', '9', '0'),
('5010', '', 'Cost of Goods Sold - Retail', '10', '0'),
('5020', '', 'Material Usage Varaiance', '10', '0'),
('5030', '', 'Consumable Materials', '10', '0'),
('5040', '', 'Purchase price Variance', '10', '0'),
('5050', '', 'Purchases of materials', '10', '0'),
('5060', '', 'Discounts Received', '10', '0'),
('5100', '', 'Freight', '10', '0'),
('5410', '', 'Wages &amp; Salaries', '11', '0'),
('5420', '', 'Wages - Overtime', '11', '0'),
('5430', '', 'Benefits - Comp Time', '11', '0'),
('5440', '', 'Benefits - Payroll Taxes', '11', '0'),
('5450', '', 'Benefits - Workers Comp', '11', '0'),
('5460', '', 'Benefits - Pension', '11', '0'),
('5470', '', 'Benefits - General Benefits', '11', '0'),
('5510', '', 'Inc Tax Exp - Federal', '11', '0'),
('5520', '', 'Inc Tax Exp - State', '11', '0'),
('5530', '', 'Taxes - Real Estate', '11', '0'),
('5540', '', 'Taxes - Personal Property', '11', '0'),
('5550', '', 'Taxes - Franchise', '11', '0'),
('5560', '', 'Taxes - Foreign Withholding', '11', '0'),
('5610', '', 'Accounting &amp; Legal', '12', '0'),
('5615', '', 'Advertising &amp; Promotions', '12', '0'),
('5620', '', 'Bad Debts', '12', '0'),
('5660', '', 'Amortization Expense', '12', '0'),
('5685', '', 'Insurance', '12', '0'),
('5690', '', 'Interest &amp; Bank Charges', '12', '0'),
('5700', '', 'Office Supplies', '12', '0'),
('5760', '', 'Rent', '12', '0'),
('5765', '', 'Repair &amp; Maintenance', '12', '0'),
('5780', '', 'Telephone', '12', '0'),
('5785', '', 'Travel &amp; Entertainment', '12', '0'),
('5790', '', 'Utilities', '12', '0'),
('5795', '', 'Registrations', '12', '0'),
('5800', '', 'Licenses', '12', '0'),
('5810', '', 'Foreign Exchange Loss', '12', '0'),
('9990', '', 'Year Profit/Loss', '12', '0');

### Structure of table `0_chart_types` ###

DROP TABLE IF EXISTS `0_chart_types`;

CREATE TABLE `0_chart_types` (
  `id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `class_id` varchar(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '-1',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_chart_types` ###

INSERT INTO `0_chart_types` VALUES
('1', 'Current Assets', '1', '', '0'),
('10', 'Cost of Goods Sold', '4', '', '0'),
('11', 'Payroll Expenses', '4', '', '0'),
('12', 'General &amp; Administrative expenses', '4', '', '0'),
('2', 'Inventory Assets', '1', '', '0'),
('3', 'Capital Assets', '1', '', '0'),
('4', 'Current Liabilities', '2', '', '0'),
('5', 'Long Term Liabilities', '2', '', '0'),
('6', 'Share Capital', '2', '', '0'),
('7', 'Retained Earnings', '2', '', '0'),
('8', 'Sales Revenue', '3', '', '0'),
('9', 'Other Revenue', '3', '', '0');

### Structure of table `0_comments` ###

DROP TABLE IF EXISTS `0_comments`;

CREATE TABLE `0_comments` (
  `type` int(11) NOT NULL DEFAULT 0,
  `id` int(11) NOT NULL DEFAULT 0,
  `date_` date DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `type_and_id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_comments` ###

INSERT INTO `0_comments` VALUES
('26', '1', '2022-05-17', 'test item process'),
('26', '2', '2022-06-09', 'TEST'),
('22', '2', '2022-05-20', '51651'),
('29', '2', '2022-05-20', 'test'),
('26', '3', '2022-05-20', 'advance production'),
('17', '1', '2022-05-20', 'adjustment'),
('28', '3', '2022-05-20', 'add carton'),
('0', '3', '2022-05-20', 'add cost'),
('28', '4', '2022-05-20', 'add cement'),
('0', '4', '2022-05-20', 'Over head cost'),
('29', '3', '2022-05-20', 'Produces'),
('22', '3', '2022-05-20', '430'),
('22', '4', '2022-05-20', '9086'),
('12', '2', '2022-05-20', 'Default #1'),
('22', '5', '2022-05-22', '0976'),
('12', '3', '2022-06-08', 'Default #2'),
('12', '4', '2022-06-09', 'Default #5'),
('26', '6', '2022-06-10', 'test'),
('1', '4', '2022-02-01', 'Employee Loan Amount #005-Noor'),
('1', '6', '2022-01-01', 'Employee Loan Amount #005-Noor');

### Structure of table `0_credit_status` ###

DROP TABLE IF EXISTS `0_credit_status`;

CREATE TABLE `0_credit_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason_description` char(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dissallow_invoices` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reason_description` (`reason_description`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_credit_status` ###

INSERT INTO `0_credit_status` VALUES
('1', 'Good History', '0', '0'),
('3', 'No more work until payment received', '1', '0'),
('4', 'In liquidation', '1', '0');

### Structure of table `0_crm_categories` ###

DROP TABLE IF EXISTS `0_crm_categories`;

CREATE TABLE `0_crm_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'pure technical key',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT 'contact type e.g. customer',
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT 'detailed usage e.g. department',
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL COMMENT 'for category selector',
  `description` tinytext COLLATE utf8_unicode_ci NOT NULL COMMENT 'usage description',
  `system` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'nonzero for core system usage',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`action`),
  UNIQUE KEY `type_2` (`type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_categories` ###

INSERT INTO `0_crm_categories` VALUES
('1', 'cust_branch', 'general', 'General', 'General contact data for customer branch (overrides company setting)', '1', '0'),
('2', 'cust_branch', 'invoice', 'Invoices', 'Invoice posting (overrides company setting)', '1', '0'),
('3', 'cust_branch', 'order', 'Orders', 'Order confirmation (overrides company setting)', '1', '0'),
('4', 'cust_branch', 'delivery', 'Deliveries', 'Delivery coordination (overrides company setting)', '1', '0'),
('5', 'customer', 'general', 'General', 'General contact data for customer', '1', '0'),
('6', 'customer', 'order', 'Orders', 'Order confirmation', '1', '0'),
('7', 'customer', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('8', 'customer', 'invoice', 'Invoices', 'Invoice posting', '1', '0'),
('9', 'supplier', 'general', 'General', 'General contact data for supplier', '1', '0'),
('10', 'supplier', 'order', 'Orders', 'Order confirmation', '1', '0'),
('11', 'supplier', 'delivery', 'Deliveries', 'Delivery coordination', '1', '0'),
('12', 'supplier', 'invoice', 'Invoices', 'Invoice posting', '1', '0');

### Structure of table `0_crm_contacts` ###

DROP TABLE IF EXISTS `0_crm_contacts`;

CREATE TABLE `0_crm_contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL DEFAULT 0 COMMENT 'foreign key to crm_persons',
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT 'foreign key to crm_categories',
  `action` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT 'foreign key to crm_categories',
  `entity_id` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT 'entity id in related class table',
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`action`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_contacts` ###

INSERT INTO `0_crm_contacts` VALUES
('1', '1', 'cust_branch', 'general', '1'),
('2', '1', 'customer', 'general', '1'),
('3', '2', 'supplier', 'general', '1'),
('4', '3', 'supplier', 'general', '2'),
('5', '4', 'supplier', 'general', '3'),
('6', '5', 'cust_branch', 'general', '2'),
('7', '5', 'customer', 'general', '2'),
('8', '6', 'supplier', 'general', '4'),
('9', '7', 'cust_branch', 'general', '3'),
('10', '7', 'customer', 'general', '3');

### Structure of table `0_crm_persons` ###

DROP TABLE IF EXISTS `0_crm_persons`;

CREATE TABLE `0_crm_persons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `name2` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `address` tinytext COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `phone2` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `lang` char(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `ref` (`ref`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_crm_persons` ###

INSERT INTO `0_crm_persons` VALUES
('1', 'tst', 'test', NULL, 'testq', '03062329070', NULL, NULL, NULL, NULL, '', '0'),
('2', 'Supp A', 'abc cont', NULL, 'abc1234', '03342993194', NULL, NULL, NULL, NULL, '', '0'),
('3', 'Supp B', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('4', 'Twisting', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '', '0'),
('5', 'yaha silk', 'Yaha silk', NULL, 'test', NULL, NULL, NULL, NULL, NULL, '', '0'),
('6', 'ZA', 'Ali ', NULL, NULL, '03008547973', NULL, NULL, NULL, NULL, '', '0'),
('7', 'naeem', 'naeem', NULL, 'xyz', NULL, NULL, NULL, NULL, NULL, '', '0');

### Structure of table `0_currencies` ###

DROP TABLE IF EXISTS `0_currencies`;

CREATE TABLE `0_currencies` (
  `currency` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_symbol` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `hundreds_name` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `auto_update` tinyint(1) NOT NULL DEFAULT 1,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`curr_abrev`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_currencies` ###

INSERT INTO `0_currencies` VALUES
('CA Dollars', 'CAD', '$', 'Canada', 'Cents', '1', '0'),
('Euro', 'EUR', '€', 'Europe', 'Cents', '1', '0'),
('Pounds', 'GBP', '£', 'England', 'Pence', '1', '0'),
('Rupee', 'PKR', 'Rs', 'Pakistan', 'Rupees', '1', '0'),
('US Dollars', 'USD', '$', 'United States', 'Cents', '1', '0');

### Structure of table `0_cust_allocations` ###

DROP TABLE IF EXISTS `0_cust_allocations`;

CREATE TABLE `0_cust_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trans_type_from` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_allocations` ###

INSERT INTO `0_cust_allocations` VALUES
('1', '2', '8900', '2022-05-20', '2', '12', '1', '10'),
('2', '2', '10000', '2022-06-08', '3', '12', '2', '10'),
('3', '1', '52650', '2022-06-09', '4', '12', '5', '10'),
('4', '3', '10000', '2022-06-09', '5', '12', '3', '10');

### Structure of table `0_cust_branch` ###

DROP TABLE IF EXISTS `0_cust_branch`;

CREATE TABLE `0_cust_branch` (
  `branch_code` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_no` int(11) NOT NULL DEFAULT 0,
  `br_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `branch_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `br_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `area` int(11) DEFAULT NULL,
  `salesman` int(11) NOT NULL DEFAULT 0,
  `default_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_group_id` int(11) DEFAULT NULL,
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `receivables_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default_ship_via` int(11) NOT NULL DEFAULT 1,
  `br_post_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `group_no` int(11) NOT NULL DEFAULT 0,
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `bank_account` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`branch_code`,`debtor_no`),
  KEY `branch_ref` (`branch_ref`),
  KEY `group_no` (`group_no`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_cust_branch` ###

INSERT INTO `0_cust_branch` VALUES
('1', '1', 'AL SAMI LLC', 'AL SAMI LLC', 'N/A', '1', '1', 'DEF', '1', '', '4510', '1200', '4500', '1', 'N/A', '0', '', NULL, '0'),
('2', '2', 'Danum Ltd.', 'Danum Ltd.', '', '1', '1', 'DEF', '2', '', '4510', '1200', '4500', '1', '', '0', '', NULL, '0'),
('3', '3', 'naeem', 'naeem', 'xyz', '1', '1', 'DEF', '1', '', '4510', '1200', '4500', '1', 'xyz', '0', '', NULL, '0');

### Structure of table `0_custom_fields` ###

DROP TABLE IF EXISTS `0_custom_fields`;

CREATE TABLE `0_custom_fields` (
  `id` int(11) NOT NULL,
  `field` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `label` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `module` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `field_name` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `pick_type` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `header_id` int(11) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_custom_fields` ###


### Structure of table `0_custom_headers` ###

DROP TABLE IF EXISTS `0_custom_headers`;

CREATE TABLE `0_custom_headers` (
  `id` int(11) NOT NULL,
  `header_label` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `module` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `position` varchar(250) COLLATE utf8_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_custom_headers` ###


### Structure of table `0_debtor_trans` ###

DROP TABLE IF EXISTS `0_debtor_trans`;

CREATE TABLE `0_debtor_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `version` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `debtor_no` int(11) unsigned NOT NULL,
  `branch_code` int(11) NOT NULL DEFAULT -1,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tpe` int(11) NOT NULL DEFAULT 0,
  `order_` int(11) NOT NULL DEFAULT 0,
  `ov_amount` double NOT NULL DEFAULT 0,
  `ov_gst` double NOT NULL DEFAULT 0,
  `ov_freight` double NOT NULL DEFAULT 0,
  `ov_freight_tax` double NOT NULL DEFAULT 0,
  `ov_discount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `ship_via` int(11) DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`type`,`trans_no`,`debtor_no`),
  KEY `debtor_no` (`debtor_no`,`branch_code`),
  KEY `tran_date` (`tran_date`),
  KEY `order_` (`order_`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans` ###

INSERT INTO `0_debtor_trans` VALUES
('1', '10', '0', '2', '2', '2022-05-20', '2022-05-20', '001/2022', '2', '6', '8900', '0', '0', '0', '0', '8900', '0', '1', '1', '0', '0', '4', '0'),
('2', '10', '0', '2', '2', '2022-06-08', '2022-06-08', '002/2022', '2', '8', '10000', '0', '0', '0', '0', '10000', '0', '1', '1', '0', '0', '4', '0'),
('3', '10', '0', '3', '3', '2022-06-08', '2022-07-17', '003/2022', '2', '9', '50000', '8500', '0', '0', '0', '10000', '0', '1', '1', '0', '0', '1', '0'),
('4', '10', '0', '3', '3', '2022-06-08', '2022-07-17', '004/2022', '2', '10', '5000', '850', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('5', '10', '0', '1', '1', '2022-06-09', '2022-06-09', '005/2022', '2', '11', '40000', '6800', '5000', '850', '0', '52650', '0', '1', '1', '0', '0', '4', '0'),
('1', '12', '0', '2', '2', '2022-05-11', '0000-00-00', '001/2022', '0', '0', '5850', '0', '0', '0', '0', '0', '0', '1', '0', '0', '0', NULL, '0'),
('2', '12', '0', '2', '2', '2022-05-20', '0000-00-00', '002/2022', '0', '0', '8900', '0', '0', '0', '0', '8900', '0', '1', '0', '0', '0', NULL, '0'),
('3', '12', '0', '2', '2', '2022-06-08', '0000-00-00', '003/2022', '0', '0', '10000', '0', '0', '0', '0', '10000', '0', '1', '0', '0', '0', NULL, '0'),
('4', '12', '0', '1', '1', '2022-06-09', '0000-00-00', '004/2022', '0', '0', '52650', '0', '0', '0', '0', '52650', '0', '1', '0', '0', '0', NULL, '0'),
('5', '12', '0', '3', '3', '2022-06-09', '0000-00-00', '005/2022', '0', '0', '10000', '0', '0', '0', '0', '10000', '0', '1', '0', '0', '0', NULL, '0'),
('1', '13', '0', '2', '2', '2022-05-11', '2022-05-12', '001/2022', '2', '2', '5000', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '0'),
('2', '13', '0', '2', '2', '2022-05-20', '2022-05-21', '002/2022', '2', '5', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '0'),
('3', '13', '1', '2', '2', '2022-05-20', '2022-05-20', 'auto', '2', '6', '8900', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '0'),
('4', '13', '1', '2', '2', '2022-06-08', '2022-06-08', 'auto', '2', '8', '10000', '0', '0', '0', '0', '0', '0', '1', '1', '0', '0', '4', '0'),
('5', '13', '1', '3', '3', '2022-06-08', '2022-07-17', 'auto', '2', '9', '50000', '8500', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('6', '13', '1', '3', '3', '2022-06-08', '2022-07-17', 'auto', '2', '10', '5000', '850', '0', '0', '0', '0', '0', '1', '1', '0', '0', '1', '0'),
('7', '13', '1', '1', '1', '2022-06-09', '2022-06-09', 'auto', '2', '11', '40000', '6800', '5000', '850', '0', '0', '0', '1', '1', '0', '0', '4', '0');

### Structure of table `0_debtor_trans_details` ###

DROP TABLE IF EXISTS `0_debtor_trans_details`;

CREATE TABLE `0_debtor_trans_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `debtor_trans_no` int(11) DEFAULT NULL,
  `debtor_trans_type` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci DEFAULT NULL,
  `unit_price` double NOT NULL DEFAULT 0,
  `unit_tax` double NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `discount_percent` double NOT NULL DEFAULT 0,
  `standard_cost` double NOT NULL DEFAULT 0,
  `qty_done` double NOT NULL DEFAULT 0,
  `src_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`debtor_trans_type`,`debtor_trans_no`),
  KEY `src_id` (`src_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtor_trans_details` ###

INSERT INTO `0_debtor_trans_details` VALUES
('1', '1', '13', '14121', 'gum ', '500', '0', '10', '0', '94640', '0', '2'),
('2', '2', '13', '187', 'KFT', '0', '0', '1', '0', '47320', '0', '5'),
('3', '3', '13', '201', 'Cement', '800', '0', '10', '0', '148454.90196078', '10', '6'),
('4', '3', '13', 'T-0002', 'Cap', '450', '0', '2', '0', '946400', '2', '7'),
('5', '1', '10', '201', 'Cement', '800', '0', '10', '0', '148454.90196078', '0', '3'),
('6', '1', '10', 'T-0002', 'Cap', '450', '0', '2', '0', '946400', '0', '4'),
('7', '4', '13', '78540', 'MG 17', '100', '0', '100', '0', '56784', '100', '9'),
('8', '2', '10', '78540', 'MG 17', '100', '0', '100', '0', '56784', '0', '7'),
('9', '5', '13', '9787', 'Chemical 1', '500', '85', '100', '0', '209472.02124833', '100', '10'),
('10', '3', '10', '9787', 'Chemical 1', '500', '85', '100', '0', '209472.02124833', '0', '9'),
('11', '6', '13', '101', 'abc', '50', '8.5', '100', '0', '9464', '100', '11'),
('12', '4', '10', '101', 'abc', '50', '8.5', '100', '0', '9464', '0', '11'),
('13', '7', '13', '187', 'KFT', '400', '68', '100', '0', '25696.146788991', '100', '14'),
('14', '5', '10', '187', 'KFT', '400', '68', '100', '0', '25696.146788991', '0', '13');

### Structure of table `0_debtors_master` ###

DROP TABLE IF EXISTS `0_debtors_master`;

CREATE TABLE `0_debtors_master` (
  `debtor_no` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `debtor_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci DEFAULT NULL,
  `tax_id` varchar(55) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type` int(11) NOT NULL DEFAULT 1,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `credit_status` int(11) NOT NULL DEFAULT 0,
  `payment_terms` int(11) DEFAULT NULL,
  `discount` double NOT NULL DEFAULT 0,
  `pymt_discount` double NOT NULL DEFAULT 0,
  `credit_limit` float NOT NULL DEFAULT 1000,
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`debtor_no`),
  UNIQUE KEY `debtor_ref` (`debtor_ref`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_debtors_master` ###

INSERT INTO `0_debtors_master` VALUES
('1', 'AL SAMI LLC', 'AL SAMI LLC', 'testq', '1', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('2', 'Danum Ltd.', 'Danum Ltd.', 'test', '', 'PKR', '2', '0', '0', '1', '4', '0', '0', '1000', '', '0'),
('3', 'naeem', 'naeem', 'xyz', '', 'PKR', '2', '0', '0', '1', '1', '0', '0', '100000', '', '0');

### Structure of table `0_dimensions` ###

DROP TABLE IF EXISTS `0_dimensions`;

CREATE TABLE `0_dimensions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type_` tinyint(1) NOT NULL DEFAULT 1,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `dimension_id` int(11) DEFAULT NULL COMMENT 'dimension_id is sub id of dimension l..',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reference` (`reference`),
  KEY `date_` (`date_`),
  KEY `due_date` (`due_date`),
  KEY `type_` (`type_`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_dimensions` ###

INSERT INTO `0_dimensions` VALUES
('1', '001/2022', 'F B Area DIM', '1', '0', '2022-03-30', '2022-04-19', NULL);

### Structure of table `0_exchange_rates` ###

DROP TABLE IF EXISTS `0_exchange_rates`;

CREATE TABLE `0_exchange_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `curr_code` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rate_buy` double NOT NULL DEFAULT 0,
  `rate_sell` double NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `curr_code` (`curr_code`,`date_`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_exchange_rates` ###

INSERT INTO `0_exchange_rates` VALUES
('1', 'USD', '189.28', '189.28', '2022-05-11'),
('2', 'USD', '189.28', '189.28', '2022-05-17'),
('3', 'USD', '189.28', '189.28', '2022-05-19'),
('4', 'USD', '189.28', '189.28', '2022-05-20'),
('5', 'USD', '189.28', '189.28', '2022-05-22'),
('6', 'USD', '189.28', '189.28', '2022-06-02'),
('7', 'USD', '189.28', '189.28', '2022-06-03'),
('8', 'USD', '189.28', '189.28', '2022-06-09'),
('9', 'USD', '189.28', '189.28', '2022-06-15'),
('10', 'CAD', '159.346', '159.346', '2022-07-13'),
('11', 'EUR', '208.033', '208.033', '2022-07-13'),
('12', 'GBP', '247.034', '247.034', '2022-07-14');

### Structure of table `0_fiscal_year` ###

DROP TABLE IF EXISTS `0_fiscal_year`;

CREATE TABLE `0_fiscal_year` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `begin` date DEFAULT '0000-00-00',
  `end` date DEFAULT '0000-00-00',
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `begin` (`begin`),
  UNIQUE KEY `end` (`end`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_fiscal_year` ###

INSERT INTO `0_fiscal_year` VALUES
('1', '2020-01-01', '2020-12-31', '1'),
('2', '2021-01-01', '2021-12-31', '0'),
('3', '2022-01-01', '2022-12-31', '0');

### Structure of table `0_gl_trans` ###

DROP TABLE IF EXISTS `0_gl_trans`;

CREATE TABLE `0_gl_trans` (
  `counter` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL DEFAULT 0,
  `type_no` int(11) NOT NULL DEFAULT 0,
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `amount` double NOT NULL DEFAULT 0,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  `person_type_id` int(11) DEFAULT NULL,
  `person_id` tinyblob DEFAULT NULL,
  PRIMARY KEY (`counter`),
  KEY `Type_and_Number` (`type`,`type_no`),
  KEY `dimension_id` (`dimension_id`),
  KEY `dimension2_id` (`dimension2_id`),
  KEY `tran_date` (`tran_date`),
  KEY `account_and_tran_date` (`account`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=338 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_gl_trans` ###

INSERT INTO `0_gl_trans` VALUES
('1', '1', '1', '2022-05-11', '2100', 'test', '189280', '1', '0', '0', '9087'),
('2', '1', '1', '2022-05-11', '1060', '', '-189280', '1', '0', NULL, NULL),
('3', '25', '1', '2022-05-11', '1510', '14121', '946400', '1', '0', NULL, NULL),
('4', '25', '1', '2022-05-11', '1550', '', '-946400', '0', '0', NULL, NULL),
('5', '20', '1', '2022-05-11', '2150', '', '160888', '0', '0', NULL, NULL),
('6', '20', '1', '2022-05-11', '2100', '', '-1107288', '0', '0', '3', '1'),
('7', '20', '1', '2022-05-11', '1550', '', '946400', '1', '0', NULL, NULL),
('8', '22', '1', '2022-05-11', '2100', '', '1107288', '0', '0', '3', '1'),
('9', '22', '1', '2022-05-11', '1060', '', '-1107288', '0', '0', NULL, NULL),
('10', '13', '1', '2022-05-11', '5010', '', '946400', '1', '0', NULL, NULL),
('11', '13', '1', '2022-05-11', '1510', '', '-946400', '0', '0', NULL, NULL),
('12', '12', '1', '2022-05-11', '1060', '', '1107288', '0', '0', NULL, NULL),
('13', '12', '1', '2022-05-11', '1200', '', '-5850', '0', '0', '2', '2'),
('14', '12', '1', '2022-05-11', '4450', '', '-1101438', '0', '0', NULL, NULL),
('15', '25', '2', '2022-05-17', '1510', '201', '473200000', '1', '0', NULL, NULL),
('16', '25', '2', '2022-05-17', '1510', '9787', '37856000', '0', '0', NULL, NULL),
('17', '25', '2', '2022-05-17', '1510', '20147', '75712000', '0', '0', NULL, NULL),
('18', '25', '2', '2022-05-17', '1550', '', '-586768000', '0', '0', NULL, NULL),
('19', '20', '2', '2022-05-17', '2150', '', '99750560', '0', '0', NULL, NULL),
('20', '20', '2', '2022-05-17', '2100', '', '-686518560', '0', '0', '3', '3'),
('21', '20', '2', '2022-05-17', '1550', '', '473200000', '1', '0', NULL, NULL),
('22', '20', '2', '2022-05-17', '1550', '', '37856000', '0', '0', NULL, NULL),
('23', '20', '2', '2022-05-17', '1550', '', '75712000', '0', '0', NULL, NULL),
('24', '25', '3', '2022-05-17', '1510', 'T-0002', '9464000000', '0', '0', NULL, NULL),
('25', '25', '3', '2022-05-17', '1550', '', '-9464000000', '0', '0', NULL, NULL),
('26', '20', '3', '2022-05-17', '2150', '', '1608880000', '0', '0', NULL, NULL),
('27', '20', '3', '2022-05-17', '2100', '', '-11072880000', '0', '0', '3', '1'),
('28', '20', '3', '2022-05-17', '1550', '', '9464000000', '0', '0', NULL, NULL),
('29', '25', '4', '2022-05-17', '1510', 'T-0003', '1135680000', '0', '0', NULL, NULL),
('30', '25', '4', '2022-05-17', '1550', '', '-1135680000', '0', '0', NULL, NULL),
('31', '20', '4', '2022-05-17', '2150', '', '193065600', '0', '0', NULL, NULL),
('32', '20', '4', '2022-05-17', '2100', '', '-1328745600', '0', '0', '3', '1'),
('33', '20', '4', '2022-05-17', '1550', '', '1135680000', '0', '0', NULL, NULL),
('34', '25', '5', '2022-05-17', '1510', 'T-0004', '75712', '0', '0', NULL, NULL),
('35', '25', '5', '2022-05-17', '1550', '', '-75712', '0', '0', NULL, NULL),
('36', '20', '5', '2022-05-17', '2150', '', '12871.04', '0', '0', NULL, NULL),
('37', '20', '5', '2022-05-17', '2100', '', '-88583.04', '0', '0', '3', '1'),
('38', '20', '5', '2022-05-17', '1550', '', '75712', '0', '0', NULL, NULL),
('39', '25', '6', '2022-05-17', '1510', 'T-0004', '75712000', '0', '0', NULL, NULL),
('40', '25', '6', '2022-05-17', '1550', '', '-75712000', '0', '0', NULL, NULL),
('41', '20', '6', '2022-05-17', '2150', '', '12871040', '0', '0', NULL, NULL),
('42', '20', '6', '2022-05-17', '2100', '', '-88583040', '0', '0', '3', '1'),
('43', '20', '6', '2022-05-17', '1550', '', '75712000', '0', '0', NULL, NULL),
('44', '0', '1', '2022-05-17', '1060', 'Overhead Cost', '-50000', '0', '0', NULL, NULL),
('45', '0', '1', '2022-05-17', '1530', 'Overhead Cost', '50000', '0', '0', NULL, NULL),
('46', '0', '2', '2022-05-17', '1060', 'Labour Cost', '-60000', '0', '0', NULL, NULL),
('47', '0', '2', '2022-05-17', '1530', 'Labour Cost', '60000', '0', '0', NULL, NULL),
('48', '29', '1', '2022-05-17', '1510', '05/17/2022: 1 * Cap', '-946400000', '0', '0', NULL, NULL),
('49', '29', '1', '2022-05-17', '1510', '05/17/2022: 2 * Sticker', '-227136000', '0', '0', NULL, NULL),
('50', '29', '1', '2022-05-17', '1510', '05/17/2022: 1 * Carton', '-75712000', '0', '0', NULL, NULL),
('51', '29', '1', '2022-05-17', '1530', '05/17/2022: 1 * Carton', '1249248000', '0', '0', NULL, NULL),
('52', '26', '1', '2022-05-17', '1530', '', '-1249358000', '0', '0', NULL, NULL),
('53', '26', '1', '2022-05-17', '1510', '', '1249358000', '0', '0', NULL, NULL),
('54', '25', '7', '2022-05-19', '1510', '201', '283920000', '1', '0', NULL, NULL),
('55', '25', '7', '2022-05-19', '1510', '9787', '70980000', '0', '0', NULL, NULL),
('56', '25', '7', '2022-05-19', '1550', '', '-354900000', '0', '0', NULL, NULL),
('57', '25', '8', '2022-05-20', '1510', '101', '9464000', '0', '0', NULL, NULL),
('58', '25', '8', '2022-05-20', '1550', '', '-9464000', '0', '0', NULL, NULL),
('59', '20', '7', '2022-05-20', '2150', '', '1608880', '0', '0', NULL, NULL),
('60', '20', '7', '2022-05-20', '2100', '', '-11072880', '0', '0', '3', '1'),
('61', '20', '7', '2022-05-20', '1550', '', '9464000', '0', '0', NULL, NULL),
('62', '22', '2', '2022-05-20', '2100', '', '12501403321.68', '0', '0', '3', '1'),
('63', '22', '2', '2022-05-20', '1060', '', '-12501403321.68', '0', '0', NULL, NULL),
('64', '25', '9', '2022-05-20', '1510', '1202', '14196000', '0', '0', NULL, NULL),
('65', '25', '9', '2022-05-20', '1550', '', '-14196000', '0', '0', NULL, NULL),
('66', '20', '8', '2022-05-20', '2150', '', '2413320', '0', '0', NULL, NULL),
('67', '20', '8', '2022-05-20', '2100', '', '-16609320', '0', '0', '3', '1'),
('68', '20', '8', '2022-05-20', '1550', '', '14196000', '0', '0', NULL, NULL),
('69', '28', '1', '2022-05-20', '1510', '05/20/2022: Issue of abc', '-94640', '0', '0', NULL, NULL),
('70', '28', '1', '2022-05-20', '1530', '05/20/2022: Issue to KFT', '94640', '0', '0', NULL, NULL),
('71', '28', '2', '2022-05-20', '1510', '05/20/2022: Issue of asad', '-141960', '0', '0', NULL, NULL),
('72', '28', '2', '2022-05-20', '1530', '05/20/2022: Issue to KFT', '141960', '0', '0', NULL, NULL),
('73', '29', '2', '2022-05-20', '1510', '05/20/2022: 1 * abc', '-94640', '0', '0', NULL, NULL),
('74', '29', '2', '2022-05-20', '1510', '05/20/2022: 1 * asad', '-141960', '0', '0', NULL, NULL),
('75', '29', '2', '2022-05-20', '1530', '05/20/2022: 1 * asad', '236600', '0', '0', NULL, NULL),
('76', '26', '2', '2022-05-20', '1530', 'test', '-473200', '0', '0', NULL, NULL),
('77', '26', '2', '2022-05-20', '1510', 'test', '473200', '0', '0', NULL, NULL),
('78', '17', '1', '2022-05-20', '5040', 'adjustment', '-3785600', '0', '0', NULL, NULL),
('79', '17', '1', '2022-05-20', '1510', 'adjustment', '3785600', '0', '0', NULL, NULL),
('80', '17', '1', '2022-05-20', '5040', 'adjustment', '-7422745.1', '1', '0', NULL, NULL),
('81', '17', '1', '2022-05-20', '1510', 'adjustment', '7422745.1', '0', '0', NULL, NULL),
('82', '17', '1', '2022-05-20', '5040', 'adjustment', '-5182666.67', '0', '0', NULL, NULL),
('83', '17', '1', '2022-05-20', '1510', 'adjustment', '5182666.67', '0', '0', NULL, NULL),
('84', '28', '3', '2022-05-20', '1510', '05/20/2022: Issue of Carton', '-3785600', '0', '0', NULL, NULL),
('85', '28', '3', '2022-05-20', '1530', '05/20/2022: Issue to First Item', '3785600', '0', '0', NULL, NULL),
('86', '0', '3', '2022-05-20', '1060', 'Labour Cost', '-120', '0', '0', NULL, NULL),
('87', '0', '3', '2022-05-20', '1530', 'Labour Cost', '120', '0', '0', NULL, NULL),
('88', '28', '4', '2022-05-20', '1510', '05/20/2022: Issue of Cement', '-742274.51', '0', '0', NULL, NULL),
('89', '28', '4', '2022-05-20', '1530', '05/20/2022: Issue to First Item', '742274.51', '0', '0', NULL, NULL),
('90', '0', '4', '2022-05-20', '1060', 'Overhead Cost', '-240', '0', '0', NULL, NULL),
('91', '0', '4', '2022-05-20', '1530', 'Overhead Cost', '240', '0', '0', NULL, NULL),
('92', '29', '3', '2022-05-20', '1510', '05/20/2022: 1 * Cap', '9464000', '0', '0', NULL, NULL),
('93', '29', '3', '2022-05-20', '1510', '05/20/2022: 2 * Sticker', '2271360', '0', '0', NULL, NULL),
('94', '29', '3', '2022-05-20', '1510', '05/20/2022: 1 * Carton', '757120', '0', '0', NULL, NULL),
('95', '29', '3', '2022-05-20', '1530', '05/20/2022: 1 * Carton', '-12492480', '0', '0', NULL, NULL),
('96', '25', '10', '2022-05-20', '1510', '9787', '283920', '0', '0', NULL, NULL),
('97', '25', '10', '2022-05-20', '1510', '78540', '4732000', '1', '0', NULL, NULL),
('98', '25', '10', '2022-05-20', '1550', '', '-5015920', '0', '0', NULL, NULL),
('99', '20', '9', '2022-05-20', '2150', '', '852706.4', '0', '0', NULL, NULL),
('100', '20', '9', '2022-05-20', '2100', '', '-5868626.4', '0', '0', '3', '2'),
('101', '20', '9', '2022-05-20', '1550', '', '283920', '0', '0', NULL, NULL),
('102', '20', '9', '2022-05-20', '1550', '', '4732000', '1', '0', NULL, NULL),
('103', '22', '3', '2022-05-20', '2100', '', '10962151.2', '0', '0', '3', '2'),
('104', '22', '3', '2022-05-20', '1060', '', '-10962151.2', '0', '0', NULL, NULL),
('105', '13', '2', '2022-05-20', '5010', '', '47320', '0', '0', NULL, NULL),
('106', '13', '2', '2022-05-20', '1510', '', '-47320', '0', '0', NULL, NULL),
('107', '0', '5', '2022-05-20', '1060', 'Overhead Cost', '-5000', '0', '0', NULL, NULL),
('108', '0', '5', '2022-05-20', '1530', 'Overhead Cost', '5000', '0', '0', NULL, NULL),
('109', '0', '6', '2022-05-20', '1060', 'Labour Cost', '-4000', '0', '0', NULL, NULL),
('110', '0', '6', '2022-05-20', '1530', 'Labour Cost', '4000', '0', '0', NULL, NULL),
('111', '29', '4', '2022-05-20', '1510', '05/20/2022: 1 * abc', '-946400', '0', '0', NULL, NULL),
('112', '29', '4', '2022-05-20', '1510', '05/20/2022: 1 * asad', '-1419600', '0', '0', NULL, NULL),
('113', '29', '4', '2022-05-20', '1530', '05/20/2022: 1 * asad', '2366000', '0', '0', NULL, NULL),
('114', '26', '4', '2022-05-20', '1530', '', '-2375000', '0', '0', NULL, NULL),
('115', '26', '4', '2022-05-20', '1510', '', '2375000', '0', '0', NULL, NULL),
('116', '25', '11', '2022-05-20', '1510', 'T-0004', '567840', '0', '0', NULL, NULL),
('117', '25', '11', '2022-05-20', '1510', '1202', '1277640', '0', '0', NULL, NULL),
('118', '25', '11', '2022-05-20', '1510', 'T-0004', '189280', '0', '0', NULL, NULL),
('119', '25', '11', '2022-05-20', '1550', '', '-2034760', '0', '0', NULL, NULL),
('120', '20', '10', '2022-05-20', '2150', '', '345909.2', '0', '0', NULL, NULL),
('121', '20', '10', '2022-05-20', '2100', '', '-2380669.2', '0', '0', '3', '3'),
('122', '20', '10', '2022-05-20', '1550', '', '567840', '0', '0', NULL, NULL),
('123', '20', '10', '2022-05-20', '1550', '', '1277640', '0', '0', NULL, NULL),
('124', '20', '10', '2022-05-20', '1550', '', '189280', '0', '0', NULL, NULL),
('125', '22', '4', '2022-05-20', '2100', '', '688054945.76', '0', '0', '3', '3'),
('126', '22', '4', '2022-05-20', '1060', '', '-688054945.76', '0', '0', NULL, NULL),
('127', '13', '3', '2022-05-20', '5010', '', '1484549.02', '1', '0', NULL, NULL),
('128', '13', '3', '2022-05-20', '1510', '', '-1484549.02', '0', '0', NULL, NULL),
('129', '13', '3', '2022-05-20', '5010', '', '1892800', '0', '0', NULL, NULL),
('130', '13', '3', '2022-05-20', '1510', '', '-1892800', '0', '0', NULL, NULL),
('131', '10', '1', '2022-05-20', '4010', '', '-8000', '1', '0', NULL, NULL),
('132', '10', '1', '2022-05-20', '4010', '', '-900', '0', '0', NULL, NULL),
('133', '10', '1', '2022-05-20', '1200', '', '8900', '0', '0', '2', '2'),
('134', '12', '2', '2022-05-20', '1065', '', '8900', '0', '0', NULL, NULL),
('135', '12', '2', '2022-05-20', '1200', '', '-8900', '0', '0', '2', '2'),
('136', '25', '12', '2022-05-22', '1510', 'IT-1001', '28392', '0', '0', NULL, NULL),
('137', '25', '12', '2022-05-22', '1550', '', '-28392', '0', '0', NULL, NULL),
('138', '20', '11', '2022-05-22', '2150', '', '4826.64', '0', '0', NULL, NULL),
('139', '20', '11', '2022-05-22', '2100', '', '-33218.64', '0', '0', '3', '1'),
('140', '20', '11', '2022-05-22', '1550', '', '28392', '0', '0', NULL, NULL),
('141', '22', '5', '2022-05-22', '2100', '', '26108753.22', '0', '0', '3', '1'),
('142', '22', '5', '2022-05-22', '1060', '', '-26108753.22', '0', '0', NULL, NULL),
('143', '25', '13', '2022-05-22', '1510', '9787', '567840', '0', '0', NULL, NULL),
('144', '25', '13', '2022-05-22', '1510', '78540', '3785600', '1', '0', NULL, NULL),
('145', '25', '13', '2022-05-22', '1550', '', '-4353440', '0', '0', NULL, NULL),
('146', '20', '12', '2022-05-22', '2150', '', '740084.8', '0', '0', NULL, NULL),
('147', '20', '12', '2022-05-22', '2100', '', '-5093524.8', '0', '0', '3', '2'),
('148', '20', '12', '2022-05-22', '1550', '', '567840', '0', '0', NULL, NULL),
('149', '20', '12', '2022-05-22', '1550', '', '3785600', '1', '0', NULL, NULL),
('150', '25', '14', '2022-06-02', '1510', '9787', '6056960', '0', '0', NULL, NULL),
('151', '25', '14', '2022-06-02', '1550', '', '-6056960', '0', '0', NULL, NULL),
('152', '25', '15', '2022-06-03', '1510', '9787', '141960000', '0', '0', NULL, NULL),
('153', '25', '15', '2022-06-03', '1510', 'T-0004', '1892800', '0', '0', NULL, NULL),
('154', '25', '15', '2022-06-03', '1550', '', '-143852800', '0', '0', NULL, NULL),
('155', '25', '16', '2022-06-06', '1510', '201', '328205.13', '1', '0', NULL, NULL),
('156', '25', '16', '2022-06-06', '1550', '', '-328205.13', '0', '0', NULL, NULL),
('157', '13', '4', '2022-06-08', '5010', '', '5678400', '1', '0', NULL, NULL),
('158', '13', '4', '2022-06-08', '1510', '', '-5678400', '0', '0', NULL, NULL),
('159', '10', '2', '2022-06-08', '4010', '', '-10000', '1', '0', NULL, NULL),
('160', '10', '2', '2022-06-08', '1200', '', '10000', '0', '0', '2', '2'),
('161', '12', '3', '2022-06-08', '1065', '', '10000', '0', '0', NULL, NULL),
('162', '12', '3', '2022-06-08', '1200', '', '-10000', '0', '0', '2', '2'),
('163', '13', '5', '2022-06-08', '5010', '', '20947202.12', '0', '0', NULL, NULL),
('164', '13', '5', '2022-06-08', '1510', '', '-20947202.12', '0', '0', NULL, NULL),
('165', '10', '3', '2022-06-08', '4010', '', '-50000', '0', '0', NULL, NULL),
('166', '10', '3', '2022-06-08', '1200', '', '58500', '0', '0', '2', '3'),
('167', '10', '3', '2022-06-08', '2150', '', '-8500', '0', '0', NULL, NULL),
('168', '13', '6', '2022-06-08', '5010', '', '946400', '0', '0', NULL, NULL),
('169', '13', '6', '2022-06-08', '1510', '', '-946400', '0', '0', NULL, NULL),
('170', '10', '4', '2022-06-08', '4010', '', '-5000', '0', '0', NULL, NULL),
('171', '10', '4', '2022-06-08', '1200', '', '5850', '0', '0', '2', '3'),
('172', '10', '4', '2022-06-08', '2150', '', '-850', '0', '0', NULL, NULL),
('173', '25', '17', '2022-06-09', '1510', '201', '1589952', '1', '0', NULL, NULL),
('174', '25', '17', '2022-06-09', '1550', '', '-1589952', '0', '0', NULL, NULL),
('175', '13', '7', '2022-06-09', '5010', '', '2569614.68', '0', '0', NULL, NULL),
('176', '13', '7', '2022-06-09', '1510', '', '-2569614.68', '0', '0', NULL, NULL),
('177', '10', '5', '2022-06-09', '4010', '', '-40000', '0', '0', NULL, NULL),
('178', '10', '5', '2022-06-09', '1200', '', '52650', '0', '0', '2', '1'),
('179', '10', '5', '2022-06-09', '4430', '', '-5000', '0', '0', NULL, NULL),
('180', '10', '5', '2022-06-09', '2150', '', '-7650', '0', '0', NULL, NULL),
('181', '12', '4', '2022-06-09', '1065', '', '52650', '0', '0', NULL, NULL),
('182', '12', '4', '2022-06-09', '1200', '', '-52650', '0', '0', '2', '1'),
('183', '12', '5', '2022-06-09', '1060', '', '1892800', '0', '0', NULL, NULL),
('184', '12', '5', '2022-06-09', '1200', '', '-10000', '0', '0', '2', '3'),
('185', '12', '5', '2022-06-09', '4450', '', '-1882800', '0', '0', NULL, NULL),
('186', '0', '7', '2022-06-09', '1060', 'Overhead Cost', '-1000', '0', '0', NULL, NULL),
('187', '0', '7', '2022-06-09', '1530', 'Overhead Cost', '1000', '0', '0', NULL, NULL),
('188', '0', '8', '2022-06-09', '1060', 'Labour Cost', '-500', '0', '0', NULL, NULL),
('189', '0', '8', '2022-06-09', '1530', 'Labour Cost', '500', '0', '0', NULL, NULL),
('190', '29', '5', '2022-06-09', '1510', '06/09/2022: 1 * abc', '-946400', '0', '0', NULL, NULL),
('191', '29', '5', '2022-06-09', '1510', '06/09/2022: 1 * asad', '-1538560.89', '0', '0', NULL, NULL),
('192', '29', '5', '2022-06-09', '1530', '06/09/2022: 1 * asad', '2484960.89', '0', '0', NULL, NULL),
('193', '26', '5', '2022-06-09', '1530', '', '-2486460.89', '0', '0', NULL, NULL),
('194', '26', '5', '2022-06-09', '1510', '', '2486460.89', '0', '0', NULL, NULL),
('195', '0', '9', '2022-06-10', '1060', 'Overhead Cost', '-600', '0', '0', NULL, NULL),
('196', '0', '9', '2022-06-10', '1530', 'Overhead Cost', '600', '0', '0', NULL, NULL),
('197', '0', '10', '2022-06-10', '1060', 'Labour Cost', '-1000', '0', '0', NULL, NULL),
('198', '0', '10', '2022-06-10', '1530', 'Labour Cost', '1000', '0', '0', NULL, NULL),
('199', '29', '6', '2022-06-10', '1510', '06/10/2022: 1 * Cap', '-4732000', '0', '0', NULL, NULL),
('200', '29', '6', '2022-06-10', '1510', '06/10/2022: 2 * Sticker', '-1135680', '0', '0', NULL, NULL),
('201', '29', '6', '2022-06-10', '1510', '06/10/2022: 1 * Carton', '-132929.47', '0', '0', NULL, NULL),
('202', '29', '6', '2022-06-10', '1530', '06/10/2022: 1 * Carton', '6000609.47', '0', '0', NULL, NULL),
('203', '26', '6', '2022-06-10', '1530', '', '-6002209.47', '0', '0', NULL, NULL),
('204', '26', '6', '2022-06-10', '1510', '', '6002209.47', '0', '0', NULL, NULL),
('205', '25', '18', '2022-06-15', '1510', 'T-0002', '946400', '0', '0', NULL, NULL),
('206', '25', '18', '2022-06-15', '1550', '', '-946400', '0', '0', NULL, NULL),
('207', '20', '13', '2022-06-15', '2150', '', '160888', '0', '0', NULL, NULL),
('208', '20', '13', '2022-06-15', '2100', '', '-1107288', '0', '0', '3', '2'),
('209', '20', '13', '2022-06-15', '1550', '', '946400', '0', '0', NULL, NULL),
('210', '0', '11', '2022-07-14', '1060', 'Exchange Variance', '1.52', '0', '0', NULL, NULL),
('211', '0', '11', '2022-07-14', '4450', 'Exchange Variance', '-1.52', '0', '0', NULL, NULL),
('212', '0', '12', '2022-07-14', '1065', 'Exchange Variance', '-0.27', '0', '0', NULL, NULL),
('213', '0', '12', '2022-07-14', '4450', 'Exchange Variance', '0.27', '0', '0', NULL, NULL),
('214', '1', '2', '2022-07-16', '1060', 'Bank Payout', '-58483.87', '0', '0', NULL, NULL),
('215', '1', '2', '2022-07-16', '5410', 'Bank Payout #003-Umar', '58483.87', '0', '0', '6', '003'),
('245', '1', '3', '2022-02-01', '1060', 'Bank Payout', '-199548.38', '0', '0', NULL, NULL),
('246', '1', '3', '2022-02-01', '5410', 'Bank Payout #004-Zaroon', '121612.9', '0', '0', '6', '004'),
('247', '1', '3', '2022-02-01', '5410', 'Bank Payout #005-Noor', '77935.48', '0', '0', '6', '005'),
('248', '1', '4', '2022-02-01', '1060', 'Employee Loan Amount #005-Noor', '0', '0', '0', NULL, NULL),
('277', '1', '5', '2022-07-16', '1060', 'Bank Payout', '-80000', '0', '0', NULL, NULL),
('278', '1', '5', '2022-07-16', '5410', 'Bank Payout #005-Noor', '80000', '0', '0', '6', '005'),
('279', '1', '6', '2022-01-01', '1060', 'Employee Loan Amount #005-Noor', '0', '0', '0', NULL, NULL),
('324', '99', '3', '2022-07-19', '1060', 'Employee Salary #0001-Noman khan', '40478.63', '0', '0', NULL, NULL),
('325', '99', '3', '2022-07-19', '5410', 'Employee Salary #0001-Noman khan', '-40478.63', '0', '0', NULL, NULL),
('326', '99', '3', '2022-07-19', '1060', 'Employee Salary #0001-Noman khan', '20000', '0', '0', '6', '0001'),
('327', '99', '3', '2022-07-19', '5410', 'Employee Salary #0001-Noman khan', '-20000', '0', '0', '6', '0001'),
('328', '99', '3', '2022-07-19', '1060', 'Employee Salary #0001-Noman khan', '0', '0', '0', '6', '0001'),
('329', '99', '3', '2022-07-19', '5410', 'Employee Salary #0001-Noman khan', '0', '0', '0', '6', '0001'),
('330', '99', '3', '2022-07-19', '1060', 'Employee Salary #0001-Noman khan', '1500', '0', '0', '6', '0001'),
('331', '99', '3', '2022-07-19', '5410', 'Employee Salary #0001-Noman khan', '-1500', '0', '0', '6', '0001'),
('332', '99', '3', '2022-07-19', '1060', 'Employee Salary #0001-Noman khan', '0', '0', '0', '6', '0001'),
('333', '99', '3', '2022-07-19', '5410', 'Employee Salary #0001-Noman khan', '0', '0', '0', '6', '0001'),
('334', '99', '3', '2022-07-19', '1060', 'Employee Salary #0001-Noman khan', '0', '0', '0', '6', '0001'),
('335', '99', '3', '2022-07-19', '5440', 'Employee Salary #0001-Noman khan', '0', '0', '0', '6', '0001'),
('336', '99', '3', '2022-07-19', '1060', 'Employee Salary #0001-Noman khan', '0', '0', '0', '6', '0001'),
('337', '99', '3', '2022-07-19', '5410', 'Employee Salary #0001-Noman khan', '0', '0', '0', '6', '0001');

### Structure of table `0_grn_batch` ###

DROP TABLE IF EXISTS `0_grn_batch`;

CREATE TABLE `0_grn_batch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `purch_order_no` int(11) DEFAULT NULL,
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `rate` double DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `delivery_date` (`delivery_date`),
  KEY `purch_order_no` (`purch_order_no`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_batch` ###

INSERT INTO `0_grn_batch` VALUES
('1', '1', '2', '001/2022', '2022-05-11', 'DEF', '189.28'),
('2', '3', '3', 'auto', '2022-05-17', 'DEF', '189.28'),
('3', '1', '4', 'auto', '2022-05-17', 'DEF', '189.28'),
('4', '1', '5', 'auto', '2022-05-17', 'DEF', '189.28'),
('5', '1', '6', 'auto', '2022-05-17', 'DEF', '189.28'),
('6', '1', '7', 'auto', '2022-05-17', 'DEF', '189.28'),
('7', '3', '9', '002/2022', '2022-05-19', 'DEF', '189.28'),
('8', '1', '10', 'auto', '2022-05-20', 'DEF', '189.28'),
('9', '1', '11', 'auto', '2022-05-20', 'DEF', '189.28'),
('10', '2', '13', '003/2022', '2022-05-20', 'DEF', '189.28'),
('11', '3', '14', 'auto', '2022-05-20', 'DEF', '189.28'),
('12', '1', '1', '004/2022', '2022-05-22', 'DEF', '189.28'),
('13', '2', '12', '005/2022', '2022-05-22', 'DEF', '189.28'),
('14', '1', '22', '006/2022', '2022-06-02', 'DEF', '189.28'),
('15', '3', '23', '007/2022', '2022-06-03', 'DEF', '189.28'),
('16', '4', '24', '008/2022', '2022-06-06', 'DEF', '1'),
('17', '1', '26', '009/2022', '2022-06-09', 'DEF', '189.28'),
('18', '2', '30', '010/2022', '2022-06-15', 'DEF', '189.28');

### Structure of table `0_grn_items` ###

DROP TABLE IF EXISTS `0_grn_items`;

CREATE TABLE `0_grn_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grn_batch_id` int(11) DEFAULT NULL,
  `po_detail_item` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty_recd` double NOT NULL DEFAULT 0,
  `quantity_inv` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `grn_batch_id` (`grn_batch_id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_grn_items` ###

INSERT INTO `0_grn_items` VALUES
('1', '1', '2', '14121', 'gum ', '10', '10'),
('2', '2', '3', '201', 'Cement', '5000', '5000'),
('3', '2', '4', '9787', 'Chemical 1', '1000', '1000'),
('4', '2', '5', '20147', 'Silicon', '1000', '1000'),
('5', '3', '6', 'T-0002', 'Cap', '10000', '10000'),
('6', '4', '7', 'T-0003', 'Sticker', '10000', '10000'),
('7', '5', '8', 'T-0004', 'Carton', '1', '1'),
('8', '6', '9', 'T-0004', 'Carton', '1000', '1000'),
('9', '7', '11', '201', 'Cement', '100', '0'),
('10', '7', '12', '9787', 'Chemical 1', '50', '0'),
('11', '8', '13', '101', 'abc', '1000', '1000'),
('12', '9', '14', '1202', 'asad', '1000', '1000'),
('13', '10', '17', '9787', 'Chemical 1', '10', '10'),
('14', '10', '18', '78540', 'MG 17', '100', '100'),
('15', '11', '19', 'T-0004', 'Carton', '10', '10'),
('16', '11', '20', '1202', 'asad', '15', '15'),
('17', '11', '21', 'T-0004', 'Carton', '10', '10'),
('18', '12', '1', 'IT-1001', 'New item A', '1', '1'),
('19', '13', '15', '9787', 'Chemical 1', '20', '20'),
('20', '13', '16', '78540', 'MG 17', '50', '50'),
('21', '14', '31', '9787', 'Chemical 1', '25', '0'),
('22', '15', '32', '9787', 'Chemical 1', '100', '0'),
('23', '15', '33', 'T-0004', 'Carton', '100', '0'),
('24', '16', '34', '201', 'Cement', '400', '0'),
('25', '17', '37', '201', 'Cement', '500', '0'),
('26', '18', '42', 'T-0002', 'Cap', '1', '1');

### Structure of table `0_groups` ###

DROP TABLE IF EXISTS `0_groups`;

CREATE TABLE `0_groups` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_groups` ###

INSERT INTO `0_groups` VALUES
('1', 'Small', '0'),
('2', 'Medium', '0'),
('3', 'Large', '0');

### Structure of table `0_item_codes` ###

DROP TABLE IF EXISTS `0_item_codes`;

CREATE TABLE `0_item_codes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` smallint(6) unsigned NOT NULL,
  `quantity` double NOT NULL DEFAULT 1,
  `is_foreign` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stock_id` (`stock_id`,`item_code`),
  KEY `item_code` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_codes` ###

INSERT INTO `0_item_codes` VALUES
('1', '101', '101', 'abc', '1', '1', '0', '0'),
('2', '1202', '1202', 'asad', '1', '1', '0', '0'),
('3', '187', '187', 'KFT', '1', '1', '0', '0'),
('4', 'T-0001', 'T-0001', 'First Item', '3', '1', '0', '0'),
('5', 'T-0002', 'T-0002', 'Cap', '1', '1', '0', '0'),
('6', 'T-0003', 'T-0003', 'Sticker', '1', '1', '0', '0'),
('7', 'T-0004', 'T-0004', 'Carton', '1', '1', '0', '0'),
('8', 'F-001', 'F-001', 'Generator', '5', '1', '0', '0'),
('9', 'IT-1001', 'IT-1001', 'New item A', '1', '1', '0', '0'),
('10', '14121', '14121', 'gum ', '2', '1', '0', '0'),
('11', '78540', '78540', 'MG 17', '1', '1', '0', '0'),
('12', '201', '201', 'Cement', '1', '1', '0', '0'),
('13', '20147', '20147', 'Silicon', '1', '1', '0', '0'),
('14', '9787', '9787', 'Chemical 1', '1', '1', '0', '0');

### Structure of table `0_item_tax_type_exemptions` ###

DROP TABLE IF EXISTS `0_item_tax_type_exemptions`;

CREATE TABLE `0_item_tax_type_exemptions` (
  `item_tax_type_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`item_tax_type_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_type_exemptions` ###


### Structure of table `0_item_tax_types` ###

DROP TABLE IF EXISTS `0_item_tax_types`;

CREATE TABLE `0_item_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `exempt` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_tax_types` ###

INSERT INTO `0_item_tax_types` VALUES
('1', 'Regular', '0', '0');

### Structure of table `0_item_units` ###

DROP TABLE IF EXISTS `0_item_units`;

CREATE TABLE `0_item_units` (
  `abbr` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `decimals` tinyint(2) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`abbr`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_item_units` ###

INSERT INTO `0_item_units` VALUES
('BG', 'Bag', '4', '0'),
('each', 'Each', '0', '0'),
('GRM', 'GRM', '4', '0'),
('hr', 'Hours', '0', '0'),
('KG', 'KG', '4', '0'),
('MT', 'MT', '4', '0');

### Structure of table `0_journal` ###

DROP TABLE IF EXISTS `0_journal`;

CREATE TABLE `0_journal` (
  `type` smallint(6) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `tran_date` date DEFAULT '0000-00-00',
  `reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `source_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `event_date` date DEFAULT '0000-00-00',
  `doc_date` date NOT NULL DEFAULT '0000-00-00',
  `currency` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `amount` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_journal` ###

INSERT INTO `0_journal` VALUES
('0', '1', '2022-05-17', '001/2022', '', '2022-05-17', '2022-05-17', 'PKR', '50000', '1'),
('0', '2', '2022-05-17', '002/2022', '', '2022-05-17', '2022-05-17', 'PKR', '60000', '1'),
('0', '3', '2022-05-20', '003/2022', '', '2022-05-20', '2022-05-20', 'PKR', '120', '1'),
('0', '4', '2022-05-20', '004/2022', '', '2022-05-20', '2022-05-20', 'PKR', '240', '1'),
('0', '5', '2022-05-20', '005/2022', '', '2022-05-20', '2022-05-20', 'PKR', '5000', '1'),
('0', '6', '2022-05-20', '006/2022', '', '2022-05-20', '2022-05-20', 'PKR', '4000', '1'),
('0', '7', '2022-06-09', '007/2022', '', '2022-06-09', '2022-06-09', 'PKR', '1000', '1'),
('0', '8', '2022-06-09', '008/2022', '', '2022-06-09', '2022-06-09', 'PKR', '500', '1'),
('0', '9', '2022-06-10', '009/2022', '', '2022-06-10', '2022-06-10', 'PKR', '600', '1'),
('0', '10', '2022-06-10', '010/2022', '', '2022-06-10', '2022-06-10', 'PKR', '1000', '1'),
('0', '11', '2022-07-14', '011/2022', '', '2022-07-14', '2022-07-14', 'PKR', '-1.5200004577637', '1'),
('0', '12', '2022-07-14', '012/2022', '', '2022-07-14', '2022-07-14', 'PKR', '0.27000000000407', '1');

### Structure of table `0_kv_empl_advance_payments` ###

DROP TABLE IF EXISTS `0_kv_empl_advance_payments`;

CREATE TABLE `0_kv_empl_advance_payments` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `month` int(2) NOT NULL,
  `date` date NOT NULL,
  `year` int(3) NOT NULL,
  `amount` double NOT NULL,
  `purpose` text COLLATE utf8_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_advance_payments` ###


### Structure of table `0_kv_empl_allowance_advanced` ###

DROP TABLE IF EXISTS `0_kv_empl_allowance_advanced`;

CREATE TABLE `0_kv_empl_allowance_advanced` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `allowance_id` int(11) NOT NULL,
  `grade_id` int(11) NOT NULL,
  `formula` text NOT NULL,
  `value` varchar(20) NOT NULL,
  `percentage` double NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_allowance_advanced` ###

INSERT INTO `0_kv_empl_allowance_advanced` VALUES
('4', '4', '1', '({$gros})/2', 'Formula', '0'),
('6', '6', '1', '1500', 'Formula', '0'),
('14', '2', '2', '({$gros})*(0.4)', 'Formula', '0'),
('15', '3', '2', '', 'Profile Input', '0'),
('16', '4', '2', '({$gros})*(0.4*0.5)', 'Formula', '0'),
('17', '11', '2', '', 'Profile Input', '0'),
('18', '12', '2', '', 'Profile Input', '0'),
('19', '13', '2', '', 'Profile Input', '0'),
('20', '2', '3', '({$gros})*(0.4)', 'Formula', '0'),
('21', '3', '3', '', 'Profile Input', '0'),
('22', '4', '3', '({$gros})*(0.4*0.5)', 'Formula', '0'),
('23', '11', '3', '', 'Profile Input', '0'),
('24', '12', '3', '', 'Profile Input', '0'),
('25', '13', '3', '', 'Profile Input', '0'),
('26', '5', '3', '3000', 'Formula', '0'),
('27', '14', '3', '5000', 'Formula', '0'),
('28', '7', '3', '({$gros})*(0.4)*(0.0833)', 'Formula', '0'),
('29', '8', '3', '({$gros})-({$basi}+{$hraa}+{$conv}+{$medi}+{$bons})', 'Formula', '0'),
('30', '5', '2', '2000', 'Formula', '0'),
('31', '6', '2', '4000', 'Formula', '0'),
('32', '7', '2', '({$gros})*(0.4)*(0.0833)', 'Formula', '0'),
('33', '8', '2', '({$gros})-({$basi}+{$hraa}+{$conv}+{$medi}+{$bons})', 'Formula', '0'),
('34', '2', '1', '({$gros})*(0.4)', 'Formula', '0'),
('35', '3', '1', '', 'Profile Input', '0'),
('36', '3', '4', '', 'Profile Input', '0'),
('37', '8', '4', '', 'Profile Input', '0');

### Structure of table `0_kv_empl_allowances` ###

DROP TABLE IF EXISTS `0_kv_empl_allowances`;

CREATE TABLE `0_kv_empl_allowances` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `debit_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `credit_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `unique_name` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `type` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `basic` int(11) DEFAULT NULL,
  `Tax` int(2) NOT NULL,
  `loan` tinyint(1) NOT NULL,
  `esic` tinyint(1) NOT NULL,
  `pf` tinyint(1) NOT NULL,
  `al_type` int(3) NOT NULL DEFAULT 0,
  `gross` tinyint(1) NOT NULL,
  `sort_order` int(3) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_allowances` ###

INSERT INTO `0_kv_empl_allowances` VALUES
('2', '', '', 'basi', 'Basic', 'Earnings', '1', '0', '0', '0', '0', '0', '0', '1', '0'),
('3', '1060', '5410', 'gros', 'Gross Pay', 'Earnings', '0', '0', '0', '0', '0', '0', '1', '2', '0'),
('4', '1060', '5410', 'hraa', 'House Rent Allowance', 'Earnings', '0', '0', '0', '0', '0', '0', '0', '3', '0'),
('5', '1060', '5410', 'conv', 'Conveyance ', 'Earnings', '0', '0', '0', '0', '0', '0', '0', '4', '0'),
('6', '1060', '5410', 'medi', 'Medical Allowance ', 'Earnings', '0', '0', '0', '0', '0', '0', '0', '5', '0'),
('7', '1060', '5410', 'bons', 'Bonus', 'Earnings', '0', '0', '0', '0', '0', '0', '0', '6', '0'),
('8', '1060', '1205', 'spcl', 'Special Allowance', 'Earnings', '0', '0', '0', '0', '0', '0', '0', '7', '0'),
('11', '1060', '5440', 'ptax', 'Professional Tax', 'Deductions', '0', '1', '0', '0', '0', '0', '0', '8', '0'),
('12', '', '', 'tax1', 'Tax1', 'Deductions', '0', '1', '0', '0', '0', '0', '0', '9', '0'),
('13', '', '', 'loan', 'Loan', 'Deductions', '0', '0', '1', '0', '0', '0', '0', '10', '0'),
('14', '1060', '5410', 'medi', '', 'Earnings', '0', '0', '0', '0', '0', '0', '0', '5', '0');

### Structure of table `0_kv_empl_allowances_coa` ###

DROP TABLE IF EXISTS `0_kv_empl_allowances_coa`;

CREATE TABLE `0_kv_empl_allowances_coa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `empl_id` int(11) NOT NULL,
  `accrual_salary_wage` varchar(15) NOT NULL,
  `bank_salary_wage` varchar(15) NOT NULL,
  `accrual_lmra_fees` varchar(15) NOT NULL,
  `bank_lmra_fees` varchar(15) NOT NULL,
  `accrual_social_security` varchar(15) NOT NULL,
  `bank_social_security` varchar(15) NOT NULL,
  `prepaid_medical_expenses` varchar(15) NOT NULL,
  `bank_medical_expenses` varchar(15) NOT NULL,
  `prepaid_visa_expenses` varchar(15) NOT NULL,
  `bank_visa_expenses` varchar(15) NOT NULL,
  `accrual_leave_travel` varchar(15) NOT NULL,
  `bank_leave_travel` varchar(15) NOT NULL,
  `accrual_leave_pay` varchar(15) NOT NULL,
  `bank_leave_pay` varchar(15) NOT NULL,
  `accrual_indemnity` varchar(15) NOT NULL,
  `bank_indemnity` varchar(15) NOT NULL,
  `prepaid_insurance` varchar(15) NOT NULL,
  `bank_insurance` varchar(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_allowances_coa` ###


### Structure of table `0_kv_empl_appraisal` ###

DROP TABLE IF EXISTS `0_kv_empl_appraisal`;

CREATE TABLE `0_kv_empl_appraisal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(20) NOT NULL,
  `empl_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `status` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_appraisal` ###


### Structure of table `0_kv_empl_attendance` ###

DROP TABLE IF EXISTS `0_kv_empl_attendance`;

CREATE TABLE `0_kv_empl_attendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `shift` int(11) NOT NULL DEFAULT 0,
  `a_date` date NOT NULL,
  `in_time` time NOT NULL,
  `out_time` time NOT NULL,
  `dimension` int(11) NOT NULL DEFAULT 0,
  `dimension2` int(11) NOT NULL DEFAULT 0,
  `duration` int(11) NOT NULL,
  `ot` int(11) NOT NULL DEFAULT 0,
  `sot` int(11) NOT NULL DEFAULT 0,
  `description` mediumtext COLLATE utf8_unicode_ci DEFAULT NULL,
  `def_time` int(11) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1711 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_attendance` ###

INSERT INTO `0_kv_empl_attendance` VALUES
('1', '18', 'P', '0', '2022-09-01', '17:34:37', '06:35:00', '0', '0', '19789', '0', '0', NULL, '0', '0'),
('2', '87', 'P', '0', '2022-09-01', '07:24:08', '06:35:00', '0', '0', '1474', '6037', '0', NULL, '0', '0'),
('3', '187', 'P', '0', '2022-09-01', '08:02:00', '06:35:00', '0', '0', '81180', '0', '0', NULL, '0', '0'),
('4', '20', 'P', '0', '2022-09-01', '07:34:00', '06:35:00', '0', '0', '1770', '1154', '0', NULL, '0', '0'),
('5', '177', 'P', '0', '2022-09-01', '11:15:08', '06:35:00', '0', '0', '8404', '4642', '0', NULL, '0', '0'),
('6', '51', 'P', '0', '2022-09-01', '18:00:11', '06:35:00', '0', '0', '20556', '11', '0', NULL, '0', '0'),
('7', '189', 'P', '0', '2022-09-01', '07:44:00', '18:16:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('8', '139', 'P', '0', '2022-09-01', '17:59:00', '18:07:00', '0', '0', '60', '0', '0', NULL, '0', '0'),
('9', '181', 'P', '0', '2022-09-01', '18:00:18', '06:35:00', '0', '0', '20559', '18', '0', NULL, '0', '0'),
('10', '171', 'P', '0', '2022-09-01', '17:59:02', '06:35:00', '0', '0', '20521', '0', '0', NULL, '0', '0'),
('11', '6', 'P', '0', '2022-09-01', '07:47:53', '06:35:00', '0', '0', '2187', '3912', '0', NULL, '0', '0'),
('12', '46', 'P', '0', '2022-09-01', '18:00:00', '06:35:00', '0', '0', '45300', '0', '0', NULL, '0', '0'),
('13', '75', 'P', '0', '2022-09-01', '07:48:00', '06:35:00', '0', '0', '81300', '0', '0', NULL, '0', '0'),
('14', '53', 'P', '0', '2022-09-01', '17:58:37', '06:35:00', '0', '0', '20509', '0', '0', NULL, '0', '0'),
('15', '32', 'P', '0', '2022-09-01', '17:59:11', '06:35:00', '0', '0', '20526', '0', '0', NULL, '0', '0'),
('16', '30', 'P', '0', '2022-09-01', '18:01:19', '06:35:00', '0', '0', '20590', '79', '0', NULL, '0', '0'),
('17', '109', 'P', '0', '2022-09-01', '07:50:58', '06:35:00', '0', '0', '2279', '441', '0', NULL, '0', '0'),
('18', '161', 'P', '0', '2022-09-01', '18:01:04', '06:35:00', '0', '0', '20582', '64', '0', NULL, '0', '0'),
('19', '143', 'P', '0', '2022-09-01', '17:59:25', '06:35:00', '0', '0', '20533', '0', '0', NULL, '0', '0'),
('20', '147', 'P', '0', '2022-09-01', '18:00:53', '06:35:00', '0', '0', '20577', '53', '0', NULL, '0', '0'),
('21', '17', 'P', '0', '2022-09-01', '07:52:20', '06:35:00', '0', '0', '2320', '473', '0', NULL, '0', '0'),
('22', '7', 'P', '0', '2022-09-01', '07:52:29', '06:35:00', '0', '0', '2325', '3942', '0', NULL, '0', '0'),
('23', '50', 'P', '0', '2022-09-01', '18:00:21', '06:35:00', '0', '0', '20561', '21', '0', NULL, '0', '0'),
('24', '8', 'P', '0', '2022-09-01', '07:52:00', '06:35:00', '0', '0', '81300', '0', '0', NULL, '0', '0'),
('25', '21', 'P', '0', '2022-09-01', '07:52:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('26', '64', 'P', '0', '2022-09-01', '07:53:00', '06:35:00', '0', '0', '81300', '0', '0', NULL, '0', '0'),
('27', '152', 'P', '0', '2022-09-01', '18:00:59', '06:35:00', '0', '0', '20580', '59', '0', NULL, '0', '0'),
('28', '121', 'P', '0', '2022-09-01', '17:58:51', '06:35:00', '0', '0', '20516', '0', '0', NULL, '0', '0'),
('29', '14', 'P', '0', '2022-09-01', '07:55:39', '06:35:00', '0', '0', '2420', '326', '0', NULL, '0', '0'),
('30', '183', 'P', '0', '2022-09-01', '07:55:00', '18:17:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('31', '47', 'P', '0', '2022-09-01', '07:56:00', '19:30:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('32', '182', 'P', '0', '2022-09-01', '07:56:25', '06:35:00', '0', '0', '2443', '0', '0', NULL, '0', '0'),
('33', '15', 'P', '0', '2022-09-01', '07:57:08', '06:35:00', '0', '0', '2464', '446', '0', NULL, '0', '0'),
('34', '25', 'P', '0', '2022-09-01', '17:59:29', '06:35:00', '0', '0', '20535', '0', '0', NULL, '0', '0'),
('35', '43', 'P', '0', '2022-09-01', '18:00:00', '06:35:00', '0', '0', '45300', '0', '0', NULL, '0', '0'),
('36', '61', 'P', '0', '2022-09-01', '18:00:48', '06:35:00', '0', '0', '20574', '48', '0', NULL, '0', '0'),
('37', '160', 'P', '0', '2022-09-01', '07:58:17', '06:35:00', '0', '0', '2499', '889', '0', NULL, '0', '0'),
('38', '73', 'P', '0', '2022-09-01', '17:58:48', '06:35:00', '0', '0', '20514', '0', '0', NULL, '0', '0'),
('39', '162', 'P', '0', '2022-09-01', '17:58:42', '06:35:00', '0', '0', '20511', '0', '0', NULL, '0', '0'),
('40', '65', 'P', '0', '2022-09-01', '17:50:03', '06:35:00', '0', '0', '20252', '0', '0', NULL, '0', '0'),
('41', '70', 'P', '0', '2022-09-01', '18:00:37', '06:35:00', '0', '0', '20569', '37', '0', NULL, '0', '0'),
('42', '35', 'P', '0', '2022-09-01', '17:59:00', '06:35:00', '0', '0', '45360', '0', '0', NULL, '0', '0'),
('43', '67', 'P', '0', '2022-09-01', '07:59:23', '06:35:00', '0', '0', '2532', '92', '0', NULL, '0', '0'),
('44', '148', 'P', '0', '2022-09-01', '18:00:41', '06:35:00', '0', '0', '20571', '41', '0', NULL, '0', '0'),
('45', '128', 'P', '0', '2022-09-01', '08:01:34', '06:35:00', '0', '0', '2597', '214', '0', NULL, '0', '0'),
('46', '22', 'P', '0', '2022-09-01', '18:01:15', '06:35:00', '0', '0', '20588', '75', '0', NULL, '0', '0'),
('47', '60', 'P', '0', '2022-09-01', '18:00:01', '06:35:00', '0', '0', '20551', '1', '0', NULL, '0', '0'),
('48', '111', 'P', '0', '2022-09-01', '08:01:00', '18:17:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('49', '57', 'P', '0', '2022-09-01', '18:00:08', '06:35:00', '0', '0', '20554', '8', '0', NULL, '0', '0'),
('50', '13', 'P', '0', '2022-09-01', '08:03:58', '06:35:00', '0', '0', '2669', '0', '0', NULL, '0', '0'),
('51', '82', 'P', '0', '2022-09-01', '08:07:10', '06:35:00', '0', '0', '2765', '0', '0', NULL, '0', '0'),
('52', '31', 'P', '0', '2022-09-01', '08:07:33', '06:35:00', '0', '0', '2777', '88', '0', NULL, '0', '0'),
('53', '170', 'P', '0', '2022-09-01', '08:07:40', '06:35:00', '0', '0', '2780', '102', '0', NULL, '0', '0'),
('54', '28', 'P', '0', '2022-09-01', '18:00:44', '06:35:00', '0', '0', '20572', '44', '0', NULL, '0', '0'),
('55', '12', 'P', '0', '2022-09-01', '08:08:03', '06:35:00', '0', '0', '2792', '732', '0', NULL, '0', '0'),
('56', '69', 'P', '0', '2022-09-01', '17:58:30', '06:35:00', '0', '0', '20505', '0', '0', NULL, '0', '0'),
('57', '118', 'P', '0', '2022-09-01', '17:58:40', '06:35:00', '0', '0', '20510', '0', '0', NULL, '0', '0'),
('58', '112', 'P', '0', '2022-09-01', '08:15:00', '18:20:00', '0', '0', '35100', '0', '0', NULL, '0', '0'),
('59', '23', 'P', '0', '2022-09-01', '17:59:08', '06:35:00', '0', '0', '20524', '0', '0', NULL, '0', '0'),
('60', '88', 'P', '0', '2022-09-01', '17:58:59', '06:35:00', '0', '0', '20520', '0', '0', NULL, '0', '0'),
('61', '2', 'P', '0', '2022-09-01', '09:15:26', '06:35:00', '0', '0', '4813', '2490', '0', NULL, '0', '0'),
('62', '4', 'P', '0', '2022-09-01', '09:15:00', '06:35:00', '0', '0', '76800', '0', '0', NULL, '0', '0'),
('63', '16', 'P', '0', '2022-09-01', '09:29:33', '06:35:00', '0', '0', '5237', '4633', '0', NULL, '0', '0'),
('64', '103', 'P', '0', '2022-09-01', '09:15:00', '06:35:00', '0', '0', '76800', '0', '0', NULL, '0', '0'),
('65', '1', 'P', '0', '2022-09-01', '09:15:00', '06:35:00', '0', '0', '76800', '0', '0', NULL, '0', '0'),
('66', '5', 'P', '0', '2022-09-01', '09:56:20', '06:35:00', '0', '0', '6040', '493', '0', NULL, '0', '0'),
('67', '190', 'P', '0', '2022-09-01', '18:01:10', '06:35:00', '0', '0', '20585', '70', '0', NULL, '0', '0'),
('68', '20', 'P', '0', '2022-09-02', '07:08:35', '19:12:21', '0', '0', '21713', '4341', '0', NULL, '0', '0'),
('69', '87', 'P', '0', '2022-09-02', '07:14:23', '19:12:28', '0', '0', '21543', '4348', '0', NULL, '0', '0'),
('70', '18', 'P', '0', '2022-09-02', '07:27:52', '12:30:13', '0', '0', '9071', '0', '0', NULL, '0', '0'),
('71', '161', 'P', '0', '2022-09-02', '07:39:56', '18:00:12', '0', '0', '18608', '12', '0', NULL, '0', '0'),
('72', '189', 'P', '0', '2022-09-02', '07:41:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('73', '139', 'P', '0', '2022-09-02', '07:41:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('74', '177', 'P', '0', '2022-09-02', '07:44:06', '20:31:12', '0', '0', '23013', '9072', '0', NULL, '0', '0'),
('75', '46', 'P', '0', '2022-09-02', '07:44:00', '18:01:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('76', '187', 'P', '0', '2022-09-02', '07:44:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('77', '130', 'P', '0', '2022-09-02', '07:44:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('78', '47', 'P', '0', '2022-09-02', '07:46:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('79', '70', 'P', '0', '2022-09-02', '07:46:13', '17:59:53', '0', '0', '18410', '0', '0', NULL, '0', '0'),
('80', '181', 'P', '0', '2022-09-02', '07:46:35', '18:00:18', '0', '0', '18412', '18', '0', NULL, '0', '0'),
('81', '35', 'P', '0', '2022-09-02', '07:46:00', '17:59:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('82', '171', 'P', '0', '2022-09-02', '07:47:03', '17:59:26', '0', '0', '18372', '0', '0', NULL, '0', '0'),
('83', '50', 'P', '0', '2022-09-02', '07:47:47', '18:01:14', '0', '0', '18404', '74', '0', NULL, '0', '0'),
('84', '21', 'P', '0', '2022-09-02', '07:48:00', '18:01:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('85', '51', 'P', '0', '2022-09-02', '07:48:12', '18:01:56', '0', '0', '18412', '116', '0', NULL, '0', '0'),
('86', '43', 'P', '0', '2022-09-02', '07:49:00', '07:49:00', '0', '0', '85740', '0', '0', NULL, '0', '0'),
('87', '67', 'P', '0', '2022-09-02', '07:49:11', '17:59:45', '0', '0', '18317', '0', '0', NULL, '0', '0'),
('88', '61', 'P', '0', '2022-09-02', '07:49:19', '18:00:38', '0', '0', '18340', '38', '0', NULL, '0', '0'),
('89', '64', 'P', '0', '2022-09-02', '07:50:00', '17:58:00', '0', '0', '35880', '0', '0', NULL, '0', '0'),
('90', '121', 'P', '0', '2022-09-02', '07:51:08', '17:58:57', '0', '0', '18235', '0', '0', NULL, '0', '0'),
('91', '6', 'P', '0', '2022-09-02', '07:51:18', '18:02:25', '0', '0', '18334', '145', '0', NULL, '0', '0'),
('92', '53', 'P', '0', '2022-09-02', '07:54:28', '17:59:12', '0', '0', '18142', '0', '0', NULL, '0', '0'),
('93', '32', 'P', '0', '2022-09-02', '07:58:03', '12:37:13', '0', '0', '8375', '0', '0', NULL, '0', '0'),
('94', '30', 'P', '0', '2022-09-02', '07:58:09', '17:58:23', '0', '0', '18007', '0', '0', NULL, '0', '0'),
('95', '57', 'P', '0', '2022-09-02', '07:58:16', '18:00:04', '0', '0', '18054', '4', '0', NULL, '0', '0'),
('96', '60', 'P', '0', '2022-09-02', '07:58:25', '18:00:32', '0', '0', '18064', '32', '0', NULL, '0', '0'),
('97', '148', 'P', '0', '2022-09-02', '07:58:48', '18:00:28', '0', '0', '18050', '28', '0', NULL, '0', '0'),
('98', '147', 'P', '0', '2022-09-02', '07:59:12', '18:02:20', '0', '0', '18094', '140', '0', NULL, '0', '0'),
('99', '143', 'P', '0', '2022-09-02', '07:59:31', '18:03:27', '0', '0', '18118', '207', '0', NULL, '0', '0'),
('100', '17', 'P', '0', '2022-09-02', '08:00:00', '18:03:15', '0', '0', '18098', '195', '0', NULL, '0', '0'),
('101', '8', 'P', '0', '2022-09-02', '08:00:00', '18:07:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('102', '69', 'P', '0', '2022-09-02', '08:00:27', '17:59:48', '0', '0', '17981', '0', '0', NULL, '0', '0'),
('103', '88', 'P', '0', '2022-09-02', '08:00:58', '17:59:18', '0', '0', '17950', '0', '0', NULL, '0', '0'),
('104', '25', 'P', '0', '2022-09-02', '08:01:08', '17:59:01', '0', '0', '17937', '0', '0', NULL, '0', '0'),
('105', '190', 'P', '0', '2022-09-02', '08:02:33', '18:00:06', '0', '0', '17927', '6', '0', NULL, '0', '0'),
('106', '75', 'P', '0', '2022-09-02', '08:03:00', '18:03:00', '0', '0', '35820', '0', '0', NULL, '0', '0'),
('107', '160', 'P', '0', '2022-09-02', '08:03:12', '18:01:20', '0', '0', '17944', '80', '0', NULL, '0', '0'),
('108', '152', 'P', '0', '2022-09-02', '08:03:26', '17:58:47', '0', '0', '17861', '0', '0', NULL, '0', '0'),
('109', '73', 'P', '0', '2022-09-02', '08:03:48', '17:59:08', '0', '0', '17860', '0', '0', NULL, '0', '0'),
('110', '186', 'P', '0', '2022-09-02', '08:03:54', '18:09:14', '0', '0', '18160', '554', '0', NULL, '0', '0'),
('111', '162', 'P', '0', '2022-09-02', '08:04:17', '17:58:35', '0', '0', '17829', '0', '0', NULL, '0', '0'),
('112', '112', 'P', '0', '2022-09-02', '08:04:00', '17:58:00', '0', '0', '35640', '0', '0', NULL, '0', '0'),
('113', '128', 'P', '0', '2022-09-02', '08:05:10', '18:05:56', '0', '0', '18023', '356', '0', NULL, '0', '0'),
('114', '38', 'P', '0', '2022-09-02', '08:06:16', '17:58:18', '0', '0', '17761', '0', '0', NULL, '0', '0'),
('115', '14', 'P', '0', '2022-09-02', '08:06:38', '20:32:26', '0', '0', '22374', '9146', '0', NULL, '0', '0'),
('116', '183', 'P', '0', '2022-09-02', '08:06:00', '18:13:00', '0', '0', '35640', '0', '0', NULL, '0', '0'),
('117', '182', 'P', '0', '2022-09-02', '08:07:05', '08:07:05', '0', '0', '0', '0', '0', NULL, '0', '0'),
('118', '118', 'P', '0', '2022-09-02', '08:07:52', '17:59:15', '0', '0', '17742', '0', '0', NULL, '0', '0'),
('119', '22', 'P', '0', '2022-09-02', '08:12:45', '18:00:47', '0', '0', '17641', '47', '0', NULL, '0', '0'),
('120', '82', 'P', '0', '2022-09-02', '08:12:56', '17:58:05', '0', '0', '17555', '0', '0', NULL, '0', '0'),
('121', '23', 'P', '0', '2022-09-02', '08:13:07', '18:01:47', '0', '0', '17660', '107', '0', NULL, '0', '0'),
('122', '31', 'P', '0', '2022-09-02', '08:13:09', '17:59:40', '0', '0', '17596', '0', '0', NULL, '0', '0'),
('123', '170', 'P', '0', '2022-09-02', '08:13:18', '17:59:58', '0', '0', '17600', '0', '0', NULL, '0', '0'),
('124', '28', 'P', '0', '2022-09-02', '08:13:35', '18:00:11', '0', '0', '17598', '11', '0', NULL, '0', '0'),
('125', '65', 'P', '0', '2022-09-02', '08:14:16', '17:59:21', '0', '0', '17553', '0', '0', NULL, '0', '0'),
('126', '13', 'P', '0', '2022-09-02', '08:14:22', '13:17:23', '0', '0', '9091', '0', '0', NULL, '0', '0'),
('127', '12', 'P', '0', '2022-09-02', '08:15:23', '13:15:08', '0', '0', '8993', '0', '0', NULL, '0', '0'),
('128', '109', 'P', '0', '2022-09-02', '08:22:01', '18:05:06', '0', '0', '17493', '306', '0', NULL, '0', '0'),
('129', '2', 'P', '0', '2022-09-02', '09:04:51', '18:23:32', '0', '0', '16761', '1412', '0', NULL, '0', '0'),
('130', '103', 'P', '0', '2022-09-02', '09:11:00', '18:22:00', '0', '0', '31740', '0', '0', NULL, '0', '0'),
('131', '1', 'P', '0', '2022-09-02', '09:11:00', '18:22:00', '0', '0', '31740', '1320', '0', NULL, '0', '0'),
('132', '15', 'P', '0', '2022-09-02', '09:25:44', '18:05:36', '0', '0', '15596', '336', '0', NULL, '0', '0'),
('133', '4', 'P', '0', '2022-09-02', '09:28:00', '18:22:00', '0', '0', '30720', '0', '0', NULL, '0', '0'),
('134', '5', 'P', '0', '2022-09-02', '10:04:28', '18:07:38', '0', '0', '14495', '458', '0', NULL, '0', '0'),
('135', '14', 'P', '0', '2022-09-03', '08:39:48', '21:00:16', '0', '0', '22214', '10816', '0', NULL, '0', '0'),
('136', '177', 'P', '0', '2022-09-03', '08:39:57', '21:00:14', '0', '0', '22209', '10814', '0', NULL, '0', '0'),
('137', '103', 'P', '0', '2022-09-03', '11:34:00', '17:14:00', '0', '0', '20400', '0', '0', NULL, '0', '0'),
('138', '4', 'A', '0', '2022-09-03', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('139', '14', 'P', '0', '2022-09-04', '09:57:50', '21:24:49', '0', '0', '20610', '12289', '0', NULL, '0', '0'),
('140', '177', 'P', '0', '2022-09-04', '09:58:05', '21:24:57', '0', '0', '20606', '12297', '0', NULL, '0', '0'),
('141', '20', 'P', '0', '2022-09-05', '06:56:56', '18:27:20', '0', '0', '20712', '1640', '0', NULL, '0', '0'),
('142', '87', 'P', '0', '2022-09-05', '07:06:36', '21:43:13', '0', '0', '26299', '13393', '0', NULL, '0', '0'),
('143', '21', 'P', '0', '2022-09-05', '07:19:00', '17:41:00', '0', '0', '34860', '0', '0', NULL, '0', '0'),
('144', '50', 'P', '0', '2022-09-05', '07:19:42', '17:41:45', '0', '0', '18662', '0', '0', NULL, '0', '0'),
('145', '18', 'P', '0', '2022-09-05', '07:24:54', '17:30:14', '0', '0', '18160', '0', '0', NULL, '0', '0'),
('146', '23', 'P', '0', '2022-09-05', '07:41:38', '17:56:18', '0', '0', '18440', '0', '0', NULL, '0', '0'),
('147', '46', 'P', '0', '2022-09-05', '07:41:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('148', '51', 'P', '0', '2022-09-05', '07:42:13', '18:04:32', '0', '0', '18670', '272', '0', NULL, '0', '0'),
('149', '183', 'P', '0', '2022-09-05', '07:43:00', '18:54:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('150', '182', 'P', '0', '2022-09-05', '07:43:18', '18:54:12', '0', '0', '20127', '3252', '0', NULL, '0', '0'),
('151', '161', 'P', '0', '2022-09-05', '07:44:35', '18:00:13', '0', '0', '18469', '13', '0', NULL, '0', '0'),
('152', '32', 'P', '0', '2022-09-05', '07:44:57', '17:59:50', '0', '0', '18447', '0', '0', NULL, '0', '0'),
('153', '171', 'P', '0', '2022-09-05', '07:47:09', '17:59:21', '0', '0', '18366', '0', '0', NULL, '0', '0'),
('154', '181', 'P', '0', '2022-09-05', '07:47:15', '17:59:45', '0', '0', '18375', '0', '0', NULL, '0', '0'),
('155', '130', 'P', '0', '2022-09-05', '07:48:00', '17:59:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('156', '25', 'P', '0', '2022-09-05', '07:48:41', '17:58:23', '0', '0', '18291', '0', '0', NULL, '0', '0'),
('157', '109', 'P', '0', '2022-09-05', '07:49:04', '18:01:29', '0', '0', '18373', '89', '0', NULL, '0', '0'),
('158', '30', 'P', '0', '2022-09-05', '07:49:18', '18:02:11', '0', '0', '18387', '131', '0', NULL, '0', '0'),
('159', '47', 'P', '0', '2022-09-05', '07:49:00', '07:49:00', '0', '0', '85740', '0', '0', NULL, '0', '0'),
('160', '75', 'P', '0', '2022-09-05', '07:50:00', '17:58:00', '0', '0', '35880', '0', '0', NULL, '0', '0'),
('161', '121', 'P', '0', '2022-09-05', '07:53:19', '17:58:08', '0', '0', '18145', '0', '0', NULL, '0', '0'),
('162', '64', 'P', '0', '2022-09-05', '07:53:00', '07:53:00', '0', '0', '85980', '0', '0', NULL, '0', '0'),
('163', '70', 'P', '0', '2022-09-05', '07:55:11', '17:59:32', '0', '0', '18131', '0', '0', NULL, '0', '0'),
('164', '173', 'P', '0', '2022-09-05', '07:55:20', '17:58:55', '0', '0', '18108', '0', '0', NULL, '0', '0'),
('165', '35', 'P', '0', '2022-09-05', '07:55:00', '17:59:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('166', '128', 'P', '0', '2022-09-05', '07:56:07', '18:04:16', '0', '0', '18245', '256', '0', NULL, '0', '0'),
('167', '147', 'P', '0', '2022-09-05', '07:56:12', '18:00:50', '0', '0', '18139', '50', '0', NULL, '0', '0'),
('168', '15', 'P', '0', '2022-09-05', '07:56:25', '18:01:10', '0', '0', '18143', '70', '0', NULL, '0', '0'),
('169', '6', 'P', '0', '2022-09-05', '07:56:30', '18:00:44', '0', '0', '18127', '44', '0', NULL, '0', '0'),
('170', '190', 'P', '0', '2022-09-05', '07:56:43', '18:00:25', '0', '0', '18111', '25', '0', NULL, '0', '0'),
('171', '177', 'P', '0', '2022-09-05', '07:57:09', '22:00:03', '0', '0', '25287', '14403', '0', NULL, '0', '0'),
('172', '57', 'P', '0', '2022-09-05', '07:57:46', '18:00:10', '0', '0', '18072', '10', '0', NULL, '0', '0'),
('173', '112', 'P', '0', '2022-09-05', '07:57:00', '18:08:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('174', '65', 'P', '0', '2022-09-05', '07:57:56', '18:00:55', '0', '0', '18090', '55', '0', NULL, '0', '0'),
('175', '60', 'P', '0', '2022-09-05', '07:58:10', '18:00:06', '0', '0', '18058', '6', '0', NULL, '0', '0'),
('176', '111', 'P', '0', '2022-09-05', '07:58:00', '07:58:00', '0', '0', '86280', '0', '0', NULL, '0', '0'),
('177', '61', 'P', '0', '2022-09-05', '07:58:23', '17:59:00', '0', '0', '18019', '0', '0', NULL, '0', '0'),
('178', '53', 'P', '0', '2022-09-05', '07:58:38', '17:58:43', '0', '0', '18003', '0', '0', NULL, '0', '0'),
('179', '88', 'P', '0', '2022-09-05', '07:59:27', '17:56:26', '0', '0', '17910', '0', '0', NULL, '0', '0'),
('180', '152', 'P', '0', '2022-09-05', '07:59:34', '17:59:15', '0', '0', '17991', '0', '0', NULL, '0', '0'),
('181', '162', 'P', '0', '2022-09-05', '07:59:49', '17:58:27', '0', '0', '17959', '0', '0', NULL, '0', '0'),
('182', '22', 'P', '0', '2022-09-05', '08:00:18', '18:00:37', '0', '0', '18010', '37', '0', NULL, '0', '0'),
('183', '98', 'P', '0', '2022-09-05', '08:00:24', '18:01:19', '0', '0', '18028', '79', '0', NULL, '0', '0'),
('184', '14', 'P', '0', '2022-09-05', '08:00:41', '22:00:10', '0', '0', '25185', '14410', '0', NULL, '0', '0'),
('185', '148', 'P', '0', '2022-09-05', '08:01:47', '17:59:03', '0', '0', '17918', '0', '0', NULL, '0', '0'),
('186', '189', 'P', '0', '2022-09-05', '08:02:00', '17:59:00', '0', '0', '35820', '0', '0', NULL, '0', '0'),
('187', '17', 'P', '0', '2022-09-05', '08:02:20', '18:28:15', '0', '0', '18778', '1695', '0', NULL, '0', '0'),
('188', '8', 'P', '0', '2022-09-05', '08:02:00', '18:02:00', '0', '0', '35880', '0', '0', NULL, '0', '0'),
('189', '139', 'P', '0', '2022-09-05', '08:02:00', '18:01:00', '0', '0', '35880', '0', '0', NULL, '0', '0'),
('190', '38', 'P', '0', '2022-09-05', '08:03:17', '17:49:23', '0', '0', '17583', '0', '0', NULL, '0', '0'),
('191', '160', 'P', '0', '2022-09-05', '08:04:38', '18:00:31', '0', '0', '17877', '31', '0', NULL, '0', '0'),
('192', '67', 'P', '0', '2022-09-05', '08:05:30', '18:00:21', '0', '0', '17846', '21', '0', NULL, '0', '0'),
('193', '13', 'P', '0', '2022-09-05', '08:08:45', '17:49:00', '0', '0', '17408', '0', '0', NULL, '0', '0'),
('194', '28', 'P', '0', '2022-09-05', '08:09:22', '17:59:55', '0', '0', '17717', '0', '0', NULL, '0', '0'),
('195', '31', 'P', '0', '2022-09-05', '08:09:33', '17:56:03', '0', '0', '17595', '0', '0', NULL, '0', '0'),
('196', '82', 'P', '0', '2022-09-05', '08:09:54', '17:58:30', '0', '0', '17658', '0', '0', NULL, '0', '0'),
('197', '118', 'P', '0', '2022-09-05', '08:10:34', '17:58:35', '0', '0', '17641', '0', '0', NULL, '0', '0'),
('198', '186', 'P', '0', '2022-09-05', '08:13:51', '17:59:07', '0', '0', '17558', '0', '0', NULL, '0', '0'),
('199', '7', 'P', '0', '2022-09-05', '08:23:18', '17:59:12', '0', '0', '17277', '0', '0', NULL, '0', '0'),
('200', '12', 'P', '0', '2022-09-05', '08:23:58', '08:23:58', '0', '0', '0', '0', '0', NULL, '0', '0'),
('201', '73', 'P', '0', '2022-09-05', '08:31:08', '17:58:49', '0', '0', '17031', '0', '0', NULL, '0', '0'),
('202', '2', 'P', '0', '2022-09-05', '09:02:34', '18:12:56', '0', '0', '16511', '776', '0', NULL, '0', '0'),
('203', '5', 'P', '0', '2022-09-05', '09:36:50', '18:05:27', '0', '0', '15259', '327', '0', NULL, '0', '0'),
('204', '4', 'P', '0', '2022-09-05', '09:39:00', '18:56:00', '0', '0', '30060', '0', '0', NULL, '0', '0'),
('205', '103', 'P', '0', '2022-09-05', '09:12:00', '18:48:00', '0', '0', '31680', '0', '0', NULL, '0', '0'),
('206', '1', 'P', '0', '2022-09-05', '09:12:00', '18:47:00', '0', '0', '31680', '2820', '0', NULL, '0', '0'),
('207', '20', 'P', '0', '2022-09-06', '06:15:13', '06:15:13', '0', '0', '0', '0', '0', NULL, '0', '0'),
('208', '18', 'P', '0', '2022-09-06', '07:21:33', '17:33:42', '0', '0', '18365', '0', '0', NULL, '0', '0'),
('209', '87', 'P', '0', '2022-09-06', '07:21:39', '22:13:45', '0', '0', '26763', '15225', '0', NULL, '0', '0'),
('210', '183', 'P', '0', '2022-09-06', '07:33:00', '17:59:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('211', '182', 'P', '0', '2022-09-06', '07:34:13', '17:58:38', '0', '0', '18733', '0', '0', NULL, '0', '0'),
('212', '46', 'P', '0', '2022-09-06', '07:35:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('213', '23', 'P', '0', '2022-09-06', '07:44:39', '17:55:36', '0', '0', '18329', '0', '0', NULL, '0', '0'),
('214', '51', 'P', '0', '2022-09-06', '07:45:56', '18:00:16', '0', '0', '18430', '16', '0', NULL, '0', '0'),
('215', '69', 'P', '0', '2022-09-06', '07:46:08', '13:06:59', '0', '0', '9626', '0', '0', NULL, '0', '0'),
('216', '181', 'P', '0', '2022-09-06', '07:46:13', '17:58:15', '0', '0', '18361', '0', '0', NULL, '0', '0'),
('217', '171', 'P', '0', '2022-09-06', '07:46:20', '17:58:32', '0', '0', '18366', '0', '0', NULL, '0', '0'),
('218', '161', 'P', '0', '2022-09-06', '07:49:02', '17:58:55', '0', '0', '18297', '0', '0', NULL, '0', '0'),
('219', '130', 'P', '0', '2022-09-06', '07:49:00', '17:59:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('220', '47', 'P', '0', '2022-09-06', '07:49:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('221', '112', 'P', '0', '2022-09-06', '07:50:00', '19:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('222', '189', 'P', '0', '2022-09-06', '07:50:00', '17:59:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('223', '190', 'P', '0', '2022-09-06', '07:50:51', '17:57:22', '0', '0', '18196', '0', '0', NULL, '0', '0'),
('224', '139', 'P', '0', '2022-09-06', '07:51:00', '17:59:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('225', '6', 'P', '0', '2022-09-06', '07:51:24', '18:00:24', '0', '0', '18270', '24', '0', NULL, '0', '0'),
('226', '70', 'P', '0', '2022-09-06', '07:51:54', '17:57:57', '0', '0', '18182', '0', '0', NULL, '0', '0'),
('227', '173', 'P', '0', '2022-09-06', '07:52:00', '17:58:01', '0', '0', '18181', '0', '0', NULL, '0', '0'),
('228', '35', 'P', '0', '2022-09-06', '07:52:00', '17:58:00', '0', '0', '35880', '0', '0', NULL, '0', '0'),
('229', '67', 'P', '0', '2022-09-06', '07:53:57', '18:01:36', '0', '0', '18230', '96', '0', NULL, '0', '0'),
('230', '121', 'P', '0', '2022-09-06', '07:54:30', '17:57:08', '0', '0', '18079', '0', '0', NULL, '0', '0'),
('231', '43', 'P', '0', '2022-09-06', '07:55:00', '19:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('232', '50', 'P', '0', '2022-09-06', '07:55:52', '17:53:42', '0', '0', '17935', '0', '0', NULL, '0', '0'),
('233', '21', 'P', '0', '2022-09-06', '07:55:00', '17:53:00', '0', '0', '35580', '0', '0', NULL, '0', '0'),
('234', '61', 'P', '0', '2022-09-06', '07:56:09', '17:58:11', '0', '0', '18061', '0', '0', NULL, '0', '0'),
('235', '75', 'P', '0', '2022-09-06', '07:56:00', '19:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('236', '147', 'P', '0', '2022-09-06', '07:56:39', '17:59:33', '0', '0', '18087', '0', '0', NULL, '0', '0'),
('237', '65', 'P', '0', '2022-09-06', '07:56:43', '18:00:02', '0', '0', '18100', '2', '0', NULL, '0', '0'),
('238', '64', 'P', '0', '2022-09-06', '07:56:00', '19:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('239', '111', 'P', '0', '2022-09-06', '07:56:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('240', '143', 'P', '0', '2022-09-06', '07:57:09', '17:57:43', '0', '0', '18017', '0', '0', NULL, '0', '0'),
('241', '17', 'P', '0', '2022-09-06', '07:57:35', '18:03:27', '0', '0', '18176', '207', '0', NULL, '0', '0'),
('242', '8', 'P', '0', '2022-09-06', '07:57:00', '18:01:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('243', '148', 'P', '0', '2022-09-06', '07:59:07', '17:58:19', '0', '0', '17976', '0', '0', NULL, '0', '0'),
('244', '88', 'P', '0', '2022-09-06', '07:59:24', '17:57:37', '0', '0', '17947', '0', '0', NULL, '0', '0'),
('245', '53', 'P', '0', '2022-09-06', '07:59:45', '17:57:02', '0', '0', '17919', '0', '0', NULL, '0', '0'),
('246', '60', 'P', '0', '2022-09-06', '07:59:54', '17:59:03', '0', '0', '17975', '0', '0', NULL, '0', '0'),
('247', '25', 'P', '0', '2022-09-06', '08:00:00', '17:57:05', '0', '0', '17913', '0', '0', NULL, '0', '0'),
('248', '57', 'P', '0', '2022-09-06', '08:00:08', '17:59:09', '0', '0', '17971', '0', '0', NULL, '0', '0'),
('249', '15', 'P', '0', '2022-09-06', '08:00:18', '08:00:18', '0', '0', '0', '0', '0', NULL, '0', '0'),
('250', '109', 'P', '0', '2022-09-06', '08:00:23', '18:01:49', '0', '0', '18043', '109', '0', NULL, '0', '0'),
('251', '186', 'P', '0', '2022-09-06', '08:01:07', '17:57:19', '0', '0', '17886', '0', '0', NULL, '0', '0'),
('252', '38', 'P', '0', '2022-09-06', '08:02:02', '17:57:27', '0', '0', '17863', '0', '0', NULL, '0', '0'),
('253', '32', 'P', '0', '2022-09-06', '08:02:40', '17:57:51', '0', '0', '17856', '0', '0', NULL, '0', '0'),
('254', '30', 'P', '0', '2022-09-06', '08:02:58', '17:58:44', '0', '0', '17873', '0', '0', NULL, '0', '0'),
('255', '162', 'P', '0', '2022-09-06', '08:03:31', '17:57:12', '0', '0', '17811', '0', '0', NULL, '0', '0'),
('256', '22', 'P', '0', '2022-09-06', '08:03:37', '17:55:30', '0', '0', '17757', '0', '0', NULL, '0', '0'),
('257', '152', 'P', '0', '2022-09-06', '08:05:13', '18:00:08', '0', '0', '17848', '8', '0', NULL, '0', '0'),
('258', '128', 'P', '0', '2022-09-06', '08:06:57', '18:02:18', '0', '0', '17861', '138', '0', NULL, '0', '0'),
('259', '14', 'P', '0', '2022-09-06', '08:07:04', '22:15:02', '0', '0', '25439', '15302', '0', NULL, '0', '0'),
('260', '7', 'P', '0', '2022-09-06', '08:07:10', '17:59:50', '0', '0', '17780', '0', '0', NULL, '0', '0'),
('261', '160', 'P', '0', '2022-09-06', '08:07:47', '18:07:27', '0', '0', '17990', '447', '0', NULL, '0', '0'),
('262', '82', 'P', '0', '2022-09-06', '08:10:21', '17:57:46', '0', '0', '17623', '0', '0', NULL, '0', '0'),
('263', '118', 'P', '0', '2022-09-06', '08:14:04', '18:00:43', '0', '0', '17600', '43', '0', NULL, '0', '0'),
('264', '13', 'P', '0', '2022-09-06', '08:14:39', '18:16:10', '0', '0', '18046', '970', '0', NULL, '0', '0'),
('265', '12', 'P', '0', '2022-09-06', '08:14:48', '18:15:55', '0', '0', '18034', '955', '0', NULL, '0', '0'),
('266', '170', 'P', '0', '2022-09-06', '08:17:56', '17:59:06', '0', '0', '17435', '0', '0', NULL, '0', '0'),
('267', '28', 'P', '0', '2022-09-06', '08:18:06', '18:00:13', '0', '0', '17464', '13', '0', NULL, '0', '0'),
('268', '31', 'P', '0', '2022-09-06', '08:18:18', '17:59:18', '0', '0', '17430', '0', '0', NULL, '0', '0'),
('269', '73', 'P', '0', '2022-09-06', '08:19:24', '17:57:16', '0', '0', '17336', '0', '0', NULL, '0', '0'),
('270', '4', 'P', '0', '2022-09-06', '08:42:00', '18:46:00', '0', '0', '33480', '0', '0', NULL, '0', '0'),
('271', '2', 'P', '0', '2022-09-06', '09:08:50', '18:26:46', '0', '0', '16738', '1606', '0', NULL, '0', '0'),
('272', '177', 'P', '0', '2022-09-06', '09:09:08', '22:15:28', '0', '0', '23590', '15328', '0', NULL, '0', '0'),
('273', '16', 'P', '0', '2022-09-06', '09:09:35', '09:09:35', '0', '0', '0', '0', '0', NULL, '0', '0'),
('274', '103', 'P', '0', '2022-09-06', '09:13:00', '18:34:00', '0', '0', '31620', '0', '0', NULL, '0', '0'),
('275', '1', 'P', '0', '2022-09-06', '09:13:00', '18:30:00', '0', '0', '31620', '1800', '0', NULL, '0', '0'),
('276', '5', 'P', '0', '2022-09-06', '14:14:23', '17:37:59', '0', '0', '6108', '0', '0', NULL, '0', '0'),
('277', '20', 'P', '0', '2022-09-07', '06:58:35', '18:28:13', '0', '0', '20689', '1693', '0', NULL, '0', '0'),
('278', '87', 'P', '0', '2022-09-07', '07:01:42', '19:38:46', '0', '0', '22712', '5926', '0', NULL, '0', '0'),
('279', '50', 'P', '0', '2022-09-07', '07:15:00', '14:15:33', '0', '0', '12617', '0', '0', NULL, '0', '0'),
('280', '21', 'P', '0', '2022-09-07', '07:15:00', '18:03:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('281', '18', 'P', '0', '2022-09-07', '07:23:06', '17:35:58', '0', '0', '18386', '0', '0', NULL, '0', '0'),
('282', '183', 'P', '0', '2022-09-07', '07:35:00', '18:02:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('283', '182', 'P', '0', '2022-09-07', '07:36:37', '18:01:32', '0', '0', '18748', '92', '0', NULL, '0', '0'),
('284', '23', 'P', '0', '2022-09-07', '07:39:59', '17:11:50', '0', '0', '17156', '0', '0', NULL, '0', '0'),
('285', '181', 'P', '0', '2022-09-07', '07:41:07', '18:02:29', '0', '0', '18641', '149', '0', NULL, '0', '0'),
('286', '171', 'P', '0', '2022-09-07', '07:41:43', '18:02:24', '0', '0', '18621', '144', '0', NULL, '0', '0'),
('287', '161', 'P', '0', '2022-09-07', '07:46:26', '18:02:49', '0', '0', '18492', '169', '0', NULL, '0', '0'),
('288', '25', 'P', '0', '2022-09-07', '07:46:48', '18:03:03', '0', '0', '18488', '183', '0', NULL, '0', '0'),
('289', '51', 'P', '0', '2022-09-07', '07:47:00', '18:11:32', '0', '0', '18736', '692', '0', NULL, '0', '0'),
('290', '65', 'P', '0', '2022-09-07', '07:48:22', '18:01:23', '0', '0', '18391', '83', '0', NULL, '0', '0'),
('291', '46', 'P', '0', '2022-09-07', '07:48:00', '12:53:00', '0', '0', '17580', '0', '0', NULL, '0', '0'),
('292', '75', 'HD', '0', '2022-09-07', '07:48:00', '12:53:00', '0', '0', '18000', '0', '0', NULL, '0', '0'),
('293', '130', 'P', '0', '2022-09-07', '07:49:00', '18:02:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('294', '60', 'P', '0', '2022-09-07', '07:51:08', '18:01:36', '0', '0', '18314', '96', '0', NULL, '0', '0'),
('295', '57', 'P', '0', '2022-09-07', '07:51:30', '18:02:12', '0', '0', '18321', '132', '0', NULL, '0', '0'),
('296', '139', 'P', '0', '2022-09-07', '07:51:00', '18:02:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('297', '6', 'P', '0', '2022-09-07', '07:51:55', '18:06:03', '0', '0', '18424', '363', '0', NULL, '0', '0'),
('298', '47', 'P', '0', '2022-09-07', '07:52:00', '07:52:00', '0', '0', '85920', '0', '0', NULL, '0', '0'),
('299', '32', 'P', '0', '2022-09-07', '07:53:11', '18:01:18', '0', '0', '18244', '78', '0', NULL, '0', '0'),
('300', '143', 'P', '0', '2022-09-07', '07:53:58', '18:01:14', '0', '0', '18218', '74', '0', NULL, '0', '0'),
('301', '64', 'P', '0', '2022-09-07', '07:54:00', '17:12:00', '0', '0', '33120', '0', '0', NULL, '0', '0'),
('302', '147', 'P', '0', '2022-09-07', '07:54:18', '18:02:44', '0', '0', '18253', '164', '0', NULL, '0', '0'),
('303', '30', 'P', '0', '2022-09-07', '07:54:32', '18:01:01', '0', '0', '18195', '61', '0', NULL, '0', '0'),
('304', '121', 'P', '0', '2022-09-07', '07:54:52', '18:01:40', '0', '0', '18204', '100', '0', NULL, '0', '0'),
('305', '53', 'P', '0', '2022-09-07', '07:57:11', '18:02:54', '0', '0', '18172', '174', '0', NULL, '0', '0'),
('306', '69', 'P', '0', '2022-09-07', '07:57:15', '12:53:36', '0', '0', '8891', '0', '0', NULL, '0', '0'),
('307', '67', 'P', '0', '2022-09-07', '07:57:49', '18:00:41', '0', '0', '18086', '41', '0', NULL, '0', '0'),
('308', '70', 'P', '0', '2022-09-07', '07:58:22', '18:01:10', '0', '0', '18084', '70', '0', NULL, '0', '0'),
('309', '173', 'P', '0', '2022-09-07', '07:58:32', '09:18:08', '0', '0', '2388', '0', '0', NULL, '0', '0'),
('310', '152', 'P', '0', '2022-09-07', '07:58:41', '13:24:56', '0', '0', '9788', '0', '0', NULL, '0', '0'),
('311', '35', 'P', '0', '2022-09-07', '07:58:00', '18:01:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('312', '148', 'P', '0', '2022-09-07', '07:59:02', '18:02:37', '0', '0', '18108', '157', '0', NULL, '0', '0'),
('313', '109', 'P', '0', '2022-09-07', '07:59:14', '18:00:34', '0', '0', '18040', '34', '0', NULL, '0', '0'),
('314', '112', 'P', '0', '2022-09-07', '07:59:00', '18:04:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('315', '15', 'P', '0', '2022-09-07', '08:00:06', '18:00:19', '0', '0', '18007', '19', '0', NULL, '0', '0'),
('316', '190', 'P', '0', '2022-09-07', '08:00:15', '18:01:06', '0', '0', '18026', '66', '0', NULL, '0', '0'),
('317', '22', 'P', '0', '2022-09-07', '08:00:57', '17:11:46', '0', '0', '16525', '0', '0', NULL, '0', '0'),
('318', '162', 'P', '0', '2022-09-07', '08:01:36', '18:00:10', '0', '0', '17957', '10', '0', NULL, '0', '0'),
('319', '17', 'P', '0', '2022-09-07', '08:02:58', '18:09:41', '0', '0', '18202', '581', '0', NULL, '0', '0'),
('320', '8', 'P', '0', '2022-09-07', '08:03:00', '18:08:00', '0', '0', '35820', '0', '0', NULL, '0', '0'),
('321', '88', 'P', '0', '2022-09-07', '08:03:14', '18:04:29', '0', '0', '18038', '269', '0', NULL, '0', '0'),
('322', '43', 'P', '0', '2022-09-07', '08:03:00', '18:03:00', '0', '0', '35820', '0', '0', NULL, '0', '0'),
('323', '61', 'P', '0', '2022-09-07', '08:03:55', '18:00:56', '0', '0', '17911', '56', '0', NULL, '0', '0'),
('324', '111', 'P', '0', '2022-09-07', '08:05:00', '23:05:00', '0', '0', '35700', '0', '0', NULL, '0', '0'),
('325', '160', 'P', '0', '2022-09-07', '08:06:04', '18:09:13', '0', '0', '18095', '553', '0', NULL, '0', '0'),
('326', '12', 'P', '0', '2022-09-07', '08:06:42', '18:03:12', '0', '0', '17895', '192', '0', NULL, '0', '0'),
('327', '7', 'P', '0', '2022-09-07', '08:06:48', '18:11:06', '0', '0', '18129', '666', '0', NULL, '0', '0'),
('328', '73', 'P', '0', '2022-09-07', '08:07:26', '18:10:51', '0', '0', '18103', '651', '0', NULL, '0', '0'),
('329', '128', 'P', '0', '2022-09-07', '08:07:37', '18:09:35', '0', '0', '18059', '575', '0', NULL, '0', '0'),
('330', '14', 'P', '0', '2022-09-07', '08:09:24', '22:59:30', '0', '0', '26703', '17970', '0', NULL, '0', '0'),
('331', '82', 'P', '0', '2022-09-07', '08:11:06', '18:00:46', '0', '0', '17690', '46', '0', NULL, '0', '0'),
('332', '170', 'P', '0', '2022-09-07', '08:12:07', '18:02:58', '0', '0', '17726', '178', '0', NULL, '0', '0'),
('333', '31', 'P', '0', '2022-09-07', '08:12:09', '18:10:45', '0', '0', '17958', '645', '0', NULL, '0', '0'),
('334', '28', 'P', '0', '2022-09-07', '08:12:18', '18:00:51', '0', '0', '17657', '51', '0', NULL, '0', '0'),
('335', '13', 'P', '0', '2022-09-07', '08:15:56', '18:51:55', '0', '0', '19080', '3115', '0', NULL, '0', '0'),
('336', '186', 'P', '0', '2022-09-07', '08:17:11', '18:03:21', '0', '0', '17585', '201', '0', NULL, '0', '0'),
('337', '118', 'P', '0', '2022-09-07', '08:17:39', '18:01:08', '0', '0', '17505', '68', '0', NULL, '0', '0'),
('338', '189', 'P', '0', '2022-09-07', '08:24:00', '18:00:00', '0', '0', '34560', '0', '0', NULL, '0', '0'),
('339', '4', 'P', '0', '2022-09-07', '09:04:00', '18:31:00', '0', '0', '32160', '0', '0', NULL, '0', '0'),
('340', '2', 'P', '0', '2022-09-07', '09:13:09', '18:24:14', '0', '0', '16533', '1454', '0', NULL, '0', '0'),
('341', '103', 'P', '0', '2022-09-07', '09:02:00', '18:22:00', '0', '0', '32280', '0', '0', NULL, '0', '0'),
('342', '1', 'P', '0', '2022-09-07', '09:02:00', '18:19:00', '0', '0', '32280', '1140', '0', NULL, '0', '0'),
('343', '5', 'P', '0', '2022-09-07', '09:25:42', '15:31:05', '0', '0', '10962', '0', '0', NULL, '0', '0'),
('344', '16', 'P', '0', '2022-09-07', '09:31:02', '09:31:02', '0', '0', '0', '0', '0', NULL, '0', '0'),
('345', '3', 'P', '0', '2022-09-07', '11:07:40', '11:07:40', '0', '0', '0', '0', '0', NULL, '0', '0'),
('346', '177', 'P', '0', '2022-09-07', '20:32:45', '20:32:45', '0', '0', '0', '9165', '0', NULL, '0', '0'),
('347', '20', 'P', '0', '2022-09-08', '07:02:34', '07:02:34', '0', '0', '0', '0', '0', NULL, '0', '0'),
('348', '18', 'P', '0', '2022-09-08', '07:28:24', '17:33:10', '0', '0', '18143', '0', '0', NULL, '0', '0'),
('349', '87', 'P', '0', '2022-09-08', '07:28:31', '23:13:34', '0', '0', '28352', '18814', '0', NULL, '0', '0'),
('350', '46', 'P', '0', '2022-09-08', '07:41:31', '18:01:11', '0', '0', '18590', '71', '0', NULL, '0', '0'),
('351', '181', 'P', '0', '2022-09-08', '07:43:18', '18:00:51', '0', '0', '18527', '51', '0', NULL, '0', '0'),
('352', '171', 'P', '0', '2022-09-08', '07:44:19', '18:01:54', '0', '0', '18528', '114', '0', NULL, '0', '0'),
('353', '21', 'P', '0', '2022-09-08', '07:45:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('354', '75', 'P', '0', '2022-09-08', '07:50:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('355', '161', 'P', '0', '2022-09-08', '07:51:11', '18:01:16', '0', '0', '18303', '76', '0', NULL, '0', '0'),
('356', '15', 'P', '0', '2022-09-08', '07:52:07', '18:07:19', '0', '0', '18456', '439', '0', NULL, '0', '0'),
('357', '65', 'P', '0', '2022-09-08', '07:52:16', '18:10:56', '0', '0', '18560', '656', '0', NULL, '0', '0'),
('358', '130', 'P', '0', '2022-09-08', '07:52:00', '18:01:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('359', '189', 'P', '0', '2022-09-08', '07:52:00', '18:01:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('360', '47', 'P', '0', '2022-09-08', '07:53:00', '18:05:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('361', '183', 'P', '0', '2022-09-08', '07:53:00', '18:01:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('362', '182', 'P', '0', '2022-09-08', '07:54:16', '18:01:51', '0', '0', '18228', '111', '0', NULL, '0', '0'),
('363', '70', 'P', '0', '2022-09-08', '07:54:23', '18:00:55', '0', '0', '18196', '55', '0', NULL, '0', '0'),
('364', '121', 'P', '0', '2022-09-08', '07:54:31', '17:36:53', '0', '0', '17471', '0', '0', NULL, '0', '0'),
('365', '35', 'P', '0', '2022-09-08', '07:54:00', '18:01:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('366', '6', 'P', '0', '2022-09-08', '07:55:35', '18:03:19', '0', '0', '18232', '199', '0', NULL, '0', '0'),
('367', '112', 'P', '0', '2022-09-08', '07:55:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('368', '109', 'P', '0', '2022-09-08', '07:55:54', '18:05:41', '0', '0', '18294', '341', '0', NULL, '0', '0'),
('369', '190', 'P', '0', '2022-09-08', '07:56:41', '18:00:25', '0', '0', '18112', '25', '0', NULL, '0', '0'),
('370', '43', 'P', '0', '2022-09-08', '07:56:58', '07:56:58', '0', '0', '0', '0', '0', NULL, '0', '0'),
('371', '61', 'P', '0', '2022-09-08', '07:57:13', '18:02:09', '0', '0', '18148', '129', '0', NULL, '0', '0'),
('372', '152', 'P', '0', '2022-09-08', '07:59:09', '18:01:33', '0', '0', '18072', '93', '0', NULL, '0', '0'),
('373', '53', 'P', '0', '2022-09-08', '08:00:52', '17:57:06', '0', '0', '17887', '0', '0', NULL, '0', '0'),
('374', '32', 'P', '0', '2022-09-08', '08:01:10', '18:00:41', '0', '0', '17986', '41', '0', NULL, '0', '0'),
('375', '30', 'P', '0', '2022-09-08', '08:01:17', '18:02:35', '0', '0', '18039', '155', '0', NULL, '0', '0'),
('376', '147', 'P', '0', '2022-09-08', '08:01:32', '18:01:44', '0', '0', '18006', '104', '0', NULL, '0', '0'),
('377', '143', 'P', '0', '2022-09-08', '08:01:50', '17:59:21', '0', '0', '17926', '0', '0', NULL, '0', '0'),
('378', '148', 'P', '0', '2022-09-08', '08:01:55', '18:02:03', '0', '0', '18004', '123', '0', NULL, '0', '0'),
('379', '162', 'P', '0', '2022-09-08', '08:02:10', '18:00:08', '0', '0', '17939', '8', '0', NULL, '0', '0'),
('380', '67', 'P', '0', '2022-09-08', '08:03:29', '18:01:23', '0', '0', '17937', '83', '0', NULL, '0', '0'),
('381', '139', 'P', '0', '2022-09-08', '08:04:00', '18:01:00', '0', '0', '35760', '0', '0', NULL, '0', '0'),
('382', '57', 'P', '0', '2022-09-08', '08:04:37', '18:00:12', '0', '0', '17868', '12', '0', NULL, '0', '0'),
('383', '60', 'P', '0', '2022-09-08', '08:05:02', '18:00:03', '0', '0', '17851', '3', '0', NULL, '0', '0'),
('384', '64', 'P', '0', '2022-09-08', '08:05:10', '08:05:10', '0', '0', '0', '0', '0', NULL, '0', '0'),
('385', '170', 'P', '0', '2022-09-08', '08:07:48', '18:01:05', '0', '0', '17799', '65', '0', NULL, '0', '0'),
('386', '31', 'P', '0', '2022-09-08', '08:07:54', '18:03:09', '0', '0', '17858', '189', '0', NULL, '0', '0'),
('387', '28', 'P', '0', '2022-09-08', '08:08:06', '18:00:36', '0', '0', '17775', '36', '0', NULL, '0', '0'),
('388', '82', 'P', '0', '2022-09-08', '08:08:20', '08:08:20', '0', '0', '0', '0', '0', NULL, '0', '0'),
('389', '38', 'P', '0', '2022-09-08', '08:08:36', '17:58:23', '0', '0', '17694', '0', '0', NULL, '0', '0'),
('390', '12', 'P', '0', '2022-09-08', '08:08:49', '18:13:01', '0', '0', '18126', '781', '0', NULL, '0', '0'),
('391', '7', 'P', '0', '2022-09-08', '08:09:00', '18:11:09', '0', '0', '18065', '669', '0', NULL, '0', '0'),
('392', '25', 'P', '0', '2022-09-08', '08:09:22', '18:00:16', '0', '0', '17727', '16', '0', NULL, '0', '0'),
('393', '160', 'P', '0', '2022-09-08', '08:10:52', '18:03:02', '0', '0', '17765', '182', '0', NULL, '0', '0'),
('394', '186', 'P', '0', '2022-09-08', '08:12:25', '18:17:18', '0', '0', '18147', '1038', '0', NULL, '0', '0'),
('395', '128', 'P', '0', '2022-09-08', '08:12:44', '18:05:27', '0', '0', '17782', '327', '0', NULL, '0', '0'),
('396', '118', 'P', '0', '2022-09-08', '08:13:27', '18:02:21', '0', '0', '17667', '141', '0', NULL, '0', '0'),
('397', '13', 'P', '0', '2022-09-08', '08:14:19', '18:11:02', '0', '0', '17902', '662', '0', NULL, '0', '0'),
('398', '73', 'P', '0', '2022-09-08', '08:15:04', '13:17:23', '0', '0', '9070', '0', '0', NULL, '0', '0'),
('399', '14', 'P', '0', '2022-09-08', '08:15:24', '23:12:29', '0', '0', '26913', '18749', '0', NULL, '0', '0'),
('400', '17', 'P', '0', '2022-09-08', '08:22:33', '18:06:03', '0', '0', '17505', '363', '0', NULL, '0', '0'),
('401', '8', 'P', '0', '2022-09-08', '08:22:45', '18:05:11', '0', '0', '17473', '311', '0', NULL, '0', '0'),
('402', '22', 'P', '0', '2022-09-08', '08:23:00', '17:58:54', '0', '0', '17277', '0', '0', NULL, '0', '0'),
('403', '51', 'P', '0', '2022-09-08', '08:30:19', '18:08:45', '0', '0', '17353', '525', '0', NULL, '0', '0'),
('404', '88', 'P', '0', '2022-09-08', '08:40:34', '17:58:56', '0', '0', '16751', '0', '0', NULL, '0', '0'),
('405', '4', 'P', '0', '2022-09-08', '08:58:43', '18:10:49', '0', '0', '16563', '649', '0', NULL, '0', '0'),
('406', '2', 'P', '0', '2022-09-08', '09:19:26', '18:11:20', '0', '0', '15957', '680', '0', NULL, '0', '0'),
('407', '103', 'P', '0', '2022-09-08', '09:13:07', '18:11:13', '0', '0', '16143', '673', '0', NULL, '0', '0'),
('408', '1', 'P', '0', '2022-09-08', '09:13:37', '18:10:00', '0', '0', '16092', '600', '0', NULL, '0', '0'),
('409', '16', 'P', '0', '2022-09-08', '09:54:25', '09:54:25', '0', '0', '0', '0', '0', NULL, '0', '0'),
('410', '5', 'P', '0', '2022-09-08', '14:17:27', '18:04:51', '0', '0', '6822', '291', '0', NULL, '0', '0'),
('411', '23', 'P', '0', '2022-09-08', '17:58:40', '17:58:40', '0', '0', '0', '0', '0', NULL, '0', '0'),
('412', '177', 'P', '0', '2022-09-08', '23:13:11', '23:13:11', '0', '0', '0', '18791', '0', NULL, '0', '0'),
('413', '20', 'P', '0', '2022-09-09', '07:17:59', '18:10:55', '0', '0', '19588', '655', '0', NULL, '0', '0'),
('414', '87', 'P', '0', '2022-09-09', '07:21:20', '20:55:50', '0', '0', '24435', '10550', '0', NULL, '0', '0'),
('415', '18', 'P', '0', '2022-09-09', '07:24:35', '17:28:48', '0', '0', '18127', '0', '0', NULL, '0', '0'),
('416', '171', 'P', '0', '2022-09-09', '07:35:27', '17:59:26', '0', '0', '18720', '0', '0', NULL, '0', '0'),
('417', '181', 'P', '0', '2022-09-09', '07:35:34', '17:59:56', '0', '0', '18731', '0', '0', NULL, '0', '0'),
('418', '51', 'P', '0', '2022-09-09', '07:41:53', '18:10:51', '0', '0', '18869', '651', '0', NULL, '0', '0'),
('419', '161', 'P', '0', '2022-09-09', '07:47:11', '18:00:24', '0', '0', '18397', '24', '0', NULL, '0', '0'),
('420', '46', 'P', '0', '2022-09-09', '07:48:44', '18:00:13', '0', '0', '18345', '13', '0', NULL, '0', '0'),
('421', '139', 'P', '0', '2022-09-09', '07:49:00', '17:59:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('422', '23', 'P', '0', '2022-09-09', '07:50:32', '18:05:57', '0', '0', '18463', '357', '0', NULL, '0', '0'),
('423', '75', 'P', '0', '2022-09-09', '07:51:00', '17:57:00', '0', '0', '35820', '0', '0', NULL, '0', '0'),
('424', '130', 'P', '0', '2022-09-09', '07:51:00', '17:59:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('425', '189', 'P', '0', '2022-09-09', '07:51:00', '17:59:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('426', '21', 'P', '0', '2022-09-09', '07:52:00', '17:00:00', '0', '0', '32400', '0', '0', NULL, '0', '0'),
('427', '109', 'P', '0', '2022-09-09', '07:52:22', '18:01:22', '0', '0', '18270', '82', '0', NULL, '0', '0'),
('428', '47', 'P', '0', '2022-09-09', '07:52:00', '17:59:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('429', '70', 'P', '0', '2022-09-09', '07:53:12', '17:59:59', '0', '0', '18204', '0', '0', NULL, '0', '0'),
('430', '173', 'P', '0', '2022-09-09', '07:53:18', '18:00:04', '0', '0', '18203', '4', '0', NULL, '0', '0'),
('431', '35', 'P', '0', '2022-09-09', '07:53:00', '18:03:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('432', '60', 'P', '0', '2022-09-09', '07:54:01', '18:00:06', '0', '0', '18183', '6', '0', NULL, '0', '0'),
('433', '57', 'P', '0', '2022-09-09', '07:54:48', '18:00:18', '0', '0', '18165', '18', '0', NULL, '0', '0'),
('434', '121', 'P', '0', '2022-09-09', '07:55:50', '17:58:22', '0', '0', '18076', '0', '0', NULL, '0', '0'),
('435', '183', 'P', '0', '2022-09-09', '07:56:00', '17:58:00', '0', '0', '35880', '0', '0', NULL, '0', '0'),
('436', '182', 'P', '0', '2022-09-09', '07:57:07', '17:58:50', '0', '0', '18052', '0', '0', NULL, '0', '0'),
('437', '6', 'P', '0', '2022-09-09', '07:58:08', '07:58:08', '0', '0', '0', '0', '0', NULL, '0', '0'),
('438', '43', 'P', '0', '2022-09-09', '07:58:00', '17:59:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('439', '61', 'P', '0', '2022-09-09', '07:58:42', '17:59:52', '0', '0', '18035', '0', '0', NULL, '0', '0'),
('440', '190', 'P', '0', '2022-09-09', '08:01:58', '17:59:09', '0', '0', '17916', '0', '0', NULL, '0', '0'),
('441', '8', 'P', '0', '2022-09-09', '08:02:14', '18:05:21', '0', '0', '18094', '321', '0', NULL, '0', '0'),
('442', '17', 'P', '0', '2022-09-09', '08:02:21', '18:11:02', '0', '0', '18261', '662', '0', NULL, '0', '0'),
('443', '53', 'P', '0', '2022-09-09', '08:02:27', '17:57:16', '0', '0', '17845', '0', '0', NULL, '0', '0'),
('444', '112', 'P', '0', '2022-09-09', '08:02:00', '18:00:00', '0', '0', '35880', '0', '0', NULL, '0', '0'),
('445', '65', 'P', '0', '2022-09-09', '08:02:37', '11:53:47', '0', '0', '6935', '0', '0', NULL, '0', '0'),
('446', '186', 'P', '0', '2022-09-09', '08:02:49', '17:57:21', '0', '0', '17836', '0', '0', NULL, '0', '0'),
('447', '152', 'P', '0', '2022-09-09', '08:03:17', '17:59:38', '0', '0', '17891', '0', '0', NULL, '0', '0'),
('448', '177', 'P', '0', '2022-09-09', '08:03:41', '22:33:05', '0', '0', '26082', '16385', '0', NULL, '0', '0'),
('449', '162', 'P', '0', '2022-09-09', '08:04:37', '17:57:39', '0', '0', '17791', '0', '0', NULL, '0', '0'),
('450', '82', 'P', '0', '2022-09-09', '08:04:44', '17:58:16', '0', '0', '17806', '0', '0', NULL, '0', '0'),
('451', '25', 'P', '0', '2022-09-09', '08:04:47', '17:58:36', '0', '0', '17815', '0', '0', NULL, '0', '0'),
('452', '64', 'HD', '0', '2022-09-09', '08:04:00', '12:01:00', '0', '0', '18000', '0', '0', NULL, '0', '0'),
('453', '32', 'P', '0', '2022-09-09', '08:06:06', '17:59:47', '0', '0', '17811', '0', '0', NULL, '0', '0'),
('454', '30', 'P', '0', '2022-09-09', '08:06:21', '17:58:30', '0', '0', '17765', '0', '0', NULL, '0', '0'),
('455', '147', 'P', '0', '2022-09-09', '08:06:52', '12:48:23', '0', '0', '8446', '0', '0', NULL, '0', '0'),
('456', '143', 'P', '0', '2022-09-09', '08:07:03', '12:48:30', '0', '0', '8444', '0', '0', NULL, '0', '0'),
('457', '14', 'P', '0', '2022-09-09', '08:08:17', '21:18:11', '0', '0', '23697', '11891', '0', NULL, '0', '0'),
('458', '160', 'P', '0', '2022-09-09', '08:11:22', '18:02:19', '0', '0', '17729', '139', '0', NULL, '0', '0'),
('459', '128', 'P', '0', '2022-09-09', '08:11:32', '18:03:26', '0', '0', '17757', '206', '0', NULL, '0', '0'),
('460', '12', 'P', '0', '2022-09-09', '08:12:19', '18:46:27', '0', '0', '19024', '2787', '0', NULL, '0', '0'),
('461', '22', 'P', '0', '2022-09-09', '08:13:13', '18:04:26', '0', '0', '17737', '266', '0', NULL, '0', '0'),
('462', '88', 'P', '0', '2022-09-09', '08:41:09', '17:57:52', '0', '0', '16702', '0', '0', NULL, '0', '0'),
('463', '16', 'P', '0', '2022-09-09', '09:03:57', '18:47:43', '0', '0', '17513', '2863', '0', NULL, '0', '0'),
('464', '4', 'P', '0', '2022-09-09', '09:10:33', '18:19:53', '0', '0', '16480', '1193', '0', NULL, '0', '0'),
('465', '2', 'P', '0', '2022-09-09', '09:27:06', '18:20:14', '0', '0', '15994', '1214', '0', NULL, '0', '0'),
('466', '103', 'P', '0', '2022-09-09', '09:11:36', '18:21:29', '0', '0', '16497', '1289', '0', NULL, '0', '0'),
('467', '1', 'P', '0', '2022-09-09', '09:11:49', '18:20:54', '0', '0', '16473', '1254', '0', NULL, '0', '0'),
('468', '5', 'P', '0', '2022-09-09', '10:36:10', '18:10:27', '0', '0', '13629', '627', '0', NULL, '0', '0');
INSERT INTO `0_kv_empl_attendance` VALUES
('469', '170', 'P', '0', '2022-09-09', '13:18:15', '13:18:15', '0', '0', '0', '0', '0', NULL, '0', '0'),
('470', '118', 'P', '0', '2022-09-09', '17:57:26', '17:57:26', '0', '0', '0', '0', '0', NULL, '0', '0'),
('471', '38', 'P', '0', '2022-09-09', '17:57:35', '17:57:35', '0', '0', '0', '0', '0', NULL, '0', '0'),
('472', '28', 'P', '0', '2022-09-09', '17:58:25', '17:58:25', '0', '0', '0', '0', '0', NULL, '0', '0'),
('473', '31', 'P', '0', '2022-09-09', '17:58:55', '17:58:55', '0', '0', '0', '0', '0', NULL, '0', '0'),
('474', '67', 'P', '0', '2022-09-09', '17:59:30', '17:59:30', '0', '0', '0', '0', '0', NULL, '0', '0'),
('475', '7', 'P', '0', '2022-09-09', '18:00:48', '18:00:48', '0', '0', '0', '48', '0', NULL, '0', '0'),
('476', '13', 'P', '0', '2022-09-09', '18:14:31', '18:14:31', '0', '0', '0', '871', '0', NULL, '0', '0'),
('477', '177', 'P', '0', '2022-09-10', '11:06:36', '11:06:36', '0', '0', '0', '0', '0', NULL, '0', '0'),
('478', '14', 'P', '0', '2022-09-10', '11:06:41', '22:44:27', '0', '0', '20933', '17067', '0', NULL, '0', '0'),
('479', '14', 'P', '0', '2022-09-11', '10:30:50', '23:14:07', '0', '0', '22899', '18847', '0', NULL, '0', '0'),
('480', '177', 'P', '0', '2022-09-11', '10:30:55', '23:15:02', '0', '0', '22924', '18902', '0', NULL, '0', '0'),
('481', '20', 'P', '0', '2022-09-12', '07:00:42', '18:24:30', '0', '0', '20514', '1470', '0', NULL, '0', '0'),
('482', '87', 'P', '0', '2022-09-12', '07:17:59', '18:10:27', '0', '0', '19574', '627', '0', NULL, '0', '0'),
('483', '18', 'P', '0', '2022-09-12', '07:23:51', '17:26:09', '0', '0', '18069', '0', '0', NULL, '0', '0'),
('484', '21', 'P', '0', '2022-09-12', '07:35:00', '17:35:00', '0', '0', '34500', '0', '0', NULL, '0', '0'),
('485', '51', 'P', '0', '2022-09-12', '07:44:57', '18:03:39', '0', '0', '18561', '219', '0', NULL, '0', '0'),
('486', '183', 'P', '0', '2022-09-12', '07:46:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('487', '182', 'P', '0', '2022-09-12', '07:46:52', '07:46:52', '0', '0', '0', '0', '0', NULL, '0', '0'),
('488', '161', 'P', '0', '2022-09-12', '07:47:23', '18:00:50', '0', '0', '18404', '50', '0', NULL, '0', '0'),
('489', '181', 'P', '0', '2022-09-12', '07:52:14', '12:54:14', '0', '0', '9060', '0', '0', NULL, '0', '0'),
('490', '171', 'P', '0', '2022-09-12', '07:53:00', '12:54:05', '0', '0', '9033', '0', '0', NULL, '0', '0'),
('491', '60', 'P', '0', '2022-09-12', '07:53:18', '18:00:53', '0', '0', '18228', '53', '0', NULL, '0', '0'),
('492', '75', 'P', '0', '2022-09-12', '07:53:00', '17:57:00', '0', '0', '35820', '0', '0', NULL, '0', '0'),
('493', '189', 'P', '0', '2022-09-12', '07:53:00', '17:58:00', '0', '0', '35880', '0', '0', NULL, '0', '0'),
('494', '57', 'P', '0', '2022-09-12', '07:54:19', '18:00:26', '0', '0', '18184', '26', '0', NULL, '0', '0'),
('495', '130', 'P', '0', '2022-09-12', '07:54:00', '18:01:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('496', '139', 'P', '0', '2022-09-12', '07:54:00', '18:01:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('497', '69', 'P', '0', '2022-09-12', '07:55:09', '12:54:01', '0', '0', '8966', '0', '0', NULL, '0', '0'),
('498', '23', 'P', '0', '2022-09-12', '07:55:33', '17:56:36', '0', '0', '18032', '0', '0', NULL, '0', '0'),
('499', '53', 'P', '0', '2022-09-12', '07:56:22', '17:39:47', '0', '0', '17503', '0', '0', NULL, '0', '0'),
('500', '46', 'P', '0', '2022-09-12', '07:56:44', '18:00:41', '0', '0', '18119', '41', '0', NULL, '0', '0'),
('501', '65', 'P', '0', '2022-09-12', '07:58:07', '18:01:28', '0', '0', '18101', '88', '0', NULL, '0', '0'),
('502', '121', 'P', '0', '2022-09-12', '07:58:54', '17:57:56', '0', '0', '17971', '0', '0', NULL, '0', '0'),
('503', '177', 'P', '0', '2022-09-12', '08:00:02', '18:03:25', '0', '0', '18102', '205', '0', NULL, '0', '0'),
('504', '111', 'P', '0', '2022-09-12', '08:01:00', '18:00:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('505', '147', 'P', '0', '2022-09-12', '08:01:22', '18:01:58', '0', '0', '18018', '118', '0', NULL, '0', '0'),
('506', '143', 'P', '0', '2022-09-12', '08:01:30', '18:03:22', '0', '0', '18056', '202', '0', NULL, '0', '0'),
('507', '6', 'P', '0', '2022-09-12', '08:02:01', '18:01:44', '0', '0', '17992', '104', '0', NULL, '0', '0'),
('508', '152', 'P', '0', '2022-09-12', '08:02:10', '17:57:31', '0', '0', '17861', '0', '0', NULL, '0', '0'),
('509', '15', 'P', '0', '2022-09-12', '08:02:13', '17:34:40', '0', '0', '17174', '0', '0', NULL, '0', '0'),
('510', '190', 'P', '0', '2022-09-12', '08:03:52', '18:00:10', '0', '0', '17889', '10', '0', NULL, '0', '0'),
('511', '148', 'P', '0', '2022-09-12', '08:04:07', '18:00:17', '0', '0', '17885', '17', '0', NULL, '0', '0'),
('512', '61', 'P', '0', '2022-09-12', '08:04:36', '18:01:37', '0', '0', '17911', '97', '0', NULL, '0', '0'),
('513', '43', 'P', '0', '2022-09-12', '08:04:00', '18:04:00', '0', '0', '35760', '0', '0', NULL, '0', '0'),
('514', '25', 'P', '0', '2022-09-12', '08:05:02', '17:58:01', '0', '0', '17790', '0', '0', NULL, '0', '0'),
('515', '17', 'P', '0', '2022-09-12', '08:05:55', '18:01:33', '0', '0', '17869', '93', '0', NULL, '0', '0'),
('516', '112', 'P', '0', '2022-09-12', '08:06:00', '18:06:00', '0', '0', '35640', '0', '0', NULL, '0', '0'),
('517', '8', 'P', '0', '2022-09-12', '08:06:16', '18:00:12', '0', '0', '17818', '12', '0', NULL, '0', '0'),
('518', '12', 'P', '0', '2022-09-12', '08:06:30', '18:02:57', '0', '0', '17894', '177', '0', NULL, '0', '0'),
('519', '82', 'P', '0', '2022-09-12', '08:06:37', '17:57:02', '0', '0', '17713', '0', '0', NULL, '0', '0'),
('520', '14', 'P', '0', '2022-09-12', '08:06:39', '18:03:11', '0', '0', '17896', '191', '0', NULL, '0', '0'),
('521', '160', 'P', '0', '2022-09-12', '08:08:39', '18:02:04', '0', '0', '17803', '124', '0', NULL, '0', '0'),
('522', '67', 'P', '0', '2022-09-12', '08:08:59', '17:58:19', '0', '0', '17680', '0', '0', NULL, '0', '0'),
('523', '70', 'P', '0', '2022-09-12', '08:10:35', '18:00:46', '0', '0', '17706', '46', '0', NULL, '0', '0'),
('524', '173', 'P', '0', '2022-09-12', '08:10:40', '18:01:00', '0', '0', '17710', '60', '0', NULL, '0', '0'),
('525', '35', 'P', '0', '2022-09-12', '08:10:00', '18:01:00', '0', '0', '35400', '0', '0', NULL, '0', '0'),
('526', '162', 'P', '0', '2022-09-12', '08:10:57', '17:40:31', '0', '0', '17087', '0', '0', NULL, '0', '0'),
('527', '32', 'P', '0', '2022-09-12', '08:11:04', '18:00:30', '0', '0', '17683', '30', '0', NULL, '0', '0'),
('528', '30', 'P', '0', '2022-09-12', '08:11:13', '18:00:36', '0', '0', '17682', '36', '0', NULL, '0', '0'),
('529', '128', 'P', '0', '2022-09-12', '08:14:01', '18:00:57', '0', '0', '17608', '57', '0', NULL, '0', '0'),
('530', '118', 'P', '0', '2022-09-12', '08:17:03', '08:17:03', '0', '0', '0', '0', '0', NULL, '0', '0'),
('531', '64', 'P', '0', '2022-09-12', '08:19:00', '18:00:00', '0', '0', '34860', '0', '0', NULL, '0', '0'),
('532', '22', 'P', '0', '2022-09-12', '08:20:46', '17:56:51', '0', '0', '17283', '0', '0', NULL, '0', '0'),
('533', '28', 'P', '0', '2022-09-12', '08:21:39', '17:58:13', '0', '0', '17297', '0', '0', NULL, '0', '0'),
('534', '170', 'P', '0', '2022-09-12', '08:21:47', '17:58:30', '0', '0', '17302', '0', '0', NULL, '0', '0'),
('535', '31', 'P', '0', '2022-09-12', '08:21:55', '08:21:55', '0', '0', '0', '0', '0', NULL, '0', '0'),
('536', '13', 'P', '0', '2022-09-12', '08:28:54', '08:28:54', '0', '0', '0', '0', '0', NULL, '0', '0'),
('537', '109', 'P', '0', '2022-09-12', '08:35:15', '08:35:15', '0', '0', '0', '0', '0', NULL, '0', '0'),
('538', '186', 'P', '0', '2022-09-12', '08:43:21', '17:39:55', '0', '0', '16097', '0', '0', NULL, '0', '0'),
('539', '88', 'P', '0', '2022-09-12', '08:51:14', '17:52:44', '0', '0', '16245', '0', '0', NULL, '0', '0'),
('540', '103', 'P', '0', '2022-09-12', '09:09:36', '17:34:35', '0', '0', '15150', '0', '0', NULL, '0', '0'),
('541', '1', 'P', '0', '2022-09-12', '09:10:29', '17:29:39', '0', '0', '14975', '0', '0', NULL, '0', '0'),
('542', '2', 'P', '0', '2022-09-12', '09:20:11', '17:34:10', '0', '0', '14820', '0', '0', NULL, '0', '0'),
('543', '4', 'P', '0', '2022-09-12', '09:27:27', '17:40:51', '0', '0', '14802', '0', '0', NULL, '0', '0'),
('544', '16', 'P', '0', '2022-09-12', '09:57:15', '09:57:15', '0', '0', '0', '0', '0', NULL, '0', '0'),
('545', '5', 'P', '0', '2022-09-12', '10:21:03', '17:33:09', '0', '0', '12963', '0', '0', NULL, '0', '0'),
('546', '20', 'P', '0', '2022-09-13', '07:09:04', '18:28:51', '0', '0', '20394', '1731', '0', NULL, '0', '0'),
('547', '18', 'P', '0', '2022-09-13', '07:21:50', '17:33:40', '0', '0', '18355', '0', '0', NULL, '0', '0'),
('548', '161', 'P', '0', '2022-09-13', '07:46:31', '18:01:43', '0', '0', '18456', '103', '0', NULL, '0', '0'),
('549', '46', 'P', '0', '2022-09-13', '07:47:08', '18:57:53', '0', '0', '20123', '3473', '0', NULL, '0', '0'),
('550', '21', 'P', '0', '2022-09-13', '07:48:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('551', '177', 'P', '0', '2022-09-13', '07:48:35', '18:57:27', '0', '0', '20066', '3447', '0', NULL, '0', '0'),
('552', '189', 'P', '0', '2022-09-13', '07:51:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('553', '47', 'P', '0', '2022-09-13', '07:52:00', '07:52:00', '0', '0', '85920', '0', '0', NULL, '0', '0'),
('554', '130', 'P', '0', '2022-09-13', '07:54:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('555', '139', 'P', '0', '2022-09-13', '07:54:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('556', '15', 'P', '0', '2022-09-13', '07:55:06', '18:06:47', '0', '0', '18351', '407', '0', NULL, '0', '0'),
('557', '25', 'P', '0', '2022-09-13', '07:57:35', '18:01:32', '0', '0', '18119', '92', '0', NULL, '0', '0'),
('558', '75', 'P', '0', '2022-09-13', '07:57:00', '07:57:00', '0', '0', '86220', '0', '0', NULL, '0', '0'),
('559', '121', 'P', '0', '2022-09-13', '07:58:07', '18:01:14', '0', '0', '18094', '74', '0', NULL, '0', '0'),
('560', '87', 'P', '0', '2022-09-13', '07:58:23', '18:13:48', '0', '0', '18463', '828', '0', NULL, '0', '0'),
('561', '190', 'P', '0', '2022-09-13', '07:59:17', '18:00:43', '0', '0', '18043', '43', '0', NULL, '0', '0'),
('562', '183', 'P', '0', '2022-09-13', '07:59:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('563', '182', 'P', '0', '2022-09-13', '07:59:47', '18:01:22', '0', '0', '18048', '82', '0', NULL, '0', '0'),
('564', '109', 'P', '0', '2022-09-13', '07:59:51', '18:09:15', '0', '0', '18282', '555', '0', NULL, '0', '0'),
('565', '64', 'P', '0', '2022-09-13', '07:59:00', '18:08:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('566', '60', 'P', '0', '2022-09-13', '08:00:31', '18:00:09', '0', '0', '17989', '9', '0', NULL, '0', '0'),
('567', '6', 'P', '0', '2022-09-13', '08:00:45', '18:06:44', '0', '0', '18180', '404', '0', NULL, '0', '0'),
('568', '57', 'P', '0', '2022-09-13', '08:01:15', '18:00:24', '0', '0', '17975', '24', '0', NULL, '0', '0'),
('569', '51', 'P', '0', '2022-09-13', '08:02:36', '18:03:29', '0', '0', '18027', '209', '0', NULL, '0', '0'),
('570', '148', 'P', '0', '2022-09-13', '08:03:53', '18:01:39', '0', '0', '17933', '99', '0', NULL, '0', '0'),
('571', '112', 'P', '0', '2022-09-13', '08:05:00', '18:00:00', '0', '0', '35700', '0', '0', NULL, '0', '0'),
('572', '70', 'P', '0', '2022-09-13', '08:05:31', '18:00:49', '0', '0', '17859', '49', '0', NULL, '0', '0'),
('573', '173', 'P', '0', '2022-09-13', '08:05:37', '18:01:05', '0', '0', '17864', '65', '0', NULL, '0', '0'),
('574', '65', 'P', '0', '2022-09-13', '08:05:43', '18:00:02', '0', '0', '17830', '2', '0', NULL, '0', '0'),
('575', '35', 'P', '0', '2022-09-13', '08:05:00', '18:01:00', '0', '0', '35700', '0', '0', NULL, '0', '0'),
('576', '17', 'P', '0', '2022-09-13', '08:06:19', '18:07:15', '0', '0', '18028', '435', '0', NULL, '0', '0'),
('577', '162', 'P', '0', '2022-09-13', '08:06:32', '18:00:05', '0', '0', '17807', '5', '0', NULL, '0', '0'),
('578', '8', 'P', '0', '2022-09-13', '08:06:41', '18:04:55', '0', '0', '17947', '295', '0', NULL, '0', '0'),
('579', '67', 'P', '0', '2022-09-13', '08:06:44', '18:00:15', '0', '0', '17806', '15', '0', NULL, '0', '0'),
('580', '170', 'P', '0', '2022-09-13', '08:06:49', '18:02:10', '0', '0', '17861', '130', '0', NULL, '0', '0'),
('581', '28', 'P', '0', '2022-09-13', '08:06:53', '14:46:23', '0', '0', '11985', '0', '0', NULL, '0', '0'),
('582', '31', 'P', '0', '2022-09-13', '08:07:08', '18:02:13', '0', '0', '17853', '133', '0', NULL, '0', '0'),
('583', '14', 'P', '0', '2022-09-13', '08:07:38', '21:41:36', '0', '0', '24419', '13296', '0', NULL, '0', '0'),
('584', '147', 'P', '0', '2022-09-13', '08:08:10', '12:53:35', '0', '0', '8563', '0', '0', NULL, '0', '0'),
('585', '143', 'P', '0', '2022-09-13', '08:08:20', '12:57:19', '0', '0', '8670', '0', '0', NULL, '0', '0'),
('586', '22', 'P', '0', '2022-09-13', '08:09:13', '18:00:32', '0', '0', '17740', '32', '0', NULL, '0', '0'),
('587', '82', 'P', '0', '2022-09-13', '08:09:55', '18:00:39', '0', '0', '17722', '39', '0', NULL, '0', '0'),
('588', '30', 'P', '0', '2022-09-13', '08:10:12', '18:02:04', '0', '0', '17756', '124', '0', NULL, '0', '0'),
('589', '32', 'P', '0', '2022-09-13', '08:10:18', '18:02:21', '0', '0', '17762', '141', '0', NULL, '0', '0'),
('590', '43', 'P', '0', '2022-09-13', '08:11:00', '18:02:00', '0', '0', '35340', '0', '0', NULL, '0', '0'),
('591', '61', 'P', '0', '2022-09-13', '08:11:28', '18:01:48', '0', '0', '17710', '108', '0', NULL, '0', '0'),
('592', '152', 'P', '0', '2022-09-13', '08:12:20', '18:02:28', '0', '0', '17704', '148', '0', NULL, '0', '0'),
('593', '118', 'P', '0', '2022-09-13', '08:13:10', '18:03:46', '0', '0', '17718', '226', '0', NULL, '0', '0'),
('594', '160', 'P', '0', '2022-09-13', '08:13:21', '18:09:20', '0', '0', '17880', '560', '0', NULL, '0', '0'),
('595', '13', 'P', '0', '2022-09-13', '08:13:57', '21:40:47', '0', '0', '24205', '13247', '0', NULL, '0', '0'),
('596', '12', 'P', '0', '2022-09-13', '08:14:41', '21:40:30', '0', '0', '24175', '13230', '0', NULL, '0', '0'),
('597', '128', 'P', '0', '2022-09-13', '08:15:22', '18:05:02', '0', '0', '17690', '302', '0', NULL, '0', '0'),
('598', '186', 'P', '0', '2022-09-13', '08:15:50', '18:00:21', '0', '0', '17536', '21', '0', NULL, '0', '0'),
('599', '111', 'P', '0', '2022-09-13', '08:16:00', '12:51:00', '0', '0', '16500', '0', '0', NULL, '0', '0'),
('600', '53', 'P', '0', '2022-09-13', '08:17:49', '17:59:40', '0', '0', '17456', '0', '0', NULL, '0', '0'),
('601', '181', 'P', '0', '2022-09-13', '08:17:57', '18:01:35', '0', '0', '17509', '95', '0', NULL, '0', '0'),
('602', '69', 'P', '0', '2022-09-13', '08:18:12', '12:50:47', '0', '0', '8178', '0', '0', NULL, '0', '0'),
('603', '171', 'P', '0', '2022-09-13', '08:18:17', '18:01:59', '0', '0', '17511', '119', '0', NULL, '0', '0'),
('604', '7', 'P', '0', '2022-09-13', '08:42:00', '18:06:24', '0', '0', '16932', '384', '0', NULL, '0', '0'),
('605', '88', 'P', '0', '2022-09-13', '08:49:42', '20:33:16', '0', '0', '21107', '9196', '0', NULL, '0', '0'),
('606', '103', 'P', '0', '2022-09-13', '09:15:23', '18:09:56', '0', '0', '16037', '596', '0', NULL, '0', '0'),
('607', '1', 'P', '0', '2022-09-13', '09:15:46', '18:08:10', '0', '0', '15972', '490', '0', NULL, '0', '0'),
('608', '5', 'P', '0', '2022-09-13', '09:20:54', '18:03:53', '0', '0', '15690', '233', '0', NULL, '0', '0'),
('609', '4', 'P', '0', '2022-09-13', '09:32:53', '18:09:31', '0', '0', '15499', '571', '0', NULL, '0', '0'),
('610', '2', 'P', '0', '2022-09-13', '09:43:52', '18:09:09', '0', '0', '15159', '549', '0', NULL, '0', '0'),
('611', '16', 'P', '0', '2022-09-13', '09:54:28', '09:54:28', '0', '0', '0', '0', '0', NULL, '0', '0'),
('612', '3', 'P', '0', '2022-09-13', '10:32:21', '10:32:21', '0', '0', '0', '0', '0', NULL, '0', '0'),
('613', '20', 'P', '0', '2022-09-14', '06:47:21', '18:38:48', '0', '0', '21344', '2328', '0', NULL, '0', '0'),
('614', '87', 'P', '0', '2022-09-14', '06:58:18', '18:35:41', '0', '0', '20922', '2141', '0', NULL, '0', '0'),
('615', '18', 'P', '0', '2022-09-14', '07:25:55', '17:30:49', '0', '0', '18147', '0', '0', NULL, '0', '0'),
('616', '51', 'P', '0', '2022-09-14', '07:28:09', '18:09:07', '0', '0', '19229', '547', '0', NULL, '0', '0'),
('617', '46', 'P', '0', '2022-09-14', '07:38:25', '18:00:37', '0', '0', '18666', '37', '0', NULL, '0', '0'),
('618', '183', 'P', '0', '2022-09-14', '07:45:00', '18:04:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('619', '182', 'P', '0', '2022-09-14', '07:46:24', '07:46:24', '0', '0', '0', '0', '0', NULL, '0', '0'),
('620', '161', 'P', '0', '2022-09-14', '07:47:12', '18:00:16', '0', '0', '18392', '16', '0', NULL, '0', '0'),
('621', '23', 'P', '0', '2022-09-14', '07:49:40', '17:57:22', '0', '0', '18231', '0', '0', NULL, '0', '0'),
('622', '111', 'P', '0', '2022-09-14', '07:51:00', '07:51:00', '0', '0', '85860', '0', '0', NULL, '0', '0'),
('623', '75', 'P', '0', '2022-09-14', '07:55:00', '20:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('624', '109', 'P', '0', '2022-09-14', '07:55:38', '18:03:19', '0', '0', '18231', '199', '0', NULL, '0', '0'),
('625', '25', 'P', '0', '2022-09-14', '07:56:37', '17:58:07', '0', '0', '18045', '0', '0', NULL, '0', '0'),
('626', '21', 'P', '0', '2022-09-14', '07:56:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('627', '14', 'P', '0', '2022-09-14', '07:56:54', '23:00:33', '0', '0', '27110', '18033', '0', NULL, '0', '0'),
('628', '121', 'P', '0', '2022-09-14', '07:57:02', '17:57:19', '0', '0', '18009', '0', '0', NULL, '0', '0'),
('629', '130', 'P', '0', '2022-09-14', '07:57:00', '18:03:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('630', '189', 'P', '0', '2022-09-14', '07:57:00', '18:04:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('631', '65', 'P', '0', '2022-09-14', '07:58:01', '23:00:22', '0', '0', '27071', '18022', '0', NULL, '0', '0'),
('632', '47', 'P', '0', '2022-09-14', '07:58:00', '19:30:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('633', '181', 'P', '0', '2022-09-14', '07:59:19', '17:58:26', '0', '0', '17974', '0', '0', NULL, '0', '0'),
('634', '171', 'P', '0', '2022-09-14', '07:59:54', '17:58:02', '0', '0', '17944', '0', '0', NULL, '0', '0'),
('635', '15', 'P', '0', '2022-09-14', '08:00:03', '18:03:36', '0', '0', '18107', '216', '0', NULL, '0', '0'),
('636', '32', 'P', '0', '2022-09-14', '08:00:40', '17:59:19', '0', '0', '17960', '0', '0', NULL, '0', '0'),
('637', '30', 'P', '0', '2022-09-14', '08:00:52', '17:59:08', '0', '0', '17948', '0', '0', NULL, '0', '0'),
('638', '190', 'P', '0', '2022-09-14', '08:01:31', '17:59:15', '0', '0', '17932', '0', '0', NULL, '0', '0'),
('639', '170', 'P', '0', '2022-09-14', '08:03:17', '18:00:02', '0', '0', '17903', '2', '0', NULL, '0', '0'),
('640', '67', 'P', '0', '2022-09-14', '08:03:21', '13:02:57', '0', '0', '8988', '0', '0', NULL, '0', '0'),
('641', '28', 'P', '0', '2022-09-14', '08:03:28', '17:58:55', '0', '0', '17864', '0', '0', NULL, '0', '0'),
('642', '31', 'P', '0', '2022-09-14', '08:03:33', '18:03:32', '0', '0', '18000', '212', '0', NULL, '0', '0'),
('643', '35', 'P', '0', '2022-09-14', '08:03:00', '19:30:00', '0', '0', '35820', '0', '0', NULL, '0', '0'),
('644', '173', 'P', '0', '2022-09-14', '08:04:03', '17:58:42', '0', '0', '17840', '0', '0', NULL, '0', '0'),
('645', '70', 'P', '0', '2022-09-14', '08:04:09', '17:58:35', '0', '0', '17833', '0', '0', NULL, '0', '0'),
('646', '8', 'P', '0', '2022-09-14', '08:04:16', '18:09:14', '0', '0', '18149', '554', '0', NULL, '0', '0'),
('647', '17', 'P', '0', '2022-09-14', '08:04:31', '18:10:02', '0', '0', '18166', '602', '0', NULL, '0', '0'),
('648', '6', 'P', '0', '2022-09-14', '08:04:50', '18:06:43', '0', '0', '18057', '403', '0', NULL, '0', '0'),
('649', '143', 'P', '0', '2022-09-14', '08:05:00', '17:58:17', '0', '0', '17799', '0', '0', NULL, '0', '0'),
('650', '147', 'P', '0', '2022-09-14', '08:05:12', '17:58:31', '0', '0', '17800', '0', '0', NULL, '0', '0'),
('651', '69', 'P', '0', '2022-09-14', '08:05:15', '13:03:06', '0', '0', '8936', '0', '0', NULL, '0', '0'),
('652', '61', 'P', '0', '2022-09-14', '08:05:18', '17:58:48', '0', '0', '17805', '0', '0', NULL, '0', '0'),
('653', '43', 'P', '0', '2022-09-14', '08:05:00', '20:00:00', '0', '0', '35700', '0', '0', NULL, '0', '0'),
('654', '148', 'P', '0', '2022-09-14', '08:05:53', '18:00:12', '0', '0', '17830', '12', '0', NULL, '0', '0'),
('655', '64', 'P', '0', '2022-09-14', '08:06:00', '20:00:00', '0', '0', '35640', '0', '0', NULL, '0', '0'),
('656', '82', 'P', '0', '2022-09-14', '08:06:28', '17:56:26', '0', '0', '17699', '0', '0', NULL, '0', '0'),
('657', '22', 'P', '0', '2022-09-14', '08:06:45', '17:59:11', '0', '0', '17773', '0', '0', NULL, '0', '0'),
('658', '57', 'P', '0', '2022-09-14', '08:07:13', '18:00:09', '0', '0', '17788', '9', '0', NULL, '0', '0'),
('659', '60', 'P', '0', '2022-09-14', '08:07:17', '18:00:04', '0', '0', '17784', '4', '0', NULL, '0', '0'),
('660', '112', 'P', '0', '2022-09-14', '08:08:00', '18:04:00', '0', '0', '35520', '0', '0', NULL, '0', '0'),
('661', '162', 'P', '0', '2022-09-14', '08:08:10', '17:58:20', '0', '0', '17705', '0', '0', NULL, '0', '0'),
('662', '152', 'P', '0', '2022-09-14', '08:10:03', '18:00:23', '0', '0', '17710', '23', '0', NULL, '0', '0'),
('663', '160', 'P', '0', '2022-09-14', '08:11:41', '18:09:56', '0', '0', '17948', '596', '0', NULL, '0', '0'),
('664', '186', 'P', '0', '2022-09-14', '08:14:07', '17:58:52', '0', '0', '17543', '0', '0', NULL, '0', '0'),
('665', '7', 'P', '0', '2022-09-14', '08:14:14', '18:04:20', '0', '0', '17703', '260', '0', NULL, '0', '0'),
('666', '53', 'P', '0', '2022-09-14', '08:14:46', '17:56:35', '0', '0', '17455', '0', '0', NULL, '0', '0'),
('667', '13', 'P', '0', '2022-09-14', '08:14:54', '23:00:17', '0', '0', '26562', '18017', '0', NULL, '0', '0'),
('668', '118', 'P', '0', '2022-09-14', '08:15:38', '18:00:31', '0', '0', '17547', '31', '0', NULL, '0', '0'),
('669', '177', 'P', '0', '2022-09-14', '08:15:44', '19:01:50', '0', '0', '19383', '3710', '0', NULL, '0', '0'),
('670', '128', 'P', '0', '2022-09-14', '08:15:49', '18:00:27', '0', '0', '17539', '27', '0', NULL, '0', '0'),
('671', '12', 'P', '0', '2022-09-14', '08:27:16', '23:00:09', '0', '0', '26187', '18009', '0', NULL, '0', '0'),
('672', '2', 'P', '0', '2022-09-14', '09:04:54', '18:24:15', '0', '0', '16781', '1455', '0', NULL, '0', '0'),
('673', '88', 'P', '0', '2022-09-14', '09:09:04', '17:58:12', '0', '0', '15874', '0', '0', NULL, '0', '0'),
('674', '4', 'P', '0', '2022-09-14', '09:18:12', '19:22:46', '0', '0', '18137', '4966', '0', NULL, '0', '0'),
('675', '103', 'P', '0', '2022-09-14', '09:11:31', '18:46:54', '0', '0', '17262', '2814', '0', NULL, '0', '0'),
('676', '1', 'P', '0', '2022-09-14', '09:11:47', '18:43:15', '0', '0', '17144', '2595', '0', NULL, '0', '0'),
('677', '16', 'P', '0', '2022-09-14', '09:41:52', '19:43:32', '0', '0', '18050', '6212', '0', NULL, '0', '0'),
('678', '5', 'P', '0', '2022-09-14', '09:52:09', '18:33:15', '0', '0', '15633', '1995', '0', NULL, '0', '0'),
('679', '3', 'P', '0', '2022-09-14', '10:24:21', '10:24:21', '0', '0', '0', '0', '0', NULL, '0', '0'),
('680', '20', 'P', '0', '2022-09-15', '07:15:10', '18:34:17', '0', '0', '20374', '2057', '0', NULL, '0', '0'),
('681', '18', 'P', '0', '2022-09-15', '07:24:14', '17:40:51', '0', '0', '18499', '0', '0', NULL, '0', '0'),
('682', '87', 'P', '0', '2022-09-15', '07:38:29', '19:35:47', '0', '0', '21519', '5747', '0', NULL, '0', '0'),
('683', '46', 'P', '0', '2022-09-15', '07:39:02', '17:59:08', '0', '0', '18603', '0', '0', NULL, '0', '0'),
('684', '23', 'P', '0', '2022-09-15', '07:42:05', '17:59:12', '0', '0', '18514', '0', '0', NULL, '0', '0'),
('685', '51', 'P', '0', '2022-09-15', '07:44:53', '18:03:10', '0', '0', '18549', '190', '0', NULL, '0', '0'),
('686', '161', 'P', '0', '2022-09-15', '07:48:46', '18:00:14', '0', '0', '18344', '14', '0', NULL, '0', '0'),
('687', '109', 'P', '0', '2022-09-15', '07:49:27', '18:17:45', '0', '0', '18849', '1065', '0', NULL, '0', '0'),
('688', '21', 'P', '0', '2022-09-15', '07:49:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('689', '177', 'P', '0', '2022-09-15', '07:50:20', '22:19:25', '0', '0', '26073', '15565', '0', NULL, '0', '0'),
('690', '70', 'P', '0', '2022-09-15', '07:51:08', '17:59:28', '0', '0', '18250', '0', '0', NULL, '0', '0'),
('691', '173', 'P', '0', '2022-09-15', '07:51:17', '18:00:38', '0', '0', '18281', '38', '0', NULL, '0', '0'),
('692', '35', 'P', '0', '2022-09-15', '07:51:30', '18:01:07', '0', '0', '18289', '67', '0', NULL, '0', '0'),
('693', '130', 'P', '0', '2022-09-15', '07:51:58', '18:16:09', '0', '0', '18726', '969', '0', NULL, '0', '0'),
('694', '189', 'P', '0', '2022-09-15', '07:52:06', '18:16:31', '0', '0', '18733', '991', '0', NULL, '0', '0'),
('695', '47', 'P', '0', '2022-09-15', '07:52:44', '18:16:01', '0', '0', '18699', '961', '0', NULL, '0', '0'),
('696', '43', 'P', '0', '2022-09-15', '07:56:00', '18:16:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('697', '6', 'P', '0', '2022-09-15', '07:56:44', '18:15:41', '0', '0', '18569', '941', '0', NULL, '0', '0'),
('698', '61', 'P', '0', '2022-09-15', '07:56:48', '13:52:12', '0', '0', '10662', '0', '0', NULL, '0', '0'),
('699', '64', 'P', '0', '2022-09-15', '07:56:00', '18:16:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('700', '121', 'P', '0', '2022-09-15', '07:57:59', '17:57:50', '0', '0', '17996', '0', '0', NULL, '0', '0'),
('701', '181', 'P', '0', '2022-09-15', '07:58:54', '17:58:56', '0', '0', '18001', '0', '0', NULL, '0', '0'),
('702', '171', 'P', '0', '2022-09-15', '07:59:05', '17:59:16', '0', '0', '18006', '0', '0', NULL, '0', '0'),
('703', '67', 'P', '0', '2022-09-15', '07:59:45', '17:58:23', '0', '0', '17959', '0', '0', NULL, '0', '0'),
('704', '190', 'P', '0', '2022-09-15', '08:00:09', '13:38:23', '0', '0', '10147', '0', '0', NULL, '0', '0'),
('705', '183', 'P', '0', '2022-09-15', '08:01:06', '18:17:21', '0', '0', '18488', '1041', '0', NULL, '0', '0'),
('706', '182', 'P', '0', '2022-09-15', '08:01:24', '18:15:56', '0', '0', '18436', '956', '0', NULL, '0', '0'),
('707', '25', 'P', '0', '2022-09-15', '08:01:30', '17:58:06', '0', '0', '17898', '0', '0', NULL, '0', '0'),
('708', '147', 'P', '0', '2022-09-15', '08:01:34', '17:59:23', '0', '0', '17935', '0', '0', NULL, '0', '0'),
('709', '15', 'P', '0', '2022-09-15', '08:01:40', '18:02:28', '0', '0', '18024', '148', '0', NULL, '0', '0'),
('710', '143', 'P', '0', '2022-09-15', '08:01:46', '17:58:31', '0', '0', '17903', '0', '0', NULL, '0', '0'),
('711', '14', 'P', '0', '2022-09-15', '08:01:50', '22:20:30', '0', '0', '25760', '15630', '0', NULL, '0', '0'),
('712', '162', 'P', '0', '2022-09-15', '08:03:23', '18:01:03', '0', '0', '17930', '63', '0', NULL, '0', '0'),
('713', '152', 'P', '0', '2022-09-15', '08:03:38', '18:00:28', '0', '0', '17905', '28', '0', NULL, '0', '0'),
('714', '65', 'P', '0', '2022-09-15', '08:03:42', '18:01:32', '0', '0', '17935', '92', '0', NULL, '0', '0'),
('715', '148', 'P', '0', '2022-09-15', '08:03:45', '18:00:18', '0', '0', '17897', '18', '0', NULL, '0', '0'),
('716', '111', 'P', '0', '2022-09-15', '08:03:49', '18:12:45', '0', '0', '18268', '765', '0', NULL, '0', '0'),
('717', '170', 'P', '0', '2022-09-15', '08:04:02', '17:59:25', '0', '0', '17862', '0', '0', NULL, '0', '0'),
('718', '28', 'P', '0', '2022-09-15', '08:04:10', '17:58:59', '0', '0', '17845', '0', '0', NULL, '0', '0'),
('719', '31', 'P', '0', '2022-09-15', '08:04:24', '17:59:19', '0', '0', '17848', '0', '0', NULL, '0', '0'),
('720', '22', 'P', '0', '2022-09-15', '08:07:54', '17:58:34', '0', '0', '17720', '0', '0', NULL, '0', '0'),
('721', '32', 'P', '0', '2022-09-15', '08:08:31', '17:59:03', '0', '0', '17716', '0', '0', NULL, '0', '0'),
('722', '69', 'P', '0', '2022-09-15', '08:08:36', '13:52:07', '0', '0', '10306', '0', '0', NULL, '0', '0'),
('723', '75', 'P', '0', '2022-09-15', '08:08:41', '18:16:23', '0', '0', '18231', '983', '0', NULL, '0', '0'),
('724', '30', 'P', '0', '2022-09-15', '08:09:00', '17:59:36', '0', '0', '17718', '0', '0', NULL, '0', '0'),
('725', '8', 'P', '0', '2022-09-15', '08:09:15', '18:12:19', '0', '0', '18092', '739', '0', NULL, '0', '0'),
('726', '160', 'P', '0', '2022-09-15', '08:09:38', '19:24:44', '0', '0', '20253', '5084', '0', NULL, '0', '0'),
('727', '82', 'P', '0', '2022-09-15', '08:09:59', '08:09:59', '0', '0', '0', '0', '0', NULL, '0', '0'),
('728', '13', 'P', '0', '2022-09-15', '08:10:09', '18:06:20', '0', '0', '17886', '380', '0', NULL, '0', '0'),
('729', '17', 'P', '0', '2022-09-15', '08:10:28', '18:16:14', '0', '0', '18173', '974', '0', NULL, '0', '0'),
('730', '60', 'P', '0', '2022-09-15', '08:10:32', '18:00:02', '0', '0', '17685', '2', '0', NULL, '0', '0'),
('731', '57', 'P', '0', '2022-09-15', '08:10:49', '18:00:06', '0', '0', '17679', '6', '0', NULL, '0', '0'),
('732', '112', 'P', '0', '2022-09-15', '08:10:55', '18:12:32', '0', '0', '18049', '752', '0', NULL, '0', '0'),
('733', '53', 'P', '0', '2022-09-15', '08:12:45', '17:55:12', '0', '0', '17474', '0', '0', NULL, '0', '0'),
('734', '118', 'P', '0', '2022-09-15', '08:15:04', '17:58:17', '0', '0', '17497', '0', '0', NULL, '0', '0'),
('735', '186', 'P', '0', '2022-09-15', '08:15:22', '17:58:45', '0', '0', '17502', '0', '0', NULL, '0', '0'),
('736', '7', 'P', '0', '2022-09-15', '08:20:07', '18:00:51', '0', '0', '17422', '51', '0', NULL, '0', '0'),
('737', '12', 'P', '0', '2022-09-15', '08:20:15', '22:21:04', '0', '0', '25225', '15664', '0', NULL, '0', '0'),
('738', '88', 'P', '0', '2022-09-15', '08:33:00', '17:58:51', '0', '0', '16976', '0', '0', NULL, '0', '0'),
('739', '128', 'P', '0', '2022-09-15', '08:42:49', '18:00:46', '0', '0', '16739', '46', '0', NULL, '0', '0'),
('740', '4', 'P', '0', '2022-09-15', '09:04:08', '19:43:27', '0', '0', '19180', '6207', '0', NULL, '0', '0'),
('741', '2', 'P', '0', '2022-09-15', '09:12:07', '18:17:34', '0', '0', '16364', '1054', '0', NULL, '0', '0'),
('742', '103', 'P', '0', '2022-09-15', '09:11:32', '18:51:09', '0', '0', '17389', '3069', '0', NULL, '0', '0'),
('743', '1', 'P', '0', '2022-09-15', '09:11:42', '18:51:02', '0', '0', '17380', '3062', '0', NULL, '0', '0'),
('744', '5', 'P', '0', '2022-09-15', '09:48:02', '09:48:02', '0', '0', '0', '0', '0', NULL, '0', '0'),
('745', '16', 'P', '0', '2022-09-15', '11:03:03', '11:03:03', '0', '0', '0', '0', '0', NULL, '0', '0'),
('746', '20', 'P', '0', '2022-09-16', '06:57:08', '21:11:46', '0', '0', '25639', '11506', '0', NULL, '0', '0'),
('747', '46', 'P', '0', '2022-09-16', '07:20:33', '17:14:00', '0', '0', '17804', '0', '0', NULL, '0', '0'),
('748', '51', 'P', '0', '2022-09-16', '07:21:35', '07:21:35', '0', '0', '0', '0', '0', NULL, '0', '0'),
('749', '21', 'P', '0', '2022-09-16', '07:21:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('750', '18', 'P', '0', '2022-09-16', '07:26:53', '07:26:53', '0', '0', '0', '0', '0', NULL, '0', '0'),
('751', '87', 'P', '0', '2022-09-16', '07:36:00', '07:36:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('752', '181', 'P', '0', '2022-09-16', '07:43:26', '17:14:12', '0', '0', '17123', '0', '0', NULL, '0', '0'),
('753', '171', 'P', '0', '2022-09-16', '07:44:49', '17:14:04', '0', '0', '17078', '0', '0', NULL, '0', '0'),
('754', '161', 'P', '0', '2022-09-16', '07:46:52', '07:46:52', '0', '0', '0', '0', '0', NULL, '0', '0'),
('755', '152', 'P', '0', '2022-09-16', '07:47:01', '07:47:01', '0', '0', '0', '0', '0', NULL, '0', '0'),
('756', '183', 'P', '0', '2022-09-16', '07:48:00', '17:12:00', '0', '0', '33120', '0', '0', NULL, '0', '0'),
('757', '182', 'P', '0', '2022-09-16', '07:49:06', '17:12:53', '0', '0', '16914', '0', '0', NULL, '0', '0'),
('758', '130', 'P', '0', '2022-09-16', '07:51:00', '07:51:00', '0', '0', '85860', '0', '0', NULL, '0', '0'),
('759', '189', 'P', '0', '2022-09-16', '07:52:00', '17:12:00', '0', '0', '33120', '0', '0', NULL, '0', '0'),
('760', '47', 'P', '0', '2022-09-16', '07:52:00', '17:13:00', '0', '0', '33180', '0', '0', NULL, '0', '0'),
('761', '70', 'P', '0', '2022-09-16', '07:52:40', '07:52:40', '0', '0', '0', '0', '0', NULL, '0', '0'),
('762', '173', 'P', '0', '2022-09-16', '07:52:48', '17:13:48', '0', '0', '16830', '0', '0', NULL, '0', '0'),
('763', '35', 'P', '0', '2022-09-16', '07:53:00', '17:53:00', '0', '0', '35580', '0', '0', NULL, '0', '0'),
('764', '8', 'P', '0', '2022-09-16', '07:54:00', '18:03:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('765', '17', 'P', '0', '2022-09-16', '07:54:17', '07:54:17', '0', '0', '0', '0', '0', NULL, '0', '0'),
('766', '6', 'P', '0', '2022-09-16', '07:54:23', '07:54:23', '0', '0', '0', '0', '0', NULL, '0', '0'),
('767', '25', 'P', '0', '2022-09-16', '07:54:28', '07:54:28', '0', '0', '0', '0', '0', NULL, '0', '0'),
('768', '121', 'P', '0', '2022-09-16', '07:54:53', '17:14:08', '0', '0', '16778', '0', '0', NULL, '0', '0'),
('769', '75', 'P', '0', '2022-09-16', '07:55:00', '07:55:00', '0', '0', '86100', '0', '0', NULL, '0', '0'),
('770', '30', 'P', '0', '2022-09-16', '07:57:57', '17:13:29', '0', '0', '16666', '0', '0', NULL, '0', '0'),
('771', '43', 'P', '0', '2022-09-16', '07:58:00', '17:13:00', '0', '0', '33180', '0', '0', NULL, '0', '0'),
('772', '61', 'P', '0', '2022-09-16', '07:58:08', '17:14:24', '0', '0', '16688', '0', '0', NULL, '0', '0'),
('773', '32', 'P', '0', '2022-09-16', '07:58:12', '17:14:16', '0', '0', '16682', '0', '0', NULL, '0', '0'),
('774', '64', 'P', '0', '2022-09-16', '07:58:00', '07:58:00', '0', '0', '86280', '0', '0', NULL, '0', '0'),
('775', '23', 'P', '0', '2022-09-16', '07:59:18', '17:12:55', '0', '0', '16609', '0', '0', NULL, '0', '0'),
('776', '31', 'P', '0', '2022-09-16', '08:00:25', '08:00:25', '0', '0', '0', '0', '0', NULL, '0', '0'),
('777', '170', 'P', '0', '2022-09-16', '08:00:30', '17:15:19', '0', '0', '16645', '0', '0', NULL, '0', '0'),
('778', '28', 'P', '0', '2022-09-16', '08:00:53', '08:00:53', '0', '0', '0', '0', '0', NULL, '0', '0'),
('779', '148', 'P', '0', '2022-09-16', '08:01:01', '17:13:39', '0', '0', '16579', '0', '0', NULL, '0', '0'),
('780', '111', 'P', '0', '2022-09-16', '08:02:00', '17:13:00', '0', '0', '33060', '0', '0', NULL, '0', '0'),
('781', '60', 'P', '0', '2022-09-16', '08:02:30', '17:13:04', '0', '0', '16517', '0', '0', NULL, '0', '0'),
('782', '57', 'P', '0', '2022-09-16', '08:02:35', '17:13:10', '0', '0', '16518', '0', '0', NULL, '0', '0'),
('783', '112', 'P', '0', '2022-09-16', '08:02:49', '17:13:35', '0', '0', '16523', '0', '0', NULL, '0', '0'),
('784', '82', 'P', '0', '2022-09-16', '08:03:11', '08:03:11', '0', '0', '0', '0', '0', NULL, '0', '0'),
('785', '162', 'P', '0', '2022-09-16', '08:03:42', '17:13:54', '0', '0', '16506', '0', '0', NULL, '0', '0'),
('786', '139', 'P', '0', '2022-09-16', '08:04:00', '17:13:00', '0', '0', '32940', '0', '0', NULL, '0', '0'),
('787', '160', 'P', '0', '2022-09-16', '08:04:18', '08:04:18', '0', '0', '0', '0', '0', NULL, '0', '0'),
('788', '53', 'P', '0', '2022-09-16', '08:04:25', '08:04:25', '0', '0', '0', '0', '0', NULL, '0', '0'),
('789', '22', 'P', '0', '2022-09-16', '08:05:20', '17:12:47', '0', '0', '16424', '0', '0', NULL, '0', '0'),
('790', '14', 'P', '0', '2022-09-16', '08:06:26', '20:35:36', '0', '0', '22475', '9336', '0', NULL, '0', '0'),
('791', '186', 'P', '0', '2022-09-16', '08:08:09', '08:08:09', '0', '0', '0', '0', '0', NULL, '0', '0'),
('792', '147', 'P', '0', '2022-09-16', '08:08:17', '17:13:51', '0', '0', '16367', '0', '0', NULL, '0', '0'),
('793', '143', 'P', '0', '2022-09-16', '08:08:33', '08:08:33', '0', '0', '0', '0', '0', NULL, '0', '0'),
('794', '69', 'P', '0', '2022-09-16', '08:08:44', '12:56:39', '0', '0', '8638', '0', '0', NULL, '0', '0'),
('795', '67', 'P', '0', '2022-09-16', '08:09:28', '08:09:28', '0', '0', '0', '0', '0', NULL, '0', '0'),
('796', '65', 'P', '0', '2022-09-16', '08:09:59', '08:09:59', '0', '0', '0', '0', '0', NULL, '0', '0'),
('797', '177', 'P', '0', '2022-09-16', '08:10:08', '14:36:52', '0', '0', '11602', '0', '0', NULL, '0', '0'),
('798', '118', 'P', '0', '2022-09-16', '08:11:53', '08:11:53', '0', '0', '0', '0', '0', NULL, '0', '0'),
('799', '12', 'P', '0', '2022-09-16', '08:19:30', '20:35:23', '0', '0', '22077', '9323', '0', NULL, '0', '0'),
('800', '13', 'P', '0', '2022-09-16', '08:21:02', '20:35:31', '0', '0', '22035', '9331', '0', NULL, '0', '0'),
('801', '88', 'P', '0', '2022-09-16', '08:29:53', '08:29:53', '0', '0', '0', '0', '0', NULL, '0', '0'),
('802', '128', 'P', '0', '2022-09-16', '08:57:36', '08:57:36', '0', '0', '0', '0', '0', NULL, '0', '0'),
('803', '5', 'P', '0', '2022-09-16', '09:00:44', '09:00:44', '0', '0', '0', '0', '0', NULL, '0', '0'),
('804', '2', 'P', '0', '2022-09-16', '09:05:01', '09:05:01', '0', '0', '0', '0', '0', NULL, '0', '0'),
('805', '103', 'P', '0', '2022-09-16', '09:03:18', '09:03:18', '0', '0', '0', '0', '0', NULL, '0', '0'),
('806', '1', 'P', '0', '2022-09-16', '09:03:36', '09:03:36', '0', '0', '0', '0', '0', NULL, '0', '0'),
('807', '4', 'P', '0', '2022-09-16', '09:39:54', '09:39:54', '0', '0', '0', '0', '0', NULL, '0', '0'),
('808', '16', 'P', '0', '2022-09-16', '09:56:44', '09:56:44', '0', '0', '0', '0', '0', NULL, '0', '0'),
('809', '15', 'P', '0', '2022-09-16', '10:16:26', '10:16:26', '0', '0', '0', '0', '0', NULL, '0', '0'),
('810', '3', 'P', '0', '2022-09-16', '11:02:12', '11:02:12', '0', '0', '0', '0', '0', NULL, '0', '0'),
('811', '14', 'P', '0', '2022-09-17', '08:39:30', '17:38:45', '0', '0', '16178', '0', '0', NULL, '0', '0'),
('812', '13', 'P', '0', '2022-09-17', '09:19:50', '17:41:12', '0', '0', '15041', '0', '0', NULL, '0', '0'),
('813', '12', 'P', '0', '2022-09-17', '09:29:02', '17:37:49', '0', '0', '14664', '0', '0', NULL, '0', '0'),
('814', '18', 'P', '0', '2022-09-17', '10:26:09', '17:44:45', '0', '0', '13158', '0', '0', NULL, '0', '0'),
('815', '31', 'P', '0', '2022-09-17', '13:05:28', '13:05:28', '0', '0', '0', '0', '0', NULL, '0', '0'),
('816', '22', 'P', '0', '2022-09-17', '13:12:22', '17:38:17', '0', '0', '7978', '0', '0', NULL, '0', '0'),
('817', '20', 'P', '0', '2022-09-19', '06:08:33', '18:06:12', '0', '0', '21530', '372', '0', NULL, '0', '0'),
('818', '18', 'P', '0', '2022-09-19', '06:47:21', '19:02:05', '0', '0', '22042', '3725', '0', NULL, '0', '0'),
('819', '87', 'P', '0', '2022-09-19', '06:55:26', '19:34:35', '0', '0', '22775', '5675', '0', NULL, '0', '0'),
('820', '46', 'P', '0', '2022-09-19', '07:40:39', '18:01:20', '0', '0', '18621', '80', '0', NULL, '0', '0'),
('821', '171', 'P', '0', '2022-09-19', '07:46:10', '18:00:49', '0', '0', '18440', '49', '0', NULL, '0', '0'),
('822', '161', 'P', '0', '2022-09-19', '07:46:27', '18:01:34', '0', '0', '18454', '94', '0', NULL, '0', '0'),
('823', '181', 'P', '0', '2022-09-19', '07:46:55', '18:01:50', '0', '0', '18448', '110', '0', NULL, '0', '0'),
('824', '23', 'P', '0', '2022-09-19', '07:48:01', '18:01:15', '0', '0', '18397', '75', '0', NULL, '0', '0'),
('825', '51', 'P', '0', '2022-09-19', '07:50:42', '17:59:18', '0', '0', '18258', '0', '0', NULL, '0', '0'),
('826', '21', 'P', '0', '2022-09-19', '07:50:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('827', '177', 'P', '0', '2022-09-19', '07:52:22', '19:18:30', '0', '0', '20584', '4710', '0', NULL, '0', '0'),
('828', '130', 'P', '0', '2022-09-19', '07:53:00', '16:09:00', '0', '0', '29340', '0', '0', NULL, '0', '0'),
('829', '189', 'P', '0', '2022-09-19', '07:53:00', '16:09:00', '0', '0', '29340', '0', '0', NULL, '0', '0'),
('830', '60', 'P', '0', '2022-09-19', '07:54:04', '18:00:03', '0', '0', '18180', '3', '0', NULL, '0', '0'),
('831', '152', 'P', '0', '2022-09-19', '07:54:22', '18:04:33', '0', '0', '18306', '273', '0', NULL, '0', '0'),
('832', '57', 'P', '0', '2022-09-19', '07:54:31', '18:00:53', '0', '0', '18191', '53', '0', NULL, '0', '0'),
('833', '139', 'P', '0', '2022-09-19', '07:54:00', '18:01:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('834', '43', 'P', '0', '2022-09-19', '07:54:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('835', '47', 'P', '0', '2022-09-19', '07:54:00', '18:01:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('836', '61', 'P', '0', '2022-09-19', '07:55:22', '18:00:46', '0', '0', '18162', '46', '0', NULL, '0', '0'),
('837', '25', 'P', '0', '2022-09-19', '07:55:30', '18:01:06', '0', '0', '18168', '66', '0', NULL, '0', '0'),
('838', '6', 'P', '0', '2022-09-19', '07:55:36', '18:34:53', '0', '0', '19179', '2093', '0', NULL, '0', '0'),
('839', '121', 'P', '0', '2022-09-19', '07:55:48', '18:00:42', '0', '0', '18147', '42', '0', NULL, '0', '0'),
('840', '64', 'P', '0', '2022-09-19', '07:58:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('841', '173', 'P', '0', '2022-09-19', '07:59:40', '18:00:40', '0', '0', '18030', '40', '0', NULL, '0', '0'),
('842', '75', 'P', '0', '2022-09-19', '07:59:00', '21:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('843', '111', 'P', '0', '2022-09-19', '08:00:00', '18:01:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('844', '53', 'P', '0', '2022-09-19', '08:01:15', '17:59:52', '0', '0', '17959', '0', '0', NULL, '0', '0'),
('845', '8', 'P', '0', '2022-09-19', '08:02:00', '18:35:00', '0', '0', '35880', '0', '0', NULL, '0', '0'),
('846', '17', 'P', '0', '2022-09-19', '08:02:10', '18:12:37', '0', '0', '18314', '757', '0', NULL, '0', '0'),
('847', '109', 'P', '0', '2022-09-19', '08:02:21', '18:03:01', '0', '0', '18020', '181', '0', NULL, '0', '0'),
('848', '170', 'P', '0', '2022-09-19', '08:02:37', '18:02:11', '0', '0', '17987', '131', '0', NULL, '0', '0'),
('849', '15', 'P', '0', '2022-09-19', '08:02:42', '18:07:56', '0', '0', '18157', '476', '0', NULL, '0', '0'),
('850', '28', 'P', '0', '2022-09-19', '08:02:51', '18:02:00', '0', '0', '17975', '120', '0', NULL, '0', '0'),
('851', '31', 'P', '0', '2022-09-19', '08:02:53', '18:00:27', '0', '0', '17927', '27', '0', NULL, '0', '0'),
('852', '182', 'P', '0', '2022-09-19', '08:03:02', '18:01:04', '0', '0', '17941', '64', '0', NULL, '0', '0'),
('853', '148', 'P', '0', '2022-09-19', '08:03:16', '18:01:28', '0', '0', '17946', '88', '0', NULL, '0', '0'),
('854', '32', 'P', '0', '2022-09-19', '08:04:19', '18:10:35', '0', '0', '18188', '635', '0', NULL, '0', '0'),
('855', '30', 'P', '0', '2022-09-19', '08:04:42', '18:15:20', '0', '0', '18319', '920', '0', NULL, '0', '0'),
('856', '70', 'P', '0', '2022-09-19', '08:05:37', '18:00:25', '0', '0', '17844', '25', '0', NULL, '0', '0'),
('857', '147', 'P', '0', '2022-09-19', '08:05:43', '18:02:04', '0', '0', '17891', '124', '0', NULL, '0', '0'),
('858', '35', 'P', '0', '2022-09-19', '08:05:00', '21:00:00', '0', '0', '35700', '0', '0', NULL, '0', '0'),
('859', '160', 'P', '0', '2022-09-19', '08:05:54', '18:07:45', '0', '0', '18056', '465', '0', NULL, '0', '0'),
('860', '143', 'P', '0', '2022-09-19', '08:06:03', '18:00:34', '0', '0', '17836', '34', '0', NULL, '0', '0'),
('861', '162', 'P', '0', '2022-09-19', '08:06:16', '18:01:11', '0', '0', '17848', '71', '0', NULL, '0', '0'),
('862', '112', 'P', '0', '2022-09-19', '08:06:43', '18:04:47', '0', '0', '17942', '287', '0', NULL, '0', '0'),
('863', '190', 'P', '0', '2022-09-19', '08:06:52', '18:10:13', '0', '0', '18101', '613', '0', NULL, '0', '0'),
('864', '69', 'P', '0', '2022-09-19', '08:06:57', '18:00:29', '0', '0', '17806', '29', '0', NULL, '0', '0'),
('865', '128', 'P', '0', '2022-09-19', '08:07:27', '18:07:37', '0', '0', '18005', '457', '0', NULL, '0', '0'),
('866', '65', 'P', '0', '2022-09-19', '08:08:37', '18:01:46', '0', '0', '17795', '106', '0', NULL, '0', '0'),
('867', '22', 'P', '0', '2022-09-19', '08:10:05', '18:02:18', '0', '0', '17767', '138', '0', NULL, '0', '0'),
('868', '118', 'P', '0', '2022-09-19', '08:11:01', '18:02:07', '0', '0', '17733', '127', '0', NULL, '0', '0'),
('869', '82', 'P', '0', '2022-09-19', '08:12:17', '17:59:54', '0', '0', '17629', '0', '0', NULL, '0', '0'),
('870', '13', 'P', '0', '2022-09-19', '08:12:54', '20:59:56', '0', '0', '23011', '10796', '0', NULL, '0', '0'),
('871', '14', 'P', '0', '2022-09-19', '08:13:51', '20:58:07', '0', '0', '22928', '10687', '0', NULL, '0', '0'),
('872', '67', 'P', '0', '2022-09-19', '08:23:05', '18:03:15', '0', '0', '17405', '195', '0', NULL, '0', '0'),
('873', '7', 'P', '0', '2022-09-19', '08:25:09', '18:05:06', '0', '0', '17399', '306', '0', NULL, '0', '0'),
('874', '88', 'P', '0', '2022-09-19', '08:25:42', '18:01:56', '0', '0', '17287', '116', '0', NULL, '0', '0'),
('875', '12', 'P', '0', '2022-09-19', '08:26:02', '20:57:29', '0', '0', '22544', '10649', '0', NULL, '0', '0'),
('876', '186', 'P', '0', '2022-09-19', '08:38:48', '18:00:07', '0', '0', '16840', '7', '0', NULL, '0', '0'),
('877', '2', 'P', '0', '2022-09-19', '09:07:14', '18:17:46', '0', '0', '16516', '1066', '0', NULL, '0', '0'),
('878', '5', 'P', '0', '2022-09-19', '09:15:35', '18:20:53', '0', '0', '16359', '1253', '0', NULL, '0', '0'),
('879', '103', 'P', '0', '2022-09-19', '09:14:25', '18:23:42', '0', '0', '16479', '1422', '0', NULL, '0', '0'),
('880', '1', 'P', '0', '2022-09-19', '09:14:45', '18:25:15', '0', '0', '16515', '1515', '0', NULL, '0', '0'),
('881', '16', 'P', '0', '2022-09-19', '10:15:37', '19:31:00', '0', '0', '16662', '5460', '0', NULL, '0', '0'),
('882', '3', 'P', '0', '2022-09-19', '10:27:32', '19:15:09', '0', '0', '15829', '4509', '0', NULL, '0', '0'),
('883', '20', 'P', '0', '2022-09-20', '06:13:37', '18:37:49', '0', '0', '22326', '2269', '0', NULL, '0', '0'),
('884', '18', 'P', '0', '2022-09-20', '06:49:32', '17:55:21', '0', '0', '19975', '0', '0', NULL, '0', '0'),
('885', '87', 'P', '0', '2022-09-20', '06:55:42', '19:16:37', '0', '0', '22228', '4597', '0', NULL, '0', '0'),
('886', '21', 'P', '0', '2022-09-20', '07:37:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('887', '51', 'P', '0', '2022-09-20', '07:37:17', '18:00:26', '0', '0', '18695', '26', '0', NULL, '0', '0'),
('888', '75', 'P', '0', '2022-09-20', '07:39:00', '17:57:00', '0', '0', '35820', '0', '0', NULL, '0', '0'),
('889', '177', 'P', '0', '2022-09-20', '07:42:53', '18:55:29', '0', '0', '20178', '3329', '0', NULL, '0', '0'),
('890', '181', 'P', '0', '2022-09-20', '07:49:14', '18:00:31', '0', '0', '18339', '31', '0', NULL, '0', '0'),
('891', '161', 'P', '0', '2022-09-20', '07:49:21', '18:00:38', '0', '0', '18339', '38', '0', NULL, '0', '0'),
('892', '171', 'P', '0', '2022-09-20', '07:49:45', '18:00:17', '0', '0', '18316', '17', '0', NULL, '0', '0'),
('893', '152', 'P', '0', '2022-09-20', '07:50:40', '18:00:45', '0', '0', '18303', '45', '0', NULL, '0', '0'),
('894', '183', 'P', '0', '2022-09-20', '07:51:00', '17:58:00', '0', '0', '35880', '0', '0', NULL, '0', '0'),
('895', '121', 'P', '0', '2022-09-20', '07:51:35', '17:57:31', '0', '0', '18178', '0', '0', NULL, '0', '0'),
('896', '25', 'P', '0', '2022-09-20', '07:51:40', '17:57:59', '0', '0', '18190', '0', '0', NULL, '0', '0'),
('897', '6', 'P', '0', '2022-09-20', '07:52:01', '18:50:40', '0', '0', '19760', '3040', '0', NULL, '0', '0'),
('898', '46', 'P', '0', '2022-09-20', '07:52:05', '18:00:13', '0', '0', '18244', '13', '0', NULL, '0', '0'),
('899', '148', 'P', '0', '2022-09-20', '07:52:09', '18:00:34', '0', '0', '18253', '34', '0', NULL, '0', '0'),
('900', '182', 'P', '0', '2022-09-20', '07:52:13', '17:58:15', '0', '0', '18181', '0', '0', NULL, '0', '0'),
('901', '60', 'P', '0', '2022-09-20', '07:53:02', '18:00:10', '0', '0', '18214', '10', '0', NULL, '0', '0'),
('902', '57', 'P', '0', '2022-09-20', '07:53:16', '18:00:22', '0', '0', '18213', '22', '0', NULL, '0', '0'),
('903', '53', 'P', '0', '2022-09-20', '07:53:57', '17:58:40', '0', '0', '18142', '0', '0', NULL, '0', '0'),
('904', '109', 'P', '0', '2022-09-20', '07:55:15', '17:57:19', '0', '0', '18062', '0', '0', NULL, '0', '0'),
('905', '130', 'P', '0', '2022-09-20', '07:55:00', '17:58:00', '0', '0', '35880', '0', '0', NULL, '0', '0'),
('906', '189', 'P', '0', '2022-09-20', '07:55:00', '17:58:00', '0', '0', '35880', '0', '0', NULL, '0', '0'),
('907', '47', 'P', '0', '2022-09-20', '07:55:00', '18:04:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('908', '147', 'P', '0', '2022-09-20', '07:57:19', '18:01:04', '0', '0', '18113', '64', '0', NULL, '0', '0'),
('909', '143', 'P', '0', '2022-09-20', '07:57:34', '17:59:31', '0', '0', '18059', '0', '0', NULL, '0', '0'),
('910', '70', 'P', '0', '2022-09-20', '07:57:41', '18:00:57', '0', '0', '18098', '57', '0', NULL, '0', '0'),
('911', '173', 'P', '0', '2022-09-20', '07:57:47', '18:01:07', '0', '0', '18100', '67', '0', NULL, '0', '0'),
('912', '35', 'P', '0', '2022-09-20', '07:58:00', '07:58:00', '0', '0', '86280', '0', '0', NULL, '0', '0'),
('913', '64', 'P', '0', '2022-09-20', '07:59:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('914', '69', 'P', '0', '2022-09-20', '07:59:08', '17:57:37', '0', '0', '17955', '0', '0', NULL, '0', '0'),
('915', '14', 'P', '0', '2022-09-20', '08:02:12', '19:15:23', '0', '0', '20196', '4523', '0', NULL, '0', '0'),
('916', '17', 'P', '0', '2022-09-20', '08:02:48', '18:02:57', '0', '0', '18005', '177', '0', NULL, '0', '0'),
('917', '23', 'P', '0', '2022-09-20', '08:02:57', '17:53:02', '0', '0', '17703', '0', '0', NULL, '0', '0'),
('918', '128', 'P', '0', '2022-09-20', '08:03:05', '18:07:19', '0', '0', '18127', '439', '0', NULL, '0', '0'),
('919', '15', 'P', '0', '2022-09-20', '08:03:27', '18:15:57', '0', '0', '18375', '957', '0', NULL, '0', '0'),
('920', '111', 'P', '0', '2022-09-20', '08:03:00', '18:03:00', '0', '0', '35820', '0', '0', NULL, '0', '0'),
('921', '43', 'P', '0', '2022-09-20', '08:03:00', '17:58:00', '0', '0', '35700', '0', '0', NULL, '0', '0'),
('922', '61', 'P', '0', '2022-09-20', '08:03:46', '17:58:52', '0', '0', '17853', '0', '0', NULL, '0', '0'),
('923', '31', 'P', '0', '2022-09-20', '08:04:02', '17:58:58', '0', '0', '17848', '0', '0', NULL, '0', '0'),
('924', '170', 'P', '0', '2022-09-20', '08:04:06', '18:00:48', '0', '0', '17901', '48', '0', NULL, '0', '0'),
('925', '190', 'P', '0', '2022-09-20', '08:04:10', '17:58:47', '0', '0', '17839', '0', '0', NULL, '0', '0'),
('926', '28', 'P', '0', '2022-09-20', '08:04:19', '17:58:35', '0', '0', '17828', '0', '0', NULL, '0', '0'),
('927', '162', 'P', '0', '2022-09-20', '08:04:43', '17:57:46', '0', '0', '17792', '0', '0', NULL, '0', '0'),
('928', '32', 'P', '0', '2022-09-20', '08:05:16', '17:59:02', '0', '0', '17813', '0', '0', NULL, '0', '0'),
('929', '30', 'P', '0', '2022-09-20', '08:05:29', '17:58:10', '0', '0', '17781', '0', '0', NULL, '0', '0'),
('930', '8', 'P', '0', '2022-09-20', '08:06:00', '18:07:00', '0', '0', '35640', '0', '0', NULL, '0', '0'),
('931', '139', 'P', '0', '2022-09-20', '08:06:00', '17:58:00', '0', '0', '35520', '0', '0', NULL, '0', '0'),
('932', '112', 'P', '0', '2022-09-20', '08:06:18', '18:06:31', '0', '0', '18007', '391', '0', NULL, '0', '0'),
('933', '160', 'P', '0', '2022-09-20', '08:06:29', '18:08:12', '0', '0', '18052', '492', '0', NULL, '0', '0'),
('934', '82', 'P', '0', '2022-09-20', '08:06:42', '17:57:53', '0', '0', '17736', '0', '0', NULL, '0', '0'),
('935', '65', 'P', '0', '2022-09-20', '08:08:29', '17:59:59', '0', '0', '17745', '0', '0', NULL, '0', '0'),
('936', '118', 'P', '0', '2022-09-20', '08:08:54', '17:57:25', '0', '0', '17656', '0', '0', NULL, '0', '0');
INSERT INTO `0_kv_empl_attendance` VALUES
('937', '67', 'P', '0', '2022-09-20', '08:09:13', '18:04:16', '0', '0', '17852', '256', '0', NULL, '0', '0'),
('938', '13', 'P', '0', '2022-09-20', '08:12:40', '19:13:23', '0', '0', '19822', '4403', '0', NULL, '0', '0'),
('939', '22', 'P', '0', '2022-09-20', '08:14:14', '17:53:59', '0', '0', '17393', '0', '0', NULL, '0', '0'),
('940', '12', 'P', '0', '2022-09-20', '08:23:01', '19:13:10', '0', '0', '19505', '4390', '0', NULL, '0', '0'),
('941', '88', 'P', '0', '2022-09-20', '09:03:43', '17:58:03', '0', '0', '16030', '0', '0', NULL, '0', '0'),
('942', '2', 'P', '0', '2022-09-20', '09:16:52', '18:18:43', '0', '0', '16256', '1123', '0', NULL, '0', '0'),
('943', '5', 'P', '0', '2022-09-20', '09:22:45', '18:22:10', '0', '0', '16183', '1330', '0', NULL, '0', '0'),
('944', '103', 'P', '0', '2022-09-20', '09:07:16', '18:34:49', '0', '0', '17027', '2089', '0', NULL, '0', '0'),
('945', '1', 'P', '0', '2022-09-20', '09:07:44', '18:36:19', '0', '0', '17058', '2179', '0', NULL, '0', '0'),
('946', '4', 'P', '0', '2022-09-20', '10:01:50', '17:50:50', '0', '0', '14070', '0', '0', NULL, '0', '0'),
('947', '3', 'P', '0', '2022-09-20', '10:28:52', '10:28:52', '0', '0', '0', '0', '0', NULL, '0', '0'),
('948', '191', 'P', '0', '2022-09-20', '10:49:52', '10:49:52', '0', '0', '0', '0', '0', NULL, '0', '0'),
('949', '192', 'P', '0', '2022-09-20', '11:00:37', '18:39:16', '0', '0', '13760', '2356', '0', NULL, '0', '0'),
('950', '7', 'P', '0', '2022-09-20', '13:44:15', '18:08:04', '0', '0', '7915', '484', '0', NULL, '0', '0'),
('951', '192', 'P', '0', '2022-09-21', '05:57:02', '18:12:17', '0', '0', '22058', '737', '0', NULL, '0', '0'),
('952', '20', 'P', '0', '2022-09-21', '06:21:38', '18:28:27', '0', '0', '21805', '1707', '0', NULL, '0', '0'),
('953', '18', 'P', '0', '2022-09-21', '06:45:29', '18:00:39', '0', '0', '20255', '39', '0', NULL, '0', '0'),
('954', '87', 'P', '0', '2022-09-21', '07:08:59', '19:08:02', '0', '0', '21572', '4082', '0', NULL, '0', '0'),
('955', '46', 'P', '0', '2022-09-21', '07:42:06', '18:10:44', '0', '0', '18859', '644', '0', NULL, '0', '0'),
('956', '57', 'P', '0', '2022-09-21', '07:47:32', '18:02:06', '0', '0', '18437', '126', '0', NULL, '0', '0'),
('957', '60', 'P', '0', '2022-09-21', '07:47:46', '18:02:00', '0', '0', '18427', '120', '0', NULL, '0', '0'),
('958', '161', 'P', '0', '2022-09-21', '07:48:52', '18:01:04', '0', '0', '18366', '64', '0', NULL, '0', '0'),
('959', '181', 'P', '0', '2022-09-21', '07:50:00', '18:07:55', '0', '0', '18538', '475', '0', NULL, '0', '0'),
('960', '171', 'P', '0', '2022-09-21', '07:50:11', '18:02:13', '0', '0', '18361', '133', '0', NULL, '0', '0'),
('961', '183', 'P', '0', '2022-09-21', '07:50:00', '17:59:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('962', '182', 'P', '0', '2022-09-21', '07:51:02', '17:59:40', '0', '0', '18259', '0', '0', NULL, '0', '0'),
('963', '51', 'P', '0', '2022-09-21', '07:53:00', '18:10:39', '0', '0', '18530', '639', '0', NULL, '0', '0'),
('964', '21', 'P', '0', '2022-09-21', '07:53:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('965', '189', 'P', '0', '2022-09-21', '07:53:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('966', '147', 'P', '0', '2022-09-21', '07:54:16', '18:08:20', '0', '0', '18422', '500', '0', NULL, '0', '0'),
('967', '25', 'P', '0', '2022-09-21', '07:54:21', '17:59:17', '0', '0', '18148', '0', '0', NULL, '0', '0'),
('968', '47', 'P', '0', '2022-09-21', '07:54:00', '19:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('969', '23', 'P', '0', '2022-09-21', '07:54:45', '17:59:23', '0', '0', '18139', '0', '0', NULL, '0', '0'),
('970', '139', 'P', '0', '2022-09-21', '07:55:00', '19:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('971', '143', 'P', '0', '2022-09-21', '07:55:20', '18:11:36', '0', '0', '18488', '696', '0', NULL, '0', '0'),
('972', '6', 'P', '0', '2022-09-21', '07:55:25', '19:05:50', '0', '0', '20113', '3950', '0', NULL, '0', '0'),
('973', '173', 'P', '0', '2022-09-21', '07:56:48', '18:12:08', '0', '0', '18460', '728', '0', NULL, '0', '0'),
('974', '70', 'P', '0', '2022-09-21', '07:57:11', '18:12:00', '0', '0', '18445', '720', '0', NULL, '0', '0'),
('975', '64', 'P', '0', '2022-09-21', '07:57:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('976', '121', 'P', '0', '2022-09-21', '07:58:42', '17:58:47', '0', '0', '18003', '0', '0', NULL, '0', '0'),
('977', '112', 'P', '0', '2022-09-21', '07:59:17', '18:00:21', '0', '0', '18032', '21', '0', NULL, '0', '0'),
('978', '69', 'P', '0', '2022-09-21', '07:59:44', '18:06:52', '0', '0', '18214', '412', '0', NULL, '0', '0'),
('979', '43', 'P', '0', '2022-09-21', '07:59:00', '19:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('980', '109', 'P', '0', '2022-09-21', '08:00:08', '18:15:50', '0', '0', '18471', '950', '0', NULL, '0', '0'),
('981', '191', 'P', '0', '2022-09-21', '08:00:19', '18:12:04', '0', '0', '18353', '724', '0', NULL, '0', '0'),
('982', '61', 'P', '0', '2022-09-21', '08:00:25', '18:09:37', '0', '0', '18276', '577', '0', NULL, '0', '0'),
('983', '35', 'P', '0', '2022-09-21', '08:01:00', '17:59:00', '0', '0', '35880', '0', '0', NULL, '0', '0'),
('984', '15', 'P', '0', '2022-09-21', '08:02:32', '18:21:11', '0', '0', '18560', '1271', '0', NULL, '0', '0'),
('985', '148', 'P', '0', '2022-09-21', '08:03:20', '18:07:59', '0', '0', '18140', '479', '0', NULL, '0', '0'),
('986', '190', 'P', '0', '2022-09-21', '08:03:45', '18:13:44', '0', '0', '18300', '824', '0', NULL, '0', '0'),
('987', '186', 'P', '0', '2022-09-21', '08:04:07', '18:02:23', '0', '0', '17948', '143', '0', NULL, '0', '0'),
('988', '67', 'P', '0', '2022-09-21', '08:04:42', '18:13:31', '0', '0', '18265', '811', '0', NULL, '0', '0'),
('989', '31', 'P', '0', '2022-09-21', '08:05:10', '17:58:56', '0', '0', '17813', '0', '0', NULL, '0', '0'),
('990', '170', 'P', '0', '2022-09-21', '08:05:13', '17:59:32', '0', '0', '17830', '0', '0', NULL, '0', '0'),
('991', '28', 'P', '0', '2022-09-21', '08:05:18', '18:00:24', '0', '0', '17853', '24', '0', NULL, '0', '0'),
('992', '30', 'P', '0', '2022-09-21', '08:05:44', '18:08:15', '0', '0', '18076', '495', '0', NULL, '0', '0'),
('993', '160', 'P', '0', '2022-09-21', '08:05:48', '18:11:04', '0', '0', '18158', '664', '0', NULL, '0', '0'),
('994', '111', 'P', '0', '2022-09-21', '08:06:00', '19:00:00', '0', '0', '35640', '0', '0', NULL, '0', '0'),
('995', '75', 'P', '0', '2022-09-21', '08:06:00', '19:00:00', '0', '0', '35640', '0', '0', NULL, '0', '0'),
('996', '13', 'P', '0', '2022-09-21', '08:06:45', '18:10:10', '0', '0', '18103', '610', '0', NULL, '0', '0'),
('997', '88', 'P', '0', '2022-09-21', '08:07:07', '18:00:35', '0', '0', '17804', '35', '0', NULL, '0', '0'),
('998', '14', 'P', '0', '2022-09-21', '08:07:21', '18:16:44', '0', '0', '18282', '1004', '0', NULL, '0', '0'),
('999', '152', 'P', '0', '2022-09-21', '08:07:34', '18:08:05', '0', '0', '18016', '485', '0', NULL, '0', '0'),
('1000', '53', 'P', '0', '2022-09-21', '08:07:41', '18:00:49', '0', '0', '17794', '49', '0', NULL, '0', '0'),
('1001', '65', 'P', '0', '2022-09-21', '08:08:06', '18:00:02', '0', '0', '17758', '2', '0', NULL, '0', '0'),
('1002', '128', 'P', '0', '2022-09-21', '08:08:38', '18:12:50', '0', '0', '18126', '770', '0', NULL, '0', '0'),
('1003', '82', 'P', '0', '2022-09-21', '08:09:22', '18:02:27', '0', '0', '17793', '147', '0', NULL, '0', '0'),
('1004', '177', 'P', '0', '2022-09-21', '08:10:17', '18:33:03', '0', '0', '18683', '1983', '0', NULL, '0', '0'),
('1005', '118', 'P', '0', '2022-09-21', '08:13:49', '18:10:32', '0', '0', '17902', '632', '0', NULL, '0', '0'),
('1006', '32', 'P', '0', '2022-09-21', '08:14:26', '10:39:07', '0', '0', '4341', '0', '0', NULL, '0', '0'),
('1007', '22', 'P', '0', '2022-09-21', '08:14:32', '18:02:30', '0', '0', '17639', '150', '0', NULL, '0', '0'),
('1008', '8', 'P', '0', '2022-09-21', '08:15:00', '18:56:00', '0', '0', '35100', '0', '0', NULL, '0', '0'),
('1009', '7', 'P', '0', '2022-09-21', '08:26:31', '18:11:14', '0', '0', '17542', '674', '0', NULL, '0', '0'),
('1010', '12', 'P', '0', '2022-09-21', '08:27:34', '18:12:23', '0', '0', '17545', '743', '0', NULL, '0', '0'),
('1011', '5', 'P', '0', '2022-09-21', '09:04:23', '19:01:27', '0', '0', '17912', '3687', '0', NULL, '0', '0'),
('1012', '2', 'P', '0', '2022-09-21', '09:08:18', '18:39:02', '0', '0', '17122', '2342', '0', NULL, '0', '0'),
('1013', '4', 'P', '0', '2022-09-21', '09:14:18', '18:38:57', '0', '0', '16940', '2337', '0', NULL, '0', '0'),
('1014', '103', 'P', '0', '2022-09-21', '09:02:49', '18:39:32', '0', '0', '17302', '2372', '0', NULL, '0', '0'),
('1015', '1', 'P', '0', '2022-09-21', '09:02:08', '18:41:55', '0', '0', '17394', '2515', '0', NULL, '0', '0'),
('1016', '16', 'P', '0', '2022-09-21', '09:44:48', '19:33:57', '0', '0', '17675', '5637', '0', NULL, '0', '0'),
('1017', '3', 'P', '0', '2022-09-21', '10:27:32', '10:27:32', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1018', '162', 'P', '0', '2022-09-21', '10:33:21', '17:59:27', '0', '0', '13383', '0', '0', NULL, '0', '0'),
('1019', '192', 'P', '0', '2022-09-22', '06:04:48', '17:40:36', '0', '0', '20874', '0', '0', NULL, '0', '0'),
('1020', '18', 'P', '0', '2022-09-22', '06:52:50', '18:06:35', '0', '0', '20213', '395', '0', NULL, '0', '0'),
('1021', '20', 'P', '0', '2022-09-22', '06:54:41', '18:59:39', '0', '0', '21749', '3579', '0', NULL, '0', '0'),
('1022', '87', 'P', '0', '2022-09-22', '07:23:27', '19:00:33', '0', '0', '20913', '3633', '0', NULL, '0', '0'),
('1023', '191', 'P', '0', '2022-09-22', '07:39:33', '18:06:50', '0', '0', '18819', '410', '0', NULL, '0', '0'),
('1024', '46', 'P', '0', '2022-09-22', '07:42:24', '18:01:51', '0', '0', '18584', '111', '0', NULL, '0', '0'),
('1025', '75', 'P', '0', '2022-09-22', '07:42:00', '20:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1026', '177', 'P', '0', '2022-09-22', '07:44:49', '19:15:35', '0', '0', '20723', '4535', '0', NULL, '0', '0'),
('1027', '161', 'P', '0', '2022-09-22', '07:47:55', '18:00:41', '0', '0', '18383', '41', '0', NULL, '0', '0'),
('1028', '60', 'P', '0', '2022-09-22', '07:51:23', '18:00:30', '0', '0', '18274', '30', '0', NULL, '0', '0'),
('1029', '57', 'P', '0', '2022-09-22', '07:51:58', '18:00:34', '0', '0', '18258', '34', '0', NULL, '0', '0'),
('1030', '183', 'P', '0', '2022-09-22', '07:53:00', '18:02:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1031', '182', 'P', '0', '2022-09-22', '07:53:39', '18:02:30', '0', '0', '18266', '150', '0', NULL, '0', '0'),
('1032', '25', 'P', '0', '2022-09-22', '07:54:52', '18:02:14', '0', '0', '18221', '134', '0', NULL, '0', '0'),
('1033', '23', 'P', '0', '2022-09-22', '07:54:56', '18:00:38', '0', '0', '18171', '38', '0', NULL, '0', '0'),
('1034', '121', 'P', '0', '2022-09-22', '07:55:29', '18:02:11', '0', '0', '18201', '131', '0', NULL, '0', '0'),
('1035', '6', 'P', '0', '2022-09-22', '07:56:32', '18:56:53', '0', '0', '19811', '3413', '0', NULL, '0', '0'),
('1036', '130', 'P', '0', '2022-09-22', '07:56:00', '18:01:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1037', '189', 'P', '0', '2022-09-22', '07:56:51', '18:01:15', '0', '0', '18132', '75', '0', NULL, '0', '0'),
('1038', '15', 'P', '0', '2022-09-22', '07:56:56', '18:02:37', '0', '0', '18171', '157', '0', NULL, '0', '0'),
('1039', '47', 'P', '0', '2022-09-22', '07:57:00', '20:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1040', '65', 'P', '0', '2022-09-22', '07:58:04', '18:00:24', '0', '0', '18070', '24', '0', NULL, '0', '0'),
('1041', '43', 'P', '0', '2022-09-22', '07:58:00', '20:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1042', '61', 'P', '0', '2022-09-22', '07:59:02', '18:00:07', '0', '0', '18033', '7', '0', NULL, '0', '0'),
('1043', '139', 'P', '0', '2022-09-22', '07:59:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1044', '148', 'P', '0', '2022-09-22', '07:59:32', '18:01:47', '0', '0', '18068', '107', '0', NULL, '0', '0'),
('1045', '21', 'P', '0', '2022-09-22', '07:59:00', '17:59:00', '0', '0', '35940', '0', '0', NULL, '0', '0'),
('1046', '51', 'P', '0', '2022-09-22', '07:59:39', '18:00:22', '0', '0', '18022', '22', '0', NULL, '0', '0'),
('1047', '70', 'P', '0', '2022-09-22', '07:59:46', '18:01:40', '0', '0', '18057', '100', '0', NULL, '0', '0'),
('1048', '190', 'P', '0', '2022-09-22', '07:59:54', '18:13:47', '0', '0', '18417', '827', '0', NULL, '0', '0'),
('1049', '173', 'P', '0', '2022-09-22', '07:59:58', '12:59:50', '0', '0', '8996', '0', '0', NULL, '0', '0'),
('1050', '171', 'P', '0', '2022-09-22', '08:00:05', '18:00:11', '0', '0', '18003', '11', '0', NULL, '0', '0'),
('1051', '181', 'P', '0', '2022-09-22', '08:00:09', '18:01:19', '0', '0', '18035', '79', '0', NULL, '0', '0'),
('1052', '152', 'P', '0', '2022-09-22', '08:00:19', '18:00:48', '0', '0', '18015', '48', '0', NULL, '0', '0'),
('1053', '35', 'P', '0', '2022-09-22', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1054', '64', 'A', '0', '2022-09-22', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1055', '8', 'P', '0', '2022-09-22', '08:02:00', '18:08:00', '0', '0', '35880', '0', '0', NULL, '0', '0'),
('1056', '67', 'P', '0', '2022-09-22', '08:03:22', '18:02:22', '0', '0', '17970', '142', '0', NULL, '0', '0'),
('1057', '162', 'P', '0', '2022-09-22', '08:03:39', '17:59:46', '0', '0', '17884', '0', '0', NULL, '0', '0'),
('1058', '112', 'P', '0', '2022-09-22', '08:03:45', '18:01:09', '0', '0', '17922', '69', '0', NULL, '0', '0'),
('1059', '109', 'P', '0', '2022-09-22', '08:05:26', '18:01:02', '0', '0', '17868', '62', '0', NULL, '0', '0'),
('1060', '32', 'P', '0', '2022-09-22', '08:06:19', '18:08:25', '0', '0', '18063', '505', '0', NULL, '0', '0'),
('1061', '30', 'P', '0', '2022-09-22', '08:06:30', '18:08:54', '0', '0', '18072', '534', '0', NULL, '0', '0'),
('1062', '53', 'P', '0', '2022-09-22', '08:06:46', '18:00:26', '0', '0', '17810', '26', '0', NULL, '0', '0'),
('1063', '118', 'P', '0', '2022-09-22', '08:06:55', '18:01:44', '0', '0', '17845', '104', '0', NULL, '0', '0'),
('1064', '170', 'P', '0', '2022-09-22', '08:07:38', '17:59:42', '0', '0', '17762', '0', '0', NULL, '0', '0'),
('1065', '31', 'P', '0', '2022-09-22', '08:07:43', '18:00:53', '0', '0', '17795', '53', '0', NULL, '0', '0'),
('1066', '28', 'P', '0', '2022-09-22', '08:07:54', '18:05:07', '0', '0', '17917', '307', '0', NULL, '0', '0'),
('1067', '160', 'P', '0', '2022-09-22', '08:08:51', '18:09:11', '0', '0', '18010', '551', '0', NULL, '0', '0'),
('1068', '69', 'P', '0', '2022-09-22', '08:09:16', '18:00:03', '0', '0', '17724', '3', '0', NULL, '0', '0'),
('1069', '128', 'P', '0', '2022-09-22', '08:10:35', '18:04:45', '0', '0', '17825', '285', '0', NULL, '0', '0'),
('1070', '186', 'P', '0', '2022-09-22', '08:10:45', '18:00:16', '0', '0', '17686', '16', '0', NULL, '0', '0'),
('1071', '14', 'P', '0', '2022-09-22', '08:10:49', '18:34:24', '0', '0', '18708', '2064', '0', NULL, '0', '0'),
('1072', '88', 'P', '0', '2022-09-22', '08:10:58', '18:02:08', '0', '0', '17735', '128', '0', NULL, '0', '0'),
('1073', '13', 'P', '0', '2022-09-22', '08:12:33', '18:32:43', '0', '0', '18605', '1963', '0', NULL, '0', '0'),
('1074', '22', 'P', '0', '2022-09-22', '08:13:16', '18:02:17', '0', '0', '17671', '137', '0', NULL, '0', '0'),
('1075', '143', 'P', '0', '2022-09-22', '08:15:13', '18:10:15', '0', '0', '17851', '615', '0', NULL, '0', '0'),
('1076', '147', 'P', '0', '2022-09-22', '08:15:29', '18:03:59', '0', '0', '17655', '239', '0', NULL, '0', '0'),
('1077', '7', 'P', '0', '2022-09-22', '08:23:47', '18:09:44', '0', '0', '17579', '584', '0', NULL, '0', '0'),
('1078', '12', 'P', '0', '2022-09-22', '08:24:05', '18:33:03', '0', '0', '18269', '1983', '0', NULL, '0', '0'),
('1079', '17', 'P', '0', '2022-09-22', '08:32:33', '18:05:13', '0', '0', '17180', '313', '0', NULL, '0', '0'),
('1080', '2', 'P', '0', '2022-09-22', '09:15:28', '18:16:29', '0', '0', '16231', '989', '0', NULL, '0', '0'),
('1081', '103', 'P', '0', '2022-09-22', '09:12:41', '18:38:08', '0', '0', '16964', '2288', '0', NULL, '0', '0'),
('1082', '1', 'P', '0', '2022-09-22', '09:12:26', '18:37:36', '0', '0', '16955', '2256', '0', NULL, '0', '0'),
('1083', '5', 'P', '0', '2022-09-22', '10:18:53', '18:08:33', '0', '0', '14090', '513', '0', NULL, '0', '0'),
('1084', '16', 'P', '0', '2022-09-22', '10:34:18', '10:34:18', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1085', '3', 'P', '0', '2022-09-22', '11:02:04', '11:02:04', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1086', '193', 'P', '0', '2022-09-22', '13:21:30', '18:01:55', '0', '0', '8413', '115', '0', NULL, '0', '0'),
('1087', '20', 'P', '0', '2022-09-23', '06:49:49', '18:57:54', '0', '0', '21843', '3474', '0', NULL, '0', '0'),
('1088', '18', 'P', '0', '2022-09-23', '06:53:30', '21:59:04', '0', '0', '27167', '14344', '0', NULL, '0', '0'),
('1089', '192', 'P', '0', '2022-09-23', '06:58:41', '06:58:41', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1090', '87', 'P', '0', '2022-09-23', '06:59:13', '22:02:44', '0', '0', '27106', '14564', '0', NULL, '0', '0'),
('1091', '191', 'P', '0', '2022-09-23', '07:10:35', '19:06:08', '0', '0', '21467', '3968', '0', NULL, '0', '0'),
('1092', '69', 'P', '0', '2022-09-23', '07:46:12', '18:28:09', '0', '0', '19259', '1689', '0', NULL, '0', '0'),
('1093', '75', 'P', '0', '2022-09-23', '07:46:23', '07:46:23', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1094', '46', 'P', '0', '2022-09-23', '07:47:06', '18:33:36', '0', '0', '19395', '2016', '0', NULL, '0', '0'),
('1095', '161', 'P', '0', '2022-09-23', '07:48:13', '18:31:11', '0', '0', '19289', '1871', '0', NULL, '0', '0'),
('1096', '152', 'P', '0', '2022-09-23', '07:48:53', '18:33:29', '0', '0', '19338', '2009', '0', NULL, '0', '0'),
('1097', '17', 'P', '0', '2022-09-23', '07:49:05', '17:46:05', '0', '0', '17910', '0', '0', NULL, '0', '0'),
('1098', '57', 'P', '0', '2022-09-23', '07:49:24', '18:39:08', '0', '0', '19492', '2348', '0', NULL, '0', '0'),
('1099', '8', 'P', '0', '2022-09-23', '07:49:00', '17:45:00', '0', '0', '35100', '0', '0', NULL, '0', '0'),
('1100', '193', 'P', '0', '2022-09-23', '07:50:51', '18:32:06', '0', '0', '19238', '1926', '0', NULL, '0', '0'),
('1101', '60', 'P', '0', '2022-09-23', '07:51:46', '18:48:41', '0', '0', '19708', '2921', '0', NULL, '0', '0'),
('1102', '6', 'P', '0', '2022-09-23', '07:51:59', '21:54:05', '0', '0', '25263', '14045', '0', NULL, '0', '0'),
('1103', '21', 'P', '0', '2022-09-23', '07:52:00', '19:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1104', '51', 'P', '0', '2022-09-23', '07:53:11', '19:04:29', '0', '0', '20139', '3869', '0', NULL, '0', '0'),
('1105', '121', 'P', '0', '2022-09-23', '07:55:39', '21:58:27', '0', '0', '25284', '14307', '0', NULL, '0', '0'),
('1106', '189', 'P', '0', '2022-09-23', '07:56:09', '07:56:09', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1107', '130', 'P', '0', '2022-09-23', '07:56:18', '07:56:18', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1108', '47', 'P', '0', '2022-09-23', '07:56:28', '18:40:58', '0', '0', '19335', '2458', '0', NULL, '0', '0'),
('1109', '181', 'P', '0', '2022-09-23', '07:56:51', '18:27:55', '0', '0', '18932', '1675', '0', NULL, '0', '0'),
('1110', '171', 'P', '0', '2022-09-23', '07:56:59', '18:28:04', '0', '0', '18933', '1684', '0', NULL, '0', '0'),
('1111', '43', 'P', '0', '2022-09-23', '07:57:10', '07:57:10', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1112', '61', 'P', '0', '2022-09-23', '07:57:49', '18:33:20', '0', '0', '19066', '2000', '0', NULL, '0', '0'),
('1113', '25', 'P', '0', '2022-09-23', '07:59:07', '21:58:31', '0', '0', '25182', '14311', '0', NULL, '0', '0'),
('1114', '190', 'P', '0', '2022-09-23', '07:59:11', '21:59:21', '0', '0', '25205', '14361', '0', NULL, '0', '0'),
('1115', '70', 'P', '0', '2022-09-23', '07:59:16', '18:31:59', '0', '0', '18982', '1919', '0', NULL, '0', '0'),
('1116', '173', 'P', '0', '2022-09-23', '07:59:21', '18:32:19', '0', '0', '18989', '1939', '0', NULL, '0', '0'),
('1117', '32', 'P', '0', '2022-09-23', '07:59:34', '19:35:14', '0', '0', '20870', '5714', '0', NULL, '0', '0'),
('1118', '30', 'P', '0', '2022-09-23', '07:59:50', '21:59:14', '0', '0', '25182', '14354', '0', NULL, '0', '0'),
('1119', '35', 'P', '0', '2022-09-23', '07:59:53', '07:59:53', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1120', '67', 'P', '0', '2022-09-23', '08:00:00', '18:33:08', '0', '0', '18994', '1988', '0', NULL, '0', '0'),
('1121', '139', 'P', '0', '2022-09-23', '08:00:06', '08:00:06', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1122', '28', 'P', '0', '2022-09-23', '08:00:47', '21:58:59', '0', '0', '25146', '14339', '0', NULL, '0', '0'),
('1123', '31', 'P', '0', '2022-09-23', '08:00:50', '21:58:38', '0', '0', '25134', '14318', '0', NULL, '0', '0'),
('1124', '170', 'P', '0', '2022-09-23', '08:00:55', '18:30:54', '0', '0', '18900', '1854', '0', NULL, '0', '0'),
('1125', '148', 'P', '0', '2022-09-23', '08:01:25', '18:31:03', '0', '0', '18889', '1863', '0', NULL, '0', '0'),
('1126', '109', 'P', '0', '2022-09-23', '08:02:18', '18:21:12', '0', '0', '18567', '1272', '0', NULL, '0', '0'),
('1127', '147', 'P', '0', '2022-09-23', '08:02:24', '18:31:00', '0', '0', '18858', '1860', '0', NULL, '0', '0'),
('1128', '15', 'P', '0', '2022-09-23', '08:02:28', '21:58:17', '0', '0', '25075', '14297', '0', NULL, '0', '0'),
('1129', '143', 'P', '0', '2022-09-23', '08:02:38', '21:58:54', '0', '0', '25088', '14334', '0', NULL, '0', '0'),
('1130', '65', 'P', '0', '2022-09-23', '08:02:51', '18:11:36', '0', '0', '18263', '696', '0', NULL, '0', '0'),
('1131', '23', 'P', '0', '2022-09-23', '08:04:16', '21:58:08', '0', '0', '25016', '14288', '0', NULL, '0', '0'),
('1132', '22', 'P', '0', '2022-09-23', '08:04:22', '21:58:34', '0', '0', '25026', '14314', '0', NULL, '0', '0'),
('1133', '64', 'P', '0', '2022-09-23', '08:05:10', '08:05:10', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1134', '112', 'P', '0', '2022-09-23', '08:05:19', '08:05:19', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1135', '53', 'P', '0', '2022-09-23', '08:06:17', '18:13:19', '0', '0', '18211', '799', '0', NULL, '0', '0'),
('1136', '162', 'P', '0', '2022-09-23', '08:06:35', '18:00:08', '0', '0', '17807', '8', '0', NULL, '0', '0'),
('1137', '160', 'P', '0', '2022-09-23', '08:07:32', '19:20:31', '0', '0', '20190', '4831', '0', NULL, '0', '0'),
('1138', '118', 'P', '0', '2022-09-23', '08:08:21', '18:20:29', '0', '0', '18364', '1229', '0', NULL, '0', '0'),
('1139', '88', 'P', '0', '2022-09-23', '08:12:05', '21:58:51', '0', '0', '24803', '14331', '0', NULL, '0', '0'),
('1140', '186', 'P', '0', '2022-09-23', '08:12:16', '18:34:11', '0', '0', '18658', '2051', '0', NULL, '0', '0'),
('1141', '14', 'P', '0', '2022-09-23', '08:12:19', '20:13:15', '0', '0', '21628', '7995', '0', NULL, '0', '0'),
('1142', '13', 'P', '0', '2022-09-23', '08:12:56', '21:58:23', '0', '0', '24764', '14303', '0', NULL, '0', '0'),
('1143', '128', 'P', '0', '2022-09-23', '08:13:08', '18:34:31', '0', '0', '18642', '2071', '0', NULL, '0', '0'),
('1144', '183', 'P', '0', '2022-09-23', '08:17:57', '08:17:57', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1145', '182', 'P', '0', '2022-09-23', '08:18:34', '08:18:34', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1146', '111', 'P', '0', '2022-09-23', '08:21:53', '08:21:53', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1147', '7', 'P', '0', '2022-09-23', '08:26:30', '19:21:55', '0', '0', '19663', '4915', '0', NULL, '0', '0'),
('1148', '12', 'P', '0', '2022-09-23', '08:26:57', '20:12:59', '0', '0', '21181', '7979', '0', NULL, '0', '0'),
('1149', '2', 'P', '0', '2022-09-23', '09:00:59', '18:24:17', '0', '0', '16899', '1457', '0', NULL, '0', '0'),
('1150', '5', 'P', '0', '2022-09-23', '09:06:52', '19:20:32', '0', '0', '18410', '4832', '0', NULL, '0', '0'),
('1151', '103', 'P', '0', '2022-09-23', '09:19:22', '18:57:16', '0', '0', '17337', '3436', '0', NULL, '0', '0'),
('1152', '1', 'P', '0', '2022-09-23', '09:19:47', '18:57:38', '0', '0', '17336', '3458', '0', NULL, '0', '0'),
('1153', '4', 'P', '0', '2022-09-23', '09:41:37', '18:54:41', '0', '0', '16592', '3281', '0', NULL, '0', '0'),
('1154', '16', 'P', '0', '2022-09-23', '10:12:40', '10:12:40', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1155', '3', 'P', '0', '2022-09-23', '10:26:32', '10:26:32', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1156', '177', 'P', '0', '2022-09-23', '21:59:39', '21:59:39', '0', '0', '0', '14379', '0', NULL, '0', '0'),
('1157', '75', 'P', '0', '2022-09-24', '07:45:38', '07:45:38', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1158', '139', 'P', '0', '2022-09-24', '07:45:56', '11:50:02', '0', '0', '7323', '0', '0', NULL, '0', '0'),
('1159', '189', 'P', '0', '2022-09-24', '07:52:57', '07:52:57', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1160', '130', 'P', '0', '2022-09-24', '07:53:06', '07:53:06', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1161', '47', 'P', '0', '2022-09-24', '07:53:10', '07:53:10', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1162', '35', 'P', '0', '2022-09-24', '07:58:41', '11:49:39', '0', '0', '6929', '0', '0', NULL, '0', '0'),
('1163', '64', 'P', '0', '2022-09-24', '08:01:59', '08:01:59', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1164', '112', 'P', '0', '2022-09-24', '08:08:13', '12:03:01', '0', '0', '7044', '0', '0', NULL, '0', '0'),
('1165', '192', 'P', '0', '2022-09-24', '08:23:23', '13:19:51', '0', '0', '8894', '0', '0', NULL, '0', '0'),
('1166', '183', 'P', '0', '2022-09-24', '08:24:12', '08:24:12', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1167', '162', 'P', '0', '2022-09-24', '08:37:42', '16:08:09', '0', '0', '13514', '0', '0', NULL, '0', '0'),
('1168', '8', 'P', '0', '2022-09-24', '08:40:00', '11:41:00', '0', '0', '10860', '0', '0', NULL, '0', '0'),
('1169', '18', 'P', '0', '2022-09-24', '08:58:12', '13:09:50', '0', '0', '7549', '0', '0', NULL, '0', '0'),
('1170', '191', 'P', '0', '2022-09-24', '10:04:26', '13:19:56', '0', '0', '5865', '0', '0', NULL, '0', '0'),
('1171', '4', 'P', '0', '2022-09-24', '11:25:42', '16:47:19', '0', '0', '9649', '0', '0', NULL, '0', '0'),
('1172', '103', 'P', '0', '2022-09-24', '11:40:38', '16:47:29', '0', '0', '9206', '0', '0', NULL, '0', '0'),
('1173', '162', 'P', '0', '2022-09-25', '08:39:22', '11:05:12', '0', '0', '4375', '0', '0', NULL, '0', '0'),
('1174', '18', 'P', '0', '2022-09-25', '09:05:37', '11:05:07', '0', '0', '3585', '0', '0', NULL, '0', '0'),
('1175', '20', 'P', '0', '2022-09-26', '06:56:42', '18:09:37', '0', '0', '20188', '577', '0', NULL, '0', '0'),
('1176', '87', 'P', '0', '2022-09-26', '07:14:30', '18:27:06', '0', '0', '20178', '1626', '0', NULL, '0', '0'),
('1177', '18', 'P', '0', '2022-09-26', '07:18:50', '19:11:53', '0', '0', '21392', '4313', '0', NULL, '0', '0'),
('1178', '191', 'P', '0', '2022-09-26', '07:39:35', '18:23:43', '0', '0', '19324', '1423', '0', NULL, '0', '0'),
('1179', '139', 'P', '0', '2022-09-26', '07:39:48', '18:01:06', '0', '0', '18639', '66', '0', NULL, '0', '0'),
('1180', '46', 'P', '0', '2022-09-26', '07:44:57', '17:59:42', '0', '0', '18443', '0', '0', NULL, '0', '0'),
('1181', '183', 'P', '0', '2022-09-26', '07:45:47', '18:01:29', '0', '0', '18471', '89', '0', NULL, '0', '0'),
('1182', '14', 'P', '0', '2022-09-26', '07:45:51', '18:01:31', '0', '0', '18470', '91', '0', NULL, '0', '0'),
('1183', '182', 'P', '0', '2022-09-26', '07:46:03', '07:46:03', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1184', '161', 'P', '0', '2022-09-26', '07:48:00', '18:01:16', '0', '0', '18398', '76', '0', NULL, '0', '0'),
('1185', '51', 'P', '0', '2022-09-26', '07:51:05', '18:02:52', '0', '0', '18354', '172', '0', NULL, '0', '0'),
('1186', '21', 'P', '0', '2022-09-26', '07:51:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1187', '193', 'P', '0', '2022-09-26', '07:52:13', '18:00:19', '0', '0', '18243', '19', '0', NULL, '0', '0'),
('1188', '75', 'P', '0', '2022-09-26', '07:52:35', '17:59:17', '0', '0', '18201', '0', '0', NULL, '0', '0'),
('1189', '171', 'P', '0', '2022-09-26', '07:52:40', '17:59:30', '0', '0', '18205', '0', '0', NULL, '0', '0'),
('1190', '23', 'P', '0', '2022-09-26', '07:53:39', '18:03:54', '0', '0', '18308', '234', '0', NULL, '0', '0'),
('1191', '181', 'P', '0', '2022-09-26', '07:54:09', '17:59:03', '0', '0', '18147', '0', '0', NULL, '0', '0'),
('1192', '130', 'P', '0', '2022-09-26', '07:54:25', '17:59:37', '0', '0', '18156', '0', '0', NULL, '0', '0'),
('1193', '189', 'P', '0', '2022-09-26', '07:54:33', '17:59:10', '0', '0', '18139', '0', '0', NULL, '0', '0'),
('1194', '25', 'P', '0', '2022-09-26', '07:54:50', '17:58:28', '0', '0', '18109', '0', '0', NULL, '0', '0'),
('1195', '121', 'P', '0', '2022-09-26', '07:55:32', '17:58:10', '0', '0', '18079', '0', '0', NULL, '0', '0'),
('1196', '47', 'P', '0', '2022-09-26', '07:55:38', '17:59:51', '0', '0', '18127', '0', '0', NULL, '0', '0'),
('1197', '70', 'P', '0', '2022-09-26', '07:56:03', '17:59:56', '0', '0', '18117', '0', '0', NULL, '0', '0'),
('1198', '173', 'P', '0', '2022-09-26', '07:56:09', '17:59:28', '0', '0', '18100', '0', '0', NULL, '0', '0'),
('1199', '43', 'P', '0', '2022-09-26', '07:56:15', '07:56:15', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1200', '31', 'P', '0', '2022-09-26', '07:56:29', '18:01:18', '0', '0', '18145', '78', '0', NULL, '0', '0'),
('1201', '170', 'P', '0', '2022-09-26', '07:56:33', '17:58:54', '0', '0', '18071', '0', '0', NULL, '0', '0'),
('1202', '35', 'P', '0', '2022-09-26', '07:56:40', '18:00:13', '0', '0', '18107', '13', '0', NULL, '0', '0'),
('1203', '28', 'P', '0', '2022-09-26', '07:56:45', '18:00:30', '0', '0', '18113', '30', '0', NULL, '0', '0'),
('1204', '61', 'P', '0', '2022-09-26', '07:56:56', '18:00:09', '0', '0', '18097', '9', '0', NULL, '0', '0'),
('1205', '111', 'P', '0', '2022-09-26', '07:57:02', '07:57:02', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1206', '65', 'P', '0', '2022-09-26', '07:58:24', '18:00:01', '0', '0', '18049', '1', '0', NULL, '0', '0'),
('1207', '6', 'P', '0', '2022-09-26', '07:59:17', '16:42:43', '0', '0', '15703', '0', '0', NULL, '0', '0'),
('1208', '69', 'P', '0', '2022-09-26', '07:59:54', '13:59:42', '0', '0', '10794', '0', '0', NULL, '0', '0'),
('1209', '57', 'P', '0', '2022-09-26', '08:00:49', '18:00:38', '0', '0', '17995', '38', '0', NULL, '0', '0'),
('1210', '60', 'P', '0', '2022-09-26', '08:01:00', '18:00:04', '0', '0', '17972', '4', '0', NULL, '0', '0'),
('1211', '32', 'P', '0', '2022-09-26', '08:01:05', '18:04:28', '0', '0', '18102', '268', '0', NULL, '0', '0'),
('1212', '30', 'P', '0', '2022-09-26', '08:01:21', '18:00:46', '0', '0', '17983', '46', '0', NULL, '0', '0'),
('1213', '162', 'P', '0', '2022-09-26', '08:01:27', '17:59:12', '0', '0', '17933', '0', '0', NULL, '0', '0'),
('1214', '67', 'P', '0', '2022-09-26', '08:01:45', '18:01:03', '0', '0', '17979', '63', '0', NULL, '0', '0'),
('1215', '109', 'P', '0', '2022-09-26', '08:02:13', '18:02:28', '0', '0', '18008', '148', '0', NULL, '0', '0'),
('1216', '82', 'P', '0', '2022-09-26', '08:02:32', '17:58:47', '0', '0', '17888', '0', '0', NULL, '0', '0'),
('1217', '147', 'P', '0', '2022-09-26', '08:03:15', '17:59:22', '0', '0', '17884', '0', '0', NULL, '0', '0'),
('1218', '143', 'P', '0', '2022-09-26', '08:03:48', '17:58:42', '0', '0', '17847', '0', '0', NULL, '0', '0'),
('1219', '112', 'P', '0', '2022-09-26', '08:05:48', '18:04:42', '0', '0', '17967', '282', '0', NULL, '0', '0'),
('1220', '190', 'P', '0', '2022-09-26', '08:06:30', '18:00:59', '0', '0', '17835', '59', '0', NULL, '0', '0'),
('1221', '152', 'P', '0', '2022-09-26', '08:09:32', '18:01:12', '0', '0', '17750', '72', '0', NULL, '0', '0'),
('1222', '8', 'P', '0', '2022-09-26', '08:10:00', '23:30:00', '0', '0', '35400', '0', '0', NULL, '0', '0'),
('1223', '128', 'P', '0', '2022-09-26', '08:10:09', '18:01:21', '0', '0', '17736', '81', '0', NULL, '0', '0'),
('1224', '17', 'P', '0', '2022-09-26', '08:10:17', '18:01:57', '0', '0', '17750', '117', '0', NULL, '0', '0'),
('1225', '22', 'P', '0', '2022-09-26', '08:10:28', '18:01:43', '0', '0', '17738', '103', '0', NULL, '0', '0'),
('1226', '160', 'P', '0', '2022-09-26', '08:10:45', '18:07:51', '0', '0', '17913', '471', '0', NULL, '0', '0'),
('1227', '118', 'P', '0', '2022-09-26', '08:12:27', '18:00:49', '0', '0', '17651', '49', '0', NULL, '0', '0'),
('1228', '13', 'P', '0', '2022-09-26', '08:15:18', '17:53:40', '0', '0', '17351', '0', '0', NULL, '0', '0'),
('1229', '15', 'P', '0', '2022-09-26', '08:25:52', '18:02:06', '0', '0', '17287', '126', '0', NULL, '0', '0'),
('1230', '12', 'P', '0', '2022-09-26', '08:38:54', '17:53:33', '0', '0', '16640', '0', '0', NULL, '0', '0'),
('1231', '177', 'P', '0', '2022-09-26', '08:41:09', '18:27:52', '0', '0', '17602', '1672', '0', NULL, '0', '0'),
('1232', '2', 'P', '0', '2022-09-26', '09:11:04', '18:24:33', '0', '0', '16605', '1473', '0', NULL, '0', '0'),
('1233', '88', 'P', '0', '2022-09-26', '09:12:30', '18:02:39', '0', '0', '15905', '159', '0', NULL, '0', '0'),
('1234', '1', 'P', '0', '2022-09-26', '09:11:02', '18:24:28', '0', '0', '16603', '1468', '0', NULL, '0', '0'),
('1235', '4', 'P', '0', '2022-09-26', '09:40:52', '18:21:56', '0', '0', '15632', '1316', '0', NULL, '0', '0'),
('1236', '5', 'P', '0', '2022-09-26', '09:46:35', '18:22:32', '0', '0', '15479', '1352', '0', NULL, '0', '0'),
('1237', '16', 'P', '0', '2022-09-26', '10:14:39', '10:14:39', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1238', '3', 'P', '0', '2022-09-26', '10:28:57', '10:28:57', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1239', '7', 'P', '0', '2022-09-26', '18:00:43', '18:00:43', '0', '0', '0', '43', '0', NULL, '0', '0'),
('1240', '192', 'P', '0', '2022-09-27', '06:49:08', '18:04:04', '0', '0', '20248', '244', '0', NULL, '0', '0'),
('1241', '20', 'P', '0', '2022-09-27', '07:10:23', '18:56:39', '0', '0', '21188', '3399', '0', NULL, '0', '0'),
('1242', '18', 'P', '0', '2022-09-27', '07:34:50', '17:35:11', '0', '0', '18011', '0', '0', NULL, '0', '0'),
('1243', '191', 'P', '0', '2022-09-27', '07:35:03', '18:06:39', '0', '0', '18948', '399', '0', NULL, '0', '0'),
('1244', '87', 'P', '0', '2022-09-27', '07:35:13', '19:32:31', '0', '0', '21519', '5551', '0', NULL, '0', '0'),
('1245', '183', 'P', '0', '2022-09-27', '07:39:26', '07:39:26', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1246', '14', 'P', '0', '2022-09-27', '07:39:41', '18:21:53', '0', '0', '19266', '1313', '0', NULL, '0', '0'),
('1247', '182', 'P', '0', '2022-09-27', '07:40:03', '18:02:39', '0', '0', '18678', '159', '0', NULL, '0', '0'),
('1248', '193', 'P', '0', '2022-09-27', '07:42:04', '17:58:09', '0', '0', '18483', '0', '0', NULL, '0', '0'),
('1249', '75', 'P', '0', '2022-09-27', '07:42:31', '07:42:31', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1250', '161', 'P', '0', '2022-09-27', '07:50:10', '18:00:45', '0', '0', '18318', '45', '0', NULL, '0', '0'),
('1251', '51', 'P', '0', '2022-09-27', '07:50:20', '18:01:03', '0', '0', '18322', '63', '0', NULL, '0', '0'),
('1252', '21', 'P', '0', '2022-09-27', '07:51:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1253', '181', 'P', '0', '2022-09-27', '07:51:42', '17:59:06', '0', '0', '18222', '0', '0', NULL, '0', '0'),
('1254', '171', 'P', '0', '2022-09-27', '07:51:48', '17:59:11', '0', '0', '18222', '0', '0', NULL, '0', '0'),
('1255', '70', 'P', '0', '2022-09-27', '07:52:45', '17:57:57', '0', '0', '18156', '0', '0', NULL, '0', '0'),
('1256', '173', 'P', '0', '2022-09-27', '07:52:57', '17:58:02', '0', '0', '18153', '0', '0', NULL, '0', '0'),
('1257', '23', 'P', '0', '2022-09-27', '07:53:10', '17:57:29', '0', '0', '18130', '0', '0', NULL, '0', '0'),
('1258', '130', 'P', '0', '2022-09-27', '07:53:21', '18:00:13', '0', '0', '18206', '13', '0', NULL, '0', '0'),
('1259', '189', 'P', '0', '2022-09-27', '07:53:25', '07:53:25', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1260', '17', 'P', '0', '2022-09-27', '07:53:40', '18:07:59', '0', '0', '18430', '479', '0', NULL, '0', '0'),
('1261', '35', 'P', '0', '2022-09-27', '07:53:44', '07:53:44', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1262', '6', 'P', '0', '2022-09-27', '07:53:52', '18:05:18', '0', '0', '18343', '318', '0', NULL, '0', '0'),
('1263', '47', 'P', '0', '2022-09-27', '07:54:20', '07:54:20', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1264', '46', 'P', '0', '2022-09-27', '07:54:35', '18:00:18', '0', '0', '18172', '18', '0', NULL, '0', '0'),
('1265', '53', 'P', '0', '2022-09-27', '07:56:58', '17:58:47', '0', '0', '18055', '0', '0', NULL, '0', '0'),
('1266', '25', 'P', '0', '2022-09-27', '07:57:06', '17:59:20', '0', '0', '18067', '0', '0', NULL, '0', '0'),
('1267', '8', 'P', '0', '2022-09-27', '07:57:00', '18:03:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1268', '121', 'P', '0', '2022-09-27', '07:57:29', '17:04:51', '0', '0', '16421', '0', '0', NULL, '0', '0'),
('1269', '43', 'P', '0', '2022-09-27', '07:58:17', '17:58:19', '0', '0', '18001', '0', '0', NULL, '0', '0'),
('1270', '64', 'P', '0', '2022-09-27', '07:58:32', '18:00:08', '0', '0', '18048', '8', '0', NULL, '0', '0'),
('1271', '61', 'P', '0', '2022-09-27', '07:58:50', '18:00:49', '0', '0', '18060', '49', '0', NULL, '0', '0'),
('1272', '139', 'P', '0', '2022-09-27', '07:59:23', '18:00:23', '0', '0', '18030', '23', '0', NULL, '0', '0'),
('1273', '65', 'P', '0', '2022-09-27', '07:59:28', '18:00:04', '0', '0', '18018', '4', '0', NULL, '0', '0'),
('1274', '67', 'P', '0', '2022-09-27', '07:59:51', '18:00:55', '0', '0', '18032', '55', '0', NULL, '0', '0'),
('1275', '57', 'P', '0', '2022-09-27', '08:00:12', '18:00:30', '0', '0', '18009', '30', '0', NULL, '0', '0'),
('1276', '170', 'P', '0', '2022-09-27', '08:00:23', '17:58:56', '0', '0', '17957', '0', '0', NULL, '0', '0'),
('1277', '31', 'P', '0', '2022-09-27', '08:00:27', '18:05:05', '0', '0', '18139', '305', '0', NULL, '0', '0'),
('1278', '60', 'P', '0', '2022-09-27', '08:00:39', '18:00:37', '0', '0', '17999', '37', '0', NULL, '0', '0'),
('1279', '28', 'P', '0', '2022-09-27', '08:00:54', '18:00:58', '0', '0', '18002', '58', '0', NULL, '0', '0'),
('1280', '148', 'P', '0', '2022-09-27', '08:02:04', '18:00:33', '0', '0', '17955', '33', '0', NULL, '0', '0'),
('1281', '15', 'P', '0', '2022-09-27', '08:02:11', '18:07:36', '0', '0', '18163', '456', '0', NULL, '0', '0'),
('1282', '152', 'P', '0', '2022-09-27', '08:02:19', '17:58:37', '0', '0', '17889', '0', '0', NULL, '0', '0'),
('1283', '147', 'P', '0', '2022-09-27', '08:04:28', '17:59:31', '0', '0', '17852', '0', '0', NULL, '0', '0'),
('1284', '143', 'P', '0', '2022-09-27', '08:04:43', '17:59:50', '0', '0', '17854', '0', '0', NULL, '0', '0'),
('1285', '82', 'P', '0', '2022-09-27', '08:05:49', '17:58:27', '0', '0', '17779', '0', '0', NULL, '0', '0'),
('1286', '112', 'P', '0', '2022-09-27', '08:05:52', '18:06:48', '0', '0', '18028', '408', '0', NULL, '0', '0'),
('1287', '7', 'P', '0', '2022-09-27', '08:05:57', '18:02:28', '0', '0', '17896', '148', '0', NULL, '0', '0'),
('1288', '109', 'P', '0', '2022-09-27', '08:06:03', '18:03:52', '0', '0', '17935', '232', '0', NULL, '0', '0'),
('1289', '177', 'P', '0', '2022-09-27', '08:06:14', '08:06:14', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1290', '22', 'P', '0', '2022-09-27', '08:07:43', '17:58:41', '0', '0', '17729', '0', '0', NULL, '0', '0'),
('1291', '128', 'P', '0', '2022-09-27', '08:11:24', '18:06:29', '0', '0', '17853', '389', '0', NULL, '0', '0'),
('1292', '118', 'P', '0', '2022-09-27', '08:13:08', '18:02:42', '0', '0', '17687', '162', '0', NULL, '0', '0'),
('1293', '162', 'P', '0', '2022-09-27', '08:14:32', '17:58:23', '0', '0', '17516', '0', '0', NULL, '0', '0'),
('1294', '111', 'P', '0', '2022-09-27', '08:14:41', '08:14:41', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1295', '160', 'P', '0', '2022-09-27', '08:14:46', '18:04:17', '0', '0', '17686', '257', '0', NULL, '0', '0'),
('1296', '13', 'P', '0', '2022-09-27', '08:18:27', '18:17:05', '0', '0', '17959', '1025', '0', NULL, '0', '0'),
('1297', '5', 'P', '0', '2022-09-27', '08:18:31', '18:13:10', '0', '0', '17840', '790', '0', NULL, '0', '0'),
('1298', '190', 'P', '0', '2022-09-27', '08:21:07', '18:01:07', '0', '0', '17400', '67', '0', NULL, '0', '0'),
('1299', '186', 'P', '0', '2022-09-27', '08:28:22', '17:59:58', '0', '0', '17148', '0', '0', NULL, '0', '0'),
('1300', '32', 'P', '0', '2022-09-27', '08:29:55', '18:00:41', '0', '0', '17123', '41', '0', NULL, '0', '0'),
('1301', '30', 'P', '0', '2022-09-27', '08:30:19', '17:59:17', '0', '0', '17069', '0', '0', NULL, '0', '0'),
('1302', '2', 'P', '0', '2022-09-27', '09:04:41', '18:24:48', '0', '0', '16804', '1488', '0', NULL, '0', '0'),
('1303', '103', 'P', '0', '2022-09-27', '09:08:23', '18:52:17', '0', '0', '17517', '3137', '0', NULL, '0', '0'),
('1304', '1', 'P', '0', '2022-09-27', '09:08:48', '18:51:02', '0', '0', '17467', '3062', '0', NULL, '0', '0'),
('1305', '88', 'P', '0', '2022-09-27', '09:22:48', '17:58:51', '0', '0', '15482', '0', '0', NULL, '0', '0'),
('1306', '4', 'P', '0', '2022-09-27', '09:38:23', '18:54:32', '0', '0', '16685', '3272', '0', NULL, '0', '0'),
('1307', '16', 'P', '0', '2022-09-27', '09:43:33', '09:43:33', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1308', '3', 'P', '0', '2022-09-27', '10:01:18', '10:01:18', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1309', '12', 'P', '0', '2022-09-27', '12:23:25', '18:17:43', '0', '0', '10629', '1063', '0', NULL, '0', '0'),
('1310', '20', 'P', '0', '2022-09-28', '06:30:14', '19:04:56', '0', '0', '22641', '3896', '0', NULL, '0', '0'),
('1311', '192', 'P', '0', '2022-09-28', '06:43:10', '18:04:03', '0', '0', '20427', '243', '0', NULL, '0', '0'),
('1312', '87', 'P', '0', '2022-09-28', '07:12:44', '19:03:03', '0', '0', '21310', '3783', '0', NULL, '0', '0'),
('1313', '191', 'P', '0', '2022-09-28', '07:20:40', '17:52:05', '0', '0', '18943', '0', '0', NULL, '0', '0'),
('1314', '18', 'P', '0', '2022-09-28', '07:33:25', '17:34:04', '0', '0', '18020', '0', '0', NULL, '0', '0'),
('1315', '161', 'P', '0', '2022-09-28', '07:48:32', '18:01:17', '0', '0', '18383', '77', '0', NULL, '0', '0'),
('1316', '75', 'P', '0', '2022-09-28', '07:51:37', '17:59:04', '0', '0', '18224', '0', '0', NULL, '0', '0'),
('1317', '171', 'P', '0', '2022-09-28', '07:51:50', '18:00:34', '0', '0', '18262', '34', '0', NULL, '0', '0'),
('1318', '181', 'P', '0', '2022-09-28', '07:51:59', '18:01:04', '0', '0', '18273', '64', '0', NULL, '0', '0'),
('1319', '25', 'P', '0', '2022-09-28', '07:52:24', '17:58:14', '0', '0', '18175', '0', '0', NULL, '0', '0'),
('1320', '130', 'P', '0', '2022-09-28', '07:52:33', '18:00:37', '0', '0', '18242', '37', '0', NULL, '0', '0'),
('1321', '189', 'P', '0', '2022-09-28', '07:52:38', '17:58:59', '0', '0', '18191', '0', '0', NULL, '0', '0'),
('1322', '121', 'P', '0', '2022-09-28', '07:52:52', '17:57:57', '0', '0', '18153', '0', '0', NULL, '0', '0'),
('1323', '139', 'P', '0', '2022-09-28', '07:53:21', '18:00:49', '0', '0', '18224', '49', '0', NULL, '0', '0'),
('1324', '47', 'P', '0', '2022-09-28', '07:53:36', '18:00:31', '0', '0', '18208', '31', '0', NULL, '0', '0'),
('1325', '69', 'P', '0', '2022-09-28', '07:53:50', '12:38:40', '0', '0', '8545', '0', '0', NULL, '0', '0'),
('1326', '6', 'P', '0', '2022-09-28', '07:54:37', '18:03:15', '0', '0', '18259', '195', '0', NULL, '0', '0'),
('1327', '183', 'P', '0', '2022-09-28', '07:54:54', '13:28:00', '0', '0', '9993', '0', '0', NULL, '0', '0'),
('1328', '14', 'P', '0', '2022-09-28', '07:55:48', '20:16:55', '0', '0', '22234', '8215', '0', NULL, '0', '0'),
('1329', '70', 'P', '0', '2022-09-28', '07:55:58', '17:59:41', '0', '0', '18112', '0', '0', NULL, '0', '0'),
('1330', '173', 'P', '0', '2022-09-28', '07:56:03', '17:59:35', '0', '0', '18106', '0', '0', NULL, '0', '0'),
('1331', '57', 'P', '0', '2022-09-28', '07:56:23', '18:00:26', '0', '0', '18122', '26', '0', NULL, '0', '0'),
('1332', '35', 'P', '0', '2022-09-28', '07:56:26', '18:00:15', '0', '0', '18115', '15', '0', NULL, '0', '0'),
('1333', '60', 'P', '0', '2022-09-28', '07:56:33', '18:00:07', '0', '0', '18107', '7', '0', NULL, '0', '0'),
('1334', '32', 'P', '0', '2022-09-28', '07:57:58', '17:59:31', '0', '0', '18047', '0', '0', NULL, '0', '0'),
('1335', '30', 'P', '0', '2022-09-28', '07:58:45', '17:59:15', '0', '0', '18015', '0', '0', NULL, '0', '0'),
('1336', '109', 'P', '0', '2022-09-28', '07:58:55', '18:03:47', '0', '0', '18146', '227', '0', NULL, '0', '0'),
('1337', '51', 'P', '0', '2022-09-28', '07:59:01', '17:48:28', '0', '0', '17684', '0', '0', NULL, '0', '0'),
('1338', '23', 'P', '0', '2022-09-28', '07:59:06', '18:02:02', '0', '0', '18088', '122', '0', NULL, '0', '0'),
('1339', '21', 'P', '0', '2022-09-28', '07:59:00', '17:50:00', '0', '0', '35400', '0', '0', NULL, '0', '0'),
('1340', '15', 'P', '0', '2022-09-28', '07:59:43', '07:59:43', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1341', '147', 'P', '0', '2022-09-28', '08:01:20', '17:59:26', '0', '0', '17943', '0', '0', NULL, '0', '0'),
('1342', '143', 'P', '0', '2022-09-28', '08:01:45', '17:58:28', '0', '0', '17902', '0', '0', NULL, '0', '0'),
('1343', '190', 'P', '0', '2022-09-28', '08:01:58', '17:59:20', '0', '0', '17921', '0', '0', NULL, '0', '0'),
('1344', '148', 'P', '0', '2022-09-28', '08:02:07', '18:01:07', '0', '0', '17970', '67', '0', NULL, '0', '0'),
('1345', '64', 'P', '0', '2022-09-28', '08:02:56', '18:00:09', '0', '0', '17917', '9', '0', NULL, '0', '0'),
('1346', '53', 'P', '0', '2022-09-28', '08:03:05', '18:01:32', '0', '0', '17954', '92', '0', NULL, '0', '0'),
('1347', '8', 'P', '0', '2022-09-28', '08:03:00', '18:03:00', '0', '0', '35820', '0', '0', NULL, '0', '0'),
('1348', '17', 'P', '0', '2022-09-28', '08:03:21', '18:05:02', '0', '0', '18051', '302', '0', NULL, '0', '0'),
('1349', '177', 'P', '0', '2022-09-28', '08:03:31', '19:02:46', '0', '0', '19778', '3766', '0', NULL, '0', '0'),
('1350', '162', 'P', '0', '2022-09-28', '08:03:55', '17:58:17', '0', '0', '17831', '0', '0', NULL, '0', '0'),
('1351', '111', 'P', '0', '2022-09-28', '08:06:58', '18:00:29', '0', '0', '17806', '29', '0', NULL, '0', '0'),
('1352', '67', 'P', '0', '2022-09-28', '08:07:36', '17:59:48', '0', '0', '17766', '0', '0', NULL, '0', '0'),
('1353', '22', 'P', '0', '2022-09-28', '08:07:41', '18:01:22', '0', '0', '17811', '82', '0', NULL, '0', '0'),
('1354', '152', 'P', '0', '2022-09-28', '08:07:50', '18:01:41', '0', '0', '17816', '101', '0', NULL, '0', '0'),
('1355', '43', 'P', '0', '2022-09-28', '08:08:19', '18:01:11', '0', '0', '17786', '71', '0', NULL, '0', '0'),
('1356', '193', 'P', '0', '2022-09-28', '08:08:31', '18:00:02', '0', '0', '17746', '2', '0', NULL, '0', '0'),
('1357', '186', 'P', '0', '2022-09-28', '08:11:29', '18:02:59', '0', '0', '17745', '179', '0', NULL, '0', '0'),
('1358', '170', 'P', '0', '2022-09-28', '08:11:34', '17:58:34', '0', '0', '17610', '0', '0', NULL, '0', '0'),
('1359', '28', 'P', '0', '2022-09-28', '08:11:38', '17:59:02', '0', '0', '17622', '0', '0', NULL, '0', '0'),
('1360', '65', 'P', '0', '2022-09-28', '08:12:31', '18:00:22', '0', '0', '17636', '22', '0', NULL, '0', '0'),
('1361', '82', 'P', '0', '2022-09-28', '08:12:51', '18:01:00', '0', '0', '17645', '60', '0', NULL, '0', '0'),
('1362', '112', 'P', '0', '2022-09-28', '08:13:54', '18:01:35', '0', '0', '17631', '95', '0', NULL, '0', '0'),
('1363', '128', 'P', '0', '2022-09-28', '08:14:24', '18:04:11', '0', '0', '17694', '251', '0', NULL, '0', '0'),
('1364', '7', 'P', '0', '2022-09-28', '08:15:13', '18:01:55', '0', '0', '17601', '115', '0', NULL, '0', '0'),
('1365', '12', 'P', '0', '2022-09-28', '08:15:36', '20:05:26', '0', '0', '21295', '7526', '0', NULL, '0', '0'),
('1366', '13', 'P', '0', '2022-09-28', '08:16:54', '20:05:33', '0', '0', '21260', '7533', '0', NULL, '0', '0'),
('1367', '118', 'P', '0', '2022-09-28', '08:18:45', '18:02:38', '0', '0', '17517', '158', '0', NULL, '0', '0'),
('1368', '31', 'P', '0', '2022-09-28', '08:23:32', '17:58:32', '0', '0', '17250', '0', '0', NULL, '0', '0'),
('1369', '88', 'P', '0', '2022-09-28', '08:45:32', '18:01:26', '0', '0', '16677', '86', '0', NULL, '0', '0'),
('1370', '2', 'P', '0', '2022-09-28', '09:16:42', '18:23:19', '0', '0', '16399', '1399', '0', NULL, '0', '0'),
('1371', '4', 'P', '0', '2022-09-28', '09:21:29', '18:28:21', '0', '0', '16406', '1701', '0', NULL, '0', '0'),
('1372', '103', 'P', '0', '2022-09-28', '09:01:29', '18:25:48', '0', '0', '16930', '1548', '0', NULL, '0', '0'),
('1373', '1', 'P', '0', '2022-09-28', '09:01:37', '18:25:13', '0', '0', '16908', '1513', '0', NULL, '0', '0'),
('1374', '5', 'P', '0', '2022-09-28', '09:51:46', '09:51:46', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1375', '160', 'P', '0', '2022-09-28', '09:54:02', '18:02:08', '0', '0', '14643', '128', '0', NULL, '0', '0'),
('1376', '3', 'P', '0', '2022-09-28', '10:18:06', '10:18:06', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1377', '16', 'P', '0', '2022-09-28', '10:39:28', '10:39:28', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1378', '192', 'P', '0', '2022-09-29', '06:54:42', '18:02:27', '0', '0', '20033', '147', '0', NULL, '0', '0'),
('1379', '20', 'P', '0', '2022-09-29', '07:07:43', '18:47:59', '0', '0', '21008', '2879', '0', NULL, '0', '0'),
('1380', '87', 'P', '0', '2022-09-29', '07:15:26', '18:47:26', '0', '0', '20760', '2846', '0', NULL, '0', '0'),
('1381', '191', 'P', '0', '2022-09-29', '07:22:02', '17:54:48', '0', '0', '18983', '0', '0', NULL, '0', '0'),
('1382', '18', 'P', '0', '2022-09-29', '07:26:26', '17:32:08', '0', '0', '18171', '0', '0', NULL, '0', '0'),
('1383', '21', 'P', '0', '2022-09-29', '07:37:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1384', '51', 'P', '0', '2022-09-29', '07:37:36', '18:03:16', '0', '0', '18770', '196', '0', NULL, '0', '0'),
('1385', '23', 'P', '0', '2022-09-29', '07:41:31', '18:03:38', '0', '0', '18664', '218', '0', NULL, '0', '0'),
('1386', '161', 'P', '0', '2022-09-29', '07:49:05', '18:01:23', '0', '0', '18369', '83', '0', NULL, '0', '0'),
('1387', '181', 'P', '0', '2022-09-29', '07:49:31', '18:00:57', '0', '0', '18343', '57', '0', NULL, '0', '0'),
('1388', '171', 'P', '0', '2022-09-29', '07:50:05', '18:01:07', '0', '0', '18331', '67', '0', NULL, '0', '0'),
('1389', '69', 'P', '0', '2022-09-29', '07:50:20', '13:03:18', '0', '0', '9389', '0', '0', NULL, '0', '0'),
('1390', '46', 'P', '0', '2022-09-29', '07:50:54', '18:00:41', '0', '0', '18294', '41', '0', NULL, '0', '0'),
('1391', '32', 'P', '0', '2022-09-29', '07:51:08', '18:01:52', '0', '0', '18322', '112', '0', NULL, '0', '0'),
('1392', '30', 'P', '0', '2022-09-29', '07:51:41', '18:01:48', '0', '0', '18304', '108', '0', NULL, '0', '0'),
('1393', '43', 'P', '0', '2022-09-29', '07:51:56', '18:02:43', '0', '0', '18324', '163', '0', NULL, '0', '0'),
('1394', '193', 'P', '0', '2022-09-29', '07:52:03', '18:00:08', '0', '0', '18243', '8', '0', NULL, '0', '0'),
('1395', '130', 'P', '0', '2022-09-29', '07:52:14', '07:52:14', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1396', '189', 'P', '0', '2022-09-29', '07:52:21', '07:52:21', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1397', '75', 'P', '0', '2022-09-29', '07:52:33', '17:59:05', '0', '0', '18196', '0', '0', NULL, '0', '0'),
('1398', '61', 'P', '0', '2022-09-29', '07:52:42', '18:01:57', '0', '0', '18278', '117', '0', NULL, '0', '0');
INSERT INTO `0_kv_empl_attendance` VALUES
('1399', '47', 'P', '0', '2022-09-29', '07:52:47', '07:52:47', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1400', '14', 'P', '0', '2022-09-29', '07:52:49', '21:11:22', '0', '0', '23957', '11482', '0', NULL, '0', '0'),
('1401', '183', 'P', '0', '2022-09-29', '07:52:56', '17:59:32', '0', '0', '18198', '0', '0', NULL, '0', '0'),
('1402', '182', 'P', '0', '2022-09-29', '07:53:31', '17:59:14', '0', '0', '18172', '0', '0', NULL, '0', '0'),
('1403', '60', 'P', '0', '2022-09-29', '07:53:41', '18:00:15', '0', '0', '18197', '15', '0', NULL, '0', '0'),
('1404', '121', 'P', '0', '2022-09-29', '07:53:46', '17:56:37', '0', '0', '18086', '0', '0', NULL, '0', '0'),
('1405', '57', 'P', '0', '2022-09-29', '07:53:52', '18:00:30', '0', '0', '18199', '30', '0', NULL, '0', '0'),
('1406', '70', 'P', '0', '2022-09-29', '07:53:56', '17:59:45', '0', '0', '18175', '0', '0', NULL, '0', '0'),
('1407', '173', 'P', '0', '2022-09-29', '07:54:03', '17:59:52', '0', '0', '18175', '0', '0', NULL, '0', '0'),
('1408', '109', 'P', '0', '2022-09-29', '07:54:27', '18:04:51', '0', '0', '18312', '291', '0', NULL, '0', '0'),
('1409', '25', 'P', '0', '2022-09-29', '07:54:38', '17:56:34', '0', '0', '18058', '0', '0', NULL, '0', '0'),
('1410', '35', 'P', '0', '2022-09-29', '07:54:41', '18:00:33', '0', '0', '18176', '33', '0', NULL, '0', '0'),
('1411', '6', 'P', '0', '2022-09-29', '07:54:56', '18:03:28', '0', '0', '18256', '208', '0', NULL, '0', '0'),
('1412', '64', 'P', '0', '2022-09-29', '07:57:34', '18:00:11', '0', '0', '18079', '11', '0', NULL, '0', '0'),
('1413', '170', 'P', '0', '2022-09-29', '07:58:09', '17:59:36', '0', '0', '18044', '0', '0', NULL, '0', '0'),
('1414', '31', 'P', '0', '2022-09-29', '07:58:20', '18:00:55', '0', '0', '18078', '55', '0', NULL, '0', '0'),
('1415', '65', 'P', '0', '2022-09-29', '07:58:25', '18:00:05', '0', '0', '18050', '5', '0', NULL, '0', '0'),
('1416', '28', 'P', '0', '2022-09-29', '07:58:28', '18:01:33', '0', '0', '18093', '93', '0', NULL, '0', '0'),
('1417', '15', 'P', '0', '2022-09-29', '07:58:38', '18:18:29', '0', '0', '18596', '1109', '0', NULL, '0', '0'),
('1418', '17', 'P', '0', '2022-09-29', '07:58:50', '07:58:50', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1419', '190', 'P', '0', '2022-09-29', '07:59:47', '18:01:03', '0', '0', '18038', '63', '0', NULL, '0', '0'),
('1420', '147', 'P', '0', '2022-09-29', '08:01:34', '18:00:51', '0', '0', '17979', '51', '0', NULL, '0', '0'),
('1421', '143', 'P', '0', '2022-09-29', '08:01:43', '17:59:23', '0', '0', '17930', '0', '0', NULL, '0', '0'),
('1422', '148', 'P', '0', '2022-09-29', '08:03:07', '18:01:13', '0', '0', '17943', '73', '0', NULL, '0', '0'),
('1423', '67', 'P', '0', '2022-09-29', '08:03:19', '18:00:25', '0', '0', '17913', '25', '0', NULL, '0', '0'),
('1424', '53', 'P', '0', '2022-09-29', '08:03:49', '18:02:01', '0', '0', '17946', '121', '0', NULL, '0', '0'),
('1425', '162', 'P', '0', '2022-09-29', '08:04:59', '17:56:49', '0', '0', '17755', '0', '0', NULL, '0', '0'),
('1426', '112', 'P', '0', '2022-09-29', '08:05:04', '18:00:46', '0', '0', '17871', '46', '0', NULL, '0', '0'),
('1427', '13', 'P', '0', '2022-09-29', '08:06:21', '21:10:28', '0', '0', '23524', '11428', '0', NULL, '0', '0'),
('1428', '160', 'P', '0', '2022-09-29', '08:06:48', '13:53:54', '0', '0', '10413', '0', '0', NULL, '0', '0'),
('1429', '22', 'P', '0', '2022-09-29', '08:08:28', '17:56:52', '0', '0', '17652', '0', '0', NULL, '0', '0'),
('1430', '7', 'P', '0', '2022-09-29', '08:08:36', '18:02:10', '0', '0', '17807', '130', '0', NULL, '0', '0'),
('1431', '152', 'P', '0', '2022-09-29', '08:09:30', '18:01:28', '0', '0', '17759', '88', '0', NULL, '0', '0'),
('1432', '128', 'P', '0', '2022-09-29', '08:12:14', '18:05:24', '0', '0', '17795', '324', '0', NULL, '0', '0'),
('1433', '82', 'P', '0', '2022-09-29', '08:12:52', '17:59:09', '0', '0', '17589', '0', '0', NULL, '0', '0'),
('1434', '118', 'P', '0', '2022-09-29', '08:14:04', '18:01:11', '0', '0', '17614', '71', '0', NULL, '0', '0'),
('1435', '177', 'P', '0', '2022-09-29', '08:22:33', '19:09:36', '0', '0', '19412', '4176', '0', NULL, '0', '0'),
('1436', '186', 'P', '0', '2022-09-29', '08:25:06', '18:00:38', '0', '0', '17266', '38', '0', NULL, '0', '0'),
('1437', '88', 'P', '0', '2022-09-29', '08:25:22', '17:59:28', '0', '0', '17223', '0', '0', NULL, '0', '0'),
('1438', '5', 'P', '0', '2022-09-29', '08:31:07', '18:17:34', '0', '0', '17594', '1054', '0', NULL, '0', '0'),
('1439', '4', 'P', '0', '2022-09-29', '08:54:00', '18:49:00', '0', '0', '32760', '0', '0', NULL, '0', '0'),
('1440', '2', 'P', '0', '2022-09-29', '09:18:46', '18:25:43', '0', '0', '16409', '1543', '0', NULL, '0', '0'),
('1441', '103', 'P', '0', '2022-09-29', '09:11:00', '18:36:00', '0', '0', '31740', '0', '0', NULL, '0', '0'),
('1442', '1', 'P', '0', '2022-09-29', '09:11:00', '18:34:00', '0', '0', '31740', '2040', '0', NULL, '0', '0'),
('1443', '12', 'P', '0', '2022-09-29', '21:10:23', '21:10:23', '0', '0', '0', '11423', '0', NULL, '0', '0'),
('1444', '20', 'P', '0', '2022-09-30', '06:22:06', '18:15:28', '0', '0', '21401', '928', '0', NULL, '0', '0'),
('1445', '192', 'P', '0', '2022-09-30', '07:16:29', '17:47:42', '0', '0', '18937', '0', '0', NULL, '0', '0'),
('1446', '18', 'P', '0', '2022-09-30', '07:23:09', '17:33:30', '0', '0', '18311', '0', '0', NULL, '0', '0'),
('1447', '161', 'P', '0', '2022-09-30', '07:40:34', '18:00:40', '0', '0', '18603', '40', '0', NULL, '0', '0'),
('1448', '46', 'P', '0', '2022-09-30', '07:40:49', '17:59:41', '0', '0', '18566', '0', '0', NULL, '0', '0'),
('1449', '75', 'P', '0', '2022-09-30', '07:42:59', '18:32:34', '0', '0', '19488', '1954', '0', NULL, '0', '0'),
('1450', '17', 'P', '0', '2022-09-30', '07:43:43', '18:05:20', '0', '0', '18649', '320', '0', NULL, '0', '0'),
('1451', '191', 'P', '0', '2022-09-30', '07:43:53', '17:57:29', '0', '0', '18408', '0', '0', NULL, '0', '0'),
('1452', '8', 'P', '0', '2022-09-30', '07:44:01', '18:32:32', '0', '0', '19456', '1952', '0', NULL, '0', '0'),
('1453', '177', 'P', '0', '2022-09-30', '07:44:05', '18:02:21', '0', '0', '18548', '141', '0', NULL, '0', '0'),
('1454', '173', 'P', '0', '2022-09-30', '07:48:57', '17:58:54', '0', '0', '18299', '0', '0', NULL, '0', '0'),
('1455', '70', 'P', '0', '2022-09-30', '07:49:02', '17:59:17', '0', '0', '18308', '0', '0', NULL, '0', '0'),
('1456', '35', 'P', '0', '2022-09-30', '07:49:26', '18:32:52', '0', '0', '19303', '1972', '0', NULL, '0', '0'),
('1457', '23', 'P', '0', '2022-09-30', '07:51:31', '17:47:56', '0', '0', '17893', '0', '0', NULL, '0', '0'),
('1458', '6', 'P', '0', '2022-09-30', '07:53:32', '18:03:30', '0', '0', '18299', '210', '0', NULL, '0', '0'),
('1459', '183', 'P', '0', '2022-09-30', '07:53:36', '07:53:36', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1460', '14', 'P', '0', '2022-09-30', '07:53:41', '07:53:41', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1461', '171', 'P', '0', '2022-09-30', '07:53:50', '17:59:12', '0', '0', '18161', '0', '0', NULL, '0', '0'),
('1462', '182', 'P', '0', '2022-09-30', '07:54:06', '17:59:56', '0', '0', '18175', '0', '0', NULL, '0', '0'),
('1463', '181', 'P', '0', '2022-09-30', '07:54:16', '17:59:20', '0', '0', '18152', '0', '0', NULL, '0', '0'),
('1464', '25', 'P', '0', '2022-09-30', '07:54:20', '17:58:01', '0', '0', '18111', '0', '0', NULL, '0', '0'),
('1465', '43', 'P', '0', '2022-09-30', '07:54:31', '17:59:46', '0', '0', '18158', '0', '0', NULL, '0', '0'),
('1466', '130', 'P', '0', '2022-09-30', '07:54:37', '17:59:31', '0', '0', '18147', '0', '0', NULL, '0', '0'),
('1467', '193', 'P', '0', '2022-09-30', '07:54:43', '17:59:05', '0', '0', '18131', '0', '0', NULL, '0', '0'),
('1468', '189', 'P', '0', '2022-09-30', '07:54:53', '17:59:50', '0', '0', '18149', '0', '0', NULL, '0', '0'),
('1469', '121', 'P', '0', '2022-09-30', '07:54:57', '17:58:07', '0', '0', '18095', '0', '0', NULL, '0', '0'),
('1470', '61', 'P', '0', '2022-09-30', '07:55:06', '17:59:25', '0', '0', '18130', '0', '0', NULL, '0', '0'),
('1471', '47', 'P', '0', '2022-09-30', '07:55:11', '07:55:11', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1472', '30', 'P', '0', '2022-09-30', '07:55:28', '18:00:30', '0', '0', '18151', '30', '0', NULL, '0', '0'),
('1473', '32', 'P', '0', '2022-09-30', '07:55:32', '18:00:37', '0', '0', '18153', '37', '0', NULL, '0', '0'),
('1474', '111', 'P', '0', '2022-09-30', '07:55:37', '18:33:00', '0', '0', '19122', '1980', '0', NULL, '0', '0'),
('1475', '57', 'P', '0', '2022-09-30', '07:55:49', '18:00:10', '0', '0', '18131', '10', '0', NULL, '0', '0'),
('1476', '60', 'P', '0', '2022-09-30', '07:55:53', '18:00:17', '0', '0', '18132', '17', '0', NULL, '0', '0'),
('1477', '51', 'P', '0', '2022-09-30', '07:56:09', '17:42:42', '0', '0', '17597', '0', '0', NULL, '0', '0'),
('1478', '21', 'P', '0', '2022-09-30', '07:56:00', '17:00:00', '0', '0', '32400', '0', '0', NULL, '0', '0'),
('1479', '139', 'P', '0', '2022-09-30', '07:57:46', '17:59:38', '0', '0', '18056', '0', '0', NULL, '0', '0'),
('1480', '112', 'P', '0', '2022-09-30', '07:59:45', '18:00:03', '0', '0', '18009', '3', '0', NULL, '0', '0'),
('1481', '109', 'P', '0', '2022-09-30', '08:00:30', '18:03:35', '0', '0', '18093', '215', '0', NULL, '0', '0'),
('1482', '15', 'P', '0', '2022-09-30', '08:00:40', '18:08:31', '0', '0', '18236', '511', '0', NULL, '0', '0'),
('1483', '162', 'P', '0', '2022-09-30', '08:02:51', '17:58:35', '0', '0', '17872', '0', '0', NULL, '0', '0'),
('1484', '69', 'P', '0', '2022-09-30', '08:03:49', '12:46:03', '0', '0', '8467', '0', '0', NULL, '0', '0'),
('1485', '152', 'P', '0', '2022-09-30', '08:04:19', '18:00:52', '0', '0', '17897', '52', '0', NULL, '0', '0'),
('1486', '65', 'P', '0', '2022-09-30', '08:04:27', '18:00:34', '0', '0', '17884', '34', '0', NULL, '0', '0'),
('1487', '28', 'P', '0', '2022-09-30', '08:04:45', '18:00:22', '0', '0', '17869', '22', '0', NULL, '0', '0'),
('1488', '170', 'P', '0', '2022-09-30', '08:04:51', '14:44:11', '0', '0', '11980', '0', '0', NULL, '0', '0'),
('1489', '31', 'P', '0', '2022-09-30', '08:04:55', '14:44:57', '0', '0', '12001', '0', '0', NULL, '0', '0'),
('1490', '148', 'P', '0', '2022-09-30', '08:05:16', '18:00:13', '0', '0', '17849', '13', '0', NULL, '0', '0'),
('1491', '22', 'P', '0', '2022-09-30', '08:05:21', '16:11:53', '0', '0', '14596', '0', '0', NULL, '0', '0'),
('1492', '128', 'P', '0', '2022-09-30', '08:05:35', '18:01:17', '0', '0', '17871', '77', '0', NULL, '0', '0'),
('1493', '190', 'P', '0', '2022-09-30', '08:06:11', '18:00:46', '0', '0', '17838', '46', '0', NULL, '0', '0'),
('1494', '82', 'P', '0', '2022-09-30', '08:06:37', '16:12:35', '0', '0', '14579', '0', '0', NULL, '0', '0'),
('1495', '64', 'P', '0', '2022-09-30', '08:07:30', '08:07:30', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1496', '160', 'P', '0', '2022-09-30', '08:09:12', '18:05:04', '0', '0', '17876', '304', '0', NULL, '0', '0'),
('1497', '67', 'P', '0', '2022-09-30', '08:09:35', '17:58:30', '0', '0', '17668', '0', '0', NULL, '0', '0'),
('1498', '53', 'P', '0', '2022-09-30', '08:09:52', '17:58:47', '0', '0', '17668', '0', '0', NULL, '0', '0'),
('1499', '143', 'P', '0', '2022-09-30', '08:10:10', '17:59:00', '0', '0', '17665', '0', '0', NULL, '0', '0'),
('1500', '13', 'P', '0', '2022-09-30', '08:15:37', '08:15:37', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1501', '12', 'P', '0', '2022-09-30', '08:16:04', '08:16:04', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1502', '118', 'P', '0', '2022-09-30', '08:19:33', '18:01:05', '0', '0', '17446', '65', '0', NULL, '0', '0'),
('1503', '186', 'P', '0', '2022-09-30', '08:26:36', '17:58:51', '0', '0', '17168', '0', '0', NULL, '0', '0'),
('1504', '88', 'P', '0', '2022-09-30', '08:29:45', '17:58:24', '0', '0', '17060', '0', '0', NULL, '0', '0'),
('1505', '7', 'P', '0', '2022-09-30', '08:37:11', '18:05:32', '0', '0', '17051', '332', '0', NULL, '0', '0'),
('1506', '4', 'P', '0', '2022-09-30', '09:04:24', '09:04:24', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1507', '2', 'P', '0', '2022-09-30', '09:11:48', '18:27:36', '0', '0', '16674', '1656', '0', NULL, '0', '0'),
('1508', '103', 'P', '0', '2022-09-30', '09:41:50', '09:41:50', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1509', '1', 'P', '0', '2022-09-30', '09:41:59', '09:41:59', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1510', '5', 'P', '0', '2022-09-30', '10:16:35', '18:03:26', '0', '0', '14006', '206', '0', NULL, '0', '0'),
('1511', '3', 'P', '0', '2022-09-30', '10:19:36', '10:19:36', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1512', '16', 'P', '0', '2022-09-30', '11:53:18', '11:53:18', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1513', '87', 'P', '0', '2022-09-30', '18:32:03', '18:32:03', '0', '0', '0', '1923', '0', NULL, '0', '0'),
('1514', '44', 'P', '0', '2022-09-30', '18:32:42', '18:32:42', '0', '0', '0', '1962', '0', NULL, '0', '0'),
('1515', '18880', 'P', '0', '2022-09-30', '18:39:00', '18:39:00', '0', '0', '0', '2340', '0', NULL, '0', '0'),
('1516', '', 'P', '0', '1970-01-01', '05:00:00', '05:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1517', '18880', 'P', '0', '2022-10-01', '23:25:47', '06:35:00', '0', '0', '30324', '0', '0', NULL, '0', '0'),
('1518', '18880', 'P', '0', '2022-10-02', '01:30:07', '06:35:00', '0', '0', '-9147', '0', '0', NULL, '0', '0'),
('1544', '1', 'P', '0', '2022-10-01', '09:30:00', '18:31:00', '0', '0', '30600', '1860', '0', NULL, '0', '0'),
('1545', '1', 'A', '0', '2022-09-03', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1546', '3', 'P', '0', '2022-09-01', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1547', '3', 'P', '0', '2022-09-02', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1548', '3', 'A', '0', '2022-09-03', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1549', '3', 'P', '0', '2022-09-05', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1550', '3', 'P', '0', '2022-09-06', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1551', '3', 'P', '0', '2022-09-29', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1552', '177', 'P', '0', '2022-10-03', '12:20:45', '12:20:45', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1553', '23', 'P', '0', '2022-10-03', '17:58:57', '17:58:57', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1554', '69', 'P', '0', '2022-10-03', '17:59:04', '17:59:04', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1555', '31', 'P', '0', '2022-10-03', '17:59:06', '17:59:06', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1556', '162', 'P', '0', '2022-10-03', '17:59:09', '17:59:09', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1557', '147', 'P', '0', '2022-10-03', '17:59:15', '17:59:15', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1558', '61', 'P', '0', '2022-10-03', '17:59:20', '17:59:20', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1559', '170', 'P', '0', '2022-10-03', '17:59:23', '17:59:23', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1560', '143', 'P', '0', '2022-10-03', '17:59:30', '17:59:30', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1561', '186', 'P', '0', '2022-10-03', '17:59:33', '17:59:33', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1562', '67', 'P', '0', '2022-10-03', '17:59:41', '17:59:41', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1563', '21', 'P', '0', '2022-10-03', '17:59:43', '17:59:43', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1564', '22', 'P', '0', '2022-10-03', '17:59:47', '17:59:47', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1565', '65', 'P', '0', '2022-10-03', '18:00:01', '18:00:01', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1566', '60', 'P', '0', '2022-10-03', '18:00:09', '18:00:09', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1567', '57', 'P', '0', '2022-10-03', '18:00:12', '18:00:12', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1568', '171', 'P', '0', '2022-10-03', '18:00:15', '18:00:15', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1569', '46', 'P', '0', '2022-10-03', '18:00:19', '18:00:19', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1570', '70', 'P', '0', '2022-10-03', '18:00:23', '18:00:23', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1571', '193', 'P', '0', '2022-10-03', '18:00:29', '18:00:29', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1572', '139', 'P', '0', '2022-10-03', '18:00:36', '18:00:36', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1573', '121', 'P', '0', '2022-10-03', '18:00:42', '18:00:42', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1574', '75', 'P', '0', '2022-10-03', '18:00:48', '18:00:48', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1575', '112', 'P', '0', '2022-10-03', '18:00:51', '18:00:51', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1576', '181', 'P', '0', '2022-10-03', '18:00:57', '18:00:57', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1577', '173', 'P', '0', '2022-10-03', '18:01:01', '18:01:01', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1578', '35', 'P', '0', '2022-10-03', '18:01:03', '18:01:03', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1579', '161', 'P', '0', '2022-10-03', '18:01:06', '18:01:06', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1580', '148', 'P', '0', '2022-10-03', '18:01:09', '18:01:09', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1581', '25', 'P', '0', '2022-10-03', '18:01:15', '18:01:15', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1582', '64', 'P', '0', '2022-10-03', '18:01:18', '18:01:18', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1583', '152', 'P', '0', '2022-10-03', '18:01:23', '18:01:23', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1584', '28', 'P', '0', '2022-10-03', '18:01:36', '18:01:36', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1585', '53', 'P', '0', '2022-10-03', '18:02:00', '18:02:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1586', '88', 'P', '0', '2022-10-03', '18:02:14', '18:02:14', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1587', '32', 'P', '0', '2022-10-03', '18:02:34', '18:02:34', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1588', '30', 'P', '0', '2022-10-03', '18:02:52', '18:02:52', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1589', '51', 'P', '0', '2022-10-03', '18:03:16', '18:03:16', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1590', '190', 'P', '0', '2022-10-03', '18:05:13', '18:05:13', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1591', '17', 'P', '0', '2022-10-03', '18:06:08', '18:42:33', '0', '0', '-368', '2553', '0', NULL, '0', '0'),
('1592', '20', 'P', '0', '2022-10-03', '18:07:25', '18:07:25', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1593', '191', 'P', '0', '2022-10-03', '18:08:57', '18:08:57', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1594', '128', 'P', '0', '2022-10-03', '18:10:55', '18:10:55', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1595', '192', 'P', '0', '2022-10-03', '18:15:41', '18:15:41', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1596', '109', 'P', '0', '2022-10-03', '18:15:46', '18:15:46', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1597', '15', 'P', '0', '2022-10-03', '18:21:34', '18:21:34', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1598', '118', 'P', '0', '2022-10-03', '18:22:50', '18:22:50', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1599', '7', 'P', '0', '2022-10-03', '18:41:31', '18:41:31', '0', '0', '-2491', '2491', '0', NULL, '0', '0'),
('1600', '160', 'P', '0', '2022-10-03', '18:58:07', '18:58:07', '0', '0', '-3487', '3487', '0', NULL, '0', '0'),
('1601', '18', 'P', '0', '2022-10-03', '19:00:04', '19:00:04', '0', '0', '-3604', '3604', '0', NULL, '0', '0'),
('1602', '8', 'P', '0', '2022-10-03', '19:00:18', '19:00:18', '0', '0', '-3618', '3618', '0', NULL, '0', '0'),
('1603', '47', 'P', '0', '2022-10-03', '19:00:24', '19:00:24', '0', '0', '-3624', '3624', '0', NULL, '0', '0'),
('1604', '130', 'P', '0', '2022-10-03', '19:00:56', '19:00:56', '0', '0', '-3656', '3656', '0', NULL, '0', '0'),
('1605', '189', 'P', '0', '2022-10-03', '19:02:05', '19:02:05', '0', '0', '-3725', '3725', '0', NULL, '0', '0'),
('1606', '6', 'P', '0', '2022-10-03', '19:11:59', '19:11:59', '0', '0', '-4319', '4319', '0', NULL, '0', '0'),
('1607', '2', 'P', '0', '2022-10-03', '19:14:58', '19:14:58', '0', '0', '-4498', '4498', '0', NULL, '0', '0'),
('1608', '4', 'P', '0', '2022-10-03', '19:24:22', '19:24:22', '0', '0', '-5062', '5062', '0', NULL, '0', '0'),
('1609', '92', 'P', '0', '2022-09-01', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1610', '92', 'P', '0', '2022-09-02', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1611', '92', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1612', '92', 'P', '0', '2022-09-05', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1613', '92', 'P', '0', '2022-09-06', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1614', '92', 'P', '0', '2022-09-07', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1615', '8', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1616', '48', 'P', '0', '2022-09-01', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1617', '48', 'P', '0', '2022-09-02', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1618', '48', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1619', '48', 'P', '0', '2022-09-05', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1620', '48', 'P', '0', '2022-09-06', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1621', '48', 'P', '0', '2022-09-07', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1622', '47', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1623', '46', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1624', '45', 'P', '0', '2022-09-01', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1625', '45', 'P', '0', '2022-09-02', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1626', '45', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1627', '45', 'P', '0', '2022-09-05', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1628', '45', 'P', '0', '2022-09-06', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1629', '45', 'P', '0', '2022-09-07', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1630', '43', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1631', '43', 'A', '0', '2022-09-05', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1632', '42', 'P', '0', '2022-09-01', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1633', '42', 'P', '0', '2022-09-02', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1634', '42', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1635', '42', 'P', '0', '2022-09-05', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1636', '42', 'P', '0', '2022-09-06', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1637', '42', 'P', '0', '2022-09-07', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1638', '40', 'P', '0', '2022-09-01', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1639', '40', 'P', '0', '2022-09-02', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1640', '40', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1641', '40', 'P', '0', '2022-09-05', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1642', '40', 'P', '0', '2022-09-06', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1643', '40', 'P', '0', '2022-09-07', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1644', '39', 'P', '0', '2022-09-01', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1645', '39', 'P', '0', '2022-09-02', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1646', '39', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1647', '39', 'P', '0', '2022-09-05', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1648', '39', 'P', '0', '2022-09-06', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1649', '39', 'P', '0', '2022-09-07', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1650', '35', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1651', '187', 'P', '0', '2022-09-05', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1652', '187', 'P', '0', '2022-09-06', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1653', '187', 'P', '0', '2022-09-07', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1654', '139', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1655', '132', 'P', '0', '2022-09-01', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1656', '132', 'P', '0', '2022-09-02', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1657', '132', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1658', '132', 'P', '0', '2022-09-05', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1659', '132', 'P', '0', '2022-09-06', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1660', '132', 'P', '0', '2022-09-07', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1661', '130', 'A', '0', '2022-09-01', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1662', '130', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1663', '114', 'P', '0', '2022-09-01', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1664', '114', 'P', '0', '2022-09-02', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1665', '114', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1666', '114', 'P', '0', '2022-09-05', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1667', '114', 'P', '0', '2022-09-06', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1668', '114', 'P', '0', '2022-09-07', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1669', '112', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1670', '111', 'A', '0', '2022-09-02', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1671', '111', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1672', '107', 'P', '0', '2022-09-01', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1673', '107', 'P', '0', '2022-09-02', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1674', '107', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1675', '107', 'P', '0', '2022-09-05', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1676', '107', 'P', '0', '2022-09-06', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1677', '107', 'P', '0', '2022-09-07', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1678', '64', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1679', '75', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1680', '35', 'P', '0', '2022-09-10', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1681', '47', 'P', '0', '2022-09-10', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1682', '47', 'A', '0', '2022-09-12', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1683', '64', 'A', '0', '2022-09-10', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1684', '43', 'P', '0', '2022-09-10', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1685', '111', 'GH', '0', '2022-09-08', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1686', '111', 'A', '0', '2022-09-09', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1687', '111', 'P', '0', '2022-09-10', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1688', '112', 'P', '0', '2022-09-10', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1689', '130', 'P', '0', '2022-09-10', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1690', '139', 'P', '0', '2022-09-10', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1691', '139', 'A', '0', '2022-09-14', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1692', '75', 'P', '0', '2022-09-10', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1693', '139', 'A', '0', '2022-09-15', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1694', '139', 'P', '0', '2022-09-17', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1695', '8', 'A', '0', '2022-09-17', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1696', '35', 'P', '0', '2022-09-17', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1697', '47', 'P', '0', '2022-09-17', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1698', '64', 'A', '0', '2022-09-17', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1699', '43', 'P', '0', '2022-09-17', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1700', '111', 'P', '0', '2022-09-17', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1701', '111', 'A', '0', '2022-09-22', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1702', '130', 'P', '0', '2022-09-17', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1703', '130', 'A', '0', '2022-09-21', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1704', '183', 'A', '0', '2022-09-19', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1705', '75', 'P', '0', '2022-09-17', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1706', '8', 'A', '0', '2022-09-29', '00:00:00', '00:00:00', '0', '0', '0', '0', '0', NULL, '0', '0'),
('1707', '21', 'P', '0', '2022-09-03', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1708', '21', 'P', '0', '2022-09-10', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1709', '21', 'P', '0', '2022-09-17', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0'),
('1710', '21', 'P', '0', '2022-09-24', '08:00:00', '18:00:00', '0', '0', '36000', '0', '0', NULL, '0', '0');

### Structure of table `0_kv_empl_attendance_settings` ###

DROP TABLE IF EXISTS `0_kv_empl_attendance_settings`;

CREATE TABLE `0_kv_empl_attendance_settings` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `dept_id` int(5) NOT NULL,
  `option_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `option_value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=225 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_attendance_settings` ###

INSERT INTO `0_kv_empl_attendance_settings` VALUES
('1', '2', 'early_coming_punch', ''),
('2', '2', 'Halfday_workduration', ''),
('3', '2', 'absent_workduration', ''),
('4', '2', 'mark_half_day_late', ''),
('5', '2', 'mark_half_day_early_go', ''),
('6', '2', 'late_going_punch', ''),
('7', '2', 'grace_in_time', '09:10:00'),
('8', '2', 'grace_out_time', '08:00:00'),
('9', '2', 'Halfday_workduration_min', '09:10:00'),
('10', '2', 'absent_workduration_min', '09:10:00'),
('11', '2', 'mark_half_day_late_min', '09:10:00'),
('12', '2', 'mark_half_day_early_go_min', '09:10:00'),
('13', '3', 'early_coming_punch', ''),
('14', '3', 'Halfday_workduration', ''),
('15', '3', 'absent_workduration', ''),
('16', '3', 'mark_half_day_late', ''),
('17', '3', 'mark_half_day_early_go', ''),
('18', '3', 'absent_workduration_both', ''),
('19', '3', 'consecutive_days_absent', ''),
('20', '3', 'late_going_punch', '1'),
('21', '3', 'grace_in_time', '09:10:00'),
('22', '3', 'grace_out_time', '18:00:00'),
('23', '3', 'Halfday_workduration_min', '09:32:00'),
('24', '3', 'absent_workduration_min', '09:32:00'),
('25', '3', 'mark_half_day_late_min', '09:32:00'),
('26', '3', 'mark_half_day_early_go_min', '09:32:00'),
('27', '1', 'early_coming_punch', ''),
('28', '1', 'Halfday_workduration', ''),
('29', '1', 'absent_workduration', ''),
('30', '1', 'mark_half_day_late', ''),
('31', '1', 'mark_half_day_early_go', ''),
('32', '1', 'absent_workduration_both', ''),
('33', '1', 'consecutive_days_absent', ''),
('34', '1', 'late_going_punch', ''),
('35', '1', 'grace_in_time', '09:10:00'),
('36', '1', 'grace_out_time', '08:00:00'),
('37', '1', 'Halfday_workduration_min', '09:32:00'),
('38', '1', 'absent_workduration_min', '09:32:00'),
('39', '1', 'mark_half_day_late_min', '09:32:00'),
('40', '1', 'mark_half_day_early_go_min', '09:32:00'),
('41', '2', 'absent_workduration_both', ''),
('42', '2', 'consecutive_days_absent', ''),
('43', '18', 'early_coming_punch', ''),
('44', '18', 'Halfday_workduration', ''),
('45', '18', 'absent_workduration', ''),
('46', '18', 'mark_half_day_late', ''),
('47', '18', 'mark_half_day_early_go', ''),
('48', '18', 'absent_workduration_both', ''),
('49', '18', 'consecutive_days_absent', ''),
('50', '18', 'late_going_punch', '1'),
('51', '18', 'grace_in_time', '09:10:00'),
('52', '18', 'grace_out_time', '06:13:00'),
('53', '18', 'Halfday_workduration_min', '09:10:00'),
('54', '18', 'absent_workduration_min', '09:10:00'),
('55', '18', 'mark_half_day_late_min', '09:10:00'),
('56', '18', 'mark_half_day_early_go_min', '09:10:00'),
('57', '17', 'early_coming_punch', ''),
('58', '17', 'Halfday_workduration', ''),
('59', '17', 'absent_workduration', ''),
('60', '17', 'mark_half_day_late', ''),
('61', '17', 'mark_half_day_early_go', ''),
('62', '17', 'absent_workduration_both', ''),
('63', '17', 'consecutive_days_absent', ''),
('64', '17', 'late_going_punch', ''),
('65', '17', 'grace_in_time', '09:10:00'),
('66', '17', 'grace_out_time', '08:10:00'),
('67', '17', 'Halfday_workduration_min', '09:10:00'),
('68', '17', 'absent_workduration_min', '09:10:00'),
('69', '17', 'mark_half_day_late_min', '09:10:00'),
('70', '17', 'mark_half_day_early_go_min', '09:10:00'),
('71', '16', 'early_coming_punch', ''),
('72', '16', 'Halfday_workduration', ''),
('73', '16', 'absent_workduration', ''),
('74', '16', 'mark_half_day_late', ''),
('75', '16', 'mark_half_day_early_go', ''),
('76', '16', 'absent_workduration_both', ''),
('77', '16', 'consecutive_days_absent', ''),
('78', '16', 'late_going_punch', ''),
('79', '16', 'grace_in_time', '09:10:00'),
('80', '16', 'grace_out_time', '08:00:00'),
('81', '16', 'Halfday_workduration_min', '09:10:00'),
('82', '16', 'absent_workduration_min', '09:10:00'),
('83', '16', 'mark_half_day_late_min', '09:10:00'),
('84', '16', 'mark_half_day_early_go_min', '09:10:00'),
('85', '15', 'early_coming_punch', ''),
('86', '15', 'Halfday_workduration', ''),
('87', '15', 'absent_workduration', ''),
('88', '15', 'mark_half_day_late', ''),
('89', '15', 'mark_half_day_early_go', ''),
('90', '15', 'absent_workduration_both', ''),
('91', '15', 'consecutive_days_absent', ''),
('92', '15', 'late_going_punch', ''),
('93', '15', 'grace_in_time', '09:10:00'),
('94', '15', 'grace_out_time', '08:00:00'),
('95', '15', 'Halfday_workduration_min', '09:10:00'),
('96', '15', 'absent_workduration_min', '09:10:00'),
('97', '15', 'mark_half_day_late_min', '09:10:00'),
('98', '15', 'mark_half_day_early_go_min', '09:10:00'),
('99', '13', 'early_coming_punch', ''),
('100', '13', 'Halfday_workduration', ''),
('101', '13', 'absent_workduration', ''),
('102', '13', 'mark_half_day_late', ''),
('103', '13', 'mark_half_day_early_go', ''),
('104', '13', 'absent_workduration_both', ''),
('105', '13', 'consecutive_days_absent', ''),
('106', '13', 'late_going_punch', ''),
('107', '13', 'grace_in_time', '09:10:00'),
('108', '13', 'grace_out_time', '08:00:00'),
('109', '13', 'Halfday_workduration_min', '09:10:00'),
('110', '13', 'absent_workduration_min', '09:10:00'),
('111', '13', 'mark_half_day_late_min', '09:10:00'),
('112', '13', 'mark_half_day_early_go_min', '09:10:00'),
('113', '11', 'early_coming_punch', ''),
('114', '11', 'Halfday_workduration', ''),
('115', '11', 'absent_workduration', ''),
('116', '11', 'mark_half_day_late', ''),
('117', '11', 'mark_half_day_early_go', ''),
('118', '11', 'absent_workduration_both', ''),
('119', '11', 'consecutive_days_absent', ''),
('120', '11', 'late_going_punch', ''),
('121', '11', 'grace_in_time', '09:10:00'),
('122', '11', 'grace_out_time', '08:00:00'),
('123', '11', 'Halfday_workduration_min', '09:10:00'),
('124', '11', 'absent_workduration_min', '09:10:00'),
('125', '11', 'mark_half_day_late_min', '09:10:00'),
('126', '11', 'mark_half_day_early_go_min', '09:10:00'),
('127', '10', 'early_coming_punch', ''),
('128', '10', 'Halfday_workduration', ''),
('129', '10', 'absent_workduration', ''),
('130', '10', 'mark_half_day_late', ''),
('131', '10', 'mark_half_day_early_go', ''),
('132', '10', 'absent_workduration_both', ''),
('133', '10', 'consecutive_days_absent', ''),
('134', '10', 'late_going_punch', ''),
('135', '10', 'grace_in_time', '09:10:00'),
('136', '10', 'grace_out_time', '08:00:00'),
('137', '10', 'Halfday_workduration_min', '09:10:00'),
('138', '10', 'absent_workduration_min', '09:10:00'),
('139', '10', 'mark_half_day_late_min', '09:10:00'),
('140', '10', 'mark_half_day_early_go_min', '09:10:00'),
('141', '9', 'early_coming_punch', ''),
('142', '9', 'Halfday_workduration', ''),
('143', '9', 'absent_workduration', ''),
('144', '9', 'mark_half_day_late', ''),
('145', '9', 'mark_half_day_early_go', ''),
('146', '9', 'absent_workduration_both', ''),
('147', '9', 'consecutive_days_absent', ''),
('148', '9', 'late_going_punch', ''),
('149', '9', 'grace_in_time', '09:10:00'),
('150', '9', 'grace_out_time', '08:00:00'),
('151', '9', 'Halfday_workduration_min', '09:10:00'),
('152', '9', 'absent_workduration_min', '09:10:00'),
('153', '9', 'mark_half_day_late_min', '09:10:00'),
('154', '9', 'mark_half_day_early_go_min', '09:10:00'),
('155', '8', 'early_coming_punch', ''),
('156', '8', 'Halfday_workduration', ''),
('157', '8', 'absent_workduration', ''),
('158', '8', 'mark_half_day_late', ''),
('159', '8', 'mark_half_day_early_go', ''),
('160', '8', 'absent_workduration_both', ''),
('161', '8', 'consecutive_days_absent', ''),
('162', '8', 'late_going_punch', ''),
('163', '8', 'grace_in_time', '09:10:00'),
('164', '8', 'grace_out_time', '08:00:00'),
('165', '8', 'Halfday_workduration_min', '09:10:00'),
('166', '8', 'absent_workduration_min', '09:10:00'),
('167', '8', 'mark_half_day_late_min', '09:10:00'),
('168', '8', 'mark_half_day_early_go_min', '09:10:00'),
('169', '7', 'early_coming_punch', ''),
('170', '7', 'Halfday_workduration', ''),
('171', '7', 'absent_workduration', ''),
('172', '7', 'mark_half_day_late', ''),
('173', '7', 'mark_half_day_early_go', ''),
('174', '7', 'absent_workduration_both', ''),
('175', '7', 'consecutive_days_absent', ''),
('176', '7', 'late_going_punch', ''),
('177', '7', 'grace_in_time', '09:10:00'),
('178', '7', 'grace_out_time', '08:00:00'),
('179', '7', 'Halfday_workduration_min', '09:10:00'),
('180', '7', 'absent_workduration_min', '09:10:00'),
('181', '7', 'mark_half_day_late_min', '09:10:00'),
('182', '7', 'mark_half_day_early_go_min', '09:10:00'),
('183', '6', 'early_coming_punch', ''),
('184', '6', 'Halfday_workduration', ''),
('185', '6', 'absent_workduration', ''),
('186', '6', 'mark_half_day_late', ''),
('187', '6', 'mark_half_day_early_go', ''),
('188', '6', 'absent_workduration_both', ''),
('189', '6', 'consecutive_days_absent', ''),
('190', '6', 'late_going_punch', ''),
('191', '6', 'grace_in_time', '09:10:00'),
('192', '6', 'grace_out_time', '08:10:00'),
('193', '6', 'Halfday_workduration_min', '09:10:00'),
('194', '6', 'absent_workduration_min', '09:10:00'),
('195', '6', 'mark_half_day_late_min', '09:10:00'),
('196', '6', 'mark_half_day_early_go_min', '09:10:00'),
('197', '5', 'early_coming_punch', ''),
('198', '5', 'Halfday_workduration', ''),
('199', '5', 'absent_workduration', ''),
('200', '5', 'mark_half_day_late', ''),
('201', '5', 'mark_half_day_early_go', ''),
('202', '5', 'absent_workduration_both', ''),
('203', '5', 'consecutive_days_absent', ''),
('204', '5', 'late_going_punch', ''),
('205', '5', 'grace_in_time', '09:10:00'),
('206', '5', 'grace_out_time', '08:00:00'),
('207', '5', 'Halfday_workduration_min', '09:10:00'),
('208', '5', 'absent_workduration_min', '09:10:00'),
('209', '5', 'mark_half_day_late_min', '09:10:00'),
('210', '5', 'mark_half_day_early_go_min', '09:10:00'),
('211', '4', 'early_coming_punch', ''),
('212', '4', 'Halfday_workduration', ''),
('213', '4', 'absent_workduration', ''),
('214', '4', 'mark_half_day_late', ''),
('215', '4', 'mark_half_day_early_go', ''),
('216', '4', 'absent_workduration_both', ''),
('217', '4', 'consecutive_days_absent', ''),
('218', '4', 'late_going_punch', ''),
('219', '4', 'grace_in_time', '09:10:00'),
('220', '4', 'grace_out_time', '08:10:00'),
('221', '4', 'Halfday_workduration_min', '09:10:00'),
('222', '4', 'absent_workduration_min', '09:10:00'),
('223', '4', 'mark_half_day_late_min', '09:10:00'),
('224', '4', 'mark_half_day_early_go_min', '09:10:00');

### Structure of table `0_kv_empl_attendancee` ###

DROP TABLE IF EXISTS `0_kv_empl_attendancee`;

CREATE TABLE `0_kv_empl_attendancee` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `month` int(2) DEFAULT NULL,
  `year` int(2) DEFAULT NULL,
  `dept_id` int(10) NOT NULL,
  `empl_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `1` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `2` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `3` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `4` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `5` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `6` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `7` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `8` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `9` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `10` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `11` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `12` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `13` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `14` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `15` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `16` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `17` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `18` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `19` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `20` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `21` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `22` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `23` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `24` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `25` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `26` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `27` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `28` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `29` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `30` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `31` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_attendancee` ###

INSERT INTO `0_kv_empl_attendancee` VALUES
('1', '2', '3', '3', '1', '', '', 'P', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''),
('2', '9', '3', '3', '1', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '06', '');

### Structure of table `0_kv_empl_candidates` ###

DROP TABLE IF EXISTS `0_kv_empl_candidates`;

CREATE TABLE `0_kv_empl_candidates` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `fname` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `lname` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `qualification` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `position` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `salary` double NOT NULL,
  `experience` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `last_company` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `comments` varchar(150) COLLATE utf8_unicode_ci NOT NULL,
  `filename` varchar(600) COLLATE utf8_unicode_ci DEFAULT NULL,
  `unique_name` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_candidates` ###


### Structure of table `0_kv_empl_country` ###

DROP TABLE IF EXISTS `0_kv_empl_country`;

CREATE TABLE `0_kv_empl_country` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `iso` varchar(50) DEFAULT NULL,
  `local_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=247 DEFAULT CHARSET=utf8 ;

### Data of table `0_kv_empl_country` ###

INSERT INTO `0_kv_empl_country` VALUES
('1', 'AD', 'Andorra'),
('2', 'AE', 'United Arab Emirates'),
('3', 'AF', 'Afghanistan'),
('4', 'AG', 'Antigua and Barbuda'),
('5', 'AI', 'Anguilla'),
('6', 'AL', 'Albania'),
('7', 'AM', 'Armenia'),
('8', 'AN', 'Netherlands Antilles'),
('9', 'AO', 'Angola'),
('10', 'AQ', 'Antarctica'),
('11', 'AR', 'Argentina'),
('12', 'AS', 'American Samoa'),
('13', 'AT', 'Austria'),
('14', 'AU', 'Australia'),
('15', 'AW', 'Aruba'),
('16', 'AX', 'Aland Islands'),
('17', 'AZ', 'Azerbaijan'),
('18', 'BA', 'Bosnia and Herzegovina'),
('19', 'BB', 'Barbados'),
('20', 'BD', 'Bangladesh'),
('21', 'BE', 'Belgium'),
('22', 'BF', 'Burkina Faso'),
('23', 'BG', 'Bulgaria'),
('24', 'BH', 'Bahrain'),
('25', 'BI', 'Burundi'),
('26', 'BJ', 'Benin'),
('27', 'BL', 'Saint Barthlemy'),
('28', 'BM', 'Bermuda'),
('29', 'BN', 'Brunei Darussalam'),
('30', 'BO', 'BoliviaBolivia, Plurinational state of'),
('31', 'BR', 'Brazil'),
('32', 'BS', 'Bahamas'),
('33', 'BT', 'Bhutan'),
('34', 'BV', 'Bouvet Island'),
('35', 'BW', 'Botswana'),
('36', 'BY', 'Belarus'),
('37', 'BZ', 'Belize'),
('38', 'CA', 'Canada'),
('39', 'CC', 'Cocos (Keeling) Islands'),
('40', 'CD', 'Congo, The Democratic Republic of the'),
('41', 'CF', 'Central African Republic'),
('42', 'CG', 'Congo'),
('43', 'CH', 'Switzerland'),
('45', 'CK', 'Cook Islands'),
('46', 'CL', 'Chile'),
('47', 'CM', 'Cameroon'),
('48', 'CN', 'China'),
('49', 'CO', 'Colombia'),
('50', 'CR', 'Costa Rica'),
('51', 'CU', 'Cuba'),
('52', 'CV', 'Cape Verde'),
('53', 'CX', 'Christmas Island'),
('54', 'CY', 'Cyprus'),
('55', 'CZ', 'Czech Republic'),
('56', 'DE', 'Germany'),
('57', 'DJ', 'Djibouti'),
('58', 'DK', 'Denmark'),
('59', 'DM', 'Dominica'),
('60', 'DO', 'Dominican Republic'),
('61', 'DZ', 'Algeria'),
('62', 'EC', 'Ecuador'),
('63', 'EE', 'Estonia'),
('64', 'EG', 'Egypt'),
('65', 'EH', 'Western Sahara'),
('66', 'ER', 'Eritrea'),
('67', 'ES', 'Spain'),
('68', 'ET', 'Ethiopia'),
('69', 'FI', 'Finland'),
('70', 'FJ', 'Fiji'),
('71', 'FK', 'Falkland Islands (Malvinas)'),
('72', 'FM', 'Micronesia, Federated States of'),
('73', 'FO', 'Faroe Islands'),
('74', 'FR', 'France'),
('75', 'GA', 'Gabon'),
('76', 'GB', 'United Kingdom'),
('77', 'GD', 'Grenada'),
('78', 'GE', 'Georgia'),
('79', 'GF', 'French Guiana'),
('80', 'GG', 'Guernsey'),
('81', 'GH', 'Ghana'),
('82', 'GI', 'Gibraltar'),
('83', 'GL', 'Greenland'),
('84', 'GM', 'Gambia'),
('85', 'GN', 'Guinea'),
('86', 'GP', 'Guadeloupe'),
('87', 'GQ', 'Equatorial Guinea'),
('88', 'GR', 'Greece'),
('89', 'GS', 'South Georgia and the South Sandwich Islands'),
('90', 'GT', 'Guatemala'),
('91', 'GU', 'Guam'),
('92', 'GW', 'Guinea-Bissau'),
('93', 'GY', 'Guyana'),
('94', 'HK', 'Hong Kong'),
('95', 'HM', 'Heard Island and McDonald Islands'),
('96', 'HN', 'Honduras'),
('97', 'HR', 'Croatia'),
('98', 'HT', 'Haiti'),
('99', 'HU', 'Hungary'),
('100', 'ID', 'Indonesia'),
('101', 'IE', 'Ireland'),
('102', 'IL', 'Israel'),
('103', 'IM', 'Isle of Man'),
('104', 'IN', 'India'),
('105', 'IO', 'British Indian Ocean Territory'),
('106', 'IQ', 'Iraq'),
('107', 'IR', 'Iran, Islamic Republic of'),
('108', 'IS', 'Iceland'),
('109', 'IT', 'Italy'),
('110', 'JE', 'Jersey'),
('111', 'JM', 'Jamaica'),
('112', 'JO', 'Jordan'),
('113', 'JP', 'Japan'),
('114', 'KE', 'Kenya'),
('115', 'KG', 'Kyrgyzstan'),
('116', 'KH', 'Cambodia'),
('117', 'KI', 'Kiribati'),
('118', 'KM', 'Comoros'),
('119', 'KN', 'Saint Kitts and Nevis'),
('120', 'KP', 'Korea, Democratic People&#039;s Republic of'),
('121', 'KR', 'Korea, Republic of'),
('122', 'KW', 'Kuwait'),
('123', 'KY', 'Cayman Islands'),
('124', 'KZ', 'Kazakhstan'),
('125', 'LA', 'Lao People&#039;s Democratic Republic'),
('126', 'LB', 'Lebanon'),
('127', 'LC', 'Saint Lucia'),
('128', 'LI', 'Liechtenstein'),
('129', 'LK', 'Sri Lanka'),
('130', 'LR', 'Liberia'),
('131', 'LS', 'Lesotho'),
('132', 'LT', 'Lithuania'),
('133', 'LU', 'Luxembourg'),
('134', 'LV', 'Latvia'),
('135', 'LY', 'Libyan Arab Jamahiriya'),
('136', 'MA', 'Morocco'),
('137', 'MC', 'Monaco'),
('138', 'MD', 'Moldova, Republic of'),
('139', 'ME', 'Montenegro'),
('140', 'MF', 'Saint Martin'),
('141', 'MG', 'Madagascar'),
('142', 'MH', 'Marshall Islands'),
('143', 'MK', 'Macedonia'),
('144', 'ML', 'Mali'),
('145', 'MM', 'Myanmar'),
('146', 'MN', 'Mongolia'),
('147', 'MO', 'Macao'),
('148', 'MP', 'Northern Mariana Islands'),
('149', 'MQ', 'Martinique'),
('150', 'MR', 'Mauritania'),
('151', 'MS', 'Montserrat'),
('152', 'MT', 'Malta'),
('153', 'MU', 'Mauritius'),
('154', 'MV', 'Maldives'),
('155', 'MW', 'Malawi'),
('156', 'MX', 'Mexico'),
('157', 'MY', 'Malaysia'),
('158', 'MZ', 'Mozambique'),
('159', 'NA', 'Namibia'),
('160', 'NC', 'New Caledonia'),
('161', 'NE', 'Niger'),
('162', 'NF', 'Norfolk Island'),
('163', 'NG', 'Nigeria'),
('164', 'NI', 'Nicaragua'),
('165', 'NL', 'Netherlands'),
('166', 'NO', 'Norway'),
('167', 'NP', 'Nepal'),
('168', 'NR', 'Nauru'),
('169', 'NU', 'Niue'),
('170', 'NZ', 'New Zealand'),
('171', 'OM', 'Oman'),
('172', 'PA', 'Panama'),
('173', 'PE', 'Peru'),
('174', 'PF', 'French Polynesia'),
('175', 'PG', 'Papua New Guinea'),
('176', 'PH', 'Philippines'),
('177', 'PK', 'Pakistan'),
('178', 'PL', 'Poland'),
('179', 'PM', 'Saint Pierre and Miquelon'),
('180', 'PN', 'Pitcairn'),
('181', 'PR', 'Puerto Rico'),
('182', 'PS', 'Palestinian Territory, Occupied'),
('183', 'PT', 'Portugal'),
('184', 'PW', 'Palau'),
('185', 'PY', 'Paraguay'),
('186', 'QA', 'Qatar'),
('188', 'RO', 'Romania'),
('189', 'RS', 'Serbia'),
('190', 'RU', 'Russian Federation'),
('191', 'RW', 'Rwanda'),
('192', 'SA', 'Saudi Arabia'),
('193', 'SB', 'Solomon Islands'),
('194', 'SC', 'Seychelles'),
('195', 'SD', 'Sudan'),
('196', 'SE', 'Sweden'),
('197', 'SG', 'Singapore'),
('198', 'SH', 'Saint Helena'),
('199', 'SI', 'Slovenia'),
('200', 'SJ', 'Svalbard and Jan Mayen'),
('201', 'SK', 'Slovakia'),
('202', 'SL', 'Sierra Leone'),
('203', 'SM', 'San Marino'),
('204', 'SN', 'Senegal'),
('205', 'SO', 'Somalia'),
('206', 'SR', 'Suriname'),
('207', 'ST', 'Sao Tome and Principe'),
('208', 'SV', 'El Salvador'),
('209', 'SY', 'Syrian Arab Republic'),
('210', 'SZ', 'Swaziland'),
('211', 'TC', 'Turks and Caicos Islands'),
('212', 'TD', 'Chad'),
('213', 'TF', 'French Southern Territories'),
('214', 'TG', 'Togo'),
('215', 'TH', 'Thailand'),
('216', 'TJ', 'Tajikistan'),
('217', 'TK', 'Tokelau'),
('218', 'TL', 'Timor-Leste'),
('219', 'TM', 'Turkmenistan'),
('220', 'TN', 'Tunisia'),
('221', 'TO', 'Tonga'),
('222', 'TR', 'Turkey'),
('223', 'TT', 'Trinidad and Tobago'),
('224', 'TV', 'Tuvalu'),
('225', 'TW', 'Taiwan'),
('226', 'TZ', 'Tanzania, United Republic of'),
('227', 'UA', 'Ukraine'),
('228', 'UG', 'Uganda'),
('229', 'UM', 'United States Minor Outlying Islands'),
('230', 'US', 'United States'),
('231', 'UY', 'Uruguay'),
('232', 'UZ', 'Uzbekistan'),
('233', 'VA', 'Holy See (Vatican City State)'),
('234', 'VC', 'Saint Vincent and the Grenadines'),
('235', 'VE', 'Venezuela, Bolivarian Republic of'),
('236', 'VG', 'Virgin Islands, British'),
('237', 'VI', 'Virgin Islands, U.S.'),
('238', 'VN', 'Viet Nam'),
('239', 'VU', 'Vanuatu'),
('240', 'WF', 'Wallis and Futuna'),
('241', 'WS', 'Samoa'),
('242', 'YE', 'Yemen'),
('243', 'YT', 'Mayotte'),
('244', 'ZA', 'South Africa'),
('245', 'ZM', 'Zambia'),
('246', 'ZW', 'Zimbabwe');

### Structure of table `0_kv_empl_cv` ###

DROP TABLE IF EXISTS `0_kv_empl_cv`;

CREATE TABLE `0_kv_empl_cv` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `cv_title` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `doc_type` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `exp_date` date NOT NULL,
  `notify_from` date NOT NULL,
  `alert` tinyint(1) NOT NULL,
  `related_to` int(11) NOT NULL,
  `filename` varchar(600) COLLATE utf8_unicode_ci NOT NULL,
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `unique_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_cv` ###


### Structure of table `0_kv_empl_degree` ###

DROP TABLE IF EXISTS `0_kv_empl_degree`;

CREATE TABLE `0_kv_empl_degree` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `degree` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `major` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `university` varchar(80) COLLATE utf8_unicode_ci NOT NULL,
  `grade` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `year` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_degree` ###


### Structure of table `0_kv_empl_departments` ###

DROP TABLE IF EXISTS `0_kv_empl_departments`;

CREATE TABLE `0_kv_empl_departments` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `role` int(5) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_departments` ###

INSERT INTO `0_kv_empl_departments` VALUES
('1', 'Accounts', '9', '0'),
('2', 'Admin', '14', '0'),
('3', 'IT', '16', '0'),
('4', 'FINANCE', '15', '0'),
('5', 'PURCHASE DPT', '15', '0'),
('6', 'STORE', '15', '0'),
('7', 'SALES DPT', '14', '0'),
('8', 'DISPATCH DPT', '14', '0'),
('9', 'ADMIN', '14', '0'),
('10', 'ENGINEERING DPT', '14', '0'),
('11', 'LAB', '14', '0'),
('13', 'BOILER', '14', '0'),
('15', 'PRODUCTION DPT', '14', '0'),
('16', 'PRINTING DPT', '14', '0'),
('17', 'CLEANING DPT', '14', '0'),
('18', 'DESIGNING', '15', '0'),
('19', 'RO-PLANT ', '5', '0');

### Structure of table `0_kv_empl_designation` ###

DROP TABLE IF EXISTS `0_kv_empl_designation`;

CREATE TABLE `0_kv_empl_designation` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_designation` ###

INSERT INTO `0_kv_empl_designation` VALUES
('1', 'Assistant ', '0'),
('2', 'Administrator', '0'),
('3', 'Software Engineer', '0'),
('4', 'Senior Software Engineer', '0'),
('5', 'Project Manager', '0'),
('6', 'Business Analyst', '0'),
('7', 'CEO', '0'),
('8', 'executive director', '0'),
('9', 'COO', '0'),
('10', 'managing director', '0'),
('11', 'vice-president', '0'),
('12', 'Human Resource Director', '0'),
('13', 'Accountant', '0'),
('14', 'Sales Associate', '0'),
('15', 'Director of Sales', '0'),
('16', 'Loader', '0'),
('17', 'HELPER', '0'),
('18', 'LAB OFFICER', '0'),
('19', 'PURCHASE OFFICER', '0'),
('20', 'SALES OFFICER', '0'),
('21', 'STORE INCHARGE', '0'),
('22', 'RO-PLANT OPERATOR', '0'),
('23', 'ADMIN OFFICER', '0'),
('24', 'BOILER OPERATOR', '0');

### Structure of table `0_kv_empl_designation_group` ###

DROP TABLE IF EXISTS `0_kv_empl_designation_group`;

CREATE TABLE `0_kv_empl_designation_group` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_designation_group` ###

INSERT INTO `0_kv_empl_designation_group` VALUES
('1', 'Sales And marketing manager', '0'),
('2', 'TRANSPORT', '0'),
('3', 'PLANT', '0'),
('4', 'QC / LAB', '0'),
('5', 'PRINTING', '0'),
('6', 'PURCHASE DPT', '0'),
('7', 'RO-PLANT', '0');

### Structure of table `0_kv_empl_doc_type` ###

DROP TABLE IF EXISTS `0_kv_empl_doc_type`;

CREATE TABLE `0_kv_empl_doc_type` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) NOT NULL DEFAULT '',
  `days` int(4) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_doc_type` ###

INSERT INTO `0_kv_empl_doc_type` VALUES
('1', 'Driver Licence', '10', '0');

### Structure of table `0_kv_empl_emails` ###

DROP TABLE IF EXISTS `0_kv_empl_emails`;

CREATE TABLE `0_kv_empl_emails` (
  `id` int(40) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `empl_name` text COLLATE utf8_unicode_ci NOT NULL,
  `email_to` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `cc` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `subject` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `description` text COLLATE utf8_unicode_ci NOT NULL,
  `send_info` int(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_emails` ###

INSERT INTO `0_kv_empl_emails` VALUES
('1', '137', 'hariskumar', 'jothics8@gmail.com2', '', '', '&lt;br&gt;', '1');

### Structure of table `0_kv_empl_employment_types` ###

DROP TABLE IF EXISTS `0_kv_empl_employment_types`;

CREATE TABLE `0_kv_empl_employment_types` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_employment_types` ###

INSERT INTO `0_kv_empl_employment_types` VALUES
('1', 'Permanent', '0'),
('2', 'Temporary', '0'),
('3', 'Contract Labout', '0');

### Structure of table `0_kv_empl_esb` ###

DROP TABLE IF EXISTS `0_kv_empl_esb`;

CREATE TABLE `0_kv_empl_esb` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `empl_id` int(10) NOT NULL,
  `last_gross` double NOT NULL,
  `date` date NOT NULL,
  `days_worked` decimal(20,2) NOT NULL,
  `status` int(2) NOT NULL,
  `loan_amount` double NOT NULL,
  `amount` double NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_esb` ###


### Structure of table `0_kv_empl_esic_pf` ###

DROP TABLE IF EXISTS `0_kv_empl_esic_pf`;

CREATE TABLE `0_kv_empl_esic_pf` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `allowance_id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `amt_limit` double NOT NULL,
  `date` date NOT NULL,
  `employer` double DEFAULT NULL,
  `company` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_esic_pf` ###


### Structure of table `0_kv_empl_experience` ###

DROP TABLE IF EXISTS `0_kv_empl_experience`;

CREATE TABLE `0_kv_empl_experience` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(10) NOT NULL,
  `company_name` varchar(260) NOT NULL,
  `company_location` varchar(160) NOT NULL,
  `department` varchar(150) NOT NULL,
  `designation` varchar(150) NOT NULL,
  `s_date` date NOT NULL,
  `e_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_experience` ###

INSERT INTO `0_kv_empl_experience` VALUES
('1', '139', 'digitleysystem', 'Cap Station', 'DISPATCH DPT', 'Loader', '0000-00-00', '2022-09-26'),
('2', '64', 'digitleysystem', 'Cap Station', 'DISPATCH DPT', 'Loader', '0000-00-00', '2022-10-03'),
('3', '75', 'digitleysystem', 'Cap Station', 'DISPATCH DPT', 'Loader', '0000-00-00', '2022-10-03');

### Structure of table `0_kv_empl_family` ###

DROP TABLE IF EXISTS `0_kv_empl_family`;

CREATE TABLE `0_kv_empl_family` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(10) NOT NULL,
  `full_name` varchar(160) NOT NULL,
  `relation` int(11) NOT NULL,
  `filename` varchar(600) NOT NULL,
  `filesize` int(11) NOT NULL DEFAULT 0,
  `filetype` varchar(60) NOT NULL DEFAULT '',
  `unique_name` varchar(60) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_family` ###


### Structure of table `0_kv_empl_gazetted_holidays` ###

DROP TABLE IF EXISTS `0_kv_empl_gazetted_holidays`;

CREATE TABLE `0_kv_empl_gazetted_holidays` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `year` int(5) NOT NULL,
  `date` date NOT NULL,
  `reason` text COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_gazetted_holidays` ###

INSERT INTO `0_kv_empl_gazetted_holidays` VALUES
('1', '3', '2022-02-05', 'Kashmir Day', '0'),
('2', '3', '2022-03-23', 'Pakistan Day', '0'),
('3', '3', '2022-05-01', 'Labour Day', '0'),
('4', '3', '2022-05-03', 'Eid ul Fitr Holiday ', '0'),
('5', '3', '2022-05-04', 'Eid ul Fitr Holiday ', '0'),
('6', '3', '2022-05-05', 'Eid ul Fitr Holiday ', '0'),
('7', '3', '2022-07-10', 'Eid Ul Adha Holiday', '0'),
('8', '3', '2022-07-11', 'Eid Ul Adha Holiday', '0'),
('9', '3', '2022-08-14', 'Independence Day', '0'),
('10', '3', '2022-10-09', 'Mild un Nabi', '0'),
('11', '3', '2022-12-25', 'Christmas Day', '0'),
('12', '3', '2022-08-09', '9 muharam', '0'),
('13', '3', '2022-09-08', 'holidy', '0'),
('14', '3', '2022-10-08', 'holiday ', '0');

### Structure of table `0_kv_empl_gosi_settings` ###

DROP TABLE IF EXISTS `0_kv_empl_gosi_settings`;

CREATE TABLE `0_kv_empl_gosi_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nationality` int(5) NOT NULL,
  `employer` double NOT NULL,
  `employee` double NOT NULL,
  `allowances` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_gosi_settings` ###

INSERT INTO `0_kv_empl_gosi_settings` VALUES
('1', '1', '13', '6', 'YToyOntpOjA7czoxOiIxIjtpOjE7czoyOiIyNyI7fQ=='),
('2', '0', '3', '1', 'YToxOntpOjA7czoxOiIxIjt9');

### Structure of table `0_kv_empl_grade` ###

DROP TABLE IF EXISTS `0_kv_empl_grade`;

CREATE TABLE `0_kv_empl_grade` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `min_salary` int(20) NOT NULL,
  `max_salary` int(20) NOT NULL,
  `al` double NOT NULL,
  `sl` double NOT NULL,
  `ml` double NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_grade` ###

INSERT INTO `0_kv_empl_grade` VALUES
('1', 'Grade A', '720000', '840000', '24', '24', '60', '0'),
('2', 'Grade B', '900000', '1200000', '36', '36', '72', '0'),
('3', 'Grade C', '1500000', '1800000', '36', '36', '72', '0'),
('4', 'Default Grade', '10000', '1000000', '12', '12', '12', '0');

### Structure of table `0_kv_empl_history` ###

DROP TABLE IF EXISTS `0_kv_empl_history`;

CREATE TABLE `0_kv_empl_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `option_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `option_value` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `last_change` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_history` ###


### Structure of table `0_kv_empl_info` ###

DROP TABLE IF EXISTS `0_kv_empl_info`;

CREATE TABLE `0_kv_empl_info` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT 0,
  `empl_salutation` varchar(9) COLLATE utf8_unicode_ci NOT NULL,
  `empl_firstname` varchar(120) COLLATE utf8_unicode_ci NOT NULL,
  `empl_lastname` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `addr_line1` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `addr_line2` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `address2` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `empl_city` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `empl_state` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `country` int(5) NOT NULL,
  `gender` int(2) NOT NULL,
  `date_of_birth` date NOT NULL,
  `marital_status` int(2) NOT NULL,
  `home_phone` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `mobile_phone` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `email` varchar(120) COLLATE utf8_unicode_ci NOT NULL,
  `status` int(2) NOT NULL,
  `date_of_status_change` date NOT NULL DEFAULT '0000-00-00',
  `reason_status_change` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `empl_pic` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `report_to` varchar(11) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supervisor` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `ice_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `ice_phone_no` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `n_period` date NOT NULL DEFAULT '0000-00-00',
  `p_period` date NOT NULL DEFAULT '0000-00-00',
  `cmy_period` date NOT NULL DEFAULT '0000-00-00',
  `notes` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `salary_payable_account` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=157 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_info` ###

INSERT INTO `0_kv_empl_info` VALUES
('39', '1', '0', '1', 'SAIF-UR-REHMAN', '', 'HOUSE # R-447, BLOCK-B, SAIMA ARABIAN VILLAS.    ', '', 'HOUSE # R-447, BLOCK-B, SAIMA ARABIAN VILLAS.    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '1', '', '0333 0254101', '', '1', '0000-00-01', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('40', '2', '0', '1', 'NOMAN INAM', '', 'HOUSE # L-826, SECTOR 5-D, SURJANI TOWN, KARACHI  KARACHI  ', '', 'HOUSE # L-826, SECTOR 5-D, SURJANI TOWN, KARACHI    ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '1', '', '0300 3029093', '', '1', '0000-00-02', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('41', '3', '0', '1', 'MUHAMMAD WAQAS', '', 'HOUSE # 1384, BLOCK-3, FB AREA KARACHI    ', '', 'HOUSE # 1384, BLOCK-3, FB AREA KARACHI    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '2', '', '0322 2548299', '', '1', '0000-00-03', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('42', '4', '0', '1', 'MUHAMMAD YOUNUS KARAR', '', 'GAWALIAR SOCIETY,  FLAT # CM 58, SECTOR 17-A, SCHEME 33, KARACHI    ', '', 'GAWALIAR SOCIETY,  FLAT # CM 58, SECTOR 17-A, SCHEME 33, KARACHI    ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '1', '', '0321 2435795', '', '1', '0000-00-04', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('43', '5', '0', '1', 'MUHAMMAD WASEEM', '', 'HOUSE # 3/599, MOHALLAH LIAQUATABAD, KARACHI    ', '', 'HOUSE # 3/599, MOHALLAH LIAQUATABAD, KARACHI    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '2', '', '0300 2363918', '', '1', '0000-00-05', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('44', '6', '0', '1', 'KASHIF KHAN', '', 'HOUSE # R-73, SECTOR, 5-D SURJANI TOWN    ', '', 'HOUSE # R-73, SECTOR, 5-D SURJANI TOWN    ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '2', '', '0300 2453961', '', '1', '0000-00-06', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('45', '7', '0', '1', 'MUHAMMAD RIZWAN ', '', 'FLAT # 305, 3RD FLOOR, CMA COMPLEX SECTOR 5-E, NORTH KARACHI    ', '', 'FLAT # 305, 3RD FLOOR, CMA COMPLEX SECTOR 5-E, NORTH KARACHI    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '2', '', '0312 2493559', '', '1', '0000-00-07', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('46', '8', '0', '1', 'MUHAMMAD ZAIN', '', 'KACHARH SHAHIJAH DAKKHANA KOHAT KOHAT     ', '', 'KACHARH SHAHIJAH DAKKHANA KOHAT KOHAT     ', 'Kohat', 'sindh', '177', '1', '0000-00-00', '2', '', '0336-6644679', '', '1', '0000-00-08', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('47', '10', '0', '1', 'FAISAL AHMED HUSSAIN', '', 'HOUSE # 11, BLOCK # 2, SECTOR , 11-F NEW     ', '', 'HOUSE # 11, BLOCK # 2, SECTOR , 11-F NEW     ', 'Karachi', 'Sindh', '177', '1', '2002-10-01', '2', '', '0322 8182574', '', '2', '2022-10-31', NULL, '', '', '', 'ooooo', '0000000000000', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('48', '11', '0', '1', 'MUHAMMAD ASIM KHAN', '', 'HOUSE # L-2018, SECTOR 11-E , NORTH KARACHI    ', '', 'HOUSE # L-2018, SECTOR 11-E , NORTH KARACHI    ', 'Karachi', 'sindh', '177', '1', '2002-10-01', '1', '', '0346 3311199', '', '2', '2022-10-31', NULL, '', '', '', 'ooooooooooooooooo', '6666666666', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('49', '12', '0', '1', 'GHULAM HAIDER  ALI', '', 'HOUSE # L-588 , SECTOR 11-L, NORTH KARACHI    ', '', 'HOUSE # L-588 , SECTOR 11-L, NORTH KARACHI    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '1', '', '0312 2690875', '', '1', '0000-00-11', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('50', '13', '0', '1', 'MUHAMMAD ZUBAIR SAGHEER', '', 'FLAT # K-40, K.D.A FLATS, SECTOR 5-E , SURJANI TOWN    ', '', 'FLAT # K-40, K.D.A FLATS, SECTOR 5-E , SURJANI TOWN    ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '1', '', '0315-2311343', '', '1', '0000-00-12', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('51', '14', '0', '1', 'MUHAMMAD JAWAID ', '', 'HOUSE # 131/5  SECTOR, 11-D NEW KARACHI     ', '', 'HOUSE # 131/5  SECTOR, 11-D NEW KARACHI     ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '1', '', '0312 3691696', '', '1', '0000-00-13', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('52', '15', '0', '1', 'MUHAMMAD FAROOQ', '', 'HOUSE # B-127, BLOCK 10, F.B AREA, KARACHI    ', '', 'HOUSE # B-127, BLOCK 10, F.B AREA, KARACHI    ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '1', '', '0330 9222270', '', '1', '0000-00-14', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('53', '16', '0', '1', 'SYED MUHAMMAD NABEEL UDDIN', '', 'HOUSE # 1-A -112 ETAWAH HOUSING SOCIETY    ', '', 'HOUSE # 1-A -112 ETAWAH HOUSING SOCIETY    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '1', '', '0332 2418856', '', '1', '0000-00-15', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('54', '17', '0', '1', 'JAMEEL AKHTAR', '', 'HOUSE # 1157 ORANGI TOWN SECTOR 12-L    ', '', 'HOUSE # 1157 ORANGI TOWN SECTOR 12-L    ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '1', '', '0312 2475561', '', '1', '0000-00-16', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('55', '18', '0', '1', 'SHAKEEL AHMED', '', 'HOUSE # 131/5 , NEW KARACHI SECTOR 11-D    ', '', 'HOUSE # 131/5 , NEW KARACHI SECTOR 11-D    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '1', '', '0333 2220623', '', '1', '0000-00-17', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('56', '20', '0', '1', 'AHSANULLAH', '', 'WANDA MAKHAN DAK KHANA SIRAI NORANG, TEHSIL ZILA LUCKY MURAWAT', '', 'WANDA MAKHAN DAK KHANA SIRAI NORANG, TEHSIL ZILA LUCKY MURAWAT', 'Karachi', 'sindh', '177', '1', '0000-00-00', '1', '', '0336 2051635', '', '1', '0000-00-18', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('57', '21', '0', '1', 'FARRUK MUNIR ', '', 'JAMEEL JOHAR WALI HASIL PUR, PURANA TEHSIL HASIL PUR,ZILA BHAWALPUR  BHAWALPUR  ', '', 'JAMEEL JOHAR WALI HASIL PUR, PURANA TEHSIL HASIL PUR,ZILA BHAWALPUR  BHAWALPUR  ', 'Bhawalpur', 'Sindh', '177', '1', '0000-00-00', '1', '', '0313 9911914', '', '1', '0000-00-19', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('58', '22', '0', '1', 'ASIF ALI ', '', 'HOUSE # 201 SIRAJ COLONY NAZIMABAD KARACHI    ', '', 'HOUSE # 201 SIRAJ COLONY NAZIMABAD KARACHI    ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '1', '', '0341 2131424', '', '1', '0000-00-20', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('59', '23', '0', '1', 'SOHAIL AHMED LAGHARI ', '', 'RALLWAY DAKKHANA ZILA SIAIKOT    ', '', 'RALLWAY DAKKHANA ZILA SIAIKOT    ', 'Sialkot', 'Sindh', '177', '1', '0000-00-00', '1', '', '0341 2131424', '', '1', '0000-00-21', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('60', '25', '0', '1', 'GULZAR ALI PANHOR', '', 'ZILA DADO', '', 'ZILA DADO', 'Bhawalpur', 'sindh', '177', '1', '0000-00-00', '1', '', '0308-4565070', '', '1', '0000-00-22', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('61', '28', '0', '1', 'GHULAM MURTAZA TABASSUM', '', 'YOUSUF KHAN SAHIB GOYH HOUSE NO 311, BLOCK C MOHALIA GADAP TOWN CITY MALIR    ', '', 'YOUSUF KHAN SAHIB GOYH HOUSE NO 311, BLOCK C MOHALIA GADAP TOWN CITY MALIR    ', 'Bhawalpur', 'Sindh', '177', '1', '0000-00-00', '1', '', '0308-4565070', '', '1', '0000-00-23', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('62', '29', '0', '1', 'NAWAB JAN', '', 'SAKATHAL KARAM KHAN SHAIR DAK KHANA    ', '', 'SAKATHAL KARAM KHAN SHAIR DAK KHANA    ', 'Karachi', 'sindh', '177', '1', '2002-10-01', '1', '', '0300-3223120', '', '2', '2022-10-31', NULL, '', '', '', 'plplplplpl', '1212121222', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('63', '30', '0', '1', 'ZUBAIR AZHAR', '', 'SAKATHAL KARAM KHAN SHAIR DAK KHANA    ', '', 'GOTH NOOR MUHAMMAD MINGAL DAKKHANA GADAP TOWN KARACHI    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '1', '', '0333-2613742', '', '1', '0000-00-25', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('64', '31', '0', '1', 'HAMZA ALI', '', 'GOTH NOOR MUHAMMAD MINGAL DAKKHANA GADAP TOWN KARACHI    ', '', 'GOTH NOOR MUHAMMAD MINGAL DAKKHANA GADAP TOWN KARACHI    ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '1', '', '0331-2553740', '', '1', '0000-00-26', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('65', '32', '0', '1', 'ABDUL QAYYUM', '', 'GOTH KHARAM KAMAL DAIRA DAK KHANA    ', '', 'GOTH KHARAM KAMAL DAIRA DAK KHANA    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '1', '', '0305-2863532', '', '1', '0000-00-27', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('66', '35', '0', '1', 'MUHAMMAD ASLAM', '', 'GOTH HAJI RAZA MUHAMMAD HAIDER PUR JACOBAD    ', '', 'GOTH HAJI RAZA MUHAMMAD HAIDER PUR JACOBAD    ', 'Jacobabad', 'sindh', '177', '1', '0000-00-00', '1', '', '0302-0241986', '', '1', '0000-00-28', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('67', '38', '0', '1', 'SHANI NIAZ', '', 'GOTH HAJI RAZA MUHAMMAD HAIDER PUR JACOBAD    ', '', 'GOTH HAJI RAZA MUHAMMAD HAIDER PUR JACOBAD    ', 'Jacobabad', 'Sindh', '177', '1', '0000-00-00', '1', '', '0305-8141743', '', '1', '0000-00-29', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('68', '39', '0', '1', 'RIZWAN JAMSHED', '', 'HOUSE # L-32 SECTOR # 36 AREA EXPRESSWAY    ', '', 'HOUSE # L-32 SECTOR # 36 AREA EXPRESSWAY    ', 'Karachi', 'sindh', '177', '1', '2002-10-01', '1', '', '0312-1105243', '', '2', '2022-10-31', NULL, '', '', '', 'iuiuiu', '5555555555', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('69', '40', '0', '1', 'MUHAMMAD SHOAIB', '', 'TERHI POST OFFICE KOHAT    ', '', 'TERHI POST OFFICE KOHAT    ', 'Kohat', 'Sindh', '177', '1', '2002-10-01', '1', '', '0342-1210955', '', '2', '2022-10-31', NULL, '', '', '', 'nnnnnnnnn', '21212121', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('70', '42', '0', '1', 'MUHAMMAD YOUSUF', '', 'DALU GOTH SURJANI TOWN KARACHI    ', '', 'DALU GOTH SURJANI TOWN KARACHI    ', 'Karachi', 'sindh', '177', '1', '2002-10-01', '1', '', '3015-8364738', '', '2', '2022-10-31', NULL, '', '', '', 'kkkkkkkk', '6666666666', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('71', '43', '0', '1', 'MUHAMMAD PANNA', '', 'GOTH DARGHAPI DAKKHANA BAHO KHOSO TAJU KHOSO THAL JECOABAD    ', '', 'GOTH DARGHAPI DAKKHANA BAHO KHOSO TAJU KHOSO THAL JECOABAD    ', 'Jacobabad', 'Sindh', '177', '1', '0000-00-00', '1', '', '0305-8141743', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('72', '45', '0', '1', 'ZULFIQAR', '', 'QUAID SHAKH ALLAH DAAD DAK KHANA JAFRABAD    ', '', 'QUAID SHAKH ALLAH DAAD DAK KHANA JAFRABAD    ', 'Karachi', 'sindh', '177', '1', '2002-10-01', '1', '', '0307-2981771', '', '2', '2022-10-31', NULL, '', '', '', 'lkkkkkkkkkk', '5555555', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('73', '46', '0', '1', 'ABDUL REHMAN', '', 'SIKENDER ABAD TAPAL GHAR JACOBABAD    ', '', 'SIKENDER ABAD TAPAL GHAR JACOBABAD    ', 'Jacobabad', 'Sindh', '177', '1', '0000-00-00', '1', '', '0323-3215717', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('74', '47', '0', '1', 'MUHAMMAD ZAFAR LOADER', '', 'GOAT SIKANDER ABAD DAK KHANA THAL ZELA JACOABAD    ', '', 'GOAT SIKANDER ABAD DAK KHANA THAL ZELA JACOABAD    ', 'Jacobabad', 'sindh', '177', '1', '2002-10-01', '1', '', '0303-2707943', '', '1', '2022-10-31', NULL, '', '', '', 'lkkkkkkkkkk', '55555555555', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('75', '48', '0', '1', 'NAZEER JAN', '', 'Nai Haveli Sahiwal Zila Sargodha    ', '', 'Nai Haveli Sahiwal Zila Sargodha    ', 'Sargodha', 'Sindh', '177', '1', '2002-10-01', '1', '', '0308-2022156', '', '2', '2022-10-31', NULL, '', '', '', 'fggfggg', '21212', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('76', '49', '0', '1', 'SHAMSHAD IMTIAZ AHMED ANSARI', '', 'ZILA JACOBABAD    ', '', 'ZILA JACOBABAD    ', 'Jacobabad', 'sindh', '177', '1', '2002-10-01', '1', '', '0300-4363697', '', '2', '2022-10-31', NULL, '', '', '', 'mmmmmmmmmm', '121212121', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('77', '50', '0', '1', 'GHULAM MUSTAFA ZAHOOR AHMED', '', 'NAI HAVELI SAHIWAL ZILA SARGODA    ', '', 'NAI HAVELI SAHIWAL ZILA SARGODA    ', 'Sargodha', 'Sindh', '177', '1', '2002-10-01', '1', '', '0300-9739282', '', '2', '2022-10-31', NULL, '', '', '', 'hhhhhhh', '12123156', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('78', '51', '0', '1', 'SAJID ALI', '', 'NOCKAB TAHSEEL BHAWAL DISTRICT SARGHODA    ', '', 'NOCKAB TAHSEEL BHAWAL DISTRICT SARGHODA    ', 'Sargodha', 'sindh', '177', '1', '0000-00-00', '2', '', '0302-4677116', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('79', '53', '0', '1', 'NAJAF WAZIR HUSSAIN', '', 'HOUSE NO # L-39 AREA KAISER TOWN SECTOR 36-J    ', '', 'HOUSE NO # L-39 AREA KAISER TOWN SECTOR 36-J    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '2', '', '0312-8599053', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('80', '54', '0', '1', 'FAISAL GHULAM NABI', '', 'PHASE 1 SINDH GOVT FLAT NORTH NAZIMABAD FLAT NO H-5 SECTOR 14-B AREA SHADMAN TOWN 2     ', '', 'PHASE 1 SINDH GOVT FLAT NORTH NAZIMABAD FLAT NO H-5 SECTOR 14-B AREA SHADMAN TOWN 2     ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '2', '', '0310-2995374', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('81', '55', '0', '1', 'ANIS GHULAM NABI', '', 'HOUSE NO# 303 AREA AHSANBAD SCHEME # 33 SECTOR# 3 KARACHI    ', '', 'HOUSE NO# 303 AREA AHSANBAD SCHEME # 33 SECTOR# 3 KARACHI    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '2', '', '0308-2962518', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('82', '56', '0', '1', 'SADDAM GHULAM NABI', '', 'HOUSE NO# 303 AREA AHSANBAD SCHEME # 33 SECTOR# 3 KARACHI    ', '', 'HOUSE NO# 303 AREA AHSANBAD SCHEME # 33 SECTOR# 3 KARACHI    ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '2', '', '0308-2962518', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('83', '57', '0', '1', 'ASWAN ZAFFARULLAH KHAN', '', 'HOUSE NO #698-A, KESC AREA MUSLIM COLONY GULSHAN-E-IQBAL KARACHI    ', '', 'HOUSE NO #698-A, KESC AREA MUSLIM COLONY GULSHAN-E-IQBAL KARACHI    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '2', '', '0345-2015601', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('84', '58', '0', '1', 'NIAZ MUHAMMAD NOOR', '', 'HARKHO PUTTO GOATH AHMED KHAN JATOL, ZILA DADU    ', '', 'HARKHO PUTTO GOATH AHMED KHAN JATOL, ZILA DADU    ', 'Zila dadu', 'sindh', '177', '1', '0000-00-00', '2', '', '0302-3483809', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('85', '60', '0', '1', 'AFNAN JAMSHED ', '', 'SECTOR 36-J MOHALLA LAYARI EXPRESS WAY KARACHI    ', '', 'SECTOR 36-J MOHALLA LAYARI EXPRESS WAY KARACHI    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '2', '', '0342-1210955', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('86', '61', '0', '1', 'RAHIM DADA', '', 'GOAT PALYO KHAN GOPANG TANASLL    ', '', 'GOAT PALYO KHAN GOPANG TANASLL    ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '2', '', '0316-3327174', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('87', '63', '0', '1', 'RAZZAK P', '', 'HOUSE NO # L-39 AREA KAISER TOWN SECTOR 36-J    ', '', 'HOUSE NO # L-39 AREA KAISER TOWN SECTOR 36-J    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '2', '', '0312-8599053', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('88', '64', '0', '1', 'FEROZE SOHNA', '', 'CHAK PEER WALA DAKHANA MUHAMMAD PUR TEHSIL JAMPUR ZILA RAJANPUR    ', '', 'CHAK PEER WALA DAKHANA MUHAMMAD PUR TEHSIL JAMPUR ZILA RAJANPUR    ', 'Rajanpur', 'sindh', '177', '1', '0000-00-00', '2', '', '0345-6072875', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('89', '65', '0', '1', 'ASIF MILLAH PANNO', '', 'MUSLIM TOWN KOTRI ZILA JAMSHORO    ', '', 'MUSLIM TOWN KOTRI ZILA JAMSHORO    ', 'Jamshoro', 'Sindh', '177', '1', '0000-00-00', '2', '', '0307-3058886', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('90', '67', '0', '1', 'JUNIAD NOOR MUHMMAD', '', 'HOUSE NO# Q-65 SECTOR 33-A KORANGI # 2 KARACHI DAKHANA KORANGI TEHSIL ZILA KARACHI    ', '', 'HOUSE NO# Q-65 SECTOR 33-A KORANGI # 2 KARACHI DAKHANA KORANGI TEHSIL ZILA KARACHI    ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '2', '', '0323-2451763', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('91', '68', '0', '1', 'SULEMAN WALI GUL', '', 'GOAT HAJI RAZA MUHAMMAD DAKHANA    ', '', 'GOAT HAJI RAZA MUHAMMAD DAKHANA    ', 'Dakhana', 'Sindh', '177', '1', '0000-00-00', '2', '', '0302-0241986', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('92', '69', '0', '1', 'RASHID NAZEER AHMED', '', 'HOUSE # L-479, MAIMARABAD, SURJANI TOWN, KARACHI    ', '', 'HOUSE # L-479, MAIMARABAD, SURJANI TOWN, KARACHI    ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '2', '', '0336-8525610', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('93', '70', '0', '1', 'ALLAH DITA ALI MARDAN', '', 'KHUDA KI BASTI, MEHALLA KHAIR MUHAMMAD GOATH, NEW KARACHI    ', '', 'KHUDA KI BASTI, MEHALLA KHAIR MUHAMMAD GOATH, NEW KARACHI    ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '2', '', '0330-2765967', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('94', '73', '0', '1', 'TALHA MUHAMMAD HAMEED', '', 'HOUSE NO# 77/19 SECTOR 5C, NEW KARACHI, KARACHI    ', '', 'HOUSE NO# 77/19 SECTOR 5C, NEW KARACHI, KARACHI    ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '2', '', '0311-2846590', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('95', '74', '0', '1', 'DIN MUHAMMAD GHULAM ', '', 'ZELA JACOBABAD    ', '', 'ZELA JACOBABAD    ', 'Jacobabad', 'Sindh', '177', '1', '0000-00-00', '2', '', '0306-2428445', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('96', '75', '0', '1', 'AHSAN ALI', '', 'JAMALANI MEHALA KETARI, ZILA THARPARKAR    ', '', 'JAMALANI MEHALA KETARI, ZILA THARPARKAR    ', 'Tharparkar', 'sindh', '177', '1', '2002-10-03', '2', '', '0344-3064559', 'XXXXXXXXXXX', '1', '0000-00-00', NULL, '', '', '', 'MAMO', '03012582065', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('97', '76', '0', '1', 'RAFIQUE AHMED', '', 'GOTH ALLAH DAAD, DAKHANA, DERAN ALLAH YAR, JAFFARABAD    ', '', 'GOTH ALLAH DAAD, DAKHANA, DERAN ALLAH YAR, JAFFARABAD    ', 'Jaffarabad', 'Sindh', '177', '1', '0000-00-00', '2', '', '0302-0240416', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('98', '79', '0', '1', 'KAMRAN WAHEED', '', 'HOUSE # 762, SECTOR 5-L, GULSHAN-E-RIZWAN, NORTH KARACHI, KARACHI    ', '', 'HOUSE # 762, SECTOR 5-L, GULSHAN-E-RIZWAN, NORTH KARACHI, KARACHI    ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '2', '', '0324-2464934', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('99', '80', '0', '1', 'RAZA ALI', '', 'FAQIRA GOTH BLOCK B, MOHALLAH YOUSUF SAHIB KHAN GOTH    ', '', 'Nazd Bismillah Bagh Mahella Channah Jacobabad    ', 'Jacobabad', 'Sindh', '177', '1', '0000-00-00', '2', '', '3158988386', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('100', '82', '0', '1', 'MOHSIN MUHAMMAD OWAIS', '', 'DAK KHANA FATEHPUR    ', '', 'Dak Khana Khas Coat Mubarak Junubi Deira Ghazi Khani  Karachi  ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '2', '', '3408242361', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('101', '83', '0', '1', 'MUSHTAQ ALLAH DITA', '', 'YOUSUF SHAB KHAN GOTH AREA MUHAMMAD SIDDIQ MALIR  KARACHI  ', '', 'Shaheed Murad Colony Area Daira Allah Yar Jaffarabad    ', 'Jaffarabad', 'Sindh', '177', '1', '0000-00-00', '2', '', '3368061060', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('102', '85', '0', '1', 'TAHIR TARIQ', '', 'Homaiyun Dakhana Tehseel Shikarpur    ', '', 'R 347 block b saima arabian villas karachi  karachi  ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '2', '', '3412207501', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('103', '87', '0', '1', 'Javed Ali', '', '  Karachi  ', '', 'Yousuf Sahab Khan Goth Gulshan-e-maymar Gadap Town  Karachi  ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '2', '', '3222998392', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('104', '88', '0', '1', 'MUHAMMAD ABID', '', 'Shaheed Murad Colony Area Daira Allah Yar Jaffarabad  Karachi  ', '', 'House# 403, Area National IT Park Caesar Tower Shahrah-e-Faisal  Karachi  ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '2', '', '3082870857', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('105', '89', '0', '1', 'LAL BAKSH GOPANG', '', 'R 347 block b saima arabian villas karachi    ', '', 'House# A-520 Block # H North Nazimbad Karachi  Karachi  ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '2', '', '3162677522', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('106', '90', '0', '1', 'AURANZAIB NAZAR', '', 'Yousuf Sahab Khan Goth Gulshan-e-maymar Gadap Town    ', '', 'House no# L-175 Area Lyari Basti Taiser Town 36-J  Karachi  ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '2', '', '3242382834', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('107', '92', '0', '1', 'Nawab ghulam Rasool', '', 'House# 403, Area National IT Park Caesar Tower Shahrah-e-Faisal  Karachi  ', '', 'House no# 348, Area Gharibabad Khokhar Par  Karachi  ', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '1', '', '3323430581', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('108', '99', '0', '1', 'Muhammad Ishaq', '', 'House# A-520 Block # H North Nazimbad Karachi    ', '', 'House no# 240, Street #9, Scheme #33, Gadap Town    ', 'Town', 'sindh', '177', '1', '0000-00-00', '1', '', '3482948483', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('109', '100', '0', '1', 'Mashooq Ahmed', '', 'House no# L-175 Area Lyari Basti Taiser Town 36-J  Karachi  ', '', 'Greece Dakhana kholo district kholo    ', 'Kholo', 'Sindh', '177', '1', '0000-00-00', '1', '', '3355526872', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('110', '103', '0', '1', 'Hamza ur Rehman', '', 'House no# 348, Area Gharibabad Khokhar Par  Karachi  ', '', 'Zangi Kila Dak Khana Zila hango    ', 'Hango', 'sindh', '177', '1', '0000-00-00', '1', '', '3082870089', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('111', '105', '0', '1', 'Rehmatullah', '', '', '', 'Flat no U-188 Block #9 Area Lal shahbaz Nagar Area    ', 'Area', 'Sindh', '177', '1', '0000-00-00', '1', '', '3162101140', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('112', '107', '0', '1', 'Sajjad Ali', '', '', '', 'Tehsil Sinjhoro Zila Sanghar  Sanghar  ', 'Sanghar', 'sindh', '177', '1', '0000-00-00', '1', '', '3322972354', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('113', '109', '0', '1', 'Syed Muhammad Ali Rizvi', '', '', '', 'Zila Kohat    ', 'Kohat', 'Sindh', '177', '1', '0000-00-00', '1', '', '', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('114', '111', '0', '1', 'Muhammad Khalid', '', '', '', '55-A, Alamgir Housing Society, Model Colony, Karachi  karachi  ', 'Karachi', 'sindh', '177', '1', '0000-00-00', '1', '', '', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('115', '112', '0', '1', 'Muhammad Jameel', '', '', '', '', '', 'Sindh', '177', '1', '0000-00-00', '1', '', '', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('116', '114', '0', '1', 'Ataullah', '', '', '', '', '', 'sindh', '177', '1', '0000-00-00', '1', '', '', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('117', '115', '0', '1', 'Noman Ali', '', '', '', '', '', 'Sindh', '177', '1', '0000-00-00', '1', '', '', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('118', '116', '0', '1', 'Nisar Jan', '', '', '', '', '', 'sindh', '177', '1', '0000-00-00', '1', '', '', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('119', '117', '0', '1', 'Ismail Khan', '', '', '', '', '', 'Sindh', '177', '1', '0000-00-00', '1', '', '', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('120', '118', '0', '1', 'Abdul Saboor', '', '', '', '', '', 'sindh', '177', '1', '0000-00-00', '1', '', '', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('121', '119', '0', '1', 'Ejaz', '', '', '', '', '', 'Sindh', '177', '1', '0000-00-00', '1', '', '', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('122', '120', '0', '1', 'Sanaullah', '', '', '', '', '', 'sindh', '177', '1', '0000-00-00', '1', '', '', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('123', '121', '0', '1', 'Farooq Ahmed', '', 'Kot Ahmed Khan Jatoi Tapal ghar Zila Dadu', '', 'Kot Ahmed Khan Jatoi Tapal ghar Zila Dadu', 'Dadu', 'Sindh', '177', '1', '0000-00-00', '1', '', '3069740452', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('124', '124', '0', '1', 'Syed Zubair Jilani', '', '', '', '', '', 'sindh', '177', '1', '0000-00-00', '2', '', '', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('125', '127', '0', '1', 'Nadeem Ahmed', '', 'Kapro Dak Khana District Jacobad, Sindh , Pakistan ', '', 'Kapro Dak Khana District Jacobad, Sindh , Pakistan ', 'Jacobabad', 'Sindh', '177', '1', '0000-00-00', '2', '', '3182762459', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('126', '128', '0', '1', 'Shakeel Sarfaraz', '', '30/7, 5-D New Karachi', '', '30/7, 5-D New Karachi', 'Karachi', 'sindh', '177', '1', '0000-00-00', '2', '', '3333518155', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('127', '130', '0', '1', 'Tariq Jatoi', '', 'Gulshan-ul-haram Burohi village, Gulshan-e-maymar, karachi', '', 'Gulshan-ul-haram Burohi village, Gulshan-e-maymar, karachi', 'Karachi', 'Sindh', '177', '1', '0000-00-00', '2', '', '30137393389', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('128', '131', '0', '1', 'Khalid Ali', '', 'Sanghar Jamnawaz Ali', '', 'Sanghar Jamnawaz Ali', 'Karachi', 'sindh', '177', '1', '0000-00-00', '1', '', '', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('129', '132', '0', '1', 'Shahnawaz', '', 'Goat Sikander Khan, Jacobabad', '', 'Goat Sikander Khan, Jacobabad', 'Karachi', 'Sindh', '177', '1', '2002-09-27', '2', '', '3022091807', '', '2', '2022-09-30', NULL, '', '', '', 'NO', '0000000000', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('130', '133', '0', '1', 'Bilawal Khan', '', 'Ward No 4 Mohalah Lango Dera Murad Jamali Zila Naseer Abad', '', 'Ward No 4 Mohalah Lango Dera Murad Jamali Zila Naseer Abad', 'Jacobabad', 'sindh', '177', '1', '0000-00-00', '1', '', '3083178987', '', '1', '0000-00-00', NULL, '', '', '', '', '', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('131', '134', '0', '1', 'Basheer Ahmed', '', 'House No# 825 Gani Abad Goth', '', 'House No# 825 Gani Abad Goth', 'Karachi', 'Sindh', '177', '1', '2002-09-27', '1', '', '3157392187', '', '2', '2022-09-30', NULL, '', '', '', 'sa', '000000000000', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('132', '134', '0', '1', 'Basheer Ahmed', '', 'House No# 825 Gani Abad Goth', '', 'House No# 825 Gani Abad Goth', 'Karachi', 'Sindh', '177', '1', '2002-09-27', '1', '', '3157392187', '', '2', '2022-09-30', NULL, '', '', '', 'sa', '000000000000', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('133', '139', '0', '1', 'SHAHNAWAZ', 'GHULAM HAIDER', 'Goat Sikander Khan, Jacobabad', '', 'Goat Sikander Khan, Jacobabad', 'JACOBABAD', '', '177', '1', '1982-01-01', '2', '', '03022975952', 'ssssssssssssssssss', '1', '0000-00-00', NULL, '', '8', '8', 'brother', '03022091807', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('134', '143', '0', '1', 'BILAWAL KHAN', 'ABDUL MAJEED', 'WARD NO# 4, MOHALLAH LANGO DERA MURAD JAMALI ZILA NASEERABAD ', '', 'WARD NO# 4, MOHALLAH LANGO DERA MURAD JAMALI ZILA NASEERABAD ', 'NASEERABAD', 'SINDH', '177', '1', '2001-01-01', '1', '', '03150366799', '.', '1', '0000-00-00', NULL, '', '21', '21', 'ELDER BROTHER', '03083178987', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('135', '147', '0', '1', 'Basheer Ahmed', 'inayatullah', 'GHANI ABAD GOTH KAREEM SHAH MAZAR HOUSENO 825', '', '', '', 'SINDH', '177', '1', '2003-01-01', '1', '03111769614', '03157392187', 'DDDDDDDDDDDDDDDDD', '1', '0000-00-00', NULL, '', '128', '128', 'NONE', '03157392187', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('136', '148', '0', '1', 'MATTI ', 'JAGSI JAMES', 'HOUSE NO# 612 STREET # 1 KHUDA KI BASTI SURJANI', '', 'HOUSE NO# 612 STREET # 1 KHUDA KI BASTI SURJANI', 'KARACHI', 'SINDH', '177', '1', '1976-03-05', '2', '', '03462287357', 'DDDDDDDDDDD', '1', '0000-00-00', NULL, '', '128', '128', 'NONE', '00000000000', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('137', '151', '0', '1', 'SOHAIL KHALID', 'KHALID MEHMOOD', 'FAQEERA GOTH KABEER CHOCK', '', '', '', 'SINDH', '177', '1', '2003-10-20', '1', '03222253244', '03222253244', 'SSSSSSSSSSS', '1', '0000-00-00', NULL, '', '21', '21', 'FATHER', '03012284671', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('138', '152', '0', '1', 'MUHAMMAD AKRAM', 'MUHAMMAD SALEEM', 'BLOCK 5F- MOHALLAH KHAMISHA GOTH NEW AKARACHI SHEHAR', '', 'BLOCK 5F- MOHALLAH KHAMISHA GOTH NEW AKARACHI SHEHAR', 'KARACHI', 'SINDH', '177', '1', '2002-10-22', '1', '03022316515', '03022316515', 'AAAAAAAAAAA', '1', '0000-00-00', NULL, '', '21', '21', 'NONE', '03022316515', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('139', '160', '0', '1', 'FARHAN AZIZ', 'ABDUL AZIZ', 'R-226, AL-NOOR MUTLIPORPOSES, COOPERATIVE HOUSING SOCIETY SCHEME# 33 , SECTOR 54/A', '', 'R-226, AL-NOOR MUTLIPORPOSES, COOPERATIVE HOUSING SOCIETY SCHEME# 33 , SECTOR 54/A ', 'KARACHI', 'SINDH', '177', '1', '1988-11-19', '2', '03182345186', '03182345186', 'NNNNNN', '1', '0000-00-00', NULL, '', '5', '5', 'BROTHER', '03232035231', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('140', '161', '0', '1', 'QAMMARUDDIN', 'ABDUL RAZZAQ', 'GOTH CHAR KOAH MUBARAK PORAH TEHSIL , ZILA JACOBABAD', '', 'GOTH CHAR KOAH MUBARAK PORAH TEHSIL , ZILA JACOBABAD', 'JACOBABAD', 'SINDH', '177', '1', '1995-01-01', '1', '03172668268', '03172668268', 'NONA', '1', '0000-00-00', NULL, '', '128', '128', 'NONE', '030048691554', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('141', '162', '0', '1', 'SYED WAQAS HUSSAIN', 'SYED SABIR HUSSAIN', 'HOUSE NO# 06, BLOCK 134 5-D NEW KARACHI', '', 'HOUSE NO# 06, BLOCK 134 5-D NEW KARACHI', 'KARACHI', 'SINDH', '177', '1', '1993-11-03', '1', '03120018210', '03120018210', 'ZZZZZZZZZZZZ', '1', '0000-00-00', NULL, '', '18', '18', 'NONE', '03102575138', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('142', '170', '0', '1', 'Rasol Baksh', 'Chakar', 'Goat Raees, Ali Barho, Dak Khana Thal, Jaikabad', '', 'Goat Raees, Ali Barho, Dak Khana Thal, Jaikabad', 'Jaikabad', 'Sindh', '177', '1', '2002-01-01', '1', '03073460681', '03073460681', 'mmmmmmmmmm', '1', '0000-00-00', NULL, '', '128', '128', 'None', '0000000', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('143', '177', '0', '1', 'Usama', 'Hanif', 'Fareed Plaza 7H, Liaquat Colony Hyderabad', '', 'Fareed Plaza 7H, Liaquat Colony Hyderabad', 'Hyderabad', '', '177', '1', '1999-02-17', '1', '030019371250', '030019371250', 'usama@gmail.com', '1', '0000-00-00', NULL, '', '3', '3', 'kkkkk', '99999', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('144', '189', '0', '1', 'WASEEM KHAN', 'MUHAMMAD AZEEM ', 'GHULAM HASSAN GOAT BLOCK A390 GULSHAN - E-MAYMAR', '', 'GHULAM HASSAN GOAT BLOCK A390 GULSHAN - E-MAYMAR', 'KARACHI', 'SINDH', '177', '1', '2004-02-03', '1', '03083421147', '03083421147', 'MMMMMMMMMMMM', '1', '0000-00-00', NULL, '', '8', '8', 'MAMO', '03003154198', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('145', '190', '0', '1', 'NADEEM UMAR', 'UMAR KITTAB', 'AHSANABAD', '', 'AHASANBAD', 'KARACHI', 'SINDH', '177', '1', '1996-09-20', '1', '03142020430', '03142020430', 'ZZZZZZZZZZZZZZZZ', '1', '0000-00-00', NULL, '', '21', '21', 'BROTHER ', '03153913601', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('146', '181', '0', '1', 'Abdul Razzaq', 'Kareem', 'Goat Haji Murad Shord Late Dakh Khana Mirpor', '', 'Goat Haji Murad Shord Late Dakh Khana Mirpor', 'Mirpor', '', '177', '1', '2000-07-01', '1', '03434709188', '03083585743', 'abdulrazaq@gmail.com', '1', '0000-00-00', NULL, '', '128', '128', 'sdfdfds', '032122121122', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('147', '193', '0', '1', 'IMTIAZ ALI', 'ALI MARDAN', 'NONE', 'NONE', '', 'NONE', 'NONE', '177', '1', '1987-01-01', '1', '03020240416', '03020240416', 'NONE', '1', '0000-00-00', NULL, '', '128', '128', 'NONE', '0000000000', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('148', '191', '0', '1', 'AYUB WAHID', 'WAHID BUX', '7 BACK SIDE ALSI GOAT NEW KARACHI', '', '7 BACK SIDE ALSI GOAT NEW KARACHI', 'KARACHI', 'SINDH', '177', '1', '1998-12-19', '1', '03023878818', '03023878818', 'OOOOOOOOOOO', '1', '0000-00-00', NULL, '', '18', '18', 'BROTHER ABID', '03022423062', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('149', '182', '0', '1', 'Bashir', 'Ahmed', 'Scheme-33 Area Yousuf Sahab Khan Goth- Karachi', '', 'Scheme-33 Area Yousuf Sahab Khan Goth- Karachi', 'Karachi', '', '177', '1', '1995-06-05', '1', '03165457534', '03099973520', 'bashir@gmail.com', '1', '0000-00-00', NULL, '', '8', '8', 'hahaham', '7686876', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('150', '183', '0', '1', 'Shabir', 'Ahmed', 'Scheme 33 Yousuf Goth Karachi', '', 'Scheme 33 Yousuf Goth Karachi', '', 'Karachi', '177', '1', '1998-12-01', '1', '03165457534', '03240264918', 'nazirhussain@gmail.com', '1', '0000-00-00', NULL, '', '8', '8', 'hjhjhjhhjh', '78676768', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('151', '192', '0', '1', 'ABDUL SATTAR', 'AMIN DAT', 'HASSAN BROHI GOAT', '', 'HASSAN BROHI GOAT', 'KARACHI', 'SINDH', '177', '1', '1993-01-01', '1', '03410035359', '03410035359', 'VVVVVVVVVVVVVVV', '1', '0000-00-00', NULL, '', '162', '162', 'BROTHER', '03142585969', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('152', '186', '0', '1', 'Muhammad', 'Arif', 'Naval Flats Karem Flat# F-33 Liyari', '', 'Naval Flats Karem Flat# F-33 Liyari', '', '', '177', '1', '1994-05-15', '1', '', '03179717750', 'muhammadarif@gmail.com', '1', '0000-00-00', NULL, '', '128', '128', 'hkjkjkkj', '809897987', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('153', '187', '0', '1', 'Muhammad ', 'Usman', 'Anaaj Mandi Mohalla Gola Jaikamabad', '', 'Anaaj Mandi Mohalla Gola Jaikamabad', 'Jaikamabad', '', '177', '1', '2002-01-01', '1', '03223394078', '03020028366', 'usman@gmail.com', '1', '0000-00-00', NULL, '', '8', '8', 'hjhjjhjhjhj', '0328282822', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('154', '171', '0', '1', 'IRSHAD ALI BALOCH', 'ABDUL KARIM BALOCH', 'HAJI MURAD SHAROW LET TIPAL KHAR MIRPUR', '', 'HAJI MURAD SHAROW LET TIPAL KHAR MIRPUR', 'MIRPUR', 'SINDH', '177', '1', '1995-01-01', '1', '03072582017', '03072582017', 'xxxxxxxxxx', '1', '0000-00-00', NULL, '', '128', '128', 'NONE', '03463964051', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('155', '173', '0', '1', 'FAYYAZ AHMED`', 'AHMED', 'NONE', '', 'NONE', 'NONE', 'NONE', '177', '1', '2002-10-01', '1', '03020241986', '03020241986', 'CCCCCCCCCC', '1', '0000-00-00', NULL, '', '128', '128', 'NONE', '03463964051', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410'),
('156', '18880', '0', '1', 'Abdul', 'Khalid', '', '', 'house no B41 block 1 Row M gulshan e Kaneez fatima Society Scheme 33 Karachi', 'Karachi', 'Sindh', '177', '1', '2002-10-02', '1', '02145678913', '03341234567', 'admin@example.com', '1', '0000-00-00', NULL, '', '', '', 'Shahid', '01221455154', '0000-00-00', '0000-00-00', '0000-00-00', NULL, '5410');

### Structure of table `0_kv_empl_job` ###

DROP TABLE IF EXISTS `0_kv_empl_job`;

CREATE TABLE `0_kv_empl_job` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `grade` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `al` double NOT NULL,
  `sl` double NOT NULL,
  `ml` double NOT NULL,
  `department` tinyint(2) NOT NULL,
  `nationality` int(11) NOT NULL DEFAULT 0,
  `medi_category` int(11) NOT NULL DEFAULT 0,
  `family` int(11) NOT NULL DEFAULT 0,
  `weekly_off` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `shift` int(3) DEFAULT NULL,
  `desig_group` varchar(2) COLLATE utf8_unicode_ci DEFAULT NULL,
  `desig` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `currency` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `joining` date NOT NULL DEFAULT '0000-00-00',
  `bond_period` date NOT NULL DEFAULT '0000-00-00',
  `bond_doc` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0',
  `date_of_desig_change` date NOT NULL DEFAULT '0000-00-00',
  `empl_type` tinyint(2) NOT NULL,
  `empl_contract_type` int(11) NOT NULL DEFAULT 0,
  `expd_percentage_amt` double DEFAULT NULL,
  `working_branch` tinyint(2) DEFAULT NULL,
  `mod_of_pay` int(2) NOT NULL DEFAULT 0,
  `bank_name` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `acc_no` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `branch_detail` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ifsc` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ESIC` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `PF` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `PAN` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bloog_group` int(2) DEFAULT NULL,
  `aadhar` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nominee_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nominee_phone` varchar(16) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nominee_email` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nominee_address` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `gross_pay_annum` double NOT NULL,
  `gross` double NOT NULL,
  `2` double NOT NULL DEFAULT 0,
  `4` double NOT NULL DEFAULT 0,
  `5` double NOT NULL DEFAULT 0,
  `6` double NOT NULL DEFAULT 0,
  `7` double NOT NULL DEFAULT 0,
  `8` double NOT NULL DEFAULT 0,
  `11` double NOT NULL DEFAULT 0,
  `12` double NOT NULL DEFAULT 0,
  `13` double NOT NULL DEFAULT 0,
  `14` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=157 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_job` ###

INSERT INTO `0_kv_empl_job` VALUES
('39', '1', NULL, '0', '0', '0', '3', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-01', '0', '0000-00-01', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '30000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('40', '2', NULL, '0', '0', '0', '18', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-02', '0', '0000-00-02', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '35000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('41', '3', NULL, '0', '0', '0', '4', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-03', '0', '0000-00-03', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '65000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('42', '4', NULL, '0', '0', '0', '4', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-04', '0', '0000-00-04', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '18000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('43', '5', NULL, '0', '0', '0', '5', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-05', '0', '0000-00-05', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '99000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('44', '6', NULL, '0', '0', '0', '6', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-06', '0', '0000-00-06', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '30250', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('45', '7', NULL, '0', '0', '0', '7', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-07', '0', '0000-00-07', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '25000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('46', '8', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-08', '0', '0000-00-08', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '27500', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('47', '10', NULL, '0', '0', '0', '2', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-09', '0', '0000-00-09', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('48', '11', NULL, '0', '0', '0', '10', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-10', '0', '0000-00-10', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('49', '12', NULL, '0', '0', '0', '10', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-11', '0', '0000-00-11', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '30250', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('50', '13', NULL, '0', '0', '0', '10', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-12', '0', '0000-00-12', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '44000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('51', '14', NULL, '0', '0', '0', '10', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-13', '0', '0000-00-13', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '18150', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('52', '15', NULL, '0', '0', '0', '11', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-14', '0', '0000-00-14', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '36300', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('53', '16', NULL, '0', '0', '0', '2', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-15', '0', '0000-00-15', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '28000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('54', '17', NULL, '0', '0', '0', '2', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-16', '0', '0000-00-16', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '16500', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('55', '18', NULL, '0', '0', '0', '13', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-17', '0', '0000-00-17', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '32700', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('56', '20', NULL, '0', '0', '0', '2', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-18', '0', '0000-00-18', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '22000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('57', '21', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-19', '0', '0000-00-19', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '96800', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('58', '22', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-20', '0', '0000-00-20', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '42350', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('59', '23', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-21', '0', '0000-00-21', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '30250', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('60', '25', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-22', '0', '0000-00-22', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '30250', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('61', '28', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-23', '0', '0000-00-23', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '16500', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('62', '29', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-24', '0', '0000-00-24', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('63', '30', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-25', '0', '0000-00-25', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('64', '31', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-26', '0', '0000-00-26', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '18150', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('65', '32', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-27', '0', '0000-00-27', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('66', '35', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-28', '0', '0000-00-28', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '16500', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('67', '38', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-29', '0', '0000-00-29', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '16500', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('68', '39', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-30', '0', '0000-00-30', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('69', '40', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-31', '0', '0000-00-31', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('70', '42', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('71', '43', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('72', '45', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('73', '46', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '18150', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('74', '47', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('75', '48', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('76', '49', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('77', '50', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('78', '51', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '57000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('79', '53', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('80', '54', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '16500', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('81', '55', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('82', '56', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('83', '57', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '16500', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('84', '58', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('85', '60', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '16500', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('86', '61', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('87', '63', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '18150', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('88', '64', NULL, '0', '0', '0', '8', '6', '1', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', '2', '16', 'PKR', '0000-00-00', '0000-00-00', '0', '2022-10-04', '1', '0', '40', '2', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '16500', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('89', '65', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '16500', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('90', '67', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '18150', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('91', '68', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('92', '69', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('93', '70', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '16500', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('94', '73', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('95', '74', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '16500', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('96', '75', NULL, '0', '0', '0', '8', '6', '1', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', '2', '16', 'PKR', '0000-00-00', '0000-00-00', '0', '2022-10-04', '1', '0', '40', '2', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('97', '76', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('98', '79', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('99', '80', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('100', '82', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('101', '83', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '17000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('102', '85', NULL, '0', '0', '0', '17', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '17000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('103', '87', NULL, '0', '0', '0', '2', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '18500', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('104', '88', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('105', '89', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('106', '90', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('107', '92', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('108', '99', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '22000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('109', '100', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('110', '103', NULL, '0', '0', '0', '4', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '18000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('111', '105', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('112', '107', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('113', '109', NULL, '0', '0', '0', '11', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '18000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('114', '111', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('115', '112', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('116', '114', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('117', '115', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('118', '116', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('119', '117', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('120', '118', NULL, '0', '0', '0', '11', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '18000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('121', '119', NULL, '0', '0', '0', '17', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '17000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('122', '120', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('123', '121', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '33000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('124', '124', NULL, '0', '0', '0', '7', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('125', '127', NULL, '0', '0', '0', '0', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '150000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('126', '128', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('127', '130', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('128', '131', NULL, '0', '0', '0', '2', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '16000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('129', '132', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('130', '133', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '15000', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('131', '134', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('132', '134', NULL, '0', '0', '0', '0', '6', '0', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', NULL, NULL, 'PKR', '0000-00-00', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '0', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('133', '139', NULL, '0', '0', '0', '8', '6', '1', '0', 'YToxOntpOjA7czozOiJTdW4iO30=', '0', '2', '16', 'PKR', '2022-02-01', '0000-00-00', '0', '2022-09-27', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('134', '143', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '1', '13', 'PKR', '2022-09-27', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('135', '147', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '5', '17', 'PKR', '2022-03-08', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('136', '148', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '5', '13', 'PKR', '2022-03-10', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('137', '151', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '3', '17', 'PKR', '2022-03-09', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('138', '152', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '3', '17', 'PKR', '2022-03-14', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('139', '160', NULL, '0', '0', '0', '5', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '6', '19', 'PKR', '2022-05-17', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('140', '161', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '5', '17', 'PKR', '2022-05-19', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('141', '162', NULL, '0', '0', '0', '19', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '7', '22', 'PKR', '2022-05-27', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('142', '170', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '5', '17', 'PKR', '2022-06-03', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('143', '177', NULL, '0', '0', '0', '2', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '3', '23', 'PKR', '2022-06-16', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('144', '189', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '2', '16', 'PKR', '2022-08-18', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('145', '190', NULL, '0', '0', '0', '15', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '3', '17', 'PKR', '2022-08-31', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('146', '181', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '5', '17', 'PKR', '2022-07-19', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('147', '193', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '5', '17', 'PKR', '2022-09-21', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('148', '191', NULL, '0', '0', '0', '13', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '3', '24', 'PKR', '2022-09-16', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('149', '182', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '2', '16', 'PKR', '2022-10-01', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('150', '183', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '2', '16', 'PKR', '2022-07-19', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('151', '192', NULL, '0', '0', '0', '13', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '3', '24', 'PKR', '2022-10-01', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('152', '186', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '5', '17', 'PKR', '2022-07-21', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('153', '187', NULL, '0', '0', '0', '8', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '2', '16', 'PKR', '2022-07-27', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('154', '171', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '5', '17', 'PKR', '2022-06-03', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('155', '173', NULL, '0', '0', '0', '16', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '5', '17', 'PKR', '2022-06-07', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '2', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('156', '18880', NULL, '0', '0', '0', '1', '6', '0', '0', 'YToyOntpOjE7czozOiJTYXQiO2k6MDtzOjM6IlN1biI7fQ==', '0', '3', '13', 'PKR', '2022-10-02', '0000-00-00', '0', '0000-00-00', '1', '0', '40', '2', '1', NULL, NULL, NULL, NULL, NULL, NULL, '', '1', NULL, NULL, NULL, NULL, NULL, '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0');

### Structure of table `0_kv_empl_leave_applied` ###

DROP TABLE IF EXISTS `0_kv_empl_leave_applied`;

CREATE TABLE `0_kv_empl_leave_applied` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `year` int(5) NOT NULL,
  `empl_id` varchar(10) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `leave_type` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `reason` text COLLATE utf8_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `days` int(3) NOT NULL,
  `filename` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `reason_rejected` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_leave_applied` ###


### Structure of table `0_kv_empl_leave_days` ###

DROP TABLE IF EXISTS `0_kv_empl_leave_days`;

CREATE TABLE `0_kv_empl_leave_days` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date` date NOT NULL,
  `leave_char` varchar(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `days` int(5) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_leave_days` ###


### Structure of table `0_kv_empl_leave_encashment` ###

DROP TABLE IF EXISTS `0_kv_empl_leave_encashment`;

CREATE TABLE `0_kv_empl_leave_encashment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `department` int(11) NOT NULL,
  `year` int(5) NOT NULL,
  `month` int(5) NOT NULL,
  `date` date NOT NULL,
  `allowances` text COLLATE utf8_unicode_ci NOT NULL,
  `payable_days` double NOT NULL,
  `amount` double NOT NULL,
  `carry_forward` tinyint(1) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_leave_encashment` ###


### Structure of table `0_kv_empl_leave_travel` ###

DROP TABLE IF EXISTS `0_kv_empl_leave_travel`;

CREATE TABLE `0_kv_empl_leave_travel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nationality` int(5) NOT NULL,
  `amount` double NOT NULL,
  `eligibility` varchar(30) NOT NULL,
  `self` tinyint(4) NOT NULL,
  `family` int(3) NOT NULL,
  `family_amt` double NOT NULL,
  `ticket_per_yr` int(3) NOT NULL,
  `month` double NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_leave_travel` ###


### Structure of table `0_kv_empl_leave_types` ###

DROP TABLE IF EXISTS `0_kv_empl_leave_types`;

CREATE TABLE `0_kv_empl_leave_types` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `char_code` varchar(2) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `frequency` int(5) NOT NULL,
  `deletable` tinyint(1) NOT NULL DEFAULT 1,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_leave_types` ###

INSERT INTO `0_kv_empl_leave_types` VALUES
('1', 'Annual Leave', 'al', '12', '0', '0'),
('2', 'Sick Leave', 'sl', '12', '0', '0'),
('3', 'Casual/General Leave', 'cl', '12', '0', '0'),
('5', 'Hajj Leave', 'hl', '60', '1', '1'),
('6', 'Death of Close relatives(Famil', 'dc', '-2', '1', '1'),
('7', 'Maternity Leaves', 'ml', '0', '1', '0');

### Structure of table `0_kv_empl_license` ###

DROP TABLE IF EXISTS `0_kv_empl_license`;

CREATE TABLE `0_kv_empl_license` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(11) NOT NULL,
  `license_category` int(4) NOT NULL,
  `license_type` int(4) NOT NULL,
  `license_number` varchar(40) NOT NULL,
  `issuing_country` int(4) NOT NULL,
  `issue_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `filename` varchar(250) NOT NULL DEFAULT '',
  `unique_name` varchar(60) NOT NULL DEFAULT '',
  `filetype` varchar(50) DEFAULT '',
  `filesize` bigint(30) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_license` ###


### Structure of table `0_kv_empl_license_type` ###

DROP TABLE IF EXISTS `0_kv_empl_license_type`;

CREATE TABLE `0_kv_empl_license_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(250) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_license_type` ###


### Structure of table `0_kv_empl_lmra_fees` ###

DROP TABLE IF EXISTS `0_kv_empl_lmra_fees`;

CREATE TABLE `0_kv_empl_lmra_fees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nationality` int(5) NOT NULL,
  `amount` double NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_lmra_fees` ###

INSERT INTO `0_kv_empl_lmra_fees` VALUES
('1', '0', '5'),
('2', '1', '0');

### Structure of table `0_kv_empl_loan` ###

DROP TABLE IF EXISTS `0_kv_empl_loan`;

CREATE TABLE `0_kv_empl_loan` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(10) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `loan_date` date DEFAULT NULL,
  `start_date` date NOT NULL DEFAULT '0000-00-00',
  `end_date` date NOT NULL DEFAULT '0000-00-00',
  `loan_amount` decimal(15,2) DEFAULT NULL,
  `currency` varchar(4) DEFAULT NULL,
  `rate` double DEFAULT NULL,
  `loan_type_id` int(5) DEFAULT NULL,
  `periods` int(5) DEFAULT NULL,
  `monthly_pay` decimal(15,2) DEFAULT NULL,
  `periods_paid` int(5) NOT NULL,
  `status` varchar(10) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `payment` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_loan` ###


### Structure of table `0_kv_empl_loan_repayment` ###

DROP TABLE IF EXISTS `0_kv_empl_loan_repayment`;

CREATE TABLE `0_kv_empl_loan_repayment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `loan_id` int(10) NOT NULL DEFAULT 0,
  `pay_slip_id` int(10) NOT NULL DEFAULT 0,
  `re_pay_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `re_pay_date` date DEFAULT NULL,
  `periods_paid` int(10) NOT NULL DEFAULT 0,
  `payment_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_loan_repayment` ###

INSERT INTO `0_kv_empl_loan_repayment` VALUES
('13', '1', '14', '30000.00', '2022-07-16', '2', '0'),
('14', '1', '14', '30000.00', '2022-07-16', '2', '0'),
('15', '1', '14', '30000.00', '2022-07-16', '2', '0'),
('16', '1', '14', '30000.00', '2022-07-16', '2', '0'),
('17', '1', '14', '30000.00', '2022-07-16', '2', '0'),
('18', '1', '14', '30000.00', '2022-07-16', '2', '0'),
('19', '1', '14', '30000.00', '2022-07-16', '2', '0'),
('20', '1', '14', '30000.00', '2022-07-16', '2', '0');

### Structure of table `0_kv_empl_loan_types` ###

DROP TABLE IF EXISTS `0_kv_empl_loan_types`;

CREATE TABLE `0_kv_empl_loan_types` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `loan_name` varchar(200) NOT NULL,
  `interest_rate` double NOT NULL,
  `allowance_id` int(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_loan_types` ###


### Structure of table `0_kv_empl_medical_premium` ###

DROP TABLE IF EXISTS `0_kv_empl_medical_premium`;

CREATE TABLE `0_kv_empl_medical_premium` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(250) NOT NULL,
  `yrly_premium` double NOT NULL,
  `self` tinyint(1) NOT NULL,
  `family` int(3) NOT NULL,
  `family_amt` double NOT NULL,
  `total` double NOT NULL,
  `month` double NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_medical_premium` ###

INSERT INTO `0_kv_empl_medical_premium` VALUES
('1', 'Category A', '72', '1', '3', '50', '222', '18.5'),
('2', 'Category B', '150', '1', '2', '25', '200', '16.67'),
('3', 'Category C', '260', '1', '1', '0', '520', '43.333333333333'),
('4', 'Category D', '300', '1', '0', '0', '300', '25'),
('5', 'Niormal', '0', '1', '0', '0', '0', '0');

### Structure of table `0_kv_empl_memo` ###

DROP TABLE IF EXISTS `0_kv_empl_memo`;

CREATE TABLE `0_kv_empl_memo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `empl_id` int(11) NOT NULL,
  `emplr_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `reason` text COLLATE utf8_unicode_ci NOT NULL,
  `status` varchar(80) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_memo` ###


### Structure of table `0_kv_empl_nationalities` ###

DROP TABLE IF EXISTS `0_kv_empl_nationalities`;

CREATE TABLE `0_kv_empl_nationalities` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `description` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_nationalities` ###

INSERT INTO `0_kv_empl_nationalities` VALUES
('1', 'Bahraini', '0'),
('2', 'Saudi', '0'),
('3', 'Nepal', '0'),
('4', 'European', '0'),
('5', 'Qatar', '0'),
('6', 'Asian', '0'),
('7', 'Indian', '0'),
('8', 'Bangladeshi', '0'),
('9', 'Egyptian', '0'),
('10', 'Pakistani', '0');

### Structure of table `0_kv_empl_option` ###

DROP TABLE IF EXISTS `0_kv_empl_option`;

CREATE TABLE `0_kv_empl_option` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `option_name` varchar(150) NOT NULL,
  `option_value` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_option` ###

INSERT INTO `0_kv_empl_option` VALUES
('1', 'weekly_off', 'YToyOntpOjA7czozOiJTdW4iO2k6MTtzOjM6IlNhdCI7fQ=='),
('2', 'empl_ref_type', '1'),
('3', 'next_empl_id', '18881'),
('4', 'ot_factor', '1'),
('5', 'special_ot_factor', '1'),
('6', 'master_role', '2'),
('7', 'empl_role', '15'),
('8', 'home_nation', '10'),
('9', 'home_country', '177'),
('10', 'monthly_choice', '1'),
('11', 'BeginDay', '1'),
('12', 'EndDay', '31'),
('13', 'total_working_days', '0'),
('14', 'adv_salary_account', '1060'),
('15', 'loan_payable_account', ''),
('16', 'interest_calculation', '2620'),
('17', 'salary_account', '1060'),
('18', 'salary_payable', '5410'),
('19', 'debit_encashment', '1060'),
('20', 'credit_encashment', '5410'),
('21', 'max_leave_forward', '2'),
('22', 'esb_salary', '0'),
('23', 'esb_country', '2'),
('24', 'expd_percentage_amt', '40'),
('25', 'n_period', '30'),
('26', 'p_period', '1'),
('27', 'cm_period', '12'),
('28', 'cy_period', '0'),
('29', 'postgl', '1'),
('30', 'zk_ip', '192.168.0.106'),
('31', 'tax_used', ''),
('32', 'enable_esic', ''),
('33', 'enable_pf', ''),
('34', 'license_mgr', ''),
('35', 'leave_travel', ''),
('36', 'lmra_fees', ''),
('37', 'gosi_settings', ''),
('38', 'medical_preimum', ''),
('39', 'visa', ''),
('40', 'candidates', ''),
('41', 'allow_recalculate', '1'),
('42', 'bahrain_options', ''),
('43', 'enable_employee_access', '1'),
('44', 'BeginTime', '08:00:00'),
('45', 'EndTime', '18:00:00'),
('46', 'OT_BeginTime', '32400'),
('47', 'OT_EndTime', '18000');

### Structure of table `0_kv_empl_petrol` ###

DROP TABLE IF EXISTS `0_kv_empl_petrol`;

CREATE TABLE `0_kv_empl_petrol` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `travel_date` date NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `from_place` text COLLATE utf8_unicode_ci NOT NULL,
  `to_place` text COLLATE utf8_unicode_ci NOT NULL,
  `distance` int(5) NOT NULL,
  `rate_per_hr` double NOT NULL,
  `amount` double NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_petrol` ###


### Structure of table `0_kv_empl_pick_type` ###

DROP TABLE IF EXISTS `0_kv_empl_pick_type`;

CREATE TABLE `0_kv_empl_pick_type` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_pick_type` ###

INSERT INTO `0_kv_empl_pick_type` VALUES
('1', 'Languages', '0'),
('2', 'Proficiency', '0'),
('3', 'long1', '0'),
('4', 'contract', '0'),
('5', 'License Type', '0'),
('6', 'License Category', '0');

### Structure of table `0_kv_empl_picklist` ###

DROP TABLE IF EXISTS `0_kv_empl_picklist`;

CREATE TABLE `0_kv_empl_picklist` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` int(3) NOT NULL,
  `description` varchar(250) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_picklist` ###

INSERT INTO `0_kv_empl_picklist` VALUES
('1', '1', 'Tamil', '0'),
('2', '1', 'English', '0'),
('3', '2', 'Read', '0'),
('4', '2', 'Write', '0'),
('5', '2', 'Read &amp; Write', '0'),
('6', '1', 'Arabic', '0'),
('10', '4', 'Permanent', '0'),
('11', '4', 'Bahraini Contract', '0'),
('12', '4', 'Bahraini Permanent', '0'),
('13', '4', 'Open Contract', '0'),
('14', '6', 'Driving license', '0'),
('16', '1', 'Malayalam', '0'),
('17', '5', 'Permanent', '0'),
('18', '5', 'Renewable', '0'),
('20', '6', 'test license', '0');

### Structure of table `0_kv_empl_salary` ###

DROP TABLE IF EXISTS `0_kv_empl_salary`;

CREATE TABLE `0_kv_empl_salary` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(10) NOT NULL,
  `month` int(2) NOT NULL,
  `from_date` date NOT NULL DEFAULT '0000-00-00',
  `to_date` date NOT NULL DEFAULT '0000-00-00',
  `days_worked` double NOT NULL DEFAULT 0,
  `pay_hrs` int(11) NOT NULL DEFAULT 0,
  `ot_hrs` int(11) NOT NULL DEFAULT 0,
  `spl_ot_hrs` int(11) NOT NULL DEFAULT 0,
  `year` int(2) NOT NULL,
  `GL` tinyint(1) NOT NULL DEFAULT 0,
  `payout` tinyint(1) NOT NULL DEFAULT 0 COMMENT '0-unpaid, 1-Paid',
  `date` date NOT NULL,
  `currency` varchar(5) NOT NULL DEFAULT '',
  `rate` double NOT NULL DEFAULT 1,
  `al` double NOT NULL DEFAULT 0,
  `sl` double NOT NULL DEFAULT 0,
  `ml` double NOT NULL DEFAULT 0,
  `gross` double NOT NULL DEFAULT 0,
  `ctc` double NOT NULL DEFAULT 0,
  `lop_amount` double NOT NULL DEFAULT 0,
  `loans` text DEFAULT NULL,
  `dimension` int(5) NOT NULL DEFAULT 0,
  `dimension2` int(5) NOT NULL DEFAULT 0,
  `adv_sal` double NOT NULL DEFAULT 0,
  `net_pay` double NOT NULL DEFAULT 0,
  `misc` double NOT NULL DEFAULT 0,
  `ot_other_allowance` double NOT NULL DEFAULT 0,
  `ot_earnings` double NOT NULL DEFAULT 0,
  `2` double NOT NULL DEFAULT 0,
  `4` double NOT NULL DEFAULT 0,
  `5` double NOT NULL DEFAULT 0,
  `6` double NOT NULL DEFAULT 0,
  `7` double NOT NULL DEFAULT 0,
  `8` double NOT NULL DEFAULT 0,
  `11` double NOT NULL DEFAULT 0,
  `12` double NOT NULL DEFAULT 0,
  `13` double NOT NULL DEFAULT 0,
  `14` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_salary` ###

INSERT INTO `0_kv_empl_salary` VALUES
('1', '0001', '0', '0000-00-00', '0000-00-00', '0', '0', '0', '0', '3', '0', '0', '2022-07-18', '', '1', '-24', '-10', '-10', '0', '0', '0', NULL, '0', '0', '0', '-1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('2', '002', '0', '0000-00-00', '0000-00-00', '0', '0', '0', '0', '3', '0', '0', '2022-07-18', '', '1', '-24', '-10', '-10', '0', '0', '0', NULL, '0', '0', '0', '-1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'),
('3', '0001', '1', '2022-01-01', '2022-01-31', '26', '842400', '25200', '0', '3', '1', '0', '2022-07-19', 'PKR', '1', '0', '0', '0', '37978.63', '37978.63', '0', 'YTowOnt9', '0', '0', '0', '40478.63', '0', '0', '478.63', '16000', '20000', '0', '1500', '0', '0', '0', '0', '0', '0');

### Structure of table `0_kv_empl_salary_advance` ###

DROP TABLE IF EXISTS `0_kv_empl_salary_advance`;

CREATE TABLE `0_kv_empl_salary_advance` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `payslip_id` int(11) NOT NULL DEFAULT 0,
  `payslip_id_adv` int(11) NOT NULL DEFAULT 0,
  `date` date NOT NULL,
  `month` int(10) NOT NULL,
  `year` int(10) NOT NULL,
  `amount` double NOT NULL,
  `description` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  `bank_id` int(5) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_salary_advance` ###


### Structure of table `0_kv_empl_shifts` ###

DROP TABLE IF EXISTS `0_kv_empl_shifts`;

CREATE TABLE `0_kv_empl_shifts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(250) COLLATE utf8_unicode_ci NOT NULL,
  `BeginTime` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `EndTime` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `dimension` int(11) NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_shifts` ###

INSERT INTO `0_kv_empl_shifts` VALUES
('1', 'Plant Timing', '08:00:00', '18:00:00', '0', '0'),
('2', 'Head Office', '20:00:00', '18:59:00', '0', '0');

### Structure of table `0_kv_empl_skills` ###

DROP TABLE IF EXISTS `0_kv_empl_skills`;

CREATE TABLE `0_kv_empl_skills` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `language` int(5) NOT NULL DEFAULT 0,
  `proficiency` int(5) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_skills` ###


### Structure of table `0_kv_empl_status_types` ###

DROP TABLE IF EXISTS `0_kv_empl_status_types`;

CREATE TABLE `0_kv_empl_status_types` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_status_types` ###

INSERT INTO `0_kv_empl_status_types` VALUES
('1', 'Active', '0'),
('2', 'Inactive', '0'),
('3', 'Resigned', '0'),
('4', 'Decesed', '0'),
('5', 'Terminated', '0');

### Structure of table `0_kv_empl_tax_types` ###

DROP TABLE IF EXISTS `0_kv_empl_tax_types`;

CREATE TABLE `0_kv_empl_tax_types` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `description` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `min_sal` int(10) NOT NULL,
  `max_sal` int(10) NOT NULL,
  `percentage` int(10) NOT NULL,
  `offset` int(10) NOT NULL,
  `year` int(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_tax_types` ###


### Structure of table `0_kv_empl_taxes` ###

DROP TABLE IF EXISTS `0_kv_empl_taxes`;

CREATE TABLE `0_kv_empl_taxes` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `description` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `min_sal` int(10) NOT NULL,
  `max_sal` int(10) NOT NULL,
  `taxable_salary` double NOT NULL,
  `percentage` int(10) NOT NULL,
  `frequency` int(3) NOT NULL DEFAULT 0,
  `offset` int(10) NOT NULL,
  `year` int(5) NOT NULL,
  `allowance_id` int(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_taxes` ###

INSERT INTO `0_kv_empl_taxes` VALUES
('1', 'Grade A', '720000', '840000', '750000', '5', '0', '0', '3', '12'),
('2', 'Grade B', '850000', '1000000', '890000', '10', '0', '0', '3', '12'),
('3', 'Grade C', '1100000', '1500000', '1200000', '15', '0', '0', '3', '12'),
('4', 'Grade A', '720000', '840000', '750000', '3', '0', '0', '3', '11'),
('5', 'Grade B', '850000', '1000000', '890000', '13', '0', '0', '3', '11'),
('6', 'Grade C', '1100000', '1500000', '1200000', '16', '0', '0', '3', '11');

### Structure of table `0_kv_empl_training` ###

DROP TABLE IF EXISTS `0_kv_empl_training`;

CREATE TABLE `0_kv_empl_training` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `empl_id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `training_desc` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `course` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `cost` int(8) NOT NULL,
  `institute` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `s_date` date NOT NULL,
  `e_date` date NOT NULL,
  `notes` longtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_training` ###


### Structure of table `0_kv_empl_travel` ###

DROP TABLE IF EXISTS `0_kv_empl_travel`;

CREATE TABLE `0_kv_empl_travel` (
  `id` int(15) NOT NULL,
  `empl_id` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `title` text COLLATE utf8_unicode_ci NOT NULL,
  `travel_date` date NOT NULL,
  `purpose` text COLLATE utf8_unicode_ci NOT NULL,
  `mode` varchar(6) COLLATE utf8_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8_unicode_ci NOT NULL,
  `from_place` text COLLATE utf8_unicode_ci NOT NULL,
  `to_place` text COLLATE utf8_unicode_ci NOT NULL,
  `distance` int(5) NOT NULL,
  `amount` double NOT NULL,
  `filename` text COLLATE utf8_unicode_ci NOT NULL,
  `unique_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `filetype` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_kv_empl_travel` ###


### Structure of table `0_kv_empl_visa_exp` ###

DROP TABLE IF EXISTS `0_kv_empl_visa_exp`;

CREATE TABLE `0_kv_empl_visa_exp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nationality` int(5) NOT NULL,
  `self` tinyint(1) NOT NULL,
  `self_amt` double NOT NULL,
  `family` int(3) NOT NULL,
  `family_amt` double NOT NULL,
  `total` double NOT NULL,
  `month` double NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 ;

### Data of table `0_kv_empl_visa_exp` ###

INSERT INTO `0_kv_empl_visa_exp` VALUES
('1', '1', '1', '0', '0', '0', '0', '0'),
('2', '0', '1', '172', '0', '0', '172', '14.33'),
('3', '0', '1', '172', '1', '0', '172', '14.33'),
('4', '0', '1', '172', '2', '90', '352', '29.33');

### Structure of table `0_loc_stock` ###

DROP TABLE IF EXISTS `0_loc_stock`;

CREATE TABLE `0_loc_stock` (
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `reorder_level` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`loc_code`,`stock_id`),
  KEY `stock_id` (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_loc_stock` ###

INSERT INTO `0_loc_stock` VALUES
('001', '101', '0'),
('001', '1202', '0'),
('001', '14121', '0'),
('001', '187', '0'),
('001', '201', '0'),
('001', '20147', '0'),
('001', '78540', '0'),
('001', '9787', '0'),
('001', 'F-001', '0'),
('001', 'IT-1001', '0'),
('001', 'T-0001', '0'),
('001', 'T-0002', '0'),
('001', 'T-0003', '0'),
('001', 'T-0004', '0'),
('DEF', '101', '10'),
('DEF', '1202', '0'),
('DEF', '14121', '10'),
('DEF', '187', '0'),
('DEF', '201', '0'),
('DEF', '20147', '0'),
('DEF', '78540', '0'),
('DEF', '9787', '0'),
('DEF', 'F-001', '0'),
('DEF', 'IT-1001', '0'),
('DEF', 'T-0001', '60'),
('DEF', 'T-0002', '0'),
('DEF', 'T-0003', '0'),
('DEF', 'T-0004', '0');

### Structure of table `0_locations` ###

DROP TABLE IF EXISTS `0_locations`;

CREATE TABLE `0_locations` (
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `location_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fax` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `fixed_asset` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`loc_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_locations` ###

INSERT INTO `0_locations` VALUES
('001', 'Fixed assets Loc', 'Fixed assets Loc', '', '', '', '', '', '1', '0'),
('DEF', 'Default', 'N/A', '', '', '', '', '', '0', '0');

### Structure of table `0_master_login` ###

DROP TABLE IF EXISTS `0_master_login`;

CREATE TABLE `0_master_login` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) NOT NULL,
  `role` int(11) NOT NULL,
  `companies` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ;

### Data of table `0_master_login` ###


### Structure of table `0_payment_terms` ###

DROP TABLE IF EXISTS `0_payment_terms`;

CREATE TABLE `0_payment_terms` (
  `terms_indicator` int(11) NOT NULL AUTO_INCREMENT,
  `terms` char(80) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `days_before_due` smallint(6) NOT NULL DEFAULT 0,
  `day_in_following_month` smallint(6) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`terms_indicator`),
  UNIQUE KEY `terms` (`terms`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_payment_terms` ###

INSERT INTO `0_payment_terms` VALUES
('1', 'Due 15th Of the Following Month', '0', '17', '0'),
('2', 'Due By End Of The Following Month', '0', '30', '0'),
('3', 'Payment due within 10 days', '10', '0', '0'),
('4', 'Cash Only', '0', '0', '0'),
('5', 'Prepaid', '-1', '0', '0');

### Structure of table `0_prices` ###

DROP TABLE IF EXISTS `0_prices`;

CREATE TABLE `0_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `sales_type_id` int(11) NOT NULL DEFAULT 0,
  `curr_abrev` char(3) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `price` (`stock_id`,`sales_type_id`,`curr_abrev`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_prices` ###

INSERT INTO `0_prices` VALUES
('1', '101', '2', 'USD', '30000'),
('2', '187', '2', 'USD', '0'),
('3', '14121', '2', 'PKR', '500');

### Structure of table `0_print_profiles` ###

DROP TABLE IF EXISTS `0_print_profiles`;

CREATE TABLE `0_print_profiles` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `report` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `printer` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile` (`profile`,`report`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_print_profiles` ###

INSERT INTO `0_print_profiles` VALUES
('1', 'Out of office', NULL, '0'),
('2', 'Sales Department', NULL, '0'),
('3', 'Central', NULL, '2'),
('4', 'Sales Department', '104', '2'),
('5', 'Sales Department', '105', '2'),
('6', 'Sales Department', '107', '2'),
('7', 'Sales Department', '109', '2'),
('8', 'Sales Department', '110', '2'),
('9', 'Sales Department', '201', '2');

### Structure of table `0_printers` ###

DROP TABLE IF EXISTS `0_printers`;

CREATE TABLE `0_printers` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `queue` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `host` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `port` smallint(11) unsigned NOT NULL,
  `timeout` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_printers` ###

INSERT INTO `0_printers` VALUES
('1', 'QL500', 'Label printer', 'QL500', 'server', '127', '20'),
('2', 'Samsung', 'Main network printer', 'scx4521F', 'server', '515', '5'),
('3', 'Local', 'Local print server at user IP', 'lp', '', '515', '10');

### Structure of table `0_purch_data` ###

DROP TABLE IF EXISTS `0_purch_data`;

CREATE TABLE `0_purch_data` (
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `price` double NOT NULL DEFAULT 0,
  `suppliers_uom` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `conversion_factor` double NOT NULL DEFAULT 1,
  `supplier_description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`supplier_id`,`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_data` ###

INSERT INTO `0_purch_data` VALUES
('1', '101', '50', '', '1', 'abc'),
('1', '1202', '75', '', '1', 'asad'),
('1', '14121', '500', '', '1', 'gum'),
('1', '201', '840', 'bg', '50', 'Cement'),
('1', '20147', '1150', 'MT', '1000', '27575'),
('1', '9787', '32000', 'kg', '25', 'Chemical 1'),
('1', 'IT-1001', '150', '', '1', 'New item A'),
('1', 'T-0002', '5000', '', '1', 'Cap'),
('1', 'T-0003', '600', '', '1', 'Sticker'),
('1', 'T-0004', '400', '', '1', 'Carton'),
('2', '78540', '400', '', '1', 'MG 17'),
('2', '9787', '150', '', '1', 'Chemical 1'),
('2', 'T-0002', '5000', '', '1', 'Cap'),
('3', '1202', '450', '', '1', 'asad'),
('3', '201', '15000', '', '1', 'Cement'),
('3', '20147', '400', '', '1', 'Silicon'),
('3', '9787', '7500', '', '1', 'Chemical 1'),
('3', 'T-0004', '100', '', '1', 'Carton'),
('4', '201', '960', '', '1', 'Cement');

### Structure of table `0_purch_order_details` ###

DROP TABLE IF EXISTS `0_purch_order_details`;

CREATE TABLE `0_purch_order_details` (
  `po_detail_item` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `item_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci DEFAULT NULL,
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `qty_invoiced` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `act_price` double NOT NULL DEFAULT 0,
  `std_cost_unit` double NOT NULL DEFAULT 0,
  `quantity_ordered` double NOT NULL DEFAULT 0,
  `quantity_received` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`po_detail_item`),
  KEY `order` (`order_no`,`po_detail_item`),
  KEY `itemcode` (`item_code`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_order_details` ###

INSERT INTO `0_purch_order_details` VALUES
('1', '1', 'IT-1001', 'New item A', '2022-05-21', '1', '150', '150', '28392', '1', '1'),
('2', '2', '14121', 'gum ', '2022-05-21', '10', '500', '500', '94640', '10', '10'),
('3', '3', '201', 'Cement', '2022-05-17', '5000', '500', '500', '94640', '5000', '5000'),
('4', '3', '9787', 'Chemical 1', '2022-05-17', '1000', '200', '200', '37856', '1000', '1000'),
('5', '3', '20147', 'Silicon', '2022-05-17', '1000', '400', '400', '75712', '1000', '1000'),
('6', '4', 'T-0002', 'Cap', '2022-05-17', '10000', '5000', '5000', '946400', '10000', '10000'),
('7', '5', 'T-0003', 'Sticker', '2022-05-17', '10000', '600', '600', '113568', '10000', '10000'),
('8', '6', 'T-0004', 'Carton', '2022-05-17', '1', '400', '400', '75712', '1', '1'),
('9', '7', 'T-0004', 'Carton', '2022-05-17', '1000', '400', '400', '75712', '1000', '1000'),
('10', '8', 'T-0002', 'Cap', '2022-05-28', '0', '100', '0', '0', '1', '0'),
('11', '9', '201', 'Cement', '2022-05-19', '0', '15000', '15000', '148454.90196078', '100', '100'),
('12', '9', '9787', 'Chemical 1', '2022-05-19', '0', '7500', '7500', '103653.33333333', '50', '50'),
('13', '10', '101', 'abc', '2022-05-20', '1000', '50', '50', '9464', '1000', '1000'),
('14', '11', '1202', 'asad', '2022-05-20', '1000', '75', '75', '14196', '1000', '1000'),
('15', '12', '9787', 'Chemical 1', '2022-05-30', '20', '150', '150', '101655.24483775', '20', '20'),
('16', '12', '78540', 'MG 17', '2022-05-30', '50', '400', '400', '56784', '50', '50'),
('17', '13', '9787', 'Chemical 1', '2022-05-30', '10', '150', '150', '102975.3033033', '10', '10'),
('18', '13', '78540', 'MG 17', '2022-05-30', '100', '250', '250', '47320', '100', '100'),
('19', '14', 'T-0004', 'Carton', '2022-05-20', '10', '300', '300', '66698.666666667', '10', '10'),
('20', '14', '1202', 'asad', '2022-05-20', '15', '450', '450', '15385.608938547', '15', '15'),
('21', '14', 'T-0004', 'Carton', '2022-05-20', '10', '100', '100', '51288.774193549', '10', '10'),
('22', '15', '20147', 'Silicon', '2022-06-03', '0', '160', '0', '0', '1', '0'),
('23', '16', '78540', 'MG 17', '2022-06-03', '0', '150', '0', '0', '10', '0'),
('24', '17', 'T-0004', 'Carton', '2022-06-01', '0', '200', '0', '0', '10', '0'),
('25', '17', '101', 'abc', '2022-06-01', '0', '300', '0', '0', '20', '0'),
('26', '18', 'T-0002', 'Cap', '2022-06-01', '0', '5000', '0', '0', '10', '0'),
('27', '18', '1202', 'asad', '2022-06-01', '0', '75', '0', '0', '15', '0'),
('30', '21', '201', 'Cement', '2022-06-11', '0', '15000', '0', '0', '1', '0'),
('31', '22', '9787', 'Chemical 1', '2022-06-12', '0', '1280', '1280', '104699.03607503', '25', '25'),
('32', '23', '9787', 'Chemical 1', '2022-06-13', '0', '7500', '7500', '209472.02124833', '100', '100'),
('33', '23', 'T-0004', 'Carton', '2022-06-13', '0', '100', '100', '26585.893129771', '100', '100'),
('34', '24', '201', 'Cement', '2022-06-16', '0', '960', '960', '137785.74987689', '500', '400'),
('35', '25', '201', 'Cement', '2022-06-19', '0', '750', '0', '0', '100', '0'),
('36', '25', 'T-0004', 'Carton', '2022-06-19', '0', '20', '0', '0', '1000', '0'),
('37', '26', '201', 'Cement', '2022-06-09', '0', '16.8', '16.8', '126633.64996994', '500', '500'),
('38', '27', '201', 'Cement', '2022-06-20', '0', '16.8', '0', '0', '50', '0'),
('39', '27', 'T-0002', 'Cap', '2022-06-20', '0', '5000', '0', '0', '100', '0'),
('40', '28', 'T-0002', 'Cap', '2022-06-23', '0', '5000', '0', '0', '15', '0'),
('41', '29', 'T-0002', 'Cap', '2022-06-24', '0', '5000', '0', '0', '15', '0'),
('42', '30', 'T-0002', 'Cap', '2022-06-25', '1', '5000', '5000', '946400', '1', '1');

### Structure of table `0_purch_orders` ###

DROP TABLE IF EXISTS `0_purch_orders`;

CREATE TABLE `0_purch_orders` (
  `order_no` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) NOT NULL DEFAULT 0,
  `comments` tinytext COLLATE utf8_unicode_ci DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `requisition_no` tinytext COLLATE utf8_unicode_ci DEFAULT NULL,
  `into_stock_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_no`),
  KEY `ord_date` (`ord_date`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_purch_orders` ###

INSERT INTO `0_purch_orders` VALUES
('1', '1', 'testing', '2022-05-11', '001/2022', NULL, 'DEF', 'N/A', '175.5', '0', '175.5', '0'),
('2', '1', NULL, '2022-05-11', '002/2022', '127', 'DEF', 'N/A', '5850', '0', '0', '0'),
('3', '3', NULL, '2022-05-17', 'auto', '782510', 'DEF', 'N/A', '3627000', '0', '0', '0'),
('4', '1', NULL, '2022-05-17', 'auto', '244', 'DEF', 'N/A', '58500000', '0', '0', '0'),
('5', '1', NULL, '2022-05-17', 'auto', '98720', 'DEF', 'N/A', '7020000', '0', '0', '0'),
('6', '1', NULL, '2022-05-17', 'auto', '03654', 'DEF', 'N/A', '468', '0', '0', '0'),
('7', '1', NULL, '2022-05-17', 'auto', '45754', 'DEF', 'N/A', '468000', '0', '0', '0'),
('8', '3', NULL, '2022-05-18', '003/2022', NULL, 'DEF', 'N/A', '117', '0', '117', '0'),
('9', '3', NULL, '2022-05-19', 'auto', '33000', 'DEF', 'N/A', '2193750', '0', '0', '0'),
('10', '1', NULL, '2022-05-20', 'auto', '51651', 'DEF', 'N/A', '58500', '0', '0', '0'),
('11', '1', NULL, '2022-05-20', 'auto', '1540', 'DEF', 'N/A', '87750', '0', '0', '0'),
('12', '2', NULL, '2022-05-20', '004/2022', '1223', 'DEF', 'N/A', '26910', '0', '26910', '0'),
('13', '2', NULL, '2022-05-20', '005/2022', '2165', 'DEF', 'N/A', '31005', '0', '0', '0'),
('14', '3', NULL, '2022-05-20', 'auto', '9086', 'DEF', 'N/A', '12577.5', '0', '0', '0'),
('15', '1', NULL, '2022-05-20', '6', NULL, 'DEF', 'Address', '187.2', '0', '187.2', '0'),
('16', '3', NULL, '2022-05-20', '7', NULL, 'DEF', 'Address', '1755', '0', '0', '0'),
('17', '3', NULL, '2022-05-22', '006/2022', '12765434', 'DEF', 'N/A', '9360', '0', '0', '0'),
('18', '1', NULL, '2022-05-22', '007/2022', NULL, 'DEF', 'N/A', '59816.25', '0', '50000', '0'),
('21', '3', NULL, '2022-06-01', '008/2022', NULL, 'DEF', 'N/A', '17550', '0', '0', '0'),
('22', '1', NULL, '2022-06-02', '009/2022', NULL, 'DEF', 'N/A', '37440', '0', '0', '0'),
('23', '3', NULL, '2022-06-03', '010/2022', '1212', 'DEF', 'N/A', '889200', '0', '0', '0'),
('24', '4', NULL, '2022-06-06', '011/2022', NULL, 'DEF', 'N/A', '480000', '0', '0', '1'),
('25', '2', NULL, '2022-06-09', '012/2022', NULL, 'DEF', 'N/A', '111150', '0', '0', '0'),
('26', '1', NULL, '2022-06-09', 'auto', NULL, 'DEF', 'N/A', '9828', '0', '0', '0'),
('27', '1', NULL, '2022-06-10', '013/2022', '54568', 'DEF', 'N/A', '585982.8', '0', '0', '0'),
('28', '1', NULL, '2022-06-13', '014/2022', '155', 'DEF', 'N/A', '87750', '0', '0', '0'),
('29', '1', NULL, '2022-06-14', '015/2022', NULL, 'DEF', 'N/A', '87750', '0', '0', '0'),
('30', '2', NULL, '2022-06-15', '016/2022', NULL, 'DEF', 'N/A', '5850', '0', '0', '0');

### Structure of table `0_quick_entries` ###

DROP TABLE IF EXISTS `0_quick_entries`;

CREATE TABLE `0_quick_entries` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `usage` varchar(120) COLLATE utf8_unicode_ci DEFAULT NULL,
  `base_amount` double NOT NULL DEFAULT 0,
  `base_desc` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bal_type` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_entries` ###


### Structure of table `0_quick_entry_lines` ###

DROP TABLE IF EXISTS `0_quick_entry_lines`;

CREATE TABLE `0_quick_entry_lines` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `qid` smallint(6) unsigned NOT NULL,
  `amount` double DEFAULT 0,
  `memo` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `action` varchar(2) COLLATE utf8_unicode_ci NOT NULL,
  `dest_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` smallint(6) unsigned DEFAULT NULL,
  `dimension2_id` smallint(6) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_quick_entry_lines` ###


### Structure of table `0_recurrent_invoices` ###

DROP TABLE IF EXISTS `0_recurrent_invoices`;

CREATE TABLE `0_recurrent_invoices` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `order_no` int(11) unsigned NOT NULL,
  `debtor_no` int(11) unsigned DEFAULT NULL,
  `group_no` smallint(6) unsigned DEFAULT NULL,
  `days` int(11) NOT NULL DEFAULT 0,
  `monthly` int(11) NOT NULL DEFAULT 0,
  `begin` date NOT NULL DEFAULT '0000-00-00',
  `end` date NOT NULL DEFAULT '0000-00-00',
  `last_sent` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_recurrent_invoices` ###


### Structure of table `0_reflines` ###

DROP TABLE IF EXISTS `0_reflines`;

CREATE TABLE `0_reflines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` int(11) NOT NULL,
  `prefix` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `pattern` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '1',
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `default` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `prefix` (`trans_type`,`prefix`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_reflines` ###

INSERT INTO `0_reflines` VALUES
('1', '0', '', '{001}/{YYYY}', '', '1', '0'),
('2', '1', '', '{001}/{YYYY}', '', '1', '0'),
('3', '2', '', '{001}/{YYYY}', '', '1', '0'),
('4', '4', '', '{001}/{YYYY}', '', '1', '0'),
('5', '10', '', '{001}/{YYYY}', '', '1', '0'),
('6', '11', '', '{001}/{YYYY}', '', '1', '0'),
('7', '12', '', '{001}/{YYYY}', '', '1', '0'),
('8', '13', '', '{001}/{YYYY}', '', '1', '0'),
('9', '16', '', '{001}/{YYYY}', '', '1', '0'),
('10', '17', '', '{001}/{YYYY}', '', '1', '0'),
('11', '18', '', '{001}/{YYYY}', '', '1', '0'),
('12', '20', '', '{001}/{YYYY}', '', '1', '0'),
('13', '21', '', '{001}/{YYYY}', '', '1', '0'),
('14', '22', '', '{001}/{YYYY}', '', '1', '0'),
('15', '25', '', '{001}/{YYYY}', '', '1', '0'),
('16', '26', '', '{001}/{YYYY}', '', '1', '0'),
('17', '28', '', '{001}/{YYYY}', '', '1', '0'),
('18', '29', '', '{001}/{YYYY}', '', '1', '0'),
('19', '30', '', '{001}/{YYYY}', '', '1', '0'),
('20', '32', '', '{001}/{YYYY}', '', '1', '0'),
('21', '35', '', '{001}/{YYYY}', '', '1', '0'),
('22', '40', '', '{001}/{YYYY}', '', '1', '0'),
('23', '97', '', '{001}', '', '1', '0'),
('24', '98', '', '{001}', '', '1', '0'),
('25', '99', '', '{001}', '', '1', '0'),
('26', '100', '', '{001}', '', '1', '0'),
('27', '101', '', '{001}', '', '1', '0'),
('28', '102', '', '{001}', '', '1', '0'),
('29', '103', '', '{001}', '', '1', '0');

### Structure of table `0_refs` ###

DROP TABLE IF EXISTS `0_refs`;

CREATE TABLE `0_refs` (
  `id` int(11) NOT NULL DEFAULT 0,
  `type` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`,`type`),
  KEY `Type_and_Reference` (`type`,`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_refs` ###

INSERT INTO `0_refs` VALUES
('1', '0', '001/2022'),
('2', '0', '002/2022'),
('3', '0', '003/2022'),
('4', '0', '004/2022'),
('5', '0', '005/2022'),
('6', '0', '006/2022'),
('7', '0', '007/2022'),
('8', '0', '008/2022'),
('9', '0', '009/2022'),
('10', '0', '010/2022'),
('11', '0', '011/2022'),
('12', '0', '012/2022'),
('4', '1', ''),
('6', '1', ''),
('1', '1', '001/2022'),
('1', '10', '001/2022'),
('2', '10', '002/2022'),
('3', '10', '003/2022'),
('4', '10', '004/2022'),
('5', '10', '005/2022'),
('1', '12', '001/2022'),
('2', '12', '002/2022'),
('3', '12', '003/2022'),
('4', '12', '004/2022'),
('5', '12', '005/2022'),
('1', '13', '001/2022'),
('2', '13', '002/2022'),
('1', '17', '001/2022'),
('1', '18', '001/2022'),
('2', '18', '002/2022'),
('8', '18', '003/2022'),
('12', '18', '004/2022'),
('13', '18', '005/2022'),
('17', '18', '006/2022'),
('18', '18', '007/2022'),
('21', '18', '008/2022'),
('22', '18', '009/2022'),
('23', '18', '010/2022'),
('24', '18', '011/2022'),
('25', '18', '012/2022'),
('27', '18', '013/2022'),
('28', '18', '014/2022'),
('29', '18', '015/2022'),
('30', '18', '016/2022'),
('0', '18', '8'),
('1', '20', '001/2022'),
('2', '20', '002/2022'),
('3', '20', '003/2022'),
('4', '20', '004/2022'),
('5', '20', '005/2022'),
('6', '20', '006/2022'),
('7', '20', '007/2022'),
('8', '20', '008/2022'),
('9', '20', '009/2022'),
('10', '20', '010/2022'),
('11', '20', '011/2022'),
('12', '20', '012/2022'),
('13', '20', '013/2022'),
('1', '22', '001/2022'),
('2', '22', '002/2022'),
('3', '22', '003/2022'),
('4', '22', '004/2022'),
('5', '22', '005/2022'),
('1', '25', '001/2022'),
('7', '25', '002/2022'),
('10', '25', '003/2022'),
('12', '25', '004/2022'),
('13', '25', '005/2022'),
('14', '25', '006/2022'),
('15', '25', '007/2022'),
('16', '25', '008/2022'),
('17', '25', '009/2022'),
('18', '25', '010/2022'),
('1', '26', '001/2022'),
('2', '26', '002/2022'),
('3', '26', '003/2022'),
('4', '26', '004/2022'),
('5', '26', '005/2022'),
('6', '26', '006/2022'),
('1', '28', '001/2022'),
('2', '28', '002/2022'),
('3', '28', '003/2022'),
('4', '28', '004/2022'),
('1', '29', '001/2022'),
('2', '29', '002/2022'),
('3', '29', '003/2022'),
('4', '29', '004/2022'),
('5', '29', '005/2022'),
('6', '29', '006/2022'),
('1', '30', '001/2022'),
('2', '30', '002/2022'),
('3', '30', '003/2022'),
('4', '30', '004/2022'),
('5', '30', '005/2022'),
('7', '30', '006/2022'),
('12', '30', '007/2022'),
('1', '32', '001/2022');

### Structure of table `0_requisition_details` ###

DROP TABLE IF EXISTS `0_requisition_details`;

CREATE TABLE `0_requisition_details` (
  `requisition_detail_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `requisition_id` int(11) DEFAULT NULL,
  `item_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `lpo_id` int(11) DEFAULT 0,
  `order_quantity` int(11) NOT NULL DEFAULT 0,
  `estimate_price` double NOT NULL DEFAULT 0,
  `quantity` int(11) NOT NULL DEFAULT 0,
  `price` double NOT NULL DEFAULT 0,
  `purpose` varchar(320) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`requisition_detail_id`),
  KEY `0_requisition_details_requisition_id` (`requisition_id`),
  KEY `0_requisition_details_item_code` (`item_code`),
  KEY `0_requisition_details_supplier_id` (`supplier_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_requisition_details` ###

INSERT INTO `0_requisition_details` VALUES
('1', '1', '78540', '3', '16', '10', '150', '10', '150', 'Purpose '),
('2', '1', '20147', '1', '15', '1', '160', '1', '160', 'Purpose '),
('3', '2', '101', '1', '0', '20', '150', '20', '150', 'test');

### Structure of table `0_requisitions` ###

DROP TABLE IF EXISTS `0_requisitions`;

CREATE TABLE `0_requisitions` (
  `requisition_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `point_of_use` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `narrative` varchar(240) COLLATE utf8_unicode_ci DEFAULT NULL,
  `application_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `completed` tinyint(4) NOT NULL DEFAULT 0,
  `processed` tinyint(4) NOT NULL DEFAULT 0,
  `inactive` tinyint(4) NOT NULL DEFAULT 0,
  `details` text COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`requisition_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_requisitions` ###

INSERT INTO `0_requisitions` VALUES
('1', 'Point of us', 'Narrative', '2022-05-20 16:04:34', '1', '0', '0', 'Details Details Details Details Details '),
('2', 'TEST', 'ABCD', '2022-05-22 07:25:08', '1', '0', '0', 'test1');

### Structure of table `0_sales_order_details` ###

DROP TABLE IF EXISTS `0_sales_order_details`;

CREATE TABLE `0_sales_order_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` int(11) NOT NULL DEFAULT 0,
  `trans_type` smallint(6) NOT NULL DEFAULT 30,
  `stk_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci DEFAULT NULL,
  `qty_sent` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `invoiced` double NOT NULL DEFAULT 0,
  `discount_percent` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `sorder` (`trans_type`,`order_no`),
  KEY `stkcode` (`stk_code`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_order_details` ###

INSERT INTO `0_sales_order_details` VALUES
('1', '1', '30', 'IT-1001', 'New item A', '0', '1000', '1', '0', '0'),
('2', '2', '30', '14121', 'gum ', '10', '500', '20', '0', '0'),
('3', '3', '30', '187', 'KFT', '0', '3000', '100', '0', '0'),
('4', '4', '30', '187', 'KFT', '0', '60', '100', '0', '0'),
('5', '5', '30', '187', 'KFT', '1', '0', '1', '0', '0'),
('6', '6', '30', '201', 'Cement', '10', '800', '10', '0', '0'),
('7', '6', '30', 'T-0002', 'Cap', '2', '450', '2', '0', '0'),
('8', '7', '30', '78540', 'MG 17', '0', '0', '50', '0', '0'),
('9', '8', '30', '78540', 'MG 17', '100', '100', '100', '0', '0'),
('10', '9', '30', '9787', 'Chemical 1', '100', '500', '100', '0', '0'),
('11', '10', '30', '101', 'abc', '100', '50', '100', '0', '0'),
('12', '1', '32', '9787', 'Chemical 1', '0', '150', '100', '0', '0'),
('13', '1', '32', '20147', 'Silicon', '0', '150', '100', '0', '0'),
('14', '11', '30', '187', 'KFT', '100', '400', '100', '0', '0'),
('15', '12', '30', 'T-0002', 'Cap', '0', '50', '10', '0', '0');

### Structure of table `0_sales_orders` ###

DROP TABLE IF EXISTS `0_sales_orders`;

CREATE TABLE `0_sales_orders` (
  `order_no` int(11) NOT NULL,
  `trans_type` smallint(6) NOT NULL DEFAULT 30,
  `version` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `debtor_no` int(11) NOT NULL DEFAULT 0,
  `branch_code` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `customer_ref` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `comments` tinytext COLLATE utf8_unicode_ci DEFAULT NULL,
  `ord_date` date NOT NULL DEFAULT '0000-00-00',
  `order_type` int(11) NOT NULL DEFAULT 0,
  `ship_via` int(11) NOT NULL DEFAULT 0,
  `delivery_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `contact_phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `contact_email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `deliver_to` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `freight_cost` double NOT NULL DEFAULT 0,
  `from_stk_loc` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `delivery_date` date NOT NULL DEFAULT '0000-00-00',
  `payment_terms` int(11) DEFAULT NULL,
  `total` double NOT NULL DEFAULT 0,
  `prep_amount` double NOT NULL DEFAULT 0,
  `alloc` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`trans_type`,`order_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_orders` ###

INSERT INTO `0_sales_orders` VALUES
('1', '30', '0', '0', '1', '1', '001/2022', '', NULL, '2022-05-11', '2', '1', 'N/A', '03062329070', NULL, 'AL SAMI LLC', '0', 'DEF', '2022-05-12', '4', '1170', '0', '0'),
('2', '30', '1', '1', '2', '2', '002/2022', '', NULL, '2022-05-11', '2', '1', 'test', NULL, NULL, 'Danum Ltd.', '0', 'DEF', '2022-05-12', '4', '10000', '0', '0'),
('3', '30', '0', '0', '2', '2', '003/2022', '', NULL, '2022-05-16', '2', '1', 'test', NULL, NULL, 'Danum Ltd.', '0', 'DEF', '2022-05-17', '4', '300000', '0', '0'),
('4', '30', '1', '0', '2', '2', '004/2022', '', NULL, '2022-05-20', '2', '1', 'test', NULL, NULL, 'Danum Ltd.', '0', 'DEF', '2022-05-21', '4', '6000', '0', '0'),
('5', '30', '1', '0', '2', '2', '005/2022', '', NULL, '2022-05-20', '2', '1', 'test', NULL, NULL, 'Danum Ltd.', '0', 'DEF', '2022-05-21', '4', '0', '0', '0'),
('6', '30', '1', '0', '2', '2', 'auto', '', NULL, '2022-05-20', '2', '1', 'test', NULL, NULL, 'Danum Ltd.', '0', 'DEF', '2022-05-20', '4', '8900', '0', '0'),
('7', '30', '0', '0', '2', '2', '006/2022', '', NULL, '2022-06-08', '2', '1', 'test', NULL, NULL, 'Danum Ltd.', '0', 'DEF', '2022-06-09', '1', '0', '0', '0'),
('8', '30', '1', '0', '2', '2', 'auto', '', NULL, '2022-06-08', '2', '1', 'test', NULL, NULL, 'Danum Ltd.', '0', 'DEF', '2022-06-08', '4', '10000', '0', '0'),
('9', '30', '1', '0', '3', '3', 'auto', '', NULL, '2022-06-08', '2', '1', 'xyz', NULL, NULL, 'naeem', '0', 'DEF', '2022-07-17', '1', '58500', '0', '0'),
('10', '30', '1', '0', '3', '3', 'auto', '', NULL, '2022-06-08', '2', '1', 'xyz', NULL, NULL, 'naeem', '0', 'DEF', '2022-07-17', '1', '5850', '0', '0'),
('11', '30', '1', '0', '1', '1', 'auto', '', NULL, '2022-06-09', '2', '1', 'N/A', '03062329070', NULL, 'AL SAMI LLC', '5000', 'DEF', '2022-06-09', '4', '52650', '0', '0'),
('12', '30', '0', '0', '2', '2', '007/2022', '', NULL, '2022-06-13', '2', '1', 'test', NULL, NULL, 'Danum Ltd.', '0', 'DEF', '2022-06-14', '1', '500', '0', '0'),
('1', '32', '0', '0', '1', '1', '001/2022', '', 'test', '2022-06-09', '2', '1', 'N/A', '03062329070', NULL, 'AL SAMI LLC', '0', 'DEF', '2022-07-09', '4', '35100', '0', '0');

### Structure of table `0_sales_pos` ###

DROP TABLE IF EXISTS `0_sales_pos`;

CREATE TABLE `0_sales_pos` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `pos_name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `cash_sale` tinyint(1) NOT NULL,
  `credit_sale` tinyint(1) NOT NULL,
  `pos_location` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `pos_account` smallint(6) unsigned NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pos_name` (`pos_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_pos` ###

INSERT INTO `0_sales_pos` VALUES
('1', 'Default', '1', '1', 'DEF', '2', '0');

### Structure of table `0_sales_types` ###

DROP TABLE IF EXISTS `0_sales_types`;

CREATE TABLE `0_sales_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sales_type` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tax_included` int(1) NOT NULL DEFAULT 0,
  `factor` double NOT NULL DEFAULT 1,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sales_type` (`sales_type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sales_types` ###

INSERT INTO `0_sales_types` VALUES
('1', 'Retail', '1', '1', '0'),
('2', 'Wholesale', '0', '0.7', '0');

### Structure of table `0_salesman` ###

DROP TABLE IF EXISTS `0_salesman`;

CREATE TABLE `0_salesman` (
  `salesman_code` int(11) NOT NULL AUTO_INCREMENT,
  `salesman_name` char(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_phone` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_fax` char(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `salesman_email` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `provision` double NOT NULL DEFAULT 0,
  `break_pt` double NOT NULL DEFAULT 0,
  `provision2` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`salesman_code`),
  UNIQUE KEY `salesman_name` (`salesman_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_salesman` ###

INSERT INTO `0_salesman` VALUES
('1', 'Sales Person', '', '', '', '5', '1000', '4', '0');

### Structure of table `0_security_roles` ###

DROP TABLE IF EXISTS `0_security_roles`;

CREATE TABLE `0_security_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `role` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sections` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `areas` text COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `role` (`role`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_security_roles` ###

INSERT INTO `0_security_roles` VALUES
('1', 'Inquiries', 'Inquiries', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128', '257;258;259;260;513;514;515;516;517;518;519;520;521;522;523;524;525;773;774;2822;3073;3075;3076;3077;3329;3330;3331;3332;3333;3334;3335;5377;5633;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8450;8451;10497;10753;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15622;15623;15624;15625;15626;15873;15882;16129;16130;16131;16132;775', '0'),
('2', 'System Administrator', 'System Administrator', '256;512;768;15616;15872;16128;353280;353536;353792;354048', '513;514;515;516;517;518;519;520;521;522;523;524;525;526;769;770;771;772;773;774;775;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;16129;16130;16131;16132;353380;353381;353382;353383;353384;353385;353386;353387;353650;353651;353652;353653;353654;353900;353901;353902;353903;353904;353905;354167;354168;354169;354170;354171;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9473;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;287844;287845', '0'),
('3', 'Salesman', 'Salesman', '768;3072;5632;8192;15872', '773;774;3073;3075;3081;5633;8194;15873;775', '0'),
('4', 'Stock Manager', 'Stock Manager', '768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15872;16128', '2818;2822;3073;3076;3077;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5640;5889;5890;5891;8193;8194;8450;8451;10753;11009;11010;11012;13313;13315;15882;16129;16130;16131;16132;775', '0'),
('5', 'Production Manager', 'Production Manager', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;2818;2819;2820;2821;2822;2823;3073;3074;3076;3077;3078;3079;3080;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5640;5640;5889;5890;5891;8193;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15876;15877;15880;15882;16129;16130;16131;16132;775', '0'),
('6', 'Purchase Officer', 'Purchase Officer', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;2818;2819;2820;2821;2822;2823;3073;3074;3076;3077;3078;3079;3080;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5377;5633;5635;5640;5640;5889;5890;5891;8193;8194;8196;8197;8449;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15876;15877;15880;15882;16129;16130;16131;16132;775', '0'),
('7', 'AR Officer', 'AR Officer', '512;768;2816;3072;3328;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '521;523;524;771;773;774;2818;2819;2820;2821;2822;2823;3073;3073;3074;3075;3076;3077;3078;3079;3080;3081;3081;3329;3330;3330;3330;3331;3331;3332;3333;3334;3335;5633;5633;5634;5637;5638;5639;5640;5640;5889;5890;5891;8193;8194;8194;8196;8197;8450;8451;10753;10755;11009;11010;11012;13313;13315;15617;15619;15620;15621;15624;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('8', 'AP Officer', 'AP Officer', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;769;770;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5635;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15876;15877;15880;15882;16129;16130;16131;16132;775', '0'),
('9', 'Accountant', 'New Accountant', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13313;13315;15617;15618;15619;15620;15621;15624;15873;15876;15877;15878;15880;15882;16129;16130;16131;16132;775', '0'),
('10', 'Sub Admin', 'Sub Admin', '512;768;2816;3072;3328;5376;5632;5888;8192;8448;10752;11008;13312;15616;15872;16128', '257;258;259;260;521;523;524;771;772;773;774;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5637;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8196;8197;8449;8450;8451;10497;10753;10755;11009;11010;11012;13057;13313;13315;15617;15619;15620;15621;15624;15873;15874;15876;15877;15878;15879;15880;15882;16129;16130;16131;16132;775', '0'),
('11', 'Trading', 'Trading', '2816;3072;3328;5376;5632;5888;7936;8192;8448;15616;15872;16128;287744', '2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15882;15884;16129;16130;16131;16132;287844;287845', '0'),
('12', 'ERP', 'ERP', '15616;15872;16128;353280;353536;353792;354048', '15617;15618;15619;15620;15621;15622;15623;15624;15628;15625;15626;15627;15630;15873;15874;15875;15876;15877;15878;15879;15880;15883;15881;15884;16129;16130;16131;16132;353380;353381;353382;353383;353384;353385;353386;353387;353650;353651;353652;353653;353654;353900;353901;353902;353903;353904;353905;354167;354168;354169;354170;354171;2817;2818;2819;2820;2821;2822;2823;3073;3074;3082;3075;3076;3077;3078;3079;3080;3081;3329;3330;3331;3332;3333;3334;3335;5377;5633;5634;5635;5636;5637;5641;5638;5639;5640;5889;5890;5891;7937;7938;7939;7940;8193;8194;8195;8196;8197;8449;8450;8451;9217;9218;9220;9474;9475;9476;9729;10497;10753;10754;10755;10756;10757;11009;11010;11011;11012;13057;13313;13314;13315;287844;287845', '0'),
('13', 'IT Assistant', 'Assistant ', '256;512;768', '260', '0'),
('14', 'IT Administrator', 'Administrator', '256;512;768', '257;258;259;260;770;771;774', '0'),
('15', 'Employee', 'Employee', '354048', '354167', '0');

### Structure of table `0_shippers` ###

DROP TABLE IF EXISTS `0_shippers`;

CREATE TABLE `0_shippers` (
  `shipper_id` int(11) NOT NULL AUTO_INCREMENT,
  `shipper_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone2` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`shipper_id`),
  UNIQUE KEY `name` (`shipper_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_shippers` ###

INSERT INTO `0_shippers` VALUES
('1', 'Default', '', '', '', '', '0');

### Structure of table `0_sql_trail` ###

DROP TABLE IF EXISTS `0_sql_trail`;

CREATE TABLE `0_sql_trail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sql` text COLLATE utf8_unicode_ci NOT NULL,
  `result` tinyint(1) NOT NULL,
  `msg` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sql_trail` ###


### Structure of table `0_stock_category` ###

DROP TABLE IF EXISTS `0_stock_category`;

CREATE TABLE `0_stock_category` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_tax_type` int(11) NOT NULL DEFAULT 1,
  `dflt_units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `dflt_mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `dflt_sales_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_cogs_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_inventory_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_adjustment_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_wip_act` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dflt_dim1` int(11) DEFAULT NULL,
  `dflt_dim2` int(11) DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `dflt_no_sale` tinyint(1) NOT NULL DEFAULT 0,
  `dflt_no_purchase` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `description` (`description`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_category` ###

INSERT INTO `0_stock_category` VALUES
('1', 'Components', '1', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('2', 'Charges', '1', 'each', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('3', 'Systems', '1', 'each', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('4', 'Services', '1', 'hr', 'D', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0'),
('5', 'Machanical', '1', 'each', 'F', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '0', '0');

### Structure of table `0_stock_fa_class` ###

DROP TABLE IF EXISTS `0_stock_fa_class`;

CREATE TABLE `0_stock_fa_class` (
  `fa_class_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `parent_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `depreciation_rate` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`fa_class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_fa_class` ###

INSERT INTO `0_stock_fa_class` VALUES
('001', '01', 'Equipment', 'Equipment', '10', '0');

### Structure of table `0_stock_master` ###

DROP TABLE IF EXISTS `0_stock_master`;

CREATE TABLE `0_stock_master` (
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `description` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `long_description` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `units` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'each',
  `mb_flag` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'B',
  `sales_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `cogs_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inventory_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `adjustment_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `wip_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `dimension_id` int(11) DEFAULT NULL,
  `dimension2_id` int(11) DEFAULT NULL,
  `purchase_cost` double NOT NULL DEFAULT 0,
  `material_cost` double NOT NULL DEFAULT 0,
  `labour_cost` double NOT NULL DEFAULT 0,
  `overhead_cost` double NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  `no_sale` tinyint(1) NOT NULL DEFAULT 0,
  `no_purchase` tinyint(1) NOT NULL DEFAULT 0,
  `editable` tinyint(1) NOT NULL DEFAULT 0,
  `depreciation_method` char(1) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'S',
  `depreciation_rate` double NOT NULL DEFAULT 0,
  `depreciation_factor` double NOT NULL DEFAULT 1,
  `depreciation_start` date NOT NULL DEFAULT '0000-00-00',
  `depreciation_date` date NOT NULL DEFAULT '0000-00-00',
  `fa_class_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`stock_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_master` ###

INSERT INTO `0_stock_master` VALUES
('101', '1', '1', 'abc', 'test', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '9464', '9464', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('1202', '1', '1', 'asad', 'wfds', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '85176', '15385.608938547', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('14121', '2', '1', 'gum ', 'test ', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '1', '0', '94640', '94640', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('187', '1', '1', 'KFT', 'TEST', 'each', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '400', '24933.268027116', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('201', '1', '1', 'Cement', 'TEST', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '1', '0', '94640', '126633.64996994', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('20147', '1', '1', 'Silicon', 'test', 'MT', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '75712', '75712', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('78540', '1', '1', 'MG 17', 'test', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '1', '0', '75712', '56784', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('9787', '1', '1', 'Chemical 1', 'test', 'KG', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '28392', '209472.02124833', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('F-001', '5', '1', 'Generator', 'Generator', 'each', 'F', '4010', '5010', '1510', '5040', '1530', '0', '0', '100000', '55555.56', '0', '0', '0', '0', '0', '0', 'N', '2', '0', '2022-04-01', '2022-12-31', '001'),
('IT-1001', '1', '1', 'New item A', 'New item A', 'each', 'B', '4010', '5010', '1510', '5040', '1530', '0', '0', '28392', '28392', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('T-0001', '3', '1', 'First Item', '', 'each', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '0', '1249114.6362842', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('T-0002', '1', '1', 'Cap', 'Cap', 'each', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '946400', '946400', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('T-0003', '1', '1', 'Sticker', 'Sticker', 'each', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '113568', '113568', '0', '0', '0', '0', '0', '1', '', '0', '0', '0000-00-00', '0000-00-00', ''),
('T-0004', '1', '1', 'Carton', 'Carton', 'each', 'M', '4010', '5010', '1510', '5040', '1530', '0', '0', '18928', '26585.893129771', '0', '0', '0', '0', '0', '0', '', '0', '0', '0000-00-00', '0000-00-00', '');

### Structure of table `0_stock_moves` ###

DROP TABLE IF EXISTS `0_stock_moves`;

CREATE TABLE `0_stock_moves` (
  `trans_id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `type` smallint(6) NOT NULL DEFAULT 0,
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `price` double NOT NULL DEFAULT 0,
  `reference` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `qty` double NOT NULL DEFAULT 1,
  `standard_cost` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`trans_id`),
  KEY `type` (`type`,`trans_no`),
  KEY `Move` (`stock_id`,`loc_code`,`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_stock_moves` ###

INSERT INTO `0_stock_moves` VALUES
('1', '1', '14121', '25', 'DEF', '2022-05-11', '500', '', '10', '94640'),
('2', '1', '14121', '13', 'DEF', '2022-05-11', '500', '001/2022', '-10', '94640'),
('3', '2', '201', '25', 'DEF', '2022-05-17', '500', '', '5000', '94640'),
('4', '2', '9787', '25', 'DEF', '2022-05-17', '200', '', '1000', '37856'),
('5', '2', '20147', '25', 'DEF', '2022-05-17', '400', '', '1000', '75712'),
('6', '3', 'T-0002', '25', 'DEF', '2022-05-17', '5000', '', '10000', '946400'),
('7', '4', 'T-0003', '25', 'DEF', '2022-05-17', '600', '', '10000', '113568'),
('8', '5', 'T-0004', '25', 'DEF', '2022-05-17', '400', '', '1', '75712'),
('9', '6', 'T-0004', '25', 'DEF', '2022-05-17', '400', '', '1000', '75712'),
('10', '1', 'T-0002', '29', 'DEF', '2022-05-17', '0', '', '-1000', '946400'),
('11', '1', 'T-0003', '29', 'DEF', '2022-05-17', '0', '', '-2000', '113568'),
('12', '1', 'T-0004', '29', 'DEF', '2022-05-17', '0', '', '-1000', '75712'),
('13', '1', 'T-0001', '26', 'DEF', '2022-05-17', '0', '001/2022', '1000', '1249358'),
('14', '7', '201', '25', 'DEF', '2022-05-19', '15000', '', '100', '148454.90196078'),
('15', '7', '9787', '25', 'DEF', '2022-05-19', '7500', '', '50', '103653.33333333'),
('16', '8', '101', '25', 'DEF', '2022-05-20', '50', '', '1000', '9464'),
('17', '9', '1202', '25', 'DEF', '2022-05-20', '75', '', '1000', '14196'),
('18', '1', '101', '28', 'DEF', '2022-05-20', '0', '', '-10', '9464'),
('19', '2', '1202', '28', 'DEF', '2022-05-20', '0', '', '-10', '14196'),
('20', '2', '101', '29', 'DEF', '2022-05-20', '0', '', '-10', '9464'),
('21', '2', '1202', '29', 'DEF', '2022-05-20', '0', '', '-10', '14196'),
('22', '2', '187', '26', 'DEF', '2022-05-20', '0', '002/2022', '10', '47320'),
('23', '1', 'T-0004', '17', 'DEF', '2022-05-20', '0', '001/2022', '50', '75712'),
('24', '1', '201', '17', 'DEF', '2022-05-20', '0', '001/2022', '50', '148454.90196078'),
('25', '1', '9787', '17', 'DEF', '2022-05-20', '0', '001/2022', '50', '103653.33333333'),
('26', '3', 'T-0004', '28', 'DEF', '2022-05-20', '0', 'add carton', '-50', '75712'),
('27', '4', '201', '28', 'DEF', '2022-05-20', '0', 'add cement', '-5', '148454.90196078'),
('28', '3', 'T-0002', '29', 'DEF', '2022-05-20', '0', '', '10', '946400'),
('29', '3', 'T-0003', '29', 'DEF', '2022-05-20', '0', '', '20', '113568'),
('30', '3', 'T-0004', '29', 'DEF', '2022-05-20', '0', '', '10', '75712'),
('31', '10', '9787', '25', 'DEF', '2022-05-20', '150', '', '10', '102975.3033033'),
('32', '10', '78540', '25', 'DEF', '2022-05-20', '250', '', '100', '47320'),
('33', '2', '187', '13', 'DEF', '2022-05-20', '0', '002/2022', '-1', '47320'),
('34', '4', '101', '29', 'DEF', '2022-05-20', '0', '', '-100', '9464'),
('35', '4', '1202', '29', 'DEF', '2022-05-20', '0', '', '-100', '14196'),
('36', '4', '187', '26', 'DEF', '2022-05-20', '0', '004/2022', '100', '23750'),
('37', '11', 'T-0004', '25', 'DEF', '2022-05-20', '300', '', '10', '66698.666666667'),
('38', '11', '1202', '25', 'DEF', '2022-05-20', '450', '', '15', '15385.608938547'),
('39', '11', 'T-0004', '25', 'DEF', '2022-05-20', '100', '', '10', '51288.774193549'),
('40', '3', '201', '13', 'DEF', '2022-05-20', '800', 'auto', '-10', '148454.90196078'),
('41', '3', 'T-0002', '13', 'DEF', '2022-05-20', '450', 'auto', '-2', '946400'),
('42', '12', 'IT-1001', '25', 'DEF', '2022-05-22', '150', '', '1', '28392'),
('43', '13', '9787', '25', 'DEF', '2022-05-22', '150', '', '20', '101655.24483775'),
('44', '13', '78540', '25', 'DEF', '2022-05-22', '400', '', '50', '56784'),
('45', '14', '9787', '25', 'DEF', '2022-06-02', '1280', '', '25', '104699.03607503'),
('46', '15', '9787', '25', 'DEF', '2022-06-03', '7500', '', '100', '209472.02124833'),
('47', '15', 'T-0004', '25', 'DEF', '2022-06-03', '100', '', '100', '26585.893129771'),
('48', '16', '201', '25', 'DEF', '2022-06-06', '820.512825', '', '400', '137785.74987689'),
('49', '4', '78540', '13', 'DEF', '2022-06-08', '100', 'auto', '-100', '56784'),
('50', '5', '9787', '13', 'DEF', '2022-06-08', '500', 'auto', '-100', '209472.02124833'),
('51', '6', '101', '13', 'DEF', '2022-06-08', '50', 'auto', '-100', '9464'),
('52', '17', '201', '25', 'DEF', '2022-06-09', '16.8', '', '500', '126633.64996994'),
('53', '7', '187', '13', 'DEF', '2022-06-09', '400', 'auto', '-100', '25696.146788991'),
('54', '5', '101', '29', 'DEF', '2022-06-09', '0', '', '-100', '9464'),
('55', '5', '1202', '29', 'DEF', '2022-06-09', '0', '', '-100', '15385.608938547'),
('56', '5', '187', '26', 'DEF', '2022-06-09', '0', '005/2022', '100', '24864.608938547'),
('57', '6', 'T-0002', '29', 'DEF', '2022-06-10', '0', '', '-5', '946400'),
('58', '6', 'T-0003', '29', 'DEF', '2022-06-10', '0', '', '-10', '113568'),
('59', '6', 'T-0004', '29', 'DEF', '2022-06-10', '0', '', '-5', '26585.893129771'),
('60', '6', 'T-0001', '26', 'DEF', '2022-06-10', '0', '006/2022', '5', '1200441.8931298'),
('61', '18', 'T-0002', '25', 'DEF', '2022-06-15', '5000', '', '1', '946400');

### Structure of table `0_supp_allocations` ###

DROP TABLE IF EXISTS `0_supp_allocations`;

CREATE TABLE `0_supp_allocations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) DEFAULT NULL,
  `amt` double unsigned DEFAULT NULL,
  `date_alloc` date NOT NULL DEFAULT '0000-00-00',
  `trans_no_from` int(11) DEFAULT NULL,
  `trans_type_from` int(11) DEFAULT NULL,
  `trans_no_to` int(11) DEFAULT NULL,
  `trans_type_to` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `trans_type_from` (`person_id`,`trans_type_from`,`trans_no_from`,`trans_type_to`,`trans_no_to`),
  KEY `From` (`trans_type_from`,`trans_no_from`),
  KEY `To` (`trans_type_to`,`trans_no_to`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_allocations` ###

INSERT INTO `0_supp_allocations` VALUES
('1', '1', '5850', '2022-05-11', '1', '22', '1', '20'),
('2', '1', '58500000', '2022-05-20', '2', '22', '3', '20'),
('3', '1', '7020000', '2022-05-20', '2', '22', '4', '20'),
('4', '1', '468', '2022-05-20', '2', '22', '5', '20'),
('5', '1', '468000', '2022-05-20', '2', '22', '6', '20'),
('6', '1', '58500', '2022-05-20', '2', '22', '7', '20'),
('8', '2', '31005', '2022-05-20', '3', '22', '9', '20'),
('10', '3', '3627000', '2022-05-20', '4', '22', '2', '20'),
('11', '3', '8000', '2022-05-20', '4', '22', '10', '20'),
('12', '3', '117', '2022-05-20', '4', '22', '8', '18'),
('13', '1', '175.5', '2022-05-22', '2', '22', '11', '20'),
('14', '1', '87750', '2022-05-22', '5', '22', '8', '20'),
('15', '1', '50000', '2022-05-22', '5', '22', '18', '18'),
('16', '1', '187.2', '2022-05-22', '5', '22', '15', '18'),
('17', '2', '26910', '2022-05-22', '3', '22', '12', '20');

### Structure of table `0_supp_invoice_items` ###

DROP TABLE IF EXISTS `0_supp_invoice_items`;

CREATE TABLE `0_supp_invoice_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_trans_no` int(11) DEFAULT NULL,
  `supp_trans_type` int(11) DEFAULT NULL,
  `gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `grn_item_id` int(11) DEFAULT NULL,
  `po_detail_item_id` int(11) DEFAULT NULL,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` tinytext COLLATE utf8_unicode_ci DEFAULT NULL,
  `quantity` double NOT NULL DEFAULT 0,
  `unit_price` double NOT NULL DEFAULT 0,
  `unit_tax` double NOT NULL DEFAULT 0,
  `memo_` tinytext COLLATE utf8_unicode_ci DEFAULT NULL,
  `dimension_id` int(11) NOT NULL DEFAULT 0,
  `dimension2_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `Transaction` (`supp_trans_type`,`supp_trans_no`,`stock_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_invoice_items` ###

INSERT INTO `0_supp_invoice_items` VALUES
('1', '1', '20', '0', '1', '2', '14121', 'gum ', '10', '500', '85', NULL, '0', '0'),
('2', '2', '20', '0', '2', '3', '201', 'Cement', '5000', '500', '85', NULL, '0', '0'),
('3', '2', '20', '0', '3', '4', '9787', 'Chemical 1', '1000', '200', '34', NULL, '0', '0'),
('4', '2', '20', '0', '4', '5', '20147', 'Silicon', '1000', '400', '68', NULL, '0', '0'),
('5', '3', '20', '0', '5', '6', 'T-0002', 'Cap', '10000', '5000', '850', NULL, '0', '0'),
('6', '4', '20', '0', '6', '7', 'T-0003', 'Sticker', '10000', '600', '102', NULL, '0', '0'),
('7', '5', '20', '0', '7', '8', 'T-0004', 'Carton', '1', '400', '68', NULL, '0', '0'),
('8', '6', '20', '0', '8', '9', 'T-0004', 'Carton', '1000', '400', '68', NULL, '0', '0'),
('9', '7', '20', '0', '11', '13', '101', 'abc', '1000', '50', '8.5', NULL, '0', '0'),
('10', '8', '20', '0', '12', '14', '1202', 'asad', '1000', '75', '12.75', NULL, '0', '0'),
('11', '9', '20', '0', '13', '17', '9787', 'Chemical 1', '10', '150', '25.5', NULL, '0', '0'),
('12', '9', '20', '0', '14', '18', '78540', 'MG 17', '100', '250', '42.5', NULL, '0', '0'),
('13', '10', '20', '0', '15', '19', 'T-0004', 'Carton', '10', '300', '51', NULL, '0', '0'),
('14', '10', '20', '0', '16', '20', '1202', 'asad', '15', '450', '76.5', NULL, '0', '0'),
('15', '10', '20', '0', '17', '21', 'T-0004', 'Carton', '10', '100', '17', NULL, '0', '0'),
('16', '11', '20', '0', '18', '1', 'IT-1001', 'New item A', '1', '150', '25.5', NULL, '0', '0'),
('17', '12', '20', '0', '19', '15', '9787', 'Chemical 1', '20', '150', '25.5', NULL, '0', '0'),
('18', '12', '20', '0', '20', '16', '78540', 'MG 17', '50', '400', '68', NULL, '0', '0'),
('19', '13', '20', '0', '26', '42', 'T-0002', 'Cap', '1', '5000', '850', NULL, '0', '0');

### Structure of table `0_supp_trans` ###

DROP TABLE IF EXISTS `0_supp_trans`;

CREATE TABLE `0_supp_trans` (
  `trans_no` int(11) unsigned NOT NULL DEFAULT 0,
  `type` smallint(6) unsigned NOT NULL DEFAULT 0,
  `supplier_id` int(11) unsigned NOT NULL,
  `reference` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_reference` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `tran_date` date NOT NULL DEFAULT '0000-00-00',
  `due_date` date NOT NULL DEFAULT '0000-00-00',
  `ov_amount` double NOT NULL DEFAULT 0,
  `ov_discount` double NOT NULL DEFAULT 0,
  `ov_gst` double NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 1,
  `alloc` double NOT NULL DEFAULT 0,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`type`,`trans_no`,`supplier_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_supp_trans` ###

INSERT INTO `0_supp_trans` VALUES
('1', '20', '1', '001/2022', '127', '2022-05-11', '2022-05-11', '5000', '0', '850', '189.28', '5850', '0'),
('2', '20', '3', '002/2022', '782510', '2022-05-17', '2022-05-17', '3100000', '0', '527000', '189.28', '3627000', '0'),
('3', '20', '1', '003/2022', '244', '2022-05-17', '2022-05-17', '50000000', '0', '8500000', '189.28', '58500000', '0'),
('4', '20', '1', '004/2022', '98720', '2022-05-17', '2022-05-17', '6000000', '0', '1020000', '189.28', '7020000', '0'),
('5', '20', '1', '005/2022', '03654', '2022-05-17', '2022-05-17', '400', '0', '68', '189.28', '468', '0'),
('6', '20', '1', '006/2022', '45754', '2022-05-17', '2022-05-17', '400000', '0', '68000', '189.28', '468000', '0'),
('7', '20', '1', '007/2022', '51651', '2022-05-20', '2022-05-20', '50000', '0', '8500', '189.28', '58500', '0'),
('8', '20', '1', '008/2022', '1540', '2022-05-20', '2022-05-20', '75000', '0', '12750', '189.28', '87750', '0'),
('9', '20', '2', '009/2022', '430', '2022-05-20', '2022-05-20', '26500', '0', '4505', '189.28', '31005', '0'),
('10', '20', '3', '010/2022', '9086', '2022-05-20', '2022-05-20', '10750', '0', '1827.5', '189.28', '8000', '0'),
('11', '20', '1', '011/2022', '0976', '2022-05-22', '2022-05-22', '150', '0', '25.5', '189.28', '175.5', '0'),
('12', '20', '2', '012/2022', '6753', '2022-05-22', '2022-05-22', '23000', '0', '3910', '189.28', '26910', '0'),
('13', '20', '2', '013/2022', '8574', '2022-06-15', '2022-06-15', '5000', '0', '850', '189.28', '0', '0'),
('1', '22', '1', '001/2022', '', '2022-05-11', '2022-05-11', '-5850', '0', '0', '189.28', '5850', '0'),
('2', '22', '1', '002/2022', '', '2022-05-20', '2022-05-20', '-66047143.5', '0', '0', '189.28', '66047143.5', '0'),
('3', '22', '2', '003/2022', '', '2022-05-20', '2022-05-20', '-57915', '0', '0', '189.28', '57915', '0'),
('4', '22', '3', '004/2022', '', '2022-05-20', '2022-05-20', '-3635117', '0', '0', '189.28', '3635117', '0'),
('5', '22', '1', '005/2022', '', '2022-05-22', '2022-05-22', '-137937.2', '0', '0', '189.28', '137937.2', '0');

### Structure of table `0_suppliers` ###

DROP TABLE IF EXISTS `0_suppliers`;

CREATE TABLE `0_suppliers` (
  `supplier_id` int(11) NOT NULL AUTO_INCREMENT,
  `supp_name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_ref` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `supp_address` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `gst_no` varchar(25) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `supp_account_no` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `website` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `bank_account` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `curr_code` char(3) COLLATE utf8_unicode_ci DEFAULT NULL,
  `payment_terms` int(11) DEFAULT NULL,
  `tax_included` tinyint(1) NOT NULL DEFAULT 0,
  `dimension_id` int(11) DEFAULT 0,
  `dimension2_id` int(11) DEFAULT 0,
  `tax_group_id` int(11) DEFAULT NULL,
  `credit_limit` double NOT NULL DEFAULT 0,
  `purchase_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payable_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `payment_discount_account` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `notes` tinytext COLLATE utf8_unicode_ci NOT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`supplier_id`),
  KEY `supp_ref` (`supp_ref`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_suppliers` ###

INSERT INTO `0_suppliers` VALUES
('1', 'Supp A', 'Supp A', 'abc1234', '', '', '', '', '', '', 'USD', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0'),
('2', 'Supp B', 'Supp B', '', '', '', '', '', '', '', 'USD', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0'),
('3', 'Talha', 'Twisting', '', '', '', '', '', '', '', 'USD', '4', '0', '0', '0', '1', '0', '', '2100', '5060', '', '0'),
('4', 'ZA Associates', 'ZA', '139 k wapda town', '', '3215641', '', '', '', '1007849756', 'PKR', '4', '1', '0', '0', '1', '0', '', '2100', '5060', '', '0');

### Structure of table `0_sys_prefs` ###

DROP TABLE IF EXISTS `0_sys_prefs`;

CREATE TABLE `0_sys_prefs` (
  `name` varchar(35) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `category` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `length` smallint(6) DEFAULT NULL,
  `value` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`name`),
  KEY `category` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_sys_prefs` ###

INSERT INTO `0_sys_prefs` VALUES
('accounts_alpha', 'glsetup.general', 'tinyint', '1', '0'),
('accumulate_shipping', 'glsetup.customer', 'tinyint', '1', '0'),
('add_pct', 'setup.company', 'int', '5', '-1'),
('allow_negative_prices', 'glsetup.inventory', 'tinyint', '1', '1'),
('allow_negative_stock', 'glsetup.inventory', 'tinyint', '1', '0'),
('alternative_tax_include_on_docs', 'setup.company', 'tinyint', '1', ''),
('auto_curr_reval', 'setup.company', 'smallint', '6', '1'),
('bank_charge_act', 'glsetup.general', 'varchar', '15', '5690'),
('barcodes_on_stock', 'setup.company', 'tinyint', '1', '0'),
('base_sales', 'setup.company', 'int', '11', '1'),
('bcc_email', 'setup.company', 'varchar', '100', ''),
('company_logo_report', 'setup.company', 'tinyint', '1', '1'),
('coy_logo', 'setup.company', 'varchar', '100', 'kv_logo.png'),
('coy_name', 'setup.company', 'varchar', '60', 'digitleysystem'),
('coy_no', 'setup.company', 'varchar', '25', ''),
('creditors_act', 'glsetup.purchase', 'varchar', '15', '2100'),
('curr_default', 'setup.company', 'char', '3', 'PKR'),
('debtors_act', 'glsetup.sales', 'varchar', '15', '1200'),
('default_adj_act', 'glsetup.items', 'varchar', '15', '5040'),
('default_cogs_act', 'glsetup.items', 'varchar', '15', '5010'),
('default_credit_limit', 'glsetup.customer', 'int', '11', '1000'),
('default_delivery_required', 'glsetup.sales', 'smallint', '6', '1'),
('default_dim_required', 'glsetup.dims', 'int', '11', '20'),
('default_inv_sales_act', 'glsetup.items', 'varchar', '15', '4010'),
('default_inventory_act', 'glsetup.items', 'varchar', '15', '1510'),
('default_loss_on_asset_disposal_act', 'glsetup.items', 'varchar', '15', '5660'),
('default_prompt_payment_act', 'glsetup.sales', 'varchar', '15', '4500'),
('default_quote_valid_days', 'glsetup.sales', 'smallint', '6', '30'),
('default_receival_required', 'glsetup.purchase', 'smallint', '6', '10'),
('default_sales_act', 'glsetup.sales', 'varchar', '15', '4010'),
('default_sales_discount_act', 'glsetup.sales', 'varchar', '15', '4510'),
('default_wip_act', 'glsetup.items', 'varchar', '15', '1530'),
('default_workorder_required', 'glsetup.manuf', 'int', '11', '20'),
('deferred_income_act', 'glsetup.sales', 'varchar', '15', '2105'),
('depreciation_period', 'glsetup.company', 'tinyint', '1', '1'),
('dim_on_recurrent_invoice', 'setup.company', 'tinyint', '1', '0'),
('dim1_name', 'setup.company', 'tinyint', '1', 'Dimension'),
('dim2_name', 'setup.company', 'tinyint', '1', 'Dimension 2'),
('domicile', 'setup.company', 'varchar', '55', ''),
('email', 'setup.company', 'varchar', '100', ''),
('exchange_diff_act', 'glsetup.general', 'varchar', '15', '4450'),
('f_year', 'setup.company', 'int', '11', '3'),
('fax', 'setup.company', 'varchar', '30', ''),
('freight_act', 'glsetup.customer', 'varchar', '15', '4430'),
('gl_closing_date', 'setup.closing_date', 'date', '8', ''),
('grn_clearing_act', 'glsetup.purchase', 'varchar', '15', '1550'),
('gst_no', 'setup.company', 'varchar', '25', ''),
('legal_text', 'glsetup.customer', 'tinytext', '0', ''),
('loc_notification', 'glsetup.inventory', 'tinyint', '1', ''),
('login_tout', 'setup.company', 'smallint', '6', '6000000'),
('long_description_invoice', 'setup.company', 'tinyint', '1', '0'),
('max_days_in_docs', 'setup.company', 'smallint', '5', '180'),
('no_customer_list', 'setup.company', 'tinyint', '1', '0'),
('no_item_list', 'setup.company', 'tinyint', '1', '1'),
('no_supplier_list', 'setup.company', 'tinyint', '1', '0'),
('no_zero_lines_amount', 'glsetup.sales', 'tinyint', '1', '1'),
('past_due_days', 'glsetup.general', 'int', '11', '30'),
('phone', 'setup.company', 'varchar', '30', ''),
('po_over_charge', 'glsetup.purchase', 'int', '11', '10'),
('po_over_receive', 'glsetup.purchase', 'int', '11', '10'),
('postal_address', 'setup.company', 'tinytext', '0', 'N/A'),
('print_dialog_direct', 'setup.company', 'tinyint', '1', '0'),
('print_invoice_no', 'glsetup.sales', 'tinyint', '1', '0'),
('print_item_images_on_quote', 'glsetup.inventory', 'tinyint', '1', ''),
('profit_loss_year_act', 'glsetup.general', 'varchar', '15', '9990'),
('pyt_discount_act', 'glsetup.purchase', 'varchar', '15', '5060'),
('ref_no_auto_increase', 'setup.company', 'tinyint', '1', '0'),
('retained_earnings_act', 'glsetup.general', 'varchar', '15', '3590'),
('round_to', 'setup.company', 'int', '5', '1'),
('shortname_name_in_list', 'setup.company', 'tinyint', '1', ''),
('show_po_item_codes', 'glsetup.purchase', 'tinyint', '1', ''),
('suppress_tax_rates', 'setup.company', 'tinyint', '1', ''),
('tax_algorithm', 'glsetup.customer', 'tinyint', '1', '1'),
('tax_last', 'setup.company', 'int', '11', '1'),
('tax_prd', 'setup.company', 'int', '11', '1'),
('time_zone', 'setup.company', 'tinyint', '1', '0'),
('use_dimension', 'setup.company', 'tinyint', '1', '0'),
('use_fixed_assets', 'setup.company', 'tinyint', '1', ''),
('use_manufacturing', 'setup.company', 'tinyint', '1', ''),
('version_id', 'system', 'varchar', '11', '2.4.1');

### Structure of table `0_tag_associations` ###

DROP TABLE IF EXISTS `0_tag_associations`;

CREATE TABLE `0_tag_associations` (
  `record_id` varchar(15) COLLATE utf8_unicode_ci NOT NULL,
  `tag_id` int(11) NOT NULL,
  PRIMARY KEY (`record_id`,`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tag_associations` ###


### Structure of table `0_tags` ###

DROP TABLE IF EXISTS `0_tags`;

CREATE TABLE `0_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` smallint(6) NOT NULL,
  `name` varchar(30) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(60) COLLATE utf8_unicode_ci DEFAULT NULL,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tags` ###


### Structure of table `0_tax_group_items` ###

DROP TABLE IF EXISTS `0_tax_group_items`;

CREATE TABLE `0_tax_group_items` (
  `tax_group_id` int(11) NOT NULL DEFAULT 0,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `tax_shipping` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`tax_group_id`,`tax_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_group_items` ###

INSERT INTO `0_tax_group_items` VALUES
('1', '1', '1');

### Structure of table `0_tax_groups` ###

DROP TABLE IF EXISTS `0_tax_groups`;

CREATE TABLE `0_tax_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_groups` ###

INSERT INTO `0_tax_groups` VALUES
('1', 'Tax', '0'),
('2', 'Tax Exempt', '0');

### Structure of table `0_tax_types` ###

DROP TABLE IF EXISTS `0_tax_types`;

CREATE TABLE `0_tax_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rate` double NOT NULL DEFAULT 0,
  `sales_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `purchasing_gl_code` varchar(15) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_tax_types` ###

INSERT INTO `0_tax_types` VALUES
('1', '17', '2150', '2150', 'Tax', '0');

### Structure of table `0_trans_tax_details` ###

DROP TABLE IF EXISTS `0_trans_tax_details`;

CREATE TABLE `0_trans_tax_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_type` smallint(6) DEFAULT NULL,
  `trans_no` int(11) DEFAULT NULL,
  `tran_date` date NOT NULL,
  `tax_type_id` int(11) NOT NULL DEFAULT 0,
  `rate` double NOT NULL DEFAULT 0,
  `ex_rate` double NOT NULL DEFAULT 1,
  `included_in_price` tinyint(1) NOT NULL DEFAULT 0,
  `net_amount` double NOT NULL DEFAULT 0,
  `amount` double NOT NULL DEFAULT 0,
  `memo` tinytext COLLATE utf8_unicode_ci DEFAULT NULL,
  `reg_type` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Type_and_Number` (`trans_type`,`trans_no`),
  KEY `tran_date` (`tran_date`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_trans_tax_details` ###

INSERT INTO `0_trans_tax_details` VALUES
('1', '20', '1', '2022-05-11', '1', '17', '189.28', '0', '5000', '850', '127', '1'),
('2', '13', '1', '2022-05-11', '0', '0', '1', '0', '5000', '0', '001/2022', NULL),
('3', '20', '2', '2022-05-17', '1', '17', '189.28', '0', '3100000', '527000', '782510', '1'),
('4', '20', '3', '2022-05-17', '1', '17', '189.28', '0', '50000000', '8500000', '244', '1'),
('5', '20', '4', '2022-05-17', '1', '17', '189.28', '0', '6000000', '1020000', '98720', '1'),
('6', '20', '5', '2022-05-17', '1', '17', '189.28', '0', '400', '68', '03654', '1'),
('7', '20', '6', '2022-05-17', '1', '17', '189.28', '0', '400000', '68000', '45754', '1'),
('8', '20', '7', '2022-05-20', '1', '17', '189.28', '0', '50000', '8500', '51651', '1'),
('9', '20', '8', '2022-05-20', '1', '17', '189.28', '0', '75000', '12750', '1540', '1'),
('10', '20', '9', '2022-05-20', '1', '17', '189.28', '0', '26500', '4505', '430', '1'),
('11', '20', '10', '2022-05-20', '1', '17', '189.28', '0', '10750', '1827.5', '9086', '1'),
('12', '13', '3', '2022-05-20', '0', '0', '1', '0', '8900', '0', 'auto', NULL),
('13', '10', '1', '2022-05-20', '0', '0', '1', '0', '8900', '0', '001/2022', '0'),
('14', '20', '11', '2022-05-22', '1', '17', '189.28', '0', '150', '25.5', '0976', '1'),
('15', '20', '12', '2022-05-22', '1', '17', '189.28', '0', '23000', '3910', '6753', '1'),
('16', '13', '4', '2022-06-08', '0', '0', '1', '0', '10000', '0', 'auto', NULL),
('17', '10', '2', '2022-06-08', '0', '0', '1', '0', '10000', '0', '002/2022', '0'),
('18', '13', '5', '2022-06-08', '1', '17', '1', '0', '50000', '8500', 'auto', NULL),
('19', '10', '3', '2022-06-08', '1', '17', '1', '0', '50000', '8500', '003/2022', '0'),
('20', '13', '6', '2022-06-08', '1', '17', '1', '0', '5000', '850', 'auto', NULL),
('21', '10', '4', '2022-06-08', '1', '17', '1', '0', '5000', '850', '004/2022', '0'),
('22', '13', '7', '2022-06-09', '1', '17', '1', '0', '45000', '7650', 'auto', NULL),
('23', '10', '5', '2022-06-09', '1', '17', '1', '0', '45000', '7650', '005/2022', '0'),
('24', '20', '13', '2022-06-15', '1', '17', '189.28', '0', '5000', '850', '8574', '1');

### Structure of table `0_useronline` ###

DROP TABLE IF EXISTS `0_useronline`;

CREATE TABLE `0_useronline` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` int(15) NOT NULL DEFAULT 0,
  `ip` varchar(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_useronline` ###


### Structure of table `0_users` ###

DROP TABLE IF EXISTS `0_users`;

CREATE TABLE `0_users` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `real_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `role_id` int(11) NOT NULL DEFAULT 1,
  `phone` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `date_format` tinyint(1) NOT NULL DEFAULT 0,
  `date_sep` tinyint(1) NOT NULL DEFAULT 0,
  `tho_sep` tinyint(1) NOT NULL DEFAULT 0,
  `dec_sep` tinyint(1) NOT NULL DEFAULT 0,
  `theme` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'LTE',
  `page_size` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'A4',
  `prices_dec` smallint(6) NOT NULL DEFAULT 2,
  `qty_dec` smallint(6) NOT NULL DEFAULT 2,
  `rates_dec` smallint(6) NOT NULL DEFAULT 4,
  `percent_dec` smallint(6) NOT NULL DEFAULT 1,
  `show_gl` tinyint(1) NOT NULL DEFAULT 1,
  `show_codes` tinyint(1) NOT NULL DEFAULT 0,
  `show_hints` tinyint(1) NOT NULL DEFAULT 0,
  `last_visit_date` datetime DEFAULT NULL,
  `query_size` tinyint(1) unsigned NOT NULL DEFAULT 10,
  `graphic_links` tinyint(1) DEFAULT 1,
  `pos` smallint(6) DEFAULT 1,
  `print_profile` varchar(30) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `rep_popup` tinyint(1) DEFAULT 1,
  `sticky_doc_date` tinyint(1) DEFAULT 0,
  `startup_tab` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `transaction_days` smallint(6) NOT NULL DEFAULT 30,
  `save_report_selections` smallint(6) NOT NULL DEFAULT 0,
  `use_date_picker` tinyint(1) NOT NULL DEFAULT 1,
  `def_print_destination` tinyint(1) NOT NULL DEFAULT 0,
  `def_print_orientation` tinyint(1) NOT NULL DEFAULT 0,
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_users` ###

INSERT INTO `0_users` VALUES
('1', 'admin', '81dc9bdb52d04dc20036dbd8313ed055', 'Administrator', '2', '', 'wrapandg@wrapandgoofficial.com', 'C', '0', '0', '0', '0', 'LTE', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2022-10-04 17:35:40', '10', '1', '1', '', '1', '0', 'system', '30', '0', '1', '0', '0', '0'),
('2', 'sales', '81dc9bdb52d04dc20036dbd8313ed055', 'salesman', '3', '', 'sales@salesman.com', 'C', '0', '0', '0', '0', 'LTE', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2022-03-30 21:01:48', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0'),
('3', 'trading', '81dc9bdb52d04dc20036dbd8313ed055', 'Trading', '11', '', NULL, 'C', '0', '0', '0', '0', 'LTE', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2022-06-16 11:36:46', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0'),
('4', 'erp1', '81dc9bdb52d04dc20036dbd8313ed055', 'ERP', '12', '', NULL, 'C', '0', '0', '0', '0', 'LTE', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2022-07-15 12:25:59', '10', '1', '1', '', '1', '0', 'orders', '30', '0', '1', '0', '0', '0'),
('11', '001', '5f4dcc3b5aa765d61d8327deb882cf99', 'Abdus ', '8', '0334212246545', 'biller1@email.com', 'C', '0', '0', '0', '0', 'LTE', 'A4', '2', '2', '4', '1', '1', '0', '0', NULL, '10', '1', '1', '1', '1', '0', '', '30', '0', '1', '0', '0', '0'),
('12', '0003', '81dc9bdb52d04dc20036dbd8313ed055', 'Umar', '8', '03017766564', NULL, 'C', '0', '0', '0', '0', 'LTE', 'A4', '2', '2', '4', '1', '1', '0', '0', '2022-07-13 10:25:01', '10', '1', '1', '', '1', '0', 'system', '30', '0', '1', '0', '0', '0'),
('13', '002', '5f4dcc3b5aa765d61d8327deb882cf99', 'Abdus', '14', '03332234325', 'abc@dummy.com', 'C', '0', '0', '0', '0', 'LTE', 'A4', '2', '2', '4', '1', '1', '0', '0', NULL, '10', '1', '1', '1', '1', '0', '', '30', '0', '1', '0', '0', '0'),
('14', 'uhrm', '81dc9bdb52d04dc20036dbd8313ed055', 'hrm', '12', '1234657896', NULL, 'C', '0', '0', '0', '0', 'LTE', 'Letter', '2', '2', '4', '1', '1', '0', '0', '2022-07-15 12:29:56', '10', '1', '1', '', '1', '0', 'system', '30', '0', '1', '0', '0', '0'),
('20', '004', '81dc9bdb52d04dc20036dbd8313ed055', 'Zaroon', '9', '03332234777', 'zr@dummy.com', 'C', '0', '0', '0', '0', 'LTE', 'A4', '2', '2', '4', '1', '1', '0', '0', NULL, '10', '1', '1', '1', '1', '0', '', '30', '0', '1', '0', '0', '0');

### Structure of table `0_voided` ###

DROP TABLE IF EXISTS `0_voided`;

CREATE TABLE `0_voided` (
  `type` int(11) NOT NULL DEFAULT 0,
  `id` int(11) NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `memo_` tinytext COLLATE utf8_unicode_ci NOT NULL,
  UNIQUE KEY `id` (`type`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_voided` ###

INSERT INTO `0_voided` VALUES
('1', '4', '2022-07-16', 'Loan Deleted.');

### Structure of table `0_wo_costing` ###

DROP TABLE IF EXISTS `0_wo_costing`;

CREATE TABLE `0_wo_costing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `cost_type` tinyint(1) NOT NULL DEFAULT 0,
  `trans_type` int(11) NOT NULL DEFAULT 0,
  `trans_no` int(11) NOT NULL DEFAULT 0,
  `factor` double NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_costing` ###

INSERT INTO `0_wo_costing` VALUES
('1', '1', '1', '0', '1', '1'),
('2', '1', '0', '0', '2', '1'),
('3', '3', '0', '0', '3', '1'),
('4', '3', '1', '0', '4', '1'),
('5', '4', '1', '0', '5', '1'),
('6', '4', '0', '0', '6', '1'),
('7', '5', '1', '0', '7', '1'),
('8', '5', '0', '0', '8', '1'),
('9', '6', '1', '0', '9', '1'),
('10', '6', '0', '0', '10', '1');

### Structure of table `0_wo_issue_items` ###

DROP TABLE IF EXISTS `0_wo_issue_items`;

CREATE TABLE `0_wo_issue_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_id` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_id` int(11) DEFAULT NULL,
  `qty_issued` double DEFAULT NULL,
  `unit_cost` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_issue_items` ###

INSERT INTO `0_wo_issue_items` VALUES
('1', '101', '1', '10', '9464'),
('2', '1202', '2', '10', '14196'),
('3', 'T-0004', '3', '50', '75712'),
('4', '201', '4', '5', '148454.90196078');

### Structure of table `0_wo_issues` ###

DROP TABLE IF EXISTS `0_wo_issues`;

CREATE TABLE `0_wo_issues` (
  `issue_no` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `loc_code` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workcentre_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`issue_no`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_issues` ###

INSERT INTO `0_wo_issues` VALUES
('1', '2', '001/2022', '2022-05-20', 'DEF', '3'),
('2', '2', '002/2022', '2022-05-20', 'DEF', '2'),
('3', '3', '003/2022', '2022-05-20', 'DEF', '4'),
('4', '3', '004/2022', '2022-05-20', 'DEF', '3');

### Structure of table `0_wo_manufacture` ###

DROP TABLE IF EXISTS `0_wo_manufacture`;

CREATE TABLE `0_wo_manufacture` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `quantity` double NOT NULL DEFAULT 0,
  `date_` date NOT NULL DEFAULT '0000-00-00',
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_manufacture` ###

INSERT INTO `0_wo_manufacture` VALUES
('1', '001/2022', '1', '1000', '2022-05-17'),
('2', '002/2022', '2', '10', '2022-05-20'),
('3', '003/2022', '3', '-10', '2022-05-20'),
('4', '004/2022', '4', '100', '2022-05-20'),
('5', '005/2022', '5', '100', '2022-06-09'),
('6', '006/2022', '6', '5', '2022-06-10');

### Structure of table `0_wo_requirements` ###

DROP TABLE IF EXISTS `0_wo_requirements`;

CREATE TABLE `0_wo_requirements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workorder_id` int(11) NOT NULL DEFAULT 0,
  `stock_id` char(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `workcentre` int(11) NOT NULL DEFAULT 0,
  `units_req` double NOT NULL DEFAULT 1,
  `unit_cost` double NOT NULL DEFAULT 0,
  `loc_code` char(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_issued` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `workorder_id` (`workorder_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_wo_requirements` ###

INSERT INTO `0_wo_requirements` VALUES
('1', '1', 'T-0002', '2', '1', '946400', 'DEF', '1000'),
('2', '1', 'T-0003', '3', '2', '113568', 'DEF', '2000'),
('3', '1', 'T-0004', '4', '1', '75712', 'DEF', '1000'),
('4', '2', '101', '1', '1', '9464', 'DEF', '10'),
('5', '2', '1202', '1', '1', '14196', 'DEF', '10'),
('6', '3', 'T-0002', '2', '1', '946400', 'DEF', '-10'),
('7', '3', 'T-0003', '3', '2', '113568', 'DEF', '-20'),
('8', '3', 'T-0004', '4', '1', '75712', 'DEF', '-10'),
('9', '4', '101', '1', '1', '9464', 'DEF', '100'),
('10', '4', '1202', '1', '1', '14196', 'DEF', '100'),
('11', '5', '101', '1', '1', '9464', 'DEF', '100'),
('12', '5', '1202', '1', '1', '15385.608938547', 'DEF', '100'),
('13', '6', 'T-0002', '2', '1', '946400', 'DEF', '5'),
('14', '6', 'T-0003', '3', '2', '113568', 'DEF', '10'),
('15', '6', 'T-0004', '4', '1', '26585.893129769996', 'DEF', '5');

### Structure of table `0_workcentres` ###

DROP TABLE IF EXISTS `0_workcentres`;

CREATE TABLE `0_workcentres` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(40) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `description` char(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `inactive` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_workcentres` ###

INSERT INTO `0_workcentres` VALUES
('1', 'Work Centre', '', '0'),
('2', 'Cap Station', 'Cap Station', '0'),
('3', 'Sticker Station', 'Sticker Station', '0'),
('4', 'Carton Station', 'Carton Station', '0');

### Structure of table `0_workorders` ###

DROP TABLE IF EXISTS `0_workorders`;

CREATE TABLE `0_workorders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wo_ref` varchar(60) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `loc_code` varchar(5) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `units_reqd` double NOT NULL DEFAULT 1,
  `stock_id` varchar(20) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `date_` date NOT NULL DEFAULT '0000-00-00',
  `type` tinyint(4) NOT NULL DEFAULT 0,
  `required_by` date NOT NULL DEFAULT '0000-00-00',
  `released_date` date NOT NULL DEFAULT '0000-00-00',
  `units_issued` double NOT NULL DEFAULT 0,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `released` tinyint(1) NOT NULL DEFAULT 0,
  `additional_costs` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wo_ref` (`wo_ref`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ;

### Data of table `0_workorders` ###

INSERT INTO `0_workorders` VALUES
('1', '001/2022', 'DEF', '1000', 'T-0001', '2022-05-17', '0', '2022-05-17', '2022-05-17', '1000', '1', '1', '0'),
('2', '002/2022', 'DEF', '10', '187', '2022-05-20', '2', '2022-06-09', '2022-05-20', '10', '1', '1', '0'),
('3', '003/2022', 'DEF', '10', 'T-0001', '2022-05-20', '2', '2022-05-20', '2022-05-20', '-10', '0', '1', '0'),
('4', '004/2022', 'DEF', '100', '187', '2022-05-20', '0', '2022-05-20', '2022-05-20', '100', '1', '1', '0'),
('5', '005/2022', 'DEF', '100', '187', '2022-06-09', '0', '2022-06-09', '2022-06-09', '100', '1', '1', '0'),
('6', '006/2022', 'DEF', '5', 'T-0001', '2022-06-10', '0', '2022-06-10', '2022-06-10', '5', '1', '1', '0');