<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_PAYMENT';
$path_to_root = "..";

include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");

include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/gl/includes/gl_ui.inc");

include_once($path_to_root . "/includes/ui.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

if (isset($_GET['ModifyTransfer'])) {
	$_SESSION['page_title'] = _($help_context = "Modify Day CLoser");
} else {
	$_SESSION['page_title'] = _($help_context = "Day CLoser Entry");
}

page($_SESSION['page_title'], false, false, "", $js);

check_db_has_bank_accounts(_("There are no bank accounts defined in the system."));

//----------------------------------------------------------------------------------------

if (isset($_GET['AddedID'])) 
{
	$trans_no = $_GET['AddedID'];
	$trans_type = ST_BANKTRANSFER;

   	display_notification_centered( _("Transfer has been entered"));

	display_note(get_gl_view_str($trans_type, $trans_no, _("&View the GL Journal Entries for this Transfer")));

   	hyperlink_no_params($_SERVER['PHP_SELF'], _("Enter &Another Transfer"));

	display_footer_exit();
}

	


// display_error($_POST['submit']);
//----------------------------------------------------------------------------------------

function gl_payment_controls($trans_no)
{
	global $Refs;
	
	if (!in_ajax()) {
		if ($trans_no) {
			$result = get_bank_trans(ST_BANKTRANSFER, $trans_no);

			if (db_num_rows($result) != 2)
				display_db_error("Bank transfer does not contain two records");

			$trans1 = db_fetch($result);
			$trans2 = db_fetch($result);

			if ($trans1["amount"] < 0) {
				$from_trans = $trans1; // from trans is the negative one
				$to_trans = $trans2;
			} else {
			$from_trans = $trans2;
				$to_trans = $trans1;
			}
			$_POST['CloserDate'] = sql2date($to_trans['trans_date']);
			$_POST['ref'] = $to_trans['ref'];
			$_POST['memo_'] = get_comments_string($to_trans['type'], $trans_no);
			$_POST['FromBankAccount'] = $from_trans['bank_act'];
			$_POST['ToBankAccount'] = $to_trans['bank_act'];
			$_POST['target_amount'] = price_format($to_trans['amount']);
			$_POST['amount'] = price_format(-$from_trans['amount']);
		} else {
			$_POST['ref'] = $Refs->get_next(ST_BANKTRANSFER, null, get_post('CloserDate'));
			$_POST['memo_'] = '';
			$_POST['FromBankAccount'] = 0;
			$_POST['ToBankAccount'] = 0;
			$_POST['amount'] = 0;
		}
	}

	start_form();


if (isset($_POST['CloserDate'])) {

	global $Ajax;
    $Ajax->activate('_page_body');
}


if(get_post('Search'))
{
	$Ajax->activate('_page_body');
}

	start_table(TABLESTYLE_NOBORDER);
start_row();


	$dim = get_company_pref('use_dimension');
			if ($dim > 0)
				dimensions_list_cells(_("Dimension").":", 'dimension_id', 
					null, true, false, false, 1, true);
			else
				hidden('dimension_id', 0);
			if ($dim > 1)
				dimensions_list_cells(_("Dimension")." 2:", 'dimension2_id', 
					null, true, ' ', false, 2, true);
			else
				hidden('dimension2_id', 0);

			  	date_cells(_("to:"), 'CloserDate', '', null, 0, 0, 0, null, true);



submit_cells('Search',_("Search"),'',_('Refresh Inquiry'), 'default');
end_row();

end_table(1);

$is_closed=0;
// display_error(is_closed_daycloser($_POST['dimension_id'],$_POST['CloserDate']));
if(is_closed_daycloser($_POST['dimension_id'],$_POST['CloserDate']))
{

	display_error(_(" Daycloser has been closed for :".$_POST['CloserDate']));
	$is_closed=1;
}

	// start_outer_table(TABLESTYLE2, "width='70%'");

	// table_section(1);

start_table(TABLESTYLE2, "width='70%'");

         $bnk_data = $amt_data=array();

     $res = get_bank_accounts(false, $_POST['dimension_id']);
     $num_row= db_num_rows($res);
     if($num_row)
     {
     	while( $row = db_fetch($res)) {


				$begin = get_fiscalyear_begin_for_date($_POST['CloserDate']);
				if (date1_greater_date2($begin, $_POST['CloserDate']))
				$begin = $_POST['CloserDate'];
				// $begin = add_days($begin, -1);
				$begin = $_POST['CloserDate'] ;  // add_days($_POST['CloserDate'], -1);
				$end   = $_POST['CloserDate'] ;  // add_days($_POST['CloserDate'], +1);

			 // date('Y-m-d', strtotime($begin. ' + 10 days'));
					// display_error($begin." == ".$end);
                 $op_cash = get_balance_before_for_bank_account($row['id'], $_POST['CloserDate']);//get_gl_balance_from_to($begin, $_POST['CloserDate'], $row['account_code'], $_POST['dimension_id'], $_POST['dimension2_id']);
                  $amt_data['op_cash'] = $op_cash;
     			 label_row(_("Opening Cash - ".$row['account_code']." - ".$row['bank_account_name']), number_format($op_cash,2) , "class='tableheader2' align=center", "align=center");
     			 $begin =  sql2date(date('Y-m-d', strtotime(date2sql($_POST['CloserDate']). ' - 1 days'))) ;
     			 $end   = sql2date(date('Y-m-d', strtotime(date2sql($_POST['CloserDate']). ' + 1 days'))) ;

                 $today_cash = get_gl_trans_from_to($begin,  $end , $row['account_code'], $_POST['dimension_id'], $_POST['dimension2_id'],ST_CUSTPAYMENT);
     			 label_row(_("Cash Sales- ".$row['account_code']), number_format($today_cash,2) , "class='tableheader2' align=center", "align=center" );
                   $amt_data['today_cash'] = $today_cash;
                	// $begin = $_POST['CloserDate'];
     			 $transfer_cash = get_gl_trans_from_to($begin,  $end , $row['account_code'], '', $_POST['dimension2_id'],ST_BANKTRANSFER);
     			 label_row(_("Transfer  Cash - ".$row['account_code']), number_format($transfer_cash,2) , "class='tableheader2' align=center", "align=center" );
     			 $amt_data['transfer_cash'] = $transfer_cash;
     		 	// $begin = $_POST['CloserDate'];
     			 $deposite_cash = get_gl_trans_from_to($begin,  $end , $row['account_code'], '', $_POST['dimension2_id'],ST_BANKDEPOSIT);
     			 label_row(_("Deposite  Cash - ".$row['account_code']), number_format($deposite_cash,2) , "class='tableheader2' align=center", "align=center" );
     			  $amt_data['deposite_cash'] = $deposite_cash;

     			 $expected_cash = $op_cash+ $today_cash + $transfer_cash  + $deposite_cash;
     			   $amt_data['expected_cash'] = $expected_cash;
              // viewer_link($label, $url='', $class='', $id='',  $icon=null,$style='')
                label_row(viewer_link(_("Total - ".$row['bank_account_name']), 'gl/inquiry/bank_inquiry.php?bank_account='.$row["id"]."&filter_date=".$_POST['CloserDate'],'','',null, "style= ' color: mediumblue;' "), number_format($expected_cash,2) , "style= 'background-color: #7878f7; color: mediumblue;' align=center", "align=center" );
                 // label_row('-','-');
                 $bnk_data[$row["id"]]=$amt_data;
     		# code...
     	}

     }
     else
     display_error(_(" No Cash account define For this dimension"))	;

  // print_r($bnk_data);
hidden('bnk_data[]',$bnk_data);
// viewer_link($myrow["bank_account_name"], 'gl/inquiry/bank_inquiry.php?bank_account='.$myrow["bank_act"])


   end_table(1);

	if ($trans_no) {
		hidden('_trans_no', $trans_no);
		submit_center('submit', _("Modify Daycloser"), true, '', 'default');
	} else {
		// display_error(is_closed_daycloser($_POST['dimension_id'],$_POST['CloserDate']));
		if(!is_closed_daycloser($_POST['dimension_id'],$_POST['CloserDate']))
		   submit_center('submit', _("Enter Daycloser"), true, '', 'default');
	}

	end_form();
}

//----------------------------------------------------------------------------------------

function check_valid_entries($trans_no)
{
	global $Refs, $systypes_array;
	
	if (!is_date($_POST['CloserDate'])) 
	{
		display_error(_("The entered date is invalid."));
		set_focus('CloserDate');
		return false;
	}
	if (!is_date_in_fiscalyear($_POST['CloserDate']))
	{
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('CloserDate');
		return false;
	}

	

    return true;
}

//----------------------------------------------------------------------------------------

function bank_transfer_handle_submit()
{
	// $trans_no = array_key_exists('_trans_no', $_POST) ?  $_POST['_trans_no'] : null;

  // var_dump($_POST['bnk_data']);	
  // display_error('in' .$_POST['bnk_data'][0]);

	    $bnk_data = $amt_data=array();

     $res = get_bank_accounts(false, $_POST['dimension_id']);
     $num_row= db_num_rows($res);
     if($num_row)
     {
     	while( $row = db_fetch($res)) {


				$begin = get_fiscalyear_begin_for_date($_POST['CloserDate']);
				if (date1_greater_date2($begin, $_POST['CloserDate']))
				$begin = $_POST['CloserDate'];
				$begin = $_POST['CloserDate'] ;  // add_days($_POST['CloserDate'], -1);
				$end   = $_POST['CloserDate'] ;  // add_days($_POST['CloserDate'], +1);


                 $op_cash = get_balance_before_for_bank_account($row['id'], $_POST['CloserDate']);//get_gl_balance_from_to($begin, $_POST['CloserDate'], $row['account_code'], $_POST['dimension_id'], $_POST['dimension2_id']);
                  $amt_data['op_cash'] = $op_cash;
 
     			 $begin =  sql2date(date('Y-m-d', strtotime(date2sql($_POST['CloserDate']). ' - 1 days'))) ;
     			 $end   = sql2date(date('Y-m-d', strtotime(date2sql($_POST['CloserDate']). ' + 1 days'))) ;

                 $today_cash = get_gl_trans_from_to($begin,  $end , $row['account_code'], $_POST['dimension_id'], $_POST['dimension2_id'],ST_CUSTPAYMENT);
                   $amt_data['today_cash'] = $today_cash;
                
     			 $transfer_cash = get_gl_trans_from_to($begin,  $end , $row['account_code'], '', $_POST['dimension2_id'],ST_BANKTRANSFER);
     			 $amt_data['transfer_cash'] = $transfer_cash;
     		 	
     			 $deposite_cash = get_gl_trans_from_to($begin,  $end , $row['account_code'], '', $_POST['dimension2_id'],ST_BANKDEPOSIT);
     			  $amt_data['deposite_cash'] = $deposite_cash;

				 $expected_cash = $op_cash+ $today_cash + $transfer_cash  + $deposite_cash;
				 $amt_data['expected_cash'] = $expected_cash;
              // viewer_link($label, $url='', $class='', $id='',  $icon=null,$style='')

            
                 $bnk_data[$row["id"]]=$amt_data;
     		# code...
     	}

     }
  $postvalue = serialize($bnk_data);
 
   	$sql = "INSERT INTO ".TB_PREF."daycloser (date,dimension_id,data) VALUES (".db_escape(date2sql($_POST['CloserDate'])) . ",".db_escape($_POST['dimension_id']).",".db_escape ($postvalue).")";
   	db_query($sql,"The sales group could not be added");



   // display_error('IN');


	meta_forward($_SERVER['PHP_SELF'], "AddedID=$trans_no");
}

//----------------------------------------------------------------------------------------

$trans_no = '';
if (!$trans_no && isset($_POST['_trans_no'])) {
	$trans_no = $_POST['_trans_no'];
}
if (!$trans_no && isset($_GET['trans_no'])) {
	$trans_no = $_GET["trans_no"];
}

if (isset($_POST['submit'])) {
    if (check_valid_entries($trans_no) == true) {
        bank_transfer_handle_submit();
	}
}

gl_payment_controls($trans_no);

end_page();
