<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
function add_box_size($stock_id, $length, $width, $height)
{
	$sql = "INSERT INTO ".TB_PREF."box_size (stock_id, length, width, height) VALUES (
	".db_escape($stock_id) . ", ".db_escape($length) . ",
	".db_escape($width) . ", ".db_escape($height) . ")";
   	db_query($sql,"The size could not be added");
   	// display_error($sql);
}

function update_box_size($selected_id, $length, $width, $height)
{
	$sql = "UPDATE ".TB_PREF."box_size SET length=".db_escape($length).",width=".db_escape($width).",
		height=".db_escape($height)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The size could not be updated");
}

function delete_box_size($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."box_size WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete size");
}

function get_box_sizes($show_inactive, $stock_id)
{
	$sql = "SELECT * FROM ".TB_PREF."box_size";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	if ($stock_id) 
		$sql .= " AND stock_id = ".db_escape($stock_id);
	return db_query($sql,"could not get size");
}

function get_box_size($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."box_size WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get size");
	return db_fetch($result);
}

function get_box_size_stock_id($stock_id)
{
	$sql = "SELECT * FROM ".TB_PREF."box_size WHERE stock_id=".db_escape($stock_id);
	$result = db_query($sql,"could not get size");
	return db_fetch($result);
}

function get_box_size_id($stock_id)
{
	$sql = "SELECT id FROM ".TB_PREF."box_size WHERE stock_id=".db_escape($stock_id);
	$result = db_query($sql,"could not get size");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}

function get_box_size_name($id)
{
	$sql = "SELECT  CONCAT(' L',length,' x ', ' W', width,' x ', ' H', height) FROM ".TB_PREF."box_size WHERE id = ".db_escape($id);
	$result = db_query($sql, "could not get size");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}