<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
function add_gsm($name)
{
	$sql = "INSERT INTO ".TB_PREF."gsm (name) VALUES (".db_escape($name) . ")";
   	db_query($sql,"The sales gsm could not be added");
}

function update_gsm($selected_id, $name)
{
	$sql = "UPDATE ".TB_PREF."gsm SET name=".db_escape($name)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The sales gsm could not be updated");
}

function delete_gsm($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."gsm WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete gsm");
}

function get_gsms($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."gsm";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	return db_query($sql,"could not get gsm");
}

function get_gsm($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."gsm WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get gsm");
	return db_fetch($result);
}

function get_gsm_name($id)
{
	$sql = "SELECT name FROM ".TB_PREF."gsm WHERE id=".db_escape($id);

	$result = db_query($sql, "could not get gsm");

	$row = db_fetch_row($result);
	return is_array($row) ? $row[0] : false;
}