<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_item_printing($stock_id, $item_printing)
{
	$sql = "INSERT INTO ".TB_PREF."item_printing (stock_id, item_printing) VALUES (".db_escape($stock_id) . ", ".db_escape($item_printing) . ")";
   	db_query($sql,"The item printing could not be added");
   	// display_error($sql);
}

function update_item_printing($selected_id, $item_printing)
{
	$sql = "UPDATE ".TB_PREF."item_printing SET item_printing=".db_escape($item_printing)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The item printing could not be updated");
}

function delete_item_printing($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."item_printing WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete item printing");
}

function get_item_printings($show_inactive, $stock_id)
{
	$sql = "SELECT * FROM ".TB_PREF."item_printing";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	if ($stock_id) 
		$sql .= " AND stock_id = ".db_escape($stock_id);
	$sql .= " ORDER BY item_printing";
	return db_query($sql,"could not get item printing");
}

function get_item_printing($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."item_printing WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get item printing");
	return db_fetch($result);
}

function get_item_printing_stock_id($stock_id)
{
	$sql = "SELECT item_printing FROM ".TB_PREF."item_printing WHERE stock_id=".db_escape($stock_id);
	$result = db_query($sql,"could not get item printing");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}

function get_item_printing_name($id)
{
	$sql = "SELECT item_printing FROM ".TB_PREF."item_printing WHERE id = ".db_escape($id);
	$result = db_query($sql, "could not get item printing");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function add_item_ply($stock_id, $item_ply)
{
	$sql = "INSERT INTO ".TB_PREF."item_ply (stock_id, item_ply) VALUES (".db_escape($stock_id) . ", ".db_escape($item_ply) . ")";
   	db_query($sql,"The item ply could not be added");
   	// display_error($sql);
}

function update_item_ply($selected_id, $item_ply)
{
	$sql = "UPDATE ".TB_PREF."item_ply SET item_ply=".db_escape($item_ply)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The item ply could not be updated");
}

function delete_item_ply($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."item_ply WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete item ply");
}

function get_item_plys($show_inactive, $stock_id)
{
	$sql = "SELECT * FROM ".TB_PREF."item_ply";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	if ($stock_id) 
		$sql .= " AND stock_id = ".db_escape($stock_id);
	$sql .= " ORDER BY item_ply";
	return db_query($sql,"could not get item ply");
}

function get_item_ply($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."item_ply WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get item ply");
	return db_fetch($result);
}

function get_item_ply_stock_id($stock_id)
{
	$sql = "SELECT item_ply FROM ".TB_PREF."item_ply WHERE stock_id=".db_escape($stock_id);
	$result = db_query($sql,"could not get item ply");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}

function get_item_ply_name($id)
{
	$sql = "SELECT item_ply FROM ".TB_PREF."item_ply WHERE id = ".db_escape($id);
	$result = db_query($sql, "could not get item ply");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function add_item_size($stock_id, $item_size)
{
	$sql = "INSERT INTO ".TB_PREF."item_size (stock_id, item_size) VALUES (".db_escape($stock_id) . ", ".db_escape($item_size) . ")";
   	db_query($sql,"The item size could not be added");
   	// display_error($sql);
}

function update_item_size($selected_id, $item_size)
{
	$sql = "UPDATE ".TB_PREF."item_size SET item_size=".db_escape($item_size)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The item size could not be updated");
}

function delete_item_size($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."item_size WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete item size");
}

function get_item_sizes($show_inactive, $stock_id)
{
	$sql = "SELECT * FROM ".TB_PREF."item_size";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	if ($stock_id) 
		$sql .= " AND stock_id = ".db_escape($stock_id);
	$sql .= " ORDER BY item_size";
	return db_query($sql,"could not get item size");
}

function get_item_size($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."item_size WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get item size");
	return db_fetch($result);
}

function get_item_size_name($id)
{
	$sql = "SELECT item_size FROM ".TB_PREF."item_size WHERE id = ".db_escape($id);
	$result = db_query($sql, "could not get item size");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function add_item_material($stock_id, $item_material)
{
	$sql = "INSERT INTO ".TB_PREF."item_material (stock_id, item_material) VALUES (".db_escape($stock_id) . ", ".db_escape($item_material) . ")";
   	db_query($sql,"The item material could not be added");
   	// display_error($sql);
}

function update_item_material($selected_id, $item_material)
{
	$sql = "UPDATE ".TB_PREF."item_material SET item_material=".db_escape($item_material)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The item material could not be updated");
}

function delete_item_material($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."item_material WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete item material");
}

function get_item_materials($show_inactive, $stock_id)
{
	$sql = "SELECT * FROM ".TB_PREF."item_material";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	if ($stock_id) 
		$sql .= " AND stock_id = ".db_escape($stock_id);
	$sql .= " ORDER BY item_material";
	return db_query($sql,"could not get item material");
}

function get_item_material($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."item_material WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get item material");
	return db_fetch($result);
}

function get_item_material_stock_id($stock_id)
{
	$sql = "SELECT item_material FROM ".TB_PREF."item_material WHERE stock_id=".db_escape($stock_id);
	$result = db_query($sql,"could not get item material");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}

function get_item_material_name($id)
{
	$sql = "SELECT item_material FROM ".TB_PREF."item_material WHERE id = ".db_escape($id);
	$result = db_query($sql, "could not get item material");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}

function get_item_material_id($stock_id)
{
	$sql = "SELECT item_material FROM ".TB_PREF."item_material WHERE stock_id = ".db_escape($stock_id);
	$result = db_query($sql, "could not get item material");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}

function get_item_box_size_order($box_size_id=0)
{
	// $sql = "SELECT bs.id, bs.length, bs.width, bs.height, bs.inactive FROM ".TB_PREF."box_size as bs , ".TB_PREF."item_size as it WHERE 
	// 	it.item_size=bs.id AND bs.id=".db_escape($box_size_id); 
  
    $sql = " SELECT * FROM ".TB_PREF."box_size WHERE id=".db_escape($box_size_id);

	// display_error($sql);
	$result = db_query($sql,"could not get");
	return db_fetch($result);
}

?>