<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_stock_consumption($items, $location, $date_, $reference, $memo_, $gsm_id=0, $size_id=0,
	 $printing_id=0, $ply_id=0, $box_size_id=0, $material_id=0, $positive_inv=0, $wo_order=0)
{
	global $SysPrefs, $path_to_root, $Refs;

	begin_transaction();
	$args = func_get_args();
	$args = (object)array_combine(array('items', 'location', 'date_', 'reference', 'memo_', 'gsm_id', 'size_id', 'printing_id', 'ply_id', 'box_size_id', 'material_id'), $args);
	$args->trans_no = 0;
	hook_db_prewrite($args, ST_CONSUMPTION);

	$adj_id = get_next_trans_no(ST_CONSUMPTION);

	if ($SysPrefs->loc_notification() == 1)
	{
		include_once($path_to_root . "/inventory/includes/inventory_db.inc");
		$st_ids = array();
		$st_names = array();
		$st_num = array();
		$st_reorder = array();
	}
	$total_cost = 0;
	foreach ($items as $line_item)
	{

		if ($SysPrefs->loc_notification() == 1 && $line_item->quantity < 0)
		{
			$chg = $line_item; $chg->quantity= -$chg->quantity;	// calculate_reorder_level expect positive qty
			$loc = calculate_reorder_level($location, $chg, $st_ids, $st_names, $st_num, $st_reorder); 
		}

		if ($positive_inv == 1) {
			add_stock_consumption_item($adj_id, $line_item->stock_id, $location, $date_, $reference,
			 $line_item->quantity, $line_item->standard_cost, $memo_, $line_item->batch_no, $line_item->exp_date, 
			 $gsm_id, $size_id, $printing_id, $ply_id, $box_size_id, $material_id, $wo_order);
			$total_cost += $line_item->standard_cost*$line_item->quantity;
		}else{
			add_stock_consumption_item($adj_id, $line_item->stock_id, $location, $date_, $reference,
			 -$line_item->quantity, $line_item->standard_cost, $memo_, $line_item->batch_no, $line_item->exp_date, 
			 $gsm_id, $size_id, $printing_id, $ply_id, $box_size_id, $material_id, $wo_order);
		    $total_cost += $line_item->standard_cost*$line_item->quantity;

		}
	}

	$stock_gl_code = get_stock_gl_code($stock_id);
	if($wo_order)
	add_gl_trans(ST_WORKORDER, $wo_order, $date_, get_company_prefs()["default_wip_act"], 0, 0, $memo_, 
		($positive_inv == 1) ? -$total_cost : $total_cost, null, null, null, "", 0);

	add_comments(ST_CONSUMPTION, $adj_id, $date_, $memo_);
	$Refs->save(ST_CONSUMPTION, $adj_id, $reference);
	add_audit_trail(ST_CONSUMPTION, $adj_id, $date_);

	$args->trans_no = $adj_id;
	hook_db_postwrite($args, ST_CONSUMPTION);
	commit_transaction();
	if ($SysPrefs->loc_notification() == 1 && count($st_ids) > 0)
		send_reorder_email($loc, $st_ids, $st_names, $st_num, $st_reorder);

	return $adj_id;
}

//-------------------------------------------------------------------------------------------------------------

function void_stock_consumption($type_no)
{
	hook_db_prevoid(ST_CONSUMPTION, $type_no);
	void_gl_trans(ST_CONSUMPTION, $type_no);
	void_stock_move(ST_CONSUMPTION, $type_no);
}

//-------------------------------------------------------------------------------------------------------------

function get_stock_consumption_items($trans_no)
{
	$result = get_stock_moves(ST_CONSUMPTION, $trans_no);

	if (db_num_rows($result) == 0)
	{
		return null;
	}

	return $result;
}

//--------------------------------------------------------------------------------------------------

function add_stock_consumption_item($adj_id, $stock_id, $location, $date_, $reference, $quantity, $standard_cost, $memo_, $batch_no=null, $exp_date=null, $gsm_id=0, $size_id=0, $printing_id=0, $ply_id=0, $box_size_id=0, $material_id=0, $wo_order=0){
	$mb_flag = get_mb_flag($stock_id);

    if (is_service($mb_flag))
    {
    	display_db_error("Cannot do inventory adjustment for Service item : $stock_id", "");
    }

	update_average_material_cost(null, $stock_id, $standard_cost, $quantity, $date_);

	if (is_fixed_asset($mb_flag)) {
		$sql = "UPDATE ".TB_PREF."stock_master SET inactive=1
			WHERE stock_id=".db_escape($stock_id);
		db_query($sql,"The inactive flag for the fixed asset could not be updated");
	}

	add_stock_move(ST_CONSUMPTION, $stock_id, $adj_id, $location,   $date_, $reference, $quantity, $standard_cost, 0, $batch_no, $exp_date, $gsm_id, $size_id, $printing_id, $ply_id, $box_size_id, $material_id);

	$inv_value = $standard_cost * $quantity;
	$adj_value = $standard_cost * -($quantity);

	$stock_gl_code = get_stock_gl_code($stock_id);
	if($wo_order){
		add_gl_trans(ST_WORKORDER, $wo_order, $date_, $stock_gl_code["inventory_account"], 0, 0, _($stock_id." Consumption"), $inv_value, null, null, null, "", 0);
	}else{

		if ($standard_cost > 0 || is_fixed_asset($mb_flag))
		{

			$stock_gl_codes = get_stock_gl_code($stock_id);
		// $stock_gl_codes['adjustment_account'];
			add_gl_trans_std_cost(ST_CUNSUMPTION, $adj_id, $date_,
				 $stock_gl_codes['inventory_account'] , $dimension_id, $dimension2_id, $memo_, $adj_value  );

			add_gl_trans_std_cost(ST_CUNSUMPTION, $adj_id, $date_,$gl_code_id, $dimension_id, $dimension2_id, $memo_, $inv_value);
		}
	}

	if (is_fixed_asset($mb_flag)) {
		// get the initial value of the fixed assset.
		$row = get_fixed_asset_move($stock_id, ST_SUPPRECEIVE);
		$inv_value = $row['price'] * $quantity;
		$adj_value = (-($row['price']) + $standard_cost) * $quantity;
	}

	// if ($standard_cost > 0 || is_fixed_asset($mb_flag))
	// {

	// 	$stock_gl_codes = get_stock_gl_code($stock_id);

	// 	add_gl_trans_std_cost(ST_CONSUMPTION, $adj_id, $date_,
	// 		$stock_gl_codes['adjustment_account'], $stock_gl_codes['dimension_id'], $stock_gl_codes['dimension2_id'], $memo_, $adj_value  );

	// 	add_gl_trans_std_cost(ST_CONSUMPTION, $adj_id, $date_, $stock_gl_codes['inventory_account'], 0, 0, $memo_, $inv_value);
	// }

	if (is_fixed_asset($mb_flag)) {
		// Additional gl entry for fixed asset.
		$grn_act = get_company_pref('default_loss_on_asset_disposal_act');
		add_gl_trans_std_cost(ST_CONSUMPTION, $adj_id, $date_, $grn_act, 0, 0, $memo_, ($standard_cost * -($quantity)));
	}
}
