<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
function add_size($name)
{
	$sql = "INSERT INTO ".TB_PREF."size (name) VALUES (".db_escape($name) . ")";
   	db_query($sql,"The size could not be added");
}

function update_size($selected_id, $name)
{
	$sql = "UPDATE ".TB_PREF."size SET name=".db_escape($name)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The size could not be updated");
}

function delete_size($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."size WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete size");
}

function get_sizes($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."size";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	return db_query($sql,"could not get size");
}

function get_size($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."size WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get size");
	return db_fetch($result);
}

function get_size_name($id)
{
	$sql = "SELECT name FROM ".TB_PREF."size WHERE id=".db_escape($id);

	$result = db_query($sql, "could not get size");

	$row = db_fetch_row($result);
	return is_array($row) ? $row[0] : false;
}

function get_size_name_by_id($name)
{
	$sql = "SELECT id FROM ".TB_PREF."size WHERE name=".db_escape($name);

	$result = db_query($sql, "could not get size");

	$row = db_fetch_row($result);
	return is_array($row) ? $row[0] : false;
}

