<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/ui/items_cart.inc");
include_once($path_to_root . "/inventory/includes/db/gsm_db.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");
include_once($path_to_root . "/sales/includes/db/printing_db.inc");
include_once($path_to_root . "/inventory/includes/db/gsm_db.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");
include_once($path_to_root . "/inventory/includes/db/box_size_db.inc");

if (isset($_GET['order_no'])) {
	$_POST['order_no'] = $_GET['order_no'];
}

if (isset($_GET['wo_order'])) {
	$_POST['wo_order'] = $_GET['wo_order'];
}
//--------------------------------------------------------------------------------

function add_to_order(&$order, $new_item, $new_item_qty, $standard_cost, $batch_no=null, $exp_date = null, $gsm_id=0, $size_id=0, $printing_id=0, $ply_id=0, $box_size_id=0, $material_id=0)
{
	// display_error($gsm_id);
	// exit();
    //if ($order->find_cart_item($new_item))
         //display_error(_("For Part :") . $new_item . " " . "This item is already on this document. You can change the quantity on the existing line if necessary.");
	//else
         $order->add_to_cart (count($order->line_items), $new_item, $new_item_qty, $standard_cost, null, $batch_no, $exp_date, $gsm_id, $size_id, $printing_id, $ply_id, $box_size_id, $material_id );
}

//--------------------------------------------------------------------------------

function display_order_header(&$order)
{
	global $Refs, $Ajax;

	start_outer_table(TABLESTYLE2, "width='70%'"); // outer table
	table_section(1);

	locations_list_row(_("Location:"), 'StockLocation', null, false, false, $order->fixed_asset);
    date_row(_("Date:"), 'AdjDate', '', true);

	table_section(2, "50%");

	ref_row(_("Reference:"), 'ref', '', $Refs->get_next(ST_CONSUMPTION, null, array('location'=>get_post('StockLocation'), 'date'=>get_post('AdjDate'))),
		 false, ST_CONSUMPTION);
	check_row(_("Positive Inventory"), 'positive_inv', @$_POST['positive_inv'], true);
 	// if ($_POST['is_reel'] && !$_POST['qty'] && !$_POST['AddItem']) 
	// {
	// 	if (count($_SESSION['adj_items']->line_items) > 0)
	// 		unset($_SESSION['adj_items']->line_items);
	// }
    $Ajax->activate('_page_body');
	start_row();
	check_row(_("Reel Specification"), 'is_reel', get_post('is_reel'), true);
	end_row();
	end_outer_table(1); // outer table
}

//---------------------------------------------------------------------------------

function display_consumption_items($title, &$order)
{
	global $path_to_root;

	$kv_batch = get_company_pref('kv_batch');
	$kv_exp_date = get_company_pref('kv_exp_date');
	if ($_POST['order_no']) {
	display_heading(_("BOM Material"));
	start_table(TABLESTYLE, "width='30%'");
	$th = array(_("Item Code"), _("Item Description"), _("Size"), _("GSM"), _("Location"), _("Total Qty"));
	table_header($th);
	$result = get_service_details($_POST['order_no']);
	$name = 'stock_id';
	while ($myrow = db_fetch($result)) 
	{
		label_cell($myrow["stock_id"], "align='center'");
		label_cell($myrow["description"], "align='center'");
		label_cell(get_size_name($myrow["size_id"]), "align='center'");
		label_cell(get_gsm_name($myrow["gsm_id"]), "align='center'");
		label_cell($myrow["loc_code"], "align='center'");
		// label_cell($myrow["unit_id"], "align='center'");
		qty_cell($myrow["unit_qty"], "align='center'");
		end_row();
	}
	hidden('order_no', $_POST['order_no']);
	hidden('wo_order', $_POST['wo_order']);
	end_table();
	br(1);
	}
	
	display_heading($title);
    div_start('items_table');
	start_table(TABLESTYLE, "width='90%'");

	if ($order->fixed_asset) {
		$th = array(_("Item Code"), _("Item Description"), _("Size"), _("GSM"), _("Quantity"),
		_("Unit"), _("Unit Cost"), _("Initial Value"), "");
	} else {
		$th = array(_("Item Code"), _("Item Description"), _("Printing"), _("Ply"), _("Carton Size"), _("Material"), _("Size"), _("GSM"), _("QOH"), _("Quantity"),
		_("Unit"), _("Unit Cost"), _("Total"), _(""), "");
		if ( count($order->line_items)) $th[] = '';
	}
	//if ( count($order->line_items)) $th[] = '';
		if (count($_SESSION['consumption_items']->line_items) > 0)
			 unset( $th[8] );
	
	if(!$order->fixed_asset){
		if($kv_exp_date){
			array_splice( $th, 4, 0, _("Batch No") );
			array_splice( $th, 5, 0, _("Exp Date") );
		}elseif($kv_batch){
			array_splice( $th, 8, 0, _("Batch No") );
			//array_splice( $th, 3, 0, _("") );
		}
	}
	if ($_POST['is_reel'] == 1) {
			unset( $th[2] );
			unset( $th[3] );
			unset( $th[4] );
			unset( $th[5] );
	}else{
			unset( $th[6] );
			unset( $th[7] );
	}
	table_header($th);
	$total = 0;
	$k = 0;  //row colour counter

	$low_stock = $order->check_qoh($_POST['StockLocation'], $_POST['AdjDate']);
	$id = get_post('selected_id', find_submit('Edit'));
	foreach ($order->line_items as $line_no=>$stock_item)
	{

		$total += ($stock_item->standard_cost * $stock_item->quantity);

		if ($id != $line_no)
		{
			if (in_array($stock_item->stock_id, $low_stock))
				start_row("class='stockmankobg'");	// notice low stock status
			else 
				alt_table_row_color($k);

    		if ($order->fixed_asset)
				label_cell($stock_item->stock_id);
      		else
				view_stock_status_cell($stock_item->stock_id);

			label_cell($stock_item->item_description);
			if ($_POST['is_reel'] == 1) {
    		label_cell(get_size_name($stock_item->size_id));
    		label_cell(get_gsm_name($stock_item->gsm_id));
    		}else{
			label_cell(get_printing_name($stock_item->printing_id ));
			label_cell(get_ply_name($stock_item->ply_id ));
			label_cell(get_box_size_name($stock_item->box_size_id ));
			label_cell(get_material_name($stock_item->material_id ));
			}
			if (!$order->fixed_asset) {
				if($kv_exp_date){
					label_cell($stock_item->batch_no);
					label_cell($stock_item->exp_date);
				}elseif($kv_batch) 
					label_cell($stock_item->batch_no);
			}
    		qty_cell($stock_item->quantity, false, get_qty_dec($stock_item->stock_id));
			label_cell($stock_item->units);
			amount_decimal_cell($stock_item->standard_cost);

			if ($order->fixed_asset) {
    	   		$price = get_purchase_value($stock_item->stock_id);
				amount_cell($price);
      		} else
				amount_cell($stock_item->standard_cost * $stock_item->quantity);

      		if (!$order->fixed_asset) {
      			if ($id == -1)
	        		edit_button_cell("Edit$line_no", _("Edit"),	_('Edit document line'));
	        	else
	        		label_cell('');
      		}
    		if ($id == -1)
				delete_button_cell("Delete$line_no", _("Delete"), _('Remove line from document'));
        	else
        		label_cell('');
			
			end_row();
		}
		else
		{
			adjustment_edit_item_controls($order, $line_no, $kv_batch, $kv_exp_date);
		}
	}

	if ($id == -1)
		adjustment_edit_item_controls($order, -1, $kv_batch, $kv_exp_date);
	if($kv_batch)
		$colspan = !$order->fixed_asset ? 7 : 6;
	else
		$colspan= !$order->fixed_asset ? 6 : 5; 
	label_row(_("Total"), number_format2($total,user_price_dec()), "align=right colspan=".$colspan, "align=right", 2);

    end_table();

	if ($id != -1)
	    hidden('selected_id', $id);
	if ($low_stock)
		display_note(_("Marked items have insufficient quantities in stock as on day of adjustment."), 0, 1, "class='stockmankofg'");
	div_end();
}

//---------------------------------------------------------------------------------

function adjustment_edit_item_controls(&$order, $line_no=-1, $kv_batch=0, $kv_exp_date=0)
{
	global $Ajax;
	start_row();

	$dec2 = 0;

	if ($line_no != -1)
	{
		if (find_submit('Edit') != -1) {
			$_POST['stock_id'] = $order->line_items[$line_no]->stock_id;
			$_POST['qty'] = qty_format($order->line_items[$line_no]->quantity, 
				$order->line_items[$line_no]->stock_id, $dec);
		//$_POST['std_cost'] = price_format($order->line_items[$line_no]->standard_cost);
			$_POST['std_cost'] = price_decimal_format($order->line_items[$line_no]->standard_cost, $dec2);
		}
		$_POST['units'] = $order->line_items[$line_no]->units;
		hidden('stock_id', $_POST['stock_id']);
		label_cell($_POST['stock_id']);
		label_cell($order->line_items[$line_no]->item_description, 'nowrap');
		
		hidden('batch_no', $order->line_items[$id]->batch_no);
		hidden('exp_date', $order->line_items[$id]->exp_date);
		if($kv_exp_date){
			label_cell($order->line_items[$id]->batch_no);
			label_cell($order->line_items[$id]->exp_date);
		} if($kv_batch)
			label_cell($order->line_items[$id]->batch_no);

	    $Ajax->activate('items_table');
	}
	else
	{
		if ($order->fixed_asset)
			stock_disposable_fa_list_cells(null, 'stock_id', null, false, true, $order->line_items);
		else
			stock_costable_items_list_cells(null, 'stock_id', null, false, true);


		if (list_updated('stock_id')) {
			    $Ajax->activate('units');
			    $Ajax->activate('std_cost');
			    $Ajax->activate('std_cost_view');
			    $Ajax->activate('initial_price');
			    $Ajax->activate('items_table');
			    $Ajax->activate('gsm_id');
				$Ajax->activate('size_id');
			   	$Ajax->activate('printing_id');
	            $Ajax->activate('ply_id');
	            $Ajax->activate('box_size_id');
	            $Ajax->activate('material_id');
			}
		if ($_POST['is_reel'] == 1) {
			size_list_cells(null, 'size_id', null, true, true);
	 		gsm_list_cells(null, 'gsm_id', null, true, true);
		}else{
			item_printing_list_cells(null, 'printing_id', null, false, true);
			item_ply_list_cells(null, 'ply_id', null, false, true);
			box_size_list_cells(null, 'box_size_id', null, false, true);
			item_material_list_cells(null, 'material_id', null, false, true);
		}
		if($kv_batch || $kv_exp_date)
			kv_batch_list_cells(null, 'batch_no', null, true, true, false, false, $_POST['gsm_id'], 
				$_POST['size_id']);
			// kv_batch_list_cells(null, 'batch_no', null, true);
		else
			hidden('batch', 0);
		if(list_updated('stock_id') || list_updated('batch_no') || get_post('batch_no')){				
			if($kv_batch || $kv_exp_date) {
				// if(get_post('batch_no') != '' || get_post('batch_no') != null ){
				// 	$sql0 =" SELECT SUM(qty) AS Stock, exp_date FROM ".TB_PREF."stock_moves WHERE batch_no=".db_escape(get_post('batch_no'))." AND stock_id=".get_post('stock_id');  
				// 	$res = db_query($sql0, "can't execute the query");
				// 	$row_res = db_fetch_row($res);		
				// 	$_POST['qty'] = $row_res[0];
				// 	$exp_date = sql2date($row_res[1]);	
				// 	hidden('exp_date', $exp_date);
				// 	if($kv_exp_date)
				// 		label_cell($exp_date);					
				// } else {	
			if($kv_exp_date){
				date_cells(null, 'exp_date', null);
				$_POST['qty'] = 0;
			}
			//}
			}
			// else {					
			// 	$_POST['qty'] = 0;
			// }
			$Ajax->activate('items_table');
			}
			else {

				if($kv_exp_date){
				$_POST['qty'] = 0;
				date_cells(null, 'exp_date', null);
				}
			}
	}
	$item_info = get_item_edit_info(get_post('stock_id'));
   	if ($item_info) {
			$dec = $item_info['decimals'];
			// display_error($_POST['qty'] );
			if (!$_POST['qty'])
   			$_POST['qty'] = number_format2(0, $dec);
			$_POST['std_cost'] = price_decimal_format($item_info["material_cost"], $dec2);
			$_POST['units'] = $item_info["units"];
		} else
			$dec = 0;
	if ($order->fixed_asset) {
		hidden('qty', -1);
		qty_cell(1, false, 0);
	} else {
		$qoh = get_qoh_on_date(get_post('stock_id'), $_POST['StockLocation'], null, input_num('printing_id'), input_num('ply_id'), input_num('box_size_id'), input_num('material_id'), input_num('gsm_id'), input_num('size_id'), $_POST['batch_no']);
		qty_cell($qoh, false, $dec);
		label_cell( text_input('qty', get_post('qty'), 10, 15, '',  'class="amount active" dec='.$dec), "nowrap align=right");
	}
	label_cell(get_post('units'), '', 'units');

	if ($order->fixed_asset) {
		/* TODO: check if this is a correct way of creating a fixed item
			that still has to be submitted in the form */ 
		hidden('std_cost');
		label_cell($_POST['std_cost'], "nowrap align=right ", 'std_cost_view');
		$price = get_purchase_value($_POST['stock_id']);
		amount_cell($price, false, '', 'initial_price');
	} else {
		if (get_post('_qty_changed')) {
			$Ajax->activate('items_table');
			set_focus(input_num('qty') >= 0 ? 'std_cost' : 'AddItem');
		}
		if (input_num('qty') >= 0)
		    amount_cells(null, 'std_cost', null, null, null, $dec2);
		else {
		    hidden('std_cost');
			label_cell($_POST['std_cost'], "nowrap align=right");
		}
		label_cell("&nbsp;");
	}

	if ($line_no != -1)
	{
		button_cell('UpdateItem', _("Update"),
				_('Confirm changes'), ICON_UPDATE);
		button_cell('CancelItemChanges', _("Cancel"),
				_('Cancel changes'), ICON_CANCEL);
		hidden('LineNo', $line_no);
		set_focus('qty');
	}
	else
	{
		submit_cells('AddItem', _("Add Item"), "colspan=2",
		    _('Add new item to document'), true);
	}

	end_row();
}


//---------------------------------------------------------------------------------

function adjustment_options_controls()
{
	  echo "<br>";
	  start_table();

	  textarea_row(_("Memo"), 'memo_', null, 50, 3);

	  end_table(1);
}


//---------------------------------------------------------------------------------

