<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/ui/items_cart.inc");
include_once($path_to_root . "/inventory/includes/db/gsm_db.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");
include_once($path_to_root . "/sales/includes/db/printing_db.inc");
include_once($path_to_root . "/inventory/includes/db/box_size_db.inc");

//--------------------------------------------------------------------------------

function add_to_order(&$order, $new_item, $new_item_qty, $standard_cost, $batch_no=null, $exp_date= null, $gsm_id=0, $size_id=0, $printing_id=0, $ply_id=0, $box_size_id=0, $material_id=0, $unit_id=0)
{
	$kit = get_item_kit($new_item);
	foreach($kit as $item) {
		if ($order->find_cart_item($item['stock_id'], $batch_no))
			display_error(_("For Part :") . $item['stock_id'] . " " . "This item is already on this document. You can change the quantity on the existing line if necessary.");
		else
			$order->add_to_cart (count($order->line_items), $item['stock_id'], $new_item_qty * $item['quantity'], $standard_cost, null, $batch_no, $exp_date, $gsm_id, $size_id, $printing_id, $ply_id, $box_size_id, $material_id, $unit_id);
	}
}

//--------------------------------------------------------------------------------

function display_order_header(&$order)
{
	global $Refs, $Ajax;

	start_outer_table(TABLESTYLE, "width='70%'");

	table_section(1);
	if(!isset($_POST['FromStockLocation']))
		$_POST['FromStockLocation'] = 'RSTR';
	locations_list_row(_("From Location:"), 'FromStockLocation', null, false, true, $order->fixed_asset);
	if(!isset($_POST['ToStockLocation']))
		$_POST['ToStockLocation'] = 'PLF';
	locations_list_row(_("To Location:"), 'ToStockLocation', null,false, true, $order->fixed_asset);
	table_section(2, "50%");

    date_row(_("Date:"), 'AdjDate', '', true,0,0,0,null,true);

	ref_row(_("Reference:"), 'ref', '', $Refs->get_next(ST_LOCTRANSFER, null, array('date'=>get_post('AdjDate'), 'location'=> get_post('FromStockLocation'))), false, ST_LOCTRANSFER);
	// if ($_POST['is_reel']) 
	// {
	// 	// if (count($_SESSION['transfer_items']->line_items) >= 1)
	// 		// $_SESSION['transfer_items']->clear_items();
	// }
    $Ajax->activate('_page_body');
	start_row();
	if(!isset($_POST['is_reel']))
		$_POST['is_reel'] = 1;
	check_row(_("Reel Specification"), 'is_reel', get_post('is_reel'), true);
	end_row();
	if($_POST['FromStockLocation'] == 'PLF' || $_POST['ToStockLocation'] == 'PLF'){
		wo_tranfer_row(_("Work Order:"), "workorder_no", null, true, true);	
   		label_cells(_(" "), get_trans_view_str(ST_WORKORDER, $_POST['workorder_no']));
	}
	end_outer_table(1); // outer table
}

//---------------------------------------------------------------------------------

function display_transfer_items($title, &$order)
{
	global $path_to_root;
	$kv_batch = get_company_pref('kv_batch');
	$kv_exp_date = get_company_pref('kv_exp_date');
	display_heading($title);
    div_start('items_table');
	start_table(TABLESTYLE, "width='80%'");
	$th = array(_("Item Code"), _("Item Description"), _("Printing"), _("Ply"), _("Carton Size"), _("Material"), _("Size"), _("GSM"), _("Quantity"), _("Unit"), '');
	if (!$order->fixed_asset && count($order->line_items)) $th[] = '';
	
	if($kv_exp_date){
			array_splice( $th, 4, 0, _("Batch No") );
			array_splice( $th, 5, 0, _("Exp Date") );
		}elseif($kv_batch){
			array_splice( $th, 8, 0, _("Batch No") );
			//array_splice( $th, 3, 0, _("") );
		}
	if ($_POST['is_reel'] == 1) {
			unset( $th[2] );
			unset( $th[3] );
			unset( $th[4] );
			unset( $th[5] );
	}else{
			unset( $th[6] );
			unset( $th[7] );
	}

	table_header($th);
	
	$k = 0;  //row colour counter
	$low_stock = $order->check_qoh($_POST['FromStockLocation'], $_POST['AdjDate'], true);
	$id = find_submit('Edit');
	foreach ($order->line_items as $line_no=>$stock_item)
	{
		if ($id != $line_no)
		{
			if (in_array($stock_item->stock_id, $low_stock) && array_key_exists($stock_item->batch_no, $low_stock))
				start_row("class='stockmankobg'");	// notice low stock status
			else 
				alt_table_row_color($k);

			if ($order->fixed_asset)
				label_cell($stock_item->stock_id);
			else
				view_stock_status_cell($stock_item->stock_id);
    		label_cell($stock_item->item_description);
    		if ($_POST['is_reel'] == 1) {
    		label_cell(get_size_name($stock_item->size_id));
    		label_cell(get_gsm_name($stock_item->gsm_id));
    		}else{
			label_cell(get_printing_name($stock_item->printing_id ));
			label_cell(get_ply_name($stock_item->ply_id ));
			label_cell(get_box_size_name($stock_item->box_size_id ));
			label_cell(get_material_name($stock_item->material_id ));
			}
			if($kv_exp_date){
				label_cell($stock_item->batch_no);
				label_cell($stock_item->exp_date);
			}elseif($kv_batch )		
			label_cell($stock_item->batch_no);
    		qty_cell($stock_item->quantity, false, get_qty_dec($stock_item->stock_id));
    		label_cell(get_unit_descr($stock_item->unit_id));
    		// label_cell($stock_item->units);
	     	if (!$order->fixed_asset)
			edit_button_cell("Edit$line_no", _("Edit"),	_('Edit document line'));
			delete_button_cell("Delete$line_no", _("Delete"), _('Remove line from document'));
    		
    		end_row();
		}
		else
		{
			transfer_edit_item_controls($order, $line_no, $kv_batch, $kv_exp_date);
		}
	}

	if ($id == -1)
		transfer_edit_item_controls($order, -1, $kv_batch, $kv_exp_date);

    end_table();
	if ($low_stock)
		display_note(_("Marked items have insufficient quantities in stock as on day of transfer".(($kv_batch || $kv_exp_date) ? ' With the respective Batch' : '' ).'.'), 0, 1, "class='stockmankofg'");
	div_end();
}

//---------------------------------------------------------------------------------

function transfer_edit_item_controls(&$order, $line_no=-1, $kv_batch=0, $kv_exp_date=0)
{
	global $Ajax;
	start_row();

	$id = find_submit('Edit');
	if ($line_no != -1 && $line_no == $id)
	{
		$_POST['stock_id'] = $order->line_items[$id]->stock_id;
		$_POST['qty'] = qty_format($order->line_items[$id]->quantity, $order->line_items[$id]->stock_id, $dec);
		$_POST['units'] = $order->line_items[$id]->units;

		hidden('stock_id', $_POST['stock_id']);
		label_cell($_POST['stock_id']);
		label_cell($order->line_items[$id]->item_description);
		
		hidden('batch_no', $order->line_items[$id]->batch_no);
		hidden('exp_date', $order->line_items[$id]->exp_date);
		if($kv_exp_date){
			label_cell($order->line_items[$id]->batch_no);
			label_cell($order->line_items[$id]->exp_date);
		}elseif($kv_batch)
			label_cell($order->line_items[$id]->batch_no);

	    $Ajax->activate('items_table');
	}
	else
	{
		if ($order->fixed_asset)
			stock_disposable_fa_list_cells(null, 'stock_id', null, false, true, $order->line_items);
		else
			sales_items_list_cells(null,'stock_id', null, false, true, true);

		if (list_updated('stock_id') || list_updated('gsm_id') || list_updated('size_id')) {
			$Ajax->activate('unit_id');
			$Ajax->activate('qty');
			$Ajax->activate('items_table');
			$Ajax->activate('gsm_id');
			$Ajax->activate('size_id');
			$Ajax->activate('batch_no');
		   	$Ajax->activate('printing_id');
            $Ajax->activate('ply_id');
            $Ajax->activate('box_size_id');
            $Ajax->activate('material_id');
		}


		if ($_POST['is_reel'] == 1) {
			size_list_cells(null, 'size_id', get_post('size_id'), true, true);
	 		gsm_list_cells(null, 'gsm_id', get_post('gsm_id'), true, true);
		}else{
			item_printing_list_cells(null, 'printing_id', null, false, true);
			item_ply_list_cells(null, 'ply_id', null, false, true);
			box_size_list_cells(null, 'box_size_id', null, false, true);
			item_material_list_cells(null, 'material_id', null, false, true);
		}
		/* Changes for the Batch System -kvvaradha */ 
		if($kv_batch || $kv_exp_date ){
			kv_batch_list_cells(null, 'batch_no', null, true, true, false, $_POST['FromStockLocation'], 
				$_POST['gsm_id'], $_POST['size_id'],0,0,0,0,$_POST['AdjDate']);
			
		}
		else
			hidden('batch', 0);
		if(list_updated('stock_id') || list_updated('batch_no') || get_post('batch_no')){				
			if($kv_batch || $kv_exp_date) {
				if(get_post('batch_no') != '' || get_post('batch_no') != null ){
					$sql0 =" SELECT SUM(qty) AS Stock, exp_date FROM ".TB_PREF."stock_moves WHERE batch_no=".db_escape(get_post('batch_no'))." AND stock_id=".db_escape(get_post('stock_id'));  
					$res = db_query($sql0, "can't execute the query");
					$row_res = db_fetch_row($res);		
					$_POST['qty'] = $row_res[0];
					$exp_date = sql2date($row_res[1]);	
					hidden('exp_date', $exp_date);
					if($kv_exp_date)
						label_cell($exp_date);						
				} else {					
					$_POST['qty'] = 0;
					if($kv_exp_date)
					date_cells(null, 'exp_date', null);
				}
			}else {		
				if($kv_exp_date)
				date_cells(null, 'exp_date', null);
				$_POST['qty'] = 0;
			}
			$Ajax->activate('items_table');
		}	
		// else 
		// 	$_POST['qty'] = 0;
		
    	$item_info = get_item_edit_info($_POST['stock_id']);

		$dec = $item_info['decimals'];
		if (!$_POST['qty'])
   		$_POST['qty'] = number_format2(0, $dec);
		$_POST['units'] = $item_info["units"];
	}

	if ($order->fixed_asset) {
		hidden('qty', 1);
		qty_cell(1, false, 0);
	} else
		small_qty_cells(null, 'qty', $_POST['qty'], null, null, $dec);

	// label_cell($_POST['units'], '', 'units');
	unit_map_list_cells(null, 'unit_id', get_post('unit_id'), false, true, $_POST['stock_id']);

	if ($id != -1)
	{
		button_cell('UpdateItem', _("Update"), _('Confirm changes'), ICON_UPDATE);
		button_cell('CancelItemChanges', _("Cancel"), _('Cancel changes'), ICON_CANCEL);
		hidden('LineNo', $line_no);
 		set_focus('qty');
	}
	else
		submit_cells('AddItem', _("Add Item"), "colspan=2", _('Add new item to document'), true);

	end_row();
}


//---------------------------------------------------------------------------------

function transfer_options_controls()
{
    echo "<br>";
    start_table();

	textarea_row(_("Memo"), 'memo_', null, 50, 3);

	end_table(1);
}


//---------------------------------------------------------------------------------

