<?php
/****************************************
/*  Author 	: Kvvaradha
/*  Module : Batch Number Expiry Date
/*  E-mail 	: admin@kvcodes.com
/*  Version : 1.0
/*  Http 	: www.kvcodes.com
*****************************************/
$page_security = 'SA_ITEMSTRANSVIEW';
$path_to_root = "../..";
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/banking.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/inventory/includes/db/gsm_db.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");
include_once($path_to_root . "/sales/includes/db/printing_db.inc");
include_once($path_to_root . "/inventory/includes/db/box_size_db.inc");
include_once($path_to_root . "/includes/ui.inc");
$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

if (isset($_GET['FixedAsset'])) {
	$page_security = 'SA_ASSETSTRANSVIEW';
	$_POST['fixed_asset'] = 1;
	$_SESSION['page_title'] = _($help_context = "Fixed Assets Movement");
} else {
	$_SESSION['page_title'] = _($help_context = "Batch Movement & Inquiry");
}

page($_SESSION['page_title'], isset($_GET['stock_id']), false, "", $js);
//------------------------------------------------------------------------------------------------

if (get_post('fixed_asset') == 1)
	check_db_has_fixed_assets(_("There are no fixed asset defined in the system."));
else
	check_db_has_stock_items(_("There are no items defined in the system."));

if(get_post('ShowMoves')){
	$Ajax->activate('doc_tbl');
}

if (isset($_GET['stock_id'])){
	$_POST['stock_id'] = $_GET['stock_id'];
}
if(list_updated('stock_id') || list_updated('StockLocation'))
	$Ajax->activate('InquiryFilters');

start_form();
div_start('InquiryFilters');
hidden('fixed_asset');

if (!isset($_POST['stock_id']))
	$_POST['stock_id'] = get_global_stock_item();

start_table(TABLESTYLE_NOBORDER);
start_row();

locations_list_cells(_("From Location:"), 'StockLocation', null, true, true, (get_post('fixed_asset') == 1));

if (!$page_nested){
	if (get_post('fixed_asset') == 1) {
		stock_items_list_cells(_("Item:"), 'stock_id', $_POST['stock_id'],
			false, false, check_value('show_inactive'), false, array('fixed_asset' => true));
		check_cells(_("Show inactive:"), 'show_inactive', null, true);

		if (get_post('_show_inactive_update')) {
			$Ajax->activate('stock_id');
			set_focus('stock_id');
		}
	} else
		stock_costable_items_list_cells(_("Item:"), 'stock_id', $_POST['stock_id'], false, true);
}
// work yahan hoga
	gsm_list_cells('GSM:', 'gsm_id', get_post('gsm_id'), true, true);
	size_list_cells('Size:', 'size_id', get_post('size_id'), true, true);
	item_printing_list_cells('Printing', 'printing_id', null, true, true);
	start_table(TABLESTYLE_NOBORDER);
	item_ply_list_cells('PLY', 'ply_id', null, true, true);
	box_size_list_cells('Carton Size', 'box_size_id', null, true, true);
	item_material_list_cells('Material', 'material_id', null, true, true);
	locations_list_cells(_("From Location:"), 'StockLocation', null, true, false, (get_post('fixed_asset') == 1));
function  kv_filter_cell($label, $name, $selected_id=null, $submit_on_change=false) {
	$kv_empl_mop = array(
		1 => _('Greater than'),  
		2 => _('Less Than'), 
		3 => _('Not equal')
	);
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	$options = array(
	    'select_submit'=> $submit_on_change
	);
	echo array_selector($name, $selected_id, $kv_empl_mop, $options);
	echo "</td>\n";
}
end_row();
end_table();
$kv_exp_date = get_company_pref('kv_exp_date');

start_table(TABLESTYLE_NOBORDER);
kv_batch_list_cells(_("Batch No:"), 'batch_no', null, true, true, $_POST['stock_id'],get_post('StockLocation'), 
		input_num('gsm_id'), input_num('size_id'), input_num('printing_id'), input_num('ply_id'), input_num('box_size_id'), 
		input_num('material_id'));

if($kv_exp_date) {
	kv_filter_cell(_("Filter Type"), 'filterType', null);
	date_cells(_("Expiry Date:"), 'exp_date', '', null, -5);
	hidden('filterType', '');
	hidden('exp_date', '');
}
submit_cells('ShowMoves',_("Show Movements"),'',_('Refresh Inquiry'), 'default');

end_table();
div_end();
end_form();

set_global_stock_item($_POST['stock_id']);

br(2);

$result = get_batch_movements($_POST['stock_id'], get_post('batch_no'), get_post('filterType'), get_post('exp_date'), get_post('StockLocation'), 
   input_num('gsm_id'), input_num('size_id'), input_num('printing_id'), input_num('ply_id'), input_num('box_size_id'), input_num('material_id'));

div_start('doc_tbl');
start_table(TABLESTYLE);
$th = array(_("Type"), _("#"), _("Reference"), _("GSM"), _("Size"), _("Printing"), _("Ply"), _("Carton Size"), _("Material"), _("Date"), _("Detail"), _("Exp Date"), _("Quantity In"), _("Quantity Out"), _("Quantity On Hand"));

if(!$kv_exp_date)
	array_remove($th, 11);
table_header($th);

//$before_qty = get_qoh_on_date($_POST['stock_id'], $_POST['StockLocation'], add_days($_POST['AfterDate'], -1));

$after_qty = $before_qty = 0;
/*
start_row("class='inquirybg'");
$header_span =  6;
//label_cell("<b>"._("Quantity on hand before") . " " . $_POST['AfterDate']."</b>", "align=center colspan=$header_span");
label_cell("&nbsp;", "colspan=2");

qty_cell($before_qty, false, $dec);
end_row();
*/
$header_span =  ($kv_exp_date ? 6 : 5);
$dec = get_qty_dec($_POST['stock_id']);
$j = 1;
$k = 0; //row colour counter

$total_in = 0;
$total_out = 0;

while ($myrow = db_fetch($result)){

	alt_table_row_color($k);
	$trandate = sql2date($myrow["tran_date"]);
	if (get_post('fixed_asset') == 1 && isset($fa_systypes_array[$myrow["type"]]))
		$type_name = $fa_systypes_array[$myrow["type"]];
	else
		$type_name = $systypes_array[$myrow["type"]];

	if ($myrow["qty"] > 0)	{
		$quantity_formatted = number_format2($myrow["qty"], $dec);
		$total_in += $myrow["qty"];
	}else	{
		$quantity_formatted = number_format2(-$myrow["qty"], $dec);
		$total_out += -$myrow["qty"];
	}
	$after_qty += $myrow["qty"];
	label_cell($type_name);
	label_cell(get_trans_view_str($myrow["type"], $myrow["trans_no"]), "nowrap align='right'");
	label_cell(get_trans_view_str($myrow["type"], $myrow["trans_no"], $myrow["reference"]));
	label_cell(get_gsm_name($myrow['gsm_id']) ? get_gsm_name($myrow['gsm_id']) : '-');
	label_cell(get_size_name($myrow['size_id']) ? get_size_name($myrow['size_id']) : '-');
	label_cell(get_printing_name($myrow['printing_id']) ? get_printing_name($myrow['printing_id'])  : '-', "align='center'");
	label_cell(get_ply_name($myrow['ply_id']) ? get_ply_name($myrow['ply_id'])  : '-', "align='center'");
	label_cell(get_box_size_name($myrow['box_size_id']) ? get_box_size_name($myrow['box_size_id'])  : '-', "align='center'");
	label_cell(get_material_name($myrow['material_id']) ? get_material_name($myrow['material_id'])  : '-', "align='center'");
	
	label_cell($trandate);
	$gl_posting = "";
	label_cell($myrow['name']);
	if($kv_exp_date)
	label_cell(sql2date($myrow['exp_date']));

	label_cell((($myrow["qty"] >= 0) ? $quantity_formatted : ""), "nowrap align=right");
	label_cell((($myrow["qty"] < 0) ? $quantity_formatted : ""), "nowrap align=right");
	qty_cell($after_qty, false, $dec);
	end_row();

	$j++;
	if ($j == 12){
		$j = 1;
		table_header($th);
	}
}

start_row("class='inquirybg'");
label_cell("<b>"._("Quantity on hand") . " </b>", "align=center colspan=$header_span");
qty_cell($total_in, false, $dec);
qty_cell($total_out, false, $dec);
qty_cell($after_qty, false, $dec);
end_row();

end_table(1);
div_end();
end_page();
