<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_SALESPRICE';

if (@$_GET['page_level'] == 1)
	$path_to_root = "../..";
else	
	$path_to_root = "..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_types_db.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");
include_once($path_to_root . "/inventory/includes/db/item_printing_db.inc");
include_once($path_to_root . "/sales/includes/db/printing_db.inc");


$js = "";
if ($SysPrefs->use_popup_windows && $SysPrefs->use_popup_search)
	$js .= get_js_open_window(900, 500);
page(_($help_context = "Item Printing"), false, false, "", $js);

//---------------------------------------------------------------------------------------------------

check_db_has_stock_items(_("There are no items defined in the system."));

check_db_has_sales_types(_("There are no sales types in the system. Please set up sales types befor entering pricing."));

simple_page_mode(true);
//---------------------------------------------------------------------------------------------------
$input_error = 0;

if (isset($_GET['stock_id']))
{
	$_POST['stock_id'] = $_GET['stock_id'];
}
if (isset($_GET['Item']))
{
	$_POST['stock_id'] = $_GET['Item'];
}

//---------------------------------------------------------------------------------------------------
$action = $_SERVER['PHP_SELF'];
if ($page_nested)
	$action .= "?stock_id=".get_post('stock_id');
start_form(false, false, $action);

if (!isset($_POST['stock_id']))
	$_POST['stock_id'] = get_global_stock_item();

if (!$page_nested)
{
	echo "<center>" . _("Item:"). "&nbsp;";
	echo sales_items_list('stock_id', $_POST['stock_id'], false, true, '', array('editable' => false));
	echo "<hr></center>";
}
else
	br(2);
set_global_stock_item($_POST['stock_id']);

//----------------------------------------------------------------------------------------------------

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{
		$input_error = 0;

		if (strlen($_POST['item_printing']) == 0) 
		{
			$input_error = 1;
			display_error(_("The  item printing cannot be empty."));
			set_focus('item_printing');
		}

    	if ($selected_id != -1) 
		{
			//editing an existing price
			update_item_printing($selected_id, $_POST['item_printing']);
			$msg = _("This item printing has been updated.");
		}
		else
		{

			add_item_printing($_POST['stock_id'], $_POST['item_printing']);
			$msg = _("The new item printing has been added.");
		}
		display_notification($msg);
		$Mode = 'RESET';
}

//------------------------------------------------------------------------------------------------------

if ($Mode == 'Delete')
{
	//the link to delete a selected record was clicked
	delete_item_printing($selected_id);
	display_notification(_("Selected Item Printing Has Been Deleted."));
	$Mode = 'RESET';
}

if ($Mode == 'RESET')
{
	$selected_id = -1;
}

if (list_updated('stock_id')) {
	$Ajax->activate('printing_table');
	$Ajax->activate('printing_details');
}

//---------------------------------------------------------------------------------------------------

$result = get_item_printings(check_value('show_inactive'), $_POST['stock_id']);

div_start('printing_table');
start_table(TABLESTYLE, "width='30%'");

$th = array(_("Item Printing"), "", "");
table_header($th);
$k = 0; //row colour counter
$calculated = false;
while ($myrow = db_fetch($result))
{
	alt_table_row_color($k);

    label_cell(get_printing_name($myrow["item_printing"]), "align='center'");

 	edit_button_cell("Edit".$myrow['id'], _("Edit"));
 	delete_button_cell("Delete".$myrow['id'], _("Delete"));
    end_row();

}
end_table();
div_end();
//------------------------------------------------------------------------------------------------

echo "<br>";

if ($Mode == 'Edit')
{
	$myrow = get_item_printing($selected_id);
	$_POST['item_printing'] = $myrow["item_printing"];
}

hidden('selected_id', $selected_id);

div_start('printing_details');
start_table(TABLESTYLE2);

printing_list_row(_("Item Printing:"), 'item_printing', null, false, true);

$kit = get_item_code_dflts($_POST['stock_id']);
$units = $kit ? $kit["units"] : '';

end_table(1);
submit_add_or_update_center($selected_id == -1, '', 'both');
div_end();

end_form();
end_page();
