<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_SALESPRICE';

if (@$_GET['page_level'] == 1)
	$path_to_root = "../..";
else	
	$path_to_root = "..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_types_db.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");
include_once($path_to_root . "/inventory/includes/db/item_printing_db.inc");
include_once($path_to_root . "/inventory/includes/db/box_size_db.inc");


$js = "";
if ($SysPrefs->use_popup_windows && $SysPrefs->use_popup_search)
	$js .= get_js_open_window(900, 500);
page(_($help_context = "Item Size"), false, false, "", $js);

//---------------------------------------------------------------------------------------------------

check_db_has_stock_items(_("There are no items defined in the system."));

check_db_has_sales_types(_("There are no sales types in the system. Please set up sales types befor entering pricing."));

simple_page_mode(true);

$input_error = 0;

if (isset($_GET['stock_id']))
{
	$_POST['stock_id'] = $_GET['stock_id'];
}
if (isset($_GET['Item']))
{
	$_POST['stock_id'] = $_GET['Item'];
}

if (!isset($_POST['brand_id']))
{
	$_POST['brand_id'] = get_company_currency();
}

//---------------------------------------------------------------------------------------------------
$action = $_SERVER['PHP_SELF'];
if ($page_nested)
	$action .= "?stock_id=".get_post('stock_id');
start_form(false, false, $action);

if (!isset($_POST['stock_id']))
	$_POST['stock_id'] = get_global_stock_item();

if (!$page_nested)
{
	echo "<center>" . _("Item:"). "&nbsp;";
	echo sales_items_list('stock_id', $_POST['stock_id'], false, true, '', array('editable' => false));
	echo "<hr></center>";
}
else
	br(2);
set_global_stock_item($_POST['stock_id']);

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{
	$input_error = 0;

	if (strlen($_POST['length']) == 0) 
	{
		$input_error = 1;
		display_error(_("The length cannot be empty."));
		set_focus('length');
	}
	if (strlen($_POST['width']) == 0) 
	{
		$input_error = 1;
		display_error(_("The width cannot be empty."));
		set_focus('width');
	}
		if (strlen($_POST['height']) == 0) 
	{
		$input_error = 1;
		display_error(_("The height cannot be empty."));
		set_focus('height');
	}

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_box_size($selected_id, $_POST['length'], $_POST['width'], $_POST['height']);
			$note = _('Selected Size has been updated');
    	} 
    	else 
    	{
    		add_box_size($_POST['stock_id'], $_POST['length'], $_POST['width'], $_POST['height']);
			$note = _('New Size has been added');
			// display_error($_POST['printing']);
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
} 

if ($Mode == 'Delete')
{

	$cancel_delete = 0;

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtors_master'

	//if (key_in_foreign_table($selected_id, 'cust_branch', 'area'))
	//{
	//	$cancel_delete = 1;
	//	display_error(_("Cannot delete this area because customer branches have been created using this area."));
	//} 
	if ($cancel_delete == 0) 
	{
		delete_box_size($selected_id);

		display_notification(_('Selected Size has been deleted'));
	} //end if Delete area
	$Mode = 'RESET';
} 

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}

if (list_updated('stock_id')) {
	$Ajax->activate('printing_table');
}

//-------------------------------------------------------------------------------------------------

$result = get_box_sizes(check_value('show_inactive'), $_POST['stock_id']);
div_start('printing_table');
start_form();
start_table(TABLESTYLE, "width='30%'");

$th = array(_("Length"),_("Width"), _("Height"), "", "");
inactive_control_column($th);

table_header($th);
$k = 0; 

while ($myrow = db_fetch($result)) 
{
	
	alt_table_row_color($k);
		
	label_cell($myrow["length"], "align='center'");
	label_cell($myrow["width"], "align='center'");
	label_cell($myrow["height"], "align='center'");

	
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'box_size', 'id');

 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}
	
inactive_control_row($th);
end_table();
div_end();
echo '<br>';

//-------------------------------------------------------------------------------------------------

start_table(TABLESTYLE2);

if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing area
		$myrow = get_box_size($selected_id);

		$_POST['length']  = $myrow["length"];
		$_POST['width']  = $myrow["width"];
		$_POST['height']  = $myrow["height"];
	}
	hidden("selected_id", $selected_id);
} 

//text_row_ex(_("Size:"), 'size', 30, 70); 
text_row_ex(_("L:"), 'length', 30, 70); 
text_row_ex(_("W:"), 'width', 30, 70); 
text_row_ex(_("H:"), 'height', 30, 70);

end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();
