<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_SIZE';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");

page(_($help_context = "Create Size "));

include($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");

simple_page_mode(true);

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{

	$input_error = 0;

	if (strlen($_POST['name']) == 0) 
	{
		$input_error = 1;
		display_error(_("The  cannot be empty."));
		set_focus('name');
	}

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_size($selected_id, $_POST['name']);
			$note = _('Selected size has been updated');
    	} 
    	else 
    	{
    		add_size($_POST['name']);
			$note = _('New size has been added');
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
} 

if ($Mode == 'Delete')
{

	$cancel_delete = 0;

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtors_master'

//	if (key_in_foreign_table($selected_id, 'cust_branch', 'area'))
//	{
//		$cancel_delete = 1;
//		display_error(_("Cannot delete this area because customer branches have been created using this area."));
//	} 
	if ($cancel_delete == 0) 
	{
		delete_size($selected_id);

		display_notification(_('Selected size has been deleted'));
	} //end if Delete area
	$Mode = 'RESET';
} 

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}

//-------------------------------------------------------------------------------------------------

$result = get_sizes(check_value('show_inactive'));

start_form();
start_table(TABLESTYLE, "width='30%'");

$th = array(_("Name"), "", "");
inactive_control_column($th);

table_header($th);
$k = 0; 

while ($myrow = db_fetch($result)) 
{
	
	alt_table_row_color($k);
		
	label_cell($myrow["name"]);
	
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'size', 'id');

 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}
	
inactive_control_row($th);
end_table();
echo '<br>';

// for ($i=17; $i <= 80 ; $i++) { 
// 	# code...

// 	// add_size($i);
// }
//-------------------------------------------------------------------------------------------------

start_table(TABLESTYLE2);

if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing area
		$myrow = get_size($selected_id);

		$_POST['name']  = $myrow["name"];
	}
	hidden("selected_id", $selected_id);
} 

text_row_ex(_("Create Size:"), 'name', 30); 

end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();
