<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_UNITMAPPING';

if (@$_GET['page_level'] == 1)
	$path_to_root = "../..";
else	
	$path_to_root = "..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_types_db.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc"); //unit_mapping_db
include_once($path_to_root . "/inventory/includes/inventory_db.inc");
include_once($path_to_root . "/inventory/includes/db/unit_mapping_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows && $SysPrefs->use_popup_search)
	$js .= get_js_open_window(900, 500);
page(_($help_context = "Inventory Item Unit Mapping"), false, false, "", $js);

//---------------------------------------------------------------------------------------------------

check_db_has_stock_items(_("There are no items defined in the system."));

check_db_has_sales_types(_("There are no sales types in the system. Please set up sales types befor entering pricing."));

simple_page_mode(true);
//---------------------------------------------------------------------------------------------------
$input_error = 0;

if (isset($_GET['stock_id']))
{
	$_POST['stock_id'] = $_GET['stock_id'];
}
if (isset($_GET['Item']))
{
	$_POST['stock_id'] = $_GET['Item'];
}

// if (!isset($_POST['curr_abrev']))
// {
// 	$_POST['curr_abrev'] = get_company_currency();
// }

//---------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------
$action = $_SERVER['PHP_SELF'];
if ($page_nested)
	$action .= "?stock_id=".get_post('stock_id');
start_form(false, false, $action);

if (!isset($_POST['stock_id']))
	$_POST['stock_id'] = get_global_stock_item();

if (!$page_nested)
{
	echo "<center>" . _("Item:"). "&nbsp;";
	echo sales_items_list('stock_id', $_POST['stock_id'], false, true, '', array('editable' => false));
	echo "<hr></center>";
}
else
	br(2);
set_global_stock_item($_POST['stock_id']);

//----------------------------------------------------------------------------------------------------

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{
	if ($input_error != 1)
	{

    	if ($selected_id != -1) 
		{
			//editing an existing price
			update_unit_mapping($selected_id, $_POST['unit_id'], input_num('qty'));

			$msg = _("This unit mapping has been updated.");
		}
		else
		{

			add_unit_mapping($_POST['stock_id'], $_POST['unit_id'], input_num('qty'));
			// display_error($_POST['unit_id']);
				
			$msg = _("The new unit mapping has been added.");
		}
		display_notification($msg);
		$Mode = 'RESET';
	}

}

//------------------------------------------------------------------------------------------------------

if ($Mode == 'Delete')
{
	//the link to delete a selected record was clicked
	delete_unit_mapping($selected_id);
	display_notification(_("The selected price has been deleted."));
	$Mode = 'RESET';
}

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	$_POST['show_inactive'] = $sav;
	unset($_POST['qty']);
}
// $result = getting_unit_mapping(check_value('show_inactive'), $_P);

// if (list_updated('stock_id')) {
// 	$Ajax->activate('price_table');
// 	$Ajax->activate('unit_id');
// }
// if (list_updated('stock_id') || isset($_POST['_curr_abrev_update']) || isset($_POST['_sales_type_id_update'])) {
// 	// after change of stock, currency or salestype selector
// 	// display default calculated price for new settings. 
// 	// If we have this price already in db it is overwritten later.
// 	unset($_POST['qty']);
// 	$Ajax->activate('unit_id');
// }

//---------------------------------------------------------------------------------------------------

$unit_mapping_list = getting_unit_mapping(check_value('show_inactive'), $_POST['stock_id']);
global $Ajax;
$Ajax->activate('_page_body');
div_start('price_table');
start_table(TABLESTYLE, "width='30%'");

$th = array(_("Units of Measure"), _("Qunantity"), "Edit", "Delete");
inactive_control_column($th);
table_header($th);
$k = 0; //row colour counter
$calculated = false;
while ($myrow = db_fetch($unit_mapping_list))
{

	alt_table_row_color($k);

	label_cell($myrow["unit_id"]);
    label_cell($myrow["qty"]);
    inactive_control_cell($myrow["id"], $myrow["inactive"], 'unit_mapping', 'id');
 	edit_button_cell("Edit".$myrow['id'], _("Edit"));
 	delete_button_cell("Delete".$myrow['id'], _("Delete"));
    // amount_cell($myrow["price"]);
    end_row();

}
inactive_control_row($th);
end_table();
if (db_num_rows($unit_mapping_list) == 0)
{
	if (get_company_pref('add_pct') != -1)
		$calculated = true;
	display_note(_("There are no unit mapping set up for this part."), 1);
}
div_end();
//------------------------------------------------------------------------------------------------

echo "<br>";

if ($Mode == 'Edit')
{
	$myrow = get_stock_unit_mapping($selected_id);
	$_POST['unit_id'] = $myrow["unit_id"];
	$_POST['qty'] = $myrow["qty"];
}

hidden('selected_id', $selected_id);

div_start('price_details');
start_table(TABLESTYLE2);

stock_units_list_row(_('Units of Measure:'), 'unit_id', null, true);
amount_row(_("Qunantity:"), 'qty', null, '');



end_table(1);
// if ($calculated)
// 	display_note(_("The price is calculated."), 0, 1);

submit_add_or_update_center($selected_id == -1, '', 'both');
div_end();

end_form();
end_page();
