<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CONSUMPTION';
$path_to_root = "../..";

include($path_to_root . "/includes/session.inc");

page(_($help_context = "View Inventory Adjustment"), true);

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");
include_once($path_to_root . "/inventory/includes/db/gsm_db.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");
include_once($path_to_root . "/sales/includes/db/printing_db.inc");
include_once($path_to_root . "/inventory/includes/db/items_consump_db.inc");
include_once($path_to_root . "/inventory/includes/db/box_size_db.inc");

if (isset($_GET["trans_no"]))
{
	$trans_no = $_GET["trans_no"];
}

display_heading($systypes_array[ST_CONSUMPTION] . " #$trans_no");

br(1);
$consumption_items = get_stock_consumption_items($trans_no);
$k = 0;
$header_shown = false;
$kv_batch = get_company_pref('kv_batch');
$kv_exp_date = get_company_pref('kv_exp_date');

while ($consumption = db_fetch($consumption_items)){
	if (!$header_shown)	{
		// print_r($consumption);
		start_table(TABLESTYLE2, "width='90%'");
		start_row();
		label_cells(_("At Location"), $consumption['location_name'], "class='tableheader2'");
    	label_cells(_("Reference"), $consumption['reference'], "class='tableheader2'", "colspan=6");
		label_cells(_("Date"), sql2date($consumption['tran_date']), "class='tableheader2'");
		if ($consumption['qty'] > 0) 
			 label_cells(_("Inventory"), _("Positive"), "class='tableheader2'");
		else
			 label_cells(_("Inventory"), _("Negative"), "class='tableheader2'");
		end_row();
		comments_display_row(ST_INVADJUST, $trans_no);

		end_table();
		$header_shown = true;

		echo "<br>";
		start_table(TABLESTYLE, "width='90%'");

    	$th = array(_("Item Code"), _("Description"), _("Size"), _("GSM"), _("Printing"), _("Ply"), _("Carton Size"), _("Material"), _("Quantity"),_("Units"), _("Unit Cost"));
		if($kv_exp_date){
			array_splice( $th, 8, 0, _("Batch No") );
			array_splice( $th, 3, 0, _("Exp Date") );
		}elseif($kv_batch){
			array_splice( $th, 8, 0, _("Batch No") );			
		}	
    	table_header($th);
	}

    alt_table_row_color($k);

    label_cell($consumption['stock_id']);
    label_cell($consumption['description']);
	label_cell(get_size_name($consumption['size_id']) ? get_size_name($consumption['size_id'])  : '-');
	label_cell(get_gsm_name($consumption['gsm_id']) ? get_gsm_name($consumption['gsm_id'])  : '-');
	label_cell(get_printing_name($consumption['printing_id']) ? get_printing_name($consumption['printing_id'])  : '-');
	label_cell(get_ply_name($consumption['ply_id']) ? get_ply_name($consumption['ply_id'])  : '-');
	label_cell(get_box_size_name($consumption['box_size_id']) ? get_box_size_name($consumption['box_size_id'])  : '-');
	label_cell(get_material_name($consumption['material_id']) ? get_material_name($consumption['material_id'])  : '-');
	if($kv_exp_date){
		label_cell($consumption['batch_no']);
		label_cell(sql2date($consumption['exp_date']));
	} elseif($kv_batch)
		label_cell($consumption['batch_no']);
    qty_cell($consumption['qty'], false, get_qty_dec($consumption['stock_id']));
    label_cell($consumption['units']);
    amount_decimal_cell($consumption['standard_cost']);
    end_row();
}

end_table(1);

is_voided_display(ST_INVADJUST, $trans_no, _("This consumption has been voided."));

end_page(true, false, false, ST_INVADJUST, $trans_no);
