<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CREATE_QC';
$path_to_root = "..";
include_once($path_to_root . "/purchasing/includes/po_class.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_db.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_ui.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Final QC"), false, false, "", $js);

if (isset($_GET['trans_no']))
{
	$_POST['trans_no'] = $_GET['trans_no'];
}

//---------------------------------------------------------------------------------------------------------------

// if (isset($_GET['AddedID']))
// {
// 	$grn = $_GET['AddedID'];
// 	$trans_type = ST_SUPPRECEIVE;

// 	display_notification_centered(_("Purchase Order Delivery has been processed"));

// 	display_note(get_trans_view_str($trans_type, $grn, _("&View this Delivery")));
	
//     $clearing_act = get_company_pref('grn_clearing_act');
// 	if ($clearing_act)	
// 		display_note(get_gl_view_str($trans_type, $grn, _("View the GL Journal Entries for this Delivery")), 1);

// 	hyperlink_params("$path_to_root/purchasing/supplier_invoice.php", _("Entry purchase &invoice for this receival"), "New=1");

// 	hyperlink_no_params("$path_to_root/purchasing/inquiry/po_search.php", _("Select a different &purchase order for receiving items against"));

// 	display_footer_exit();
// }

// if (isset($_GET['AddedQC']))
// {
// 	$qc_id = $_GET['AddedQC'];

// 	hyperlink_params("$path_to_root/purchasing/view/qc_trans_view.php", _("View QC Trans"), 
// 		"qc_id=$qc_id");
// 	display_footer_exit();
// }



//--------------------------------------------------------------------------------------------------

function display_po_receive_items($kv_batch=0, $kv_exp_date=0, $workorder)
{
	global $Ajax;
	div_start('qc_trans');
	start_form();
	display_heading(_("Sampling Result"));
    start_table(TABLESTYLE, "colspan=7 width='90%'");
    $th = array(_("S.No"), _("BCT"), _("ECT"), _("Thickness μ m"), _("Moisture %"), 
    	_("Color"), _("Ply"), _("L"), _("W"), _("H"));
    table_header($th);
    $dec = 0;
    $sno=1;
	$j = $_POST['no_of_line'];
	$final_qc = get_final_qc($_POST['trans_no']);
	$final_qc_details = get_final_qc_details($final_qc['id']);
	for ($i=0; $i < $j; $i++) { 

		alt_table_row_color($k);
        $final_qc_details_data = db_fetch($final_qc_details);
		if ($final_qc['trans_no']) {
			if(!isset($_POST['bct'.$i]))
		 		$_POST['bct'.$i] = $final_qc_details_data['bct']; 
			if(!isset($_POST['ect'.$i]))
		 		$_POST['ect'.$i] = $final_qc_details_data['ect']; 
			if(!isset($_POST['thickness'.$i]))
		 		$_POST['thickness'.$i] = $final_qc_details_data['thickness']; 
		 	if(!isset($_POST['moisture'.$i]))
		 		$_POST['moisture'.$i] = $final_qc_details_data['moisture']; 
		 	if(!isset($_POST['color'.$i]))
		 		$_POST['color'.$i] = $final_qc_details_data['color']; 
			if(!isset($_POST['ply'.$i]))
		 		$_POST['ply'.$i] = $final_qc_details_data['ply']; 
		 	if(!isset($_POST['length'.$i]))
		 		$_POST['length'.$i] = $final_qc_details_data['length']; 
		 	if(!isset($_POST['width'.$i]))
		 		$_POST['width'.$i] = $final_qc_details_data['width']; 
		 	if(!isset($_POST['height'.$i]))
		 		$_POST['height'.$i] = $final_qc_details_data['height']; 
		 	hidden('final_qc_details_id'.$i, $final_qc_details_data['id']);
		}

		label_cell($sno++ , "align='center'");
		text_cells(null, "bct".$i, null, 10, "", false, "", "", "", true);
		text_cells(null, "ect".$i, null, 10, "", false, "", "", "", true);
		text_cells(null, "thickness".$i, null, 10, "", false, "", "", "", true);
		text_cells(null, "moisture".$i, null, 10, "", false, "", "", "", true);
		text_cells(null, "color".$i, null, 10, "", false, "", "", "", true);
		text_cells(null, "ply".$i, null, 10, "", false, "", "", "", true);
		text_cells(null, "length".$i, null, 10, "", false, "", "", "", true);
		text_cells(null, "width".$i, null, 10, "", false, "", "", "", true);
		text_cells(null, "height".$i, null, 10, "", false, "", "", "", true);
		end_row();
		$Ajax->activate('_page_body');
	}

    end_table();
	hidden('trans_no', $_POST['trans_no']);
	end_form();
	div_end();
}

//--------------------------------------------------------------------------------------------------

if (isset($_POST['ProcessGoodsReceived']))
{
	begin_transaction();
	
	$existing_trans_no = get_final_qc($_POST['trans_no']);
	if ($existing_trans_no['trans_no']) {

		$sql = "UPDATE ".TB_PREF."final_qc 
	            SET date_='".date2sql($_POST['date_'])."', sample_size=".db_escape($_POST['sample_size']).", quantity=".db_escape($_POST['quantity'])."
	            WHERE trans_no=".db_escape($_POST['trans_no']);
	    db_query($sql, "The qc could not be updated");

		$j = $_POST['no_of_line'];
		for ($i = 0; $i < $j; $i++) {
			$sql = "UPDATE " . TB_PREF . "final_qc_details SET 
				bct = " . db_escape($_POST['bct'.$i]) . ",
				ect = " . db_escape($_POST['ect'.$i]) . ",
				thickness = " . db_escape($_POST['thickness'.$i]) . ",
				moisture = " . db_escape($_POST['moisture'.$i]) . ",
				color = " . db_escape($_POST['color'.$i]) . ",
				ply = " . db_escape($_POST['ply'.$i]) . ",
				length = " . db_escape($_POST['length'.$i]) . ",
				width = " . db_escape($_POST['width'.$i]) . ",
				height = " . db_escape($_POST['height'.$i]) . "
				WHERE id = " . db_escape($_POST['final_qc_details_id'.$i]);
			db_query($sql, "The purch qc trans details could not be updated");
			}

    }else{

		$sql = "INSERT INTO ".TB_PREF."final_qc (trans_no, date_, sample_size, quantity, no_of_line) VALUES (
		 ".db_escape($_POST['trans_no']).", '".date2sql($_POST['date_'])."', 
		 ".db_escape($_POST['sample_size']).", ".db_escape($_POST['quantity']).", ".db_escape($_POST['no_of_line']).")";
	   	db_query($sql,"The qc could not be added");
	   	$final_qc_id = db_insert_id();

	    $j = $_POST['no_of_line'];
		for ($i=0; $i < $j; $i++) { 
			$sql = "INSERT INTO ".TB_PREF."final_qc_details (final_qc_id, bct, ect, thickness,
					moisture, color, ply, length, width, height)
		    VALUES (".db_escape($final_qc_id).", ".db_escape($_POST['bct'.$i]).", 
		    	".db_escape($_POST['ect'.$i]).", ".db_escape($_POST['thickness'.$i]).", 
		    	".db_escape($_POST['moisture'.$i]).", ".db_escape($_POST['color'.$i]).", ".db_escape($_POST['ply'.$i]).", ".db_escape($_POST['length'.$i]).", ".db_escape($_POST['width'.$i]).", ".db_escape($_POST['height'.$i]).")";
	  	 	db_query($sql,"The purch qc trans details could not be added");
	   	}
    }

	commit_transaction();
 	meta_forward($path_to_root.'/manufacturing/search_work_orders.php?');
}

//--------------------------------------------------------------------------------------------------
$kv_batch = get_company_pref('kv_batch');
$kv_exp_date = get_company_pref('kv_exp_date');
$row = get_work_order($_POST['trans_no']);
$myrow = get_item($row['stock_id']);
start_form();
global $Ajax;
start_outer_table(TABLESTYLE2, "width='80%'");
start_row();
$final_qc_data = get_final_qc($_POST['trans_no']);
if ($final_qc_data['trans_no']) {
	if(!isset($_POST['date_']))
		$_POST['date_'] = sql2date($final_qc_data['date_']);
	if(!isset($_POST['sample_size']))
		$_POST['sample_size'] = $final_qc_data['sample_size'];
	if(!isset($_POST['quantity']))
		$_POST['quantity'] = $final_qc_data['quantity'];
}
label_cells(_("Customer Name"), get_customer_name($myrow['customer_id']), "align='left' class='tableheader2'");
date_cells(_("Date"), 'date_', null, null, 0, 0, 0, "class='tableheader2'", false);
end_row();
start_row();
label_cells(_("Product Name"), $myrow['description'] , "align='left' class='tableheader2'");
text_cells(_("Sample Size"), "sample_size", null, 47, "", false, "class='tableheader2'", "", "", true);
end_row();
start_row();
text_cells(_("Quantity"), "quantity", null, 47, "", false, "class='tableheader2'", "", "", true);
if(!isset($_POST['no_of_line']) && !$final_qc_data['trans_no'])
 	$_POST['no_of_line'] = 5;
elseif($final_qc_data['trans_no'])
	$_POST['no_of_line'] = $final_qc_data['no_of_line'];
$Ajax->activate('_page_body');
if(!$final_qc_data['trans_no'])
	text_cells(_("No Of Lines"), "no_of_line", null, 47, "", false, "class='tableheader2'", "", "", true);
else{
	label_cells(_("No Of Lines"), $final_qc_data['no_of_line'] , "align='left' class='tableheader2'");
	hidden('no_of_line', $_POST['no_of_line']);
}
end_row();
end_outer_table(1);
display_po_receive_items($kv_batch, $kv_exp_date, $row);
echo '<br>';
echo "<center>";
submit_center_last('ProcessGoodsReceived', _("Process QC"), _("Clear all GL entry fields"), 'default');
echo "</center>";
end_form();
//--------------------------------------------------------------------------------------------------
end_page();

