<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_flexo_printing($wo_station, $stock_id, $input_output)
{
	$sql = "INSERT INTO ".TB_PREF."flexo_printing (wo_station, stock_id, input_output) VALUES (".db_escape($wo_station) . ", ".db_escape($stock_id) . ", ".db_escape($input_output) . ")";
   	db_query($sql,"The flexo_printing could not be added");
   	// display_error($sql);
}

function update_flexo_printing($selected_id, $stock_id, $input_output)
{
	$sql = "UPDATE ".TB_PREF."flexo_printing SET stock_id=".db_escape($stock_id).", input_output=".db_escape($input_output)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The flexo_printing could not be updated");
}

function delete_flexo_printing($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."flexo_printing WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete flexo_printing");
}

function get_flexo_printings($show_inactive, $wo_station='')
{
	$sql = "SELECT * FROM ".TB_PREF."flexo_printing";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	IF($wo_station != '')
		$sql .= " AND wo_station=".db_escape($wo_station);
	$sql .= " ORDER BY id";
	return db_query($sql,"could not get flexo_printing");
}

function get_flexo_printing($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."flexo_printing WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get flexo_printing");
	return db_fetch($result);
}

function get_flexo_printing_input($wo_station='')
{
	$sql = "SELECT * FROM ".TB_PREF."flexo_printing WHERE input_output=1";
	IF($wo_station != '')
		$sql .= " AND wo_station=".db_escape($wo_station);
	return db_query($sql,"could not get flexo_printing");
}

function get_flexo_printing_output($wo_station='')
{
	$sql = "SELECT * FROM ".TB_PREF."flexo_printing WHERE input_output=2";
	IF($wo_station != '')
		$sql .= " AND wo_station=".db_escape($wo_station);
	return db_query($sql,"could not get flexo_printing");
}
// function get_flexo_printing_name($id)
// {
// 	$sql = "SELECT type FROM ".TB_PREF."flexo_printing WHERE id = ".db_escape($id);
// 	$result = db_query($sql, "could not get flexo_printing");
// 	$row = db_fetch($result);
// 	return is_array($row) ? $row[0] : false;
// }

?>