<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_issue_type_glue_ink($type, $stock_id)
{
	$sql = "INSERT INTO ".TB_PREF."issue_glue_ink (type,stock_id) VALUES (".db_escape($type) . ", ".db_escape($stock_id) . ")";
   	db_query($sql,"The issue_glue_ink could not be added");
   	// display_error($sql);
}

function update_issue_type_glue_ink($selected_id, $type, $stock_id)
{
	$sql = "UPDATE ".TB_PREF."issue_glue_ink SET type=".db_escape($type).", stock_id=".db_escape($stock_id)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The issue_glue_ink could not be updated");
}

function delete_issue_type_glue_ink($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."issue_glue_ink WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete issue_glue_ink");
}

function get_issue_type_glue_inks($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."issue_glue_ink";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	$sql .= " ORDER BY type";
	return db_query($sql,"could not get issue_glue_ink");
}

function get_issue_type_glue_ink($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."issue_glue_ink WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get issue_glue_ink");
	return db_fetch($result);
}

function get_issue_type_glue_ink_name($id)
{
	$sql = "SELECT type FROM ".TB_PREF."issue_glue_ink WHERE id = ".db_escape($id);
	$result = db_query($sql, "could not get issue_glue_ink");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}

function get_item_issue_glue_ink($type)
{
	$sql = "SELECT * FROM ".TB_PREF."issue_glue_ink WHERE type=".db_escape($type);
	return db_query($sql,"could not get issue_glue_ink");
}


?>