<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_issue_type($type)
{
	$sql = "INSERT INTO ".TB_PREF."issue_type (type) VALUES (".db_escape($type) . ")";
   	db_query($sql,"The issue_type could not be added");
   	// display_error($sql);
}

function update_issue_type($selected_id, $type)
{
	$sql = "UPDATE ".TB_PREF."issue_type SET type=".db_escape($type)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The issue_type could not be updated");
}

function delete_issue_type($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."issue_type WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete issue_type");
}

function get_issue_types($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."issue_type";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	$sql .= " ORDER BY type";
	return db_query($sql,"could not get issue_type");
}

function get_issue_type($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."issue_type WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get issue_type");
	return db_fetch($result);
}

function get_issue_type_name($id)
{
	$sql = "SELECT type FROM ".TB_PREF."issue_type WHERE id = ".db_escape($id);
	$result = db_query($sql, "could not get issue_type");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}
function get_stock_reserve_transfer_edit($wo=null)
{
	$sql = " SELECT *, str.id as str_id FROM ".TB_PREF."wo_stock_reserve as str JOIN ".TB_PREF."workorders as wo ON str.wo=wo.id WHERE str.wo=wo.id";
	if($wo)
	$sql.=" AND str.wo IN(".$wo.")";	

	return db_query($sql,"could not get issue_type");
}

function get_stock_reserve_transfer($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."wo_stock_reserve WHERE id=".db_escape($selected_id);
	$result = db_query($sql,"could not get issue_type");
	return db_fetch($result);
}

function update_stock_reserve_transfer($id, $workorder_no)
{
	$sql = "UPDATE ".TB_PREF."wo_stock_reserve SET wo=".db_escape($workorder_no)." WHERE id = ".db_escape($id);
   	db_query($sql,"The issue_type could not be updated");
}

function delete_issue_reel_reserve($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."wo_stock_reserve WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete issue_type");
}

function get_trnsfer_multiple($transfer_no) {

  // $sql = "SELECT * FROM ".TB_PREF."wo_stock_reserve WHERE transfer_no IN(".implode(',',$transfer_no).")";

//   $sql = "SELECT wr.item_code,wr.gsm_id , wr.size_id, wr.batch_no, wr.transfer_no, wo.cutt ,COUNT(*) as occurrences
// FROM ".TB_PREF."wo_stock_reserve wr,".TB_PREF."workorders wo
// WHERE wr.wo= wo.id AND wr.transfer_no IN(".implode(',',$transfer_no).")
// GROUP BY wr.item_code, wr.batch_no, wr.transfer_no
// HAVING COUNT(*) > 1";

//     // display_error($sql);
//   	$result = db_query($sql,"could not get issue_type");
//   	return $result;
// 	// return db_fetch($result);

if (!empty($transfer_no)) {
    $sql = "SELECT wr.item_code, wr.gsm_id , wr.size_id, wr.batch_no, wr.transfer_no, wo.cutt ,COUNT(*) as occurrences
    FROM ".TB_PREF."wo_stock_reserve wr,".TB_PREF."workorders wo
    WHERE wr.wo= wo.id AND wr.transfer_no IN(".implode(',', $transfer_no).")
    GROUP BY wr.item_code, wr.batch_no, wr.transfer_no
    HAVING COUNT(*) > 1";
    
    $result = db_query($sql,"could not get issue_type");
    return $result;
}

}



function get_multiple_tranfer_cutt_sum($transfer_no) {

  // $sql = "SELECT * FROM ".TB_PREF."wo_stock_reserve WHERE transfer_no IN(".implode(',',$transfer_no).")";

  $sql = "SELECT wr.wo, sum(wo.cutt) AS cutt FROM 0_wo_stock_reserve wr JOIN 0_workorders wo ON wr.wo = wo.id WHERE  wr.wo= wo.id AND wr.transfer_no IN(".implode(',',$transfer_no).")
GROUP BY wr.item_code, wr.batch_no, wr.transfer_no
HAVING COUNT(*) > 1";

    // display_error($sql);
  	$result = db_query($sql,"could not get issue_type");
  	$sum_cut=0;
  	// while ($row=db_fetch($result)) {
  	// 	// display_error($row['cutt']." sm");
  	//       	$sum_cut+=$row['cutt'];
  	// }
  $row=db_fetch($result);
  	return 	$row['cutt'];
  	// return $result;
	// return db_fetch($result);

}


?>