<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_reel_type($type)
{
	$sql = "INSERT INTO ".TB_PREF."reel_type (type) VALUES (".db_escape($type) . ")";
   	db_query($sql,"The reel_type could not be added");
   	// display_error($sql);
}

function update_reel_type($selected_id, $type)
{
	$sql = "UPDATE ".TB_PREF."reel_type SET type=".db_escape($type)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The reel_type could not be updated");
}

function delete_reel_type($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."reel_type WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete reel_type");
}

function get_reel_types($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."reel_type";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	$sql .= " ORDER BY type";
	return db_query($sql,"could not get reel_type");
}

function get_reel_type($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."reel_type WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get reel_type");
	return db_fetch($result);
}

function get_reel_type_name($id)
{
	$sql = "SELECT type FROM ".TB_PREF."reel_type WHERE id = ".db_escape($id);
	$result = db_query($sql, "could not get reel_type");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}

?>