<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/ui/items_cart.inc");
include_once($path_to_root . "/inventory/includes/db/gsm_db.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");
include_once($path_to_root . "/manufacturing/includes/db/issue_type_db.inc");

//--------------------------------------------------------------------------------
function add_to_issue(&$order, $new_item, $new_item_qty, $standard_cost, $batch_no=null, 
	$exp_date=null, $gsm_id=0, $size_id=0, $issue_type=0, $peel_qty=0, $cone_weight=0, $corr_1_weight=0,$corr_2_weight=0, $plant_waste=0, $consume_weight=0, $add_zero_qty=0)
{
	// if ($order->find_cart_item($new_item))
	//  display_error(_("For Part :") . $new_item . " " . "This item is already on this issue.  You can change the quantity issued of the existing line if necessary.");
	//else
	$order->add_to_cart (count($order->line_items), $new_item, $new_item_qty, $standard_cost, null, $batch_no, $exp_date, $gsm_id, $size_id,  0,0,0,0,0,$issue_type, $peel_qty, $cone_weight, $corr_1_weight, $corr_2_weight, $plant_waste, $consume_weight,$add_zero_qty);
}
//---------------------------------------------------------------------------------

function display_issue_items($title, &$order, $kv_batch=0, $kv_exp_date = 0) {
	global $path_to_root, $Ajax;

	display_heading($title);
    div_start('items_table');
	start_table(TABLESTYLE, "width='80%'");
	$th = array(_("Item Code"), _("Item Description"), _("GSM"),  _("Size"),  _("Job Card Kg"), 
	 _("QOH Weight"), _("Waste 1"), _("Waste 2"), 
	 _("Jutti"), _("Cone"), _("Plant Waste"), _("Return Weight"), _("Consume Weight"), _("Total Weight"), _("Unit"),  _("Unit Cost"),  _("Total ")); //, _("Return Weight")
	// if ( count($order->line_items)) $th[] = '';
	if($kv_exp_date){
			array_splice( $th, 5, 0, _("Batch No") );
			array_splice( $th, 6, 0, _("Exp Date") );
		}elseif($kv_batch){
			array_splice( $th, 4, 0, _("Batch No") );
		}
	
	table_header($th);
//	$total = 0;
	$k = 0;  //row colour counter
	if (count($order->line_items))
		$low_stock = $order->check_qoh($_POST['Location'], $_POST['date_'], !$_POST['IssueType']);
	$id = find_submit('Edit');
	$wo_quantity = get_work_order($order->order_id);
	$result = get_wo_requirements($order->order_id);
    $qoh_sum=$peel_sum=$cone_weight_sum=$corr_1_weight_sum=$corr_2_weight_sum=$plant_waste_sum=$consume_weight_sum=0;
	foreach ($order->line_items as $line_no=>$stock_item)
	{
		if ($id != $line_no)
		{
			if (in_array($stock_item->stock_id, $low_stock))
				start_row("class='stockmankobg'");	// notice low stock status
			else 
				alt_table_row_color($k);

			view_stock_status_cell($stock_item->stock_id);
			label_cell($stock_item->item_description);
			label_cell(get_gsm_name($stock_item->gsm_id), "align='center'");
			label_cell(get_size_name($stock_item->size_id), "align='center'");
            
            $qoh = get_qoh_on_date($stock_item->stock_id, $_POST['Location'], null, input_num('printing_id'), input_num('ply_id'), input_num('box_size_id'), input_num('material_id'), $stock_item->gsm_id,$stock_item->size_id,$stock_item->batch_no);
			if($kv_exp_date){
				label_cell($stock_item->batch_no);
				label_cell($stock_item->exp_date);
			}elseif($kv_batch)
				label_cell($stock_item->batch_no);

 			$myrow = db_fetch($result);
 			$job_car_kg = $myrow["units_req"] * $wo_quantity['units_reqd'];
       	 	label_cell(number_format2($job_car_kg, 2), "align='center'");
            label_cell($qoh, "align='center'");

		
			// if($_POST['return_weight'.$line_no]){
	
			
			qty_cells(null, 'peel_qty'.$line_no, number_format2($_POST['peel_qty'.$line_no], $dec), "align=right ", null, $dec, true);
			$stock_item->peel_qty = $_POST['peel_qty'.$line_no];
			qty_cells(null, 'cone_weight'.$line_no, number_format2($_POST['cone_weight'.$line_no], $dec), "align=right ", null, $dec, true);
			$stock_item->cone_weight = $_POST['cone_weight'.$line_no];
			qty_cells(null, 'corr_1_weight'.$line_no, number_format2($_POST['corr_1_weight'.$line_no], $dec), "align=right ", null, $dec, true);
			$stock_item->corr_1_weight = $_POST['corr_1_weight'.$line_no];
			qty_cells(null, 'corr_2_weight'.$line_no, number_format2($_POST['corr_2_weight'.$line_no], $dec), "align=right ", null, $dec, true);
			$stock_item->corr_2_weight = $_POST['corr_2_weight'.$line_no];
			qty_cells(null, 'plant_waste'.$line_no, number_format2($_POST['plant_waste'.$line_no], $dec), "align=right ", null, $dec, true);
			$stock_item->plant_waste = $_POST['plant_waste'.$line_no];
				qty_cells(null, 'return_weight'.$line_no, number_format2($_POST['return_weight'.$line_no], $dec), "align=right ", null, $dec, true);
			$stock_item->return_weight = $_POST['return_weight'.$line_no];

					$_POST['consume_weight'.$line_no]=abs($qoh-$_POST['return_weight'.$line_no])-($_POST['peel_qty'.$line_no]+$_POST['cone_weight'.$line_no]+$_POST['corr_1_weight'.$line_no]+$_POST['corr_2_weight'.$line_no]+$_POST['plant_waste'.$line_no]);
			qty_cells(null, 'consume_weight'.$line_no, number_format2($_POST['consume_weight'.$line_no], $dec), "align=right readonly", null, $dec, true);
		
		$stock_item->consume_weight = $_POST['consume_weight'.$line_no];
			// if($_POST['return_weight'.$line_no]){
			// $_POST['consume_weight'.$line_no]=abs($qoh-$_POST['return_weight'.$line_no])-($_POST['peel_qty'.$line_no]+$_POST['cone_weight'.$line_no]+$_POST['corr_1_weight'.$line_no]+$_POST['corr_2_weight'.$line_no]+$_POST['plant_waste'.$line_no]);
			// }
			// label_cell(get_issue_type_name($stock_item->issue_type), "align='center'");
    		// qty_cell($stock_item->quantity, false, get_qty_dec($stock_item->stock_id));
			// small_qty_cells(null, 'Line'.$line_no, null, null, null, $dec);
			// if(!$_POST['Line'.$line_no])
			// 	$_POST['Line'.$line_no] = $stock_item->quantity;

			if (input_num('peel_qty'.$line_no) || input_num('cone_weight'.$line_no) || 
					input_num('corr_1_weight'.$line_no) || input_num('corr_2_weight'.$line_no) || 
					input_num('plant_waste'.$line_no) || input_num('consume_weight'.$line_no)) {
				$_POST['Line'.$line_no] = $_POST['peel_qty'.$line_no]+
								$_POST['cone_weight'.$line_no]+$_POST['corr_1_weight'.$line_no]+
								$_POST['corr_2_weight'.$line_no]+$_POST['plant_waste'.$line_no]+
								$_POST['consume_weight'.$line_no];
								//$stock_item->quantity
			}
			qty_cells(null, 'Line'.$line_no, number_format2($_POST['Line'.$line_no], $dec), "align=right ", null, $dec, true);
			$stock_item->quantity = $_POST['Line'.$line_no];
			if($stock_item->quantity > $qoh)
				display_error("The total weight of Item (" . $stock_item->item_description .") cannot exceed the available Quantity On Hand (QOH) weight.");
			$Ajax->activate('_page_body');
			label_cell($stock_item->units);
			amount_cell($stock_item->standard_cost);
			amount_cell($stock_item->standard_cost * $stock_item->quantity);
			$unit_total = $stock_item->standard_cost * $stock_item->quantity;
			hidden('unit_total', $unit_total);
			// edit_button_cell("Edit$line_no", _("Edit"),
			// 	_('Edit document line'));
			// delete_button_cell("Delete$line_no", _("Delete"),
			// 	_('Remove line from document'));
			end_row();
		}
		// 	else {
		// 	issue_edit_item_controls($order, $line_no, $kv_batch,$kv_exp_date);
		// }

		$total_quantity += $stock_item->quantity;
         $qoh_sum +=$qoh;
		$peel_sum += $stock_item->peel_qty;
		$cone_weight_sum += $stock_item->cone_weight;
		$corr_1_weight_sum += $stock_item->corr_1_weight;
		$corr_2_weight_sum += $stock_item->corr_2_weight;
		$plant_waste_sum += $stock_item->plant_waste;
		$consume_weight_sum += $stock_item->consume_weight;
	}


     start_row();
     label_cell(' <h4><b>Total Weight<b></h4>',"colspan=6");
     amount_cell($qoh_sum);
     amount_cell($peel_sum);
     amount_cell($cone_weight_sum);
     amount_cell($corr_1_weight_sum);
     amount_cell($corr_2_weight_sum);
     amount_cell($plant_waste_sum);
     $waste_sum = $peel_sum+$cone_weight_sum+$corr_1_weight_sum+$corr_2_weight_sum+$plant_waste_sum;
     label_cell('<b> Waste : '.$waste_sum." </b>","align='center'");
     amount_cell($consume_weight_sum);
     amount_cell($total_quantity);
     label_cell('-',"align='center'");
     label_cell('-',"align='center'");
     end_row();

          start_row();
     label_cell(' <h4><b>Total Weight %<b></h4>',"colspan=7");
     $tot_waste_per += ($peel_sum/$total_quantity)*100;
     amount_cell_perc( ($peel_sum/$total_quantity)*100   );
     $tot_waste_per += ($cone_weight_sum/$total_quantity)*100;
     
     amount_cell_perc(($cone_weight_sum/$total_quantity)*100 );
     $tot_waste_per += ($corr_1_weight_sum/$total_quantity)*100;
     
     amount_cell_perc(($corr_1_weight_sum/$total_quantity)*100 );
     $tot_waste_per += ($corr_2_weight_sum/$total_quantity)*100;
     
     amount_cell_perc(($corr_2_weight_sum/$total_quantity)*100 );
     $tot_waste_per += ($plant_waste_sum/$total_quantity)*100;
     
     amount_cell_perc(($plant_waste_sum/$total_quantity)*100 );
     label_cell('<b> Waste % : '.price_format($tot_waste_per)."</b>","align='center'");
     amount_cell_perc(($consume_weight_sum/$total_quantity)*100);
     // amount_cell_perc($total_quantity);
     label_cell('-',"align='center'");
     
     label_cell('-',"align='center'");
     label_cell('-',"align='center'");
     end_row();
	// if ($id == -1)
	// 	issue_edit_item_controls($order, -1, $kv_batch,$kv_exp_date);
	// label_row(_("Total Weight"), $total_quantity, "colspan='13' style='font-weight: bold; text-align: right;'","align=right", 2);
	text_cells_ex(_("Per Sheet Weight:"), 'per_sheet_weight', 15, 255, null, null, "colspan='14' style='font-weight: bold; text-align: right;'", null, true);
	$total_sheet = $consume_weight_sum/input_num('per_sheet_weight', 1);
	label_row(_("Actual Total Sheet"), round($total_sheet, 2), "colspan='14' style='font-weight: bold; text-align: right;'","align=right", 2);
	text_cells_ex(_("Plant Sheet Physical Qty:"), 'no_of_sheets', 15, 255, null, null, "colspan='14' style='font-weight: bold; text-align: right;'", null, true);
		
	$wesatge_sheet = input_num('no_of_sheets')-$total_sheet;
	// if ($wesatge_sheet > 0) {
  	// 	 $label = "Additional Sheet";
	// } elseif ($wesatge_sheet < 0) 
   		 $label = "Difference Sheet";

   if($wesatge_sheet>0)
	label_row(_($label), round($wesatge_sheet, 2), "colspan='14' style='font-weight: bold; text-align: right;'","align=right", 2);
   else
   	label_row(_($label), round($wesatge_sheet, 2), "colspan='14' style='font-weight: bold;  text-align: right;'","align=right  style='font-weight: bold; color:red;' ", 2);
	hidden('wesatge_sheet', $wesatge_sheet);

    end_table();
	if (@$low_stock)
		display_note(_("Marked items have insufficient quantities in stock as on day of issue."), 0, 1, "class='stockmankofg'");
	div_end();
}

//---------------------------------------------------------------------------------

function issue_edit_item_controls(&$order, $line_no=-1, $kv_batch=0, $kv_exp_date=0)
{
	global $Ajax;
	start_row();

	$id = find_submit('Edit');
	if ($line_no != -1 && $line_no == $id)
	{
		$_POST['stock_id'] = $order->line_items[$id]->stock_id;
		$_POST['gsm_id'] = $order->line_items[$id]->gsm_id;
		$_POST['size_id'] = $order->line_items[$id]->size_id;
		$_POST['batch_no'] = $order->line_items[$id]->batch_no;
		// $_POST['issue_type'] = $order->line_items[$id]->issue_type;
		$_POST['qty'] = qty_format($order->line_items[$id]->quantity, 
		$order->line_items[$id]->stock_id, $dec);
		$_POST['units'] = $order->line_items[$id]->units;
		$std_cost = $order->line_items[$id]->standard_cost;
		$_POST['exp_date'] = $order->line_items[$id]->exp_date;

		hidden('stock_id', $_POST['stock_id']);
		label_cell($_POST['stock_id']);
		label_cell($order->line_items[$id]->item_description);
		if($kv_batch || $kv_exp_date){
			label_cell($_POST['batch_no']);
			label_cell($_POST['exp_date']);		
		}
	    $Ajax->activate('items_table');
	}
	else
	{
  		$wo_details = get_work_order($_SESSION['issue_items']->order_id);

  		stock_component_items_list_cells(null, 'stock_id', 
			$wo_details["stock_id"], null, false, true);
		if (list_updated('stock_id')) {
			    $Ajax->activate('units');
			    $Ajax->activate('qty');
			    $Ajax->activate('std_cost');
				$Ajax->activate('items_table');
				$Ajax->activate('peel_qty');
				$Ajax->activate('cone_weight');
				$Ajax->activate('corr_1_weight');
				$Ajax->activate('corr_2_weight');
				$Ajax->activate('plant_waste');
				$Ajax->activate('consume_weight');
		}
		gsm_list_cells(null, 'gsm_id', null, true, true);
		size_list_cells(null, 'size_id', null, true, true);
		text_cells_ex(null, 'peel_qty', 6, 255);
		text_cells_ex(null, 'cone_weight', 6, 255);
		text_cells_ex(null, 'corr_1_weight', 6, 255);
		text_cells_ex(null, 'corr_2_weight', 6, 255);
		text_cells_ex(null, 'plant_waste', 6, 255);
		text_cells_ex(null, 'consume_weight', 6, 255);

		if($kv_batch || $kv_exp_date) {
			if($_POST['IssueType'] != 1){
			kv_batch_list_cells(null, 'batch_no', null, true, true, false, $_POST['Location'],
			  $_POST['gsm_id'], $_POST['size_id']);
			}
			else{
				$batch_no = $_POST['ref'].'-'.$_SESSION['issue_items']->order_id;
				text_cells(null,'batch_no',$batch_no, 15, 25);
			}
			if(list_updated('stock_id') || list_updated('batch_no') || get_post('batch_no')){				
				if(get_post('batch_no') != '' || get_post('batch_no') != null ){
					$sql0 =" SELECT SUM(qty) AS Stock, exp_date FROM ".TB_PREF."stock_moves WHERE batch_no=".db_escape(get_post('batch_no'))." AND stock_id=".db_escape(get_post('stock_id'));  
					$res = db_query($sql0, "can't execute the query");
					$row_res = db_fetch_row($res);		
					$_POST['qty'] = $row_res[0];	
					$exp_date = sql2date($row_res[1]);	
					hidden('exp_date', $exp_date);
					if($kv_exp_date)
						label_cell($exp_date);						
				} else {					
					$_POST['qty'] = 0;
					if($kv_exp_date)
						date_cells(null, 'exp_date', null);
				}
				$Ajax->activate('items_table');
			}	else {
				$_POST['qty'] = 0;
				if($kv_exp_date)
					date_cells(null, 'exp_date', null);
			}
		}	else{
			hidden('batch_no', 0);
			$_POST['qty'] = 0;
		}
    	$item_info = get_item_edit_info($_POST['stock_id']);

   		$dec = $item_info["decimals"];
   		$_POST['qty'] =	number_format2(0, $dec);
		// $std_cost = $item_info["material_cost"];
		$std_cost= get_betch_price($_POST['batch_no'],$_POST["stock_id"]);
		$_POST['units'] = $item_info["units"];
	}

	// issue_type_list_cells(null, 'issue_type', get_post('issue_type'), true, true);
	qty_cells(null, 'qty', $_POST['qty'], null, null, $dec);
	label_cell($_POST['units'], '', 'units');

	//amount_cells(null, 'std_cost', $_POST['std_cost']);
	hidden('std_cost', $std_cost);
	amount_cell($std_cost);

	if ($id != -1)
	{
		button_cell('UpdateItem', _("Update"),
				_('Confirm changes'), ICON_UPDATE);
		button_cell('CancelItemChanges', _("Cancel"),
				_('Cancel changes'), ICON_CANCEL);
		hidden('LineNo', $line_no);
 		set_focus('qty');
	}
	// else
	// {
	// 	submit_cells('AddItem', _("Add Item"), "colspan=2",
	// 	    _('Add new item to document'), true);
	// }

	end_row();
}
//---------------------------------------------------------------------------------

function issue_options_controls()
{
	global $Refs;

	echo "<br>";
	start_outer_table(TABLESTYLE, "width='100%'");
	table_section(1);
 	date_row(_("Date:"), 'date_');

 	locations_list_row(_("From Location:"), 'Location', null , false , true);
 	workcenter_list_row(_("To Work Centre:"), 'WorkCentre');
	// text_row_ex(_("No OF Sheets:"), 'no_of_sheets', 15, 255, null, null, null, null, true);
	// if(!$_POST['waste_sheets'])
	// text_row_ex(_("Waste Sheets:"), 'waste_sheets', 15, 255, null, null, null, null, true);
	// if(!$_POST['no_of_sheets'] > 0)
	// 	display_error('No OF Sheet Must Be Enter');
	// if(!$_POST['waste_sheets'] > 0)
	// 	display_error('Waste Sheet Must Be Enter');

	table_section(2, "50%");
    ref_row(_("Reference:"), 'ref', '', $Refs->get_next(ST_MANUISSUE, null, array('date'=> get_post('date_'), 'location' => get_post('Location'))));
 
 	if (!isset($_POST['IssueType']))
 		$_POST['IssueType'] = 0;
 	yesno_list_row(_("Type:"), 'IssueType', $_POST['IssueType'],
 		_("Return Items to Location"), _("Issue/Westage Items to Work order"), true);
	textarea_row(_("Memo"), 'memo_', null, 50, 3);
	end_outer_table(1); // outer table
}
//---------------------------------------------------------------------------------
