<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_FLEXO_PRINTING';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/manufacturing/includes/db/flexo_printing_db.inc");

page(_($help_context = "Flexo Printing"));

include($path_to_root . "/includes/ui.inc");

simple_page_mode(true);

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{
	$input_error = 0;

	// if (strlen($_POST['stock_id']) == 0) 
	// {
	// 	$input_error = 1;
	// 	display_error(_("The flexo printing cannot be empty."));
	// 	set_focus('stock_id');
	// }

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_issue_type_glue_ink($selected_id, $_POST['wo_station'], $_POST['stock_id'], $_POST['input_output']);
			$note = _('Selected flexo printing has been updated');
    	} 
    	else 
    	{
    		add_flexo_printing($_POST['wo_station'], $_POST['stock_id'], $_POST['input_output']);
			$note = _('New flexo printing has been added');
			// display_error($_POST['printing']);
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
} 

if ($Mode == 'Delete')
{

	$cancel_delete = 0;

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtors_master'

	//if (key_in_foreign_table($selected_id, 'cust_branch', 'area'))
	//{
	//	$cancel_delete = 1;
	//	display_error(_("Cannot delete this area because customer branches have been created using this area."));
	//} 
	if ($cancel_delete == 0) 
	{
		delete_flexo_printing($selected_id);

		display_notification(_('Selected flexo printing has been deleted'));
	} //end if Delete area
	$Mode = 'RESET';
} 

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}

//-------------------------------------------------------------------------------------------------
start_form();
echo "<center> ". "&nbsp;";
workcenter_list_cells(_("Work Station:"), 'wo_station', null, false, true);
echo "<hr></center>";

$result = get_flexo_printings(check_value('show_inactive'), $_POST['wo_station']);


if(list_updated('wo_station'))
	$Ajax->activate('_page_body');

start_table(TABLESTYLE, "width='30%'");

$th = array(_("Item"), _("Status"), "", "");
inactive_control_column($th);

table_header($th);
$k = 0; 
while ($myrow = db_fetch($result)) 
{
	global $input_output;
	
	alt_table_row_color($k);
		
	$description = get_item($myrow["stock_id"]);
	// label_cell(get_issue_type_name($myrow["type"]), "align='center'");
	label_cell($myrow["stock_id"] . ' - ' . $description['description'], "align='center'");
	label_cell($input_output[$myrow["input_output"]], "align='center'");
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'ply', 'id');

 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}
	
inactive_control_row($th);
end_table();
echo '<br>';

//-------------------------------------------------------------------------------------------------

start_table(TABLESTYLE2);

if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing area
		$myrow = get_flexo_printing($selected_id);

		$_POST['stock_id']  = $myrow["stock_id"];
		$_POST['input_output']  = $myrow["input_output"];
	}
	hidden("selected_id", $selected_id);
} 

start_row();
stock_component_items_list_rows(_("Items"), 'stock_id', null, null, false, true);
input_and_output_list_row(_("Select Status:"), 'input_output', $_POST['input_output']);
end_row();
end_table(1);
submit_add_or_update_center($selected_id == -1, '', 'both');
end_form();
end_page();
