<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_ISSUE_TYPE';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/manufacturing/includes/db/issue_type_db.inc");
include_once($path_to_root . "/inventory/includes/db/gsm_db.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");

page(_($help_context = "Stock Reserve Transfer Edit"));

include($path_to_root . "/includes/ui.inc");

simple_page_mode(true);

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{
	$input_error = 0;

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_stock_reserve_transfer($selected_id, $_POST['workorder_no']);
			$note = _('Selected WorkOrder has been updated');
    	} 
    	// else 
    	// {
    	// 	add_issue_type($_POST['type']);
		// 	$note = _('New Type has been added');
		// 	// display_error($_POST['printing']);
    	// }
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
} 

if ($Mode == 'Delete')
{

	$cancel_delete = 0;

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'debtors_master'

	//if (key_in_foreign_table($selected_id, 'cust_branch', 'area'))
	//{
	//	$cancel_delete = 1;
	//	display_error(_("Cannot delete this area because customer branches have been created using this area."));
	//} 
	if ($cancel_delete == 0) 
	{
		delete_issue_reel_reserve($selected_id);

		display_notification(_('Selected reserve Rell issue has been deleted'));
	} //end if Delete area
	$Mode = 'RESET';
} 

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	$wo_no= $_POST['wo'];
	unset($_POST);
	$_POST['wo']=$wo_no;
	$_POST['show_inactive'] = $sav;
}

//-------------------------------------------------------------------------------------------------

$wo = ($_GET['wo']) ? $_GET['wo'] :$_POST['wo'];
$result = get_stock_reserve_transfer_edit($wo);

start_form();
start_table(TABLESTYLE, "width='30%'");

$th = array(_("WorkOrder No."),_("Location Tranfer No.") ,_("Item Code"), _("Batch No."), _("Gsm"), _("Size"), _("Location"), 
	_("QOH"), "", "");
inactive_control_column($th);

table_header($th);
$k = 0; 
while ($myrow = db_fetch($result)) 
{
	//  echo "<pre>";
	// print_r($myrow);
	alt_table_row_color($k);
	  
   $qoh = get_qoh_on_date($myrow["item_code"], $myrow["location"], null, 0, 0, 0, 
   	0, $myrow["gsm_id"], $myrow["size_id"], $myrow["batch_no"]);
   // if ($qoh > 0) {
    label_cells(_(""), get_trans_view_str(ST_WORKORDER, $myrow["wo"]), "", "align='center'");
   
   if($myrow["transfer_no"])
       label_cells(_(""), get_trans_view_str(ST_LOCTRANSFER, $myrow["transfer_no"]), "", "align='center'");
   else
    label_cell(_("-"));
	
	$item_row = get_item($myrow["item_code"]);
	label_cell($myrow["item_code"]." - ".	$item_row['description'], "align='center'");
	label_cell($myrow["batch_no"], "align='center'");
	label_cell(get_gsm_name($myrow["gsm_id"]), "align='center'");
	label_cell(get_size_name($myrow["size_id"]), "align='center'");
	label_cell($myrow["location"], "align='center'");
	label_cell(number_format2($qoh), "align='center'");

	// inactive_control_cell($myrow["id"], $myrow["inactive"], 'ply', 'id');

 	edit_button_cell("Edit".$myrow["str_id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["str_id"], _("Delete"));
   // }
	end_row();
}


hidden('wo',$_GET['wo']);
// inactive_control_row($th);
end_table();
echo '<br>';

//-------------------------------------------------------------------------------------------------

start_table(TABLESTYLE2);

if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing area
		$myrow = get_stock_reserve_transfer($selected_id);
		$_POST['workorder_no']  = $myrow["wo"];

	wo_tranfer_row(_("Work Order:"), "workorder_no", null, false, true);	

	}
	hidden("selected_id", $selected_id);
} 

end_table(1);
// submit_add_or_update_center($selected_id == -1, '', 'both');
echo "<center>";
if ($selected_id != -1) 
submit('UPDATE_ITEM', _("Update"), true, _('Submit changes'), $async);
echo "</center>";

end_form();

end_page();
