<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CREATE_QC';
$path_to_root = "..";
include_once($path_to_root . "/purchasing/includes/po_class.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_db.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_ui.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "QC"), false, false, "", $js);

if (isset($_GET['trans_no']))
{
	$_POST['trans_no'] = $_GET['trans_no'];
}

//---------------------------------------------------------------------------------------------------------------

// if (isset($_GET['AddedID']))
// {
// 	$grn = $_GET['AddedID'];
// 	$trans_type = ST_SUPPRECEIVE;

// 	display_notification_centered(_("Purchase Order Delivery has been processed"));

// 	display_note(get_trans_view_str($trans_type, $grn, _("&View this Delivery")));
	
//     $clearing_act = get_company_pref('grn_clearing_act');
// 	if ($clearing_act)	
// 		display_note(get_gl_view_str($trans_type, $grn, _("View the GL Journal Entries for this Delivery")), 1);

// 	hyperlink_params("$path_to_root/purchasing/supplier_invoice.php", _("Entry purchase &invoice for this receival"), "New=1");

// 	hyperlink_no_params("$path_to_root/purchasing/inquiry/po_search.php", _("Select a different &purchase order for receiving items against"));

// 	display_footer_exit();
// }

// if (isset($_GET['AddedQC']))
// {
// 	$qc_id = $_GET['AddedQC'];

// 	hyperlink_params("$path_to_root/purchasing/view/qc_trans_view.php", _("View QC Trans"), 
// 		"qc_id=$qc_id");
// 	display_footer_exit();
// }



//--------------------------------------------------------------------------------------------------

function display_po_receive_items($kv_batch=0, $kv_exp_date=0, $workorder)
{
	global $Ajax;
	div_start('qc_trans');
	display_heading(_("Quality Observations (PAPER)"));
	start_form();
	
    start_table(TABLESTYLE, "colspan=7 width='90%'");
    $th = array(_("S.No"), _("Quality Tests"), _("Size"), _("Item"), _("Standard GSM"), 
    	_("Obs"), _("Obs"), _("Average"));
    table_header($th);
    $dec = 0;
    $sno=1;
	// $bom = get_bom($workorder['stock_id']);
	    $bom = get_wo_requirements($workorder['id']);
	$i = 1;
	$sum_gsm=0;
	$quality_obs = get_quality_observations($_POST['trans_no']);
	$quality_obs_details =  get_quality_observations_details($quality_obs['id']);
	while ($data = db_fetch($bom)) {
           // echo "<pre>";
		// print_r($data);
		


		$quality_obs_details_data = db_fetch($quality_obs_details);
		if ($quality_obs['trans_no']) {
			if(!isset($_POST['standard'.$i]))
		 	$_POST['standard'.$i] = $quality_obs_details_data['standard']; 
			if(!isset($_POST['obs_a'.$i]))
		 	$_POST['obs_a'.$i] = $quality_obs_details_data['obs_a']; 
			if(!isset($_POST['obs_b'.$i]))
		 	$_POST['obs_b'.$i] = $quality_obs_details_data['obs_b']; 
		 	hidden('quality_obs_detail_id'.$i, $quality_obs_details_data['id']);
		}

		alt_table_row_color($k);
		label_cell($sno++ , "align='center'");
		label_cell(_("Material Combination (Gm)"), "align='center'");
		label_cell(get_size_name($data['size_id']), "align='center'");
		// echo "<pre>";
		// print_r($data);

		$data2 = get_item($data['stock_id']);
		label_cell($data2['description'], "align='center'");
		$_POST["standard".$i]= get_gsm_name($data['gsm_id']);
         // display_error($data['misc_qty']."*".$_POST["standard".$i]."  = ".$sum_gsm);
		$sum_gsm+=$data['misc_qty']*$_POST["standard".$i];
		text_cells(null, "standard".$i, get_gsm_name($data['gsm_id']), 10, "", false, "", "", "", true);
		text_cells(null, "obs_a".$i, null, 10, "", false, "", "", "", true);
		text_cells(null, "obs_b".$i, null, 10, "", false, "", "", "", true);
		if($_POST['obs_a'.$i] > 0 AND $_POST['obs_b'.$i] > 0)
			$average = (input_num('obs_a'.$i)+input_num('obs_b'.$i))/2;
		else
			$average = input_num('obs_a'.$i);
		label_cell($average , "align='center'");
		end_row();
		$Ajax->activate('_page_body');
		$size = get_size_name($data['size_id']);

	$i++;
	}

	
    end_table();
    br();
    display_heading(_("Quality Observations (Sizing)"));
    start_table(TABLESTYLE, "colspan=7 width='90%'");
    $th = array(_("S.No"), _("Quality Tests"), _("Units"), _("Standard"), 
    	_("Observation"));
    table_header($th,"calspam='3'");
    $dec = 0;
    $sno=1;
	$quality_obs_details2 =  get_quality_observations_details($quality_obs['id']);
   	for ($j=1; $j < 6; $j++) {

		$quality_obs_details_data2 = db_fetch($quality_obs_details2);
		if ($quality_obs['trans_no']) {
			if(!isset($_POST['remarks'.$j]))
		 	$_POST['remarks'.$j] = $quality_obs_details_data2['remarks']; 
		}
		label_cell($sno++ , "align='center'");
   		if($j == 1){

   			$val = explode('-', $quality_obs_details_data2['remarks']);
   			if(!isset($_POST["L"]))
   			{
   				$_POST["L"]=$val[0];
   				$_POST["W"]=$val[1];
   				$_POST["H"]=$val[2];

   			}	
			label_cell(_("Box Size"), "align='center'");
			label_cell(_("mm"), "align='center'");
			label_cell(_("   L   ".$workorder['box_length']."    W    ".$workorder['box_weight']."   H   " .$workorder['sheet_heigh']), "align='center' class='tableheader' ");
			// 	if(!isset($_POST['remarks'.$j]))
			// $_POST["remarks".$j]=" L ".$workorder['box_length']." W ".$workorder['box_weight']." H " .$workorder['sheet_heigh'];

			label_cell('<label align="center" class=""   style="margin-left: 10px;"> L   </label>     <input class="amount" style="margin-left: 10px;" type="text" name="L" size="8" maxlength="15" dec="0" value="'.$_POST["L"].'" _last_val="">      

			<label align="center" class=""  style="margin-left: 10px;"> W   </label>     <input class="amount" style="margin-left: 10px;" type="text" name="W" size="8" maxlength="15" dec="0" value="'.$_POST["W"].'" _last_val="">

			<label align="center" class="" style="margin-left: 10px;"> H   </label>     <input class="amount" style="margin-left: 10px;" type="text" name="H" size="8" maxlength="15" dec="0"  value="'.$_POST["H"].'" _last_val="">');

   		}elseif ($j == 2) {
			label_cell(_("Flap Size + Height + Flap Size"), "align='center'");
			label_cell(_("mm"), "align='center'");
			$box_weight = $workorder['box_weight']/2;
			label_cell(_($box_weight."   ".$workorder['sheet_heigh']."   " .$box_weight), "align='center' class='tableheader'");
			// 	if(!isset($_POST['remarks'.$j]))
			// $_POST["remarks".$j]=$box_weight."   ".$workorder['sheet_heigh']."   " .$box_weight;

		    $val = explode('-', $quality_obs_details_data2['remarks']);
   			if(!isset($_POST["L1"]))
   			{
   				$_POST["L1"]=$val[0];
   				$_POST["W1"]=$val[1];
   				$_POST["H1"]=$val[2];
   			}	

		label_cell('<label align="center" class=""   style="margin-left: 10px;"> Flap Size   </label>     <input class="amount" style="margin-left: 10px;" type="text" name="L1" size="8" maxlength="15" dec="0" value="'.$_POST["L1"].'" _last_val="">      

			<label align="center" class=""  style="margin-left: 10px;"> Height  </label>     <input class="amount" style="margin-left: 10px;" type="text" name="W1" size="8" maxlength="15" dec="0" value="'.$_POST["W1"].'" _last_val="">

			<label align="center" class="" style="margin-left: 10px;"> Flap Size   </label>     <input class="amount" style="margin-left: 10px;" type="text" name="H1" size="8" maxlength="15" dec="0"  value="'.$_POST["H1"].'" _last_val="">');
		}elseif ($j == 3) {
			label_cell(_("Reel Size"), "align='center'");
			label_cell(_("inches"), "align='center'");
			label_cell($size, "align='center' class='tableheader'");
			// 	if(!isset($_POST['remarks'.$j]))
			// $_POST["remarks".$j]=$size;
			 // $val = explode('-', $quality_obs_details_data2['remarks']);
   			if(!isset($_POST["reel_size"]))
   			$_POST["reel_size"]= $quality_obs_details_data2['remarks'];
   				
   				

		   label_cell('
			<label align="center" class="" style="margin-left: 10px;">   Reel Size </label>     <input class="amount" style="margin-left: 10px;" type="text" name="reel_size" size="8" maxlength="15" dec="0"  value="'.$_POST["reel_size"].'" _last_val="">');
		}elseif ($j == 4) {
			label_cell(_("Sheet L/W"), "align='center'");
			label_cell(_("inches"), "align='center' ");
			$sheet_lw = ($workorder['box_length']+$workorder['box_weight']+$workorder['box_length']+$workorder['box_weight'])+40;
			label_cell($sheet_lw." x ". ($box_weight+$workorder['sheet_heigh']+$box_weight), "align='center' class='tableheader' ");
			// 	if(!isset($_POST['remarks'.$j]))
			// $_POST["remarks".$j]=$sheet_lw." x ".$box_weight+$workorder['sheet_heigh']+$box_weight;

		  $val = explode('x', $quality_obs_details_data2['remarks']);
   			if(!isset($_POST["sheet_l"]))
   			{
   				$_POST["sheet_l"]=$val[0];
   				$_POST["sheet_w"]=$val[1];
   			}		

		label_cell('<label align="center" class=""   style="margin-left: 10px;"> Sheet L  </label>     <input class="amount" style="margin-left: 10px;" type="text" name="sheet_l" size="8" maxlength="15"  dec="0" value="'.$_POST["sheet_l"].'" _last_val="">      

			<label align="center" class="" style="margin-left: 10px;"> Sheet W </label>     <input class="amount" style="margin-left: 10px;" type="text" name="sheet_w" size="8" maxlength="15" dec="0"  value="'.$_POST["sheet_w"].'" _last_val="">');

		}elseif ($j == 5) {
			label_cell(_("Number of ups"), "align='center'");
			label_cell(_(""), "align='center'");
			label_cell($workorder['ups'], "align='center' class='tableheader'");
				// if(!isset($_POST['remarks'.$j]))
				// 	$_POST["remarks".$j]=$workorder['ups'];

				if(!isset($_POST["ups"]))
   			$_POST["ups"]= $quality_obs_details_data2['remarks'];

				  label_cell('<label align="center" class="" style="margin-left: 10px;">   Ups </label>     <input class="amount" style="margin-left: 10px;" type="text" name="ups" size="8" maxlength="15" dec="0"  value="'.$_POST["ups"].'" _last_val="">');
		}
		// text_cells(null, "remarks".$j, null, 50, "", false, "", "", "align='center'", true);
		end_row();
    }
    end_table();
  	br();
    display_heading(_("Quality Observations (Testings)"));
    start_table(TABLESTYLE, "colspan=7 width='90%'");
    $th = array(_("S.No"), _("Quality Tests"), _("Units"), _("Standard"), 
    	_("Sample 1"), _("Sample 2"));
    table_header($th);
    $dec = 0;
    $sno=1;
    $quality_obs_details_testing =  get_quality_observations_testing_details($quality_obs['id']);
   	for ($j=1; $j < 10; $j++) {

   		$quality_obs_details_testing_data = db_fetch($quality_obs_details_testing);
		if ($quality_obs['trans_no']) {
			if(!isset($_POST['standard2'.$j]))
		 	$_POST['standard2'.$j] = $quality_obs_details_testing_data['standard2']; 
			if(!isset($_POST['sample1'.$j]))
		 	$_POST['sample1'.$j] = $quality_obs_details_testing_data['sample1']; 
			if(!isset($_POST['sample2'.$j]))
		 	$_POST['sample2'.$j] = $quality_obs_details_testing_data['sample2']; 
		 	hidden('quality_obs_details_testing_id'.$j, $quality_obs_details_testing_data['id']);
		}

		label_cell($sno++ , "align='center'");
		switch ($j) {
			case $j == 1:
			label_cell(_("Edge Crush"), "align='center'");
			label_cell(_("Kgf"), "align='center'");
				break;
			case $j == 2:
			label_cell(_("Gsm 100 x 100"), "align='center'");
			label_cell(_("Gm"), "align='center'");
			// display_error($_POST["standard1"]." == ".$_POST["standard2"]." == ".$_POST["standard3"]." == ".$_POST["standard4"]." == ".$_POST["standard5"]);
			  $_POST["standard2".$j]= $sum_gsm + 20;
				break;
			case $j == 3:
			label_cell(_("Sheet Weight"), "align='center'");
			label_cell(_("Gm"), "align='center'");
				break;
			case $j == 4:
			label_cell(_("Moisture"), "align='center'");
			label_cell(_("%"), "align='center'");
			 $_POST["standard2".$j]='7-9';
				break;
			case $j == 5:
			label_cell(_("Take-up Factor (B Flute)"), "align='center'");
			label_cell(_(""), "align='center'");
			$_POST["standard2".$j]=1.33;
				break;
			case $j == 6:
			label_cell(_("Take-up Factor (C Flute)"), "align='center'");
			label_cell(_(""), "align='center'");
			$_POST["standard2".$j]=( ($i-1)==5 )? 1.43: '' ;
				break;
			case $j == 7:
			label_cell(_("Sheet Finishing"), "align='center'");
			label_cell(_("Obs"), "align='center'");
				break;
			case $j == 8:
				 $_POST["standard2".$j]=( ($i-1)==5 )? 6: 3 ;
			label_cell(_("Thickness"), "align='center'");
			label_cell(_("mm"), "align='center'");
				break;
			case $j == 9:
			$_POST["standard2".$j]=$i-1;
			label_cell(_("Ply"), "align='center'");
			label_cell(_("no"), "align='center'");
				break;
		}
		text_cells(null, "standard2".$j, null, 20, "", false, "", "", "", true);
		text_cells(null, "sample1".$j, null, 20, "", false, "", "", "", true);
		text_cells(null, "sample2".$j, null, 20, "", false, "", "", "", true);
		end_row();

    }
    if(!isset($_POST['memo_']))
    	$_POST['memo_'] = $quality_obs['memo_'];
	label_cell(_("Tolerance: + / - 5 %"), "align='center' colspan='6'");
	start_row();
	textarea_cells(_("Remarks:"), "memo_", null, 50, 3, null, null, "align='center' colspan='4'");
	label_cell(_(""), "colspan='1'");
	end_row();
	start_row();
	label_cell(_("Status Based"), "colspan='4'");
	  if(!isset($_POST['qc_status']))
    	$_POST['qc_status'] = $quality_obs['qc_status'];
	yesno_list_cells(null, 'qc_status', null, _("Pass"), _("Rejected"), false);
	label_cell(_(""), "colspan='1'");
		end_row();

	start_row();
	label_cell(_("Prepared By"), "colspan='4'");
	    if(!isset($_POST['Prepare_by']))
    	$_POST['Prepare_by'] = $quality_obs['Prepare_by'];
	text_cells(null, "Prepare_by", null, 20, "", false, "", "", "", true);
	label_cell(_(""), "colspan='1'");
	end_row();	
    
    start_row();
	label_cell(_("Perform  By"), "colspan='4'");
		    if(!isset($_POST['perform_by']))
    	$_POST['perform_by'] = $quality_obs['perform_by'];
	text_cells(null, "perform_by", null, 20, "", false, "", "", "", true);
	label_cell(_(""), "colspan='1'");
		end_row();	
    end_table();
	hidden('trans_no', $_POST['trans_no']);
	end_form();
	div_end();
}

//--------------------------------------------------------------------------------------------------

if (isset($_POST['ProcessGoodsReceived']))
{
	begin_transaction();

	$existing_trans_no = get_quality_observations($_POST['trans_no']);

  

	    for ($i=1; $i < 6; $i++) {
	    	if( $i==1 )
	    	$_POST['remarks'.$i] = input_num('L')." - ".input_num('W')." - ".input_num('L');
	    	elseif($i==2) 
	    	$_POST['remarks'.$i] = input_num('L1')." - ".input_num('W1')." - ".input_num('H1');
            elseif ($i==3)
            $_POST['remarks'.$i] = input_num('reel_size');
            elseif($i==4)
            $_POST['remarks'.$i] = input_num('sheet_l')." - ".input_num('sheet_w');
            else
            $_POST['remarks'.$i] = input_num('ups');

	    }







	if ($existing_trans_no['trans_no']) {

	    $sql = "UPDATE ".TB_PREF."quality_observations 
	            SET date_='".date2sql($_POST['date_'])."' , qc_status=".db_escape($_POST['qc_status'])." , memo_=".db_escape($_POST['memo_']).", Prepare_by=".db_escape($_POST['Prepare_by']).", perform_by=".db_escape($_POST['perform_by'])." 
	            WHERE trans_no=".db_escape($_POST['trans_no']);
	    db_query($sql, "The qc could not be updated");

	    for ($i = 1; $i < 6; $i++) {
	        if (isset($_POST['quality_obs_detail_id'.$i])) {
	            $sql = "UPDATE ".TB_PREF."quality_observations_details 
	                    SET standard=".db_escape($_POST['standard'.$i]).", 
	                        obs_a=".db_escape($_POST['obs_a'.$i]).", 
	                        obs_b=".db_escape($_POST['obs_b'.$i]).", 
	                        remarks=".db_escape($_POST['remarks'.$i])." 
	                    WHERE id = ".db_escape($_POST['quality_obs_detail_id'.$i]);
	            db_query($sql, "The purch qc trans details could not be updated");
	        }
	    }
	    for ($j = 1; $j < 10; $j++) {
	        if (isset($_POST['quality_obs_details_testing_id'.$j])) {
	            $sql = "UPDATE ".TB_PREF."quality_observations_testing_details 
	                    SET standard2=".db_escape($_POST['standard2'.$j]).", 
	                        sample1=".db_escape(input_num('sample1'.$j)).", 
	                        sample2=".db_escape(input_num('sample2'.$j))." 
	                    WHERE id = ".db_escape($_POST['quality_obs_details_testing_id'.$j]);
	            db_query($sql, "The purch qc trans testing details could not be updated");
	        }
	    }

	} else {


	    $sql = "INSERT INTO ".TB_PREF."quality_observations (trans_no, date_, memo_,qc_status,Prepare_by,perform_by) VALUES (
	            ".db_escape($_POST['trans_no']).", '".date2sql($_POST['date_'])."', 
	            ".db_escape($_POST['memo_']).",".db_escape($_POST['qc_status']).",".db_escape($_POST['Prepare_by']).",".db_escape($_POST['perform_by']).")";
	    db_query($sql,"The qc could not be added");
	    $quality_obs_id = db_insert_id();

	    for ($i=1; $i < 6; $i++) { 
	        $sql = "INSERT INTO ".TB_PREF."quality_observations_details (quality_obs_id, standard, obs_a, obs_b, remarks)
	                VALUES (".db_escape($quality_obs_id).", ".db_escape($_POST['standard'.$i]).", 
	                        ".db_escape($_POST['obs_a'.$i]).", ".db_escape($_POST['obs_b'.$i]).", 
	                        ".db_escape($_POST['remarks'.$i]).")";
	        db_query($sql,"The purch qc trans details could not be added");
	    }
	    for ($j=1; $j < 10; $j++) {
	        $sql = "INSERT INTO ".TB_PREF."quality_observations_testing_details (quality_obs_id, standard2, sample1, sample2)
	                VALUES (".db_escape($quality_obs_id).", ".db_escape($_POST['standard2'.$j]).", 
	                        ".db_escape($_POST['sample1'.$j]).", ".db_escape($_POST['sample2'.$j]).")";
	        db_query($sql,"The purch qc trans testing details could not be added");
	    }
	}

	commit_transaction();
 	meta_forward($path_to_root.'/manufacturing/qc_inquiry.php?');
}

//--------------------------------------------------------------------------------------------------
$kv_batch = get_company_pref('kv_batch');
$kv_exp_date = get_company_pref('kv_exp_date');
$row = get_work_order($_POST['trans_no']);
$myrow = get_item($row['stock_id']);
start_form();
	display_heading(_("Process Corrugated Sheet Test"));
start_outer_table(TABLESTYLE2, "width='80%'");
start_row();
$quality_obs2 = get_quality_observations($_POST['trans_no']);
if(!isset($_POST['date_']))
	$_POST['date_'] = sql2date($quality_obs2['date_']);
label_cells(_("Customer Name"), get_customer_name($myrow['customer_id']), "align='center'");
date_cells(_("Date"), 'date_', null, null, 0, 0, 0,$_POST['date_'], false);
end_row();
start_row();
label_cells(_("Product Name"), $myrow['description'] , "align='center'");
label_cells(_("Job No"), $row['job_no'] ? $row['job_no'] : '-' , "align='center'");
end_row();
end_outer_table(1);
display_po_receive_items($kv_batch, $kv_exp_date, $row);
echo '<br>';
echo "<center>";
submit_center_last('ProcessGoodsReceived', _("Process QC"), _("Clear all GL entry fields"), 'default');
echo "</center>";
end_form();
global $Ajax;
$Ajax->activate('_page_body');
//--------------------------------------------------------------------------------------------------
end_page();

