<?php 
$path_to_root = "../..";
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/inventory/includes/db/gsm_db.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");

$myrow = get_work_order($_GET['woid'], true);
$data = get_item($myrow['stock_id']);
$quality_obs = get_quality_observations($_GET['woid']);
$quality_obs_details =  get_quality_observations_details($quality_obs['id']);
$quality_obs_details_testing =  get_quality_observations_testing_details($quality_obs['id']);
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Process Corrugated Sheet Test Report</title>
</head>
<body>
    <table style="width:100%; border: 1px solid black; border-collapse: collapse;">
        <tr>
            <td rowspan="3" style="width: 2%; height: 2%; border: 1px solid black;">
                <img src="<?php echo company_path();?>/images/gp.png " style="width: 250px; height: 120px;" />
            </td>
            <td rowspan="3" colspan="6" style="text-align: center; font-weight: bold; border: 1px solid black;  ">
                <h1>Process Corrugated Sheet Test Report</h1>
            </td>
            <td style="text-align: center; font-size: 20px; font-weight: bold; border: 1px solid black; ">GP-F17-2</td>
        </tr>
        <tr>
          <td style="text-align: center; font-size: 20px; font-weight: bold; border: 1px solid black; "> 
            <?php 
            // $issue_no = get_work_order_issues($_GET['woid']);
            //       $wo_issue_no = db_fetch($issue_no)
            // <?php echo $wo_issue_no['issue_no']
             // <?php echo date('d-M-y', strtotime($wo_issue_no['issue_date']));
                   ?>
            <div>Issue No: 2  </div>
          </td>
        </tr>
        <tr>
          <td style="text-align: center; font-size: 20px; font-weight: bold; border: 1px solid black; "> 
             <div> Issue Date: 29/12/2023 </div>
          </td>
        </tr>
        <tr>
            <th style="font-weight: bold; font-size: 20px;">Customer Name:</th>
            <th colspan="3"><?php echo  get_customer_name($data['customer_id']); ?></th>
            <th style="font-weight: bold; font-size: 20px;">Date</th>
            <th colspan="3"><?php echo sql2date($quality_obs['date_']) ?></th>
        </tr>

        <tr>
            <th style="font-weight: bold; font-size: 20px;">Product Name:</th>
            <th colspan="3"><?php echo  $data['description']; ?></th>
            <th style="font-weight: bold; font-size: 20px;">Job No:</th>
            <th colspan="3"><?php echo $myrow['job_no'] ?></th>
        </tr>
        <tr>
            <td colspan="8" style="text-align: center; font-size: 18px; font-weight: bold; border: 1px solid black; "> 
            <h2>Quality Observations (PAPER)</h2>
          </td>
        </tr>
         <tr>
            <th style="font-weight: bold; font-size: 20px;">S.No</th>
            <th style="font-weight: bold; font-size: 20px;">Quality Tests</th>
            <th style="font-weight: bold; font-size: 20px;">Size</th>
            <th style="font-weight: bold; font-size: 20px;">Item</th>
            <th style="font-weight: bold; font-size: 20px;">Standard</th>
            <th style="font-weight: bold; font-size: 20px;">Obs</th>
            <th style="font-weight: bold; font-size: 20px;">Obs</th>
            <th style="font-weight: bold; font-size: 20px;">Average</th>
        </tr>
        <?php 
        $s_no = 1;
        // $bom = get_bom($myrow['stock_id']);
            $bom = get_wo_requirements($_GET['woid']);
        // display_error(db_num_rows($bom));
        while ($data2 = db_fetch($bom)) { ?>
            <tr>
                <th><?php echo  $s_no++ ?></th>
                <?php if($s_no==2){ ?>
                <th rowspan="<?php echo db_num_rows($bom);?>">Material Combination (Gsm)</th>
            <?php } ?>
                <th><?php  echo get_size_name($data2['size_id']); ?></th>
                <th><?php $item_description = get_item($data2['stock_id']);
                        echo  $item_description['description']; ?></th>
                <?php $myrow2 =  db_fetch($quality_obs_details) ?>
                <th class="data"><?php echo $myrow2['standard']; ?></th>
                <th class="data"><?php echo $myrow2['obs_a']; ?></th>
                <th class="data"><?php echo $myrow2['obs_b']; ?></th>
                <th class="data"><?php 
                 if($myrow2['obs_a'] > 0 AND $myrow2['obs_b'] > 0)
                    $average = ($myrow2['obs_a']+$myrow2['obs_b'])/2;
                 else
                    $average = $myrow2['obs_a'];
                 echo $average; ?></th>
            </tr>
        <?php  $size_name =  get_size_name($data2['size_id']); } ?>

        <tr>
            <td colspan="8" style="text-align: center; font-size: 18px; font-weight: bold; border: 1px solid black; "> 
            <h2>Quality Observations (Sizing)</h2>
          </td>
        </tr>
         <tr>
            <th style="font-weight: bold; font-size: 20px;">S.No</th>
            <th style="font-weight: bold; font-size: 20px;">Quality Tests</th>
            <th style="font-weight: bold; font-size: 20px;">Units</th>
            <th colspan="4" style="font-weight: bold; font-size: 20px;">Standard</th>
            <th style="font-weight: bold; font-size: 20px;">Remarks</th>
        </tr>
        <tr>
            <th rowspan="2">1</th>
            <th rowspan="2">Box Size</th>
            <th rowspan="2">mm</th>
            <th>L</th>
            <th>W</th>
            <th colspan="2">H</th>
            <?php 
            $i = 1;
            $quality_obs_details_remarks =  get_quality_observations_details($quality_obs['id']);
            while ($myrow3 =  db_fetch($quality_obs_details_remarks)) {  ?>
            <?php if($i == 1) {
                    $val = explode('-', $myrow3['remarks']);
                     // display_error($myrow3['remarks']);
             ?>
            <th rowspan="2" class="data"><?php echo "  <span style='padding: 15px;'> L   ".$val[0]." </span>   <span style='padding: 15px;'> W   ".$val[1]."  </span>   <span style='padding: 15px;'> H  ".$val[2] ." </span> "; ?></th>
            <?php  } $i++;  } ?>
        </tr>
        <tr>
            <th><?php echo $myrow['box_length'] ?></th>
            <th><?php echo $myrow['box_weight'] ?></th>
            <th colspan="2"><?php echo $myrow['sheet_heigh'] ?></th>
        </tr>
        <tr>
            <th>2</th>
            <?php           
            $box_weight = $myrow['box_weight']/2; ?>
            <th>Flap Size + Height + Flap Size</th>
            <th>mm</th>
            <th><?php echo $box_weight; ?></th>
            <th><?php echo $myrow['sheet_heigh']; ?></th>
            <th colspan="2"><?php echo $box_weight; ?></th>
            <?php 
            $i = 1;
            $quality_obs_details_remarks =  get_quality_observations_details($quality_obs['id']);
            while ($myrow3 =  db_fetch($quality_obs_details_remarks)) {  ?>
            <?php if($i == 2) {
              $val = explode('-', $myrow3['remarks']);   
             // display_error($myrow3['remarks']); ?>
            <th class="data"><?php echo "  <span style='padding: 15px;'>  ".$val[0]." </span>  <span style='padding: 15px;'>".$val[1]." </span> <span style='padding: 15px;'>  ".$val[2]." </span>"; ?></th>
            <?php  } $i++;  } ?>
        </tr>

        <tr>
            <th>3</th>
            <th>Reel Size</th>
            <th>inches</th>
            <th colspan="4"><?php echo $size_name ?></th>
            <?php 
            $i = 1;
            $quality_obs_details_remarks =  get_quality_observations_details($quality_obs['id']);
            while ($myrow3 =  db_fetch($quality_obs_details_remarks)) {  ?>
            <?php if($i == 3) { ?>
            <th class="data"><?php echo $myrow3['remarks']; ?></th>
            <?php  } $i++;  } ?>
        </tr>
        <tr>
            <th>4</th>
            <th>Sheet L/W</th>
            <th>inches</th>
            <?php 
            $sheet_lw = ($myrow['box_length']+$myrow['box_weight']+$myrow['box_length']+$myrow['box_weight'])+40; ?>
            <th colspan="4" style=" word-spacing: 10px ; "><?php echo $sheet_lw . " x " . ($box_weight+$myrow['sheet_heigh']+$box_weight) ?></th>
            <?php 
            $i = 1;
            $quality_obs_details_remarks =  get_quality_observations_details($quality_obs['id']);
            while ($myrow3 =  db_fetch($quality_obs_details_remarks)) {  ?>
            <?php if($i == 4) { 
              $val = explode('-', $myrow3['remarks']); 
                ?>
            <th class="data"><?php echo  $val[0]."  x  ". $val[1]; ?></th>
            <?php  } $i++;  } ?>
        </tr>
        <tr>
            <th>5</th>
            <th>Number of ups</th>
            <th></th>
            <th colspan="4"><?php echo $myrow['ups'] ?></th>
            <?php 
            $i = 1;
            $quality_obs_details_remarks =  get_quality_observations_details($quality_obs['id']);
            while ($myrow3 =  db_fetch($quality_obs_details_remarks)) {  ?>
            <?php if($i == 5) { ?>
            <th class="data"><?php echo $myrow3['remarks']; ?></th>
            <?php  } $i++;  } ?>
        </tr>

        <tr>
        <td colspan="8" style="text-align: center; font-size: 18px; font-weight: bold; border: 1px solid black; "> 
            <h2>Quality Observations (Testing)</h2>
          </td>
        </tr>
         <tr>
            <th style="font-weight: bold; font-size: 20px;">S.No</th>
            <th style="font-weight: bold; font-size: 20px;">Quality Tests</th>
            <th style="font-weight: bold; font-size: 20px;">Units</th>
            <th colspan="3" style="font-weight: bold; font-size: 20px;">Standard</th>
            <th style="font-weight: bold; font-size: 20px;">Sample 1</th>
            <th style="font-weight: bold; font-size: 20px;">Sample 2</th>
        </tr>
        <?php 
        $quality_test = [1 => 'Edge Crush', 2 => 'Gsm 100 x 100', 3 => 'Sheet Weight', 4 => 'Moisture',
          5 => 'Take-up Factor (B Flute)', 6 => 'Take-up Factor (C Flute)', 7 => 'Sheet Finishing',
          8 => 'Thickness', 9 => 'Ply'];
        $quality_test_unit = [1 => 'Kgf', 2 => 'Gm', 3 => 'Gm', 4 => '%', 5 => '-', 6 => '-', 7 => 'Obs',
          8 => 'mm', 9 => 'no'];
         ?>
        <?php for ($i=1; $i < 10; $i++) { 
            ?>
         <tr>
            <th><?php echo $i ?></th>
            <th><?php echo $quality_test[$i] ?></th>
            <th><?php echo $quality_test_unit[$i] ?></th>
            <?php $test_details = db_fetch($quality_obs_details_testing) ?>
            <th colspan="3" class="data"><?php echo $test_details['standard2'] ?></th>
            <th class="data"><?php echo $test_details['sample1'] ?></th>
            <th class="data"><?php echo $test_details['sample2'] ?></th>
        </tr>
        <?php } ?>


    </table>
    <div style="text-align: center; font-size: 18px; font-weight: bold; border: 1px solid black;">
      <h4 style="margin: 0; padding: 10px;">Tolerance: + / - 5 %</h4>
    </div>

  <div style="text-align: left; font-size: 18px; font-weight: bold; border: 1px solid black;">
      <h4 style="margin: 0; padding: 10px; display: inline-block; vertical-align: top;">Remarks:</h4>
      <div style="display: inline-block; vertical-align: top; padding: 10px;"><?php echo $quality_obs['memo_']; ?></div>
      <br>

  
      <h4 style="margin: 0; padding: 10px; display: inline-block; vertical-align: top;">Satus:</h4>
      <div class="label label-success" style="display: inline-block; vertical-align: top; padding: 10px;"><?php echo ($quality_obs['qc_status']) ? 'PASS' : 'REJECTED' ; ?></div> 

      <div style="position: absolute; left: 10px;">

               <h4 class="data" style="margin: 0; margin-top: 70px; margin-left: 50px; margin-bottom: 10px;"><?php  echo $quality_obs['Prepare_by'] ?></h4>
        <hr style="width: 150%; margin: 0; border-color: black; margin-top: 30px;">
        <h4 style="margin: 0; margin-top: 10px; margin-left: 50px; margin-bottom: 20px;">Prepared By</h4>
      </div>

       <div style="position: absolute; right: 50px;">
           <h4  class="data"  style="margin: 0; margin-top: 70px; margin-left: 50px; margin-bottom: 10px;"><?php  echo $quality_obs['perform_by'] ?></h4>
        <hr style="width: 120%; margin: 0; border-color: black; margin-top: 30px;">
        <h4 style="margin: 0; margin-top: 10px; margin-left: 50px; margin-bottom: 20px;">Perform By</h4>
      </div>

<!--       <div style="position: absolute; right: 10px;">
        <hr style="width: 50%; margin: 0; border-color: black;">
        <h4 style="margin: 0; padding: 10px;">Incharge Signature</h4>
      </div> -->
   </div>

<!-- Style -->
<style>

    body { 
     font-family:"Calibri (Body)";
}
th, td {
    border: 1px solid black;
    border-collapse: collapse;
    padding: 3.9px;
    font-family:"Calibri (Body)";
    font-weight: bold;

}

.data {
    color: gray;
}
</style>
</body>
</html>
