<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
    Released under the terms of the GNU General Public License, GPL, 
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CREATE_QC';
$path_to_root = "../..";
include($path_to_root . "/purchasing/includes/po_class.inc");
include($path_to_root . "/includes/session.inc");
include($path_to_root . "/purchasing/includes/purchasing_ui.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
    $js .= get_js_open_window(900, 500);
page(_($help_context = "View QC Trans"), true, false, "", $js);

if (!isset($_GET['wo_qc_no']))
{
    die ("<br>" . _("This page must be called with a purchase order number to review."));
}

display_heading(_("") . "QC Trans # ".  $_GET['wo_qc_no']);
br(2);

$row = get_qc_trans_order_no($_GET['wo_qc_no'], ST_WORKORDER);
$data = get_work_order($_GET['wo_qc_no']);
$myrow = get_item($data['stock_id']);
start_outer_table(TABLESTYLE2, "width='100%'");
start_outer_table(TABLESTYLE2, "width=90%");
start_row();
label_cells(_("Tested Date:"), sql2date($row['tested_date']), "class='tableheader2'");
label_cells(_("Item Description"), $myrow['description'], "class='tableheader2'");
end_row();
end_outer_table();
end_outer_table(1);

$trans_no = get_qc_trans_order_no($_GET['wo_qc_no'], ST_WORKORDER);
$result = get_purch_qc_trans_details($trans_no['id']);
start_form();
start_table(TABLESTYLE, "width='30%'");

$th = array(_("S.No"), _("Status"), _("Time"), _("Viscocity"), _("Jel Point"), 
        _("Solid Cont"));
table_header($th);

$sno=1;
$type = '-';
while ($myrow = db_fetch($result)) 
{
    $src_data = unserialize(base64_decode($myrow['src_data']));
    label_cell($sno , "align='center'");
    $sno++;
    label_cell($src_data["status"], "align='center'");
    label_cell($src_data["time"], "align='center'");
    label_cell($src_data["viscocity"], "align='center'");
    label_cell($src_data["jel_point"], "align='center'");
    label_cell($src_data["solid_cont"], "align='center'");
    end_row();
}
end_table();

//----------------------------------------------------------------------------------------------------

end_page(true, false, false);

