<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CREATE_QC';
$path_to_root = "..";
include_once($path_to_root . "/purchasing/includes/po_class.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/purchasing/includes/purchasing_db.inc");
include_once($path_to_root . "/purchasing/includes/purchasing_ui.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "QC Trans"), false, false, "", $js);

if (isset($_GET['trans_no']))
{
	$_POST['trans_no'] = $_GET['trans_no'];
	hidden('trans_no', $_POST['trans_no']);
}

//---------------------------------------------------------------------------------------------------------------

// if (isset($_GET['AddedID']))
// {
// 	$grn = $_GET['AddedID'];
// 	$trans_type = ST_SUPPRECEIVE;

// 	display_notification_centered(_("Purchase Order Delivery has been processed"));

// 	display_note(get_trans_view_str($trans_type, $grn, _("&View this Delivery")));
	
//     $clearing_act = get_company_pref('grn_clearing_act');
// 	if ($clearing_act)	
// 		display_note(get_gl_view_str($trans_type, $grn, _("View the GL Journal Entries for this Delivery")), 1);

// 	hyperlink_params("$path_to_root/purchasing/supplier_invoice.php", _("Entry purchase &invoice for this receival"), "New=1");

// 	hyperlink_no_params("$path_to_root/purchasing/inquiry/po_search.php", _("Select a different &purchase order for receiving items against"));

// 	display_footer_exit();
// }

// if (isset($_GET['AddedQC']))
// {
// 	$qc_id = $_GET['AddedQC'];

// 	hyperlink_params("$path_to_root/purchasing/view/qc_trans_view.php", _("View QC Trans"), 
// 		"qc_id=$qc_id");
// 	display_footer_exit();
// }


//--------------------------------------------------------------------------------------------------

if ((!isset($_GET['trans_no']) || $_GET['trans_no'] == 0) && !isset($_SESSION['QC']))
{
	die (_("This page can only be opened if a purchase order has been selected. Please select a purchase order first."));
}

//--------------------------------------------------------------------------------------------------

function display_po_receive_items($kv_batch=0, $kv_exp_date=0)
{
	global $Ajax;
	div_start('qc_trans');
	start_form();
    start_table(TABLESTYLE, "colspan=7 width='90%'");
    $th = array(_("S.No"), _("Status"), _("Time"), _("Viscocity"), _("Jel Point"), 
    	_("Solid Cont"));
    table_header($th);
    $trans_no = get_qc_trans_order_no($_GET['trans_no'],$_GET['type']);
    $result = get_purch_qc_trans_details($trans_no['id']);
    hidden('wo_qc_no',$trans_no['id']);

    $dec = 0;
    $sno=1;
   	for ($j=0; $j < 8; $j++) {
		alt_table_row_color($k);
            $data = db_fetch($result);
			$src_data = unserialize(base64_decode($data['src_data']));
			// display_error($data['src_data']);
			// print_r(unserialize(base64_decode($data['src_data'])));
			// print_r($src_data);
			// display_error($data['src_data'] .'=='. $src_data['status'] .'=='. $_POST['status'.$j]);
		 	$_POST['status'.$j] = $src_data['status']; 
		 	$_POST['time'.$j] = $src_data['time']; 
		 	$_POST['viscocity'.$j] = $src_data['viscocity']; 
		 	$_POST['jel_point'.$j] = $src_data['jel_point']; 
		 	$_POST['solid_cont'.$j] = $src_data['solid_cont']; 
		 	hidden('src_id'.$j, $data['id']);
		 	// display_error($data['id']);

		label_cell($sno , "align='center'");
		$sno++;
		small_qty_cells(null, 'status'.$j, $_POST['status'.$j], null, null, $dec);
		small_qty_cells(null, 'time'.$j, $_POST['time'.$j], null, null, $dec);
		small_qty_cells(null, 'viscocity'.$j, $_POST['viscocity'.$j], null, null, $dec);
		small_qty_cells(null, 'jel_point'.$j, $_POST['jel_point'.$j], null, null, $dec);
		small_qty_cells(null, 'solid_cont'.$j, $_POST['solid_cont'.$j], null, null, $dec);
		end_row();
    }
    end_table();
	end_form();
	div_end();
}
//--------------------------------------------------------------------------------------------------

function check_po_changed()
{
	/*Now need to check that the order details are the same as they were when they were read
	into the Items array. If they've changed then someone else must have altered them */
	// Compare against COMPLETED items only !!
	// Otherwise if you try to fullfill item quantities separately will give error.
	$result = get_po_items($_SESSION['QC']->order_no);

	$line_no = 0;
	while ($myrow = db_fetch($result))
	{
		$ln_item = $_SESSION['QC']->line_items[$line_no];
		// only compare against items that are outstanding
		$qty_outstanding = $ln_item->quantity - $ln_item->qty_received;
		if ($qty_outstanding > 0)
		{
    		if ($ln_item->qty_inv != $myrow["qty_invoiced"]	||
    			$ln_item->stock_id != $myrow["item_code"] ||
    			$ln_item->quantity != $myrow["quantity_ordered"] ||
    			$ln_item->qty_received != $myrow["quantity_received"])
    		{
    			return true;
    		}
		}
	 	$line_no++;
	} /*loop through all line items of the order to ensure none have been invoiced */

	return false;
}

//--------------------------------------------------------------------------------------------------

function can_process()
{
// 	global $SysPrefs;
	
// 	if (count($_SESSION['QC']->line_items) <= 0)
// 	{
//         display_error(_("There is nothing to process. Please enter valid quantities greater than zero."));
//     	return false;
// 	}

// 	if (!is_date($_POST['DefaultReceivedDate']))
// 	{
// 		display_error(_("The entered date is invalid."));
// 		set_focus('DefaultReceivedDate');
// 		return false;
// 	}
// 	if (!is_date_in_fiscalyear($_POST['DefaultReceivedDate'])) {
// 		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
// 		set_focus('DefaultReceivedDate');
// 		return false;
// 	}

// 	if (!check_reference($_POST['ref'], ST_SUPPRECEIVE))
// 	{
// 		set_focus('ref');
// 		return false;
// 	}

// 	$something_received = 0;
// 	foreach ($_SESSION['QC']->line_items as $order_line)
// 	{
// 	  	if ($order_line->receive_qty > 0)
// 	  	{
// 			$something_received = 1;
// 			break;
// 	  	}
// 	}

//     // Check whether trying to deliver more items than are recorded on the actual purchase order (+ overreceive allowance)
//     $delivery_qty_too_large = 0;
// 	foreach ($_SESSION['QC']->line_items as $order_line)
// 	{
// 	  	if ($order_line->receive_qty+$order_line->qty_received >
// 	  		$order_line->quantity * (1+ ($SysPrefs->over_receive_allowance() / 100)))
// 	  	{
// 			$delivery_qty_too_large = 1;
// 			break;
// 	  	}
// 	}

//     // if ($something_received == 0)
//     // { 	/*Then dont bother proceeding cos nothing to do ! */
//     //     display_error(_("There is nothing to process. Please enter valid quantities greater than zero."));
//     // 	return false;
//     // }
//     // elseif ($delivery_qty_too_large == 1)
//     // {
//     // 	display_error(_("Entered quantities cannot be greater than the quantity entered on the purchase order including the allowed over-receive percentage") . " (" . $SysPrefs->over_receive_allowance() ."%)."
//     // 		. "<br>" .
//     // 	 	_("Modify the ordered items on the purchase order if you wish to increase the quantities."));
//     // 	return false;
//     // }

// 	return true;
}

//--------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------

if (isset($_GET['trans_no']) && $_GET['trans_no'] > 0 && !isset($_POST['Update']))
{
	create_new_qc(ST_WORKORDER, $_GET['trans_no']);
	$_SESSION['QC']->trans_type = ST_SUPPRECEIVE;
	$_SESSION['QC']->reference = $Refs->get_next(ST_SUPPRECEIVE, null,
		array('date' => Today(), 'supplier' => $_SESSION['QC']->supplier_id));
	copy_from_cart();
}

//--------------------------------------------------------------------------------------------------

if (isset($_POST['Update']) || isset($_POST['ProcessGoodsReceived']))
{

	/* if update quantities button is hit page has been called and ${$line->line_no} would have be
 	set from the post to the quantity to be received in this receival*/
	// foreach ($_SESSION['QC']->line_items as $line)
	// {
	//  if( ($line->quantity - $line->qty_received)>0) {
	// 	$_POST[$line->line_no] = max($_POST[$line->line_no], 0);
	// 	if (!check_num($line->line_no))
	// 		$_POST[$line->line_no] = number_format2(0, get_qty_dec($line->stock_id));

	// 	if (!isset($_POST['DefaultReceivedDate']) || $_POST['DefaultReceivedDate'] == "")
	// 		$_POST['DefaultReceivedDate'] = new_doc_date();

	// 	$_SESSION['QC']->line_items[$line->line_no]->receive_qty = input_num($line->line_no);

	// 	if (isset($_POST[$line->stock_id . "Desc"]) && strlen($_POST[$line->stock_id . "Desc"]) > 0)
	// 	{
	// 		$_SESSION['QC']->line_items[$line->line_no]->item_description = $_POST[$line->stock_id . "Desc"];		

	// 		$_SESSION['QC']->line_items[$line->line_no]->batch_no = $_POST[$line->line_no . "batch_no"];
	// 		$_SESSION['QC']->line_items[$line->line_no]->exp_date = $_POST[$line->stock_id . "exp_date"];
	// 	}
	//  }
	// }
	$Ajax->activate('qc_trans');
}

//--------------------------------------------------------------------------------------------------

if (isset($_POST['ProcessGoodsReceived']) || isset($_POST['save']))
{

	begin_transaction();
	if (!$_POST['wo_qc_no']) {
	$sql = "INSERT INTO ".TB_PREF."purch_qc_trans (order_no, type, tested_date) VALUES (
	 ".db_escape($_POST['trans_no']).", ".db_escape(ST_WORKORDER).",
	'".date2sql($_POST['tested_date'])."')";
	// display_error($sql. 'Header Data');
   	db_query($sql,"The purch qc trans could not be added");
   	$qc_trans_id = db_insert_id();
	}
   	for ($j=0; $j < 8; $j++) {
	$data_array['status'] = $_POST['status'.$j];
	$data_array['time'] = $_POST['time'.$j];
	$data_array['viscocity'] = $_POST['viscocity'.$j];
	$data_array['jel_point'] = $_POST['jel_point'.$j];
	$data_array['solid_cont'] = $_POST['solid_cont'.$j];
	$src_data = base64_encode(serialize($data_array));
	// display_error($data_array['status'] .'='. $_POST['status'.$j] . '||'.
	// $data_array['time'] .'='. $_POST['time'.$j]);
	if (!$_POST['src_id'.$j]) {
	$sql = "INSERT INTO ".TB_PREF."purch_qc_trans_details (qc_trans_id, sno, src_data)
	  VALUES (".db_escape($qc_trans_id).", '0', ".db_escape($src_data).")";
	 // display_error($sql. 'Detail Data');
  	 db_query($sql,"The purch qc trans details could not be added");
  	 unset($src_data);
	}
	else{
	  $sql = "UPDATE ".TB_PREF."purch_qc_trans_details SET 
	  src_data=".db_escape($src_data)." WHERE id = ".db_escape($_POST['src_id'.$j]);
	  // display_error($sql);
      db_query($sql,"The purch qc trans details could not be added");
	  // display_error($_POST['wo_qc_no']. '=='. $_POST['src_id'.$j]);
	 }
	}
	// commit_transaction();
	if (isset($_POST['ProcessGoodsReceived'])) {
	if($_POST['trans_no'])
	{
		$sql = "UPDATE ".TB_PREF."workorders SET is_qc=1 WHERE 
		id=".db_escape($_POST['trans_no']);
   		// display_error($sql);
   		db_query($sql,"The purch orders is qc could not be updated");
	 }
	}
	commit_transaction();
 	meta_forward($path_to_root.'/manufacturing/search_work_orders.php?');
}
//--------------------------------------------------------------------------------------------------
$kv_batch = get_company_pref('kv_batch');
$kv_exp_date = get_company_pref('kv_exp_date');
$row = get_work_order($_POST['trans_no']);
$myrow = get_item($row['stock_id']);
start_form();
start_outer_table(TABLESTYLE2, "width='80%'");
date_row(_("Tested Date:"), 'tested_date', null, null, 0, 0, 0,$_POST['tested_date'], false);
label_row(_("Item Description"), $myrow['description'] , "align='center'");
end_outer_table(1);
display_heading(_("Items to Receive"));
display_po_receive_items($kv_batch, $kv_exp_date);

echo '<br>';
// submit_center_first('Update', _("Update"), '', true);
submit_center_first('save', _("Save"), '', null);
submit_center_last('ProcessGoodsReceived', _("Process QC"), _("Clear all GL entry fields"), 'default');

end_form();

//--------------------------------------------------------------------------------------------------
end_page();
