<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_MANUFRECEIVE';
$path_to_root = "..";
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/inventory.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/gl/includes/db/gl_db_bank_trans.inc");

include_once($path_to_root . "/manufacturing/includes/manufacturing_db.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_ui.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Chainge Work Center From Work Order"), false, false, "", $js);

if (isset($_GET['trans_no']) && $_GET['trans_no'] != "")
{
	$_POST['selected_id'] = $_GET['trans_no'];
}

//--------------------------------------------------------------------------------------------------

if (isset($_GET['AddedID']))
{
	include_once($path_to_root . "/reporting/includes/reporting.inc");
	$id = $_GET['AddedID'];
	$stype = ST_WORKORDER;

	display_notification(_("The manufacturing process has been entered."));
	
    display_note(get_trans_view_str($stype, $id, _("View this Work Order")));

   	display_note(get_gl_view_str($stype, $id, _("View the GL Journal Entries for this Work Order")), 1);
   	$ar = array('PARAM_0' => $_GET['date'], 'PARAM_1' => $_GET['date'], 'PARAM_2' => $stype); 
   	display_note(print_link(_("Print the GL Journal Entries for this Work Order"), 702, $ar), 1);

	hyperlink_no_params("search_work_orders.php", _("Select another &Work Order to Process"));
	br();

	end_page();
	exit;
}

//--------------------------------------------------------------------------------------------------

$wo_details = get_work_order($_POST['selected_id'], true);

if ($wo_details === false)
{
	display_error(_("The order number sent is not valid."));
	exit;
}

//--------------------------------------------------------------------------------------------------

function can_process($wo_details)
{
	global $SysPrefs;

	if (!check_reference($_POST['ref'], ST_MANURECEIVE))
	{
		set_focus('ref');
		return false;
	}

	if (!check_num('quantity', 0))
	{
		display_error(_("The quantity entered is not a valid number or less then zero."));
		set_focus('quantity');
		return false;
	}

	if (!is_date($_POST['date_']))
	{
		display_error(_("The entered date is invalid."));
		set_focus('date_');
		return false;
	}
	elseif (!is_date_in_fiscalyear($_POST['date_']))
	{
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('date_');
		return false;
	}
	if (date_diff2(sql2date($wo_details["released_date"]), $_POST['date_'], "d") > 0)
	{
		display_error(_("The production date cannot be before the release date of the work order."));
		set_focus('date_');
		return false;
	}
	// don't produce more that required. Otherwise change the Work Order.
	if (input_num('quantity') > ($wo_details["units_reqd"] - $wo_details["units_issued"]))
	{
		display_error(_("The production exceeds the quantity needed. Please change the Work Order."));
		set_focus('quantity');
		return false;
	}
	// if unassembling we need to check the qoh
	if (($_POST['ProductionType'] == 0) && !$SysPrefs->allow_negative_stock())
	{
		if (check_negative_stock($wo_details["stock_id"], -input_num('quantity'), $wo_details["loc_code"], $_POST['date_']))
		{
			display_error(_("The unassembling cannot be processed because there is insufficient stock."));
			set_focus('quantity');
			return false;
		}
	}
// display_error($_POST['workcentre_added']."  --- ".($wo_details['work_center_status']+1) );
	// if($_POST['workcentre_added']!=$wo_details['work_center_status']+1){
	// 	display_error(_("The production status process can not be direct next or previous stage."));
	// 		set_focus('workcentre_added');
	// 		return false;
	// }

	// if production we need to check the qoh of the wo requirements
	if (($_POST['ProductionType'] == 1) && !$SysPrefs->allow_negative_stock() && 
		$wo_details['out_service'] == 0)
	{
    	$err = false;
    	$result = get_wo_requirements($_POST['selected_id']);
		while ($row = db_fetch($result))
		{
			if ($row['mb_flag'] == 'D' || $_POST['workcentre_added']!=$row['workcentre']) // service, non stock
				continue;

            
			$qoh=check_negative_stock($row["stock_id"], -$row['units_req'] * input_num('quantity'), $row["loc_code"], $_POST['date_']);	
			// print_r($qoh);
           // display_error($qoh['qty']." sami ".$row['stock_id']." ==".$_POST['date_']);
			// exit();

			if (check_negative_stock($row["stock_id"], -$row['units_req'] * input_num('quantity'), $row["loc_code"], $_POST['date_']))
			{
    			display_error( _("The production cannot be processed because a required item would cause a negative inventory balance :") .
    				" " . $row['stock_id'] . " - " .  $row['description']." Loc: ".$row["location_name"]);
    			$err = true;
			}
		}
		if ($err)
		{
			set_focus('quantity');
			return false;
		}	
	}
	return true;
}

//--------------------------------------------------------------------------------------------------

if ((isset($_POST['Process']) || isset($_POST['ProcessAndClose'])) && can_process($wo_details) == true)
{

	$close_wo = 0;
	if (isset($_POST['ProcessAndClose']) && ($_POST['ProcessAndClose']!=""))
		$close_wo = 1;

	// if unassembling, negate quantity
	if ($_POST['ProductionType'] == 0)
		$_POST['quantity'] = -$_POST['quantity'];
	$row = get_work_order_produce($_POST['selected_id']);
	if(!$row)
	 {
 	    $date = date2sql($_POST['date_']);
		$sql = "INSERT INTO ".TB_PREF."wo_manufacture (workorder_id, reference, 
			quantity, date_)
		VALUES (".db_escape($_POST['selected_id']).", ".db_escape($_POST['ref']).", ".db_escape(input_num('quantity'))
		.", '$date')";
         // display_error($sql);
		db_query($sql,"A work order manufacture could not be added");
		$id = db_insert_id();
	 }
	 else
	 	$id=$row['id'];


	 // $id = work_order_produce($_POST['selected_id'], $_POST['ref'], input_num('quantity'),	$_POST['date_'], $_POST['memo_'], $close_wo, $_POST['batch_no'], $_POST['exp_date'], false);
 	$wo_order = get_work_order($_POST['selected_id']);
	 	// display_error($wo_order['out_service'] . 'in');
	 // if ($wo_order['out_service'] == 0) {
	 // work_order_production_gl_work_center($_POST['selected_id'], $product["stock_id"], 
	 // 	input_num('quantity'),$_POST['date_'], $id, $batch_no, $exp_date, false, 
	 // 	$_POST['workcentre_added']);
	 // }

 	$sql = "UPDATE ".TB_PREF."workorders SET work_center_status=".$_POST['workcentre_added']." WHERE id=".db_escape($_POST['selected_id']);
	db_query($sql, "Cannot update work cente for work order");
	meta_forward($_SERVER['PHP_SELF'], "AddedID=".$_POST['selected_id']."&date=".$_POST['date_']);
}

// if ((isset($_POST['ProcessStation']))
// {
//   work_order_production_gl($_POST['selected_id'], $product["stock_id"], input_num('quantity'),	$_POST['date_']
//   	, $id, $batch_no, $exp_date, $loc_code);

// } 

//-------------------------------------------------------------------------------------

display_wo_details($_POST['selected_id']);

//-------------------------------------------------------------------------------------

start_form();
hidden('selected_id', $_POST['selected_id']);

$dec = get_qty_dec($wo_details["stock_id"]);
if (!isset($_POST['quantity']) || $_POST['quantity'] == '')
	$_POST['quantity'] = qty_format(max($wo_details["units_reqd"] - $wo_details["units_issued"], 0), $wo_details["stock_id"], $dec);

start_table(TABLESTYLE2);
br();

date_row(_("Date:"), 'date_');
ref_row(_("Reference:"), 'ref', '', $Refs->get_next(ST_MANURECEIVE, null, get_post('date_')), false, ST_MANURECEIVE);

if (!isset($_POST['ProductionType']))
	$_POST['ProductionType'] = 1;

// yesno_list_row(_("Type:"), 'ProductionType', $_POST['ProductionType'],
// 	_("Produce Finished Items"), _("Return Items to Work Order"));
hidden('ProductionType', 1);

// small_qty_row(_("Quantity:"), 'quantity', null, null, null, $dec);
label_row(_("Quantity:"), $_POST['quantity']);
hidden('quantity', $_POST['quantity']);

workcenter_list_row(_("Work Centre Added:"), 'workcentre_added', $wo_details['work_center_status']  ,'Select Status');

// $kv_exp_date = get_company_pref('kv_exp_date');
// if(get_company_pref('kv_batch')  || $kv_exp_date){
// 	text_row(_("Batch No:"), 'batch_no', null, 20, 20);
// if($kv_exp_date)
// 	date_row(_("Exp Date:"), 'exp_date');
// }
textarea_row(_("Memo:"), 'memo_', null, 40, 3);

end_table(1);

submit_center_first('Process', _("Process"), '', 'default');
submit_center_last('ProcessAndClose', _("Process And Close Order"), '', true);

end_form();

end_page();

