<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_WORKORDERENTRY';
$path_to_root = "..";

include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");

include_once($path_to_root . "/manufacturing/includes/manufacturing_db.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_ui.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Work Order Entry"), false, false, "", $js);


check_db_has_manufacturable_items(_("There are no manufacturable items defined in the system."));

check_db_has_locations(("There are no inventory locations defined in the system."));

//---------------------------------------------------------------------------------------

if (isset($_GET['trans_no']))
{
	$selected_id = $_GET['trans_no'];
}
elseif(isset($_POST['selected_id']))
{
	$selected_id = $_POST['selected_id'];
}

if(isset($_GET['order_no']))
$_POST['order_no']=$_GET['order_no'];
// display_error($_POST['order_no']);

//---------------------------------------------------------------------------------------

if (isset($_GET['AddedID']))
{
	$id = $_GET['AddedID'];
	$stype = ST_WORKORDER;

	display_notification_centered(_("The work order been added."));

    display_note(get_trans_view_str($stype, $id, _("View this Work Order")), 0, 1);

	if ($_GET['type'] != WO_ADVANCED)
	{
		include_once($path_to_root . "/reporting/includes/reporting.inc");

		submenu_print(_("&Print This Work Order"), ST_WORKORDER, $id, 'prtopt');
		submenu_print(_("&Email This Work Order"), ST_WORKORDER, $id, null, 1);
    	display_note(get_gl_view_str($stype, $id, _("View the GL Journal Entries for this Work Order")), 1);
    	$ar = array('PARAM_0' => $_GET['date'], 'PARAM_1' => $_GET['date'], 'PARAM_2' => $stype, 'PARAM_3' => '',
    		'PARAM_4' => (user_def_print_orientation() == 1 ? 1 : 0)); 
    	display_note(print_link(_("Print the GL Journal Entries for this Work Order"), 702, $ar), 1);
		hyperlink_params("$path_to_root/admin/attachments.php", _("Add an Attachment"), "filterType=$stype&trans_no=$id");
	}
	
	safe_exit();
}

//---------------------------------------------------------------------------------------

if (isset($_GET['UpdatedID']))
{
	$id = $_GET['UpdatedID'];
	$stype = ST_WORKORDER;

	display_notification_centered(_("The work order has been updated."));
    display_note(get_trans_view_str($stype, $id, _("View this Work Order")));

	safe_exit();
}

//---------------------------------------------------------------------------------------

if (isset($_GET['DeletedID']))
{
	$id = $_GET['DeletedID'];

	display_notification_centered(_("Work order has been deleted."));
	safe_exit();
}

//---------------------------------------------------------------------------------------

if (isset($_GET['ClosedID']))
{
	$id = $_GET['ClosedID'];

	display_notification_centered(_("This work order has been closed. There can be no more issues against it.") . " #$id");
	safe_exit();
}

//---------------------------------------------------------------------------------------

function safe_exit()
{
	global $path_to_root;

	hyperlink_no_params("", _("Enter a new work order"));
	hyperlink_no_params("search_work_orders.php", _("Select an existing work order"));
	
	display_footer_exit();
}

//-------------------------------------------------------------------------------------
if (!isset($_POST['date_']))
{
	$_POST['date_'] = new_doc_date();
	if (!is_date_in_fiscalyear($_POST['date_']))
		$_POST['date_'] = end_fiscalyear();
}

function can_process()
{
	global $selected_id, $SysPrefs;

	if (!isset($selected_id))
	{
    	if (!check_reference($_POST['wo_ref'], ST_WORKORDER))
    	{
			set_focus('wo_ref');
    		return false;
    	}
	}

	if (!check_num('quantity', 1))
	{
		display_error( _("The quantity entered is invalid or less than zero."));
		set_focus('quantity');
		return false;
	}
		if (!check_num('dackle', 1))
	{
		display_error( _("The dackle size must be entered."));
		set_focus('dackle');
		return false;
	}
	
	if ($_POST['job_no'] == ""){

			display_error( _("The Job Card must be entered."));
		set_focus('dackle');

		}
	if(!isset($_POST['kv_batch'])) {
		if (strlen($_POST['batch_no']) == 0 )	{
			display_error( _("The Batch Number entered is invalid or less than zero."));
			set_focus('batch_no');
			return false;
		}elseif(db_has_batch_no($_POST['batch_no'])) {
			display_error( _("The Batch Number entered is already exists."));
			set_focus('batch_no');
			return false;
		}
	}
	if (!is_date($_POST['date_']))
	{
		display_error( _("The date entered is in an invalid format."));
		set_focus('date_');
		return false;
	}
	elseif (!is_date_in_fiscalyear($_POST['date_']))
	{
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('date_');
		return false;
	}
	// only check bom and quantites if quick assembly
	if (!($_POST['type'] == WO_ADVANCED))
	{
        if (!has_bom($_POST['stock_id']))
        {
        	display_error(_("The selected item to manufacture does not have a bom."));
			set_focus('stock_id');
        	return false;
        }

		if ($_POST['Labour'] == "")
			$_POST['Labour'] = price_format(0);
    	if (!check_num('Labour', 0))
    	{
    		display_error( _("The labour cost entered is invalid or less than zero."));
			set_focus('Labour');
    		return false;
    	}
		if ($_POST['Costs'] == "")
			$_POST['Costs'] = price_format(0);
    	if (!check_num('Costs', 0))
    	{
    		display_error( _("The cost entered is invalid or less than zero."));
			set_focus('Costs');
    		return false;
    	}

        if (!$SysPrefs->allow_negative_stock())
        {
        	if ($_POST['type'] == WO_ASSEMBLY)
        	{
        		// check bom if assembling
                $result = get_bom($_POST['stock_id']);

            	while ($bom_item = db_fetch($result))
            	{

            		if (has_stock_holding($bom_item["ResourceType"]))
            		{

                		$quantity = $bom_item["quantity"] * input_num('quantity');

                        if (check_negative_stock($bom_item["component"], -$quantity, $bom_item["loc_code"], $_POST['date_']))
                		{
                			display_error(_("The work order cannot be processed because there is an insufficient quantity for component:") .
                				" " . $bom_item["component"] . " - " .  $bom_item["description"] . ".  " . _("Location:") . " " . $bom_item["location_name"]);
							set_focus('quantity');
        					return false;
                		}
            		}
            	}
        	}
        	elseif ($_POST['type'] == WO_UNASSEMBLY)
        	{
        		// if unassembling, check item to unassemble
                if (check_negative_stock($_POST['stock_id'], -input_num('quantity'), $_POST['StockLocation'], $_POST['date_']))
        		{
        			display_error(_("The selected item cannot be unassembled because there is insufficient stock."));
					return false;
        		}
        	}
    	}
     }
     else
     {
    	if (!is_date($_POST['RequDate']))
    	{
			set_focus('RequDate');
    		display_error( _("The date entered is in an invalid format."));
    		return false;
		}
    	if (isset($selected_id))
    	{
    		if ($_POST['units_issued'] > input_num('quantity'))
    		{
				set_focus('quantity');
    			display_error(_("The quantity cannot be changed to be less than the quantity already manufactured for this order."));
        		return false;
    		}
    	}
	}

	return true;
}

//-------------------------------------------------------------------------------------

if (isset($_POST['ADD_ITEM']) && can_process())
{
	if (!isset($_POST['cr_acc']))
		$_POST['cr_acc'] = "";
	if (!isset($_POST['cr_lab_acc']))
		$_POST['cr_lab_acc'] = "";
	$_POST['batch_no'] = (isset($_POST['batch_no']) ? $_POST['batch_no'] : "");
	$_POST['exp_date'] = (isset($_POST['exp_date']) ? $_POST['exp_date'] : "");
	
	$id = add_work_order($_POST['wo_ref'], $_POST['StockLocation'], input_num('quantity'),
		$_POST['stock_id'],  $_POST['type'], $_POST['date_'], $_POST['RequDate'], $_POST['memo_'], 
		input_num('Costs'), $_POST['cr_acc'], input_num('Labour'), $_POST['cr_lab_acc'], $_POST['batch_no'],
		$_POST['exp_date'], input_num('order_no'), input_num('box_size'), input_num('dackle'), input_num('sheet_length'), 
		input_num('sheet_width'), input_num('flap_a'), input_num('hight'), input_num('cutt'), input_num('ups'), 
		input_num('wo_trim'), input_num('sq_m'), input_num('lm'),
		input_num('box_length'), input_num('box_weight'), input_num('sheet_heigh'),input_num('flap_b'), input_num('ctn_type'),$_POST['job_no'], input_num('zay'));

	new_doc_date($_POST['date_']);
	meta_forward($_SERVER['PHP_SELF'], "AddedID=$id&type=".$_POST['type']."&date=".$_POST['date_']);
}

//-------------------------------------------------------------------------------------

if (isset($_POST['UPDATE_ITEM']) && can_process())
{

	update_work_order($selected_id, $_POST['StockLocation'], input_num('quantity'),
		$_POST['stock_id'],  $_POST['date_'], $_POST['RequDate'], $_POST['memo_'], input_num('box_size'), input_num('dackle'), 
		input_num('sheet_length'), input_num('sheet_width'), input_num('flap_a'), input_num('hight'), input_num('cutt'), 
		input_num('ups'), input_num('wo_trim'), input_num('sq_m'), input_num('lm'),
		input_num('box_length'), input_num('box_weight'), input_num('sheet_heigh'),input_num('flap_b'), input_num('ctn_type'),$_POST['job_no'], input_num('zay'));
	new_doc_date($_POST['date_']);
	new_doc_date($_POST['date_']);
	meta_forward($_SERVER['PHP_SELF'], "UpdatedID=$selected_id");
}

//--------------------------------------------------------------------------------------

if (isset($_POST['delete']))
{
	//the link to delete a selected record was clicked instead of the submit button

	$cancel_delete = false;

	// can't delete it there are productions or issues
	if (work_order_has_productions($selected_id) ||
		work_order_has_issues($selected_id)	||
		work_order_has_payments($selected_id))
	{
		display_error(_("This work order cannot be deleted because it has already been processed."));
		$cancel_delete = true;
	}

	if ($cancel_delete == false)
	{ //ie not cancelled the delete as a result of above tests

		// delete the actual work order
		delete_work_order($selected_id, $_POST['stock_id'], $_POST['quantity'], $_POST['date_']);
		meta_forward($_SERVER['PHP_SELF'], "DeletedID=$selected_id");
	}
}

//-------------------------------------------------------------------------------------

if (isset($_POST['close']))
{

	// update the closed flag in the work order
	close_work_order($selected_id);
	meta_forward($_SERVER['PHP_SELF'], "ClosedID=$selected_id");
}

//-------------------------------------------------------------------------------------
if (get_post('_type_update')) 
{
  $Ajax->activate('_page_body');
}
//-------------------------------------------------------------------------------------

start_form();
$kv_batch = get_company_pref('kv_batch');
$kv_exp_date = get_company_pref('kv_exp_date');
start_table(TABLESTYLE2);

$existing_comments = "";

$dec = 0;
if (isset($selected_id))
{
	$myrow = get_work_order($selected_id, true);
	// print_r($myrow);

	if ($myrow === false)
	{
		echo _("The order number sent is not valid.");
		safe_exit();
	}

	// if it's a closed work order can't edit it
	if ($myrow["closed"] == 1)
	{
		echo "<center>";
		display_error(_("This work order is closed and cannot be edited."));
		safe_exit();
	}
    

    if($_GET['trans_no']){
	$_POST['wo_ref'] = $myrow["wo_ref"];
	$_POST['stock_id'] = $myrow["stock_id"];
	//$_POST['quantity'] = qty_format($myrow["units_reqd"], $_POST['stock_id'], $dec);
	$_POST['quantity'] = $myrow["units_reqd"];
	$_POST['StockLocation'] = $myrow["loc_code"];
	$_POST['released'] = $myrow["released"];
	$_POST['closed'] = $myrow["closed"];
	$_POST['date_'] = sql2date($myrow["date_"]);
	$_POST['RequDate'] = sql2date($myrow["required_by"]);
	$_POST['released_date'] = sql2date($myrow["released_date"]);
	$_POST['units_issued'] = $myrow["units_issued"];
	$_POST['Costs'] = price_format($myrow["additional_costs"]);

	$_POST['memo_'] = get_comments_string(ST_WORKORDER, $selected_id);
	$_POST['box_size'] = $myrow["box_size"];
	$_POST['dackle'] = $myrow["dackle"];
	$_POST['sheet_length'] = $myrow["sheet_length"];
	$_POST['sheet_width'] = $myrow["sheet_width"];
	$_POST['flap'] = $myrow["flap"];
	$_POST['hight'] = $myrow["hight"];
	$_POST['cutt'] = $myrow["cutt"];
	$_POST['ups'] = $myrow["ups"];
	$_POST['wo_trim'] = $myrow["wo_trim"];
	$_POST['sq_m'] = $myrow["sq_m"];
	$_POST['lm'] = $myrow["lm"];
	$_POST['ctn_type'] = $myrow['ctn_type'];
}
	$_POST['type'] = $myrow["type"];



	hidden('wo_ref', $_POST['wo_ref']);
	hidden('units_issued', $_POST['units_issued']);
	hidden('released', $_POST['released']);
	hidden('released_date', $_POST['released_date']);
	hidden('selected_id',  $selected_id);

	label_row(_("Reference:"), $_POST['wo_ref']);
	label_row(_("Type:"), $wo_types_array[$_POST['type']]);
	hidden('type', $myrow["type"]);
	hidden('ctn_type', $myrow["ctn_type"]);
}
else
{
	$_POST['units_issued'] = $_POST['released'] = 0;

	ref_row(_("Reference:"), 'wo_ref', '', $Refs->get_next(ST_WORKORDER, null, array('date' => (get_post('date_')) ? get_post('date_') : Today()) ), false, ST_WORKORDER);


   	text_row(_("Job Card # :"), 'job_no', null, 20, 60);
	wo_types_list_row(_("Type:"), 'type', null);
	// if($_GET['ctn_type'])
	// 	$_POST['ctn_type']=$_GET['ctn_type'];
	$_POST['ctn_type']=($_GET['ctn_type']) ? $_GET['ctn_type'] : $_POST['ctn_type'];
	carton_type_list_row(_("Carton Type:"), 'ctn_type', $_GET['ctn_type']);
	label_cells(_("Carton Type"), '<span class="label label-warning">'.$wo_ctn_types_array[$_POST['ctn_type']].'<span>'  ,"align='center'");

	if( ($_POST['ctn_type']!=WO_CTN_SHEETS)  && !$_GET['ctn_type']){
			get_carton_type_meta_forward($_POST['order_no'],$_POST['ctn_type']);

           
	}
	if($_POST['order_no']){

		$order_row = get_sales_order_header($_POST['order_no'], ST_SALESORDER);
		$_POST['customer_id']= $order_row['debtor_no'];
    }
      customer_list_row(_("Customer:"), 'customer_id', $_POST['customer_id'], false, true, false, true);


}


// display_error($_GET['trans_no']);
if($_GET['trans_no'])
text_row(_("Job Card # :"), 'job_no', $_POST['job_no'], 20, 60);

if (get_post('released'))
{
	hidden('stock_id', $_POST['stock_id']);
	hidden('StockLocation', $_POST['StockLocation']);
	hidden('type', $_POST['type']);

	label_row(_("Item:"), $myrow["StockItemName"]);
	label_row(_("Destination Location:"), $myrow["location_name"]);
}
else
{
	// stock_manufactured_items_list_row(_("Item:"), 'stock_id', null, false, true);
sales_order_list_row(_("Item:"), 'stock_id', null, false, null, true, $_POST['order_no']);
	if (list_updated('stock_id'))
		$Ajax->activate('quantity');

    if(!$_POST['StockLocation'])
    $_POST['StockLocation']='PLF';	
	locations_list_row(_("Destination Location:"), 'StockLocation', null);
}

// if (!input_num('quantity'))
// 	$_POST['quantity'] = qty_format(1, $_POST['stock_id'], $dec);
// else
// 	$_POST['quantity'] = qty_format($_POST['quantity'], $_POST['stock_id'], $dec);
	
hidden('order_no', $_POST['order_no']);
$dec = user_price_dec();
if($_POST['order_no'])
$so_details = get_sales_order_details($_POST['order_no'], ST_SALESORDER);
while($so_result = db_fetch($so_details))
{
	if($so_result['stk_code']==$_POST['stock_id'])
	{

	
		if(!$_POST['quantity'] || list_updated('stock_id'))
       $_POST['quantity']=$so_result['quantity'];	
        $Ajax->activate('_page_body');
	  break;
	}	
	// exit();
}		

if (get_post('type') == WO_ADVANCED)
{
    qty_row(_("Quantity Required:"), 'quantity', $_POST['quantity'], null, null, $dec, true);
    if ($_POST['released'])
    	label_row(_("Quantity Manufactured:"), number_format($_POST['units_issued'], get_qty_dec($_POST['stock_id'])));
    date_row(_("Date") . ":", 'date_', '', true);
	date_row(_("Date Required By") . ":", 'RequDate', '', null, $SysPrefs->default_wo_required_by());
}
else
{
    qty_row(_("Quantity:"), 'quantity', null, null, null, $dec, true);
    date_row(_("Date") . ":", 'date_', '', true);
	hidden('RequDate', '');

	if (!isset($_POST['Labour']) || list_updated('stock_id') || list_updated('type'))
	{
		$bank_act = get_default_bank_account();
		$item = get_item(get_post('stock_id'));
		$_POST['Labour'] = price_format(get_post('type') == WO_ASSEMBLY ? $item['labour_cost'] : 0);
		$_POST['cr_lab_acc'] = $bank_act['account_code'];
		$_POST['Costs'] = price_format(get_post('type') == WO_ASSEMBLY ? $item['overhead_cost'] : 0);
		$_POST['cr_acc'] = $bank_act['account_code'];
		$Ajax->activate('_page_body');
	}

	amount_row($wo_cost_types[WO_LABOUR], 'Labour');
	gl_all_accounts_list_row(_("Credit Labour Account"), 'cr_lab_acc', null);
	amount_row($wo_cost_types[WO_OVERHEAD], 'Costs');
	gl_all_accounts_list_row(_("Credit Overhead Account"), 'cr_acc', null);

}
if(get_post('quantity') || get_post('box_length') ||  get_post('box_weight') || get_post('sheet_heigh'))
{
	global $Ajax;

	$Ajax->activate('_page_body');

}
if (get_post('released')){
	label_row(_("Released On:"),$_POST['released_date']);
}
// get_post('released') ||
if (($kv_batch || $kv_exp_date) && (get_post('type') != WO_ADVANCED)) {	
	text_row(_("Batch No:"), 'batch_no', null, 20, 20);	
	if($kv_exp_date)
		date_row(_("Exp Date:"), 'exp_date', null, null, null, $dec);
} else {
	hidden('batch_no' , 0);
	hidden('exp_date' , '');
	hidden('kv_batch' , 1);	
}

textarea_row(_("Memo:"), 'memo_', null, 40, 5);
label_row(_("Sales Order #"), ($_POST['order_no']) ?  get_customer_trans_view_str(ST_SALESORDER, $_POST['order_no']) : '-');
hidden('order_no', $_POST['order_no']);
$dec = user_price_dec();
// qty_row(_("Box Size:"), 'box_size', null, null, null, null, true); 
// $result = get_work_order_data($_POST['stock_id']);
// print_r($result);
label_row(_("L:"), '0', null, null, null, null, true);
hidden('box_length', 0);
label_row(_("W:"), '0', null, null, null, null, true);
hidden('box_weight', 0);
label_row(_("H:"), '0', null, null, null, null, true);
hidden('sheet_heigh', 0);
// $_POST['short_flap'] = ($_POST['short_flap']) ? $_POST['short_flap'] : 5;
label_row(_("Short Flap:"), '0', null, null, null, null, true);
hidden('short_flap', 0);
// $flap_a = ($_POST['box_weight']/2-$_POST['short_flap']);
// $flap_b = ($_POST['box_weight']/2-$_POST['short_flap']);
label_row(_("Carton Flap A:"), '0', null, 15, null);
hidden('flap_a', 0);
label_row(_("Carton Flap B:"), '0', null, 15, null);
hidden('flap_b', 0);
label_row(_("Carton Hight:"), '0', null, 15, null);
hidden('hight', 0);
qty_row(_("Ups:"), 'ups', input_num('ups'), null, null, null, true);
label_row(_("Zay:"), '0', null, null, null, null, true);
hidden('zay', 0);
// $sheet_length = ($_POST['box_length']+$_POST['box_weight'])*2+$_POST['zay'];
// display_error($_POST['box_length']." + ".$_POST['box_weight']." *2+40 ");
text_row(_("Sheet Length:"), 'sheet_length', $_POST['sheet_length'], 15, null, null, "", "", true);
$sheet_length_total = ($_POST['sheet_length']/25.4);
// display_error($sheet_length_total);
label_row(_("Sheet Length Inch"), number_format2($sheet_length_total,$dec));
$Ajax->activate('_page_body');
$_POST['sheet_length_total'] = $sheet_length_total;
hidden('sheet_length_total', $_POST['sheet_length_total']);
// $sheet_width = ($flap_a+$_POST['sheet_heigh']+$flap_b);
// display_error($sheet_width ."  ==  ".$flap_a." == ".$_POST['sheet_heigh']." == ".$flap_b );
text_row(_("Sheet Width:"), 'sheet_width', $_POST['sheet_width'], 15, null, null, "", "", true);
$sheet_width_total = ($_POST['sheet_width']/25.4);
label_row(_("Sheet Width Inch"), number_format2($sheet_width_total,$dec));

if(!input_num('dackle'))
$dackle = ( $_POST['sheet_width'])*input_num('ups')/25.4;
else
$dackle = $_POST['dackle'];

// display_error($_POST['dackle']);
// display_error("(".$flap."+".$_POST['hight']."+".$flap." ) * ".input_num('ups')." / 25.4 + 0.75  = ".$_POST['dackle'] ."  flap = ".$flap );
label_row(_("Dackel Calculated"), number_format2($dackle,$dec) );
text_row(_("Dackle:"), 'dackle', number_format2($_POST['dackle'], $dec), 15, null, null, "", "",
	true);
$dackle_total = $dackle*25.4;
// label_row(_("Dackle mm"), number_format2($dackle_total,$dec));
// qty_row(_("Dackle:"), 'dackle', null, null, null, null, true);
// if(input_num('ups'))
$cutt = (input_num('quantity')/input_num('ups'));
// display_error($cutt." == ".input_num('quantity')." == ".input_num('ups'));
text_row(_("Cutt:"), 'cutt', number_format2($cutt, $dec), 15, null);
// $wo_trim = ($sheet_width*$_POST['ups'])-$dackle_total; //$_POST['dackle']*25.4;
// text_row(_("Trim:"), 'wo_trim', number_format2($wo_trim, $dec), 15, null);
label_row(_("Trim:"), '0', null, null, null, null, true);
hidden('wo_trim', 0);
$lm = ($_POST['sheet_length']/input_num('ups')*input_num('quantity')/1000);
// if($sheet_length)
text_row(_("LM:"), 'lm', number_format2($lm, $dec), 15, null);
$sq_m = ($lm*$dackle*25.34)/1000;
// display_error($sq_m);
// display_error($_POST['dackle'] . '=='. $lm. '=='. $sq_m);
// if($cutt)
text_row(_("SQ:M:"), 'sq_m', number_format2($sq_m, $dec), 15, null);
check_row(_("Out Service"), 'out_service', input_num('out_service'), true);

end_table(1);
    display_bom_requirements($_POST['stock_id'], input_num('quantity'), true, $_POST['date_'], $_POST['cutt'], input_num('ups'), $_POST['sheet_length_total']);

if (isset($selected_id))
{
	echo "<table align=center><tr>";

	submit_cells('UPDATE_ITEM', _("Update"), '', _('Save changes to work order'), 'default');
	if (get_post('released'))
	{
		submit_cells('close', _("Close This Work Order"),'','',true);
	}
	submit_cells('delete', _("Delete This Work Order"),'','',true);

	echo "</tr></table>";
}
else
{
	submit_center('ADD_ITEM', _("Add Workorder"), true, '', 'default');
}

end_form();
end_page();

