<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_MANUFISSUE';
$path_to_root = "..";

include_once($path_to_root . "/includes/ui/items_cart.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_db.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_ui.inc");
include_once($path_to_root . "/manufacturing/includes/work_order_issue_glue_ink_ui.inc");
include_once($path_to_root . "/manufacturing/includes/db/issue_glue_ink_db.inc");
include_once($path_to_root . "/manufacturing/includes/db/issue_type_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

page(_($help_context = "Issue Items to Work Order Glue Ink"), false, false, "", $js);

//-----------------------------------------------------------------------------------------------

if (isset($_GET['AddedID'])) 
{
	$id = $_GET['AddedID'];
   	display_notification(_("The work order issue has been entered."));

    display_note(get_trans_view_str(ST_WORKORDER, $id, _("View this Work Order")));

   	display_note(get_gl_view_str(ST_WORKORDER, $id, _("View the GL Journal Entries for this Work Order")), 1);

   	hyperlink_no_params("search_work_orders.php", _("Select another &Work Order to Process"));

	display_footer_exit();
}
//--------------------------------------------------------------------------------------------------

function line_start_focus() {
  global 	$Ajax;

  $Ajax->activate('items_table');
  set_focus('_stock_id_edit');
}

//--------------------------------------------------------------------------------------------------

function handle_new_order()
{
	if (isset($_SESSION['issue_items']))
	{
		$_SESSION['issue_items']->clear_items();
		unset ($_SESSION['issue_items']);
	}

     $_SESSION['issue_items'] = new items_cart(ST_MANUISSUE);
     $_SESSION['issue_items']->order_id = $_GET['trans_no'];
}

//-----------------------------------------------------------------------------------------------
function can_process()
{
	if (!is_date($_POST['date_']))
	{
		display_error(_("The entered date for the issue is invalid."));
		set_focus('date_');
		return false;
	} 
	elseif (!is_date_in_fiscalyear($_POST['date_']))
	{
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('date_');
		return false;
	}
	if (!check_reference($_POST['ref'], ST_MANUISSUE))
	{
		set_focus('ref');
		return false;
	}

	$failed_item = $_SESSION['issue_items']->check_qoh($_POST['Location'], $_POST['date_'], !$_POST['IssueType']);
	if ($failed_item)
	{
   		display_error(_("The issue cannot be processed because it would cause negative inventory balance for marked items as of document date or later."));
		return false;
	}

	return true;
}

if (isset($_POST['Process']) && can_process())
{

	// if failed, returns a stockID

	$result = get_item_issue_glue_ink(2);
	$i = 1;
	$is_item_wo=0;
	while ($myrow = db_fetch($result)) {
			if ($_POST['qty_glue'.$i] > 0) {
				$std_cost = get_betch_price($_POST['glue_batch_no'.$i], $_POST['glue_item'.$i]);
				add_to_issue($_SESSION['issue_items'], $_POST['glue_item'.$i], $_POST['qty_glue'.$i],
				$std_cost, $_POST['glue_batch_no'.$i], Today());
            	$is_item_wo=1;
			}
	     $i++;
	}

	$result = get_item_issue_glue_ink(3);
	$i = 1;
	$is_item_wo=0;
	while ($myrow = db_fetch($result)) {
			if ($_POST['qty_ink'.$i] > 0) {
				$std_cost = get_betch_price($_POST['ink_batch_no'.$i], $_POST['ink_item'.$i]);
				add_to_issue($_SESSION['issue_items'], $_POST['ink_item'.$i], $_POST['qty_ink'.$i],
				$std_cost, $_POST['ink_batch_no'.$i], Today());
            	$is_item_wo=1;
			}
	     $i++;
	}

	$failed_data = add_work_order_issue($_SESSION['issue_items']->order_id,
		$_POST['ref'], $_POST['IssueType'], $_SESSION['issue_items']->line_items,
		$_POST['Location'], $_POST['WorkCentre'], $_POST['date_'], $_POST['memo_'],
		input_num('gsm_id'), input_num('size_id'));



	if ($failed_data != null) 
	{
		display_error(_("The process cannot be completed because there is an insufficient total quantity for a component.") . "<br>"
		. _("Component is :"). $failed_data[0] . "<br>"
		. _("From location :"). $failed_data[1] . "<br>");
	} 
	else 
	{
		// meta_forward($_SERVER['PHP_SELF'], "AddedID=".$_SESSION['issue_items']->order_id);
	}

} /*end of process credit note */

//-----------------------------------------------------------------------------------------------

function check_item_data()
{
	if (input_num('qty') == 0 || !check_num('qty', 0))
	{
		display_error(_("The quantity entered is negative or invalid."));
		set_focus('qty');
		return false;
	}

	if (!check_num('std_cost', 0))
	{
		display_error(_("The entered standard cost is negative or invalid."));
		set_focus('std_cost');
		return false;
	}

   	return true;
}

//-----------------------------------------------------------------------------------------------

function handle_update_item()
{
    if($_POST['UpdateItem'] != "" && check_item_data())
    {
		$id = $_POST['LineNo'];
    	$_SESSION['issue_items']->update_cart_item($id, input_num('qty'), input_num('std_cost'),
    	 input_num('gsm_id'), input_num('size_id'));
    }
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

function handle_delete_item($id)
{
	$_SESSION['issue_items']->remove_from_cart($id);
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

function handle_new_item()
{
	if (!check_item_data())
		return;

	add_to_issue($_SESSION['issue_items'], $_POST['stock_id'], input_num('qty'),
		 input_num('std_cost'), get_post('batch_no'), get_post('exp_date'), input_num('gsm_id'), input_num('size_id'), $_POST['issue_type']);
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------
$id = find_submit('Delete');
if ($id != -1)
	handle_delete_item($id);

if (isset($_POST['AddItem']))
	handle_new_item();

if (isset($_POST['UpdateItem']))
	handle_update_item();

if (isset($_POST['CancelItemChanges'])) {
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

if (isset($_GET['trans_no']))
{
	handle_new_order();
}
$kv_batch = get_company_pref('kv_batch');
$kv_exp_date = get_company_pref('kv_exp_date');
//-----------------------------------------------------------------------------------------------
display_wo_details($_SESSION['issue_items']->order_id, false, $kv_batch, $kv_exp_date);
echo "<br>";

start_form();


start_table(TABLESTYLE, "width='90%'", 10);
issue_options_controls();
// echo "<tr><td>";
// display_issue_items(_("Items to Issue/Westage"), $_SESSION['issue_items'], $kv_batch, $kv_exp_date);
// echo "</td></tr>";
br(1);
end_table();

display_heading('Glue');
start_outer_table(TABLESTYLE2, "width='60%'");
$th = array(_("Item Code"), _("Batch No."), _("Quantity"));
table_header($th);
table_section(1);
$result = get_item_issue_glue_ink(2);
$i = 1;
while ($myrow = db_fetch($result)) {
	global $Ajax;
	// if(!$_POST['westage_item'.$i] && !list_updated('type'))
	$_POST['glue_item'.$i] = $myrow['stock_id'];
	$item_name_ = get_item($_POST['glue_item'.$i]);
	start_row();
	stock_component_items_list_cells(null, 'glue_item'.$i, null, $_POST['glue_item'.$i], false, true);
	// stock_component_items_list_rows(_("Westage"), 'glue_item'.$i, null, $_POST['glue_item'.$i], false, true);
	kv_batch_list_cells(null, 'glue_batch_no'.$i, null, true, true, $_POST['glue_item'.$i], $_POST['Location'],0, 0);
	text_cells(null,'qty_glue'.$i, $_POST['qty_glue'.$i], 25, 100, null, "", "", true);
	end_row();
	$Ajax->activate('_page_body');
	$i++;
}

end_outer_table();
display_heading('Printing Ink');
start_outer_table(TABLESTYLE2, "width='60%'");
$th = array(_("Item Code"), _("Batch No."), _("Quantity"));
table_header($th);
table_section(1);
$result = get_item_issue_glue_ink(3);
$i = 1;
while ($myrow = db_fetch($result)) {
	global $Ajax;
	// if(!$_POST['westage_item'.$i] && !list_updated('type'))
	$_POST['ink_item'.$i] = $myrow['stock_id'];
	$item_name_ = get_item($_POST['ink_item'.$i]);
	start_row();
	stock_component_items_list_cells(null, 'ink_item'.$i, null, $_POST['ink_item'.$i], false, true);
	kv_batch_list_cells(null, 'ink_batch_no'.$i, null, true, true, $_POST['ink_item'.$i], $_POST['Location'],0, 0);
	text_cells(null,'qty_ink'.$i, $_POST['qty_ink'.$i], 25, 100, null, "", "", true);
	end_row();
	$Ajax->activate('_page_body');
	$i++;
}

end_outer_table();

br(1);
submit_center('Process', _("Process Issue"), true, '', 'default');

end_form();
//------------------------------------------------------------------------------------------------
end_page();

