<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_MANUFISSUE';
$path_to_root = "..";

include_once($path_to_root . "/includes/ui/items_cart.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_db.inc");
include_once($path_to_root . "/manufacturing/includes/manufacturing_ui.inc");
include_once($path_to_root . "/manufacturing/includes/work_order_issue_wo_stock_reserve_ui.inc");
// include_once($path_to_root . "/manufacturing/includes/work_order_issue_glue_ink_ui.inc");
include_once($path_to_root . "/manufacturing/includes/db/issue_glue_ink_db.inc");
include_once($path_to_root . "/manufacturing/includes/db/issue_type_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

page(_($help_context = "Issue/Westage Items to Work Order"), false, false, "", $js);

//-----------------------------------------------------------------------------------------------

if (isset($_GET['AddedID'])) 
{
	$id = $_GET['AddedID'];
   	display_notification(_("The work order issue has been entered."));

    display_note(get_trans_view_str(ST_WORKORDER, $id, _("View this Work Order")));

   	display_note(get_gl_view_str(ST_WORKORDER, $id, _("View the GL Journal Entries for this Work Order")), 1);

   	hyperlink_no_params("search_work_orders.php", _("Select another &Work Order to Process"));

	display_footer_exit();
}
//--------------------------------------------------------------------------------------------------

function line_start_focus() {
  global 	$Ajax;

  $Ajax->activate('items_table');
  set_focus('_stock_id_edit');
}

//--------------------------------------------------------------------------------------------------
function handle_new_order()
{
	if (isset($_SESSION['issue_items']))
	{
		$_SESSION['issue_items']->clear_items();
		unset ($_SESSION['issue_items']);
	}

     $_SESSION['issue_items'] = new items_cart(ST_MANUISSUE);
     $_SESSION['issue_items']->order_id = $_GET['trans_no'];
}

//-----------------------------------------------------------------------------------------------
function can_process()
{
	if (!is_date($_POST['date_']))
	{
		display_error(_("The entered date for the issue is invalid."));
		set_focus('date_');
		return false;
	} 
	elseif (!is_date_in_fiscalyear($_POST['date_']))
	{
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('date_');
		return false;
	}
	if (!check_reference($_POST['ref'], ST_MANUISSUE))
	{
		set_focus('ref');
		return false;
	}

	$failed_item = $_SESSION['issue_items']->check_qoh($_POST['Location'], $_POST['date_'], !$_POST['IssueType']);
	if ($failed_item)
	{
   		display_error(_("The issue cannot be processed because it would cause negative inventory balance for marked items as of document date or later."));
		return false;
	}

	return true;
}

if (isset($_POST['Process']) && can_process())
{

	// if failed, returns a stockID

	if ($_POST['sheets_qty'] > 0) {
		add_to_issue($_SESSION['issue_items'], '88669458', -$_POST['sheets_qty'],
		$_POST['sheets_unit_cost'], $_POST['sheets_batch_no'], Today(), 0, 0, 1);
	}

	// $result = get_item_issue_glue_ink(3);
	// $i = 1;
	// $is_item_wo=0;
	// while ($myrow = db_fetch($result)) {
	// 		if ($_POST['qty_ink'.$i] > 0) {
	// 			$std_cost = get_betch_price($_POST['ink_batch_no'.$i], $_POST['ink_item'.$i]);
	// 			add_to_issue($_SESSION['issue_items'], $_POST['ink_item'.$i], $_POST['qty_ink'.$i],
	// 			$std_cost, $_POST['ink_batch_no'.$i], Today());
    //         	$is_item_wo=1;
	// 		}
	//      $i++;
	// }

	foreach ($_SESSION['issue_items']->line_items as $line_no=>$stock_item){
		if($stock_item->quantity == 0){
			unset($_SESSION['issue_items']->line_items[$line_no]);
		} 
	}
	$failed_data = add_work_order_issue($_SESSION['issue_items']->order_id,
		$_POST['ref'], $_POST['IssueType'], $_SESSION['issue_items']->line_items,
		$_POST['Location'], $_POST['WorkCentre'], $_POST['date_'], $_POST['memo_'],
		input_num('gsm_id'), input_num('size_id'), $_POST['no_of_sheets'], $_POST['waste_sheets'],
		$_POST['per_sheet_weight']);

	if ($failed_data != null) 
	{
		display_error(_("The process cannot be completed because there is an insufficient total quantity for a component.") . "<br>"
		. _("Component is :"). $failed_data[0] . "<br>"
		. _("From location :"). $failed_data[1] . "<br>");
	} 
	else 
	{
		meta_forward($_SERVER['PHP_SELF'], "AddedID=".$_SESSION['issue_items']->order_id);
	}

} /*end of process credit note */

//-----------------------------------------------------------------------------------------------

function check_item_data()
{
	if (input_num('qty') == 0 || !check_num('qty', 0))
	{
		display_error(_("The quantity entered is negative or invalid."));
		set_focus('qty');
		return false;
	}

	if (!check_num('std_cost', 0))
	{
		display_error(_("The entered standard cost is negative or invalid."));
		set_focus('std_cost');
		return false;
	}

   	return true;
}

//-----------------------------------------------------------------------------------------------

function handle_update_item()
{
    if($_POST['UpdateItem'] != "" && check_item_data())
    {
		$id = $_POST['LineNo'];
    	$_SESSION['issue_items']->update_cart_item($id, input_num('qty'), input_num('std_cost'),
    	 input_num('gsm_id'), input_num('size_id'));
    }
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

function handle_delete_item($id)
{
	$_SESSION['issue_items']->remove_from_cart($id);
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

function handle_new_item()
{
	if (!check_item_data())
		return;

	add_to_issue($_SESSION['issue_items'], $_POST['stock_id'], input_num('qty'),
		 input_num('std_cost'), get_post('batch_no'), get_post('exp_date'), input_num('gsm_id'), input_num('size_id'), 0, $_POST['peel_qty'], $_POST['cone_weight'], $_POST['corr_1_weight'], $_POST['corr_2_weight'], $_POST['plant_waste'], $_POST['consume_weight'], 1);
	line_start_focus();
}


//-----------------------------------------------------------------------------------------------
$id = find_submit('Delete');
if ($id != -1)
	handle_delete_item($id);

if (isset($_POST['AddItem']))
	handle_new_item();

if (isset($_POST['UpdateItem']))
	handle_update_item();

if (isset($_POST['CancelItemChanges'])) {
	line_start_focus();
}

//-----------------------------------------------------------------------------------------------

if (isset($_GET['trans_no']))
{
	handle_new_order();
}
// WO Stock Reserve 
	if(!$_POST['Location'])
 	$_POST['Location']='PF';
//-----------------------------------------------------------------------------------------------

	$wo_row = get_work_order($_SESSION['issue_items']->order_id, true);
if ($_SESSION['issue_items']->order_id && $_POST['Location'] && isset($_GET['trans_no'])) { 

	 $result = get_bom($wo_row['stock_id']);
    // $result = get_wo_stock_reserve($_SESSION['issue_items']->order_id, $_POST['Location']);
	$i = 0;

     $result = get_wo_stock_reserve_by_item($_SESSION['issue_items']->order_id, $_POST['Location']);
	while ($myrow = db_fetch($result)) {

  // $bom_row
     // if(!$myrow)
     // 	continue;
		// echo"<pre>";
	$_SESSION['issue_items']->transfer_no[$myrow['transfer_no']]=$myrow['transfer_no'];
		// print_r($myrow );


	$qoh = get_qoh_on_date($myrow["item_code"], $_POST['Location']);
	global $Ajax;
	// if(!$_POST['FLine'.$i]){
	// 	$_POST['FLine'.$i] = 1;	
	// }
          // display_error($_POST['Line'.$i]);
         if ($qoh > 0) {
				$std_cost = get_betch_price($myrow['batch_no'],$myrow["item_code"]);
				add_to_issue($_SESSION['issue_items'], $myrow['item_code'], $_POST['Line'.$i],
				$std_cost, $myrow['batch_no'], Today(), $myrow['gsm_id'], $myrow['size_id'], 
				0, $_POST['peel_qty'.$i], $_POST['cone_weight'.$i], $_POST['corr_1_weight'.$i], 
				$_POST['corr_2_weight'.$i], $_POST['plant_waste'.$i], $_POST['consume_weight'.$i], 1);
          } else{
          	continue;
          }
	 $i++;
	}

	 $Ajax->activate('_page_body');
}


//-----------------------------------------------------------------------------------------------

$kv_batch = get_company_pref('kv_batch');
$kv_exp_date = get_company_pref('kv_exp_date');
//-----------------------------------------------------------------------------------------------
display_wo_details($_SESSION['issue_items']->order_id, false, $kv_batch, $kv_exp_date);
echo "<br>";

start_form();


	// echo "<pre>";
	// print_r($multi_wo_no);

start_table(TABLESTYLE, "width='90%'", 10);
issue_options_controls();

			// start_table(TABLESTYLE, "width='80%'");
			// display_heading("Job orders");
			// start_row();
			// label_cell("Work Order's");
			// foreach ($transfer_no as $key => $value) {
			// // display_error($value);
			// label_cell($value);
			// // code...
			// }
			// end_row();

			// end_table();

	$multi_wo_no_res=get_trnsfer_multiple(	$_SESSION['issue_items']->transfer_no);
// display_error(db_num_rows($multi_wo_no_res)	."  count");

 if(db_num_rows($multi_wo_no_res)){

          	$wo_row = get_work_order($_SESSION['issue_items']->order_id, true);
		start_table(TABLESTYLE, "width='80%'");
		display_heading("Multi Job issue wastage and Cunsume weight calculation");

			$th = array(_("Item Code"), _("Item Description"), _("GSM"),  _("Size"), _("batch_no"), 
		 _("QOH Weight"), _("Waste 1"), _("Waste 2"), 
		 _("Jutti"), _("Cone"), _("Plant Waste"),_("Return Weight"),_("Consume Weight"),_("Calculate \n Return")); 
			table_header($th);
		$sum_cutt=get_multiple_tranfer_cutt_sum(	$_SESSION['issue_items']->transfer_no);	
           $ln_k=0;
		while($multi_wo_no_row=db_fetch($multi_wo_no_res)){

			    $cal_waste=$c_waste2_=$jutti=$cone=$plant_waste_cal=$cunsume_wt=$cal_return_wt=0;
                start_row();
				view_stock_status_cell($multi_wo_no_row['item_code']);
				$item_row = get_item($multi_wo_no_row['item_code']);
				label_cell($item_row["description"]);
				label_cell(get_gsm_name($multi_wo_no_row['gsm_id']), "align='center'");
				label_cell(get_size_name($multi_wo_no_row['size_id']), "align='center'");
				label_cell($multi_wo_no_row['batch_no'], "align='center'");
				$qoh = get_qoh_on_date($multi_wo_no_row['item_code'], $_POST['Location'], null, input_num('printing_id'), input_num('ply_id'), input_num('box_size_id'), input_num('material_id'), $multi_wo_no_row['gsm_id'],$multi_wo_no_row['size_id'],$multi_wo_no_row['batch_no']);
				label_cell($qoh, "align='center'"); 
				$wo_per = ($wo_row['cutt']/$sum_cutt)*100;
				// display_error($multi_wo_no_row['cutt']."/".$sum_cutt);

				// display_error(input_num('c_waste1_'.$ln_k));
     
                  if(input_num('c_waste1_'.$ln_k)){
                  	// display_error($wo_row['cutt']." / ".$sum_cutt." * ".$wo_per);
                    $cal_waste=(input_num('c_waste1_'.$ln_k)/100)*$wo_per;

                  }
                echo '<td align="right"><input class="searchbox amount" type="text" name="c_waste1_'.$ln_k.'" size="8" maxlength="15" dec="2" value="'.$_POST['c_waste1_'.$ln_k].'" >';
                echo '<br> <span style="font-weight: bolder; font-size: large; color: blue;"> '.round($cal_waste,2).' </span> 
                </td>'  ;

                 if(input_num('c_waste2_'.$ln_k))
                    $c_waste2_=(input_num('c_waste2_'.$ln_k)/100)*$wo_per;


                echo '<td align="right"><input class="searchbox amount" type="text" name="c_waste2_'.$ln_k.'" size="8" maxlength="15" dec="2" value="'.$_POST['c_waste2_'.$ln_k].'" >';
                echo '<br> <span style="font-weight: bolder; font-size: large; color: blue;"> '.round($c_waste2_,2).' </span> 
                </td>'  ;

                 if(input_num('jutti'.$ln_k))
                    $jutti=(input_num('jutti'.$ln_k)/100)*$wo_per;

                 echo '<td align="right"><input class="searchbox amount" type="text" name="jutti'.$ln_k.'" size="8" maxlength="15" dec="2" value="'.$_POST['jutti'.$ln_k].'" >';
                echo '<br> <span style="font-weight: bolder; font-size: large; color: blue;"> '.round($jutti,2).' </span> 
                </td>'  ;

                     if(input_num('cone'.$ln_k))
                    $cone=(input_num('cone'.$ln_k)/100)*$wo_per;


                 echo '<td align="right"><input class="searchbox amount" type="text" name="cone'.$ln_k.'" size="8" maxlength="15" dec="2" value="'.$_POST['cone'.$ln_k].'" >';
                echo '<br> <span style="font-weight: bolder; font-size: large; color: blue;"> '.round($cone,2).' </span> 
                </td>'  ;

                      if(input_num('plant_waste_cal'.$ln_k))
                    $plant_waste_cal=(input_num('plant_waste_cal'.$ln_k)/100)*$wo_per;

                 echo '<td align="right"><input class="searchbox amount" type="text" name="plant_waste_cal'.$ln_k.'" size="8" maxlength="15" dec="2" value="'.$_POST['plant_waste_cal'.$ln_k].'" >';
                echo '<br> <span style="font-weight: bolder; font-size: large; color: blue;"> '.round($plant_waste_cal,2).' </span> 
                </td>'  ;


                echo '<td align="right"><input class="searchbox amount" type="text" name="return_wt'.$ln_k.'" size="8" maxlength="15" dec="2" value="'.$_POST['return_wt'.$ln_k].'" > </td>';
                // echo '<br> <span style="font-weight: bolder; font-size: large; color: blue;"> '.$cal_waste.' </span> 
                // </td>'  ;

                 if(input_num('return_wt'.$ln_k)>=0)
                    $cunsume_wt=( ($qoh-input_num('return_wt'.$ln_k))-( $cal_waste + $c_waste2_ + $jutti +  $cone + $plant_waste_cal ) );



                 echo '<td align="right">';
                echo '<br> <span style="font-weight: bolder; font-size: large; color: blue;"> '.round($cunsume_wt,2).' </span> 
                </td>'  ;
                 $cal_return_wt= $cunsume_wt - (($cunsume_wt/100)*$wo_per) ;
                 echo '<td align="right">';
                echo '<br> <span style="font-weight: bolder; font-size: large; color: blue;"> '.round($cal_return_wt,2).' </span> 
                </td>'  ;






				end_row();
				$ln_k++;
		    // $multi_wo_no=$multi_wo_no_row;
		// print_r($multi_wo_no_row);
		}


		end_table();

 }
echo "<tr><td>";
display_issue_items(_("Items to Issue Stock Reserve"), $_SESSION['issue_items'], $kv_batch, $kv_exp_date);
echo "</td></tr>";
br(1);
end_table();

display_heading('Received Sheets');
br();
start_table(TABLESTYLE, "width='100%'");
$th = array(_("Description"), _("Batch No."), _("QOH"), _("Quantity"), _("Cost"), _("Total"));
table_header($th);
global $Ajax;

$qoh = get_qoh_on_date(88669458, $_POST['Location'], null);
$item_name_ = get_item(88669458);

label_cell('88669458'.' - '.$item_name_['description'], "align='center'");
$_POST['sheets_batch_no'] = $wo_row['wo_ref'];
text_cells(null,'sheets_batch_no', $_POST['sheets_batch_no'], 25, 100, null, "", "", "", true);
label_cell($qoh, "align='center'");
if(isset($_POST['no_of_sheets']))
	$_POST['sheets_qty'] = $_POST['no_of_sheets'];
text_cells(null,'sheets_qty', $_POST['sheets_qty'], 25, 100, null, "", "", "", true);
if($_POST['unit_total'])
$_POST['sheets_unit_cost'] = $_POST['unit_total']/$_POST['sheets_qty'];
text_cells(null,'sheets_unit_cost', $_POST['sheets_unit_cost'], 25, 100, null, "", "", "", true);
if($_POST['sheets_unit_cost'])
$total_sheets = $_POST['sheets_qty']*$_POST['sheets_unit_cost'];
label_cell($total_sheets, "align='center'");
// if($_POST['sheets_qty'] > 0)
// $_SESSION['issue_items']->add_to_cart (count($_SESSION['issue_items']->line_items), 88669458, $_POST['sheets_qty'], $_POST['sheets_unit_cost'], null, 
// 	$_POST['sheets_batch_no'], Today(), 0, 0, 0,0,0,0,0,1, 0, 0, 0, 0, 0, 0, 0);

if($_POST['sheets_qty'] > $qoh)
	 display_error("The qty of Item ( " . $item_name_['description'] ." ) cannot exceed the available Quantity On Hand (QOH) weight.");
end_row();
$Ajax->activate('_page_body');
end_table(1);

// display_heading('Glue');
// start_outer_table(TABLESTYLE, "width='60%'");
// $th = array(_("Item Code"), _("Batch No."), _("Quantity"));
// table_header($th);
// table_section(1);
// $result = get_item_issue_glue_ink(2);
// $i = 1;
// while ($myrow = db_fetch($result)) {
// 	global $Ajax;
// 	// if(!$_POST['westage_item'.$i] && !list_updated('type'))
//    $qoh_glue = get_qoh_on_date($_POST['glue_item'.$i], $_POST['Location'], null, input_num('printing_id'), input_num('ply_id'), input_num('box_size_id'), input_num('material_id'), input_num('gsm_id'),
// 	  	  input_num('size_id') ,$_POST['glue_batch_no'.$i]);
// 	$_POST['glue_item'.$i] = $myrow['stock_id'];
// 	$item_name_ = get_item($_POST['glue_item'.$i]);
// 	start_row();
// 	stock_component_items_list_cells(null, 'glue_item'.$i, null, $_POST['glue_item'.$i], false, true);
// 	// stock_component_items_list_rows(_("Westage"), 'glue_item'.$i, null, $_POST['glue_item'.$i], false, true);
// 	kv_batch_list_cells(null, 'glue_batch_no'.$i, null, true, true, $_POST['glue_item'.$i], $_POST['Location'],0, 0);
// 	text_cells(null,'qty_glue'.$i, $_POST['qty_glue'.$i], 25, 100, null, "", "", "", true);
// 	if($_POST['qty_glue'.$i] > $qoh_glue)
// 		 display_error("The total weight of Item ( " . $item_name_['description'] ." ) cannot exceed the available Quantity On Hand (QOH) weight.");
// 	end_row();
// 	$Ajax->activate('_page_body');
// 	$i++;
// }

// end_outer_table();
// br();
// display_heading('Printing Ink');
// start_outer_table(TABLESTYLE, "width='60%'");
// $th = array(_("Item Code"), _("Batch No."), _("Quantity"));
// table_header($th);
// table_section(1);
// $result = get_item_issue_glue_ink(3);
// $i = 1;
// while ($myrow = db_fetch($result)) {
// 	global $Ajax;
// 	// if(!$_POST['westage_item'.$i] && !list_updated('type'))
//     $qoh_ink = get_qoh_on_date($_POST['ink_item'.$i], $_POST['Location'], null, input_num('printing_id'), input_num('ply_id'), input_num('box_size_id'), input_num('material_id'), input_num('gsm_id'),
// 	  	  input_num('size_id') ,$_POST['ink_batch_no'.$i]);
// 	$_POST['ink_item'.$i] = $myrow['stock_id'];
// 	$item_name_ = get_item($_POST['ink_item'.$i]);
// 	start_row();
// 	stock_component_items_list_cells(null, 'ink_item'.$i, null, $_POST['ink_item'.$i], false, true);
// 	kv_batch_list_cells(null, 'ink_batch_no'.$i, null, true, true, $_POST['ink_item'.$i], $_POST['Location'],0, 0);
// 	text_cells(null,'qty_ink'.$i, $_POST['qty_ink'.$i], 25, 100, null, "", "", "", true);
// 	if($_POST['qty_ink'.$i] > $qoh_ink)
// 		 display_error("The total weight of Item ( " . $item_name_['description'] ." ) cannot exceed the available Quantity On Hand (QOH) weight.");
// 	end_row();
// 	$Ajax->activate('_page_body');
// 	$i++;
// }

// end_outer_table();

// br(1);

submit_center('Process', _("Process Issue"), true, '', 'default');

end_form();

//------------------------------------------------------------------------------------------------

end_page();

