<?php
/****************************************
/*  Author 	: Kvvaradha
/*  Module 	: Extended HRM
/*  E-mail 	: admin@kvcodes.com
/*  Version : 1.0
/*  Http 	: www.kvcodes.com
*****************************************/
	if ($this->formData['doctype'] == 'payslip'){
		$this->title = _("Payslip");
		$addr_title = _("Payable To");
		$this->formData['document_name'] =_("Payroll ID.");
	}elseif ($this->formData['doctype'] == 'empl_detail'){	
		$this->title = _("Employee Details");
		$addr_title = '' ; //_("Payable To");
		$this->formData['document_name'] = ''; //_("Employee");
	}elseif ($this->formData['doctype'] == 'loan'){
		$this->title = _("Loan Details");
		$addr_title = _("Employee Info");
		$this->formData['document_name'] =_("Employee ID.");
	}elseif($this->formData['doctype'] == 'esb'){
		$this->title = _("End of Service Benefit");
		$addr_title = _("End of Service Benefit");
		$this->formData['document_name'] =_(" ");
	}elseif($this->formData['doctype'] == 'paysummary'){
		$this->title = _("Payroll Summary");
		$addr_title = _("Pay Details");
		$this->formData['document_name'] =_(" ");
	}elseif($this->formData['doctype'] == 'annual_encashment'){
		$this->title = _("Encashment Report");
		$addr_title = _("Encashment Details");
		$this->formData['document_name'] =_(" ");
	}
	
	if($this->formData['doctype'] == 'paysummary'){
		$Addr1 = array(
			'title' => $addr_title,
			'id' => (isset($this->formData['order_no']) ? $this->formData['order_no']: ''),
			'year' => $this->formData['disable_branch']
			);
	}elseif($this->formData['doctype'] == 'esb'){
		$Addr1 = array(
			'title' => $addr_title,
			'id' => $this->formData['order_no'],
			'name' => @$this->formData['name'] ? $this->formData['name'] : @$this->formData['name'],
			'dept' => $this->formData['location_name'], 
			'desig' => $this->formData['payment_terms'], 
			'resignation' => $this->formData['due_date'], 
			'status' => $this->formData['status'], 			
			'joining' => $this->formData['ord_date']
		);
	}else{
		$Addr1 = array(
			'title' => $addr_title,
			'id' => $this->formData['order_no'],
			'name' => @$this->formData['name'] ? $this->formData['name'] : @$this->formData['name'],
			'dept' => $this->formData['location_name'], 
			'desig' => isset($this->formData['payment_terms']) ? $this->formData['payment_terms'] : '', 
			'joining' => $this->formData['ord_date']
		);		
	}
	
	$this->formData['domicile'] = $this->company['domicile'];

	$Footer = [_("All amounts stated in Company  Currency")];

		// default values 
	if (!isset($this->formData['document_date']) && !isset($this->formData['tran_date']))
		$this->formData['document_date'] = Today(); 
    elseif(isset($this->formData['tran_date']) && $this->formData['tran_date'] != '')
        $this->formData['document_date'] = $this->formData['tran_date'];
		
	if (!isset($this->formData['document_number']))
		$this->formData['document_number'] =  isset($this->formData['reference']) ? $this->formData['reference'] : @$this->formData['trans_no'];

	// footer generic content
	if (@$this->formData['bank_name'] && $this->formData['doctype'] != 'empl_detail')
		$Footer[] = _("Bank Name"). ": ".$this->formData['bank_name']. ", " . _("Bank Account Number") . ": " . $this->formData['acc_no'];

	// if ($this->formData['doctype'] == 'payslip')
 // 		$Footer[] = _("* Subject to Realisation of the Cheque.");

	if (isset($this->params['comments']) && $this->params['comments'] != '')
		$Footer[] = $this->params['comments'];

	if(isset($Addr1['name']))
		$this->formData['recipient_name'] = $Addr1['name'];

    $this->row = $this->pageHeight - $this->topMargin;

		$upper = $this->row - 2 * $this->lineHeight;
		$lower = $this->bottomMargin + 8 * $this->lineHeight;
		$iline1 = $upper - 7.5 * $this->lineHeight;
		$iline2 = $iline1 - 8 * $this->lineHeight;
		$iline3 = $iline2 - 1.5 * $this->lineHeight;
		$iline4 = $iline3 - 1.5 * $this->lineHeight;
		$iline5 = $iline4 - 3 * $this->lineHeight;
		$iline6 = $iline5 - 1.5 * $this->lineHeight;
		$iline7 = $lower;
		$right = $this->pageWidth - $this->rightMargin;
		$width = ($right - $this->leftMargin) / 5;
		$icol = $this->pageWidth / 2;
        if($this->formData['doctype'] == 'empl_detail')
            $ccol=43;
        else
		    $ccol = $this->cols[0] + 4;
		$c2col = $ccol + 60;
		$ccol2 = $icol / 2;
		$mcol = $icol + 8; 
		$mcol2 = $this->pageWidth - $ccol2;
		$cols = count_array($this->cols);
        if($this->formData['doctype'] != 'empl_detail'){
            $this->SetDrawColor(205, 205, 205);
            $this->rectangle($this->leftMargin, $iline2, $right - $this->leftMargin, $iline2 - $iline3, "F", null, array(222, 231, 236));   
            $this->Line($iline2);
            $this->Line($iline3);
        }
		if ($this->formData['doctype'] == 'payslip'){
			//$this->rectangle($this->leftMargin, $iline5-314, $right - $this->leftMargin, $iline5 - $iline6+12, "F", null, array(255, 211, 179));   
			//$this->Line($iline6-136);
		}
		if ($this->formData['doctype'] == 'esb'){
			$this->rectangle($this->leftMargin, $iline5-355, $right - $this->leftMargin, $iline5 - $iline6+12, "F", null, array(255, 211, 179));   
			//$this->Line($iline6-136);
		}
		
		//$this->Line($iline6-166);
		$col = $this->leftMargin;
		if ($this->formData['doctype'] == 'payslip'){
			$this->LineTo($col += $width+80, $iline2,$col, $iline7+40);
			$this->LineTo($col += $width-20, $iline2,$col, $iline7+40);
			$this->LineTo($col += $width+80, $iline2,$col, $iline7+40);
		}
		if($this->formData['doctype'] == 'esb'){
			$this->LineTo($col += $width+280, $iline2,$col, $iline7+40);
		}
        if($this->formData['doctype'] != 'empl_detail'){
            $this->LineTo($right, $iline2 ,$right, $iline7+10);
            $this->LineTo($this->leftMargin, $iline2 ,$this->leftMargin, $iline7+10);
        }
		// Company Logo
		$this->NewLine();
		$logo = company_path() . "/images/" . $this->company['coy_logo'];
		if ($this->company['coy_logo'] != '' && file_exists($logo))	{
			$this->AddImage($logo, $ccol, $this->row, 0, 40);
		}else{
			$this->fontSize += 4;
			$this->Font('bold');
			$this->Text($ccol, $this->company['coy_name'], $icol);
			$this->Font();
			$this->fontSize -= 4;
		}
		// Document title
		$this->SetTextColor(190, 190, 190);
		$this->fontSize += 10;
		$this->Font('bold');
		$this->TextWrap($mcol, $this->row, $this->pageWidth - $this->rightMargin - $mcol - 20, $this->title, 'right');
		$this->Font();
		$this->fontSize -= 10;
		$this->NewLine();
		$this->SetTextColor(0, 0, 0);
		$adrline = $this->row;

		// Company data
		$this->TextWrapLines($ccol, $icol, $this->company['postal_address']);
		$this->Font('italic');
		if (@$this->company['phone']){
			$this->Text($ccol, _("Phone"), $c2col);
			$this->Text($c2col, $this->company['phone'], $mcol);
			$this->NewLine();
		}
		// if (@$this->company['fax']){
		// 	$this->Text($ccol, _("Fax"), $c2col);
		// 	$this->Text($c2col, $this->company['fax'], $mcol);
		// 	$this->NewLine();
		// }
		if (@$this->company['email']){
			$this->Text($ccol, _("Email"), $c2col);

			$url = "mailto:" . $this->company['email'];
			$this->SetTextColor(0, 0, 255);
			$this->Text($c2col, $this->company['email'], $mcol);
			$this->SetTextColor(0, 0, 0);
			$this->addLink($url, $c2col, $this->row, $mcol, $this->row + $this->lineHeight);

			$this->NewLine();
		}
		if($this->formData['doctype'] == 'payslip'){
            $this->Font();
            $this->row = $adrline;
            $this->NewLine(3);
            $this->Text($mcol + 100, _("Salary Month"));
            $sal = GetRow('kv_empl_salary', array('empl_id' => $Addr1['id'], 'year' => $this->formData['disable_branch'], 'month' => $this->formData['date_']));
            $this->Text($mcol + 180, kv_month_name_by_id($sal['month']));
        }

		$this->NewLine();
		$this->Text($mcol + 100, $this->formData['document_name']);
		$this->Text($mcol + 180, $this->formData['document_number']);
		$this->NewLine(2);
	
		if ($this->pageNumber > 1)
			$this->Text($mcol + 180, _("Page") . ' ' . $this->pageNumber);
		$this->row = $iline1 - $this->lineHeight;
		
		$this->fontSize -= 4;
		$this->fontSize += 6;
		$this->Text($ccol, $Addr1['title'], $icol,0,-21);
		//$this->Text($mcol, $Addr1['title']);
		$this->fontSize -= 2;
 
		// address1
		$temp = $this->row = $this->row - $this->lineHeight - 5;
	if($this->formData['doctype'] == 'paysummary' ){
		if($Addr1['id'] != ''){
			$this->Text($ccol, _('Month'), $icol,0,-4);
			$this->Text($ccol+100, kv_month_name_by_id($Addr1['id']), $icol,0,-4);
			$this->NewLine();
		}
		
		$this->NewLine();
		$this->Text($ccol, _('Year'), $icol,0,1);
		$fYear = get_fiscalyear($Addr1['year']);
		$this->Text($ccol+100, $fYear['begin'] .' - '. $fYear['end'], $icol,0,1);
	}elseif($this->formData['doctype'] != 'empl_detail'){
		$this->Text($ccol, _('Employee ID'), $icol,0,-4);
		$this->Text($ccol+100, $Addr1['id'], $icol,0,-4);
	}
	$empl_details = GetRow('kv_empl_job',array('empl_id' => $Addr1['id']));
	if($this->formData['doctype'] != 'paysummary'){
		$this->Text($ccol+350, _('Department'), $icol,0,-4);
		$this->Text($ccol+430, $Addr1['dept'], $icol,0,-4);
		$this->NewLine();
		$this->Text($ccol, _('Name of Employee'), $icol,0,1);
		$this->Text($ccol+100, $Addr1['name'], $icol,0,1);
		$this->Text($ccol+350, _('Date of Joining'), $icol,0,1);
		$this->Text($ccol+430, $Addr1['joining'], $icol,0,1);
		$this->NewLine();
		$this->Text($ccol, _('Designation'), $icol,0,5);
		$this->Text($ccol+100, ((is_numeric($Addr1['desig']) && $Addr1['desig'] > 0 )? GetSingleValue('kv_empl_designation', 'description', ['id' => $Addr1['desig']]) : $Addr1['desig']) , $icol,0,5);
		if($empl_details['ESIC'] != '')
		$this->Text($ccol+350, _('ESI No'), $icol,0,1);
		$this->Text($ccol+430, $empl_details['ESIC'], $icol,0,1);

		$this->NewLine();
		if($empl_details['PF'] != '')
		$this->Text($ccol+350, _('EPF No'), $icol,0,1);
		$this->Text($ccol+430, $empl_details['PF'], $icol,0,1);
		$this->Text($ccol, _('VAN NO. '), $icol,0,5);
		if($this->formData['doctype'] == 'esb' ){
			$this->Text($ccol+350, _('Resignation'), $icol,0,5);
			$this->Text($ccol+430, $Addr1['resignation'], $icol,0,5);
			$this->NewLine();
			$this->Text($ccol, _('Status'), $icol,0,7);
			$this->Text($ccol+100, $Addr1['status'], $icol,0,7);
		} 

		$this->NewLine(2);
		if($this->formData['doctype'] == 'payslip'){
            $day2 = date('Y-m-d', strtotime($sal['to_date']. ' + 1 day'));
            $day1 = date('Y-m-d', strtotime($sal['from_date']));
            $off_days = 0;
            $weekly_off = unserialize(base64_decode($empl_details['weekly_off']));
            $shift = GetEmplShiftDetails($Addr1['id']);
            $time = strtotime($shift['EndTime']) - strtotime($shift['BeginTime']);

            $from = sql2date(date('Y-m-d', strtotime($sal['from_date'])));
            $to = sql2date(date('Y-m-d', strtotime($sal['to_date'])));

            $begin = new DateTime(date2sql($from));
            $end = new DateTime(date2sql(add_days($to,1)));

            $interval = DateInterval::createFromDateString('1 day');
            $period = new DatePeriod($begin, $interval, $end);
            foreach ($period as $dt) {
                $day_letters =date("D", strtotime($dt->format("Y-m-d")));	
            //--------Weekly_off-----------//
                $date_count = date("Y-m-d", strtotime($dt->format("Y-m-d"))) ;
                if(in_array($day_letters, $weekly_off ) ){
                    $Weekly_date =strtotime($date_count) ;
                        $off_days += $time;	
                    $off_days = abs(round($off_days / $time));
                }
            }

            $days = strtotime($day2) - strtotime($day1);
            $TotalDays = abs(round($days / 86400));
            $this->Text($ccol, _('Total Days'), $icol,0,1);
            $this->Text($ccol+100, $TotalDays, $icol,0,1);
            $this->Text($ccol+180, _('Days of Present'), $icol,0,1);
            $this->Text($ccol+300, $sal['days_worked'], $icol,0,1);
            $lop = ($TotalDays) - $sal['days_worked'] - $off_days;
            $this->Text($ccol+350, _('Lop :'), $icol,0,1);
            $this->Text($ccol+450, $lop, $icol,0,1);

            $this->NewLine();
        }
 
	/*	if($this->formData['doctype'] == 'payslip'){
			$this->Text($ccol+350, _('Month'), $icol,0,5);
			$this->Text($ccol+430, kv_month_name_by_id($this->formData['date_']), $icol,0,5);
			$this->NewLine();
		}*/
	}
		
		// Line headers
		$this->row = $iline2 - $this->lineHeight - 1;
		$this->Font('bold');
		$count = count_array($this->headers);
		$this->cols[$count] = $right ;
		for ($i = 0; $i < $count; $i++)
			$this->TextCol($i, $i + 1, $this->headers[$i], -2);
		$this->Font();
		
		// Footer
		$this->Font('italic');
		$this->row = $iline7 - $this->lineHeight - 50;

		foreach ($Footer as $line => $txt){
			if (!is_numeric($line))	{// title => link			
				$this->fontSize -= 2;
				$this->TextWrap($ccol, $this->row, $right - $ccol, $line, 'C');
				$this->row -= $this->lineHeight;
				$this->SetTextColor(0, 0, 255);
				$this->TextWrap($ccol, $this->row, $right - $ccol, $txt, 'C');
				$this->SetTextColor(0, 0, 0);
				$this->addLink($txt, $ccol, $this->row, $this->pageWidth - $this->rightMargin, $this->row + $this->lineHeight);
				$this->fontSize += 2;
			}
			else
				$this->TextWrap($ccol, $this->row, $right - $ccol, $txt, 'C');
			$this->row -= $this->lineHeight;
		}
        if($this->formData['doctype'] == 'payslip')
            $this->row = 450;
        elseif($this->formData['doctype'] == 'empl_detail'){
            $this->row = 450;
            if($this->pageNumber == 1)
                $this->row = 250;
        } elseif($this->formData['doctype'] == 'loan')
            $this->row = 520;
		$this->Font();
		$temp = $iline6 - $this->lineHeight - 200;
      //  display_error($temp);