<?php
/****************************************
/*  Author  : Kvvaradha
/*  Module  : Extended HRM
/*  E-mail  : admin@kvcodes.com
/*  Version : 1.0
/*  Http    : www.kvcodes.com
*****************************************/
define ('SS_EXHRM', 250<<8);
define ('SS_EXHRM_SETTINGS', 251<<8);
define ('SS_EXHRM_PAYROLL', 252<<8);
define ('SS_EXHRM_EMPLOYEE', 253<<8);

class ExtendedHRM_app extends application{
    var $apps;
   
    function __construct()  {     
      parent::__construct("hrm", _($this->help_context = "&HRM"));
    
      $this->add_module(_("Transactions"));
      $this->add_lapp_function(0, _("PaySlip"),'modules/ExtendedHRM/payslip.php', 'HR_PAYSLIP', MENU_TRANSACTION);
      $this->add_lapp_function(0, _("Payroll"), 'modules/ExtendedHRM/manage/payroll.php', 'HR_PAYSLIP', MENU_TRANSACTION);       
      $this->add_lapp_function(0, _("Advance Salary"), 'modules/ExtendedHRM/advance_salary.php', 'HR_PAYSLIP', MENU_TRANSACTION); 
      $this->add_rapp_function(0, _("Attendance Entry"), 'modules/ExtendedHRM/attendance.php', 'HR_ATTENDANCE', MENU_TRANSACTION);

      $this->add_lapp_function(0, _("Petrol Claim"), 'modules/ExtendedHRM/petrol.php', 'HR_PETROL_CLAIM', MENU_TRANSACTION); 
      $this->add_rapp_function(0, _("Travel Claim"), 'modules/ExtendedHRM/manage/travel-claim.php', 'HR_TRAVEL_CLAIM', MENU_TRANSACTION); 
     // $this->add_rapp_function(0, _("Edit Attendance"), 'modules/ExtendedHRM/single_empl_attend.php', 'HR_ATTENDANCE', MENU_TRANSACTION); 
     $this->add_rapp_function(0, _("ZK Time Attendance"), 'modules/ExtendedHRM/zkteco_attendance.php', 'HR_ATTENDANCE', MENU_TRANSACTION); 
      $this->add_rapp_function(0, _("Leave Request & Approval"), 'modules/ExtendedHRM/leave_approval.php', 'HR_ATTENDANCE', MENU_TRANSACTION);  
    // $this->add_lapp_function(0, _("Leave Encashment"),'modules/ExtendedHRM/leave_encashment.php','HR_LEAVE_ENCASHMENT', MENU_TRANSACTION);    
      $this->add_lapp_function(0, _("End of Service Benefit"), 'modules/ExtendedHRM/esb.php','HR_PAYSLIP', MENU_TRANSACTION);
      $this->add_rapp_function(0, _("Loan Entry"), 'modules/ExtendedHRM/manage/loan_form.php', 'HR_LOANFORM', MENU_TRANSACTION); 
      $this->add_rapp_function(0, _("Attendance Import"), 'modules/ExtendedHRM/attendance_import.php', 'HR_ATTENDANCE', MENU_TRANSACTION);     
      $this->add_lapp_function(0, _("Employee Attachments"), 'modules/ExtendedHRM/manage/attachments.php', 'HR_EMPL_INFO', MENU_TRANSACTION);
      $this->add_rapp_function(0, _("Family Data"), 'modules/ExtendedHRM/manage/family_data.php', 'HR_EMPL_INFO', MENU_TRANSACTION);
      $this->add_rapp_function(0, _("Email"), 'modules/ExtendedHRM/manage/email.php', 'HR_EMPL_INFO', MENU_TRANSACTION);
   if(GetHRMOption('enable_employee_access'))
      $this->add_lapp_function(0, _('Profile'), 'modules/ExtendedHRM/employee/index.php', 'HR_EML_PROFILE', MENU_TRANSACTION);
    

      $this->add_module(_("Inquires"));
      $this->add_lapp_function(1, _("Payroll Inquiry"), 'modules/ExtendedHRM/inquires/payroll_history_inquiry.php', 'HR_PAYROLL_INQ', MENU_INQUIRY);
      $this->add_lapp_function(1, _("Attendance Inquiry"), 'modules/ExtendedHRM/inquires/attendance_inquiry.php', 'HR_ATTENDANCE', MENU_INQUIRY);
      $this->add_lapp_function(1, _("Daily Attendance Inquiry"), 'modules/ExtendedHRM/inquires/daily_attendance_inquiry.php', 'HR_SELATTENDANCE', MENU_INQUIRY);
      $this->add_rapp_function(1, _("Loan Inquiry"), 'modules/ExtendedHRM/inquires/loan_inquiry.php', 'HR_LOAN_INQ', MENU_INQUIRY);
      $this->add_rapp_function(1, _("Advance Salary Inquiry"), 'modules/ExtendedHRM/inquires/adv_sal_inquiry.php', 'HR_PAYROLL_INQ', MENU_INQUIRY);
      $this->add_lapp_function(1, _("Employees Inquiry"), 'modules/ExtendedHRM/inquires/employees_inquiry.php', 'HR_EMPLOYEE_INQ', MENU_INQUIRY);
      $this->add_rapp_function(1, _("Document Inquiry"), 'modules/ExtendedHRM/inquires/document_inquiry.php', 'HR_EMPLOYEE_INQ', MENU_INQUIRY);      
    // $this->add_rapp_function(1, _("Leave Encashment Inquiry"), 'modules/ExtendedHRM/inquires/encashment_inquiry.php', 'HR_LEAVE_ENCASHMENT', MENU_INQUIRY);
    $this->add_rapp_function(1, _("HRM Reports"), 'reporting/reports_main.php?Class=12&REP_ID=801', 'HR_REPORTS', MENU_INQUIRY);
      
      $this->add_module(_("Maintainance"));

      $this->add_lapp_function(2, _("Add And Manage Employees"), 'modules/ExtendedHRM/manage/employees.php', 'HR_EMPL_INFO', MENU_ENTRY);
      $this->add_lapp_function(2, _("Department"), 'modules/ExtendedHRM/manage/department.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      $this->add_rapp_function(2, _("Document Type"), 'modules/ExtendedHRM/manage/doc_type.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      //$this->add_rapp_function(2, _("Notifications"), 'modules/ExtendedHRM/manage/notifications.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      $this->add_lapp_function(2, _("Designations"), 'modules/ExtendedHRM/manage/designation.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      $this->add_lapp_function(2, _("Designation Group"), 'modules/ExtendedHRM/manage/designation_group.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      $this->add_rapp_function(2, _("Allowance Setup"), 'modules/ExtendedHRM/manage/allowances.php', 'HR_PAYROLL_SETUP', MENU_MAINTENANCE);
    $this->add_rapp_function(2, _("Company Shifts"), 'modules/ExtendedHRM/manage/shifts.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      $this->add_lapp_function(2, _("Grade Setup"), 'modules/ExtendedHRM/grade.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
    if(GetHRMOption('tax_used'))
      $this->add_rapp_function(2, _("Taxes"), 'modules/ExtendedHRM/tax/', 'HR_EMPL_TAX', MENU_MAINTENANCE);
    if(GetHRMOption('enable_esic') || GetHRMOption('enable_pf'))
      $this->add_rapp_function(2, _("ESIC & PF Settings"), 'modules/ExtendedHRM/esic_pf_settings.php', 'HR_EMPL_TAX', MENU_MAINTENANCE);

      $this->add_lapp_function(2, _("Loan Types"), 'modules/ExtendedHRM/manage/loan_type.php', 'HR_LOANTYPE', MENU_MAINTENANCE); 
      // $this->add_rapp_function(2, _("Backup & Restore"), 'modules/ExtendedHRM/manage/backups.php?', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      $this->add_rapp_function(2, _("Clear Demo and Data's"), 'modules/ExtendedHRM/docs/', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      // $this->add_rapp_function(2, _("Documentation"), 'modules/ExtendedHRM/docs/index.php?tut=text', 'SA_OPEN', MENU_MAINTENANCE);
      $this->add_lapp_function(2, _("Gazetted Off Days"), 'modules/ExtendedHRM/manage/gazetted_holidays.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
   // if(isset($_SESSION['wa_current_user']) && ($_SESSION['wa_current_user']->username == 'kvcodes' ||$_SESSION['wa_current_user']->username == 'kvvaradha14' ) ){
      $this->add_rapp_function(2, _("Pick List Types"), 'modules/ExtendedHRM/manage/picklist.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE); 
      $this->add_rapp_function(2, _("Pick Type"), 'modules/ExtendedHRM/manage/PickType.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE); 
   // }
      $this->add_rapp_function(2, _("Attendance Settings"), 'modules/ExtendedHRM/manage/attendance_settings.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE); 
  

      //  $this->add_lapp_function(2, _("Leave Pay Settings"), 'modules/ExtendedHRM/manage/leave_pay_allowance_settings.php','HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
         if(GetHRMOption('medical_preimum'))
        $this->add_rapp_function(2, _("Medical Preimum"), 'modules/ExtendedHRM/manage/medical_premium.php','HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
         if(GetHRMOption('visa'))
        $this->add_rapp_function(2, _("Visa & Immigration Types"), 'modules/ExtendedHRM/manage/visa_types.php','HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
        if(GetHRMOption('leave_travel'))
        $this->add_lapp_function(2, _("Leave Travel/Passage"), 'modules/ExtendedHRM/manage/leave_travel.php','HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      if(GetHRMOption('lmra_fees'))
        $this->add_lapp_function(2, _("LMRA Fees"), 'modules/ExtendedHRM/manage/lmra.php','HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      if(GetHRMOption('gosi_settings'))
        $this->add_lapp_function(2, _("GOSI Settings"), 'modules/ExtendedHRM/manage/gosi_settings.php','HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
 
      $this->add_rapp_function(2, _("Indemnity Settings"), 'modules/ExtendedHRM/manage/indemnity_setup.php','HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      $this->add_lapp_function(2, _("Nationalities"), 'modules/ExtendedHRM/manage/nationalities.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);

      $this->add_lapp_function(2, _("Custom Headers"), 'modules/ExtendedHRM/manage/custom_header.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      $this->add_lapp_function(2, _("Custom Fields"), 'modules/ExtendedHRM/manage/custom_fields.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
    
      $this->add_rapp_function(2, _("Languages"), 'modules/ExtendedHRM/manage/picklist.php?type=1', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      $this->add_rapp_function(2, _("Proficiency"), 'modules/ExtendedHRM/manage/picklist.php?type=2', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      $this->add_rapp_function(2, _("Settings"), 'modules/ExtendedHRM/manage/hrm_settings.php', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);           
    if(GetHRMOption('license_mgr')){
        $this->add_lapp_function(2, _("License  Category"), 'modules/ExtendedHRM/manage/picklist.php?type=6', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
        $this->add_lapp_function(2, _("License Type "), 'modules/ExtendedHRM/manage/picklist.php?type=5', 'HR_EMPLOYEE_SETUP', MENU_MAINTENANCE);
      }
       if(GetHRMOption('candidates')){
        $this->add_lapp_function(2, _("Candidates"), 'modules/ExtendedHRM/manage/candidates.php', 'SA_OPEN', MENU_MAINTENANCE);
        $this->add_lapp_function(2, _("web Candidatess Setup"), 'modules/ExtendedHRM/manage/web_candidates.php', 'SA_OPEN', MENU_MAINTENANCE);
      }
      $this->add_extensions();        
    }      
    
}



function GetHRMOption($option){
        $result = db_query("SHOW TABLES LIKE '".TB_PREF."kv_empl_option'", "can't get mysql result");
      if (db_num_rows($result) == 1){
      $sql = "SELECT option_value FROM ".TB_PREF."kv_empl_option WHERE option_name=".db_escape($option);
      $res = db_query($sql, "Can't get option value for settings" );
      if($row =db_fetch($res))
        return $row[0];
      else
        return false;
     }
    }

class hooks_ExtendedHRM extends hooks {
	var $module_name = 'ExtendedHRM';

	/*
		Install additonal menu options provided by module
	*/
    function install_tabs($app) {
        $app->add_application(new ExtendedHRM_app);
    }
  
    function install_access()	{
        $security_sections[SS_EXHRM]               = _("HRM");
        $security_sections[SS_EXHRM_SETTINGS]       = _("HRM Settings");
        $security_sections[SS_EXHRM_PAYROLL]        = _("HRM Payroll");
        $security_sections[SS_EXHRM_EMPLOYEE]        = _("HRM Employee Access");
        // ############################################################################################
        // HRM related functionality
        //
        // Employee Information
        $security_areas['HR_EMPL_INFO'] = array(SS_EXHRM|1, _("HRM Employee info")); 
		    $security_areas['HR_ATTENDANCE'] = array(SS_EXHRM|2, _("Employee Attendence"));
        $security_areas['HR_LOANFORM'] = array(SS_EXHRM|3, _("Loan Application Form"));
		    $security_areas['HR_EMPLOYEE_INQ'] = array(SS_EXHRM|4, _("Employee Inquiry")); 
        $security_areas['HR_SELATTENDANCE'] = array(SS_EXHRM|5, _("Selective Attendance List Show"));         
        $security_areas['HR_LOAN_INQ'] = array(SS_EXHRM|6, _("Loan Approve Inquiry"));
        $security_areas['HR_LEAVEFORM'] = array(SS_EXHRM|7, _("Leave Application Form"));
		    $security_areas['HR_DOCUMENT_MGT'] = array(SS_EXHRM|8, _("Document"));	
		 
        $security_areas['HR_PAYSLIP'] = array(SS_EXHRM_PAYROLL|1, _("Pay Slip Generation"));	
		    $security_areas['HR_LEAVE_ENCASHMENT'] = array(SS_EXHRM_PAYROLL|2, _("Leave Encashment")); 
		    $security_areas['HR_PAYROLL_SETUP'] = array(SS_EXHRM_PAYROLL|3, _("Payroll Setup"));		 
		    $security_areas['HR_PAYROLL_INQ'] = array(SS_EXHRM_PAYROLL|4, _("Payroll Inquriy"));	
        $security_areas['HR_TRAVEL_CLAIM'] = array(SS_EXHRM_PAYROLL|5, _("Travel Claim"));   
        $security_areas['HR_PETROL_CLAIM'] = array(SS_EXHRM_PAYROLL|6, _("Petrol Claim"));	 
         
         $security_areas['HR_REPORTS'] = array(SS_EXHRM_SETTINGS|1, _("HRM Reports")); 
         $security_areas['SA_OPEN'] = array(SS_EXHRM_SETTINGS|2, _("Documentation")); 
         $security_areas['HR_EMPL_TAX'] = array(SS_EXHRM_SETTINGS|3, _("Tax Setup"));          
         $security_areas['HR_LOANTYPE'] = array(SS_EXHRM_SETTINGS|4, _("Loan Type Setup"));         	 
         $security_areas['HR_EMPLOYEE_SETUP'] = array(SS_EXHRM_SETTINGS|5, _("Setup"));
         
         // Employees Access
         $security_areas['HR_EML_PROFILE'] = array(SS_EXHRM_EMPLOYEE|1, _("Profile")); 
         $security_areas['HR_EML_LEAVE'] = array(SS_EXHRM_EMPLOYEE|2, _("Leave Form")); 
         $security_areas['HR_EML_PAYROLL'] = array(SS_EXHRM_EMPLOYEE|3, _("Payroll History"));
         $security_areas['HR_EML_LEAVE_INQUIRY'] = array(SS_EXHRM_EMPLOYEE|4, _("Leave Inquiry")); 
         $security_areas['HR_EML_LOAN'] = array(SS_EXHRM_EMPLOYEE|5, _("Employee Loan Apply")); 

		return array($security_areas, $security_sections);
	}

    /* This method is called on extension activation for company.   */
    // function activate_extension($company, $check_only=true) {
    //     global $db_connections;

    //     $updates = array(   'update.sql' => array('ExtendedHRM')    );

    //     $result = db_query("SHOW COLUMNS FROM `".TB_PREF."users` LIKE 'employee_id'", _("can't get mysql result"));
    //     $exists = (db_num_rows($result))?TRUE:FALSE;
    //     if(!$exists)
    //       db_query("ALTER TABLE `".TB_PREF."users` ADD `employee_id` INT(11) NOT NULL AFTER `user_id`", _("can't alter suppliers Table"));
    //         return $this->update_databases($company, $updates, $check_only);
    //     }




    function activate_extension($company, $check_only=true)  {
        global $db_connections, $path_to_root, $systypes_array, $installed_extensions;
        $updates = array(   'update.sql' => array('HRM')    );

        // $result = db_query("SHOW COLUMNS FROM `".TB_PREF."users` LIKE 'employee_id'", "can't get mysql result");
        // $exists = (db_num_rows($result))?TRUE:FALSE;
        // if(!$exists)
        //   db_query("ALTER TABLE `".TB_PREF."users` ADD `employee_id` INT(11) NOT NULL AFTER `user_id`", "can't alter suppliers Table");

        //         $result = db_query("SHOW COLUMNS FROM `".TB_PREF."kv_empl_job` LIKE 'empl_id'", "can't get mysql result");
        // $exists = (db_num_rows($result))?TRUE:FALSE;
        // if(!$exists)
        //   db_query("ALTER TABLE `".TB_PREF."users` ADD `empl_id` INT(11) NOT NULL AFTER `id`", "can't alter job Table");

        if(!defined('ST_EMPLOYEE')){
      $types_ = file_get_contents($path_to_root.'/includes/types.inc');

      // $change_content = "define('ST_EMPLOYEE', 99) 
      $change_content = "define('ST_MANURECEIVE', 29);

      ".(!isset($systypes_array['ST_EMPLOYEE_ENCASHMENT']) ? 'define("ST_EMPLOYEE_ENCASHMENT",97);'.PHP_EOL : '' ) 
      .(!isset($systypes_array['ST_EMPLOYEE_LOAN']) ? 'define("ST_EMPLOYEE_LOAN",98);'.PHP_EOL : '' ) 
      .(!isset($systypes_array['ST_EMPLOYEE']) ? 'define("ST_EMPLOYEE",99);'.PHP_EOL : '' ) 
      .(!isset($systypes_array['ST_EMPLOYEE_ID']) ? 'define("ST_EMPLOYEE_ID",100);'.PHP_EOL : '' ) 
      .(!isset($systypes_array['ST_EMPLOYEE_PETROL']) ? 'define("ST_EMPLOYEE_PETROL",101);'.PHP_EOL : '' ) 
      .(!isset($systypes_array['ST_EMPLOYEE_TRAVEL']) ? 'define("ST_EMPLOYEE_TRAVEL",102);'.PHP_EOL : '' ) 
      .(!isset($systypes_array['ST_EMPLOYEE_ADVANCE']) ? 'define("ST_EMPLOYEE_ADVANCE",103);'.PHP_EOL : '' ) 
      .(!isset($systypes_array['ST_EMPLOYEE_SALARY']) ? 'define("ST_EMPLOYEE_SALARY",104);'.PHP_EOL : '' ) 
      .(!isset($systypes_array['PT_EMPLOYEE']) ? 'define("PT_EMPLOYEE",6);'.PHP_EOL : '' ); 

    // $types_inc = str_replace("define('ST_EMPLOYEE', 99)", $change_content, $types_);  
   $types_inc = str_replace("define('ST_MANURECEIVE', 29);", $change_content, $types_); 
    file_put_contents($path_to_root.'/includes/types.inc', $types_inc);

    $transactions_db = file_get_contents($path_to_root.'/admin/db/transactions_db.inc');

      $transactions_db_change = "case   ST_EMPLOYEE    : return array(TB_PREF.'kv_empl_salary', null, 'id', 'empl_id', 'date');
        case   ST_EMPLOYEE_ID   : return array(TB_PREF.'kv_empl_info', null, 'id', 'empl_id', 'date');
        case   ST_EMPLOYEE_LOAN   : return array(TB_PREF.'kv_empl_loan', null, 'id', 'empl_id', 'date');
        case   ST_EMPLOYEE_PETROL   : return array(TB_PREF.'kv_empl_petrol', null, 'id', 'empl_id', 'date');
        case   ST_EMPLOYEE_TRAVEL   : return array(TB_PREF.'kv_empl_travel', null, 'id', 'empl_id', 'date');
        case   ST_EMPLOYEE_ADVANCE   : return array(TB_PREF.'kv_empl_salary_advance', null, 'id', 'empl_id', 'date');
        case   ST_EMPLOYEE_SALARY   : return array(TB_PREF.'kv_empl_salary', null, 'id', 'empl_id', 'date');
        case   ST_EMPLOYEE_ENCASHMENT : return array(TB_PREF.'kv_empl_leave_encashment', null, 'id', 'empl_id', 'date');";

      $transactions_db__inc = str_replace('case     ST_SUPPLIER    : return array(TB_PREF."suppliers", null, "supplier_id", "supp_ref", null);', $transactions_db_change, $transactions_db);    
    file_put_contents($path_to_root.'/admin/db/transactions_db.inc', $transactions_db__inc);
  
    //sysnames.inc
    $sysnames = file_get_contents($path_to_root.'/includes/sysnames.inc');

      $change = 'ST_DIMENSION => _("Dimension"),'.PHP_EOL .'

          ST_EMPLOYEE_ID => _("Employee ID"),'.PHP_EOL .'
          ST_EMPLOYEE => _("Employee"),'.PHP_EOL .'
          ST_EMPLOYEE_LOAN => _("Employee Loan"),'.PHP_EOL .'
          ST_EMPLOYEE_PETROL => _("Employee Petrol Claim"),'.PHP_EOL .'
          ST_EMPLOYEE_ADVANCE => _("Salary Advance"),'.PHP_EOL .'
          ST_EMPLOYEE_SALARY => _("Employee Salary"),'.PHP_EOL .'
          ST_EMPLOYEE_ENCASHMENT => _("Employee Leave Encashment"),'.PHP_EOL .'
          ST_EMPLOYEE_TRAVEL => _("Employee Travel Claim"),' .PHP_EOL ;  
  
          $sysnames_inc = str_replace('ST_DIMENSION => _("Dimension"),', $change, $sysnames);   
      file_put_contents($path_to_root.'/includes/sysnames.inc', $sysnames_inc); 
    

    } 
//---------
//for update current access roles to current user session and security_roles table
  foreach($installed_extensions as $extid => $ext) {
    if($ext['name'] =='HRM And Payroll'){
      $extentionid =$extid;
      break;
    }
    }

        $security_sections[SS_EXHRM]               = _("HRM");
        $security_sections[SS_EXHRM_SETTINGS]       = _("HRM Settings");
        $security_sections[SS_EXHRM_PAYROLL]        = _("HRM Payroll");
        $security_sections[SS_EXHRM_EMPLOYEE]        = _("HRM Employee Access");

         $security_areas['HR_EMPL_INFO'] = array(SS_EXHRM|1, _("HRM Employee info")); 
         $security_areas['HR_ATTENDANCE'] = array(SS_EXHRM|2, _("Employee Attendence"));
         $security_areas['HR_LOANFORM'] = array(SS_EXHRM|3, _("Loan Application Form"));
         $security_areas['HR_EMPLOYEE_INQ'] = array(SS_EXHRM|4, _("Employee Inquiry")); 
         $security_areas['HR_SELATTENDANCE'] = array(SS_EXHRM|5, _("Selective Attendance List Show"));         
         $security_areas['HR_LOAN_INQ'] = array(SS_EXHRM|6, _("Loan Approve Inquiry"));
         $security_areas['HR_LEAVEFORM'] = array(SS_EXHRM|7, _("Leave Application Form"));
         $security_areas['HR_DOCUMENT_MGT'] = array(SS_EXHRM|8, _("Document")); 
     
         $security_areas['HR_PAYSLIP'] = array(SS_EXHRM_PAYROLL|1, _("Pay Slip Generation"));  
         $security_areas['HR_LEAVE_ENCASHMENT'] = array(SS_EXHRM_PAYROLL|2, _("Leave Encashment")); 
         $security_areas['HR_PAYROLL_SETUP'] = array(SS_EXHRM_PAYROLL|3, _("Payroll Setup"));    
         $security_areas['HR_PAYROLL_INQ'] = array(SS_EXHRM_PAYROLL|4, _("Payroll Inquriy"));    
         
         $security_areas['HR_REPORTS'] = array(SS_EXHRM_SETTINGS|1, _("HRM Reports")); 
         $security_areas['HR_EMPL_TAX'] = array(SS_EXHRM_SETTINGS|2, _("Tax Setup"));          
         $security_areas['HR_LOANTYPE'] = array(SS_EXHRM_SETTINGS|3, _("Loan Type Setup"));            
         $security_areas['HR_EMPLOYEE_SETUP'] = array(SS_EXHRM_SETTINGS|4, _("Setup"));
         
         // Employees Access
         $security_areas['HR_EML_PROFILE'] = array(SS_EXHRM_EMPLOYEE|1, _("Profile")); 
         $security_areas['HR_EML_LEAVE'] = array(SS_EXHRM_EMPLOYEE|2, _("Leave Form")); 
         $security_areas['HR_EML_PAYROLL'] = array(SS_EXHRM_EMPLOYEE|3, _("Payroll History"));
         $security_areas['HR_EML_LEAVE_INQUIRY'] = array(SS_EXHRM_EMPLOYEE|4, _("Leave Inquiry")); 
         $security_areas['HR_EML_LOAN'] = array(SS_EXHRM_EMPLOYEE|5, _("Employee Loan Apply")); 

    $security_sections[SS_EXHRM]                = _("HRM");
    $security_sections[SS_EXHRM_SETTINGS]       = _("HRM Settings");
    $security_sections[SS_EXHRM_PAYROLL]        = _("HRM Payroll");
    $security_sections[SS_EXHRM_EMPLOYEE]       = _("HRM Employee Access");
    $scode = 100;
  $acode = 100;
  $extsections = $security_sections;
  $extareas = $security_areas;
  $extcode = $extentionid<<16;
  $hrm_security_sections =array();
  $hrm_security_areas=array();
  $trans = array();
  foreach($extsections as $code =>$name) {
    $trans[$code] = $scode<<8;
    // reassign section codes
    $hrm_security_sections[$trans[$code]|$extcode] = $name;
    $scode++;
  }
  foreach($extareas as $code => $area) {
    $section = $area[0]&0xff00;
    // extension modules:
    // if area belongs to nonstandard section
    // use translated section codes and
    // preserve lower part of area code
    if (isset($trans[$section])) {
      $section = $trans[$section];
    } 
      // otherwise assign next available
      // area code >99
    $area[0] = $extcode | $section | ($acode++);
    $hrm_security_areas[$code] = $area;
  }
  include_once($path_to_root.'/admin/db/security_db.inc');

  //get current security role
  $myrow =get_security_role($_SESSION['wa_current_user']->access);
  $hrm_section=$myrow['sections'];
  $hrm_areas=$myrow['areas'];

  //add hrm roles to current security role
  foreach ($hrm_security_sections as $key => $value) {
    if(!in_array($key, $hrm_section)){
      $hrm_section[]=$key;
      //update current session access
      $_SESSION['wa_current_user']->role_set[] =$key;
    }
  }
  foreach ($hrm_security_areas as $key => $value) {
    if(!in_array($key, $hrm_areas)){
      $hrm_areas[]=$value[0];
      //update current session access
      $_SESSION['wa_current_user']->role_set[] =$value[0];
    }
  }
  // $sql = " INSERT INTO `".TB_PREF."reflines` (`id`, `trans_type`, `prefix`, `pattern`, `description`, `default`, `inactive`) VALUES (NULL, '99', '', '{001}', '', '1', '0');";
  
  update_security_role($_SESSION['wa_current_user']->access, $myrow['role'], $myrow['description'], $hrm_section, $hrm_areas);

  //update session app for hrm
  $_SESSION['App']->applications['hrm']=new ExtendedHRM_app;

//---------
            return $this->update_databases($company, $updates, $check_only);
    }


    function deactivate_extension($company, $check_only=true) {
        global $db_connections;

        $updates = array(     'drop.sql' => array('ugly_hack') );

        return $this->update_databases($company, $updates, $check_only);
    }

    function pre_header($args){

      //$_SESSION['wa_current_user']->HRM_Options = HRM_Get_Options();
    }
}

if(!function_exists('GetRow')) {
  function HRM_GetRow($table_name, $conditions = null, $order_by = null, $both= true){
    $sql0 = "SELECT * FROM ".TB_PREF.$table_name." WHERE 1=1";
    if($conditions != null) {
      foreach($conditions as $key=>$value){
        if(is_array($value)) { 
          $sql0 .= " AND ".$key." ".$value[1]." ". kv_db_escape($value[0]);
        } else
          $sql0 .= " AND {$key} = '${value}'";
      }
    }

    if($order_by != null) {
      $sql0 .=" ORDER BY ";
      foreach($order_by as $key=>$value){
        $sql0 .= " {$key} ${value}";
      }
    }

    $sql0 .= ' LIMIT 1'; 
    $result = db_query($sql0, "Could not get data from {$table_name}");
    if($both)
      $data = db_fetch($result);
        else
      $data = db_fetch_assoc($result);
    
    return $data;
  }
}

function HRM_GetSingleValue($tablename, $column_single, $conditions=null, $order_by = null, $sql=false){
    $sql0 = "SELECT ".$column_single." FROM ".TB_PREF.$tablename." WHERE 1=1";
    if($conditions){
      foreach($conditions as $key=>$value){
        $sql0 .= " AND {$key} = '${value}'";
      }
    }
    
    if($order_by != null) {
      $sql0 .=" ORDER BY ";
      foreach($order_by as $key=>$value){
        $sql0 .= " {$key} ${value}";
      }
    }
    if($sql)
      return $sql0;
    $result = db_query($sql0, _("could not get {$tablename}"));

    $row = db_fetch_row($result);

    $data = @unserialize(base64_decode($row[0]));
    if ($data !== false) {
        return unserialize(base64_decode($row[0]));
    }else
      return $row[0];
  }

function HRM_GetAll($table_name, $conditions = null, $order_by = null, $group_by = null, $default_company=null, $show_query=false, $return_sql=false){
       $sql0 = "SELECT * FROM ".TB_PREF.$table_name." WHERE 1=1";
        if($conditions != null) {
        foreach($conditions as $key=>$value){
                if(is_array($value)) { 
                    if(isset($value[2]))
                        $operator = $value[2];
                    else
                        $operator = '=';

                    if($value[1] == 'date')             
                        $sql0 .= " AND ".$key." ".$operator." ". db_escape(date2sql($value[0]));
                    elseif($value[1] == 'float')
                        $sql0 .= " AND ".$key." ".$operator." ". $value;
                    else
                        $sql0 .= " AND ".$key." ".$operator." ". db_escape($value[0]);
                }else
           $sql0 .= " AND {$key} = ".db_escape($value);
        }
        }
       
        if($group_by != null) {
            $sql0 .=" GROUP BY ";
            foreach($group_by as $value){
                $sql0 .= " ${value}";
            }
        }
        if($order_by != null) {
            $sql0 .=" ORDER BY ";
            foreach($order_by as $key=>$value){
                $sql0 .= " {$key} ${value}";
            }
        }
        if($return_sql)
            return $sql0;
        $result = db_query($sql0, "Could not get data from"." ".$table_name, $show_query);
        $data = array();
        while($row = db_fetch_assoc($result)) {
            $data[] = $row;
        }
        return $data;
}

function HRM_Get_Options(){
  $res = HRM_GetAll('kv_empl_option');
  $final = [];
  foreach($res as $row){
    $data = @unserialize(base64_decode($row['option_value']));
    if ($data !== false) {
        $final[$row['option_name']] = unserialize(base64_decode($row['option_value']));
    }else
      $final[$row['option_name']] = $row['option_value'];
  }
  return $final;
}

function get_payroll_trans_view_str($type=99, $trans_no='',  $label="", $icon=false, $class='', $id='') {
  if ($type == ST_EMPLOYEE)
    $viewer = "modules/ExtendedHRM/payslip.php?payslip_id=$trans_no";
  else
    return $trans_no;

  if ($label == "")
    $label = $trans_no;

  return viewer_link($label, $viewer, $class, $id,  $icon);
}

function last_month_pay_sal(){

  $sql = "SELECT MAX(`date`) FROM ".TB_PREF."kv_empl_salary";
    $result = db_query($sql);
        $dat = db_fetch_row($result);
  $rows = HRM_GetRow('kv_empl_salary',array('date' => $dat[0]));

  $sql1 = "SELECT SUM(`net_pay`) FROM ".TB_PREF."kv_empl_salary WHERE from_date = ".db_escape($rows['from_date'])." AND to_date = ".db_escape($rows['to_date'])."";
    $res = db_query($sql1, _("Can't get payout salary"));

    if($row = db_fetch($res))
      return price_format(round($row[0]));
    else
      return false;
}

function get_employee() {

   $sql = "SELECT COUNT(*) FROM ".TB_PREF."kv_empl_info";
   $res = db_query($sql, _("Can't get employee"));

  if($row = db_fetch($res))
    return $row[0];
  else
    return false;
}

function get_active_empl() {

   $sql = "SELECT COUNT(*) FROM ".TB_PREF."kv_empl_info WHERE status = 1";
   $res = db_query($sql, _("Can't get active employee"));

   if($row = db_fetch($res))
    return $row[0];
  else
    return false;
}

function get_departments() {

   $sql = "SELECT COUNT(*) FROM ".TB_PREF."kv_empl_departments";
   $res = db_query($sql, _("Can't get departments"));

  if($row = db_fetch($res))
    return $row[0];
  else
    return false;
}


function get_presents_absent() {
        global $path_to_root ;
        $today = date2sql(Today());

        $sql = "SELECT * FROM ".TB_PREF."kv_empl_attendance WHERE a_date = '".$today."'";

    $res = db_query($sql, _("Can't get attendance"));

    // if($row = db_fetch($res))
      return $res;
    // else
    //   return false;
}



// $present = $absent = $leave = $onduty = 0 ;
//      while($row2 = db_fetch($res)){
//     $attendance_code  = $row2['code'];
//      if($row2['code'] == 'A')
//        $absent++;
//      elseif($row2['code'] == 'P')
//        $present++;
//      elseif($row2['code'] == 'AL' || $row2['code'] == 'CL' || $row2['code'] == 'SL' || $row2['code'] == 'ML' || $row2['code'] == 'L')
//        $leave++;
//      elseif($row2['code'] == 'OD')
//        $onduty++;

//           }

?>
