
<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITN
    ESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_BOM';
$path_to_root = "../..";
include_once($path_to_root . "/includes/session.inc");

page(_($help_context = " QC Setup"));

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/purchasing/includes/db/po_db.inc");

check_db_has_bom_stock_items(_("There are no manufactured or kit items defined in the system."));

check_db_has_workcentres(_("There are no work centres defined in the system. BOMs require at least one work centre be defined."));

simple_page_mode(true);
$selected_component = $selected_id;
//--------------------------------------------------------------------------------------------------

if (isset($_GET['stock_id']))
{
	$_POST['stock_id'] = $_GET['stock_id'];
	$selected_parent =  $_GET['stock_id'];
}

//--------------------------------------------------------------------------------------------------

function display_bom_items($selected_parent)
{
	$result = get_qc_details($selected_parent);
	div_start('bom');
	start_table(TABLESTYLE, "width='60%'");
	$th = array(_("Name"), _("Input Type"), _("min"),
		_("max"), _("dropdwon value"),'','');
	table_header($th);

	$k = 0;
	$found = false;
	while ($myrow = db_fetch($result))
	{
		$found = true;
		alt_table_row_color($k);

		label_cell($myrow["name"]);
		label_cell($myrow["qc_type"]);
        label_cell($myrow["min"]);
        label_cell($myrow["max"]);
        // qty_cell($myrow["quantity"], false, get_qty_dec($myrow["component"]));
        label_cell($myrow["options"]);
 		edit_button_cell("Edit".$myrow['id'], _("Edit"));
 		delete_button_cell("Delete".$myrow['id'], _("Delete"));
        end_row();

	} //END WHILE LIST LOOP
	end_table();
	
	if ($found) {
		start_table(TABLESTYLE, "width='60%'");
			// stock_categories_list_row(_("Category:"), 'category_id', null, false, $new_item, $fixed_asset);
		// stock_manufactured_items_list_row(_("Copy BOM to another manufacturable item"), 'new_stock_id', $selected_parent, false, true);
		end_table();
	}

	div_end();
}

function copy_bom_items($stock_id, $new_stock_id)
{
	$result = get_bom($stock_id);
	while ($myrow = db_fetch($result))
	{
		$_POST['component'] = $myrow["component"];
		$_POST['loc_code'] = $myrow["loc_code"];
		$_POST['workcentre_added'] = $myrow["workcentre_added"];
		$_POST['quantity'] = $myrow["quantity"];
		on_submit($new_stock_id, -1);
	}
}
 
//--------------------------------------------------------------------------------------------------

function on_submit($selected_parent, $selected_component=-1)
{
	if ($_POST['inp_name']=='')
	{
		display_error(_("Field Name Must be entered."));
		set_focus('inp_name');
		return;
	}
	else
	{

  // display_error($_POST['category_id']." ,  ".$_POST['inp_type_id']." ,  ".$_POST['inp_name']." ,  ".$_POST['min']." ,  ".$_POST['max']." ,  ".$_POST['list_value']);exit();
		if(isset($_POST['selected_id']))
		{

			update_qc_field($_POST['selected_id'],$_POST['category_id'],$_POST['inp_type_id'],$_POST['inp_name'],$_POST['min'],input_num('max'),$_POST['list_value']);
	    	display_notification(_("The  QC field has been Updated"));
	    		unset($_POST['inp_name']);

		}
		else{

	        add_qc_field($_POST['category_id'],$_POST['inp_type_id'],$_POST['inp_name'],$_POST['min'],input_num('max'),$_POST['list_value']);
	    	display_notification(_("The  QC field has been Added"));
	    		unset($_POST['inp_name']);

		}

     
	}
}

//--------------------------------------------------------------------------------------------------

if ($Mode == 'Delete')
{
	delete_qc_setup_item($selected_id);
	display_notification(_("The QC setup item has been deleted from"));
	$Mode = 'RESET';
}

if ($Mode == 'RESET')
{
	$selected_id = -1;
	unset($_POST['quantity']);
}

//--------------------------------------------------------------------------------------------------

if (list_updated('new_stock_id')) {
	copy_bom_items($_POST['stock_id'], $_POST['new_stock_id']);
	$item = get_item($_POST['new_stock_id']);
	$_POST['stock_id'] = $_POST['new_stock_id'];
	$Ajax->activate('_page_body');
	display_notification(_("BOM copied to ") . $item['description']);
}

start_form();

start_form(false, true);
start_table(TABLESTYLE_NOBORDER);
start_row();
	stock_categories_list_row(_("Category:"), 'category_id', null, false, true, $fixed_asset);

// stock_manufactured_items_list_cells(_("Select a manufacturable item:"), 'stock_id', null, false, true);
end_row();
if (list_updated('category_id'))
{
	$selected_id = -1;
	$Ajax->activate('_page_body');
}
end_table();
br();

end_form();
//--------------------------------------------------------------------------------------------------

if (get_post('category_id') != '')
{ //Parent Item selected so display bom or edit component
	$selected_parent = $_POST['category_id'];
	if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM')
		on_submit($selected_parent, $selected_id);
	//--------------------------------------------------------------------------------------

start_form();
	display_bom_items($selected_parent);
	//--------------------------------------------------------------------------------------
	echo '<br>';

	start_table(TABLESTYLE2);

	if ($selected_id != -1)
	{
 		if ($Mode == 'Edit') {
			//editing a selected component from the link to the line item
			$myrow = get_qc_details_id($selected_id);

			$_POST['inp_name'] = $myrow["name"];
			$_POST['inp_type_id'] = $myrow["qc_type"]; // by Tom Moulton
			$_POST['min']  = $myrow["min"];
			$_POST['max']  = $myrow["max"];
      
			$_POST['list_value']  = $myrow["options"];
			// $_POST['quantity'] = number_format2($myrow["quantity"], get_qty_dec($myrow["component"]));
			// label_row(_("Component:"), $myrow["component"] . " - " . $myrow["description"]);
		}
		hidden('selected_id', $selected_id);
	}
	
//	hidden('stock_id', $selected_parent);

    text_row_ex(_("Field Name:"), 'inp_name', 30);
    input_type_list_row(_('Input Type'), 'inp_type_id', $_POST['inp_type_id'],false,true);
    // display_error($_POST['inp_type_id']);
	if (list_updated('inp_type_id'))
	{
	$Ajax->activate('_page_body');
	}

	if($_POST['inp_type_id']==2)
	{
		qty_row(_("min:"), 'min', number_format2(1, 0), '');
		qty_row(_("max:"), 'max', number_format2(1, 0), '');
	}
	elseif($_POST['inp_type_id']==6){
		 // text_row_ex($label, $name, $size, $max=null, $title=null, $value=null, $params=null, $post_label=null)
         text_row_ex(_("List name (Comma sparated Value):"), 'list_value', 100);
	}
	
	// workcenter_list_row(_("Work Centre Added:"), 'workcentre_added', null);
	// $dec = get_qty_dec(get_post('component'));
	// $_POST['quantity'] = number_format2(input_num('quantity',1), $dec);
	// qty_row(_("Quantity:"), 'quantity', null, null, null, $dec);

	end_table(1);
	submit_add_or_update_center($selected_id == -1, '', 'both');
	end_form();
}
// ----------------------------------------------------------------------------------

end_page();

