<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_QCTRANS';
$path_to_root = "..";
include_once($path_to_root . "/purchasing/includes/po_class.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/purchasing/includes/purchasing_db.inc");
include_once($path_to_root . "/purchasing/includes/purchasing_ui.inc");
include_once($path_to_root . "/includes/db_pager.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "QC Trans"), false, false, "", $js);

if (isset($_GET['PONumber']))
{
	$_POST['order_no'] = $_GET['PONumber'];
	hidden('order_no', $_POST['order_no']);
}

//---------------------------------------------------------------------------------------------------------------

// if (isset($_GET['AddedID']))
// {
// 	$grn = $_GET['AddedID'];
// 	$trans_type = ST_SUPPRECEIVE;

// 	display_notification_centered(_("Purchase Order Delivery has been processed"));

// 	display_note(get_trans_view_str($trans_type, $grn, _("&View this Delivery")));
	
//     $clearing_act = get_company_pref('grn_clearing_act');
// 	if ($clearing_act)	
// 		display_note(get_gl_view_str($trans_type, $grn, _("View the GL Journal Entries for this Delivery")), 1);

// 	hyperlink_params("$path_to_root/purchasing/supplier_invoice.php", _("Entry purchase &invoice for this receival"), "New=1");

// 	hyperlink_no_params("$path_to_root/purchasing/inquiry/po_search.php", _("Select a different &purchase order for receiving items against"));

// 	display_footer_exit();
// }

// if (isset($_GET['AddedQC']))
// {
// 	$qc_id = $_GET['AddedQC'];

// 	hyperlink_params("$path_to_root/purchasing/view/qc_trans_view.php", _("View QC Trans"), 
// 		"qc_id=$qc_id");
// 	display_footer_exit();
// }


//--------------------------------------------------------------------------------------------------

if ((!isset($_GET['PONumber']) || $_GET['PONumber'] == 0) && !isset($_SESSION['QC']))
{
	die (_("This page can only be opened if a purchase order has been selected. Please select a purchase order first."));
}

//--------------------------------------------------------------------------------------------------

function display_po_receive_items($kv_batch=0, $kv_exp_date=0)
{
	div_start('qc_trans');
	// $_GET['qc_trans_no']=($_GET['qc_trans_no']) ?  $_GET['qc_trans_no'] : $_POST['qc_trans_no'];
	display_error($_GET['qc_trans_no']." == ".$_POST['qc_trans_no']);

    start_table(TABLESTYLE, "colspan=7 width='90%'");
    $th = array(_("S.No"), _("Batch No."), _("Size"), _("Type"), _("GSM"), 
    	_("Weight"), _("Gsm 1"), _("Gsm 2"), _("Gsm Avg"), _("Bct 1"), 
    	_("Bct 2"), _("Bct Avg"), _("MD"), _("CD"), _(" Moisture %"), _("Ash %"));
    table_header($th);
    $result = get_purch_qc_trans_details(($_GET['qc_trans_no']) ?  $_GET['qc_trans_no'] : $_POST['qc_trans_no']);
    $sno=1;
	$dec = 0;	
	$i = 0;	
	// echo '<pre>';
	// print_r($_SESSION['QC']->line_items);
	$sum_weight=$gsm_avg=$bct_avg=$sum_md=$sum_cd=$sum_moisture=$sum_ash=0;
    foreach ($_SESSION['QC']->line_items as $ln_itm)
	{
		$against_grn_item = get_against_grn_item($ln_itm->po_detail_rec);
		// print_r($against_grn_item);
		alt_table_row_color($k);
		if ($_GET['qc_trans_no']) {
			$data = db_fetch($result);
			 	$_POST['weight'.$i] = $data['weight']; 
			 	$_POST['gsm_1'.$i] = $data['gsm_1']; 
			 	$_POST['gsm_2'.$i] = $data['gsm_2']; 
			 	$_POST['gsm_average'.$i] = $data['gsm_average']; 
			 	$_POST['bst_1'.$i] = $data['bst_1']; 
			 	$_POST['bst_2'.$i] = $data['bst_2']; 
			 	$_POST['bst_average'.$i] = $data['bst_average']; 
			 	$_POST['md'.$i] = $data['md']; 
			 	$_POST['cd'.$i] = $data['cd']; 
			 	$_POST['per_deckle'.$i] = $data['per_deckle']; 
			 	$_POST['moisture'.$i] = $data['moisture']; 
			 	hidden('src_id'.$i,  $data['id']);
		         // display_error( $data['id']." sdsd");
		}
		else{

                 if(isset($_POST['qc_trans_no']))
                 {
				  	$data = db_fetch($result);
					hidden('src_id'.$i,  $data['id']);
			        display_error( $data['id']." sdsd");
                 	
                 }	
		   }

		

		

		label_cell($sno , "align='center'");
		$sno++;
		label_cell($against_grn_item['batch_no'] , "align='center'");
		label_cell((!$ln_itm->size_id) ? '-' : get_size_name($ln_itm->size_id), "align='center'");
		label_cell($ln_itm->item_description, "align='center'");
		label_cell( (!$ln_itm->gsm_id) ? '-' : get_gsm_name($ln_itm->gsm_id) , "align='center'");
		
		global $Ajax;
// 		display_error($against_grn_item['po_detail_item']." == ".$data['po_detail_rec']);

		if($against_grn_item['po_detail_item'] == $data['po_detail_rec'] && $data['po_detail_rec']!='')
		small_qty_cells(null, 'weight'.$i, $_POST['weight'.$i], null, null, $dec, false, 'readonly');
		else
		small_qty_cells(null, 'weight'.$i, $_POST['weight'.$i], null, null, $dec,true);

		$sum_gsm = $_POST['gsm_1'.$i] + $_POST['gsm_2'.$i];
		$_POST['gsm_average'.$i] = $sum_gsm / 2;
		$Ajax->activate('gsm_average'.$i);

		small_qty_cells(null, 'gsm_1'.$i, $_POST['gsm_1'.$i], null, null, $dec, true);
		small_qty_cells(null, 'gsm_2'.$i, $_POST['gsm_2'.$i], null, null, $dec, true);
		// qty_cells(null, 'gsm_average'.$i, null, $_POST['gsm_average'.$i], null, $dec, false, 'readonly');

		amount_cells_ex(null, 'gsm_average'.$i , 6, 6, $_POST['gsm_average'.$i] , null, null , $dec,
		false, 'readonly');
		// small_qty_cells(null, 'gsm_average'.$i, $_POST['gsm_average'.$i], null, null, $dec);
		$sum_bst = $_POST['bst_1'.$i] + $_POST['bst_2'.$i];
		$_POST['bst_average'.$i] = $sum_bst / 2;
		$Ajax->activate('bst_average'.$i);
		small_qty_cells(null, 'bst_1'.$i, $_POST['bst_1'.$i], null, null, $dec, true);
		small_qty_cells(null, 'bst_2'.$i, $_POST['bst_2'.$i], null, null, $dec, true);
		amount_cells_ex(null, 'bst_average'.$i , 6, 6, $_POST['bst_average'.$i] , null, null , $dec,
		false, 'readonly');
		// qty_cells(null, 'bst_average'.$i, null, $_POST['bst_average'.$i], null, $dec, false, 'readonly');
		// small_qty_cells(null, 'bst_average'.$i, $_POST['bst_average'.$i], null, null, $dec);
		small_qty_cells(null, 'md'.$i, $_POST['md'.$i], null, null, 2,true);
		small_qty_cells(null, 'cd'.$i, $_POST['cd'.$i], null, null, 2,true);
	    small_qty_cells(null, 'moisture'.$i, $_POST['moisture'.$i], null, null, 2,true);
		small_qty_cells(null, 'per_deckle'.$i, $_POST['per_deckle'.$i], null, null, 2,true);
		hidden('batch_no'.$i, $against_grn_item['batch_no']);
		$sum_weight+=input_num('weight'.$i);
        $gsm_avg+=input_num('gsm_average'.$i);
        $bct_avg+=input_num('bst_average'.$i);
        $sum_md+=input_num('md'.$i);
        $sum_cd+=input_num('cd'.$i);
        $sum_moisture+=input_num('moisture'.$i);
        $sum_ash+=input_num('per_deckle'.$i);
		$i++;
		end_row();

     

    }
	$Ajax->activate('qc_trans');
	 $sno--;
    label_cell("Total",'colspan=5 class="tableheader2" ');

		label_cell(price_format($sum_weight),' align="right" ');
		label_cell(_() ,"colspan=2 ");
		label_cell(price_format($gsm_avg/$sno),' align="right" ');
		label_cell(_() ,"colspan=2 ");
		label_cell(price_format($bct_avg/$sno) ,' align="right" ');

		label_cell(price_format($sum_md/$sno),' align="right" ');
		label_cell(price_format($sum_cd/$sno) ,' align="right" ');
		label_cell(price_format($sum_moisture/$sno),' align="right" ');
		label_cell(price_format($sum_ash/$sno),' align="right" ');

    end_table();
	div_end();
}

//--------------------------------------------------------------------------------------------------

function check_po_changed()
{
	/*Now need to check that the order details are the same as they were when they were read
	into the Items array. If they've changed then someone else must have altered them */
	// Compare against COMPLETED items only !!
	// Otherwise if you try to fullfill item quantities separately will give error.
	$result = get_po_items($_SESSION['QC']->order_no);

	$line_no = 0;
	while ($myrow = db_fetch($result))
	{
		$ln_item = $_SESSION['QC']->line_items[$line_no];
		// only compare against items that are outstanding
		$qty_outstanding = $ln_item->quantity - $ln_item->qty_received;
		if ($qty_outstanding > 0)
		{
    		if ($ln_item->qty_inv != $myrow["qty_invoiced"]	||
    			$ln_item->stock_id != $myrow["item_code"] ||
    			$ln_item->quantity != $myrow["quantity_ordered"] ||
    			$ln_item->qty_received != $myrow["quantity_received"])
    		{
    			return true;
    		}
		}
	 	$line_no++;
	} /*loop through all line items of the order to ensure none have been invoiced */

	return false;
}

//--------------------------------------------------------------------------------------------------

function can_process()
{
	global $SysPrefs;
	
	if (count($_SESSION['QC']->line_items) <= 0)
	{
        display_error(_("There is nothing to process. Please enter valid quantities greater than zero."));
    	return false;
	}

	if (!is_date($_POST['DefaultReceivedDate']))
	{
		display_error(_("The entered date is invalid."));
		set_focus('DefaultReceivedDate');
		return false;
	}
	if (!is_date_in_fiscalyear($_POST['DefaultReceivedDate'])) {
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('DefaultReceivedDate');
		return false;
	}

	if (!check_reference($_POST['ref'], ST_SUPPRECEIVE))
	{
		set_focus('ref');
		return false;
	}

	$something_received = 0;
	foreach ($_SESSION['QC']->line_items as $order_line)
	{		
	  	if ($order_line->receive_qty > 0)
	  	{
			$something_received = 1;
			break;
	  	}
	}

    // Check whether trying to deliver more items than are recorded on the actual purchase order (+ overreceive allowance)
    $delivery_qty_too_large = 0;
	foreach ($_SESSION['QC']->line_items as $order_line)
	{
	  	if ($order_line->receive_qty+$order_line->qty_received >
	  		$order_line->quantity * (1+ ($SysPrefs->over_receive_allowance() / 100)))
	  	{
			$delivery_qty_too_large = 1;
			break;
	  	}
	}

    // if ($something_received == 0)
    // { 	/*Then dont bother proceeding cos nothing to do ! */
    //     display_error(_("There is nothing to process. Please enter valid quantities greater than zero."));
    // 	return false;
    // }
    // elseif ($delivery_qty_too_large == 1)
    // {
    // 	display_error(_("Entered quantities cannot be greater than the quantity entered on the purchase order including the allowed over-receive percentage") . " (" . $SysPrefs->over_receive_allowance() ."%)."
    // 		. "<br>" .
    // 	 	_("Modify the ordered items on the purchase order if you wish to increase the quantities."));
    // 	return false;
    // }

	return true;
}

//--------------------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------------------

if (isset($_GET['PONumber']) && $_GET['PONumber'] > 0 && !isset($_POST['Update']))
{
	create_new_qc(ST_PURCHORDER, $_GET['PONumber']);
	$_SESSION['QC']->trans_type = ST_SUPPRECEIVE;
// 	$_SESSION['QC']->reference = $Refs->get_next(ST_SUPPRECEIVE, null,
// 		array('date' => Today(), 'supplier' => $_SESSION['QC']->supplier_id));
	copy_from_cart();
}

//--------------------------------------------------------------------------------------------------

if (isset($_POST['Update']) || isset($_POST['ProcessGoodsReceived']))
{

	/* if update quantities button is hit page has been called and ${$line->line_no} would have be
 	set from the post to the quantity to be received in this receival*/
	// foreach ($_SESSION['QC']->line_items as $line)
	// {
	//  if( ($line->quantity - $line->qty_received)>0) {
	// 	$_POST[$line->line_no] = max($_POST[$line->line_no], 0);
	// 	if (!check_num($line->line_no))
	// 		$_POST[$line->line_no] = number_format2(0, get_qty_dec($line->stock_id));

	// 	if (!isset($_POST['DefaultReceivedDate']) || $_POST['DefaultReceivedDate'] == "")
	// 		$_POST['DefaultReceivedDate'] = new_doc_date();

	// 	$_SESSION['QC']->line_items[$line->line_no]->receive_qty = input_num($line->line_no);

	// 	if (isset($_POST[$line->stock_id . "Desc"]) && strlen($_POST[$line->stock_id . "Desc"]) > 0)
	// 	{
	// 		$_SESSION['QC']->line_items[$line->line_no]->item_description = $_POST[$line->stock_id . "Desc"];		

	// 		$_SESSION['QC']->line_items[$line->line_no]->batch_no = $_POST[$line->line_no . "batch_no"];
	// 		$_SESSION['QC']->line_items[$line->line_no]->exp_date = $_POST[$line->stock_id . "exp_date"];
	// 	}
	//  }
	// }
	$Ajax->activate('qc_trans');
}

//--------------------------------------------------------------------------------------------------

if (isset($_POST['ProcessGoodsReceived']) || isset($_POST['Update']) )
{
	begin_transaction();
	if (!$_POST['qc_trans_no']) {
	$sql = "INSERT INTO ".TB_PREF."purch_qc_trans (order_no, type, vehicle_no, chalan_no, reveived_date, tested_date, iso_no, lot_qty,qc_status,remarks) VALUES (
	 ".db_escape($_POST['order_no']).", 
	 ".db_escape(ST_PURCHORDER).", 
	 ".db_escape($_POST['vehicle_no']).", 
	 ".db_escape($_POST['chalan_no']).", '".date2sql($_POST['reveived_date'])."', 
	 '".date2sql($_POST['tested_date'])."', ".db_escape($_POST['iso_no']).",
	 ".db_escape($_POST['lot_qty']).",
	 ".db_escape($_POST['qc_status']).",
	 ".db_escape($_POST['remarks']).")";
   	db_query($sql,"The purch qc trans could not be added");
   	$qc_trans_id = db_insert_id();
	}
	else{
       
       $sql = "UPDATE ".TB_PREF."purch_qc_trans SET remarks=".db_escape($_POST['remarks'])." , vehicle_no=".db_escape($_POST['vehicle_no'])."
       , iso_no=".db_escape($_POST['iso_no'])."
       , lot_qty=".db_escape($_POST['lot_qty'])."
       , qc_status=".db_escape($_POST['qc_status'])." WHERE 
		order_no=".db_escape($_POST['order_no']);
   		db_query($sql,"The purch orders is qc could not be updated");
        $qc_trans_id= $_POST['qc_trans_no'];

	}
   	$i=0;
  	foreach ($_SESSION['QC']->line_items as $ln_itm){
	if (!$_POST['src_id'.$i]) {		
	$sql = "INSERT INTO ".TB_PREF."purch_qc_trans_details (qc_trans_id, sno, batch_no, type,
	 gsm_id, size_id, weight, gsm_1, gsm_2, gsm_average, bst_1, bst_2, bst_average, md, cd, per_deckle, po_detail_rec,moisture)
	  VALUES (".db_escape($qc_trans_id).", '0', ".db_escape($_POST['batch_no'.$i]).", 
	 ".db_escape($ln_itm->item_description).", 
	 ".db_escape($ln_itm->gsm_id).", 
	 ".db_escape($ln_itm->size_id).", ".db_escape(input_num('weight'.$i)).",
	 ".db_escape($_POST['gsm_1'.$i]).",  ".db_escape($_POST['gsm_2'.$i]).",  
	 ".db_escape($_POST['gsm_average'.$i]).",  ".db_escape($_POST['bst_1'.$i]).", 
	 ".db_escape($_POST['bst_2'.$i]).", ".db_escape($_POST['bst_average'.$i]).",
	 ".db_escape($_POST['md'.$i]).", ".db_escape($_POST['cd'.$i]).", 
	 ".db_escape($_POST['per_deckle'.$i]).", ".db_escape($ln_itm->po_detail_rec).", ".db_escape($_POST['moisture'.$i]).")";
  	 db_query($sql,"The purch qc trans details could not be added");
  	 // display_error($sql);
	 }else{
		$sql = "UPDATE ".TB_PREF."purch_qc_trans_details SET batch_no=".db_escape($_POST['batch_no'.$i]).",weight=".db_escape($_POST['weight'.$i]).",
		 	gsm_1=".db_escape($_POST['gsm_1'.$i]).", gsm_2=".db_escape($_POST['gsm_2'.$i]).",
		 	gsm_average=".db_escape($_POST['gsm_average'.$i]).", bst_1=".db_escape($_POST['bst_1'.$i]).",
		 	bst_2=".db_escape($_POST['bst_2'.$i]).", bst_average=".db_escape($_POST['bst_average'.$i]).",
		 	md=".db_escape($_POST['md'.$i]).", cd=".db_escape($_POST['cd'.$i]).", moisture=".db_escape($_POST['moisture'.$i])." ,
		 	per_deckle=".db_escape($_POST['per_deckle'.$i]).",
		 	per_deckle=".db_escape($_POST['per_deckle'.$i]).",
		 	per_deckle=".db_escape($_POST['per_deckle'.$i]).",
		 	per_deckle=".db_escape($_POST['per_deckle'.$i])." WHERE id = ".db_escape($_POST['src_id'.$i]);
	 	// display_error($sql);
		db_query($sql,"The purch qc trans details could not be updated");
	 }
	 $i++;
	}

	commit_transaction();
	if($_POST['order_no']  && !isset($_POST['Update']))
	{
		$sql = "UPDATE ".TB_PREF."purch_orders SET is_qc=1 WHERE 
		order_no=".db_escape($_POST['order_no']);
   		db_query($sql,"The purch orders is qc could not be updated");
	}	
	commit_transaction();
	// display_error($sql);

	if(isset($_POST['Update']))
	 meta_forward($path_to_root.'/purchasing/purch_qc_trans.php?PONumber='.$_POST['order_no'].'&qc_trans_no='.$qc_trans_id);
	
		// if(!$_POST['qc_trans_no'])
	 	meta_forward($path_to_root.'/purchasing/inquiry/po_search.php');
	 	// else
	 	// meta_forward($path_to_root.'/purchasing/inquiry/po_search_completed.php');
	

}

//--------------------------------------------------------------------------------------------------
$kv_batch = get_company_pref('kv_batch');
$kv_exp_date = get_company_pref('kv_exp_date');
if(isset($_GET['qc_trans_no']))
$_POST['qc_trans_no'] = $_GET['qc_trans_no'];
hidden('qc_trans_no', $_POST['qc_trans_no']);

if ($_GET['qc_trans_no']) {
$row = get_purch_qc_trans($_GET['qc_trans_no'], ST_PURCHORDER);
	$_POST['vehicle_no'] = $row['vehicle_no'];
	$_POST['chalan_no'] = $row['chalan_no'];
	$_POST['reveived_date'] = sql2date($row['reveived_date']);
	$_POST['tested_date'] = sql2date($row['tested_date']);
	$_POST['iso_no'] = $row['iso_no'];
	$_POST['lot_qty'] = $row['lot_qty'];
		$_POST['qc_status'] = $row['qc_status'];
		$_POST['remarks'] = $row['remarks'];
}


	// print_r($row);
	$purchase_order = new purch_order;
	read_po($_POST['order_no'], $purchase_order,false,true);

start_form();
start_outer_table(TABLESTYLE2, "width='80%'");
table_section(1);
text_row_ex(_("Vehicle No:"), 'vehicle_no', 20, null, null, $_POST['vehicle_no'],null, 
    null, false);
text_row_ex(_("Challan No:"), 'chalan_no', 20, null, null, $_POST['chalan_no'],null, 
    null, false);
date_row(_("Received Date:"), 'reveived_date', null, null, 0, 0, 0,$_POST['reveived_date'], false);
label_cells(_("Supplier"), $purchase_order->supplier_name, "class='tableheader2'");
table_section(2);
date_row(_("Tested Date:"), 'tested_date', null, null, 0, 0, 0,$_POST['tested_date'], false);
// text_row_ex(_("ISO No:"), 'iso_no', 20, null, null, $_POST['lot_qty'],null, 
//     null, false);
// label_row(_("Po"),$purchase_order->reference);
label_row(_("PO "),  get_trans_view_str(ST_PURCHORDER, $_POST['order_no'],$purchase_order->reference) );
text_row_ex(_("Lot Qty:"), 'lot_qty', 20, null, null, $_POST['lot_qty'],null, 
    null, false);
yesno_list_row(_("Status Based"), 'qc_status', null, _("Pass"), _("Rejected"), false);
	textarea_row(_("Remarks:"), "remarks", $_POST['remarks'], 50, 3);
$qc_res =get_qc_trans_all($_POST['order_no'], ST_PURCHORDER);
$last_qc_no=0;
while($qc_trans=db_fetch($qc_res))
   $last_qc_no=$qc_trans['id'];
// display_error($last_qc_no);
if($last_qc_no)
label_cells("Conditionally Approved Last QC ",pager_link(null,
		"/purchasing/purch_qc_trans.php?PONumber=".$_POST["order_no"]."&qc_trans_no=".$last_qc_no, ICON_ADD));

// ahref_cell("Conditionally Approved Last QC","/purchasing/purch_qc_trans.php?PONumber=".$_POST["order_no"]."&qc_trans_no=".$last_qc_no, ICON_ADD);
end_outer_table(1);
display_heading(_("Items to Receive"));
display_po_receive_items($kv_batch, $kv_exp_date);
echo '<br>';
submit_center_first('Update', _("Update"), '', true);
submit_center_last('ProcessGoodsReceived', _("Process Receive Items"), _("Clear all GL entry fields"), 'default');

end_form();

//--------------------------------------------------------------------------------------------------
end_page();
