<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
    Released under the terms of the GNU General Public License, GPL, 
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_QCTRANS';
$path_to_root = "../..";
include($path_to_root . "/purchasing/includes/po_class.inc");
include($path_to_root . "/includes/session.inc");
include($path_to_root . "/purchasing/includes/purchasing_ui.inc");
include_once($path_to_root . "/inventory/includes/db/gsm_db.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
    $js .= get_js_open_window(900, 500);
page(_($help_context = "View QC Trans"), true, false, "", $js);

if (!isset($_GET['qc_no']))
{
    die ("<br>" . _("This page must be called with a purchase order number to review."));
}

display_heading(_("") . "QC Trans # ".  $_GET['qc_no']);
br(2);


$row = get_purch_qc_trans($_GET['qc_no'], $_GET['type']);

$purchase_order = new purch_order;
read_po($row['order_no'], $purchase_order,false,true);

start_outer_table(TABLESTYLE2, "width='100%'");
start_outer_table(TABLESTYLE2, "width=90%");
start_row();
label_cells(_("Vehicle No:"), $row['vehicle_no'], "class='tableheader2'");
label_cells(_("Challan No:"), $row['chalan_no'], "class='tableheader2'");
end_row();
start_row();
label_cells(_("Received Date:"), sql2date($row['reveived_date']), "class='tableheader2'");
label_cells(_("Tested Date:"), sql2date($row['reveived_date']), "class='tableheader2'");
end_row();
start_row();
label_cells(_("ISO No:"), $row['iso_no'], "class='tableheader2'");
label_cells(_("Lot Qty:"), $row['lot_qty'], "class='tableheader2'");
end_row();
start_row();
label_cells(_("Supplier"), $purchase_order->supplier_name, "class='tableheader2'");
if(!$row['qc_status'])
label_cells(_("Status"),  '<span class="label label-danger"> Rejected <span>', "class='tableheader2'");
else
label_cells(_("Status"),  '<span class="label label-success"> PASS <span>', "class='tableheader2'");

end_row();

start_row();
// print_r($row);
label_cells(_("Remarks"),  '<span class="label label-info">'.$row['remarks'].'<span>' , "class='tableheader2'");

end_row();
end_outer_table();
end_outer_table(1);

$result = get_purch_qc_trans_details($_GET['qc_no']);
start_form();
start_table(TABLESTYLE, "width='30%'");

$th = array(_("S.No"), _("Batch No."), _("Size"), _("Type"), _("Gsm"), 
_("Weight"), _("Gsm 1"), _("Gsm 2"), _("GSM Avg"), _("BST 1"), _("BST 2"), _("BST Avg"), 
_("MD"), _("CD"), _(" Moisture %"), _("Ash %"));
table_header($th);

    $sum_weight=$gsm_avg=$bct_avg=$sum_md=$sum_cd=$sum_moisture=$sum_ash=0;

$sno=1;
$type = '-';
while ($myrow = db_fetch($result)) 
{
    label_cell($sno , "align='center'");
    $sno++;
    label_cell($myrow["batch_no"], "align='center'");
    label_cell(get_size_name($myrow["size_id"]), "align='center'");
    label_cell($myrow["type"], "align='center'");
    label_cell(get_gsm_name($myrow["gsm_id"]), "align='center'");
    label_cell($myrow["weight"], "align='center'");
    label_cell($myrow["gsm_1"], "align='center'");
    label_cell($myrow["gsm_2"], "align='center'");
    label_cell($myrow["gsm_average"], "align='center'");
    label_cell($myrow["bst_1"], "align='center'");
    label_cell($myrow["bst_2"], "align='center'");
    label_cell($myrow["bst_average"], "align='center'");
    label_cell($myrow["md"], "align='center'");
    label_cell($myrow["cd"], "align='center'");
    label_cell($myrow["moisture"], "align='center'");
    label_cell($myrow["per_deckle"], "align='center'");
    end_row();

        $sum_weight+=$myrow["weight"];
        $gsm_avg += $myrow["gsm_average"];
        $bct_avg+=$myrow["bst_average"];
        $sum_md+=$myrow["md"];
        $sum_cd+=$myrow["cd"];
        $sum_moisture+=$myrow["moisture"];
        $sum_ash+=$myrow["per_deckle"];
}

    label_cell("Total",'colspan=5 class="tableheader2" ');
     $sno--;

label_cell(price_format($sum_weight),' align="center" ');
        label_cell(_() ,"colspan=2 ");
        label_cell(price_format($gsm_avg/$sno),' align="center" ');
        label_cell(_() ,"colspan=2 ");
        label_cell(price_format($bct_avg/$sno),' align="center" ');

        label_cell(price_format($sum_md/$sno),' align="center" ');
        label_cell(price_format($sum_cd/$sno) ,' align="center" ');
        label_cell(price_format($sum_moisture/$sno),' align="center" ');
        label_cell(price_format($sum_ash/$sno),' align="center" ');

end_table();



//----------------------------------------------------------------------------------------------------

end_page(true, false, false);

