<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

/**
	Document blueprint use following parameters set in doctext.inc:

	$Addr1,	$Addr2 - address info
	$Payment_Terms - payment terms line
	$Footer - footer texts
	$this->company - company info
	$this->title - report title
	$this->formData - some other info
***/

		$this->row = $this->pageHeight - $this->topMargin;

		$upper = $this->row - 2 * $this->lineHeight;
		$lower = $this->bottomMargin + 12 * $this->lineHeight-50;
		$iline1 = $upper - 7.5 * $this->lineHeight+90;
		$iline2 = $iline1 - 4 * $this->lineHeight;
		$iline3 = $iline2 - 1.5 * $this->lineHeight;
		$iline4 = $iline3 - 1.5 * $this->lineHeight;
		$iline5 = $iline4 - 1 * $this->lineHeight+30;
		$iline6 = $iline5 - 1.5 * $this->lineHeight;
		$iline7 = $lower;
		$right = $this->pageWidth - $this->rightMargin;
		$width = ($right - $this->leftMargin) / 5;
		$icol = $this->pageWidth / 2;
		$ccol = $this->cols[0] + 4;
		$c2col = $ccol + 60;
		$ccol2 = $icol / 2;
		$mcol = $icol + 8;
		$mcol2 = $this->pageWidth - $ccol2;
		$cols = count($this->cols);

   $pre_row=$this->row;
   // 	$header_logo = company_path() . "/images/invoice_header.jpg"; //. $this->company['coy_logo'];
// 		if (file_exists($header_logo))
// 		{
// 			$this->NewLine(4);
// 			$this->AddImage($header_logo, $ccol-230, $this->row-41, 810, 130);
// 		} //$header_logo, $ccol - 50, $this->row + 80, 600, 0



		//$this->SetDrawColor(205, 205, 205);
		// $this->Line($iline1, 3);
		// $this->SetDrawColor(0, 0, 0);
		// $this->Line($iline1);
		 // $this->rectangle($this->leftMargin, $iline2, $right - $this->leftMargin, $iline2 - $iline3, "F", null, array(0, 0, 0));   
		// $this->Line($iline2);
		// $this->Line($iline3);
		// $this->Line($iline4);
		$this->rectangle($this->leftMargin, $iline5, $right - $this->leftMargin, $iline5 - $iline6, "F", null, array(255, 255, 255));   
		$this->Line($iline5);
		$this->Line($iline6);
		$this->Line($iline7);
		$this->Line($iline7+20);
		//$this->LineTo($this->leftMargin, $iline2 ,$this->leftMargin, $iline4);
		$col = $this->leftMargin;
		$this->LineTo($this->leftMargin, $iline5 ,$this->leftMargin, $iline7);
		          for ($i=0; $i < count($this->cols)-1 ; $i++)  if($i>0)
			$this->LineTo($this->cols[$i]-5 , $iline5 ,$this->cols[$i]-5, $iline7);	
			$this->SetDrawColor(195, 195, 195);

		
		// for ($i = 0; $i < 5; $i++)
		// {  	if($i==4)
		// 	$this->SetDrawColor(0, 0, 0);
			// $this->LineTo($col += $width, $iline2,$col, $iline4);
		// }
		$this->SetDrawColor(195, 195, 195);
		// if ($this->l['a_meta_dir'] == 'rtl') // avoid line overwrite in rtl language
		// 	$this->LineTo($this->cols[$cols - 2], $iline5 ,$this->cols[$cols - 2], $iline7);
		// else	
		// 	$this->LineTo($this->cols[$cols - 2] + 4, $iline5 ,$this->cols[$cols - 2] + 4, $iline7);
			$this->SetDrawColor(0, 0, 0);
		$this->LineTo($right, $iline5 ,$right, $iline7);

	// Company Logo
		if(startsWith($this->formData['reference'], "T"))
		$logo = company_path() . "/images/" . $this->company['coy_logo'];
         else 
		$logo = company_path() ."/images/gp-nt.jpg"; 
		if ($this->company['coy_logo'] != '' && file_exists($logo))
		{	
			$this->NewLine(5);
			// $ccol=$ccol-5;
				if(startsWith($this->formData['reference'], "T"))
			      $this->AddImage($logo, $ccol, $this->row, 0, 105);
			  else
			      $this->AddImage($logo, $ccol-30, $this->row, 0, 105);

		}


				// Document title
		$this->row= $pre_row+10;
		$header_logo = company_path() . "/images/sgs.jpeg";	
		if (file_exists($header_logo))
		{

		$this->AddImage($header_logo, $mcol+150, $this->row-50, 40, 40);
		}
		$this->SetTextColor(0, 0, 0);
		$this->fontSize += 5;
		$this->Font('bold');
		$this->TextWrap($mcol+25, $this->row, $this->pageWidth - $this->rightMargin - $mcol - 20, $this->title, 'right');
		$this->Font();
		$this->fontSize -= 5;
		$this->NewLine();
		$this->SetTextColor(0, 0, 0);
		// $this->NewLine();
		// $this->fontSize += 4;
		// $this->Font('bold');
		// $this->Text($ccol, $this->company['coy_name'], $icol);
		// $this->Font();
		// $this->fontSize -= 4;

		$adrline = $this->row;

		// Company data
// 		$this->TextWrapLines($ccol, $icol, $this->company['postal_address']);
// 		$this->Font();
// 			// $this->SetTextColor(255, 255, 255);
			
// // 			print_r($this->company);
// // 			exit();

// 		if (@$this->company['phone'])
// 		{
// 			$this->Text($ccol, _("Supply Chain "), $c2col);
// 			$this->Text($c2col, $this->company['phone'], $mcol);
// 			$this->NewLine();
// 		}
		
// 	    	if (@$this->company['coy_no'])
// 		{
// 			$this->Text($ccol, _("Finance "), $c2col);
// 			$this->Text($c2col, $this->company['coy_no'], $mcol);
// 			$this->NewLine();
// 		}
		
// // 		if (@$this->company['fax'])
// // 		{
// // 			$this->Text($ccol, _("Fax"), $c2col);
// // 			$this->Text($c2col, $this->company['fax'], $mcol);
// // 			$this->NewLine();
// // 		}
// 		if (@$this->company['email'])
// 		{
// 			$this->Text($ccol, _("Email"), $c2col);

// 			$url = "mailto:" . $this->company['email'];
// 			$this->SetTextColor(0, 0, 255);
// 			$this->Text($c2col, $this->company['email'], $mcol);
// 			$this->SetTextColor(0, 0, 0);
// 			$this->addLink($url, $c2col, $this->row, $mcol, $this->row + $this->lineHeight);

// 			$this->NewLine();
// 		}
// 		// display_error($this->formData['tax_group_id'] .'=='. $this->company['gst_no']);
// 		// if ($this->formData['tax_group_id'] == 1) {
// 		// if (@$this->company['gst_no'])
// 		// {
// 		// 	$this->Text($ccol, _("GST No."), $c2col);
// 		// 	$this->Text($c2col, $this->company['gst_no'], $mcol);
// 		// 	$this->NewLine();
// 		// }
// 		// }
// 		if (@$this->formData['domicile'])
// 		{
// 			$this->Text($ccol, _("Domicile"), $c2col);
// 			$this->Text($c2col, $this->company['domicile'], $mcol);
// 			$this->NewLine();
// 		}

// 		$this->NewLine(2);
	
		if ($this->pageNumber > 1)
			$this->Text($mcol + 180, _("Page") . ' ' . $this->pageNumber);
		$this->row = $iline1 - $this->lineHeight;
// 		$this->f+50ontSize -= 1;
	    // $this->Font('bold');
		// $this->Text($ccol, $Addr1['title'], $icol);
		// $this->Text($mcol, $Addr2['title']);
		// $this->Font();
// 		$this->fontSize += 4;

// address1
		$temp = $this->row = $this->row - $this->lineHeight - 5;
	     $this->Font('bold');
		$this->fontSize += 2;
		$this->fontSize += 2;
		$this->Text($ccol, $Addr1['name'], $icol+100);
	     $this->fontSize -= 2;
		$this->Font();
				$this->NewLine();
		$old_row=$this->row;
		$this->TextWrapLines($ccol, $icol - $ccol, ($Addr1['address']) ? trim($Addr1['address']) : 'N/A');
		$new_row = $this->row;
		$this->row=$old_row;
		$this->Font('bold');
		$this->Text($mcol + 70, _("Date"));
		$this->Text($mcol + 120, sql2date($this->formData['document_date']));
		$this->Font();
		$this->row=$new_row;
		
		if($Addr1['tax_id']){
		  $this->Text($ccol, "GST : ".$Addr1['tax_id'], $icol);
		$this->NewLine();
		}
		if($Addr1['ntn_no']){
		  $this->Text($ccol, "NTN : ".$Addr1['ntn_no'], $icol);
		  $this->NewLine();
		}
		if($Addr1['po_no']){
		  $this->Font('bold');
		  $this->fontSize += 1;
		  $this->Text($ccol, "P.O #  : ".$Addr1['po_no'], $icol);
		  $this->fontSize -= 1;
		  $this->Font();

		}
		  $this->Font('bold');
		$this->Text($mcol + 70, $this->formData['document_name']);
		$this->Text($mcol + 120, $this->formData['document_number']);
        $this->Font();
		  $this->NewLine();

				$this->Font();
		// $this->row = $adrline;
		// $this->SetTextColor(0, 0, 0);
		// $this->NewLine(2);
		// $this->fontSize += 2;
		

		// $this->NewLine();
	
	    // $this->fontSize -= 2;
		// $this->SetTextColor(0, 0, 0);
		// display_error($Addr1['tax_id']);


// address2
		$this->row = $temp;
		$this->Text($mcol, $Addr2['name']);
		$this->NewLine();
		$this->TextWrapLines($mcol, $this->rightMargin - $mcol, $Addr2['address'], 'left', 0, 0, NULL, 1);

		// Auxiliary document information
		$col = $this->leftMargin;
		// foreach($aux_info as $info_header => $info_content)
		// {

		// 	$this->SetTextColor(255, 255, 255);
		// 	$this->row = $iline2 - $this->lineHeight - 1;
		// 	$this->TextWrap($col, $this->row, $width, $info_header, 'C');
		// 	$this->SetTextColor(0, 0, 0);
		// 	$this->row = $iline3 - $this->lineHeight - 1;
		// 	$this->TextWrap($col, $this->row, $width, $info_content, 'C');
		// 	$col += $width;
		// }
		// Payment terms
		$this->row -= (3 * $this->lineHeight);
		$this->Font();
		$this->TextWrap($ccol, $this->row, $right-$ccol, $Payment_Terms);
		$this->Font();

		// Line headers
		$this->row = $iline5 - $this->lineHeight - 1;
		$this->Font('bold');
		$count = count($this->headers);
		$this->cols[$count] = $right - 3;
	     $this->SetTextColor(0, 0, 0);
		for ($i = 0; $i < $count; $i++)
			$this->TextCol($i, $i + 1, $this->headers[$i], -2);

// his->=his->-5;
			$this->SetTextColor(0, 0, 0);
		$this->Font();

		// Footer All amounts stated in - PKR
		$this->Font();
		$this->row = $iline7 - $this->lineHeight - 6;

		foreach ($Footer as $line => $txt)
		{
			if (!is_numeric($line))	// title => link
			{
				$this->fontSize -= 2;
				$this->TextWrap($ccol, $this->row, $right - $ccol, $line, 'C');
				$this->row -= $this->lineHeight;
				$this->SetTextColor(0, 0, 255);
				$this->TextWrap($ccol, $this->row, $right - $ccol, $txt, 'C');
				$this->SetTextColor(0, 0, 0);
				$this->addLink($txt, $ccol, $this->row, $this->pageWidth - $this->rightMargin, $this->row + $this->lineHeight);
				$this->fontSize += 2;
			}
			else
				$this->TextWrap($ccol, $this->row, $right - $ccol, $txt, 'C');
			$this->row -= $this->lineHeight;

		}

			// $pre_row=$this->row;
		   	// $header_logo = company_path() . "/images/invoice_line.jpg"; //. $this->company['coy_logo'];
			// 	if (file_exists($header_logo))
			// 	{
			// 		$this->NewLine(4);
			// 		// $this->Line(10, 3);
			// 		$this->AddImage($header_logo, $ccol-230, $this->row-41, 810, 20);
			// 	} //$header_logo, $ccol - 50, $this->row + 80, 600, 0

			//$this->Line(10, 3);
			// $this->row= $pre_row;


		$this->fontSize -= 2;
		$this->Font();
		$temp = $iline6 - $this->lineHeight - 2;
