<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_SALESTRANSVIEW' : 'SA_SALESBULKREP';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Print Invoices
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");

//----------------------------------------------------------------------------------------------------
function get_invoice_range($from, $to)
{
	global $SysPrefs;

	$ref = ($SysPrefs->print_invoice_no() == 1 ? "trans_no" : "reference");

	$sql = "SELECT trans.trans_no, trans.reference
		FROM ".TB_PREF."debtor_trans trans 
			LEFT JOIN ".TB_PREF."voided voided ON trans.type=voided.type AND trans.trans_no=voided.id
		WHERE trans.type=".ST_SALESINVOICE 
			." AND ISNULL(voided.id)"
 			." AND trans.trans_no BETWEEN ".db_escape($from)." AND ".db_escape($to)			
		." ORDER BY trans.tran_date, trans.$ref";

	return db_query($sql, "Cant retrieve invoice range");
}

print_invoices();

function startsWith($string, $startString) { 
  $len = strlen($startString); 
  return (substr($string, 0, $len) === $startString); 
}
//----------------------------------------------------------------------------------------------------

function print_invoices()
{
	global $path_to_root, $SysPrefs;
	
	$kv_batch = get_company_pref('kv_batch');
	$kv_exp_date = get_company_pref('kv_exp_date');
	$show_this_payment = true; // include payments invoiced here in summary

	include_once($path_to_root . "/reporting/includes/pdf_report_inv_tax.inc");

	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
	$currency = $_POST['PARAM_2'];
	$email = $_POST['PARAM_3'];
	$pay_service = $_POST['PARAM_4'];
	$comments = $_POST['PARAM_5'];
	$customer = $_POST['PARAM_6'];
	$orientation = $_POST['PARAM_7'];

	if (!$from || !$to) return;

	$orientation = ($orientation ? 'L' : 'P');
	$dec = user_price_dec();

 	$fno = explode("-", $from);
	$tno = explode("-", $to);
	$from = min($fno[0], $tno[0]);
	$to = max($fno[0], $tno[0]);

	//-------------code-Descr-Qty--uom--tax--prc--Disc-Tot--//
	// //array(_("Item Code"), _("Item Description"), _("Quantity"), _("Unit"), _("Batch No"), _("Exp Date"), '', _("Price"), _("Discount %"), _("Total"));
	// if($kv_batch || $kv_exp_date)
	// 	$cols = array(4, 50, 205, 280, 305, 365, 405, 455, 495, 525);
	// else

	$cols = array(4, 30, 90, 270, 325, 365, 430,495, 515);

	// $headers in doctext.inc
	// if($kv_batch || $kv_exp_date)
	// 	$aligns = array('left',	'left',	'right', 'center', 'left', 'center',  'right', 'right', 'right');
	// else
	$aligns = array('center',	'center',	'center', 'center', 'center', 'center', 'center', 'center');

	$params = array('comments' => $comments);

	$cur = get_company_Pref('curr_default');

	if ($email == 0)
		$rep = new FrontReport(_('INVOICE'), "SalesTaxInvoice", user_pagesize(), 8, $orientation);
	if ($orientation == 'L')
		recalculate_cols($cols);

	$range = get_invoice_range($from, $to);
	while($row = db_fetch($range))
	{
			if (!exists_customer_trans(ST_SALESINVOICE, $row['trans_no']))
				continue;
			$sign = 1;
			$myrow = get_customer_trans($row['trans_no'], ST_SALESINVOICE);

			if ($customer && $myrow['debtor_no'] != $customer) {
				continue;
			}
			if ($currency != ALL_TEXT && $myrow['curr_code'] != $currency) {
				continue;
			}
			$baccount = get_default_bank_account($myrow['curr_code']);
			$params['bankaccount'] = $baccount['id'];

			$branch = get_branch($myrow["branch_code"]);
			$sales_order = get_sales_order_header($myrow["order_"], ST_SALESORDER);
			if ($email == 1)
			{
				$rep = new FrontReport("", "", user_pagesize(), 9, $orientation);
				$rep->title = _('INVOICE');
				$rep->filename = "Invoice" . $myrow['reference'] . ".pdf";
			}	
			$rep->currency = $cur;
			$rep->Font('');
			$rep->Info($params, $cols, null, $aligns);

			$contacts = get_branch_contacts($branch['branch_code'], 'invoice', $branch['debtor_no'], true);
			$baccount['payment_service'] = $pay_service;
			$rep->SetCommonData($myrow, $branch, $sales_order, $baccount, ST_SALESINVOICE, $contacts);
			$rep->SetHeaderType('Header2');
			$rep->NewPage();
			// calculate summary start row for later use
			$summary_start_row = $rep->bottomMargin + (15 * $rep->lineHeight);

			if ($rep->formData['prepaid'])
			{
				$result = get_sales_order_invoices($myrow['order_']);
				$prepayments = array();
				while($inv = db_fetch($result))
				{
					$prepayments[] = $inv;
					if ($inv['trans_no'] == $row['trans_no'])
					break;
				}

				if (count($prepayments) > ($show_this_payment ? 0 : 1))
					$summary_start_row += (count($prepayments)) * $rep->lineHeight;
				else
					unset($prepayments);
			}

   			$result = get_customer_trans_details(ST_SALESINVOICE, $row['trans_no']);
			$SubTotal = 0;
			$newrow=array();
			$s_no = 1;
			while ($myrow2=db_fetch($result))
			{
				// print_r($myrow2); exit();
				if ($myrow2["quantity"] == 0)
					continue;

				$Net = round2($sign * ((1 - $myrow2["discount_percent"]) * $myrow2["unit_price"] * $myrow2["quantity"]),
				   user_price_dec());
				$SubTotal += $Net;
	    		$DisplayPrice = number_format2($myrow2["unit_price"],$dec);
	    		$DisplayQty = number_format2($sign*$myrow2["quantity"],get_qty_dec($myrow2['stock_id']));
	    		$DisplayNet = number_format2($Net+($myrow2['unit_tax']*$myrow2["quantity"]),$dec);
	    		if ($myrow2["discount_percent"]==0)
		  			$DisplayDiscount ="";
	    		else
		  			$DisplayDiscount = number_format2($myrow2["discount_percent"]*100,user_percent_dec()) . "%";
				$c=0;
				$delivery_ref = get_src_id_debtor_trans_details($myrow2['src_id']); 
				$oldrow = $rep->row;
				$rep->TextCol($c++, $c,	$s_no++, -2);
				// $rep->TextCol($c++, $c,	$DisplayQty." \n ".$myrow2['units'], -2);
				$newrow[] = $rep->row;
				$rep->row = $oldrow;
				// $rep->TextCol($c++, $c,	$myrow2['stock_id'], -2);
				$oldrow = $rep->row;
				$rep->TextCol($c++, $c,	$delivery_ref['reference'], -2);
				// $rep->TextColLines($c++, $c, $myrow2['StockDescription'], -2);
				$newrow[] = $rep->row;
				$rep->row = $oldrow;
				if ($Net != 0.0 || !is_service($myrow2['mb_flag']) || !$SysPrefs->no_zero_lines_amount())
				{  
				  $oldrow = $rep->row;
				  $rep->TextColLines($c++, $c, " ".$myrow2['StockLongDescription'], -2);
				  // $rep->TextColLines($c++, $c,	$DisplayPrice." \n Per ".$myrow2['units'], -2);
				  $newrow[] = $rep->row;
				  $rep->row = $oldrow;
				  $rep->TextCol($c++, $c,	number_format2($myrow2['quantity'],$dec), -2);

					// $rep->TextCol($c++, $c,	number_format2($myrow2['unit_price']*$myrow2['quantity'],$dec), -2);
					// display_error($myrow2['unit_tax']."/".$myrow2["unit_price"]." * 100");exit();

					$rep->TextCol($c++, $c,	number_format2($myrow2["unit_price"],$dec), -2);

					// $rep->TextCol($c++, $c,	number_format2(($myrow2['unit_tax']/$myrow2["unit_price"])*100,$dec)." %", -2);

					$rep->TextCol($c++, $c,	number_format2($myrow2['unit_price']*$myrow2['quantity'],$dec), -2);

					$rep->TextCol($c++, $c,	number_format2($myrow2['unit_tax']*$myrow2['quantity'],$dec), -2);

					// if($kv_exp_date) {
					// 	$rep->TextCol($c++, $c,	$myrow2['batch_no'], -2);
					// 	//$rep->TextCol($c++, $c,	'', -2);
					// 	$rep->TextCol($c++, $c,	sql2date($myrow2['exp_date']), -2);
					// 	//$rep->TextCol($c++, $c,	'', -2);
					// }elseif($kv_batch) {
					// 	// display_error($myrow2['batch_no']);exit();
					// 	$rep->TextCol($c++, $c,	$myrow2['batch_no'], -2);
					// 	// $rep->TextCol($c++, $c,	'', -2);
					// }
					$incl_sale_tax = ($myrow2['unit_price']*$myrow2['quantity'])+($myrow2['unit_tax']*$myrow2['quantity']);
					// $rep->TextCol($c++, $c,	number_format(0,2), -2);
					$rep->TextCol($c++, $c,	number_format2($incl_sale_tax), -2);
				}
				$rep->row = min($newrow);
				unset($newrow);
				$rep->NewLine(1);
				if ($rep->row < $summary_start_row)
					$rep->NewPage();
			  if($myrow2["unit_price"])
				$qty_total += $myrow2['quantity'];
				$total_rate += $myrow2["unit_price"];
				$total_exclu_sale_tax += $myrow2['unit_price']*$myrow2['quantity'];   
				$total_sales_tax += $myrow2['unit_tax']*$myrow2['quantity'];
				$total_inclu_sale_tax += $incl_sale_tax;
			}


            // $save_row = $rep->row;
            // $rep->row=890;
			// $memo = get_comments_string(ST_SALESINVOICE, $row['trans_no']);
			// if ($memo != "")
			// {
			// 	$rep->NewLine();
			// 	$rep->TextColLines(0, 1, $memo, -2);
			// }

   			// $DisplaySubTot = number_format2($SubTotal,$dec);
            
			// set to start of summary line:
    		// $rep->row = $summary_start_row;
			// if (isset($prepayments))
			// {
			// 	// Partial invoices table
			// 	$rep->TextCol(0, 3,_("Prepayments invoiced to this order up to day:"));
			// 	$rep->TextCol(0, 3,	str_pad('', 150, '_'));
			// 	$rep->cols[2] -= 20;
			// 	$rep->aligns[2] = 'right';
			// 	$rep->NewLine(); $c = 0; $tot_pym=0;
			// 	$rep->TextCol(0, 3,	str_pad('', 150, '_'));
			// 	$rep->TextCol($c++, $c, _("Date"));
			// 	$rep->TextCol($c++, $c,	_("Invoice reference"));
			// 	$rep->TextCol($c++, $c,	_("Amount"));

			// 	foreach ($prepayments as $invoice)
			// 	{
			// 		if ($show_this_payment || ($invoice['reference'] != $myrow['reference']))
			// 		{
			// 			$rep->NewLine();
			// 			$c = 0; $tot_pym += $invoice['prep_amount'];
			// 			$rep->TextCol($c++, $c,	sql2date($invoice['tran_date']));
			// 			$rep->TextCol($c++, $c,	$invoice['reference']);
			// 			$rep->TextCol($c++, $c, number_format2($invoice['prep_amount'], $dec));
			// 		}
			// 		if ($invoice['reference']==$myrow['reference']) break;
			// 	}
			// 	$rep->TextCol(0, 3,	str_pad('', 150, '_'));
			// 	$rep->NewLine();
			// 	$rep->TextCol(1, 2,	_("Total payments:"));
			// 	$rep->TextCol(2, 3,	number_format2($tot_pym, $dec));
			// }


			// $doctype = ST_SALESINVOICE;
    		// $rep->row = $summary_start_row-55;
			// $rep->cols[2] += 20;
			// $rep->cols[3] += 20;
			// $rep->aligns[3] = 'left';
			// if($kv_exp_date || $kv_batch) {
			// 	$rep->TextCol(3, 6, _("Sub-total"), -2);
			// 	$rep->TextCol(7, 8,	$DisplaySubTot, -2);
			// }  else {
			// 	$rep->TextCol(3, 6, _("Sub-total"), -2);
			// 	$rep->TextCol(6, 7,	$DisplaySubTot, -2);
			// }
		// 	$rep->NewLine(2);
		// 	if ($myrow['ov_freight'] != 0.0)
		// 	{
   		// 		$DisplayFreight = number_format2($sign*$myrow["ov_freight"],$dec);
		// 		if($kv_exp_date || $kv_batch) {
		// 			$rep->TextCol(3, 8, _("Shipping"), -2);
		// 			$rep->TextCol(7, 8,	$DisplayFreight, -2);
		// 		} else { 
		// 			$rep->TextCol(3, 6, _("Shipping"), -2);
		// 			$rep->TextCol(6, 7,	$DisplayFreight, -2);
		// 		}
		// 		$rep->NewLine();
		// 	}	
		// 	$tax_items = get_trans_tax_details(ST_SALESINVOICE, $row['trans_no']);
		// 	$first = true;
    	// 	while ($tax_item = db_fetch($tax_items))
    	// 	{ 	
    	// 		// tax create here

    	// 		// if ($tax_item['amount'] == 0)
    	// 		// 	continue;
    	// 		// $DisplayTax = number_format2($sign*$tax_item['amount'], $dec);

    	// 		// if ($SysPrefs->suppress_tax_rates() == 1)
    	// 		// 	$tax_type_name = $tax_item['tax_type_name'];
    	// 		// else
    	// 		// 	$tax_type_name = $tax_item['tax_type_name']." (".$tax_item['rate']."%) ";

    	// 		if ($myrow['tax_included'])
    	// 		{
    	// 			if ($SysPrefs->alternative_tax_include_on_docs() == 1)
    	// 			{
    	// 				if ($first)
    	// 				{
		// 					$rep->TextCol(3, 6, _("Total Tax Excluded"), -2);
		// 					$rep->TextCol(6, 7,	number_format2($sign*$tax_item['net_amount'], $dec), -2);
		// 					$rep->NewLine();
    	// 				}
		// 				if($kv_exp_date || $kv_batch) {
		// 					$rep->TextCol(3, 8, $tax_type_name, -2);
		// 					$rep->TextCol(8, 9,	$DisplayTax, -2);
		// 				} else {
		// 					// $rep->TextCol(3, 6, $tax_type_name, -2);
		// 					$rep->TextCol(6,7,	$DisplayTax, -2);
		// 				}
		// 				$first = false;
    	// 			}
    	// 			else
		// 				$rep->TextCol(3, 7, _("Included") . " " . $tax_type_name . _("Amount") . ": " . $DisplayTax, -2);
		// 		}
    	// 		// else
    	// 		// {
		// 		// 	if($kv_exp_date || $kv_batch){
		// 		// 		$rep->TextCol(6, 7, $tax_type_name, -2);
		// 		// 		$rep->TextCol(8, 9,	$DisplayTax, -2);
		// 		// 	} else {
		// 		// 		// $rep->TextCol(3, 6, $tax_type_name, -2);
		// 		// 		$rep->TextCol(5, 6,	$DisplayTax, -2);
		// 		// 	}
		// 		// }
		// 		// $rep->NewLine();
    	// 	}

    	// 	// $rep->NewLine();
		// 	$DisplayTotal = number_format2($sign*($myrow["ov_freight"] + $myrow["ov_gst"] +
		// 		$myrow["ov_amount"]+$myrow["ov_freight_tax"]),$dec);
		// 	$rep->Font('bold');
		// 	if($kv_exp_date || $kv_batch) {
		// 		if (!$myrow['prepaid']) $rep->Font('bold');
		// 			$rep->TextCol(1, 3, $rep->formData['prepaid'] ? _("TOTAL ORDER VAT INCL.") : _("TOTAL"), - 2); // INVOICE
		// 		$rep->TextCol(8, 9, $DisplayTotal, -2);
		// 	} else {
		// 		  $rep->aligns[4]='left';
		// 		if (!$myrow['prepaid']) $rep->Font('bold');
		// 			$rep->TextCol(1, 2, $rep->formData['prepaid'] ? _("TOTAL ORDER VAT INCL.") : _("TOTAL INVOICE"), - 2);
		// 		$rep->TextCol(7, 8, $DisplayTotal, -2);
		// 	}
		// 	if ($rep->formData['prepaid'])
		// 	{
		// 		$rep->NewLine();
		// 		$rep->Font('bold');
		// 		if($kv_exp_date || $kv_batch) {
		// 			$rep->TextCol(3, 8, $rep->formData['prepaid']=='final' ? _("THIS INVOICE") : _("TOTAL INVOICE"), - 2);
		// 			$rep->TextCol(8, 9, number_format2($myrow['prep_amount'], $dec), -2);
		// 		} else {
		// 			$rep->TextCol(1, 2, $rep->formData['prepaid']=='final' ? _("THIS INVOICE") : _("TOTAL INVOICE"), - 2);
		// 			$rep->TextCol(6, 7, number_format2($myrow['prep_amount'], $dec), -2);
		// 		}
		// 	}

		$rep->fontSize += 1;
		$rep->Font('B');
		$rep->TextWrap(200,130,500, _("Total "));
		$rep->fontSize -= 1;
		$rep->Font();
    
    $temp_row = $rep->row;
    $rep->row=130;
		$rep->Font('B');
  	$rep->TextCol(3, 4,number_format2($qty_total), -2);
		// $rep->TextWrap(340,132,500, number_format2($qty_total));
		$rep->Font();

		$rep->Font('B');
		// $rep->TextWrap(390,132,500, number_format2($total_rate));
		  	$rep->TextCol(4, 5,number_format2($total_rate), -2);
		$rep->Font();

		$rep->Font('B');
		$rep->TextCol(5, 6, number_format2($total_exclu_sale_tax), -2);
		// $rep->TextWrap(440,132,500, number_format2($total_exclu_sale_tax));
		$rep->Font();

		$rep->Font('B');
		$rep->TextCol(6, 7, number_format2($total_sales_tax), -2);
		
		// $rep->TextWrap(490,132,500, number_format2($total_sales_tax));
		$rep->Font();

		$rep->Font('B');
		$rep->TextCol(7, 8, number_format2($total_inclu_sale_tax), -2);
		
		$rep->row=$temp_row;
		// $rep->TextWrap(540,132,500, number_format2($total_inclu_sale_tax));
		$rep->Font();

		$words = price_in_words($rep->formData['prepaid'] ? $myrow['prep_amount'] : round($myrow['Total'])
				, ST_SALESINVOICE); //, array( 'type' => ST_SALESINVOICE, 'currency' => $myrow['curr_code'])
				
		// 	// 		if ($sales_order["customer_ref"] != "")
		// 	// {
		// 	// 	$rep->NewLine(6);
		// 	// 	$rep->TextColLines(0, 3, " PO # / LC #  : ".$sales_order["customer_ref"], -2);
		// 	// }
		// 	$del_no = get_sales_parent_numbers(ST_SALESINVOICE, $row['trans_no']);
           // // print_r($del_no);
           // // display_error($del_no[0]." sd");exit();
           // $del_row = get_customer_trans($del_no[0], ST_CUSTDELIVERY);

           // if ($del_row["del_truck_no"] != "")
		// 	{
		// 		$rep->NewLine();
		// 		$rep->TextColLines(0, 3, "".$del_row["del_truck_no"], -2);
		// 	}
			if ($words != "")
			{
				$mcol=30;
				$rep->fontSize += 1;
				$rep->TextWrap($mcol, 110, $right-$mcol, "Amount in Words : ");
				$rep->fontSize -= 1;
				$rep->Font();
				$rep->TextWrap($mcol, 95, $right-$mcol,   $words);		

                // $mcol=480;
        		// $rep->Font('italic','times');
                // $rep->fontSize += 2;
				// $rep->TextWrap($mcol, 50, $right-$mcol, " Prime Pakages");
				// $rep->fontSize -= 2;
				// // $rep->NewLine(2);
				// 			$rep->Font();


				// if($kv_exp_date || $kv_batch)
				// 	$rep->TextCol(1, 9, $myrow['curr_code'] . ": " . $words, - 2);
				// else
				// 	$rep->TextCol(1, 7, $myrow['curr_code'] . ": " . $words, - 2);
			}

			  $rep->TextWrap(30,32,150,"_______________________________"); 
		    $rep->TextWrap(70,20,150, _("Prepared By")); 

		    $rep->TextWrap(250,32,150,"______________________________"); 
		    $rep->TextWrap(290,20,150, _("Received By")); 

		    $rep->TextWrap(455,32,150,"______________________________"); 
		    $rep->TextWrap(475,20,150, _("Grace Packages (Pvt) Ltd")); 

        $rep->TextWrap(30,5,500, $rep->company['legal_text'] );  
			// if(startsWith($myrow['reference'], "T"))
			// $header_logo = company_path() . "/images/t-stamp.jpeg"; 
			// else 
			$header_logo = company_path() . "/images/tax-sale-invoice.jpeg";	

			if (file_exists($header_logo))
			{
			// $rep->NewLine(4);
			$rep->AddImage($header_logo, 478, 32, 80, 80);
			} 

			// $header_logo = company_path() . "/images/fsc.jpeg";	
			// if (file_exists($header_logo))
			// {
			// $rep->AddImage($header_logo, 440, 710, 70, 70);
			// } 

			$header_logo = company_path() . "/images/sgs.jpeg";	
			if (file_exists($header_logo))
			{
			$rep->AddImage($header_logo, 520, 710, 70, 70);
			} 

			//  $mcol=450;
		    //  $rep->Font('bold','pdfacourieri');
            //     $rep->fontSize += 2;
			// 	$rep->TextWrap($mcol, 40, $right-$mcol, "_____________________________________");
			// 	$rep->TextWrap($mcol+40, 25, $right-$mcol, "Signature");

			// 	$rep->fontSize -= 2;
			// $rep->Font();
			if ($email == 1)
			{
				$rep->End($email);
			}
	}
	if ($email == 0)
		$rep->End();
}

