<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
    Released under the terms of the GNU General Public License, GPL, 
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
    'SA_REP_PRINT_SALES_QUOTATION' : 'SA_REP_PRINT_SALES_QUOTATION';
// ----------------------------------------------------------------
// $ Revision:  2.0 $
// Creator: Joe Hunt
// date_:   2005-05-19
// Title:   Print Sales Quotations
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/taxes/tax_calc.inc");

//----------------------------------------------------------------------------------------------------

print_sales_quotations();
function print_sales_quotations()
{
    global $path_to_root, $SysPrefs;

    include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $data = $_POST['PARAM_0'];
    $to = $_POST['PARAM_1'];
    $currency = $_POST['PARAM_2'];
    $email = $_POST['PARAM_3'];
    $comments = $_POST['PARAM_4'];
    $orientation = $_POST['PARAM_5'];

    $set_date = explode(',', $data);
    $orientation = ($orientation ? 'L' : 'P');
    $dec = user_price_dec();

    $cols = array(0, 120, 225, 300, 325, 385, 450, 515);
    $aligns = array('center', 'center', 'right', 'left', 'right', 'right', 'right');
    $params = array('comments' => $comments);

    $margins = array(
        'left' => 10,
        'top' => 15,
        'right' => 0,
        'bottom' => 15
    );

    // Page size in mm (6x4 inches)
    $pageWidth = 152.4; // 6 inches
    $pageHeight = 101.6; // 4 inches

    // Initialize the report with custom page size
    $rep = new FrontReport(_('Barcode'), "Barcode", array($pageWidth, $pageHeight), 9, $orientation, $margins);
    
    if ($orientation == 'L') {
        recalculate_cols($cols);
    }

        $rep->Info($params, $cols, null, $aligns);
    // Add logo
    $logo = company_path() . "/images/bc.jpeg";
    $rep->NewPage();
    if($set_date[3])
    $rep->AddImage($logo, 0, 0, 150, 100);
     
    // $logo = company_path() . "/images/box.jpg";
        // $rep->row+=;
    // $rep->AddImage($logo, 0, 12, 125, 20);


    // Set barcode data
    $barcode = $set_date[0]; // Use the first part of the date

    // Define barcode style
    $style = array(
        'position' => 'S',
        'stretch' => false,
        // 'width' => 60,
        'fitwidth' => true,
        'cellfitalign' => '',
        'border' => false,
        'padding' => 1,
        'fgcolor' => array(0, 0, 0),
        'bgcolor' => false,
        'text' => false,
        'font' => 'helvetica',
        'fontsize' => 6,
        'stretchtext' => 4
    );

    // Calculate Y position for the barcode
    $bar_y = 52; // Adjust this value for vertical position

    // Write the barcode to the PDF
    
    $rep->write1DBarcode($set_date[1], 'C128A', 20, $bar_y, 80, 15, 1, $style, 'N');


    $item_row = get_item($set_date[1]);
     $rep->Font('b');
    // $rep->TextWrap(0, 65, 100, , 'C');

    $rep->row=65;

// display_error(strlen($item_row['description']));exit();
if(strlen($item_row['description'])<=15)
   {

    // echo strlen($item_row['description']); exit();
      $rep->fontSize = 12;
      $rep->row-=5;
   } 
  else if(strlen($item_row['description'])>=30)
  {
      $rep->fontSize = 7;
      // $rep->row-=1; 

  }
 else{

    $rep->fontSize = 9;
      // $rep->row-=2; 
 }
    
    
    



    $oldrow = $rep->row;
    $rep->TextColLines(0, 1, strtoupper(html_entity_decode($item_row['description']) ));
    $newrow = $rep->row;

    // $rep->row = $oldrow;
    $rep->fontSize = 5;
    $rep->Font('B');
    $rep->TextWrap(105, 37, 125, $set_date[1], 'L'); //$set_date[1]
    $rep->Font();
    $rep->fontSize = 3;
    // display_error($rep->fontSize);exit();
    $rep->TextWrap(10, 20, 125, "BATCH NO : ".$barcode, 'L'); //$set_date[1]
    $dec = get_qty_dec($set_date[1]);
 $rep->TextWrap(75, 20, 125, " NET : ".$set_date[2], 'L');

    // Your report content generation code goes here

    $rep->End();
}

