<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = $_POST['PARAM_0'] == $_POST['PARAM_1'] ?
	'SA_REP_PRINT_SALES_QUOTATION' : 'SA_REP_PRINT_SALES_QUOTATION';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Print Sales Quotations
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/taxes/tax_calc.inc");

//----------------------------------------------------------------------------------------------------

print_sales_quotations();
function print_sales_quotations()
{
    global $path_to_root, $SysPrefs;

    include_once($path_to_root . "/reporting/includes/pdf_report.inc");

    $data = $_POST['PARAM_0'];
    $to = $_POST['PARAM_1'];
    $currency = $_POST['PARAM_2'];
    $email = $_POST['PARAM_3'];
    $comments = $_POST['PARAM_4'];
    $orientation = $_POST['PARAM_5'];

    $set_date = explode(',', $data);
    $orientation = ($orientation ? 'L' : 'P');
    $dec = user_price_dec();

    $cols = array(0, 101.6, 225, 300, 325, 385, 450, 515);
    $aligns = array('center', 'left', 'right', 'left', 'right', 'right', 'right');
    $params = array('comments' => $comments);

    $margins = array(
        'left' => 0,
        'top' => 0,
        'right' => 0,
        'bottom' => 0
    );

    // Page size in mm (4x2 inches)
    $pageWidth = 101.6; // 4 inches
    $pageHeight = 50.8; // 2 inches

    // Initialize the report with custom page size
    $rep = new FrontReport(_('Barcode 4 by 2 Inch'), "Barcode4x2Inch", array($pageWidth, $pageHeight), 5, $orientation, $margins);
    
    if ($orientation == 'L') {
        recalculate_cols($cols);
    }


    


    $rep->Info($params, $cols, null, $aligns);
    // Add logo
    $logo = company_path() . "/images/bc.jpeg";
    $rep->NewPage();
    // $rep->AddImage($logo, 0, 0, 150, 100);

    // Set barcode data
    $barcode = $set_date[0]; // Use the first part of the date

    // Define barcode style
    $style = array(
        'position' => 'S',
        'stretch' => false,
        // 'width' => 60,
        'fitwidth' => true,
        'cellfitalign' => '',
        'border' => false,
        'padding' => 1,
        'fgcolor' => array(0, 0, 0),
        'bgcolor' => false,
        'text' => false,
        'font' => 'helvetica',
        'fontsize' => 6,
        'stretchtext' => 4
    );
    // Calculate Y position for the barcode
    $bar_y = 20; // Adjust this value for vertical position

    // Write the barcode to the PDF
    $rep->write1DBarcode($barcode, 'C128A', 5, $bar_y, 90, 20, 1, $style, 'N');


	$item_row = get_item($set_date[1]);

    $rep->row=93;

        if(strlen($item_row['description'])<=20)
    {

     $rep->fontSize = 8;
     $rep->row-=5;
    } 
    else
     $rep->fontSize = 5;
    // $rep->fontSize -= 1;
    $rep->Font('bu');

    $rep->lineHeight=7;
    // $rep->TextWrap(1, 20, 100, trim($item_row['description']) , 'C');
    $oldrow = $rep->row;
    $rep->TextColLines(0, 1, strtoupper(trim(html_entity_decode($item_row['description']) )) );
    $newrow = $rep->row;
    $rep->Font();
         $rep->fontSize = 5;
    $rep->TextWrap(5,3, 101, $barcode , 'L');//$set_date[1]
    $dec = get_qty_dec($set_date[1]);
       $rep->Font('B');
        $rep->TextWrap(45, 3, 101, $set_date[1] , 'L');//$set_date[1]
           $rep->Font();
    $rep->TextWrap(75, 3, 101, $set_date[2], 'L'); //$item_row['units']
    // $rep->fontSize += 2;
    
    // Your report content generation code goes here

    $rep->End();
}

