<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_REP_OUTSTANDING_PO_REEL_REPORT';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Outstanding GRNs Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/inventory/includes/db/gsm_db.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");

//----------------------------------------------------------------------------------------------------


print_outstanding_GRN();

function getTransactions($fromsupp, $from, $to)
{
	$from = date2sql($from);
	$to = date2sql($to);

	$sql = "SELECT po.order_no,
			po.supplier_id,
			supplier.supp_name,
			poline.description,
			poline.gsm_id,
			poline.item_code,
			poline.size_id,
			po.is_reel,
			po.ord_date,
			poline.unit_price,
			SUM(CASE WHEN poline.quantity_ordered>1  THEN poline.quantity_ordered ELSE 0 END) AS quantity_ordered,
			poline.delivery_date,
		SUM(CASE WHEN poline.quantity_ordered>0  THEN 1 ELSE 0 END) AS 
		all_reel ,
		SUM(CASE WHEN poline.quantity_ordered>1  THEN 1 ELSE 0 END) AS 
		rec_reel
		FROM ".TB_PREF."purch_orders po,
			".TB_PREF."purch_order_details poline,
			".TB_PREF."suppliers supplier
		WHERE po.supplier_id=supplier.supplier_id
		 AND po.order_no = poline.order_no
		 AND po.ord_date >= '$from' AND po.ord_date <= '$to'
		AND poline.quantity_ordered-poline.quantity_received!=0 
		 AND po.is_reel=1";
		 // display_error($sql);
	if ($fromsupp != ALL_TEXT)
		$sql .= " AND po.supplier_id =".db_escape($fromsupp);

	$sql .= " GROUP BY po.order_no, poline.item_code, poline.gsm_id, 				 poline.size_id";
		
     $sql .= " ORDER BY po.supplier_id, po.order_no, poline.item_code, 
			 poline.gsm_id, poline.size_id";
	// display_error($sql);
			 // $sql .= " AND poline.delivery_date < '$to'";

    return db_query($sql, "No transactions were returned");
}

function get_order_all_reels($fromsupp, $order_no,$gsm_id,$size_id)
{
	

	$sql = "SELECT 
		SUM(CASE WHEN poline.quantity_ordered>0  THEN 1 ELSE 0 END) AS 
		all_reel ,
		SUM(CASE WHEN poline.quantity_ordered>1  THEN 1 ELSE 0 END) AS 
		rec_reel
		FROM ".TB_PREF."purch_orders po,
			".TB_PREF."purch_order_details poline,
			".TB_PREF."suppliers supplier
		WHERE po.supplier_id=supplier.supplier_id
		 AND po.order_no = poline.order_no
		 AND po.order_no='$order_no' AND poline.gsm_id='$gsm_id'  
		 AND poline.size_id='$size_id'
		 AND po.is_reel=1";
		 // display_error($sql);
	if ($fromsupp != ALL_TEXT)
		$sql .= " AND po.supplier_id =".db_escape($fromsupp);

	$sql .= " GROUP BY po.order_no, poline.item_code, poline.gsm_id, 	 poline.size_id";
		
     $sql .= " ORDER BY po.supplier_id, po.order_no, poline.item_code, 
			 poline.gsm_id, poline.size_id";
	// display_error($sql);
			 // $sql .= " AND poline.delivery_date < '$to'";

    return db_fetch(db_query($sql, "No transactions were returned"));
}


//----------------------------------------------------------------------------------------------------

function print_outstanding_GRN()
{
    global $path_to_root;
	$from = $_POST['PARAM_0'];
	$to = $_POST['PARAM_1'];
    $fromsupp = $_POST['PARAM_2'];
    $comments = $_POST['PARAM_3'];
	$orientation = $_POST['PARAM_4'];
	$destination = $_POST['PARAM_5'];
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = ($orientation ? 'L' : 'P');
	if ($fromsupp == ALL_TEXT)
		$fromsupp_name = _('All');
	else
		$fromsupp_name = get_supplier_name($fromsupp);
    $dec = user_price_dec();

	$cols = array(0, 50, 130, 190, 220, 300, 330, 370, 440, 480, 520, 560, 600);

$headers = array(_('Order NO'), _('Order Date'), _('Req Date'), _('I. Desc'), _('Size'), _('GSM'), _('Order reel'), _('Receive reel'), _('Rate'), _('weight'), _('Total'));

	$aligns = array('center',	'center',	'center',	'center',	'center', 'center', 'center', 'center', 'center', 'center', 'center');

    $params =   array( 	0 => $comments,
    				    1 => array('text' => _('Supplier'), 'from' => $fromsupp_name, 'to' => ''));

    $rep = new FrontReport(_('Outstanding PO Reel Report'), "OutstandingGRN", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();

	$Tot_Val=0;
	$Supplier = '';
	$SuppTot_Val=0;
	$res = getTransactions($fromsupp, $from, $to);
	// display_error($from);
	While ($GRNs = db_fetch($res))
	{
		// print_r($GRNs);
		$dec2 = get_qty_dec($GRNs['item_code']);
		if ($Supplier != $GRNs['supplier_id'])
		{
			if ($Supplier != '')
			{
				$rep->NewLine(2);
				//$rep->TextCol(0, 1, _('Total'));
				//$rep->AmountCol(7, 8, $SuppTot_Val, $dec);
				$rep->Line($rep->row - 2);
				$rep->NewLine(3);
				// $SuppTot_Val = 0;
			}
					$rep->Font('bold');
			$rep->TextCol(0, 3, $GRNs['supp_name']);
				$rep->Font();
			$Supplier = $GRNs['supplier_id'];
		}
		$rep->NewLine();
		$rep->TextCol(0, 1, $GRNs['order_no']);
		$rep->TextCol(1, 2, $GRNs['ord_date']);
		$rep->TextCol(2, 3, $GRNs['delivery_date']);

		$rep->TextCol(3, 4, $GRNs['description']);
		$g_row=get_order_all_reels($GRNs['supplier_id'],  $GRNs['order_no'],$GRNs['gsm_id'],$GRNs['size_id']);
		$rep->TextCol(4, 5, get_size_name($GRNs['size_id']));// . '-' . $GRNs['description']
		$rep->TextCol(5, 6,  get_gsm_name($GRNs['gsm_id']));
		$rep->AmountCol(6, 7, $g_row['all_reel']);
		$rep->AmountCol(7, 8, $g_row['rec_reel']);
		$rep->AmountCol(8, 9, $GRNs['unit_price']);
		$rep->AmountCol(9, 10, $GRNs['quantity_ordered']);
		$rep->AmountCol(10, 11, $GRNs['unit_price'] * $GRNs['quantity_ordered']);

	}
	
    $rep->End();
}

