<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_REP_REEL_QC_STOCK_REPORT';
// ----------------------------------------------------------------
// $ Revision:	2.0 $
// Creator:	Joe Hunt
// date_:	2005-05-19
// Title:	Sales Summary Report
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/inventory/includes/db/gsm_db.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");
// include_once($path_to_root . "/dimensions/includes/project_timeline_alloc_db.inc");

//------------------------------------------------------------------

print_sales_summary_report();

function getTransactions($form, $to, $item_code='',$gsm_id='', $size_id='',$batch_no=''){
	
	$from_date = date2sql($form);
	$to_date = date2sql($to);

	$sql="SELECT * FROM ".TB_PREF."stock_moves as sm, ".TB_PREF."grn_items as gi WHERE sm.size_id > 0 AND sm.tran_date >= '$from_date' AND sm.tran_date <= '$to_date'" ." AND sm.batch_no=gi.batch_no";
	if($item_code != '')
	$sql .= "  AND sm.stock_id=".db_escape($item_code);
if($gsm_id != '')
	$sql .= "  AND sm.gsm_id=".db_escape($gsm_id);
if($size_id != '')
	$sql .= "  AND sm.size_id=".db_escape($size_id);

if($batch_no != '')
	$sql .= "  AND sm.batch_no LIKE ".db_escape('%'. $order_number . '%');


	$sql .=  " GROUP BY sm.batch_no";
	$sql.= " ORDER BY sm.size_id ,sm.gsm_id ASC";
	$result = db_query($sql);
	// display_error($sql." == ".$gsm_id."  == ".$size_id);
	return $result;
}

function get_batch_qty($batch_no,$stock_id,$loc_code=''){

	$sql0=" SELECT IFNULL(SUM(qty),0) AS Stock FROM ".TB_PREF."stock_moves WHERE batch_no=".db_escape($batch_no)." AND stock_id=".db_escape($stock_id); 

	   if($loc_code != 'all')
		$sql0 .= " AND loc_code=".db_escape($loc_code);

// display_error($sql0);

	$res = db_query($sql0, "can't execute the query");
	$row_res = db_fetch($res);
	return $row_res;
}

//----------------------------------------------------------------------------------------------------

function print_sales_summary_report()
{
	global $path_to_root;
    $form = $_POST['PARAM_0'];
    $to = $_POST['PARAM_1'];
	$item_code = $_POST['PARAM_2'];
	$gsm_id =  $_POST['PARAM_3'];
	$size_id =  $_POST['PARAM_4'];
	$loc_code =  $_POST['PARAM_5'];
	$batch_no = $_POST['PARAM_6'];
	$orientation = $_POST['PARAM_7'];
	$destination = $_POST['PARAM_8'];

		if ($loc_code == ALL_TEXT)
		$loc_code = 'all';
	if ($loc_code == 'all')
		$loc = _('All');
	else
		$loc = get_location_name($loc_code);


	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");
	$orientation = ($orientation ? 'L' : 'P');

    $dec = user_price_dec();
	
	$headers = array(_('S.no'), _('Batch No.'),_('Size'), _('Gsm') , _('Material'),  _('Weight'),  _('Unit Cost'),  _('Total value')); 

	$cols = array(0, 30, 110, 150, 170, 380,430,500,560);

	// $headers in doctext.inc
	$aligns = array('left', 'left', 'left', 'left', 'center', 'left');  
	$params = array( 0 => $comments,
    				    1 => array('text' => _('Location'), 'from' => $loc, 'to' => ''));
  	$rep = new FrontReport(_('Updated Reel Stock'), "ReelStock", user_pagesize(), 9, $orientation);
      if ($orientation == 'L')
    	recalculate_cols($cols);

	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();
	$transactions = getTransactions($form, $to, $item_code,$gsm_id, $size_id,$batch_no);
	$sno = 1;
	$tot_weight = $cost_price =$tot_value=0;
	while ($trans=db_fetch($transactions))
	{	
		$grn_batch = get_grn_batch($trans['grn_batch_id']);
        $stock = get_item($trans['stock_id']);
		$get_row = get_batch_qty($trans['batch_no'],$trans['stock_id'], $loc_code);
		// print_r($get_row);exit();
		if(!$get_row['Stock'])
		  continue;
        
		$rep->TextCol(0, 1, $sno++);
		$rep->TextCol(1, 2, $trans['batch_no']);
		$rep->TextCol(2, 3, get_size_name($trans['size_id']));
		$rep->TextCol(3, 4, get_gsm_name($trans['gsm_id']));

		if($destination){
					$rep->TextCol(4, 5, $trans['batch_no']);
		}
		else{

			$oldrow = $rep->row;
			$rep->TextColLines(4, 5,  $stock['description'] .' ( ' . get_supplier_name($grn_batch['supplier_id']) . ' ) ' , -2); 
			$newrow = $rep->row;
			$rep->row = $oldrow;
		}	
		// $get_po = get_po($grn_batch['purch_order_no']);
		$rep->AmountCol(5, 6, $get_row['Stock']);

		 $price=get_betch_price($trans['batch_no'],$trans['stock_id'],true,$date);
         
         $unit_map = get_unit_mapping($stock_id, $unit_id);
	     if ($unit_map)
         $price=price_decimal_format($price/$unit_map['qty']);
		$UnitCost = $price;
		$ItemTotal = $get_row['Stock'] *  $UnitCost ;
		// display_error($UnitCos." == ".$ItemTotal);
		$rep->AmountCol(6, 7, 	$UnitCost,$dec);
		$rep->AmountCol(7, 8, $ItemTotal,$dec);

		$tot_weight+=$get_row['Stock'];
		$cost_price+=$UnitCost;
		$tot_value+=$ItemTotal;
    

			if($destination)
			$rep->NewLine();
			else
			$rep->row = $newrow;

		if ($rep->row < $rep->bottomMargin + $rep->lineHeight)
		{
			$rep->Line($rep->row - 2);
			$rep->NewPage();
		}
	}
	$rep->Line($rep->row  + 11);
	$rep->TextCol(0, 2, _("Total"));

	$rep->Amountcol(5, 6, $tot_weight, $dec);
	// display_error($cost_price." == ".$sno);
	$rep->Amountcol(6, 7, $tot_value/$tot_weight, $dec);
	$rep->Amountcol(7, 8, $tot_value, $dec);

	$rep->Line($rep->row  - 4);
	$rep->NewLine();


	$rep->End();
}

