<!-- NEW -->


<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CORRUGATED_CARTON_COSTING';
$path_to_root = "..";
include($path_to_root . "/includes/session.inc");
page(_($help_context = "Corrugated Carton Costing"));
include($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/inventory/includes/db/gsm_db.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");
include_once($path_to_root . "/sales/includes/db/printing_db.inc");
include_once($path_to_root . "/sales/includes/db/corrugated_carton_costing_db.inc");

simple_page_mode(true);

if (isset($_GET['is_clone'])) {
	$_POST['is_clone'] = $_GET['is_clone'];
}

if (isset($_GET['ADD_ITEM'])) {
	$id = $_GET['ADD_ITEM'];

	hyperlink_params("$path_to_root/sales/view/corrugated_carton_costing_view.php", 
		_("View Corrugated Carton Costing"), "costing_id=$id");
	hyperlink_params("$path_to_root/sales/view/corrugated_carton_costing_view_print.php", 
		_("View Corrugated Carton Costing Print View"), "costing_id=$id");
	hyperlink_params("$path_to_root/sales/inquiry/corrugated_carton_costing_inquiry.php", 
		_("Corrugated Carton Costing Inquiry"), "");
	br();
	submenu_option(_("Enter Other &Corrugated Carton Costing"), "/sales/corrugated_carton_costing.php");
	display_footer_exit();
}



if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{
	$input_error = 0;

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_costing_trans($selected_id, $_POST['customer_id']);
			$note = _('Selected sales area has been updated');
    	} 
    	else 
    	{
    		begin_transaction();
    		$sql = "INSERT INTO ".TB_PREF."costing_trans (date_, customer_id, stock_id, length, weight, heigh, ups, ply_id, printing_id, box_size_id, material_id, no_of_ctns, actual_ctn_size, printing, wastage_cut_size, cartage, tax_percentage, glue_size_id, glue_rate, total_per_ups, overheads, net_cost, final_rate, is_clone, ctn_type, clone_reference) VALUES 
			('".date2sql($_POST['date_']) . "', ".db_escape( $_POST['customer_id']).",
				".db_escape($_POST['stock_id']).", ".db_escape($_POST['length']).", 
				".db_escape($_POST['weight']).", ".db_escape($_POST['heigh']).",
				".db_escape($_POST['ups']).", ".db_escape($_POST['ply_id']).", 
				".db_escape($_POST['printing_id']).", ".db_escape($_POST['box_size_id']).",
				".db_escape($_POST['material_id']).",".db_escape($_POST['no_of_ctns']).", 
				".db_escape($_POST['actual_ctn_size']).", ".db_escape($_POST['printing']).", 
				".db_escape($_POST['wastage_cut_size']).", ".db_escape($_POST['cartage']).", 
				".db_escape($_POST['tax_percentage']).", ".db_escape($_POST['glue_size_id']).",
				".db_escape($_POST['glue_rate']).", ".db_escape($_POST['total_per_ups']).",
				".db_escape($_POST['overheads']).", ".db_escape($_POST['net_cost']).", 
				".db_escape(input_num('final_rate')).", ".db_escape(input_num('is_clone')).",
				".db_escape(input_num('ctn_type')).", ".db_escape(($_POST['clone_reference']) ? 
					$_POST['clone_reference'] : 0).")";
			// display_error($sql);
    		db_query($sql,"The costing trans could not be added");
			$id = db_insert_id();
		
		$ply_name = get_ply_name($_POST['ply_id']);
		$j = $ply_name;
		for ($i=0; $i < $j; $i++) { 
			$sql = "INSERT INTO ".TB_PREF."costing_trans_details (costing_id, size_id, gsm_id, rate, misc_qty, papper) VALUES 
			($id, ".db_escape( input_num('size_id'.$i)).",".db_escape(input_num('gsm_id'.$i)).", 
				".db_escape($_POST['rate'.$i]).", ".db_escape($_POST['misc_qty'.$i]).", 
				".db_escape($_POST['papper'.$i]).")";
    		 db_query($sql,"The costing trans details could not be added");
		   }
    	}
    	commit_transaction();

      meta_forward($_SERVER['PHP_SELF'], "ADD_ITEM=".$id);

		$Mode = 'RESET';
	}
} 

if ($Mode == 'RESET' AND !isset($_POST['is_clone']))
{
	$selected_id = -1;
	unset($_POST);
}

//-------------------------------------------------------------------------------------------------

if (isset($_GET['is_clone'])) {

$myrow = get_costing_trans($_POST['is_clone']);
$costing_trans_detail = get_costing_trans_details($myrow['id']);

	$_POST['date_'] = sql2date($myrow['date_']);
	if (!isset($_POST['customer_id']))
 		$_POST['customer_id'] = $myrow["customer_id"];
	if (!isset($_POST['stock_id']))
  	$_POST['stock_id'] =  $myrow["stock_id"];
	if (!isset($_POST['length']))
  	$_POST['length'] = $myrow["length"];
	if (!isset($_POST['weight']))
  	$_POST['weight'] = $myrow["weight"];
  if (!isset($_POST['heigh']))
  	$_POST['heigh'] = $myrow["heigh"];
  if (!isset($_POST['ups']))
  	$_POST['ups'] = $myrow["ups"];
	if (!isset($_POST['ply_id']))
  	$_POST['ply_id'] = $myrow["ply_id"];
  if (!isset($_POST['printing_id']))
  	$_POST['printing_id'] = $myrow["printing_id"];
  if (!isset($_POST['box_size_id']))
  	$_POST['box_size_id'] = $myrow["box_size_id"];
  if (!isset($_POST['material_id']))
  	$_POST['material_id'] = $myrow["material_id"];
  if (!isset($_POST['no_of_ctns']))
  	$_POST['no_of_ctns'] = $myrow["no_of_ctns"];
  if (!isset($_POST['actual_ctn_size']))
  	$_POST['actual_ctn_size'] = $myrow["actual_ctn_size"];
  if (!isset($_POST['printing']))
  	$_POST['printing'] = $myrow["printing"];
  if (!isset($_POST['printing']))
  	$_POST['printing'] = $myrow["printing"];
  if (!isset($_POST['wastage_cut_size']))
  	$_POST['wastage_cut_size'] = $myrow["wastage_cut_size"];
  if (!isset($_POST['cartage']))
 	 $_POST['cartage'] = $myrow["cartage"];
  if (!isset($_POST['tax_percentage']))
  $_POST['tax_percentage'] = $myrow["tax_percentage"];
  $_POST['glue_rate'] = $myrow["glue_rate"];
  $_POST['total_per_ups'] = $myrow["total_per_ups"];
  $_POST['overheads'] = $myrow["overheads"];
  $_POST['net_cost'] = $myrow["net_cost"];

  $ply_name = get_ply_name($_POST['ply_id']);
	$j = $ply_name;
	$dec = user_price_dec();
	for ($i=0; $i < $j; $i++) { 
		$result = db_fetch($costing_trans_detail);

	  if (!isset($_POST['size_id'.$i]))
	  	$_POST['size_id'.$i] = $result['size_id'];
	  if (!isset($_POST['gsm_id'.$i]))
	  	$_POST['gsm_id'.$i] = $result['gsm_id'];
	  if (!isset($_POST['rate'.$i]))
	  	$_POST['rate'.$i] = $result['rate'];
	  if (!isset($_POST['misc_qty'.$i]))
	  	$_POST['misc_qty'.$i] = $result['misc_qty'];
    if (!isset($_POST['papper'.$i]))
	  	$_POST['papper'.$i] = $result['papper'];
	 }
}

global $Ajax;
start_form();
hidden('is_clone', $_POST['is_clone']);
start_table(TABLESTYLE, "width='30%'");
start_table(TABLESTYLE2, "width='80%'", 5);
echo "<tr><td>"; // outer table
display_heading("Corrugated Carton  Costing");
start_table(TABLESTYLE, "width='100%'");

if (isset($_POST['is_clone'])){
text_cells_ex(_("Reference:"), 'clone_reference', 20, null, $_POST['is_clone'], null, null, 
    null, true);
    label_cell(null, "colspan=1",null);
}


carton_type_list_cells(_("Carton Type:"), 'ctn_type', $_GET['ctn_type']);
label_cells(_("Carton Type"), '<span class="label label-success">'.$wo_ctn_types_array[$_POST['ctn_type']].'<span>'  ,"align='center'");
label_cell(null, "colspan=4",null);
start_row();
date_cells(_("Date:"), 'date_', $_POST['date_'], null, 0, 0, 0,null, false);
customer_list_cells(_("Customer Name:"), 'customer_id', $_POST['customer_id'], false, true, false, true, "class='tableheader2'");
sales_items_list_cells(_("Item Description"),'stock_id', $_POST['stock_id'], false, true, true, $_POST['customer_id']);

end_row();
start_row();
text_cells_ex(_("L:"), 'length', 15, null, $_POST['length'], null, null, null, true);
text_cells_ex(_("W:"), 'weight', 15, null,  $_POST['weight'], null, null, null, true);
text_cells_ex(_("H:"), 'heigh', 15, null,  $_POST['heigh'], null, null, null, true);
text_cells_ex(_("Ups:"), 'ups', 15, null, $_POST['ups']
	, null, null, null, true);
end_row();
start_row();
$Ajax->activate('_page_body');
$ctn_size = ($_POST['length']+$_POST['weight'])*2+50;
label_cells(_("Ctn Size:"), number_format($ctn_size));
$_POST['ctn_size'] = number_format($ctn_size); 
hidden('ctn_size', $_POST['ctn_size']);
$ctn_size_inch = ($ctn_size/25.4);
label_cells(_("Ctn Size Inc:"), ($ctn_size_inch));
$_POST['ctn_size_inch'] = $ctn_size_inch;
hidden('ctn_size_inch', $_POST['ctn_size_inch']); 
// text_cells_ex(_("Cut Size Inc:"), 'ctn_size_inch', 15, null);
$dackle_size = ($_POST['weight']+$_POST['heigh'])*$_POST['ups'];
// display_error($dackle_size .'=='. $_POST['weight'] .'=='. $_POST['heigh'] .'=='. $_POST['one_pcs_up']);
label_cells(_("Dackle size:"), number_format($dackle_size));
$dackle_size_inch = ($dackle_size/25.4);
label_cells(_("Dackle size Inc:"), ($dackle_size_inch));
end_row();
start_row();
item_ply_list_cells(_("Ply"), 'ply_id', $_POST['ply_id'], false, true, $_POST['stock_id']);
item_printing_list_cells(_("Printing"), 'printing_id', $_POST['printing_id'], false, true, $_POST['stock_id']);
box_size_list_cells(_("Carton Size"), 'box_size_id', $_POST['box_size_id'], false, true, $_POST['stock_id']);
item_material_list_cells(_("Material"), 'material_id', $_POST['material_id'], false, true, $_POST['stock_id']);
end_row();
start_row();
text_cells_ex(_("No.of Ctns:"), 'no_of_ctns', 15, $_POST['no_of_ctns'], null, null, null, null, true);
text_cells_ex(_("Dackle Size:"), 'actual_ctn_size', 15, $_POST['actual_ctn_size'], null, null, null, null, true);
	sale_payment_list_cells(_('Payment term:'), 'payment', $is_order ? PM_ANY : $paymcat, null, true, $is_order);
$ply_name = get_ply_name($_POST['ply_id']);
end_row();
end_table();
display_heading("Ply Carton Costing");
start_table(TABLESTYLE, "width='100%'");
$th = array(_("Reel Size"), _("GSM"), _("Cut Size:"), _("S.formula:"), _("Rate:"), _("Misc Qty"), _("Cost:"),
		_("No.of Ctns:"), _("Total Weight:"), _("Papper:"), _("Amount:"));
table_header($th);
start_row();
$j = $ply_name;
$dec = user_price_dec();
for ($i=0; $i < $j; $i++) { 
	$size_id = get_size_name_by_id($_POST['actual_ctn_size']);
	// display_error($size_id);
size_list_cells(null, 'size_id'.$i, ($size_id) ? $size_id:  $_POST['size_id'.$i] , false, true);
gsm_list_cells(null, 'gsm_id'.$i, $_POST['gsm_id'.$i], false, true);
label_cell( $ctn_size_inch, "align='center'");
$size_name = get_size_name($_POST['size_id'.$i]);
$gsm_name = get_gsm_name($_POST['gsm_id'.$i]);
$s_formula = ($size_name*$ctn_size_inch*$gsm_name)/1550000;
label_cell(round($s_formula, $dec), "align='center'");
text_cells_ex(null, 'rate'.$i, 15, null, $_POST['rate'.$i], null, null, null, true);
if($_POST['misc_qty'.$i] <= 0){	
	if($i==0)
	$_POST['misc_qty'.$i] = $misc_qty = 1;
	elseif($i==1)
	$_POST['misc_qty'.$i] = $misc_qty = 1.33;	
	elseif($i==3)
	$_POST['misc_qty'.$i] = $misc_qty = 1.43;		
	else
	$_POST['misc_qty'.$i] = $misc_qty = 1;
	}
else
	$_POST['misc_qty'.$i]=$misc_qty = $_POST['misc_qty'.$i];
	qty_cells(null, 'misc_qty'.$i, $_POST['misc_qty'.$i] ,null,null,null,true);
if($_POST['misc_qty'.$i])
{
	global $Ajax;
	$Ajax->activate('_page_body');
}
$cost = ($s_formula*$_POST['rate'.$i]*$_POST['misc_qty'.$i]);
label_cell(round($cost, $dec),  "align='center'");
label_cell(($_POST['no_of_ctns']),  "align='center'");
// text_cells_ex(null, 'no_of_ctns'.$i, 15, null, null, null, null, null, true);
$total_weight = ($_POST['no_of_ctns']*$s_formula*$_POST['misc_qty'.$i]);
$total_weight_cost += $total_weight;
// display_error($_POST['no_of_ctns'.$i].'=='.$s_formula);
label_cell(round($total_weight, $dec),  "align='center'");
text_cells_ex(null, 'papper'.$i, 15, $_POST['papper'.$i]);
$amount = ($total_weight*$_POST['rate'.$i]);
// display_error($amount);
// display_error($total_weight.'=='.$_POST['rate'.$i]);
label_cell(round($amount, $dec), "align='center'");
$total_cost += $cost; 
$total_amt += $amount;
end_row();
}

size_list_cells(null, 'glue_size_id', ($size_id) ? $size_id:  $_POST['glue_size_id'], false, true);
$glue_size_name = get_size_name($_POST['glue_size_id']);
label_cell(null, "colspan=1",null);
label_cell( $ctn_size_inch, "align='center'");
label_cell(null, "colspan=1",null);
if(!$_POST['glue_rate'])
$_POST['glue_rate']=0.011;
text_cells_ex(null, 'glue_rate', 15, null, $_POST['glue_rate'], null, null, null, true);
$glue_gsm_size = ($glue_size_name*$ctn_size_inch*$_POST['glue_rate']);
// display_error($glue_size_name." * ".$ctn_size_inch."*".$_POST['glue_rate']);
label_cell(null, "colspan=1",null);
label_cell(round($glue_gsm_size, $dec), "align='center'");
label_cell(($_POST['no_of_ctns']),  "align='center'");
label_cell(null, "colspan=2",null);
// display_error($_POST['no_of_ctns']." * ".$glue_gsm_size);
$total_amont = ($_POST['no_of_ctns']*$glue_gsm_size);
label_cell(round($total_amont, $dec), "align='center'");

start_row();
label_cell(_("Printing"), "style='font-weight:bold'");
label_cell(null, "colspan=5",null);
text_cells_ex(null, 'printing', 15, $_POST['printing'], null, null, null, null, true);
label_cell(($_POST['no_of_ctns']),  "align='center'");
label_cell(null, "colspan=2",null);
$total_amont_print = ($_POST['no_of_ctns']*$_POST['printing']);
label_cell(round($total_amont_print, $dec), "align='center'");
end_row();

start_row();
label_cell(_("Wastage"), "style='font-weight:bold'");
label_cell(null, "colspan=1",null);
if(!$_POST['wastage_cut_size'])
$_POST['wastage_cut_size']=3.5;
text_cells_ex(null, 'wastage_cut_size', 10, null, $_POST['wastage_cut_size'], null, null, "%", true);
label_cell(null, "colspan=3",null);
$total_cost_wastage =  ($total_cost+$glue_gsm_size+$_POST['printing']);
$wastage_cost = ($total_cost_wastage/$_POST['ups']*$_POST['wastage_cut_size']/100);
// display_error($wastage_cost);
label_cell(round($wastage_cost, $dec), "align='center'");
// text_cells_ex(null, 'wastage', 15, null, null, null, null, null, true);
label_cell(($_POST['no_of_ctns']),  "align='center'");
label_cell(null, "colspan=2",null);
$total_amont_wastage = ($_POST['no_of_ctns']*$_POST['cartage']);
label_cell(round($total_amont_wastage, $dec), "align='center'");
end_row();

start_row();
label_cell(_("Cartage"), "style='font-weight:bold'");
label_cell(null, "colspan=5",null);
text_cells_ex(null, 'cartage', 15, null, $_POST['cartage'], null, null, null, true);
label_cell(($_POST['no_of_ctns']),  "align='center'");
label_cell(null, "colspan=3",null);
end_row();

start_row();
label_cell(_("Papper Cost"), "style='font-weight:bold'");
label_cell(null, "colspan=5",null);
label_cells(null, round($total_cost, $dec), null, "style='font-weight:bold' align='center'");
label_cell(null, "colspan=1",null);
label_cells(null," Total Weight :".round($total_weight_cost, $dec), null, "style='font-weight:bold' align='center'");
label_cell(null, "colspan=1",null);
label_cells(null, round($total_amt, $dec), null, "style='font-weight:bold' align='center'");
end_row();
$actual_total = ($total_cost+$glue_gsm_size+$_POST['printing']+$wastage_cost+$_POST['cartage'])/$_POST['ups'];
$total_per_ups = ($total_amt+$total_amont+$total_amont_print+$total_amont_wastage+$wastage_cost);
// display_error($total_amt." == ".$total_amont."+".$total_amont_print."+".$total_amont_wastage);


label_cell(_("Total Per Ups"), "style='font-weight:bold'");
label_cell(null, "colspan=5",null);
label_cells(null, round($actual_total, $dec), null, "style='font-weight:bold' align='center'");
label_cell(null, "colspan=3",null);
label_cells(null, round($total_per_ups, $dec), round($_POST['total_per_ups'], $dec), "style='font-weight:bold' align='center'");
$_POST['total_per_ups'] = $actual_total;
hidden('total_per_ups', $_POST['total_per_ups']);

start_row();
// display_error($actual_total."*".$_POST['printing']."/100");
label_cell(_("Overheads"), "style='font-weight:bold'");
  $_POST['ov_perc'] = ($_POST['ov_perc']) ? $_POST['ov_perc']: 15;
text_cells_ex(null, 'ov_perc', 10, null, null, null, null, "%", true);
$overheads = ($actual_total*$_POST['ov_perc']/100); //$_POST['printing']
label_cell(null, "colspan=8",null);
label_cells(null, round($overheads, $dec), round($_POST['overheads'], $dec), "style='font-weight:bold' align='center'");
$_POST['overheads'] = $overheads;
hidden('overheads', $_POST['overheads']);
end_row();
start_row();
$net_cost = ($actual_total+$overheads);
label_cell(_("Net Cost"), "style='font-weight:bold'");
label_cell(null, "colspan=9",null);
label_cells(null, round($net_cost, $dec), round($_POST['net_cost'], $dec), "style='font-weight:bold' align='center'");
$_POST['net_cost'] = $net_cost;
hidden('net_cost', $_POST['net_cost']);
end_row();
label_cell(_("Tax Percentage"), "style='font-weight:bold'");
label_cell(null, "colspan=9",null);
if(!$_POST['tax_percentage'])
$_POST['tax_percentage'] = 18;
text_cells_ex(null, 'tax_percentage', 15, null, $_POST['tax_percentage'], null, null,null, true);
start_row();
$gst_net_cost = ($net_cost*$_POST['tax_percentage']/100)+$net_cost;
label_cell(_("Net Cost + Gst 17%"), "style='font-weight:bold'");
label_cell(null, "colspan=9",null);
label_cells(null, round($gst_net_cost, $dec), null, "style='font-weight:bold' align='center'");
end_row();
start_row();
label_cell(_("Final Rate"), "style='font-weight:bold'");
label_cell(null, "colspan=9",null);
text_cells_ex(null, 'final_rate', 15, null, $_POST['final_rate'], null, null,null, true);
end_row();
end_table();
start_table(TABLESTYLE, "width='100%'");
end_table();
echo '<br>';
end_table();
echo "</td><td>";// outer table
end_table();
echo '<br>';

// if ($_POST['is_clone']) {
// submit_center_first('ProcessClone', _("Add new"),
// 		    _('Check entered data and save document'), 'default');
// }

// if (!$_POST['is_clone']) 
submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();
