<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function get_costing_trans($costing_id)
{
	$sql = "SELECT * FROM ".TB_PREF."costing_trans WHERE id=".db_escape($costing_id);
	$result = db_query($sql,"could not get group");
	return db_fetch($result);
}

function get_costing_trans_print($costing_id)
{ 
	// Use Any Qurey 

	// $sql = "SELECT * FROM ".TB_PREF."costing_trans WHERE id IN $costing_id";

	$sql = "SELECT * FROM ".TB_PREF."costing_trans WHERE id IN ($costing_id)";
	$result = db_query($sql,"could not get group");
	return db_fetch($result);
}


function get_costing_trans_details($costing_id)
{
	$sql = "SELECT * FROM ".TB_PREF."costing_trans_details WHERE costing_id IN (".db_escape($costing_id)." )";
	return db_query($sql,"could not get group");
	// return db_fetch($result);
}


function get_corrugated_carton_costing_inquiry($from="", $to="", $customer_id=0, $stock_id=0)
{
	$sql = "SELECT 
			ct.id,
			ct.customer_id,
			ct.stock_id,
			ct.date_,
			ct.total_per_ups,
			ct.overheads,
			ct.tax_percentage,
			ct.approved,
			ctd.costing_id,
			ct.is_clone
	FROM ".TB_PREF."costing_trans ct , ".TB_PREF."costing_trans_details 
	ctd WHERE ct.id=ctd.costing_id";

	$data_after = date2sql($from);
	$date_before = date2sql($to);
	$sql .= " AND ct.date_ >= '$data_after'";
	$sql .= " AND ct.date_ <= '$date_before'";

	if ($customer_id) 
		$sql .= " AND ct.customer_id = ".db_escape($customer_id);
	if ($stock_id) 
		$sql .= " AND ct.stock_id = ".db_escape($stock_id);


	$sql .= " GROUP BY ct.id";
	return $sql;
}

function so_order_approved($id,$status)
{
  	$sql = "UPDATE ".TB_PREF."costing_trans SET approved = ".db_escape($status)." WHERE id=".db_escape($id);
  	db_query($sql, "Can't change sales order type");
}