<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/

function add_printing($printing)
{
	$sql = "INSERT INTO ".TB_PREF."printing (printing) VALUES (".db_escape($printing) . ")";
   	db_query($sql,"The printing could not be added");
   	// display_error($sql);
}

function update_printing($selected_id, $printing)
{
	$sql = "UPDATE ".TB_PREF."printing SET printing=".db_escape($printing)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The printing could not be updated");
}

function delete_printing($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."printing WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete printing");
}

function get_printings($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."printing";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	$sql .= " ORDER BY printing";
	return db_query($sql,"could not get printing");
}

function get_printing($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."printing WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get printing");
	return db_fetch($result);
}

function get_printing_name($id)
{
	$sql = "SELECT printing FROM ".TB_PREF."printing WHERE id = ".db_escape($id);
	$result = db_query($sql, "could not get printing");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function add_ply($ply)
{
	$sql = "INSERT INTO ".TB_PREF."ply (ply) VALUES (".db_escape($ply) . ")";
   	db_query($sql,"The ply could not be added");
   	// display_error($sql);
}

function update_ply($selected_id, $ply)
{
	$sql = "UPDATE ".TB_PREF."ply SET ply=".db_escape($ply)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The ply could not be updated");
}

function delete_ply($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."ply WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete ply");
}

function get_plys($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."ply";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	$sql .= " ORDER BY ply";
	return db_query($sql,"could not get ply");
}

function get_ply($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."ply WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get ply");
	return db_fetch($result);
}

function get_ply_name($id)
{
	$sql = "SELECT ply FROM ".TB_PREF."ply WHERE id = ".db_escape($id);
	$result = db_query($sql, "could not get ply");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// function add_box_size($length, $width, $height)
// {
// 	$sql = "INSERT INTO ".TB_PREF."box_size (length, width, height) VALUES (".db_escape($length) . ",
// 	".db_escape($width) . ", ".db_escape($height) . ")";
//    	db_query($sql,"The size could not be added");
//    	// display_error($sql);
// }

// function update_box_size($selected_id, $length, $width, $height)
// {
// 	$sql = "UPDATE ".TB_PREF."box_size SET length=".db_escape($length).",width=".db_escape($width).",
// 		height=".db_escape($height)." WHERE id = ".db_escape($selected_id);
//    	db_query($sql,"The size could not be updated");
// }

// function delete_box_size($selected_id)
// {
// 	$sql="DELETE FROM ".TB_PREF."box_size WHERE id=".db_escape($selected_id);
// 	db_query($sql,"could not delete size");
// }

// function get_box_sizes($show_inactive)
// {
// 	$sql = "SELECT * FROM ".TB_PREF."box_size";
// 	if (!$show_inactive) $sql .= " WHERE !inactive";
// 	return db_query($sql,"could not get size");
// }

// function get_box_size($selected_id)
// {
// 	$sql = "SELECT * FROM ".TB_PREF."box_size WHERE id=".db_escape($selected_id);

// 	$result = db_query($sql,"could not get size");
// 	return db_fetch($result);
// }

// function get_box_size_name($id)
// {
// 	$sql = "SELECT  CONCAT(length,' - ',width,' - ',height) FROM ".TB_PREF."box_size WHERE id = ".db_escape($id);
// 	$result = db_query($sql, "could not get size");
// 	$row = db_fetch($result);
// 	return is_array($row) ? $row[0] : false;
// }


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function add_material($material)
{
	$sql = "INSERT INTO ".TB_PREF."material (material) VALUES (".db_escape($material) . ")";
   	db_query($sql,"The material could not be added");
   	// display_error($sql);
}

function update_material($selected_id, $material)
{
	$sql = "UPDATE ".TB_PREF."material SET material=".db_escape($material)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The material could not be updated");
}

function delete_material($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."material WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete material");
}

function get_materials($show_inactive)
{
	$sql = "SELECT * FROM ".TB_PREF."material";
	if (!$show_inactive) $sql .= " WHERE !inactive";
	$sql .= " ORDER BY material";
	return db_query($sql,"could not get material");
}

function get_material($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."material WHERE id=".db_escape($selected_id);

	$result = db_query($sql,"could not get material");
	return db_fetch($result);
}

function get_material_name($id)
{
	$sql = "SELECT material FROM ".TB_PREF."material WHERE id = ".db_escape($id);
	$result = db_query($sql, "could not get material");
	$row = db_fetch($result);
	return is_array($row) ? $row[0] : false;
}

?>