<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CORRUGATED_CARTON_COSTING';
$path_to_root="../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/purchasing/includes/purchasing_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
include_once($path_to_root . "/inventory/includes/db/gsm_db.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");
include_once($path_to_root . "/sales/includes/db/printing_db.inc");
include_once($path_to_root . "/sales/includes/db/corrugated_carton_costing_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Corrugated Carton Costing Inquiry"), false, false, "", $js);


if (isset($_POST['Print_Quotation']))
{
  	
  	// display_error($_POST['multi_itmes_print']. '=='. $_POST['Print_Quotation']);
  	
  	$del_count = 0;
    if (isset($_POST['multi_itmes_print'])) {
			foreach($_POST['multi_itmes_print'] as $delivery => $branch) {
				// print_r($branch);
				$checkbox = 'multi_itmes_print'.$delivery;
				if (check_value($checkbox))	{
					if (!$del_count) {
						$del_branch = $branch;
					}
					else {
						if ($del_branch != $branch)	{
							$del_count=0;
							break;
						}
					}
					$selected[] = $delivery;
					$del_count++;
				}
			}
		}
    if (!$del_count) {
		display_error(_('For batch invoicing you should
		    select at least one delivery. All items must be dispatched to
		    the same customer branch.'));
    } else {
		$_SESSION['Print_Quotation'] = $selected;
		meta_forward($path_to_root . '/sales/view/corrugated_carton_costing_view_print.php','Print_Quotation=Yes');
    }

}

//---------------------------------------------------------------------------------------------
function costing_trans_id($row)
{
	return viewer_link($row['id'] ,'/sales/view/corrugated_carton_costing_view.php?costing_id='.$row['id']);
}

function costing_trans_view_print($row)
{
	return viewer_link($row['id'] ,'/sales/view/corrugated_carton_costing_view_print.php?costing_id='.$row['id']);
}


function customer_name($row)
{
	return get_customer_name($row["customer_id"]);
}

function item_description_name($row)
{
	$item_name = get_item($row["stock_id"]);
	return $item_name["description"];
}

function costing_trans_date($row)
{
	return sql2date($row["date_"]);
}

function net_cost_gst($row)
{
	$dec = user_price_dec();
	$net_cost = ($row['total_per_ups']+$row['overheads']);
	$gst_net_cost = ($net_cost*$row['tax_percentage']/100)+$net_cost;
	return round($gst_net_cost, $dec);
}

function so_link($row) 
{	
	if($row['approved'] != 0)
	  return pager_link(_(""), "/sales/sales_order_entry.php?NewOrder=Yes&costing_id=".$row['id'], ICON_RECEIVE);
}

function approval_link($row)
{

$name = "2chgtpl" .$row['id'];
$value = $row['approved'] ? 1:0;
	
	if(!$row['approved'])
	return checkbox(null, $name, $value, true,
	_("Set the approved GT Order's ")) 
	. hidden('last['.$row['id'].']', $value, false)."<span style='color:red;' > Un-Approved <span>";
    else
      return 
        "<span style='color:Green' > Approved <span>";	

}

function clone_carton_costing_link($row) 
{	
	  	return pager_link(_(""), "/sales/corrugated_carton_costing.php?is_clone=".$row['id'], ICON_RECEIVE);
}

function print_checkbox($row)
{

	$name = "multi_itmes_print" .$row['id'];
	return $row['Done'] ? '' :
		"<input type='checkbox' name='$name' value='1' >"
	 ."<input name='multi_itmes_print[".$row['id']."]' type='hidden' value='"
	 .$row['customer_id']."'>\n";

	// $name = "multi_itmes_print" .$row['id'];

	// return checkbox(null, $name, null, true,
	// 	_("Print This")) 
	// . hidden('last['.$row['id'].']', null, false);

}

$id2 = find_submit('_2chgtpl');
if ($id2 != -1)
{

	so_order_approved($id2, check_value('2chgtpl'.$id2));
	$Ajax->activate('orders_tbl');
}

start_form();
start_table(TABLESTYLE_NOBORDER);
start_row();
sales_items_list_cells(_("Item Description"),'stock_id', $_POST['stock_id'], true, true, true);
customer_list_cells(_("Customer Name:"), 'customer_id', null, true, true, false, true, "class='tableheader2'");
end_row();
end_table();
start_table(TABLESTYLE_NOBORDER);
start_row();
date_cells(_("from:"), 'OrdersAfterDate', '', null, -user_transaction_days());
date_cells(_("to:"), 'OrdersToDate');
submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
end_row();
end_table(1);
//---------------------------------------------------------------------------------------------

$sql = get_corrugated_carton_costing_inquiry(get_post('OrdersAfterDate'), get_post('OrdersToDate'),
		get_post('customer_id'), get_post('stock_id'));

$cols = array(
	_("Carton Costing #") => array('fun'=>'costing_trans_id', 'ord'=>'', 'align'=>'center'),
	_("Carton Costing Print #") => array('fun'=>'costing_trans_view_print', 'ord'=>'', 'align'=>'center'),
	_("Customer Name") => array('fun'=>'customer_name', 'ord'=>'', 'align'=>'center'),
	_("Item Description") => array('fun'=>'item_description_name', 'ord'=>'', 'align'=>'center'),
	_("Date") => array('fun'=>'costing_trans_date', 'ord'=>'', 'align'=>'center'),
	_("Net Cost + Gst 17%") => array('fun'=>'net_cost_gst', 'ord'=>'', 'align'=>'center'),
	_("SO") => array('fun'=>'so_link', 'ord'=>'', 'align'=>'center'),
	_("Approval SO") => array('fun'=>'approval_link', 'ord'=>'', 'align'=>'center'),
	_("Clone") => array('fun'=>'clone_carton_costing_link', 'ord'=>'', 'align'=>'center'),

	submit('Print_Quotation',_("Print Quotation"), false, _("Print Quotation")) 
			=> array('insert'=>true, 'fun'=>'print_checkbox', 'align'=>'center'),
);

//---------------------------------------------------------------------------------------------------

$table =& new_db_pager('orders_tbl', $sql, $cols);

$table->width = "80%";
display_db_pager($table);

end_form();
end_page();
