<?php
$path_to_root = "..";
$page_security = 'SA_SALESORDER';

include_once($path_to_root . "/sales/includes/cart_class.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/sales/includes/ui/pos_ui.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_types_db.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");
set_page_security( @$_SESSION['PosItems']->trans_type,
	array(	ST_SALESORDER=>'SA_SALESORDER',
			ST_SALESQUOTE => 'SA_SALESQUOTE',
			ST_CUSTDELIVERY => 'SA_SALESDELIVERY',
			ST_SALESINVOICE => 'SA_POS_INVOICE'),
	array(	'NewOrder' => 'SA_SALESORDER',
			'ModifyOrderNumber' => 'SA_SALESORDER',
			'AddedID' => 'SA_SALESORDER',
			'UpdatedID' => 'SA_SALESORDER',
			'NewQuotation' => 'SA_SALESQUOTE',
			'ModifyQuotationNumber' => 'SA_SALESQUOTE',
			'NewQuoteToSalesOrder' => 'SA_SALESQUOTE',
			'AddedQU' => 'SA_SALESQUOTE',
			'UpdatedQU' => 'SA_SALESQUOTE',
			'NewDelivery' => 'SA_SALESDELIVERY',
			'AddedDN' => 'SA_SALESDELIVERY', 
			'NewInvoice' => 'SA_POS_INVOICE',
			'AddedDI' => 'SA_POS_INVOICE'
			)
);

$js = '';

if ($SysPrefs->use_popup_windows) {
	$js .= get_js_open_window(900, 500);
}

if (user_use_date_picker()) {
	$js .= get_js_date_picker();
}

page($_SESSION['page_title'], true, false, "", $js);

if (isset($_GET['AddedDI'])) {
    $invoice = $_GET['AddedDI'];

    display_notification_centered(sprintf(_("Invoice # %d has been entered."), $invoice));

    submenu_view(_("&View This Invoice"), ST_SALESINVOICE, $invoice);

 echo '<center><span><a target="_blank" class="viewlink" href="../sales/view/view_pos.php?trans_no='.$invoice.'&amp;trans_type=ST_SALESINVOICE_POS" onclick="javascript:openWindow(this.href,this.target); return false;" accesskey="V"><u>V</u>iew This POS Invoice</a></span></center>';

    submenu_print(_("&Print Sales Invoice"), ST_SALESINVOICE, $invoice."-".ST_SALESINVOICE, 'prtopt');
    submenu_print(_("&Email Sales Invoice"), ST_SALESINVOICE, $invoice."-".ST_SALESINVOICE, null, 1);
    set_focus('prtopt');

    $row = db_fetch(get_allocatable_from_cust_transactions(null, $invoice, ST_SALESINVOICE));
    if ($row !== false)
        submenu_print(_("Print &Receipt"), $row['type'], $row['trans_no']."-".$row['type'], 'prtopt');

    display_note(get_gl_view_str(ST_SALESINVOICE, $invoice, _("View the GL &Journal Entries for this Invoice")),0, 1);

    if ((isset($_GET['Type']) && $_GET['Type'] == 1))
        submenu_option(_("Enter a &New Template Invoice"), 
            "/sales/inquiry/sales_orders_view.php?InvoiceTemplates=Yes");
    else
        submenu_option(_("Enter a &New Pos Invoice"),
            "/sales/pos.php?NewInvoice=0");

    if ($row === false)
        submenu_option(_("Entry &customer payment for this invoice"), "/sales/customer_payments.php?SInvoice=".$invoice);

    submenu_option(_("Add an Attachment"), "/admin/attachments.php?filterType=".ST_SALESINVOICE."&trans_no=$invoice");

    display_footer_exit();
} else
    check_edit_conflicts(get_post('cart_id'));


if(isset($_GET['NewInvoice']) && is_numeric($_GET['NewInvoice'])){
    $_SESSION['page_title'] = _($help_context = "Pos Invoice");
	create_cart(ST_SALESINVOICE,0);
}


if(isset($_GET['OrderNo']) && is_numeric($_GET['OrderNo']))
{

        read_sales_order($_GET['OrderNo'], $_SESSION['PosItems'], ST_SALESORDER);
        $_SESSION['PosItems']->trans_type=ST_SALESINVOICE;

        $_SESSION['PosItems']->hold_order_no=$_GET['OrderNo'];
        unset($_SESSION['PosItems']->trans_no);
        $_SESSION['PosItems']->trans_no=0;
        // if (!is_array($_SESSION['PosItems']->trans_no)) $_SESSION['PosItems']->trans_no = array($_SESSION['PosItems']->trans_no);
        // print_r($_SESSION['PosItems']);
        

}


if(isset($_GET['AddedID']) && is_numeric($_GET['AddedID'])){

    $invoice = $_GET['AddedID'];
       display_notification_centered(sprintf(_("Order # %d has been entered On Hold invoice."), $invoice));

}
	function create_cart($type, $trans_no)
{ 
	global $Refs, $SysPrefs;

	if (!$SysPrefs->db_ok) // create_cart is called before page() where the check is done
		return;

	processing_start();

	if (isset($_GET['NewQuoteToSalesOrder']))
	{
		$trans_no = $_GET['NewQuoteToSalesOrder'];
		$doc = new Cart(ST_SALESQUOTE, $trans_no, true);
		$doc->Comments = _("Sales Quotation") . " # " . $trans_no;
		$_SESSION['PosItems'] = $doc;
	}	
	elseif($type != ST_SALESORDER && $type != ST_SALESQUOTE && $trans_no != 0) { // this is template

		$doc = new Cart(ST_SALESORDER, array($trans_no));
		$doc->trans_type = $type;
		$doc->trans_no = 0;
		$doc->document_date = new_doc_date();
		if ($type == ST_SALESINVOICE) {
			$doc->due_date = get_invoice_duedate($doc->payment, $doc->document_date);
			$doc->pos = get_sales_point(user_pos());
		} else
			$doc->due_date = $doc->document_date;
		$doc->reference = $Refs->get_next($doc->trans_type, null, array('date' => Today()));
		//$doc->Comments='';
		foreach($doc->line_items as $line_no => $line) {
			$doc->line_items[$line_no]->qty_done = 0;
		}
		$_SESSION['PosItems'] = $doc;
	} else
		$_SESSION['PosItems'] = new Cart($type, array($trans_no));
	copy_from_cart();
}

//--------------------------------------------------------------------------------
function can_process() {

    global $Refs, $SysPrefs;

    copy_to_cart();

    if (!get_post('customer_id')) 
    {
        display_error(_("There is no customer selected."));
        set_focus('customer_id');
        return false;
    } 
    
    if (!get_post('branch_id')) 
    {
        display_error(_("This customer has no branch defined."));
        set_focus('branch_id');
        return false;
    } 
    
    if (!is_date($_POST['OrderDate'])) {
        display_error(_("The entered date is invalid."));
        set_focus('OrderDate');
        return false;
    }
    if ($_SESSION['PosItems']->trans_type!=ST_SALESORDER && $_SESSION['PosItems']->trans_type!=ST_SALESQUOTE && !is_date_in_fiscalyear($_POST['OrderDate'])) {
        display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
        set_focus('OrderDate');
        return false;
    }
    if (count($_SESSION['PosItems']->line_items) == 0) {
        display_error(_("You must enter at least one non empty item line."));
        set_focus('AddItem');
        return false;
    }
    if (!$SysPrefs->allow_negative_stock() && ($low_stock = $_SESSION['PosItems']->check_qoh()))
    {
        display_error(_("This document cannot be processed because there is insufficient quantity for items marked."));
        return false;
    }
    if ($_SESSION['PosItems']->payment_terms['cash_sale'] == 0) {
        if (!$_SESSION['PosItems']->is_started() && ($_SESSION['PosItems']->payment_terms['days_before_due'] == -1) && ((input_num('prep_amount')<=0) ||
            input_num('prep_amount')>$_SESSION['PosItems']->get_trans_total())) {
            display_error(_("Pre-payment required have to be positive and less than total amount."));
            set_focus('prep_amount');
            return false;
        }
        if (strlen($_POST['deliver_to']) <= 1) {
            display_error(_("You must enter the person or company to whom delivery should be made to."));
            set_focus('deliver_to');
            return false;
        }

        if ($_SESSION['PosItems']->trans_type != ST_SALESQUOTE && strlen($_POST['delivery_address']) <= 1) {
            display_error( _("You should enter the street address in the box provided. Orders cannot be accepted without a valid street address."));
            set_focus('delivery_address');
            return false;
        }

        if ($_POST['freight_cost'] == "")
            $_POST['freight_cost'] = price_format(0);

        if (!check_num('freight_cost',0)) {
            display_error(_("The shipping cost entered is expected to be numeric."));
            set_focus('freight_cost');
            return false;
        }
        if (!is_date($_POST['delivery_date'])) {
            if ($_SESSION['PosItems']->trans_type==ST_SALESQUOTE)
                display_error(_("The Valid date is invalid."));
            else    
                display_error(_("The delivery date is invalid."));
            set_focus('delivery_date');
            return false;
        }
        if (date1_greater_date2($_POST['OrderDate'], $_POST['delivery_date'])) {
            if ($_SESSION['PosItems']->trans_type==ST_SALESQUOTE)
                display_error(_("The requested valid date is before the date of the quotation."));
            else    
                display_error(_("The requested delivery date is before the date of the order."));
            set_focus('delivery_date');
            return false;
        }
    }
    else
    {
        if (!db_has_cash_accounts())
        {
            display_error(_("You need to define a cash account for your Sales Point."));
            return false;
        }   
    }   
    if (!$Refs->is_valid($_POST['ref'], $_SESSION['PosItems']->trans_type)) {
        display_error(_("You must enter a reference."));
        set_focus('ref');
        return false;
    }
    if (!db_has_currency_rates($_SESSION['PosItems']->customer_currency, $_POST['OrderDate']))
        return false;
    // display_error($_SESSION['PosItems']->get_items_total());
    if ($_SESSION['PosItems']->get_items_total() < 0) {
        display_error("Invoice total amount cannot be less than zero.");
        return false;
    }

    if ($_SESSION['PosItems']->payment_terms['cash_sale'] && 
        ($_SESSION['PosItems']->trans_type == ST_CUSTDELIVERY || $_SESSION['PosItems']->trans_type == ST_SALESINVOICE)) 
        $_SESSION['PosItems']->due_date = $_SESSION['PosItems']->document_date;



  

            foreach ($_SESSION['PosItems']->get_items() as $line_no=>$stock_item){

                    if($stock_item->is_return)
                    {
                        $_SESSION['PosItems']->rtn_line_item[count($_SESSION['PosItems']->rtn_line_item)]=$stock_item;

                        $_SESSION['PosItems']->remove_from_cart($line_no);

                    }
            }












    return true;
}


// if(isset($_POST['HoldOrder'])){

//   meta_forward($_SERVER['PHP_SELF'], "NewInvoice=0");


// }


if ( (isset($_POST['ProcessOrder']) || isset($_POST['HoldOrder'])) && can_process()) {

    $modified = ($_SESSION['PosItems']->trans_no != 0);
    $so_type = $_SESSION['PosItems']->so_type;
  
  // print_r($_SESSION['PosItems']);exit();

   if(isset($_POST['HoldOrder'])){
    // display_error('in');exit();
    $_SESSION['PosItems']->trans_type=ST_SALESORDER;
       $_SESSION['PosItems']->reference = $Refs->get_next($_SESSION['PosItems']->trans_type, null, array('date' => Today()));
   
   }


    $ret = $_SESSION['PosItems']->write(1);
    
    if($_SESSION['PosItems']->hold_order_no)
       {
            $sql = "UPDATE ".TB_PREF."sales_orders SET hold_order = 1  WHERE trans_type='30' AND order_no=".db_escape($_SESSION['PosItems']->hold_order_no);
             db_query($sql, "Can't change sales order type");
       } 



    if ($ret == -1)
    {
        display_error(_("The entered reference is already in use."));
        $ref = $Refs->get_next($_SESSION['PosItems']->trans_type, null, array('date' => Today()));
        if ($ref != $_SESSION['PosItems']->reference)
        {
            unset($_POST['ref']); // force refresh reference
            display_error(_("The reference number field has been increased. Please save the document again."));
        }
        set_focus('ref');
    }
    else
    {
        if (count($messages)) { // abort on failure or error messages are lost
            $Ajax->activate('_page_body');
            display_footer_exit();
        }
        $trans_no = key($_SESSION['PosItems']->trans_no);
        $trans_type = $_SESSION['PosItems']->trans_type;
         
          if(count($_SESSION['PosItems']->rtn_line_item))
          {
               unset($_SESSION['PosItems']->line_items); 
            $_SESSION['PosItems']->line_items =$_SESSION['PosItems']->rtn_line_item;
            $_SESSION['PosItems']->trans_type=ST_CUSTCREDIT;
            $_SESSION['PosItems']->src_docs = $_SESSION['PosItems']->trans_no ;
             $_SESSION['PosItems']->reference = $Refs->get_next($_SESSION['PosItems']->trans_type, null, array('date' => Today()));

            $new_credit = ($_SESSION['PosItems']->trans_no == 0);

            if (!isset($_POST['WriteOffGLCode']))
            $_POST['WriteOffGLCode'] = 0;

            copy_to_cart();
            if ($new_credit) 
            new_doc_date($_SESSION['PosItems']->document_date);
            $credit_no = $_SESSION['PosItems']->write($_POST['WriteOffGLCode']);
            if ($credit_no == -1)
            {
            display_error(_("The entered reference is already in use."));
            set_focus('ref');
            }

   // print_r($_SESSION['PosItems']->rtn_line_item);
          }


        new_doc_date($_SESSION['PosItems']->document_date);


        processing_end();
        if ($modified) {
            if ($trans_type == ST_SALESQUOTE)
                meta_forward($_SERVER['PHP_SELF'], "UpdatedQU=$trans_no");
            else    
                meta_forward($_SERVER['PHP_SELF'], "UpdatedID=$trans_no");
        } elseif ($trans_type == ST_SALESORDER) {
            meta_forward($_SERVER['PHP_SELF'], "NewInvoice=0&AddedID=$trans_no");
        } elseif ($trans_type == ST_SALESQUOTE) {
            meta_forward($_SERVER['PHP_SELF'], "AddedQU=$trans_no");
        } elseif ($trans_type == ST_SALESINVOICE) {
            echo "<script type='text/javascript'>
            window.open('../sales/view/view_pos.php?trans_no=".$trans_no."&amp;trans_type=ST_SALESINVOICE','','toolbar=no,scrollbar=no,resizable=yes,menubar=no,width=400,height=800');
            </script>";
              meta_forward($_SERVER['PHP_SELF'], "NewInvoice=0");
            // meta_forward($_SERVER['PHP_SELF'], "AddedDI=$trans_no&Type=$so_type");
        } else {
            meta_forward($_SERVER['PHP_SELF'], "AddedDN=$trans_no&Type=$so_type");
        }
    }   
}
function copy_from_cart()
{
	$cart = &$_SESSION['PosItems'];
	$_POST['ref'] = $cart->reference;
	$_POST['Comments'] = $cart->Comments;

	$_POST['OrderDate'] = $cart->document_date;
	$_POST['delivery_date'] = $cart->due_date;
	$_POST['cust_ref'] = $cart->cust_ref;
	$_POST['freight_cost'] = price_format($cart->freight_cost);

	$_POST['deliver_to'] = $cart->deliver_to;
	$_POST['delivery_address'] = $cart->delivery_address;
	$_POST['phone'] = $cart->phone;
	$_POST['Location'] = $cart->Location;
	$_POST['ship_via'] = $cart->ship_via;

	$_POST['customer_id'] = $cart->customer_id;

	$_POST['branch_id'] = $cart->Branch;
	$_POST['sales_type'] = $cart->sales_type;
	$_POST['prep_amount'] = price_format($cart->prep_amount);
    $_POST['tot_discount'] = price_format($cart->tot_discount);

	// POS 
	$_POST['payment'] = $cart->payment;
	if ($cart->trans_type!=ST_SALESORDER && $cart->trans_type!=ST_SALESQUOTE) { // 2008-11-12 Joe Hunt
		$_POST['dimension_id'] = $cart->dimension_id;
		$_POST['dimension2_id'] = $cart->dimension2_id;
	}
	$_POST['cart_id'] = $cart->cart_id;
	$_POST['_ex_rate'] = $cart->ex_rate;

        $_POST['card_amount'] = $cart->card_amount;
    $_POST['bank_account'] = $cart->bank_account;
}

function copy_to_cart()
{
    $cart = &$_SESSION['PosItems'];

    $cart->reference = $_POST['ref'];

    $cart->Comments =  $_POST['Comments'];

    $cart->document_date = $_POST['OrderDate'];

    $newpayment = false;

    if (isset($_POST['payment']) && ($cart->payment != $_POST['payment'])) {
        $cart->payment = $_POST['payment'];
        $cart->payment_terms = get_payment_terms($_POST['payment']);
        $newpayment = true;
    }
    if ($cart->payment_terms['cash_sale']) {
        if ($newpayment) {
            $cart->due_date = $cart->document_date;
            $cart->phone = $cart->cust_ref = $cart->delivery_address = '';
            $cart->ship_via = 0;
            $cart->deliver_to = '';
            $cart->prep_amount = 0;
        }
    } else {
        $cart->due_date = $_POST['delivery_date'];
        $cart->cust_ref = $_POST['cust_ref'];
        $cart->deliver_to = $_POST['deliver_to'];
        $cart->delivery_address = $_POST['delivery_address'];
        $cart->ship_via = $_POST['ship_via'];
        if (!$cart->trans_no || ($cart->trans_type == ST_SALESORDER && !$cart->is_started()))
            $cart->prep_amount = input_num('prep_amount', 0);
    }
        $cart->phone = $_POST['phone'];
    $cart->Location = $_POST['Location'];
    $cart->freight_cost = input_num('freight_cost');
    if (isset($_POST['email']))
        $cart->email =$_POST['email'];
    else
        $cart->email = '';
    $cart->customer_id  = $_POST['customer_id'];
    $cart->Branch = $_POST['branch_id'];
    $cart->sales_type = $_POST['sales_type'];

    if ($cart->trans_type!=ST_SALESORDER && $cart->trans_type!=ST_SALESQUOTE) { // 2008-11-12 Joe Hunt
        $cart->dimension_id = $_POST['dimension_id'];
        $cart->dimension2_id = $_POST['dimension2_id'];
    }
    $cart->ex_rate = input_num('_ex_rate', null);

        $cart->cash_amount = input_num('cash_amount');
    $cart->card_amount = input_num('card_amount');
    $cart->bank_account = $_POST['bank_account'];
    $cart->tot_discount = input_num('tot_discount');
       $cart->bank_charges = input_num('bank_charges');
          $cart->inc_bank_charges = input_num('inc_bank_charges');

                    $cart->sales_person_id = input_num('sales_person_id');
    
}

// print_r(	$_SESSION['PosItems']);
?>
<!-- <!DOCTYPE html>
<html lang="en" data-textdirection="ltr">
<head>
 -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="csrf-token" content="">
    <title>Landing Page</title>
    <base href="">

    <meta name="description" content="" />
    <meta name="keywords" content="" />

    <meta property="og:url"           content="" />
    <meta property="og:type"          content="" />
    <meta property="og:title"         content="" />
    <meta property="og:description"   content="" />
    <meta property="og:image"         content="" />

    <link rel="apple-touch-icon" sizes="57x57" href="">
    <link rel="apple-touch-icon" sizes="60x60" href="">
    <link rel="apple-touch-icon" sizes="72x72" href="">
    <link rel="apple-touch-icon" sizes="76x76" href="">
    <link rel="apple-touch-icon" sizes="114x114" href="">
    <link rel="apple-touch-icon" sizes="120x120" href="">
    <link rel="apple-touch-icon" sizes="144x144" href="">
    <link rel="apple-touch-icon" sizes="152x152" href="">
    <link rel="apple-touch-icon" sizes="180x180" href="">
    <link rel="icon" type="image/png" sizes="192x192"  href="">
    <link rel="icon" type="image/png" sizes="32x32" href="">
    <link rel="icon" type="image/png" sizes="96x96" href="">
    <link rel="icon" type="image/png" sizes="16x16" href="">
    <link rel="manifest" href="">
    <!-- Slick Slider -->
    <link rel="stylesheet" type="text/css" href="assets/vendors/slick-1.8.1/slick/slick.css"/>
    <link rel="stylesheet" type="text/css" href="assets/vendors/slick-1.8.1/slick/slick-theme.css"/>
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="https://pro.fontawesome.com/releases/v5.10.0/css/all.css" integrity="sha384-AYmEC3Yw5cVb3ZcuHtOA93w35dYTsvhLPVnYs9eStHfGJvOvKxVfELGroGkvsg+p" crossorigin="anonymous"/>
    <link href="assets/vendors/bootstrap-5/css/bootstrap.css" rel="stylesheet"><link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="assets/css/style.css" rel="stylesheet">
         <link href="assets/css/toastr.min.css" rel="stylesheet">
  <script src="assets/js/toastr.min.js"></script>

<!--      <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script> -->

<!-- </head>
<body> -->
<!--------------------------Section-------------------------------------->
<!-- <section class=""> -->
    <!-- <div class="container-fluid "> -->

    	<?php  


     function handle_delete_item($line_no)
    {   global $Ajax;
           // display_error($line_no);
        // if ($_SESSION['PosItems']->some_already_delivered($line_no) == 0) {
            $_SESSION['PosItems']->remove_from_cart($line_no);
            $Ajax->activate('_page_body');
        // } else {
        //     display_error(_("This item cannot be deleted because some of it has already been delivered."));
        // }
        // line_start_focus();
    }

$id = find_submit('AddItem',false);
    if ($id != '')
    { 


    global $Ajax;
    $price = get_price($id, $_SESSION['PosItems']->customer_currency, $_POST['sales_type'] );
    // display_error($id);
        add_to_order($_SESSION['PosItems'], $id, 1,
        $price, input_num('Disc') / 100, '');

         $Ajax->activate('_page_body');
      // display_error('in');
        // print_r($_SESSION['PosItems']->line_items);
        $Ajax->addScript(true, "beep_sound();");// $('#left-bar').scrollTop($('#left-bar').height());
        
         // $Ajax->addScript(true, " $('#cash_amount').focus();");


    }

    if(get_post('barcode') || get_post('stock_id'))
    {

     // $kit = get_item_kit(input_num('barcode'));

        if(get_post('barcode'))
        $item_num = get_item_barcode_code_dflts(get_post('barcode'));
        else
        $item_num = get_item_code_dflts(get_post('stock_id'));

     if($item_num)
       {
       // display_error(get_post('barcode'));
        global $Ajax;
        $price = get_price($item_num['stock_id'], $_SESSION['PosItems']->customer_currency, $_POST['sales_type'] );
        add_to_order($_SESSION['PosItems'], $item_num['stock_id'], 1,
        $price, input_num('Disc') / 100, '');
        $Ajax->activate('_page_body');
        $Ajax->addScript(true, "beep_sound();");


         //$('#left-bar').scrollTop($('#left-bar').height());
            if(!get_post('stock_id'))
             set_focus('barcode');

                     // if(input_num('barcode'))
            // else
            // set_focus('_stock_id_edit');

            // set_focus('_cash_amount');

       } 

        $Ajax->addScript(true, "
                $('#barcode').on('change keyup',function(e) {

                    if(e.keyCode == 13 || e.keyCode == 9){
                    var len = $('#barcode').val().length;
                    var bb =  $('#barcode').val();
                             
                             $('#tot_discount').focus();

                             $('#barcode').focus();
                            
                    }
                });   ");
    }


    $del_id = find_submit('Delete');
    if ($del_id!=-1)
    handle_delete_item($del_id);

    if(isset($_POST['tot_discount']))
    {     global $Ajax;
           $Ajax->activate('_page_body');
    }



        start_form(); ?>
        <div class="row">
<audio src="beep_sound.wav" id="beep_audio" ></audio>





            <div class="col-sm-12 col-md-4 col-lg-4 p-0 ">
                <div class="">
                    <div class="content-side">
                        <div class="d-flex flex-column bd-highlight">
                            <div class=" bd-highlight">

                                <div class="d-flex bd-highlight bg-color-1 p-0">
                                    <div class="p-2 bd-highlight"><i class="fad fa-bars text-white fa-2x"></i></div>
                                    <div class="p-2 mx-auto bd-highlight">
                                        <div class="fs-5 text-white">
                                            CART (0)
                                        </div>
                                    </div>
                                    <div class="p-2 bd-highlight"><i class="fad fa-plus text-white fa-2x"></i></div>
                                </div>

                            </div>
                            <div class=" bd-highlight scroll" id="left-bar">
                                <div class="p-2 content-side-menu ">
                                    <!-- <form class=""> -->
                                       <!--  <div class="col-md-12 cus-b-border pt-4 pb-4">
                                            <select class="form-select" aria-label="Default select example">
                                                <option selected>Open this select menu</option>
                                                <option value="1">One</option>
                                                <option value="2">Two</option>
                                                <option value="3">Three</option>
                                            </select>
                                        </div> -->
                                       
                                        <div class="col-md-12 pt-2">
                                            <div class="input-group ">
                                                <input type="text" class="form-control" name="barcode" id="barcode" aria-label="Username" aria-describedby="basic-addon1">
                                                <span class="input-group-text" id="basic-addon1"><i class="far fa-barcode-read"></i></span>
                                            </div>
                                        </div>
                                        <div class="col-md-12 pt-2 table-container scroll" id="item_details">
                                            <table class="table ch-8 table-striped">   <!-- table-secondary  -->
                                                <thead>
                                                <tr class="table-secondary">
                                                    <th scope="col">Return</th>
                                                    <th scope="col">Name</th>
                                                    <th scope="col">Code</th>
                                                    <th scope="col">Qty</th>
                                                    <th scope="col">Price</th>
                                                    <th scope="col">Disc %</th>
                                                    <th scope="col">Line Total</th>
                                                    <th scope="col"></th>
                                                </tr>
                                                </thead>
                                                <tbody id="item-body" style="height: 300px; overflow-y: scroll;">
                                                 
                                                 <?php
                                                 $line_total= $total_qty=0;
  
                                                   foreach ($_SESSION['PosItems']->get_items() as $line_no=>$stock_item)
                                                   {   
                                                            $_SESSION['PosItems']->line_items[$line_no]->is_return = $_POST['is_return'.$line_no];

                                                        $stock_item->discount_percent = input_num('Disc'.$line_no) / 100 ;                      
                                                    // display_error(input_num('Disc'.$line_no)." = ".$stock_item->discount_percent." = ".$line_no);
                                                        $line_total = round($stock_item->qty_dispatched * $stock_item->price * (1 - $stock_item->discount_percent),
                                                        user_price_dec());
                                                        if(input_num('is_return'.$line_no))
                                                        $line_total*=-1;
                                                        else
                                                        if($stock_item->qty_dispatched<0)
                                                        $line_total*=-1; 


                                                     $line_mark='';
                                                   $qoh  = get_qoh_on_date($stock_item->stock_id, $_POST['Location']);
                                                   // display_error($qoh);
                                                     $line_mark= (!$qoh) ?  'style="color:red;"' : '';

                                                    ?>   
                                                <tr <?php  echo $line_mark; ?>>
                                                     <?php 
                                                     // if($_POST['is_return'.$line_no])

                                                     echo check_cells(null, 'is_return'.$line_no, $_POST['is_return'.$line_no],
                                                     true, _('split payment cash or card')); ?>
                                                    <td><?php echo $stock_item->item_description ?></td>
                                                    <td><?php echo $stock_item->stock_id ?></td>
                                                    <td><?php echo $stock_item->qty_dispatched ?></td>
                                                    <td><?php echo $stock_item->price ?></td>
                                                    <?php // display_error($_POST['Disc'.$line_no]);
                                                     echo   small_amount_perc_cells(null, 'Disc'.$line_no, percent_format($_POST['Disc'.$line_no]), null, null, user_percent_dec(),true); ?>
                                                     
                                                      <td><?php echo  price_format($line_total) ?></td>

                                                       <td><?php echo button("Delete$line_no",  _("Delete"),_('Remove line from document') ,ICON_DELETE, ''); ?></td>
                                                </tr>
                                                 <?php 
                                                  $total += $line_total;
                                                  $total_qty+= $stock_item->qty_dispatched ;

                                                 }


                                                  ?> 


                                               <!--  <tr>
                                                    <td>Red Maxi</td>
                                                    <td>101</td>
                                                    <td>1</td>
                                                    <td>50.00</td>
                                                </tr> -->

                                                </tbody>
                                                <tfoot>
                                                <tr>
                                                    <th  scope="col" colspan="3">Total QTY</th>
                                                    <th  scope="col" id="qty_total"><?php echo     $total_qty; ?></th>
                                                    <td colspan="4"></td>
                                                   
                                                </tr>
                                                 </tfoot>
                                            </table>
                                        </div>

                                    

                                        <div class="d-flex bd-highlight cus-b-border">
                                            <div class="me-auto p-2 bd-highlight"><div class="ch-6 fw-bold "> Total</div></div>
                                            <div class="p-2 bd-highlight">
                                                <div class="ch-6 fw-bold " id="total_val"><?php echo $_SESSION['PosItems']->customer_currency." ";  echo  price_format($total) ; ?></div>
                                            </div>
                                        </div>

                                      <!--   <div class="d-flex bd-highlight cus-b-border">
                                            <div class="me-auto p-2 bd-highlight"><div class="ch-6 fw-bold ">Taxes </div></div>
                                            <div class="p-2 bd-highlight">
                                                <div class="ch-6 fw-bold "> <?php //echo $_SESSION['PosItems']->customer_currency." ";  $taxes = $_SESSION['PosItems']->get_taxes(input_num('freight_cost'));
                                              //$tax_total = display_edit_tax_items($taxes, $colspan, $_SESSION['PosItems']->tax_included, 2); ?></div>
                                            </div>
                                        </div> -->

                                         <div class="d-flex bd-highlight bg-color-1 text-white rounded-10">
                                            <div class="me-auto p-2 bd-highlight"><div class="ch-6 fw-bold ">Sub Total</div></div>
                                            <div class="p-2 bd-highlight">
                                                <?php $display_total = price_format(( ($total + input_num('freight_cost') + $tax_total))); ?>
                                                <div class="ch-6 fw-bold " id="sub_total_val"> <?php echo $_SESSION['PosItems']->customer_currency." "; echo $display_total;  ?></div>
                                            </div>
                                        </div>

                                       <div class="d-flex bd-highlight cus-b-border">
                                            <div class="me-auto p-2 bd-highlight"><div class="ch-6 fw-bold ">Add Discount</div></div>
                                            <div class="p-2 bd-highlight">
                                                <input type="number" name="tot_discount" id="tot_discount" class="form-control"  placeholder="Discount" value="<?php echo input_num('tot_discount'); ?>">
                                            </div>
                                        </div>
                                       

                                  <!--       <div class="d-flex bd-highlight">
                                            <div class="me-auto p-2 bd-highlight"><div class="ch-6 fw-bold "> Refund</div></div>
                                            <div class="p-2 bd-highlight">
                                                <input type="email" class="form-control" id="exampleFormControlInput1" placeholder="Cash Refund">
                                            </div>
                                        </div>
                                        <div class="d-flex bd-highlight">
                                            <div class="me-auto p-2 bd-highlight"><div class="ch-6 fw-bold ">Cash Refund</div></div>
                                            <div class="p-2 bd-highlight">
                                                <input type="email" class="form-control" id="exampleFormControlInput1" placeholder="Cash Refund">
                                            </div>
                                        </div> -->


                                        <div class="d-flex bd-highlight bg-color-1 text-white rounded-10">
                                            <div class="me-auto p-2 bd-highlight"><div class="ch-6 fw-bold ">Charge</div></div>
                                            <div class="p-2 bd-highlight" >
                                                <?php
                                                    $display_total_ =( ($total + input_num('freight_cost') + $tax_total)-input_num('tot_discount'));
                                                    $display_total = price_format(( ($total + input_num('freight_cost') + $tax_total)-input_num('tot_discount'))); ?>
                                                <div class="ch-6 fw-bold " id="charge_amt"> <?php echo $_SESSION['PosItems']->customer_currency." "; echo $display_total;  ?></div>
                                            </div>
                                        </div>

                                    <div class="d-flex bd-highlight ">
                                            <div class="me-auto p-2 bd-highlight"><div class="ch-6 fw-bold ">Sales Person</div></div>
                                            <div class="p-2 bd-highlight">
                                                    <!-- <div class="ch-6 fw-bold "> <?php  ?> </div> -->
                                                    <!-- <div class="ch-6 fw-bold ">Bank </div> -->
                                                    <?php echo sales_persons_list_row(null, 'sales_person_id', null);  ?>
                                             

                                            
                                            </div>
                                        </div>

                                          <?php // if($_POST['split_payment']) { ?>

                                      <div id="SplitPayDiv" style="display: none;">
                                         <div class="d-flex bd-highlight ">
                                            <div class="me-auto p-2 bd-highlight"><div class="ch-6 fw-bold ">CASH AMOUNT</div></div>
                                            <div class="p-2 bd-highlight">

                                                <div class="ch-6 fw-bold "> <?php echo $_SESSION['PosItems']->customer_currency." "; echo $display_total;  ?></div>
                                            </div>
                                        </div>
                                         
                                        <div class="d-flex bd-highlight ">
                                            <div class="me-auto p-2 bd-highlight"><div class="ch-6 fw-bold ">CARD AMOUNT</div></div>
                                            <div class="p-2 bd-highlight">
                                                    <!-- <div class="ch-6 fw-bold "> <?php  ?> </div> -->
                                                    <div class="ch-6 fw-bold ">Bank </div>
                                                    <?php echo bank_accounts_list("bank_account", $_POST['bank_account'], false, false);  ?>
                                                <div class="ch-6 fw-bold "> 
                                                    <div class="ch-6 fw-bold ">Bank Amount</div>
                                                   <input type="number" name="card_amount"  id="card_amount" class="form-control"  placeholder="card_amount" value="<?php echo input_num('card_amount'); ?>"></div>

                                                 <div class="ch-6 fw-bold"><div class="ch-6 fw-bold ">Bank charges</div> 
                                                 <input type="number" name="bank_charges"  id="bank_charges" class="form-control"  placeholder="Cash Amount" value="<?php echo input_num('bank_charges'); ?>"></div>
                                            </div>
                                        </div>

                                      </div>  



                                    <?php//  } ?>

                                           <div class="d-flex bd-highlight cus-b-border">
                                            <div class="me-auto p-2 bd-highlight"><div class="ch-6 fw-bold ">Split Payment</div></div>
                                            <div class="p-2 bd-highlight">
                                                <?php ///display_error($display_total_);

                                                            check_row(null, 'split_payment', $_POST['split_payment'],
                                                            false, _('split payment cash or card')); 
                                                  ?>
                                            

                                           
                                            </div>
                                        </div>

                                     <div class="d-flex bd-highlight cus-b-border">
                                            <div class="me-auto p-2 bd-highlight"><div class="ch-6 fw-bold ">Cash Amount</div></div>
                                            <div class="p-2 bd-highlight">
                                                <?php ///display_error($display_total_);  
                                                $_POST['cash_amount'] =   $display_total_-input_num('card_amount');  ?>
                                                <input type="number" name="cash_amount"  id="cash_amount" class="form-control"  placeholder="Cash Amount" value="<?php echo input_num('cash_amount'); ?>">

                                           
                                            </div>
                                        </div>





                                        

                                      <!--   <div class="d-flex bd-highlight mt-2">
                                            <div class="me-auto bd-highlight"><div class=" flex-fill bd-highlight"><a href="<?php echo $path_to_root."/index.php"; ?>" class="btn ch-6 w-100 fw-bold btn-info">Home</a></div></div>

                                            <div class="me-auto bd-highlight"><div class=" flex-fill bd-highlight"><button name="HoldOrder"  class="btn ch-6 w-100 fw-bold btn-secondary">Hold</button></div></div>
                                            <div class=" bd-highlight"><div class=" flex-fill bd-highlight"><button name="ProcessOrder" class="btn ch-6 w-100 fw-bold btn-success">Invoice</button></div></div>
                                        </div>
 -->





                                    <!-- </form> -->
                                     <div class="col-md-12 pt-4" id="content">
                                           <?php
                                            if ($_SESSION['PosItems']->trans_type == ST_SALESINVOICE) {
                                            $idate = _("Invoice Date:");
                                            $orderitems = _("Sales Invoice Items");
                                            $deliverydetails = _("Enter Delivery Details and Confirm Invoice");
                                            $cancelorder = _("Cancel Invoice");
                                            $porder = _("Place Invoice");
                                            } 
                                            $customer_error = display_order_header($_SESSION['PosItems'], !$_SESSION['PosItems']->is_started(), $idate);

                                            // print_r($_SESSION['PosItems']);
                                             
                                                display_delivery_details($_SESSION['PosItems']);
                                            ?>
                                            <!-- <select class="form-select" aria-label="Default select example">
                                                <option selected>Customer</option>
                                                <option value="1">One</option>
                                                <option value="2">Two</option>
                                                <option value="3">Three</option>
                                            </select> -->
                                        </div>
                                </div>
                            </div>
                        </div>


                    </div>
                </div>
            </div>




            <div class="col-sm-12 col-md-8 col-lg-8 p-0">
                <div class="content-side">
                    <div class="d-flex flex-column bd-highlight">
                        <div class=" bd-highlight">

                            <div class="d-flex bd-highlight bg-color-1 p-0">
                                <div class="p-2 bd-highlight"><i class="fas fa-bars text-white fa-2x"></i></div>
                                <div class=" flex-grow-1 bd-highlight tab-1 ps-3">
                                    <!-----------------------Tab------------------------------->
                                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" id="Products-tab" data-bs-toggle="tab" data-bs-target="#Products" type="button" role="tab" aria-controls="Products" aria-selected="true">Products</button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="Orders-tab" data-bs-toggle="tab" data-bs-target="#Orders" type="button" role="tab" aria-controls="Orders" aria-selected="false">Orders</button>
                                        </li>
                                    </ul>

                                     

                                    <!-----------------------Tab------------------------------->
                                </div>



<!--                                <div class="p-2 bd-highlight pe-4"><i class="far fa-search text-white fa-2x"></i></div>-->
                                  <div class="d-flex bd-highlight mt-2 ">

                                      <div class="me-auto bd-highlight "><div class=" flex-fill bd-highlight p-2"><a href="<?php echo $path_to_root."/sales/pos.php?NewInvoice=0"; ?>" class="btn ch-6 w-100 fw-bold btn-warning">Refresh</a></div></div>
                                            <div class="me-auto bd-highlight "><div class=" flex-fill bd-highlight p-2"><a href="<?php echo $path_to_root."/index.php"; ?>" class="btn ch-6 w-100 fw-bold btn-danger">Home</a></div></div>

                                            <div class="me-auto bd-highlight"><div class=" flex-fill bd-highlight  ps-3 p-2"><button name="HoldOrder"  class="btn ch-6 w-100 fw-bold btn-secondary">Hold</button></div></div>
                                            <div class=" bd-highlight"><div class=" flex-fill bd-highlight  ps-3 p-2"><button name="ProcessOrder" class="btn ch-6 w-100 fw-bold btn-success">Invoice</button></div></div>

                                            <div class=" bd-highlight" id="toggleButton" ><div class=" flex-fill bd-highlight  ps-3 p-2"><a name="ProcessOrder" class="btn ch-6 w-100 fw-bold btn-success">show Detail</a></div></div>

                                        </div>
                            </div>

                        </div>
                        <div class=" bd-highlight">
                            <div class="content-side-menu scroll">
                                <!-----------------------Tab------------------------------->
                                <div class="tab-content " id="myTabContent">
                                    <!-----------------Tab 1------------->
                                    <div class="tab-pane fade show active" id="Products" role="tabpanel" aria-labelledby="Products-tab">
                                        <div class="container-fluid">

                                            <div class="row mt-3 mb-3">
                                                <div class="col-sm-12 col-md-12 col-lg-12">

                                                      <table class="table table-secondary ch-8 tablestyle">
                                                <thead>
                                                <tr>
                                                    <?php 
                                                    start_table(TABLESTYLE2, "width='100%'");
                                                          label_cells( _(" Items : "),pos_sales_items_list('stock_id', $_POST['stock_id'], _("Select"),false));  

                                                         
                                                                stock_categories_list_cells(_("Category:"), 'category_id', null, _("All Category"), false);
                                                           end_table();
                                                      ?>
                                                      </tr>
                                                       </thead>
                                                     <tbody>
                                                  </tbody>
                                                </table>
                                                    <!-- <select class="form-select" aria-label="Default select example">
                                                        <option selected>Category</option>
                                                        <option value="1">One</option>
                                                        <option value="2">Two</option>
                                                        <option value="3">Three</option>
                                                    </select> -->
                                                </div>
                                                <!-- <div class="col-sm-12 col-md-6 col-lg-6">
                                                    <div class="input-group ">
                                                        <input type="text" class="form-control" aria-label="Username" placeholder="Search" aria-describedby="basic-addon1">
                                                        <span class="input-group-text"><i class="fas fa-search"></i></span>
                                                    </div>
                                                </div> -->
                                            </div>
                                            <div class="row " id="item-box">

                                             <!--    <div class="col-sm-6 col-md-3 col-lg-3 cus-r-b-border">
                                                    <div class=" h-100 w-100 p-3">
                                                        <div class="text-center">
                                                            <div class="bg-color-1 mt-3 rounded-10 text-center pt-3 pb-3">
                                                                <img src="assets/img/icons/plus.svg" height="150px" class="w-100" type="button">
                                                            </div>
                                                            <div class="text-color-1 mt-2 mb-2">ADD PRODUCT</div>
                                                        </div>
                                                    </div>
                                                </div> -->

                                        <?php

                                           $res_cat = get_categories(false,$_POST['category_id']);   
                                            while ($cat_row = db_fetch($res_cat)) {  ?>
                                             <?php 
                                             $res_item = get_sale_items($cat_row["category_id"]);
                                           
                                           // display_error( $_SESSION['PosItems']->customer_currency);
                                           // display_error($_POST['AddItem']);
                                             if(!db_num_rows($res_item))
                                                continue;
                                            // br(2);
                                               ?>
                                                  <div class=" h-100 w-100 p-3">  <h2><b><u> <?php echo $cat_row["description"];  ?></u></b></h2></div>
                                               <?php 

                                                   // $item_row = db_fetch($res_item);
                                                   // print_r($item_row);

                                               while ($item_row = db_fetch($res_item)) {
                                                    $price = get_price($item_row['item_code'], $_SESSION['PosItems']->customer_currency, $_POST['sales_type'] );
                                                ?>
                                               		
                                                <div class="col-sm-6 col-md-3 col-lg-3 cus-r-b-border">
                                                    <div class=" h-100 w-100 p-3">
                                                        <div class="text-center">
                                                            <div class="bg-color-1 mt-3 rounded-10 text-center pt-3 pb-3">
                                               	<a class="btn addbtn" type="" name="AddItem<?php echo $item_row['item_code'];?>" id="<?php echo $item_row['item_code'];?>" value="<?php  echo $item_row['item_code']; ?>" title="Add new item to document">

                                                              <?php 
                                                                 $file_ref ='assets/img/icons/shoes.svg'; 
                                                               foreach (array('jpg', 'png', 'gif') as $ext){

                                                                  $file = company_path().'/images/'.item_img_name($item_row['item_code']). ".$ext";
                                                                   if (file_exists($file)){

                                                                       $file_ref = company_path().'/images/'.item_img_name($item_row['item_code']). ".$ext"; 
                                                                       break;
                                                                   }
                                                               }
                                                                    $mark_color = "style= 'color: Green;'";
                                                                    $qoh = get_qoh_on_date($item_row['item_code'], get_post('Location'));
                                                                      if($qoh<=0)
                                                                    $mark_color = "style= 'color: red;'";
                                                                     
                                                                 ?>
                                                                <img src="<?php echo $file_ref; ?>" class="w-100" height="150px" >
                                                            </div>
                                                            <div class="text-color-1 mt-2"><?php echo $item_row['item_code']." ".$item_row['description_item']." </br> ". $item_row['barcode']; ?></div>
                                                            <div class="text-color-1 fw-bold">PRICE : <?php echo $price; ?> </div>
                                                            <div class="text-color-1 fw-bold" <?php echo $mark_color; ?>>QOH : <?php echo $qoh; ?> </div>
                                               	</a>
                                                        </div>
                                                    </div>
                                                </div>
                                               <?php  } 
                                                  
                                                      
                                                  }
         
                                               ?> 
                                             



                                            </div>
                                        </div>
                                    </div>
                                    <!-----------------Tab 1------------->
                                    <div class="tab-pane fade" id="Orders" role="tabpanel" aria-labelledby="Orders-tab">
                                        <?php   $res = get_on_hold_order(); 
                                           while ($row =db_fetch($res)) {
                                             # code...   
                                        ?>
                                          <div class="col-sm-6 col-md-3 col-lg-3 cus-r-b-border">
                                                    <div class=" h-100 w-100 p-3">
                                                        <div class="text-center">
                                                            <a href="<?php echo $path_to_root."/sales/pos.php?NewInvoice=0&OrderNo=".$row['order_no']; ?>">
                                                                
                                                            <div class="bg-color-1 mt-3 rounded-10 text-center pt-3 pb-3">
                                                                <img src="assets/img/icons/shoes.svg" height="150px" class="w-100" type="button">
                                                            </div>
                                                             <div class="text-color-1 fw-bold">HOLD ORDER </div>
                                                            <div class="text-color-1 mt-2 mb-2"><?php  echo "Order No # ".$row['order_no'] ." <br> Order Referance ".$row['reference'] ; ?></div>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>

                                              <?php  } ?>  

                                    </div>
                                </div>
                                <!-----------------------Tab------------------------------->
                            </div>
                        </div>
                    </div>


                </div>
            </div>


            <!-----------Portion Distributed----------->



        </div>
        <?php  


		// submit_cells('AddItem', _("Add Item"), "colspan=2 align='center'",
		//     _('Add new item to document'), true);


           end_form();


           if(isset($_GET['NewInvoice']) && is_numeric($_GET['NewInvoice']))
           {
                set_focus('barcode');



           }
		     ?>

    <!-- </div> -->
<!-- </section> -->
<!-------------------------/Section-------------------------------------->
<!--------------------------Footer--------------------------------------->
<!-- <footer class="pt-5 pb-5">
</footer> -->
<!-------------------------/Footer--------------------------------------->
<!--------------------------Script--------------------------------------->
<script src="assets/js/jquery-3.6.0.min.js"></script>
<script src="assets/vendors/bootstrap-5/js/bootstrap.js"></script>
<script src="asset/js/script.js"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>
<script type="text/javascript" src="assets/vendors/slick-1.8.1/slick/slick.min.js"></script>
<!-- <script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.11.4/jquery-ui.min.js"></script> -->
<script src="assets/js/jquery-ui.min.js"></script>

<?php  end_page(true,true); ?>

<script>
    function beep_sound() {
        let sound = document.getElementById('beep_audio');
        sound.play();
    }





$("#barcode").on('change keyup',function(e) {
    var barcode = $(this).val();
    // alert(barcode);
    if(e.keyCode == 13 || e.keyCode == 9){
          
        var len = $("#barcode").val().length;
        var bb =  $("#barcode").val();

         add_item_ajax(null,barcode);
          $('#barcode').val('');
        $('#tot_discount').focus();
        $('#barcode').focus();
  
        
        }
    });


    $('#stock_id').select2({
    width: '300px' // need to override the changed default
});


$(document).ready(function() {
  $('.addbtn').on('click', function() { 

    var stock_id = $(this).attr('id');

    // Make an AJAX request
    add_item_ajax(stock_id);

    
  });

  // for show hide custoemr details
  $("#toggleButton").click(function() {
    $("#content").slideToggle();
  });
});



$(document).ready(function() {
$('#stock_id').on('change click', function() { 
    var selectedOption = $(this).val();

// alert(selectedOption);
 add_item_ajax(selectedOption);
   $('#stock_id').val('defaultOption');
    // Make an AJAX request

  });

$('#tot_discount').on('focusout', function() { 
// alert(selectedOption);
 add_item_ajax();
 
    // Make an AJAX request

  });


$('#card_amount').on('focusout', function() { 
// alert(selectedOption);
 add_item_ajax();
 
    // Make an AJAX request

  });



});

function add_item_ajax(stock_id,barcode,del_id)
{
   var sales_type =document.getElementById("sales_type").value;

   var tot_discount =document.getElementById("tot_discount").value;
    var Location =document.getElementById("Location").value;
    var card_amount =document.getElementById("card_amount").value;

   
   // $('#item-body').fadeOut();

    $.ajax({
      url: 'line_item.php',
      method: 'POST',
      data: { stock_id: stock_id ,barcode:barcode, sales_type:sales_type , Location:Location ,tot_discount:tot_discount , card_amount:card_amount , del_id:del_id },
      dataType: "json",
      success: function(response) {
          console.log(response);
        // Handle the response from PHP
                $('#item-body').html('');
        $('#item-body').html(response.html);
        // $('#item-body').fadeIn();
        $('#total_val').html(response.total);
        $('#sub_total_val').html(response.sub_total);
        $('#charge_amt').html((response.cash_amount).toLocaleString('en-US', {
              style: 'currency',
              currency: 'PKR',
            }) );
        $('#cash_amount').val(response.cash_amount);
        $('#qty_total').html(response.total_qty);

        
        
         
         
        

         // $('#item-body').slideDown(400);
        beep_sound();
        if(stock_id!=null || barcode!=null)
        {

              if(response.item_status==2)
              toastr.warning(' Item '+response.item_desc+' Quantity In Hand is  '+response.qoh, 'Warning');  
                else
              toastr.success('Item has been Added', 'Successfully');
        }
        // showNotification(,);
      },
      error: function(e) {
        console.log(e);

        // Handle any errors that occur during the AJAX request
        console.error('AJAX request failed.');
      }
    });
    

}

function del_item(line_no)
{

   // alert(line_no);

 add_item_ajax(null,null,line_no);
 
    // Make an AJAX request

}

function update_item(line_no){

        var disc =document.getElementById("disc"+line_no).value;

         var qty =document.getElementById("qty"+line_no).value;
         var  is_return_val =0
           if(document.getElementById("is_return"+line_no).checked===true)
            is_return_val =  1;//document.getElementById("is_return"+line_no).checked;
           else
              is_return_val =  0;
           // console.log(is_return_val+"  "+"is_return"+line_no);

                $.ajax({
      url: 'update_item.php',
      method: 'POST',
      data: { line_no:line_no, disc:disc , qty:qty ,is_return_val:is_return_val },
      success: function(response) {
          // console.log(response);
           add_item_ajax();
     
        // beep_sound();
      },
      error: function() {
        // Handle any errors that occur during the AJAX request
        console.error('AJAX request failed.');
      }
    });

      // document.getElementById("disc"+line_no).focus();          


}


$(document).ready(function() {
$('#category_id').on('change', function() { 
    var category_id = $(this).val();
    $( "#item-box" ).fadeToggle('fast');
    var sales_type =document.getElementById("sales_type").value;

        $.ajax({
      url: 'item_box.php',
      method: 'POST',
      data: { category_id: category_id , sales_type:sales_type },
      success: function(response) {
          // console.log(response);
        // Handle the response from PHP
                $('#item-box').html('');
           $( "#item-box" ).fadeToggle('fast');
        $('#item-box').html(response);
         // $('#item-box').slideDown(400);
        // beep_sound();
      },
      error: function() {
        // Handle any errors that occur during the AJAX request
        console.error('AJAX request failed.');
      }
    });

// alert(selectedOption);
 // add_item_ajax(selectedOption);
   // $('#stock_id').val('defaultOption');
    // Make an AJAX request

  });
});




    // function showNotification(msg,title) {
      // toastr.success(msg, title);
    // }

    toastr.options.timeOut = 3000;
$(document).ready(function() {
  $('#split_payment').change(function() {
    if ($(this).is(':checked')) {
      $('#SplitPayDiv').show();
    } else {
      $('#SplitPayDiv').hide();
    }
  });
});




</script>

<style type="text/css">
    .main-footer {
  display: none !important;
}



#content {
  display: none;
  /* Additional styling */
}
.table-container {
  height: 500px; /* Specify the desired height */
  overflow-y: auto; /* Enable vertical scroll */
}
thead {
  position: sticky;
  top: -9px;
  background-color: #fff; /* Set the background color as desired */
}

tfoot {
  position: sticky;
  bottom: -9px;
  background-color: #fff; /* Set the background color as desired */
}




</style>
<!-------------------------/Script--------------------------------------->
<!-- </body>
</html> -->