<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
    Released under the terms of the GNU General Public License, GPL, 
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_CORRUGATED_CARTON_COSTING';
$path_to_root = "../..";
include_once($path_to_root . "/sales/includes/cart_class.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include($path_to_root . "/purchasing/includes/purchasing_ui.inc");
include_once($path_to_root . "/inventory/includes/db/gsm_db.inc");
include_once($path_to_root . "/inventory/includes/db/size_db.inc");
include_once($path_to_root . "/sales/includes/db/printing_db.inc");
include_once($path_to_root . "/sales/includes/db/corrugated_carton_costing_db.inc");
include_once($path_to_root . "/inventory/includes/db/box_size_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
    $js .= get_js_open_window(900, 500);
page(_($help_context = "Corrugated Carton Costing"), true, false, "", $js);

if (!isset($_GET['costing_id']))
{
    die ("<br>" . _("This page not found."));
}

display_heading(_("") . "Carton Costing # ".  $_GET['costing_id']);
br(2);

$row = get_costing_trans($_GET['costing_id']);
$item_name = get_item($row['stock_id']);
// print_r($row);
echo "<center>";
if($row['approved'])
   echo "<h3 style='color:green;' > Approved </h3>" ;
else
   echo "<h3 style='color:red;' > Un-Approved </h3>" ;

start_outer_table(TABLESTYLE2, "width='100%'");
start_outer_table(TABLESTYLE2, "width=90%");
start_row();
label_cells(_("Date:"), sql2date($row['date_']), "class='tableheader2'");
label_cells(_("Customer Name:"), get_customer_name($row['customer_id']), "class='tableheader2'");
label_cells(_("Item Description:"), $item_name['description'], "class='tableheader2'");
end_row();
start_row();
label_cells(_("L:"), $row['length'], "class='tableheader2'");
label_cells(_("W:"), $row['weight'], "class='tableheader2'");
label_cells(_("H:"), $row['heigh'], "class='tableheader2'");
end_row();
start_row();
label_cells(_("Ups:"), $row['ups'], "class='tableheader2'");
$ctn_size = ($row['length']+$row['weight'])*2+50;
label_cells(_("Ctn Size:"), number_format($ctn_size), "class='tableheader2'");
$ctn_size_inch = ($ctn_size/25.4);
label_cells(_("Ctn Size Inc:"), ($ctn_size_inch), "class='tableheader2'");
end_row();
start_row();
$dackle_size = ($row['weight']+$row['heigh'])*$row['ups'];
label_cells(_("Dackle size:"), number_format($dackle_size), "class='tableheader2'");
$dackle_size_inch = ($dackle_size/25.4);
label_cells(_("Dackle size Inc:"), ($dackle_size_inch), "class='tableheader2'");
label_cells(_("Ply:"), get_ply_name($row['ply_id']), "class='tableheader2'");
end_row();
start_row();
label_cells(_("Printing:"), get_printing_name($row['printing_id']), "class='tableheader2'");
label_cells(_("Carton Size:"), get_box_size_name($row['box_size_id']), "class='tableheader2'");
label_cells(_("Material:"), get_material_name($row['material_id']), "class='tableheader2'");
end_row();
start_row();
label_cells(_("No.of Ctns:"), $row['no_of_ctns'], "class='tableheader2'");
label_cells(_("Actual Ctn Size:"), $row['actual_ctn_size'], "class='tableheader2'");
if($row['is_clone'])
label_cells(_("Reference:"), $row['clone_reference'], "class='tableheader2'");
end_row();
end_outer_table();
end_outer_table(1);

$result = get_costing_trans_details($_GET['costing_id']);
start_form();
start_table(TABLESTYLE, "width='30%'");

$th = array(_("Reel Size"), _("GSM"), _("Ctn Size:"), _("S.formula:"), _("Rate:"), _("Misc Qty"), 
    _("Cost:"), _("No.of Ctns:"), _("Total Weight:"), _("Papper:"), _("Amount:"));
table_header($th);

$dec = user_price_dec();
while ($myrow = db_fetch($result)) 
{
    $size_name = get_size_name($myrow['size_id']);
    $gsm_name = get_gsm_name($myrow["gsm_id"]);
    label_cell(get_size_name($myrow['size_id']), "align='center'");
    label_cell(get_gsm_name($myrow["gsm_id"]), "align='center'");
    label_cell(($myrow['actual_ctn_size']) ? round($myrow['actual_ctn_size'], $dec) : 
        round($ctn_size_inch, $dec), "align='center'");
    $s_formula = ($size_name*$ctn_size_inch*$gsm_name)/1550000;
    label_cell(round($s_formula, $dec), "align='center'");
    label_cell($myrow['rate'], "align='center'");
    label_cell($myrow['misc_qty'], "align='center'");
    $cost = ($s_formula*$myrow['rate']*$myrow['misc_qty']);
    label_cell(round($cost, $dec),  "align='center'");
    label_cell($row['no_of_ctns'],  "align='center'");
    $total_weight = ($row['no_of_ctns']*$s_formula*$myrow['misc_qty']);
    $total_weight_cost += $total_weight;
    label_cell(round($total_weight, $dec),  "align='center'");
    label_cell($myrow['papper'], "align='center'");
    $amount = ($total_weight*$myrow['rate']);
    label_cell(round($amount, $dec), "align='center'");
    $total_cost += $cost; 
    $total_amt += $amount;
    end_row();
}

$glue_size_name = get_size_name($row['glue_size_id']);
$glue_gsm_size = ($glue_size_name*$ctn_size_inch*$row['glue_rate']);
label_cell($glue_size_name, "align='center'");
label_cell(null, "colspan=1");
label_cell(($myrow['actual_ctn_size']) ? round($myrow['actual_ctn_size'], $dec) : 
        round($ctn_size_inch, $dec), "align='center'");
label_cell(null, "colspan=1");
label_cell($row['glue_rate'], "align='center'");
label_cell(null, "colspan=1");
label_cell(round($glue_gsm_size, $dec), "align='center'");
label_cell(($row['no_of_ctns']),  "align='center'");
label_cell(null, "colspan=2");
$total_amont = ($row['no_of_ctns']*$glue_gsm_size);
label_cell(round($total_amont, $dec), "align='center'");
start_row();
label_cell(_("Printing"), "style='font-weight:bold'");
label_cell(null, "colspan=5");
label_cell($row['printing'], "align='center'");
label_cell(($row['no_of_ctns']),  "align='center'");
label_cell(null, "colspan=2");
$total_amont_print = ($row['no_of_ctns']*$row['printing']);
label_cell(round($total_amont_print, $dec), "align='center'");
end_row();
start_row();
label_cell(_("Wastage"), "style='font-weight:bold'");
label_cell(null, "colspan=1");
label_cell($row['wastage_cut_size'], "align='center'");
label_cell(null, "colspan=3");
$total_cost_wastage =  ($total_cost+$glue_gsm_size+$row['printing']);
$wastage_cost = ($total_cost_wastage/$row['ups']*$row['wastage_cut_size']/100);
label_cell(round($wastage_cost, $dec), "align='center'");
// text_cells_ex(null, 'wastage', 15, null, null, null, null, null, true);
label_cell(($row['no_of_ctns']),  "align='center'");
label_cell(null, "colspan=2");
$total_amont_wastage = ($row['no_of_ctns']*$row['cartage']);
label_cell(round($total_amont_wastage, $dec), "align='center'");
end_row();
start_row();
label_cell(_("Cartage"), "style='font-weight:bold'");
label_cell(null, "colspan=5");
label_cell(($row['cartage']),  "align='center'");
label_cell(($row['no_of_ctns']),  "align='center'");
label_cell(null, "colspan=3");
end_row();
start_row();
label_cell(_("Papper Cost"), "style='font-weight:bold'");
label_cell(null, "colspan=5",null);
label_cells(null, round($total_cost, $dec), null, "style='font-weight:bold' align='center'");
label_cell(null, "colspan=1",null);
label_cells(null, " Total Weight : ".round($total_weight_cost, $dec), null, "style='font-weight:bold' align='center'");
label_cell(null, "colspan=1",null);
label_cells(null, round($total_amt, $dec), null, "style='font-weight:bold' align='center'");
end_row();
$actual_total = ($total_cost+$glue_gsm_size+$row['printing']+$wastage_cost+$row['cartage'])/$row['ups'];
$total_per_ups = ($total_amt+$total_amont+$total_amont_print+$total_amont_wastage);
label_cell(_("Total Per Ups"), "style='font-weight:bold'");
label_cell(null, "colspan=5",null);
label_cells(null, round($actual_total, $dec), null, "style='font-weight:bold' align='center'");
label_cell(null, "colspan=3",null);
label_cells(null, round($total_per_ups, $dec), null, "style='font-weight:bold' align='center'");
start_row();
$overheads = ($actual_total*15/100); //$_POST['printing']
label_cell(_("Overheads"), "style='font-weight:bold'");
label_cell(null, "colspan=9",null);
label_cells(null, round($overheads, $dec), null, "style='font-weight:bold' align='center'");
end_row();
start_row();
$net_cost = ($actual_total+$overheads);
label_cell(_("Net Cost"), "style='font-weight:bold'");
label_cell(null, "colspan=9",null);
label_cells(null, round($net_cost, $dec), null, "style='font-weight:bold' align='center'");
end_row();
label_cell(_("Tax Percentage"), "style='font-weight:bold'");
label_cell(null, "colspan=9",null);
if(!$row['tax_percentage'])
$row['tax_percentage'] = 17;
label_cell(($row['tax_percentage']." %"),  "align='center'");
start_row();
$gst_net_cost = ($net_cost*$row['tax_percentage']/100)+$net_cost;
label_cell(_("Net Cost + Gst 17%"), "style='font-weight:bold'");
label_cell(null, "colspan=9",null);
label_cells(null, round($gst_net_cost, $dec), null, "style='font-weight:bold' align='center'");
end_row();
start_row();
label_cell(_("Final Rate"), "style='font-weight:bold'");
label_cell(null, "colspan=9",null);
label_cells(null, round($row['final_rate'], $dec), null, "style='font-weight:bold' align='center'");
end_row();
end_table();
//----------------------------------------------------------------------------------------------------

end_page(true, false, false);

