<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
    Released under the terms of the GNU General Public License, GPL, 
    as published by the Free Software Foundation, either version 3 
    of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_POS_INVOICE_VIEW';
$path_to_root = "../..";
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/sales/includes/cart_class.inc");
// include_once($path_to_root . "/sales/includes/sales_ui.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
// $js = "";
// if ($SysPrefs->use_popup_windows)
//  $js .= get_js_open_window(900, 600);
// page(false, true, false, "", $js);

// display_error($_GET["trans_no"]. '===='. $_GET['trans_type']);
$invoice = get_customer_trans($_GET["trans_no"], ST_SALESINVOICE);
$invoice_detail = get_customer_trans_details(ST_SALESINVOICE, $_GET["trans_no"]);
$gst_no = get_company_prefs();
$sales_order = get_sales_order_header($invoice['order_'], ST_SALESORDER);

$paym = get_payment_terms($invoice['payment_terms']);
$branch = get_branch($invoice["branch_code"]);
$alloc_result = get_allocatable_from_cust_transactions( $invoice['debtor_no'],  $_GET["trans_no"], ST_SALESINVOICE);
// $alloc_row = db_fetch($alloc_result);


// print_r($sales_order);
// print_r($branch);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            margin: 0;
            padding: 10px;
            font-family: 'PT Sans', sans-serif;
        }

        @page {
            size: 2.8in 11in;
            margin-top: 0cm;
            margin-left: 0cm;
            margin-right: 0cm;
        }

        table {
            width: 100%;
        }

        tr {
            width: 100%;

        }

        h1 {
            text-align: center;
            vertical-align: middle;
        }

        #logo {
            width: 80%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            padding: 5px;
            margin: 2px;
            display: block;
            margin: 0 auto;
        }

        header {
            width: 100%;
            text-align: center;
            -webkit-align-content: center;
            align-content: center;
            vertical-align: middle;
        }

        .items thead {
            text-align: center;
        }

        .center-align {
            text-align: center;
        }

        .bill-details td {
            font-size: 11px;
        }

        .receipt {
            font-size: medium;
        }

        .items .heading {
            font-size: 14.5px;
            text-transform: uppercase;
            border-top:1px solid black;
            margin-bottom: 4px;
            border-bottom: 1px solid black;
            vertical-align: middle;
        }

        .items thead tr th:first-child,
        .items tbody tr td:first-child {
            width: 47%;
            min-width: 47%;
            max-width: 47%;
            word-break: break-all;
            text-align: left;
        }

        .items td {
            font-size: 11px;
            text-align: right;
            vertical-align: bottom;
        }

        .price::before {
             content: "";
            font-family: Arial;
            text-align: right;
        }

        .sum-up {
            text-align: right !important;
        }
        .total {
            font-size: 13px;
            border-top:1px dashed black !important;
            border-bottom:1px dashed black !important;
        }
        .total.text, .total.price {
            text-align: right;
        }
        .total.price::before {
            content: "Rs"; 
        }
        .line {
            border-top:1px solid black !important;
        }
        .heading.rate {
            width: 20%;
        }
        .heading.amount {
            width: 25%;
        }
        .heading.qty {
            width: 5%
        }
        p {
            padding: 1px;
            margin: 0;
        }
        section, footer {
            font-size: 11px;
        }
    </style>
</head>

<body>
    <header>
        <?php 
         $logo = company_path() . "/images/" . get_company_prefs()['coy_logo'];
         

          if (get_company_prefs()['coy_logo'] != '' && file_exists($logo)) { //display_error($logo); ?>
         
             <div id="logo" class="media" data-src="logo.png" src="<?php echo $logo; ?>"> <img id="logo" class="media" src="<?php echo $logo; ?>"></div>

              
                       <div id="logo" ><h5><?php echo "Address : ".get_company_prefs()['postal_address']; ?> <br> <br> <?php echo "Contact : ".get_company_prefs()['phone']; ?><h5></div>
                          <!-- <div id="logo" ><h4><h4></div> -->
         
         <?php  }else {  ?>

                <div id="logo" ><?php echo get_company_prefs()['coy_name']; ?></div>
         
         <?php }  ?>

    </header>
    <table class="bill-details">
        <tbody>
            <?php if($gst_no['gst_no']) { ?>
            <tr>
                <td><b>GST Number : <span><?php echo $gst_no['gst_no']; ?></span></b></td>
            </tr>
            <?php } ?>
            
             <tr>
                <td colspan="2">Customer Name : <span><?php echo get_customer_name($invoice['debtor_no']); ?></span></td>
            </tr>
             <tr>
                <td colspan="2">phone # : <span><?php echo $sales_order['contact_phone']; ?></span></td>
            </tr>
            <tr>
                <td>Location : <span><?php echo $sales_order['location_name']; ?></span></td>
            </tr>
            <tr>
                <td>Date : <span><?php echo sql2date($invoice['tran_date']); ?></span></td>
                <td>Invoice # : <span><?php echo $invoice['trans_no']; ?></span></td>
            </tr>
             <tr>
                <td>Invoice Referance # : <span><?php echo $invoice['reference']; ?></span></td>
                <td>Sales Person : <span><?php echo get_salesman_name($invoice["sales_person_id"]); ?></span></td>
            </tr>
            
            <tr>
                <th class="center-align" colspan="2"><span class="receipt">Original Receipt</span></th>
            </tr>
        </tbody>
    </table>
    <table class="items">
        <thead>
            <tr>
                <th class="heading name">Item</th>
                <th class="heading qty">Qty</th>
                <th class="heading rate">Rate</th>
                <th class="heading rate">Disc%</th>
                <th class="heading amount">Amount</th>
            </tr>
        </thead>
       
        <tbody>
            <?php 
            while ($myrow  = db_fetch($invoice_detail)) {
                // display_error($myrow['tot_discount']);
            ?>
            <?php 
            $value = round2(((1 - $myrow["discount_percent"]) * $myrow["unit_price"] * $myrow["quantity"]),
            user_price_dec());
            $sub_total += $value;
            // $display_total += price_format($invoice["ov_freight"]+$invoice["ov_gst"]+$invoice["ov_amount"]+$invoice["ov_freight_tax"]);
            $tax_items = get_trans_tax_details(ST_SALESINVOICE, $_GET["trans_no"]);
            $display_discount = percent_format($myrow["discount_percent"]*100) . "%";
            ?>
            <tr>
                <td><?php echo $myrow['description']; ?></td>
                <td><?php echo $myrow['quantity']; ?></td>
                <td class="price"><?php echo $myrow['unit_price']; ?></td>
                <td class="price"><?php echo $display_discount; ?></td>
                <td class="price"><?php echo  $value; ?></td>
            </tr>
            <?php 
             }


            while ($alloc_row = db_fetch($alloc_result)) {

                if($alloc_row['type']==ST_CUSTCREDIT)
                   {

                    $credit_detail = get_customer_trans_details($alloc_row['type'], $alloc_row['trans_no']);

                    while ($myrow  = db_fetch($credit_detail)) {


                                ?>
                                <?php 
                                $myrow["quantity"]=-$myrow["quantity"];
                                $value = round2(((1 - $myrow["discount_percent"]) * $myrow["unit_price"] * $myrow["quantity"]),
                                user_price_dec());
                                $sub_total += $value;
                                // $display_total = price_format($invoice["ov_freight"]+$invoice["ov_gst"]+$invoice["ov_amount"]+$invoice["ov_freight_tax"]);
                                 $tax_items = get_trans_tax_details($alloc_row['type'], $alloc_row['trans_no']);
                                     $display_discount = percent_format($myrow["discount_percent"]*100) . "%";
                                ?>
                                <tr>
                                <td><?php echo $myrow['description']; ?></td>
                                <td><?php echo $myrow['quantity']; ?></td>
                                <td class="price"><?php echo $myrow['unit_price']; ?></td>
                                 <td class="price"><?php echo $display_discount; ?></td>
                                <td class="price"><?php echo  $value; ?></td>
                                </tr>
                                <?php 
                            }




                   } 





            }




            ?>
            <tr>
                <td colspan="4" class="sum-up line">Subtotal</td>
                <td class="line price"><?php echo $sub_total; ?></td>
            </tr>
           <!--  <tr>
                <td colspan="4" class="sum-up">Tax</td>
                <td class="price"><?php// echo price_format($tax_items); ?></td>
            </tr> -->
             <tr>
                <td colspan="4" class="sum-up">Total Discount</td>
                <td class="price"><?php echo price_format($invoice["tot_discount"]); ?></td>
            </tr>
            
            <?php  $sub_total-=$invoice["tot_discount"]; ?> 
           <!--  <tr>
                <td colspan="4" class="sum-up">CGST</td>
                <td class="price"><?php// echo price_format($invoice["tot_discount"]); ?></td>
            </tr> -->
            <tr>
                <th colspan="4" class="total text">Total</th>
                <th class="total price"><?php echo $sub_total; ?></th>
            </tr>
        </tbody>
    </table>
    <section>
        <?php 
        global $systypes_array;
        $alloc_result = get_allocatable_from_cust_transactions( $invoice['debtor_no'],  $_GET["trans_no"], ST_SALESINVOICE);
        while ($alloc_row = db_fetch($alloc_result)) {
        // echo "<pre>";
        // print_r($alloc_row);
        $receipt = get_customer_trans($alloc_row['trans_no'], $alloc_row['type']);
         ?>
        <p><b>
            Paid by : <span><?php echo  $systypes_array[$alloc_row['type']]." - ".$receipt['bank_account_name'] . "  (". $receipt['ov_amount']. ")";?></span>
        </b></p>
        <?php 
         }
         ?>
        <p style="text-align:center">
            Thank you for your visit!
        </p>
    </section>
    <footer style="text-align:center">
        <p>Digitley System Pvt Ltd</p>
        <a>www.digitleysystem.com</a>
    </footer>

    <script type="text/javascript">window.print();</script>
</body>

</html>